/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.Attribute;
import oracle.AWXML.AttributeProjection;
import oracle.AWXML.BaseObject;
import oracle.AWXML.ExternalSourceExpression;
import oracle.AWXML.Hierarchy;
import oracle.AWXML.Level;
import oracle.AWXML.SourceColumn;

public class AttributeSourceExpression
extends ExternalSourceExpression {
    private Level m_level;
    private Hierarchy m_hierarchy;
    private Attribute m_baseAttribute;
    private String m_language;

    protected AttributeSourceExpression() {
    }

    public AttributeSourceExpression(BaseObject baseObject) {
        super(baseObject);
    }

    public AttributeSourceExpression(BaseObject baseObject, String string) {
        super(baseObject);
        this.m_language = string;
    }

    public void setBaseAttribute(Attribute attribute) {
        if (!this.getNamePart(1, this.getId()).equalsIgnoreCase(this.getNamePart(1, attribute.getId()))) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.getId(), attribute.getId()});
        }
        this.m_baseAttribute = attribute;
    }

    public void setTargetObject(BaseObject baseObject) {
        Object object;
        if (this.m_level != null || this.m_hierarchy != null) {
            if (baseObject instanceof AttributeProjection) {
                object = this.getNamePart(1, baseObject.getId());
                object = this.getNamePart(2, baseObject.getId());
                String string = this.getNamePart(1, this.getId());
                string = this.getNamePart(2, this.getId());
                if (this.m_hierarchy != null && this.m_level != null) {
                    string = this.getNamePart(3, this.getId());
                    object = this.getNamePart(3, baseObject.getId());
                }
                if (!string.equals(object)) {
                    throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.getId(), baseObject.getId()});
                }
            } else {
                throw new AWException("AWXML-ERR-NUM-900001", new Object[]{baseObject.getId(), "AttributeProjection"});
            }
        }
        this.m_targetObject = baseObject;
        if (this.m_targetObject instanceof AttributeProjection) {
            object = (AttributeProjection)this.m_targetObject;
            if (((AttributeProjection)object).getAttribute() != null) {
                this.m_baseAttribute = ((AttributeProjection)object).getAttribute();
            }
        } else {
            this.m_baseAttribute = (Attribute)baseObject;
        }
    }

    public void setLevel(Level level) {
        if (this.m_hierarchy != null && !this.getNamePart(1, this.m_hierarchy.getId()).equalsIgnoreCase(this.getNamePart(1, level.getId()))) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.m_hierarchy.getId(), level.getId()});
        }
        if (!this.getNamePart(1, this.getId()).equalsIgnoreCase(this.getNamePart(1, level.getId()))) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.getId(), level.getId()});
        }
        this.m_level = level;
    }

    public Level getLevel() {
        return this.m_level;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        if (this.m_level != null && !this.getNamePart(1, this.m_level.getId()).equalsIgnoreCase(this.getNamePart(1, hierarchy.getId()))) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.m_level.getId(), hierarchy.getId()});
        }
        if (!this.getNamePart(1, this.getId()).equalsIgnoreCase(this.getNamePart(1, hierarchy.getId()))) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.getId(), hierarchy.getId()});
        }
        this.m_hierarchy = hierarchy;
    }

    public Hierarchy getHierarchy() {
        return this.m_hierarchy;
    }

    public String WriteToXML() {
        String string = null;
        string = AttributeSourceExpression.TAB() + this.WriteElementStart("AttributeSourceExpression");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + AttributeSourceExpression.TAB() + this.WriteElementEndTag("AttributeSourceExpression") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        if (this.m_language != null) {
            string = string + this.WriteAsAttribute("Language", this.m_language);
        }
        return string;
    }

    public String WriteContentsToXML() {
        String string = super.WriteContentsToXML();
        if (this.m_level != null) {
            string = string == null ? this.WriteAsIDRef("Level", this.m_level) : string + this.WriteAsIDRef("Level", this.m_level);
        }
        if (this.m_hierarchy != null) {
            string = string == null ? this.WriteAsIDRef("Hierarchy", this.m_hierarchy) : string + this.WriteAsIDRef("Hierarchy", this.m_hierarchy);
        }
        if (this.m_baseAttribute != null) {
            string = string == null ? this.WriteAsIDRef("BaseAttribute", this.m_baseAttribute) : string + this.WriteAsIDRef("BaseAttribute", this.m_baseAttribute);
        }
        return string;
    }

    public String Alter(AWConnection aWConnection) {
        String string = "Success";
        if (this.m_baseAttribute == null) {
            throw new AWException("AWXML-ERR-NUM-400012", new Object[]{this.getId()});
        }
        String string2 = this.getId();
        string2 = string2.substring(0, string2.lastIndexOf("."));
        string2 = string2.substring(0, string2.lastIndexOf(".")) + ".DIMENSIONMAPGROUP";
        if (this.getTargetObject() != null) {
            Attribute attribute = (Attribute)this.getTargetObject();
            String string3 = this.getId();
            if (attribute instanceof AttributeProjection) {
                string3 = this.m_baseAttribute.getId();
            }
            String string4 = null;
            Iterator iterator = this.getSourceColumns().iterator();
            while (iterator.hasNext()) {
                SourceColumn sourceColumn = (SourceColumn)iterator.next();
                if (string4 == null) {
                    string4 = sourceColumn.getColumn();
                    continue;
                }
                string4 = string4 + "," + sourceColumn.getColumn();
            }
            aWConnection.executeCommand("call set_attribute_expression(" + this.quoteValue(string2) + "," + this.quoteValue(string3) + "," + this.quoteValue(string4) + "," + AWConnection.CommitMode + ")");
            this.m_listResults = aWConnection.getResults();
            this.m_commandResults = this.m_listResults[0];
            this.m_commandResultText = this.m_listResults[1];
            if (new Integer(this.m_commandResults) < 0) {
                throw new AWException("AWXML-ERR-NUM-400010", new Object[]{this.getId(), this.m_commandResultText});
            }
        }
        return string;
    }

    public String Create(AWConnection aWConnection) {
        String string = "Success";
        if (this.m_baseAttribute == null) {
            throw new AWException("AWXML-ERR-NUM-400012", new Object[]{this.getId()});
        }
        String string2 = this.getId();
        string2 = string2.substring(0, string2.lastIndexOf("."));
        string2 = string2.substring(0, string2.lastIndexOf(".")) + ".DIMENSIONMAPGROUP";
        if (this.getTargetObject() != null) {
            Attribute attribute = (Attribute)this.getTargetObject();
            String string3 = this.getTargetObject().getId();
            if (attribute instanceof AttributeProjection) {
                string3 = this.m_baseAttribute.getId();
            }
            String string4 = null;
            Object object = this.getSourceColumns().iterator();
            while (object.hasNext()) {
                SourceColumn sourceColumn = (SourceColumn)object.next();
                if (string4 == null) {
                    string4 = sourceColumn.getColumn();
                    continue;
                }
                string4 = string4 + "," + sourceColumn.getColumn();
            }
            if (AW.getCurAW().getMetaDataFormat() <= 10.1) {
                aWConnection.executeCommand("call set_attribute_expression(" + this.quoteValue(string2) + "," + this.quoteValue(string3) + "," + this.quoteValue(string4) + "," + AWConnection.CommitMode + ")");
            } else {
                object = this.m_language;
                if (this.m_language == null) {
                    object = AW.getCurAW().getDefaultLanguage();
                }
                aWConnection.executeCommand("call set_attribute_expression(" + this.quoteValue(string2) + "," + this.quoteValue(string3) + "," + this.quoteValue(string4) + "," + AWConnection.CommitMode + "," + this.quoteValue((String)object) + ")");
            }
            this.m_listResults = aWConnection.getResults();
            this.m_commandResults = this.m_listResults[0];
            this.m_commandResultText = this.m_listResults[1];
            if (new Integer(this.m_commandResults) < 0) {
                throw new AWException("AWXML-ERR-NUM-400009", new Object[]{this.getId(), this.m_commandResultText});
            }
        }
        return string;
    }

    public String Delete(AWConnection aWConnection) {
        String string = "Success";
        if (this.m_baseAttribute == null) {
            throw new AWException("AWXML-ERR-NUM-400012", new Object[]{this.getId()});
        }
        String string2 = this.getId();
        string2 = string2.substring(0, string2.lastIndexOf("."));
        string2 = string2.substring(0, string2.lastIndexOf(".")) + ".DIMENSIONMAPGROUP";
        if (this.getTargetObject() != null) {
            Attribute attribute = (Attribute)this.getTargetObject();
            String string3 = this.getId();
            if (attribute instanceof AttributeProjection) {
                string3 = this.m_baseAttribute.getId();
            }
            String string4 = AWNULL;
            aWConnection.executeCommand("call set_attribute_expression(" + this.quoteValue(string2) + "," + this.quoteValue(string3) + "," + string4 + "," + AWConnection.CommitMode + ")");
            this.m_listResults = aWConnection.getResults();
            this.m_commandResults = this.m_listResults[0];
            this.m_commandResultText = this.m_listResults[1];
            if (new Integer(this.m_commandResults) < 0) {
                throw new AWException("AWXML-ERR-NUM-400011", new Object[]{this.getId(), this.m_commandResultText});
            }
        }
        return string;
    }

    public String getLanguage() {
        String string = null;
        string = this.m_language != null ? this.m_language : AW.getCurAW().getDefaultLanguage();
        return string;
    }

    public void setLanguage(String string) {
        if (this.m_language != null) {
            throw new AWException("AWXML-ERR-NUM-900011", new Object[]{string});
        }
        this.m_language = string;
    }
}

