/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.commands.CSCommon;
import oracle.dbtools.commands.CommandMessages;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.WalletUtils;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.util.AutoBastionUtil;
import oracle.dbtools.util.BastionHost;
import oracle.dbtools.util.BastionSSHTunnel;
import oracle.dbtools.util.BastionSession;
import oracle.dbtools.util.OpenSSH_PKCS8KeyPairGenerator;
import oracle.jdbc.pool.OracleDataSource;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class OCICommand
extends CommandListener
implements IHelp {
    private static final String OCI_CMD = "oci";
    private static final String OCI_CMDU = "OCI";
    private static final String OCI_CONNECT = "connect-oci";
    private static final String OCI_PROFILE_NAME = "oci.profile.name";
    private static final String OCI_REGION_NAME = "oci.region.name";
    private static final String OCI_SQLCL_CONFIG_FILE = "OCI_SQLCL_CONFIG_FILE";
    private static final String DELETE = "delete";
    private static final String GET = "get";
    private static final String PUT = "put";
    private static final String CLEAR = "clear";
    private static final String NL = "\n";
    private static boolean region_set = false;
    private static ArrayList<String> subsRegions = new ArrayList();
    private static int homeRegionIndex = -1;
    private static boolean r1 = false;

    public String getCommand() {
        return OCI_CMDU;
    }

    public String getHelp() {
        return CommandMessages.getString("OCI_CMD_HELP");
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] parts = cmd.getSql().replace(NL, "").split("\\s+");
        if (parts.length == 2 && OCICommand.matches((String)OCI_CONNECT, (String)cmd.getSql()) && this.validateOCID(parts[1], ctx) || parts.length == 3 && OCICommand.matches((String)OCI_CONNECT, (String)cmd.getSql()) && this.validateOCID(parts[2], ctx)) {
            ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
            if (sqlcl.getConn() != null) {
                this.OCIConnClear(ctx);
            }
            boolean connect = false;
            List<String> partsList = Arrays.asList(parts);
            partsList.stream().map(cmdParts -> cmdParts.toLowerCase());
            String profile = (String)ctx.getProperty(OCI_PROFILE_NAME);
            String region = null;
            if (profile == null) {
                ctx.write("OCI Profile not set. \n \nPlease run: oci profile <profile_name> to set your profile \n \n");
                return true;
            }
            region = !region_set ? this.set_region_home(profile, ctx) : (String)ctx.getProperty(OCI_REGION_NAME);
            if (!connect && (parts.length == 2 || parts.length == 3) && this.validateOCID(parts[1], ctx)) {
                String ocid = parts[1];
                if (!this.isDatabaseToolsConnectionOCID(ocid, ctx)) {
                    return true;
                }
                if (!this.isOCIDRegionMatch(ocid, ctx)) {
                    return true;
                }
                ctx.write(CommandMessages.getString("OCI_RETRIEVING_CONNECTION_DETAILS"));
                try {
                    OCIProfiles p = new OCIProfiles();
                    OCIRESTClient client = p.getOciClient(profile);
                    String oci_url = OCICommand.generateOCIurl(region, ocid);
                    URI root = URI.create(oci_url);
                    OCIRequest req = new OCIRequest.Builder().host(root.getHost()).method(GET).target("/20201005/databaseToolsConnections/" + ocid).build();
                    String baseInfo = client.getString(req);
                    JSON j = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
                    Map map = j.mapFrom((Object)baseInfo);
                    if (this.isUnauthorizedError(map, ctx)) {
                        return true;
                    }
                    String isPE = (String)map.get("privateEndpointId");
                    String username = (String)map.get("userName");
                    String connString = (String)map.get("connectionString");
                    String secretOCID = (String)((Map)map.get("userPassword")).get("secretId");
                    String secret_host = "secrets.vaults." + region + ".oci.oraclecloud.com";
                    req = new OCIRequest.Builder().host(secret_host).method(GET).target("/20190301/secretbundles/" + secretOCID + "?stage=CURRENT").build();
                    Properties props = new Properties();
                    String secretJson = client.getString(req);
                    Map secretMap = j.mapFrom((Object)secretJson);
                    String passwdEncoded = (String)((Map)secretMap.get("secretBundleContent")).get("content");
                    String password = new String(Base64.getDecoder().decode(passwdEncoded.getBytes()));
                    props.put("user", username);
                    props.put("password", password);
                    String autonomousDatabaseID = (String)((Map)map.get("relatedResource")).get("identifier");
                    String walletSecret = "{\"generateType\": \"SINGLE\", \"password\": \"al123@#@#skjfalskjfaslkdfja\"}";
                    String wallet_host = "database." + region + ".oraclecloud.com";
                    req = new OCIRequest.Builder().host(wallet_host).contentType("application/json").body(walletSecret).method("post").target("/20160918/autonomousDatabases/" + autonomousDatabaseID + "/actions/generateWallet/").build();
                    ctx.write(CommandMessages.getString("OCI_RETRIEVING_WALLET"));
                    ctx.getOutputStream().flush();
                    CloseableHttpResponse response = client.getResponse(req);
                    HttpEntity ent = response.getEntity();
                    req = new OCIRequest.Builder().host(wallet_host).method(GET).target("/20160918/autonomousDatabases/" + autonomousDatabaseID).build();
                    String walletInfo = client.getString(req);
                    JSON jWallet = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
                    Map walletMap = jWallet.mapFrom((Object)walletInfo);
                    String dburl = (String)((Map)((ArrayList)((Map)walletMap.get("connectionStrings")).get("profiles")).get(0)).get("displayName");
                    if (response.getCode() == 200) {
                        String walletZip = "wallet1234.zip";
                        Path responsePath = FileUtils.getNewOrExistingPath((ScriptRunnerContext)ctx, (String)walletZip);
                        try (InputStream inputStream = ent.getContent();){
                            Files.copy(inputStream, responsePath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        URI httpsProxy = null;
                        if (parts[1].startsWith("-proxy")) {
                            String proxyValue = null;
                            proxyValue = parts[1].substring(parts[1].indexOf("=") + 1);
                            httpsProxy = WalletUtils.httpsProxy((ScriptRunnerContext)ctx, (String)proxyValue);
                        }
                        WalletUtils.setWallet((ScriptRunnerContext)ctx, (String)walletZip, httpsProxy);
                        ctx.write(CommandMessages.getString("OCI_ESTABLISHING_CONNECTION"));
                        ctx.getOutputStream().flush();
                        if (isPE != null) {
                            try {
                                ctx.write("Creating Bastion for Private Endpoint connection...\n");
                                ctx.getOutputStream().flush();
                                BastionHost bastionHost = new BastionHost(ocid, client, region);
                                String bastionId = bastionHost.getBastionId();
                                Thread.sleep(20000L);
                                OpenSSH_PKCS8KeyPairGenerator opensshKeys = new OpenSSH_PKCS8KeyPairGenerator();
                                String publicKey = opensshKeys.getPublicKey();
                                String privateKeyPath = opensshKeys.getPrivateKeyPath();
                                BastionSession bastionSession = new BastionSession(ocid, client, region, bastionId, publicKey);
                                String bastionSessionId = bastionSession.getBastionSessionId();
                                ctx.write("Creating a session...\n\n");
                                ctx.getOutputStream().flush();
                                Thread.sleep(25000L);
                                ctx.write("Creating SSH tunnel...\n");
                                ctx.getOutputStream().flush();
                                AutoBastionUtil autoBastionUtil = new AutoBastionUtil(ocid, client, region);
                                int databasePort = Integer.parseInt(autoBastionUtil.getDatabasePort());
                                String databaseIP = autoBastionUtil.getDbEndpointIP();
                                BastionSSHTunnel bastionSSHTunnel = new BastionSSHTunnel(privateKeyPath);
                                String bastionHostId = "host.bastion." + region + ".oci.oraclecloud.com";
                                Tunnel sshTunnel = bastionSSHTunnel.openTunnel(ctx, databasePort, databaseIP, bastionHostId, bastionSessionId, 22);
                                String databaseConnString = autoBastionUtil.getDatabaseConnString();
                                dburl = autoBastionUtil.modifyDBurl();
                            }
                            catch (SQLException e) {
                                ctx.write(e.getMessage() + NL);
                                ctx.getOutputStream().flush();
                                return false;
                            }
                        }
                        String url = "jdbc:oracle:thin:@" + dburl;
                        OracleDataSource datasource = WalletUtils.configureDataSource((String)url, (Properties)props, (ScriptRunnerContext)ctx);
                        conn = datasource.getConnection();
                        return this.setConnection(ctx, props, conn);
                    }
                    String url = "jdbc:oracle:thin:@" + connString;
                    Class.forName("oracle.jdbc.OracleDriver");
                    Connection oracleConnection = DriverManager.getConnection(url, props);
                    return this.setConnection(ctx, props, oracleConnection);
                }
                catch (IOException | ClassNotFoundException | GeneralSecurityException | SQLException | ParseException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else if (!connect && parts.length == 3 && partsList.get(1).equalsIgnoreCase("-rest")) {
                String ocid = parts[2];
                if (!this.isDatabaseToolsConnectionOCID(ocid, ctx)) {
                    return true;
                }
                if (!this.validateOCID(ocid, ctx)) {
                    return true;
                }
                if (!this.isOCIDRegionMatch(ocid, ctx)) {
                    return true;
                }
                String config_filepath = null;
                config_filepath = ctx.getProperty(OCI_SQLCL_CONFIG_FILE) != null ? (String)ctx.getProperty(OCI_SQLCL_CONFIG_FILE) : "~/.oci/config";
                Properties props = new Properties();
                props.put("oci_config_filepath", config_filepath);
                props.put("oci_profile", profile);
                props.put("region", region);
                try {
                    Class.forName("oracle.dbtools.jdbc.Driver");
                    Connection restConnection = DriverManager.getConnection(ocid, props);
                    return this.setConnection(ctx, props, restConnection);
                }
                catch (ClassNotFoundException | SQLException e) {
                    ctx.write(e.getMessage());
                }
            } else if (parts.length < 2 || !connect) {
                ctx.write("Connecting with OCI authentication \n \n");
                ctx.write("Usage: \nSQL> conn oci\n\nConnect to OCI with the Thin Driver: conn oci <ocid>    \n\nConnect to OCI with the REST JDBC Driver: conn oci -rest <ocid> \n\n");
                connect = false;
            }
            return connect;
        }
        if (OCICommand.matches((String)OCI_CMD, (String)cmd.getSql())) {
            block92: {
                OCIProfiles p;
                if (parts.length == 2 && parts[1].equalsIgnoreCase(CLEAR)) {
                    ctx.write(CommandMessages.getString("OCI_PROFILE_CLEARED") + NL);
                    ctx.write("Region Cleared\n\n");
                    ctx.removeProperty(OCI_PROFILE_NAME);
                    ctx.removeProperty(OCI_REGION_NAME);
                    subsRegions.clear();
                    this.OCIConnClear(ctx);
                    ctx.write("Connection cleared\n\n");
                    homeRegionIndex = -1;
                    Map csProps = (Map)ctx.getProperty("cloud.storage");
                    if (csProps != null) {
                        csProps.remove(OCI_PROFILE_NAME);
                    }
                    return true;
                }
                if (parts.length > 1 && parts[1].equalsIgnoreCase("compartments")) {
                    String profile = (String)ctx.getProperty(OCI_PROFILE_NAME);
                    String region = (String)ctx.getProperty(OCI_REGION_NAME);
                    if (profile == null) {
                        ctx.write("OCI Profile not set. \n \nPlease run: oci profile <profile_name> to set your profile \n \n");
                    } else if (region == null) {
                        this.set_region_home(profile, ctx);
                    } else if (parts.length == 3 && parts[2].equalsIgnoreCase("list")) {
                        try {
                            this.compartments(profile, ctx);
                        }
                        catch (IOException | GeneralSecurityException | ParseException e) {
                            ctx.write(e.getLocalizedMessage() + NL);
                            return true;
                        }
                    }
                    return true;
                }
                if (parts.length > 1 && parts[1].equalsIgnoreCase("region")) {
                    String profile = (String)ctx.getProperty(OCI_PROFILE_NAME);
                    if (profile == null) {
                        ctx.write("OCI Profile not set. \n \nPlease run: oci profile <profile_name> to set your profile \n \n");
                    } else {
                        if (parts.length != 3 && !region_set) {
                            this.set_region_home(profile, ctx);
                            return true;
                        }
                        if (parts.length == 3) {
                            if (parts[2].equalsIgnoreCase("list")) {
                                for (int i = 0; i < subsRegions.size(); ++i) {
                                    if (i == homeRegionIndex) {
                                        ctx.write(subsRegions.get(i) + "\t(HOME REGION)\n");
                                        continue;
                                    }
                                    ctx.write(subsRegions.get(i) + NL);
                                }
                                return true;
                            }
                            if (subsRegions.contains(parts[2])) {
                                ctx.putProperty(OCI_REGION_NAME, (Object)parts[2]);
                                region_set = true;
                                ctx.write("Set OCI Region: " + parts[2] + "\n\n");
                                return true;
                            }
                            ctx.write(parts[2] + " is not in the list of subscribed regions for this tenancy\n\n");
                            return true;
                        }
                        ctx.write("Region is set to: " + ctx.getProperty(OCI_REGION_NAME) + NL);
                        return true;
                    }
                }
                if (parts.length > 1 && parts[1].equalsIgnoreCase("profile") && parts.length != 3 && parts.length != 4) {
                    try {
                        p = new OCIProfiles();
                        ctx.write(CommandMessages.getString("OCI_PROFILES"));
                        for (String profile : p.getProfiles()) {
                            ctx.write("\t" + profile + NL);
                        }
                    }
                    catch (IOException e) {
                        ctx.write(e.getLocalizedMessage() + NL);
                    }
                    return true;
                }
                if ((parts.length == 3 || parts.length == 4) && parts[1].equalsIgnoreCase("profile")) {
                    if (parts[2].contains("r1")) {
                        r1 = true;
                    }
                    if (parts.length == 4) {
                        ctx.removeProperty(OCI_PROFILE_NAME);
                        ctx.removeProperty(OCI_REGION_NAME);
                        ctx.putProperty(OCI_SQLCL_CONFIG_FILE, (Object)parts[3]);
                        System.setProperty(OCI_SQLCL_CONFIG_FILE, parts[3]);
                    }
                    try {
                        p = new OCIProfiles();
                        if (p.getProfiles().contains(parts[2])) {
                            ctx.removeProperty(OCI_REGION_NAME);
                            ctx.putProperty(OCI_PROFILE_NAME, (Object)parts[2]);
                            HashMap csProps = (HashMap)ctx.getProperty("cloud.storage");
                            if (csProps == null) {
                                csProps = new HashMap();
                                ctx.putProperty("cloud.storage", csProps);
                            }
                            this.set_region_home(parts[2], ctx);
                            this.regionSubscriptions(parts[2], ctx);
                            CSCommon.setProfileAndWarn(ctx, parts[2], true);
                        } else {
                            ctx.write(CommandMessages.getString("OCI_PROFILE_INVALID"));
                        }
                    }
                    catch (IOException | IllegalArgumentException | GeneralSecurityException | ParseException e) {
                        ctx.write(CommandMessages.getString("OCI_PEMFILE_INVALID"));
                        return true;
                    }
                    return true;
                }
                if (ctx.getProperty(OCI_PROFILE_NAME) != null && parts.length > 1 && parts.length < 6) {
                    String host = null;
                    String method = null;
                    String bodyFile = null;
                    String qualifier = null;
                    String target = null;
                    try {
                        String ct;
                        if (parts[1].equalsIgnoreCase(DELETE) || parts[1].equalsIgnoreCase(GET) || parts[1].equalsIgnoreCase(PUT)) {
                            method = parts[1].toLowerCase();
                            Map props = (Map)ctx.getProperty("cloud.storage");
                            if (props == null || (CloudStorageUrl)props.get("cloud_url") == null) {
                                return true;
                            }
                            if (!method.equals(PUT) && parts.length == 3) {
                                qualifier = parts[2];
                            } else if (method.equals(PUT) && parts.length == 3) {
                                bodyFile = parts[2];
                            } else if (method.equals(PUT) && parts.length == 4) {
                                bodyFile = parts[2];
                                qualifier = parts[3];
                            }
                            CloudStorageUrl csUrl = new CloudStorageUrl(((CloudStorageUrl)props.get("cloud_url")).getFinalUrl());
                            if (qualifier != null) {
                                csUrl.qualifiedUrl(qualifier);
                            }
                            URL url = csUrl.getFinalUrlAsOCI();
                            if (method.equalsIgnoreCase(DELETE) || method.equalsIgnoreCase(GET) || method.equalsIgnoreCase(PUT)) {
                                csUrl.validateUrlAsObject();
                            }
                            host = url.getHost();
                            target = url.getPath();
                            csUrl.dropQualifiedUrl();
                        } else if (parts.length == 4) {
                            host = parts[1];
                            method = parts[2];
                            target = parts[3];
                        } else if (parts.length == 5) {
                            host = parts[1];
                            method = parts[2];
                            bodyFile = parts[3];
                            target = parts[4];
                        } else {
                            ctx.write(CommandMessages.getString("OCI_CMD_HELP") + NL);
                            return true;
                        }
                        OCIProfiles p2 = new OCIProfiles();
                        OCIRESTClient client = p2.getOciClient((String)ctx.getProperty(OCI_PROFILE_NAME));
                        OCIRequest req = null;
                        if (bodyFile == null) {
                            req = new OCIRequest.Builder().host(host).method(method).target(target).build();
                        } else if (bodyFile != null && !bodyFile.isEmpty()) {
                            File srcFile = new File(bodyFile = ctx.prependCD(bodyFile));
                            if (!srcFile.isFile()) {
                                throw new IOException(bodyFile + " is not a file");
                            }
                            req = new OCIRequest.Builder().host(host).method(method).bodyFile(new File(bodyFile)).target(target).build();
                        }
                        CloseableHttpResponse response = client.getResponse(req);
                        ctx.write("Status:" + response.getCode() + " " + response.getReasonPhrase() + NL);
                        HttpEntity ent = response.getEntity();
                        String string = ct = ent != null && ent.getContentType() != null ? ent.getContentType() : "application/octect";
                        if (ct.equals("application/json")) {
                            String ret = response != null && response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8") : "";
                            ctx.write(ret + NL);
                            break block92;
                        }
                        if (ent == null || ent.getContentLength() == 0L) break block92;
                        String responseFileName = req.getFinalPath() == null || req.getFinalPath().trim().equals("") ? "response.oci" : req.getFinalPath();
                        Path responsePath = FileUtils.getNewOrExistingPath((ScriptRunnerContext)ctx, (String)responseFileName);
                        ctx.write(CommandMessages.format("OCI_FILE_SAVED", responsePath.toAbsolutePath()));
                        try (InputStream inputStream = ent.getContent();){
                            Files.copy(inputStream, responsePath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException | GeneralSecurityException | ParseException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                } else {
                    ctx.write(CommandMessages.getString("OCI_CMD_HELP") + NL);
                }
            }
            return true;
        }
        return false;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    private boolean setConnection(ScriptRunnerContext ctx, Properties props, Connection conn) throws SQLException {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        if (conn != null) {
            sqlcl.setConn(conn);
            try {
                ConnectionDetails cdFinal = new ConnectionDetails(conn.getMetaData().getURL());
                cdFinal.setConn(conn);
                ConnectionStoreBridge connResolver = (ConnectionStoreBridge)sqlcl.getScriptRunnerContext().getProperty("cli.conn.resolver");
                connResolver.addConnection(cdFinal);
                sqlcl.getScriptRunnerContext().putProperty("cli.conn.name", (Object)cdFinal.getUrl());
            }
            catch (Exception exception) {
                // empty catch block
            }
            sqlcl.getScriptRunnerContext().setCurrentConnection(conn);
            sqlcl.getScriptRunnerContext().setBaseConnection(conn);
            sqlcl.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", (Object)Boolean.FALSE);
            ctx.putProperty("cli.conn.props", (Object)props);
            ctx.write("Connected.\n\n");
            return true;
        }
        ctx.write("Connection to OCI Failed. \n\n");
        return true;
    }

    private String set_region_home(String profile, ScriptRunnerContext ctx) {
        OCIProfiles profiles = new OCIProfiles();
        String region = null;
        try {
            Properties pProps = profiles.getProperties();
            region = pProps.getProperty(profile + "/region");
            ctx.putProperty(OCI_REGION_NAME, (Object)region);
            ctx.write("Region set to: " + region + NL);
            region_set = true;
        }
        catch (IOException e) {
            ctx.write(e.getLocalizedMessage() + NL);
        }
        return region;
    }

    private boolean isUnauthorizedError(Map<String, Object> map, ScriptRunnerContext ctx) {
        if (map.containsKey("code")) {
            if (((String)map.get("code")).equalsIgnoreCase("NotAuthorizedOrNotFound")) {
                ctx.write((String)map.get("message") + NL);
                ctx.write("Invalid OCID provided. Please check the OCID provided, and try again.\n");
            }
            return true;
        }
        return false;
    }

    private boolean isOCIDRegionMatch(String ocid, ScriptRunnerContext ctx) {
        String[] parts = ocid.replace(NL, "").split("\\.");
        String ocid_region = parts[3];
        String set_region = (String)ctx.getProperty(OCI_REGION_NAME);
        if (ocid_region.equals("phx") && set_region.equals("us-phoenix-1")) {
            return true;
        }
        if (!ctx.getProperty(OCI_REGION_NAME).equals(ocid_region)) {
            ctx.write("OCID region does not match set region. \n");
            ctx.write("OCID region: " + ocid_region + NL);
            ctx.write("Set region: " + ctx.getProperty(OCI_REGION_NAME) + NL);
            return false;
        }
        return true;
    }

    private boolean isDatabaseToolsConnectionOCID(String ocid, ScriptRunnerContext ctx) {
        if (ocid.contains(":") && ocid.substring(0, 4).equalsIgnoreCase("ocid")) {
            ctx.write("Incorrect OCID provided.\n");
            ctx.write("Expected: A databasetoolsconnection OCID.\n");
            return false;
        }
        String[] parts = ocid.replace(NL, "").split("\\.");
        if (!parts[1].equalsIgnoreCase("databasetoolsconnection")) {
            try {
                throw new SQLException("Incorrect OCID provided.\nExpected: A databasetoolsconnection OCID.\nProvided: A " + parts[1] + " OCID\n");
            }
            catch (SQLException e) {
                ctx.write(e.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean validateOCID(String ocid, ScriptRunnerContext ctx) {
        String[] parts = ocid.replace(NL, "").split("\\.");
        return parts[0].contains("ocid");
    }

    private Iterator<JrsValue> callOCIEndpoint(String profile, String path, ScriptRunnerContext ctx) throws IOException, GeneralSecurityException, ParseException, IllegalArgumentException {
        OCIProfiles p = new OCIProfiles();
        Iterator elements = null;
        OCIRESTClient client = p.getOciClient(profile);
        Object host = null;
        host = r1 ? "identity.r1.oracleiaas.com" : "identity." + ctx.getProperty(OCI_REGION_NAME) + ".oraclecloud.com";
        OCIRequest request = new OCIRequest.Builder().host((String)host).method(GET).target(path).contentType("application/json").build();
        CloseableHttpResponse response = client.getResponse(request);
        HttpEntity entity = response.getEntity();
        String entityStr = EntityUtils.toString((HttpEntity)entity);
        JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
        JrsArray array = (JrsArray)json.treeFrom((Object)entityStr);
        elements = array.elements();
        return elements;
    }

    private void compartments(String profile, ScriptRunnerContext ctx) throws ParseException, GeneralSecurityException, IOException {
        String tenancyID = null;
        OCIProfiles p = new OCIProfiles();
        Properties profiles = p.getProperties();
        tenancyID = profiles.getProperty(profile + "/tenancy");
        String path = "/20160918/compartments/?compartmentId=" + tenancyID;
        Iterator<JrsValue> elements = this.callOCIEndpoint(profile, path, ctx);
        while (elements.hasNext()) {
            JrsValue element = elements.next();
            String compartmentName = element.get("name").asText();
            ctx.write(compartmentName + NL);
        }
    }

    private void regionSubscriptions(String profile, ScriptRunnerContext ctx) throws ParseException, GeneralSecurityException, IOException {
        OCIProfiles p = new OCIProfiles();
        String tenancyID = null;
        subsRegions.clear();
        Properties profiles = p.getProperties();
        tenancyID = profiles.getProperty(profile + "/tenancy");
        String path = "/20160918/tenancies/" + tenancyID + "/regionSubscriptions";
        int i = 0;
        Iterator<JrsValue> elements = this.callOCIEndpoint(profile, path, ctx);
        if (r1) {
            subsRegions.add("r1.oci.oracleiaas.com");
            ++i;
        }
        while (elements.hasNext()) {
            JrsValue element = elements.next();
            String region = element.get("regionName").asText();
            if (((JrsBoolean)element.get("isHomeRegion")).booleanValue()) {
                homeRegionIndex = i;
            }
            subsRegions.add(region);
            ++i;
        }
    }

    private void OCIConnClear(ScriptRunnerContext ctx) {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        sqlcl.setConn(null);
        ctx.setCurrentConnection(null);
        ctx.setBaseConnection(null);
        ctx.putProperty("script.runner.sqlplus.nolog", (Object)Boolean.TRUE);
        ctx.putProperty("cli.conn.props", null);
    }

    private static String generateOCIurl(String region, String ocid) {
        if (!((String)ocid).endsWith("/")) {
            ocid = (String)ocid + "/";
        }
        Object url = "https://";
        if (region.contains("r1")) {
            url = (String)url + "test-04.";
        }
        if (!region.contains("r1")) {
            url = (String)url + "dbtools.";
        }
        url = region.contains(".") ? (String)url + region + "/20201005/ords/" + (String)ocid : (String)url + region + ".oci.oraclecloud.com/20201005/ords/" + (String)ocid;
        return url;
    }
}

