/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.util.BastionSSHClientImpl;

public class BastionSSHTunnel {
    private URL privateKeyURL = null;
    private static String OCIBASTIONSSHTUNNEL = "oci.bastion.sshtunnel";

    public BastionSSHTunnel(String privateKeyPath) throws MalformedURLException {
        File file = new File(privateKeyPath);
        this.privateKeyURL = file.toURL();
    }

    public Tunnel openTunnel(ScriptRunnerContext ctx, int databasePort, String databaseIP, String bastionHost, String user, int sshPort) throws IOException {
        if (ctx.getProperty(OCIBASTIONSSHTUNNEL) == null) {
            Client.setImplementationClass(BastionSSHClientImpl.class);
            ctx.putProperty(OCIBASTIONSSHTUNNEL, (Object)true);
        }
        Client sshclient = Client.getInstance();
        HostDescriptor.Builder hostDescBuild = new HostDescriptor.Builder("hostDescBuilder").hostname(bastionHost).username(user).port(sshPort).keyfile(this.privateKeyURL);
        HostDescriptor hostDesc = hostDescBuild.getDescriptor();
        TunnelDescriptor.Builder tunnelDescBuild = new TunnelDescriptor.Builder("bastionTunnelDescBuilder", TunnelDescriptor.Type.LOCAL);
        tunnelDescBuild.port(databasePort).host(databaseIP).hostPort(databasePort);
        TunnelDescriptor tunnelDescriptor = tunnelDescBuild.getDescriptor();
        tunnelDescriptor.setHost(hostDesc);
        return sshclient.openTunnel(tunnelDescriptor);
    }

    public String modifyDBurl(String url, String bastionId) {
        String newUrl = url.replace("host=" + bastionId, "host=localhost");
        return newUrl;
    }
}

