/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.Map;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.util.AutoBastionUtil;
import org.apache.hc.core5.http.ParseException;

public class CreateBastion {
    private static String connOCID = null;
    private static String bastionReqBody = null;
    private static String bastionReqResponse = null;

    public CreateBastion(String connOCID, OCIRESTClient client, String region) throws IOException, GeneralSecurityException, ParseException {
        CreateBastion.connOCID = connOCID;
        AutoBastionUtil autoBastionUtil = new AutoBastionUtil(connOCID, client, region);
        String compartmentId = autoBastionUtil.getCompartmentId();
        String subnetId = autoBastionUtil.getSubnetOCID();
        this.createBastionRequestBody(compartmentId, subnetId);
        bastionReqResponse = this.createBastion(client);
    }

    private void createBastionRequestBody(String compartmentId, String subnetId) throws IOException {
        JsonFactory f = new JsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator g = f.createGenerator((Writer)writer);
        g.writeStartObject();
        g.writeStringField("bastionType", "STANDARD");
        g.writeArrayFieldStart("clientCidrBlockAllowList");
        g.writeString("0.0.0.0/0");
        g.writeEndArray();
        g.writeStringField("compartmentId", compartmentId);
        g.writeStringField("name", "BastionSqlcl");
        g.writeStringField("targetSubnetId", subnetId);
        g.writeEndObject();
        g.close();
        bastionReqBody = ((Object)writer).toString();
    }

    private String createBastion(OCIRESTClient client) throws GeneralSecurityException, IOException, ParseException {
        String bastionHost = "bastion.us-phoenix-1.oci.oraclecloud.com";
        OCIRequest req = new OCIRequest.Builder().host(bastionHost).body(bastionReqBody).method("post").contentType("application/json").target("/20210331/bastions").build();
        return client.getString(req);
    }

    public String getCreateBastionReqResponse() {
        return bastionReqResponse;
    }

    public String getBastionId() throws IOException {
        JSON j = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
        Map map = j.mapFrom((Object)bastionReqResponse);
        return (String)map.get("id");
    }
}

