/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.saveactions;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ideimpl.ceditor.saveactions.SaveActionDescription;
import oracle.ideimpl.ceditor.saveactions.SaveActionsShapingHook;
import oracle.javatools.data.HashStructure;

public class SaveActionsHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/ceditor-saveactions", "ceditor-saveactions-hook");
    private static HashStructureHook hashStructureHook;
    private static Set<String> _emittedErrors;
    private static Map<String, SaveActionDescription> saveActions;

    private static synchronized void primeHook() {
        if (hashStructureHook == null) {
            hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
            if (hashStructureHook == null) {
                return;
            }
            hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    SaveActionsHook.getItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    SaveActionsHook.getItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
    }

    public static synchronized Map<String, SaveActionDescription> getSaveActions() {
        SaveActionsHook.primeHook();
        return saveActions != null ? new LinkedHashMap<String, SaveActionDescription>(saveActions) : Collections.emptyMap();
    }

    private static synchronized void getItemsFromHook(HashStructure hashStructure) {
        List saveActionDefinitions;
        if (saveActions == null) {
            saveActions = new LinkedHashMap<String, SaveActionDescription>();
        }
        if ((saveActionDefinitions = hashStructure.getAsList("save-action")) != null && saveActionDefinitions.size() != 0) {
            Map<String, SaveActionsShapingHook.SaveActionShaper> shapers = SaveActionsShapingHook.getActionShapers();
            for (Object definition : saveActionDefinitions) {
                HashStructure hash = (HashStructure)definition;
                String id = hash.getString("id");
                String extensionId = HashStructureHook.getExtensionId((HashStructure)hash);
                if (id == null || id.trim().length() == 0) {
                    SaveActionsHook.logError("Missing id attribute in save-action definition", extensionId);
                    continue;
                }
                if (!saveActions.containsKey(id = id.trim())) {
                    SaveActionDescription action = new SaveActionDescription(extensionId, hash);
                    SaveActionsShapingHook.SaveActionShaper shaper = shapers.get(id);
                    if (shaper != null) {
                        action.setExecuteByDefault(shaper.executeByDefault());
                    }
                    saveActions.put(id, action);
                    continue;
                }
                SaveActionsHook.logDuplicateSaveActionError(id, extensionId);
            }
        }
    }

    private static void logDuplicateSaveActionError(String id, String extensionId) {
        SaveActionsHook.logError("Duplicate save action registration for: " + id, extensionId);
    }

    static synchronized void logError(String msg, String extensionId) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (_emittedErrors == null) {
            _emittedErrors = new HashSet<String>();
        }
        if (!_emittedErrors.contains(buf.toString())) {
            _emittedErrors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    static synchronized void registerSaveAction(String id, SaveActionDescription desc) {
        if (saveActions == null) {
            saveActions = new LinkedHashMap<String, SaveActionDescription>();
        }
        saveActions.put(id, desc);
    }
}

