/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.parser.sparql.SparqlSelectDescriptor;

public class AskSPARQLTreeNode
extends AbstractSPARQLTreeNode
implements SPARQLTreeNode {
    private static final String ASK_VAR = "ASK";
    private SparqlSelectDescriptor selDesc;
    private boolean rdfTermsOnly = false;
    private boolean plusRDFTerms = false;

    public AskSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2, boolean bl, boolean bl2, SparqlSelectDescriptor sparqlSelectDescriptor) {
        super(n, sQLGenContext, n2);
        this.selDesc = sparqlSelectDescriptor;
        this.rdfTermsOnly = bl;
        this.plusRDFTerms = bl2;
    }

    @Override
    public boolean containsEmptyBGP() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (!sPARQLTreeNode.containsEmptyBGP()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setProjections() throws RDFException {
        if (this.getNumChildren() == 1) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(0);
            sPARQLTreeNode.setProjections();
        } else if (this.getNumChildren() > 1) {
            throw new RDFException("Invalid number of children under AskSPARQLTreeNode");
        }
    }

    @Override
    public String toSQL() throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "";
        String string2 = "";
        String string3 = "V0";
        if (this.plusRDFTerms || this.rdfTermsOnly) {
            string2 = "FROM (SELECT R.ASK AS ASK, NULL AS ASK" + this.vid_alias + ", R." + ASK_VAR + " AS " + ASK_VAR + this.prefix_alias + ", NULL AS " + ASK_VAR + this.suffix_alias + ", 'LIT' AS " + ASK_VAR + this.vtype_alias + ", TO_CLOB(NULL) AS " + ASK_VAR + this.longLit_alias + ", '" + "http://www.w3.org/2001/XMLSchema#boolean" + "' AS " + ASK_VAR + this.litType_alias + ", NULL AS " + ASK_VAR + this.langType_alias + "\n";
            string3 = "R)V0";
        }
        if (this.getNumChildren() == 1) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(0);
            sPARQLTreeNode.setLimit(1);
            string = sPARQLTreeNode.toSQL();
            String string4 = this.buildWithForBind();
            stringBuffer.append(string4);
            stringBuffer.append("SELECT").append(" ");
            stringBuffer.append(this.buildFinalSelect()).append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("FROM (SELECT (CASE WHEN (EXISTS ");
            stringBuffer.append("(").append(string).append(" ").append(")\n");
            stringBuffer.append(") THEN 'true' ELSE 'false' END) \"ASK\" FROM DUAL)").append(string3);
            stringBuffer.append(" WHERE (1=1)");
        } else if (this.getNumChildren() == 0) {
            stringBuffer.append("SELECT").append(" ");
            stringBuffer.append(this.buildFinalSelect()).append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("FROM (SELECT (CASE WHEN (1=1) THEN 'true' END) \"ASK\" FROM DUAL)");
            stringBuffer.append(string3).append(" WHERE (1=1)");
        } else {
            throw new RDFException("Syntax Tree Error: ASTSelectQuery with more than one child");
        }
        return stringBuffer.toString();
    }

    private String buildFinalSelect() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.rdfTermsOnly) {
            stringBuffer.append("V0.ASK AS ASK, NULL AS ASK" + this.vid_alias + ", V0." + ASK_VAR + " AS " + ASK_VAR + this.prefix_alias + ", NULL AS " + ASK_VAR + this.suffix_alias + ", 'LIT' AS " + ASK_VAR + this.vtype_alias + ", TO_CLOB(NULL) AS " + ASK_VAR + this.longLit_alias + ", '" + "http://www.w3.org/2001/XMLSchema#boolean" + "' AS " + ASK_VAR + this.litType_alias + ", NULL AS " + ASK_VAR + this.langType_alias);
        } else {
            stringBuffer.append("NULL AS ask$RDFVID");
        }
        if (this.plusRDFTerms || this.rdfTermsOnly) {
            boolean bl = true;
            if (this.ctx.vcTerms) {
                bl = false;
            }
            stringBuffer.append(",\n");
            stringBuffer.append(this.composeRDFTForVar("V0", ASK_VAR, null, bl, false, false, true));
            stringBuffer.append(" AS ASK" + this.term_alias);
        }
        String string = "1";
        stringBuffer.append(",\n");
        stringBuffer.append(string).append(" AS SEM$ROWNUM");
        return stringBuffer.toString();
    }
}

