/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTTopLevelQueryNode;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.SparqlSolnModDesc;

public class BindingsRewriteOptimizer
implements SparqlQueryOptimizer {
    private static final int MAX_ITERS = 10000;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        Node node2 = node;
        boolean bl = true;
        int n = 0;
        if (OptimizerUtils.containsNodeType(node2, 12) && (OptimizerUtils.containsNodeType(node2, 23) || OptimizerUtils.containsNodeType(node2, 13))) {
            this.nestValuesClause(node2);
        }
        while (bl && n < 10000) {
            bl = this.removeSingleBindings(node2);
            ++n;
        }
        if (n >= 10000) {
            throw new ParseException("BindingsRewriteOptimizer: entered infinite loop when optimizing query tree");
        }
        return node2;
    }

    private void nestValuesClause(Node node) throws RDFException, ParseException {
        int n;
        SimpleNode simpleNode = (SimpleNode)node.jjtGetChild(0);
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
        ASTTopLevelQueryNode aSTTopLevelQueryNode = null;
        try {
            aSTTopLevelQueryNode = (ASTTopLevelQueryNode)((Object)simpleNode2);
        }
        catch (Exception exception) {
            throw new RDFException("Unexpected node type found under FullSparqlQuery");
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(simpleNode.jjtGetNumChildren() + aSTTopLevelQueryNode.jjtGetNumChildren());
        for (n = 0; n < aSTTopLevelQueryNode.jjtGetNumChildren(); ++n) {
            arrayList.add(aSTTopLevelQueryNode.jjtGetChild(n));
        }
        for (n = 1; n < simpleNode.jjtGetNumChildren(); ++n) {
            arrayList.add(simpleNode.jjtGetChild(n));
        }
        aSTTopLevelQueryNode.jjtSetInitCapacity(1);
        simpleNode.jjtSetInitCapacity(1);
        simpleNode.jjtAddChild(aSTTopLevelQueryNode, 0);
        ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        aSTGroupGraphPattern.jjtSetParent(aSTTopLevelQueryNode);
        aSTTopLevelQueryNode.jjtAddChild(aSTGroupGraphPattern, 0);
        List<Node> list = Collections.emptyList();
        Set<String> set = null;
        if (aSTTopLevelQueryNode.getsolnMod().hasGroupBy()) {
            set = aSTTopLevelQueryNode.getsolnMod().getGroupByVars();
        }
        ASTSelectQuery aSTSelectQuery = OptimizerUtils.genSelectQuery(arrayList, list, false, set);
        aSTSelectQuery.jjtSetParent(aSTGroupGraphPattern);
        aSTGroupGraphPattern.jjtAddChild(aSTSelectQuery, 0);
        aSTSelectQuery.setsolnMod(aSTTopLevelQueryNode.getsolnMod());
        aSTTopLevelQueryNode.setsolnMod(new SparqlSolnModDesc());
    }

    private boolean removeSingleBindings(Node node) throws ParseException {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(node);
        boolean bl = false;
        while (!linkedList.isEmpty() && !bl) {
            SimpleNode simpleNode = (SimpleNode)linkedList.remove();
            if (simpleNode.id == 5 || simpleNode.id == 7) {
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(simpleNode.jjtGetNumChildren() - 1);
                if (simpleNode2.id == 23) {
                    SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(0);
                    if (simpleNode3.id != 25) {
                        throw new ParseException("BindingsRewriteOptimizer: unexpected node type found under JJTValuesClause");
                    }
                    bl = true;
                    int[] nArray = new int[1];
                    ASTSelectQuery aSTSelectQuery = this.extractSelectQ(simpleNode, nArray);
                    this.removeBindings(simpleNode, aSTSelectQuery, nArray[0], simpleNode3);
                }
            }
            if (bl) continue;
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                linkedList.offer(simpleNode.jjtGetChild(i));
            }
        }
        return bl;
    }

    private ASTSelectQuery extractSelectQ(SimpleNode simpleNode, int[] nArray) {
        if (simpleNode.id == 7) {
            return (ASTSelectQuery)simpleNode;
        }
        SimpleNode simpleNode2 = null;
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2.id != 7) continue;
            nArray[0] = i;
            return (ASTSelectQuery)simpleNode2;
        }
        return null;
    }

    private void removeBindings(Node node, ASTSelectQuery aSTSelectQuery, int n, Node node2) throws ParseException {
        if (aSTSelectQuery.getselDesc().containsAggregate()) {
            SimpleNode simpleNode = (SimpleNode)node;
            if (((SimpleNode)node).id == 7) {
                simpleNode = (SimpleNode)node.jjtGetParent();
            }
            ASTGraphPatternNotTriples aSTGraphPatternNotTriples = OptimizerUtils.nestDataBlock(node2);
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.add(aSTGraphPatternNotTriples);
            ASTSelectQuery aSTSelectQuery2 = OptimizerUtils.genWrapperSelect(aSTSelectQuery, arrayList);
            simpleNode.jjtAddChild(aSTSelectQuery2, n);
            aSTSelectQuery2.jjtSetParent(simpleNode);
        } else {
            boolean bl = false;
            for (int i = 0; i < aSTSelectQuery.jjtGetNumChildren() && !bl; ++i) {
                SimpleNode simpleNode = (SimpleNode)aSTSelectQuery.jjtGetChild(i);
                if (simpleNode.id != 48) continue;
                ASTGroupGraphPattern aSTGroupGraphPattern = (ASTGroupGraphPattern)simpleNode;
                ASTGroupGraphPattern aSTGroupGraphPattern2 = (ASTGroupGraphPattern)aSTGroupGraphPattern.cloneSubTree();
                ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
                aSTGraphPatternNotTriples.jjtAddChild(aSTGroupGraphPattern2, 0);
                aSTGroupGraphPattern2.jjtSetParent(aSTGraphPatternNotTriples);
                ASTGraphPatternNotTriples aSTGraphPatternNotTriples2 = OptimizerUtils.nestDataBlock(node2);
                aSTGroupGraphPattern.jjtSetInitCapacity(2);
                aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples, 0);
                aSTGraphPatternNotTriples.jjtSetParent(aSTGroupGraphPattern);
                aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples2, 1);
                aSTGraphPatternNotTriples2.jjtSetParent(aSTGroupGraphPattern);
                bl = true;
            }
        }
        if (((SimpleNode)node.jjtGetChild((int)(node.jjtGetNumChildren() - 1))).id != 23) {
            throw new ParseException("BindingsRewriteOptimizer: Trailing JJTBindingsClause not found under parent");
        }
        node.jjtRemoveChild(node.jjtGetNumChildren() - 1);
    }
}

