/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.TemplateSPARQLTreeNode;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class ConstructSPARQLTreeNode
extends AbstractSPARQLTreeNode
implements TemplateSPARQLTreeNode {
    private static final int TOTAL_RET_COLS = 40;
    private static final int CUT_TOTAL_RET_COLS = 12;
    private static final int MAX_NUMB_COLS = 1000;
    private static final int COLS_PER_VAR = 10;
    private static final int ID_COL_IDX = 1;
    private static final int CLOB_COL_IDX = 5;
    private static final int TOTAL_CLOB_COLS = 8;
    private static final int CUT_TOTAL_CLOB_COLS = 4;
    private static final String MASK_COL_FLAG = "-1";
    private static final String MASK_PROJ_FLAG = "-1-1";
    private List<QuadBGP> bgpList;
    private boolean newBGPonTB = true;
    private int currBGPIdx = -1;
    private List<Quad> tbList;
    private boolean rdfTermsOnly = false;
    private boolean plusRDFTerms = false;
    private String bindingsSQL = null;
    private boolean subjProjected = false;
    private boolean predProjected = false;
    private boolean objProjected = false;
    private boolean graphProjected = false;
    Set<String> subjVars = null;
    Set<String> predVars = null;
    Set<String> objVars = null;
    Set<String> graphVars = null;

    public ConstructSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2, boolean bl, boolean bl2, String string) {
        super(n, sQLGenContext, n2);
        this.rdfTermsOnly = bl;
        this.plusRDFTerms = bl2;
        this.bgpList = new ArrayList<QuadBGP>();
        this.newBGPonTB = true;
        this.currBGPIdx = -1;
        this.tbList = null;
        this.bindingsSQL = string;
        this.subjProjected = false;
        this.predProjected = false;
        this.objProjected = false;
        this.graphProjected = false;
        this.subjVars = new HashSet<String>();
        this.predVars = new HashSet<String>();
        this.objVars = new HashSet<String>();
        this.graphVars = new HashSet<String>();
    }

    @Override
    public void openBGP() {
        this.newBGPonTB = true;
    }

    @Override
    public void closeBGP() {
        this.newBGPonTB = true;
        this.setActiveGraph(null);
    }

    @Override
    public boolean containsEmptyBGP() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (!sPARQLTreeNode.containsEmptyBGP()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setProjections() throws RDFException {
        SPARQLTreeNode sPARQLTreeNode;
        if (this.getNumChildren() == 1) {
            Iterator<String> iterator;
            Object object;
            sPARQLTreeNode = this.getChild(0);
            HashSet<String> hashSet = new HashSet<String>();
            List<Quad> list = this.getTBList();
            for (Quad quad : list) {
                TriplesBlock triplesBlock = quad.triple;
                TriplesBlock.Element element = triplesBlock.getSubject();
                if (element.isVariable()) {
                    hashSet.add(element.getName());
                    this.subjVars.add(element.getName());
                } else if (!this.ctx.constructNoConstProj) {
                    this.subjProjected = true;
                }
                object = triplesBlock.getPredicate();
                if (((TriplesBlock.Element)object).isVariable()) {
                    hashSet.add(((TriplesBlock.Element)object).getName());
                    this.predVars.add(((TriplesBlock.Element)object).getName());
                } else if (!this.ctx.constructNoConstProj) {
                    this.predProjected = true;
                }
                TriplesBlock.Element element2 = triplesBlock.getObject();
                if (element2.isVariable()) {
                    hashSet.add(element2.getName());
                    this.objVars.add(element2.getName());
                } else if (!this.ctx.constructNoConstProj) {
                    this.objProjected = true;
                }
                if (quad.graph == null) continue;
                TriplesBlock.Element element3 = TriplesBlock.getElementForNode(quad.graph, this.ctx);
                if (element3.isVariable()) {
                    hashSet.add(element3.getName());
                    this.graphVars.add(element3.getName());
                    continue;
                }
                if (this.ctx.constructNoConstProj) continue;
                this.graphProjected = true;
            }
            if (this.ctx.constructStrict) {
                this.subjProjected = true;
                this.predProjected = true;
                this.graphProjected = true;
            }
            Set<String> set = this.getAllLexVars();
            if (!this.subjProjected && QueryUtils.containsAny(set, this.subjVars)) {
                this.subjProjected = true;
            }
            if (!this.predProjected && QueryUtils.containsAny(set, this.predVars)) {
                this.predProjected = true;
            }
            if (!this.objProjected && QueryUtils.containsAny(set, this.objVars)) {
                this.objProjected = true;
            }
            if (!this.graphProjected && QueryUtils.containsAny(set, this.graphVars)) {
                this.graphProjected = true;
            }
            int n = 1;
            for (int i = 0; i < this.ctx.pIDs.length; ++i) {
                int n2 = this.ctx.pIDs[i];
                if (n2 >= 40 || n2 % 10 == n) continue;
                if (n2 / 10 == 0) {
                    this.subjProjected = true;
                    continue;
                }
                if (n2 / 10 == 1) {
                    this.predProjected = true;
                    continue;
                }
                if (n2 / 10 == 2) {
                    this.objProjected = true;
                    continue;
                }
                if (n2 / 10 != 3) continue;
                this.graphProjected = true;
            }
            Set<String> set2 = QueryUtils.getDistinctVars(hashSet, sPARQLTreeNode.getCumulativeVars());
            if (!set2.isEmpty() && (iterator = set2.iterator()).hasNext()) {
                object = iterator.next();
                throw new RDFException("CONSTRUCT template variable ?" + (String)object + " is undefined");
            }
            if (this.subjProjected) {
                sPARQLTreeNode.addProjectVars(this.subjVars);
            }
            if (this.predProjected) {
                sPARQLTreeNode.addProjectVars(this.predVars);
            }
            if (this.objProjected) {
                sPARQLTreeNode.addProjectVars(this.objVars);
            }
            if (this.graphProjected) {
                sPARQLTreeNode.addProjectVars(this.graphVars);
            }
        } else {
            throw new RDFException("Invalid number of children under ConstructSPARQLTreeNode");
        }
        sPARQLTreeNode.setProjections();
    }

    @Override
    public void setActiveGraph(ASTTripleAtom aSTTripleAtom) {
        this.activeGraph = aSTTripleAtom;
    }

    @Override
    public void addTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) {
        Object object;
        if (this.newBGPonTB) {
            object = new BasicGraphPattern();
            this.bgpList.add(new QuadBGP(this.activeGraph, (BasicGraphPattern)object));
            ++this.currBGPIdx;
            this.newBGPonTB = false;
        }
        object = this.bgpList.get(this.currBGPIdx);
        ((QuadBGP)object).bgp.addTriplesBlock(sPARQLTriplesBlock, this.ctx);
    }

    @Override
    public String toSQL() throws RDFException {
        if (this.getTBList().size() == 0) {
            throw new RDFException("An empty CONSTRUCT template is not allowed");
        }
        if (this.getNumChildren() != 1) {
            throw new RDFException("Unexpected number of children under ConstructSPARQLTreeNode");
        }
        String string = "";
        string = this.bindingsSQL != null && this.bindingsSQL.length() > 0 ? this.bindingsSQL : this.getChild(0).toSQL();
        try {
            string = this.buildUnPivot(string);
        }
        catch (SQLException sQLException) {
            throw new RDFException(sQLException.getMessage());
        }
        return string;
    }

    private List<Quad> getTBList() {
        if (this.tbList == null) {
            this.tbList = new ArrayList<Quad>();
            if (this.bgpList != null) {
                for (QuadBGP quadBGP : this.bgpList) {
                    List<TriplesBlock> list = quadBGP.bgp.getTriplesList();
                    for (TriplesBlock triplesBlock : list) {
                        this.tbList.add(new Quad(quadBGP.graph, triplesBlock));
                    }
                }
            }
        }
        return this.tbList;
    }

    private String buildUnPivot(String string) throws SQLException {
        CharSequence charSequence;
        boolean bl = this.ctx.constructUnique;
        boolean bl2 = this.ctx.constructStrict;
        boolean bl3 = this.ctx.constructNarrowCols;
        int n = this.getTBList().size() * 40;
        if (!bl) {
            ++n;
        }
        if (n > 1000) {
            bl3 = true;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        StringBuffer stringBuffer4 = new StringBuffer("");
        StringBuffer stringBuffer5 = new StringBuffer("");
        String[] stringArray = new String[]{"SUBJ", "PRED", "OBJ", "GRAPH"};
        for (int i = 0; i < stringArray.length; ++i) {
            QueryUtils.appendToList(stringBuffer, this.buildColumnsList(stringArray[i], bl, false), ",\n", "");
            if (bl3) {
                QueryUtils.appendToList(stringBuffer2, this.buildShortColumnsList(stringArray[i], bl, false), ",\n", "");
                QueryUtils.appendToList(stringBuffer3, this.decomposeRDFTerm(stringArray[i], bl), ",\n", "");
            }
            if (!bl) continue;
            QueryUtils.appendToList(stringBuffer4, this.buildColumnsList(stringArray[i], false, true), ",\n", "");
            QueryUtils.appendToList(stringBuffer5, this.buildColumnsList(stringArray[i], false, true), ",\n", "");
        }
        if (!bl) {
            QueryUtils.appendToList(stringBuffer, "SEM$ROWNUM", ",\n", "");
            QueryUtils.appendToList(stringBuffer2, "SEM$ROWNUM", ",\n", "");
            QueryUtils.appendToList(stringBuffer3, "SEM$ROWNUM", ",\n", "");
        }
        StringBuffer stringBuffer6 = new StringBuffer("");
        int n2 = 40;
        int n3 = 8;
        if (bl3) {
            n2 = 12;
            n3 = 4;
        }
        if (bl) {
            n2 -= n3;
        }
        for (int i = 0; i < n2; ++i) {
            QueryUtils.appendToList(stringBuffer6, "C" + i, ", ", "");
        }
        if (!bl) {
            QueryUtils.appendToList(stringBuffer6, "CRNUM", ", ", "");
        }
        StringBuffer stringBuffer7 = new StringBuffer("");
        stringArray[0] = "S";
        stringArray[1] = "P";
        stringArray[2] = "O";
        stringArray[3] = "G";
        for (int i = 0; i < this.getTBList().size(); ++i) {
            charSequence = new StringBuffer("");
            for (int j = 0; j < stringArray.length; ++j) {
                if (!bl3) {
                    QueryUtils.appendToList(charSequence, this.buildColumnsList(stringArray[j] + i, bl, false), ",\n", "");
                    continue;
                }
                QueryUtils.appendToList(charSequence, this.buildShortColumnsList(stringArray[j] + i, bl, false), ",\n", "");
            }
            if (!bl) {
                QueryUtils.appendToList(charSequence, "SEM$ROWNUM", ",\n", "");
            }
            QueryUtils.appendToList(stringBuffer7, "(" + charSequence.toString() + ")", ",\n", "");
        }
        StringBuffer stringBuffer8 = new StringBuffer("");
        stringBuffer8.append("SELECT ");
        if (bl) {
            stringBuffer8.append("DISTINCT ");
        }
        stringBuffer8.append(stringBuffer.toString());
        stringBuffer8.append("\n");
        if (bl3) {
            stringBuffer8.append("FROM (\n SELECT ").append(stringBuffer3).append("\n");
        }
        stringBuffer8.append("FROM (\n").append(this.buildConstructWrapper(string, bl, bl3)).append(")\n");
        stringBuffer8.append("UNPIVOT INCLUDE NULLS\n");
        if (!bl3) {
            stringBuffer8.append("((").append(stringBuffer.toString()).append(")\n");
        } else {
            stringBuffer8.append("((").append(stringBuffer2.toString()).append(")\n");
        }
        stringBuffer8.append("FOR (").append(stringBuffer6.toString()).append(")\n");
        stringBuffer8.append("IN (").append(stringBuffer7.toString()).append("))");
        if (bl) {
            charSequence = "1";
            if (this.ctx.disableRowNumOpt) {
                charSequence = "ROWNUM";
            }
            if (!bl3) {
                stringBuffer8.insert(0, "SELECT " + stringBuffer4.toString() + ",\n" + (String)charSequence + " AS SEM$ROWNUM\nFROM (");
            } else {
                stringBuffer8.insert(0, "SELECT " + stringBuffer5.toString() + ",\n" + (String)charSequence + " AS SEM$ROWNUM\nFROM (");
            }
            stringBuffer8.append(")");
        }
        if (bl3) {
            stringBuffer8.append("\n)");
        }
        stringBuffer8.append("\nWHERE (1=1) ");
        if (bl2) {
            stringBuffer8.append("AND SUBJ$RDFVTYP IN ('UR','URI','BL','BLN') AND PRED$RDFVTYP IN ('UR','URI') AND NVL(GRAPH$RDFVTYP,'UR') IN ('UR','URI') ");
        }
        if (this.subjProjected) {
            stringBuffer8.append("AND SUBJ$RDFVTYP IS NOT NULL ");
        } else {
            stringBuffer8.append("AND SUBJ$RDFVID IS NOT NULL ");
        }
        if (this.predProjected) {
            stringBuffer8.append("AND PRED$RDFVTYP IS NOT NULL ");
        } else {
            stringBuffer8.append("AND PRED$RDFVID IS NOT NULL ");
        }
        if (this.objProjected) {
            stringBuffer8.append("AND OBJ$RDFVTYP IS NOT NULL ");
        } else {
            stringBuffer8.append("AND OBJ$RDFVID IS NOT NULL ");
        }
        return stringBuffer8.toString();
    }

    private String buildColumnsList(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        for (int i = 0; i < 8; ++i) {
            if (bl && i == 5) continue;
            string2 = string + this.finalCols[i];
            if (bl2 && i == 5) {
                string2 = "NULL AS " + string2;
            }
            QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        }
        QueryUtils.appendToList(stringBuffer, string + "$RDFTERM", ", ", "");
        if (!bl) {
            string2 = string + "$RDFCLBT";
            if (bl2) {
                string2 = "TO_CLOB(NULL) AS " + string2;
            }
            QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        }
        return stringBuffer.toString();
    }

    private String buildShortColumnsList(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        QueryUtils.appendToList(stringBuffer, string + this.finalCols[1], ", ", "");
        if (!bl) {
            string2 = string + this.finalCols[5];
            if (bl2) {
                string2 = "NULL AS " + string2;
            }
            QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        }
        QueryUtils.appendToList(stringBuffer, string + "$RDFTERM", ", ", "");
        return stringBuffer.toString();
    }

    private String buildConstructWrapper(String string, boolean bl, boolean bl2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        Set<String> set = this.getAllLexVars();
        List<Quad> list = this.getTBList();
        int n = 0;
        for (Quad quad : list) {
            TriplesBlock triplesBlock = quad.triple;
            QueryUtils.appendToList(stringBuffer, this.buildTBProjection(quad.graph, triplesBlock, n, set, bl2), ",\n", "SELECT ");
            ++n;
        }
        if (!bl) {
            Object object = "1";
            if (this.ctx.disableRowNumOpt) {
                object = "ROWNUM";
            }
            QueryUtils.appendToList(stringBuffer, (String)object + " AS SEM$ROWNUM", ",\n", "SELECT ");
        }
        stringBuffer.append("\nFROM (\n" + string + ") R");
        return stringBuffer.toString();
    }

    private String buildTBProjection(ASTTripleAtom aSTTripleAtom, TriplesBlock triplesBlock, int n, Set<String> set, boolean bl) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        TriplesBlock.Element element = null;
        if (aSTTripleAtom != null) {
            element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
        }
        TriplesBlock.Element element2 = triplesBlock.getSubject();
        TriplesBlock.Element element3 = triplesBlock.getPredicate();
        TriplesBlock.Element element4 = triplesBlock.getObject();
        QueryUtils.appendToList(stringBuffer, this.buildElemProjection(element2, "S" + n, this.subjProjected, set, bl), ", ", "");
        stringBuffer.append("\n");
        QueryUtils.appendToList(stringBuffer, this.buildElemProjection(element3, "P" + n, this.predProjected, set, bl), ", ", "");
        stringBuffer.append("\n");
        QueryUtils.appendToList(stringBuffer, this.buildElemProjection(element4, "O" + n, this.objProjected, set, bl), ", ", "");
        stringBuffer.append("\n");
        QueryUtils.appendToList(stringBuffer, this.buildElemProjection(element, "G" + n, this.graphProjected, set, bl), ", ", "");
        return stringBuffer.toString();
    }

    private String buildElemProjection(TriplesBlock.Element element, String string, boolean bl, Set<String> set, boolean bl2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        String[] stringArray = new String[10];
        String[] stringArray2 = new String[10];
        ArrayList<String> arrayList = null;
        int n = 0;
        int n2 = 8;
        boolean bl3 = false;
        int n3 = 1;
        int n4 = 2;
        int n5 = 3;
        int n6 = 4;
        int n7 = 5;
        int n8 = 6;
        int n9 = 7;
        String string2 = "";
        String string3 = "";
        if (element != null) {
            switch (element.getType()) {
                case 0: {
                    bl3 = true;
                    String string4 = "NULL";
                    if (bl) {
                        string4 = "R." + element.getName() + this.varProjColumns[n4];
                    }
                    for (int i = 0; i < 8; ++i) {
                        if (!bl2 || i == n || i == n9) {
                            if (bl || i == n) {
                                stringArray[i] = "R." + element.getName() + this.varProjColumns[i];
                                if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults && (i == n3 || i == n5 || i == n6 || i == n7 || i == n8)) {
                                    stringArray[i] = this.unescapeColumn("SEM_APIS.unescape_rdf_value", stringArray[i]);
                                } else if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults && i == n9) {
                                    stringArray[i] = this.unescapeColumn("SEM_APIS.unescape_clob_value", stringArray[i]);
                                }
                            } else {
                                stringArray[i] = "NULL";
                            }
                            stringArray2[i] = " AS " + string + this.varProjColumns[i];
                            continue;
                        }
                        stringArray[i] = MASK_COL_FLAG;
                        stringArray2[i] = MASK_COL_FLAG;
                    }
                    if (bl) {
                        stringArray[8] = this.buildRDFTForVar("R", element.getName(), null, false, false, false, set.contains(element.getName()), false, "SEM_APIS.COMPOSE_RDF_TERM");
                        if (this.ctx.networkStorageForm.equals("UNESC")) {
                            if (!this.ctx.unescapeResults) {
                                stringArray[8] = this.escapeColumnSpecialChars("SEM_APIS.escape_rdf_term", stringArray[8]);
                            }
                        } else if (this.ctx.unescapeResults) {
                            stringArray[8] = this.unescapeColumn("SEM_APIS.unescape_rdf_term", stringArray[8]);
                        }
                    } else {
                        stringArray[8] = "NULL";
                    }
                    stringArray2[8] = " AS " + string + "$RDFTERM";
                    if (!bl2) {
                        if (bl) {
                            stringArray[9] = this.buildRDFTForVar("R", element.getName(), null, true, false, false, set.contains(element.getName()), false, "SEM_APIS.COMPOSE_RDF_TERM");
                            if (this.ctx.networkStorageForm.equals("UNESC")) {
                                if (!this.ctx.unescapeResults) {
                                    stringArray[9] = this.escapeColumnSpecialChars("SEM_APIS.escape_clob_term", stringArray[9]);
                                }
                            } else if (this.ctx.unescapeResults) {
                                stringArray[9] = this.unescapeColumn("SEM_APIS.unescape_clob_term", stringArray[9]);
                            }
                        } else {
                            stringArray[9] = "TO_CLOB(NULL)";
                        }
                        stringArray2[9] = " AS " + string + "$RDFCLBT";
                        break;
                    }
                    stringArray[9] = MASK_COL_FLAG;
                    stringArray2[9] = MASK_COL_FLAG;
                    break;
                }
                case 1: {
                    stringArray[0] = element.getCanonicalID() != null ? "TO_NUMBER('" + element.getCanonicalID() + "')" : "TO_NUMBER(NULL)";
                    stringArray2[0] = " AS " + string + this.varProjColumns[0];
                    stringArray[1] = string3 = QueryUtils.enquoteLiteral(element.getValueName());
                    if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults) {
                        stringArray[1] = this.unescapeColumn("SEM_APIS.unescape_rdf_value", stringArray[1]);
                    }
                    stringArray2[1] = " AS " + string + this.varProjColumns[1];
                    stringArray[2] = "'URI'";
                    stringArray2[2] = " AS " + string + this.varProjColumns[2];
                    stringArray[3] = "MDSYS.RDF_APIS.VALUE_NAME_PREFIX(" + string3 + ",'URI')";
                    if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults) {
                        stringArray[3] = this.unescapeColumn("SEM_APIS.unescape_rdf_value", stringArray[3]);
                    }
                    stringArray2[3] = " AS " + string + this.varProjColumns[3];
                    stringArray[4] = "MDSYS.RDF_APIS.VALUE_NAME_SUFFIX(" + string3 + ",'URI')";
                    if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults) {
                        stringArray[4] = this.unescapeColumn("SEM_APIS.unescape_rdf_value", stringArray[4]);
                    }
                    stringArray2[4] = " AS " + string + this.varProjColumns[4];
                    stringArray[5] = "NULL";
                    stringArray2[5] = " AS " + string + this.varProjColumns[5];
                    stringArray[6] = "NULL";
                    stringArray2[6] = " AS " + string + this.varProjColumns[6];
                    stringArray[7] = "TO_CLOB(NULL)";
                    stringArray2[7] = " AS " + string + this.varProjColumns[7];
                    arrayList = new ArrayList<String>(8);
                    arrayList.add(stringArray[1]);
                    arrayList.add(stringArray[0]);
                    arrayList.add(stringArray[3]);
                    arrayList.add(stringArray[4]);
                    arrayList.add(stringArray[2]);
                    arrayList.add(stringArray[7]);
                    arrayList.add(stringArray[5]);
                    arrayList.add(stringArray[6]);
                    stringArray[8] = QueryUtils.buildFuncCall("SEM_APIS.COMPOSE_RDF_TERM", RDFT_VC_COLS, arrayList);
                    stringArray2[8] = " AS " + string + "$RDFTERM";
                    if (!bl2) {
                        stringArray[9] = QueryUtils.buildFuncCall("SEM_APIS.COMPOSE_RDF_TERM", RDFT_CLOB_COLS, arrayList);
                        stringArray2[9] = " AS " + string + "$RDFCLBT";
                        break;
                    }
                    for (int i = 1; i <= 6; ++i) {
                        stringArray[i] = MASK_COL_FLAG;
                        stringArray2[i] = MASK_COL_FLAG;
                    }
                    stringArray[9] = MASK_COL_FLAG;
                    stringArray2[9] = MASK_COL_FLAG;
                    break;
                }
                default: {
                    stringArray[0] = element.getCanonicalID() != null ? "TO_NUMBER('" + element.getCanonicalID() + "')" : "TO_NUMBER(NULL)";
                    stringArray2[0] = " AS " + string + this.varProjColumns[0];
                    String string5 = element.getValueName();
                    String string6 = element.getLitLang();
                    String string7 = element.getLitType();
                    string3 = QueryUtils.shortenConstVNforTerm(string5, string6, string7);
                    stringArray[1] = string3 = QueryUtils.enquoteLiteral(string3);
                    if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults) {
                        stringArray[1] = this.unescapeColumn("SEM_APIS.unescape_rdf_value", stringArray[1]);
                    }
                    stringArray2[1] = " AS " + string + this.varProjColumns[1];
                    stringArray[2] = "'LIT'";
                    stringArray2[2] = " AS " + string + this.varProjColumns[2];
                    stringArray[3] = string3;
                    if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults) {
                        stringArray[3] = this.unescapeColumn("SEM_APIS.unescape_rdf_value", stringArray[3]);
                    }
                    stringArray2[3] = " AS " + string + this.varProjColumns[3];
                    stringArray[4] = "NULL";
                    stringArray2[4] = " AS " + string + this.varProjColumns[4];
                    String string8 = stringArray[5] = string7 != null ? QueryUtils.enquoteLiteral(string7) : "NULL";
                    if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults) {
                        stringArray[5] = this.unescapeColumn("SEM_APIS.unescape_rdf_value", stringArray[5]);
                    }
                    stringArray2[5] = " AS " + string + this.varProjColumns[5];
                    String string9 = stringArray[6] = string6 != null ? "'" + string6 + "'" : "NULL";
                    if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults) {
                        stringArray[6] = this.unescapeColumn("SEM_APIS.unescape_rdf_value", stringArray[6]);
                    }
                    stringArray2[6] = " AS " + string + this.varProjColumns[6];
                    stringArray[7] = "NULL";
                    if (QueryUtils.computeConstTermLen(string5, string6, string7) > 4000) {
                        stringArray[7] = QueryUtils.splitClobInChunks(string5, 3500);
                        if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeResults) {
                            stringArray[7] = this.unescapeColumn("SEM_APIS.unescape_clob_value", stringArray[7]);
                        }
                    }
                    stringArray2[7] = " AS " + string + this.varProjColumns[7];
                    arrayList = new ArrayList(8);
                    arrayList.add(stringArray[1]);
                    arrayList.add(stringArray[0]);
                    arrayList.add(stringArray[3]);
                    arrayList.add(stringArray[4]);
                    arrayList.add(stringArray[2]);
                    arrayList.add(stringArray[7]);
                    arrayList.add(stringArray[5]);
                    arrayList.add(stringArray[6]);
                    String string10 = "SEM_APIS.COMPOSE_CANON_TERM";
                    if (this.ctx.useExactForExpr) {
                        string10 = "SEM_APIS.COMPOSE_RDF_TERM";
                    }
                    stringArray[8] = QueryUtils.buildFuncCall(string10, RDFT_VC_COLS, arrayList);
                    stringArray2[8] = " AS " + string + "$RDFTERM";
                    if (!bl2) {
                        stringArray[9] = QueryUtils.buildFuncCall("SEM_APIS.COMPOSE_RDF_TERM", RDFT_CLOB_COLS, arrayList);
                        stringArray2[9] = " AS " + string + "$RDFCLBT";
                        break;
                    }
                    for (int i = 1; i <= 6; ++i) {
                        stringArray[i] = MASK_COL_FLAG;
                        stringArray2[i] = MASK_COL_FLAG;
                    }
                    stringArray[9] = MASK_COL_FLAG;
                    stringArray2[9] = MASK_COL_FLAG;
                }
            }
            if (this.ctx.hashVids) {
                if (element.getType() == 0 && set.contains(element.getName())) {
                    stringArray[n] = QueryUtils.buildVidHash(stringArray[n2]);
                } else if (element.getType() != 0) {
                    string2 = QueryUtils.buildVidHash(stringArray[n2]);
                    stringArray[n] = element.getCanonicalID() != null ? "TO_NUMBER('" + element.getCanonicalID() + "')" : string2;
                }
            }
        } else {
            stringArray[0] = "TO_NUMBER(NULL)";
            stringArray2[0] = " AS " + string + this.varProjColumns[0];
            stringArray[7] = "TO_CLOB(NULL)";
            stringArray2[7] = " AS " + string + this.varProjColumns[7];
            stringArray[8] = "NULL";
            stringArray2[8] = " AS " + string + "$RDFTERM";
            if (!bl2) {
                stringArray[1] = "NULL";
                stringArray2[1] = " AS " + string + this.varProjColumns[1];
                stringArray[2] = "NULL";
                stringArray2[2] = " AS " + string + this.varProjColumns[2];
                stringArray[3] = "NULL";
                stringArray2[3] = " AS " + string + this.varProjColumns[3];
                stringArray[4] = "NULL";
                stringArray2[4] = " AS " + string + this.varProjColumns[4];
                stringArray[5] = "NULL";
                stringArray2[5] = " AS " + string + this.varProjColumns[5];
                stringArray[6] = "NULL";
                stringArray2[6] = " AS " + string + this.varProjColumns[6];
                stringArray[9] = "TO_CLOB(NULL)";
                stringArray2[9] = " AS " + string + "$RDFCLBT";
            } else {
                for (int i = 1; i <= 6; ++i) {
                    stringArray[i] = MASK_COL_FLAG;
                    stringArray2[i] = MASK_COL_FLAG;
                }
                stringArray[9] = MASK_COL_FLAG;
                stringArray2[9] = MASK_COL_FLAG;
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if ((stringArray[i] + stringArray2[i]).equals(MASK_PROJ_FLAG)) continue;
            QueryUtils.appendToList(stringBuffer, stringArray[i] + stringArray2[i], ", ", "");
        }
        return stringBuffer.toString();
    }

    private String decomposeRDFTerm(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        string2 = "MDSYS.SDO_RDF.VNAME(" + string + "$RDFTERM" + ") " + string;
        QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        string2 = string + "$RDFVID";
        QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        string2 = "MDSYS.SDO_RDF.VNPFX(" + string + "$RDFTERM" + ") " + string + "$_PREFIX";
        QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        string2 = "MDSYS.SDO_RDF.VNSFX(" + string + "$RDFTERM" + ") " + string + "$_SUFFIX";
        QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        string2 = "MDSYS.SDO_RDF.VTYPE(" + string + "$RDFTERM" + ") " + string + "$RDFVTYP";
        QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        if (!bl) {
            string2 = string + "$RDFCLOB";
            QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        }
        string2 = "MDSYS.SDO_RDF.LTYPE(" + string + "$RDFTERM" + ") " + string + "$RDFLTYP";
        QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        string2 = "MDSYS.SDO_RDF.LATAG(" + string + "$RDFTERM" + ") " + string + "$RDFLANG";
        QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        string2 = string + "$RDFTERM";
        QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        string2 = "SEM_APIS.COMPOSE_RDF_TERM(MDSYS.SDO_RDF.VNAME(" + string + "$RDFTERM" + "), " + "MDSYS.SDO_RDF.VTYPE" + "(" + string + "$RDFTERM" + "), " + "MDSYS.SDO_RDF.LTYPE" + "(" + string + "$RDFTERM" + "), " + "MDSYS.SDO_RDF.LATAG" + "(" + string + "$RDFTERM" + "), ";
        string2 = !bl ? string2 + string + "$RDFCLOB" : string2 + "TO_CLOB(NULL)";
        string2 = string2 + ") " + string + "$RDFCLBT";
        QueryUtils.appendToList(stringBuffer, string2, ", ", "");
        return stringBuffer.toString();
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "====== Construct Pattern =======\n";
        for (QuadBGP quadBGP : this.bgpList) {
            if (quadBGP.graph != null) {
                string2 = string2 + "GRAPH: " + quadBGP.graph.toString() + "\n";
            }
            string2 = string2 + quadBGP.bgp.toString() + "\n";
        }
        string2 = string2 + string + "================================\n";
        string2 = string2 + super.toString(string);
        return string2;
    }

    private static class Quad {
        public ASTTripleAtom graph;
        public TriplesBlock triple;

        public Quad(ASTTripleAtom aSTTripleAtom, TriplesBlock triplesBlock) {
            this.graph = aSTTripleAtom;
            this.triple = triplesBlock;
        }
    }

    private static class QuadBGP {
        public ASTTripleAtom graph;
        public BasicGraphPattern bgp;

        public QuadBGP(ASTTripleAtom aSTTripleAtom, BasicGraphPattern basicGraphPattern) {
            this.graph = aSTTripleAtom;
            this.bgp = basicGraphPattern;
        }
    }
}

