/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Stack;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SPARQLTreeOptimizer;
import oracle.spatial.rdf.server.SelectSPARQLTreeNode;
import oracle.spatial.rdf.server.SimpleSPARQLTreeNode;
import oracle.spatial.rdf.server.UnionSPARQLTreeNode;

public class EmptySPARQLTreeOptimizer
implements SPARQLTreeOptimizer {
    private static final String MAX_ITERS_ERROR = "Error optimizing SPARQL Tree: max iterations reached while removing empty nodes";
    private static final int MAX_ITERS = 10000;

    @Override
    public SPARQLTreeNode optimizeTree(SPARQLTreeNode sPARQLTreeNode) throws RDFException {
        int n;
        boolean bl = true;
        for (n = 0; !sPARQLTreeNode.isEmpty() && bl && n < 10000; ++n) {
            bl = this.removeSingleEmptyNode(sPARQLTreeNode);
        }
        if (n >= 10000) {
            throw new RDFException(MAX_ITERS_ERROR);
        }
        bl = true;
        for (n = 0; !sPARQLTreeNode.isEmpty() && bl && n < 10000; ++n) {
            bl = this.removeSingleNonLeafNode(sPARQLTreeNode);
        }
        if (n >= 10000) {
            throw new RDFException(MAX_ITERS_ERROR);
        }
        sPARQLTreeNode.resetVarLists();
        return sPARQLTreeNode;
    }

    private boolean removeSingleEmptyNode(SPARQLTreeNode sPARQLTreeNode) {
        Stack<SPARQLTreeNode> stack = new Stack<SPARQLTreeNode>();
        stack.push(sPARQLTreeNode);
        while (!stack.isEmpty()) {
            SPARQLTreeNode sPARQLTreeNode2 = (SPARQLTreeNode)stack.pop();
            for (int i = 0; i < sPARQLTreeNode2.getNumChildren(); ++i) {
                SPARQLTreeNode sPARQLTreeNode3 = sPARQLTreeNode2.getChild(i);
                if (sPARQLTreeNode3.isEmpty()) {
                    sPARQLTreeNode2.removeChild(i);
                    return true;
                }
                stack.push(sPARQLTreeNode3);
            }
        }
        return false;
    }

    private boolean removeSingleNonLeafNode(SPARQLTreeNode sPARQLTreeNode) {
        Stack<SPARQLTreeNode> stack = new Stack<SPARQLTreeNode>();
        stack.push(sPARQLTreeNode);
        while (!stack.isEmpty()) {
            SPARQLTreeNode sPARQLTreeNode2 = (SPARQLTreeNode)stack.pop();
            for (int i = 0; i < sPARQLTreeNode2.getNumChildren(); ++i) {
                SPARQLTreeNode sPARQLTreeNode3 = sPARQLTreeNode2.getChild(i);
                int n = sPARQLTreeNode3.getNumChildren();
                if (n > 0 && SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode3) && (sPARQLTreeNode3.getOverloadedServiceInfo() & 1) == 0 && (sPARQLTreeNode3.getType() == 0 || sPARQLTreeNode3.getType() == 1) && sPARQLTreeNode3.containsEmptyLocalBGP() && sPARQLTreeNode3.getAllFilters().isEmpty()) {
                    SPARQLTreeNode sPARQLTreeNode4;
                    if (sPARQLTreeNode3.getType() == 0 && (n == 1 || SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode2))) {
                        sPARQLTreeNode4 = sPARQLTreeNode3.getChild(0);
                        if (sPARQLTreeNode4.getType() == 0 && (SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode4) || SelectSPARQLTreeNode.class.isInstance(sPARQLTreeNode4) || UnionSPARQLTreeNode.class.isInstance(sPARQLTreeNode4)) && this.graphCompatible(sPARQLTreeNode2, sPARQLTreeNode3, sPARQLTreeNode4)) {
                            sPARQLTreeNode2.removeChild(i);
                            sPARQLTreeNode2.addChild(sPARQLTreeNode4, i);
                            sPARQLTreeNode4.setParent(sPARQLTreeNode2);
                            int n2 = i + 1;
                            for (int j = 1; j < sPARQLTreeNode3.getNumChildren(); ++j) {
                                SPARQLTreeNode sPARQLTreeNode5 = sPARQLTreeNode3.getChild(j);
                                sPARQLTreeNode2.addChild(sPARQLTreeNode5, n2);
                                sPARQLTreeNode5.setParent(sPARQLTreeNode2);
                                ++n2;
                            }
                            return true;
                        }
                    } else {
                        sPARQLTreeNode4 = sPARQLTreeNode3.getChild(0);
                        if (sPARQLTreeNode4.getType() == 0 && SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode4) && this.graphCompatible(sPARQLTreeNode2, sPARQLTreeNode3, sPARQLTreeNode4)) {
                            sPARQLTreeNode2.removeChild(i);
                            sPARQLTreeNode2.addChild(sPARQLTreeNode4, i);
                            sPARQLTreeNode4.setParent(sPARQLTreeNode2);
                            sPARQLTreeNode4.setType(sPARQLTreeNode3.getType());
                            for (int j = 1; j < sPARQLTreeNode3.getNumChildren(); ++j) {
                                SPARQLTreeNode sPARQLTreeNode6 = sPARQLTreeNode3.getChild(j);
                                sPARQLTreeNode4.addChild(sPARQLTreeNode6);
                                sPARQLTreeNode6.setParent(sPARQLTreeNode4);
                            }
                            return true;
                        }
                    }
                }
                stack.push(sPARQLTreeNode3);
            }
        }
        return false;
    }

    private boolean graphCompatible(SPARQLTreeNode sPARQLTreeNode, SPARQLTreeNode sPARQLTreeNode2, SPARQLTreeNode sPARQLTreeNode3) {
        if (sPARQLTreeNode2.isGraphQuery() && (sPARQLTreeNode3.getOverloadedServiceInfo() & 1) == 1) {
            return false;
        }
        if (this.noActiveGraph(sPARQLTreeNode, sPARQLTreeNode2) || this.noActiveGraph(sPARQLTreeNode2, sPARQLTreeNode3)) {
            return true;
        }
        return this.sameActiveGraph(sPARQLTreeNode, sPARQLTreeNode2) && SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode) && SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode2) || this.sameActiveGraph(sPARQLTreeNode2, sPARQLTreeNode3) && SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode2) && SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode3);
    }

    private boolean sameActiveGraph(SPARQLTreeNode sPARQLTreeNode, SPARQLTreeNode sPARQLTreeNode2) {
        if (sPARQLTreeNode.isGraphQuery() != sPARQLTreeNode2.isGraphQuery()) {
            return false;
        }
        return !sPARQLTreeNode.isGraphQuery() || sPARQLTreeNode.getActiveGraph().equals(sPARQLTreeNode2.getActiveGraph());
    }

    private boolean noActiveGraph(SPARQLTreeNode sPARQLTreeNode, SPARQLTreeNode sPARQLTreeNode2) {
        return !sPARQLTreeNode.isGraphQuery() && !sPARQLTreeNode2.isGraphQuery();
    }
}

