/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.FilterFuncHandler;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.OracleDatabaseVersion;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLEngine;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SimpleSPARQLTreeNode;
import oracle.spatial.rdf.server.SparqlFilterOptimizer;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.UserDefinedAggHandler;
import oracle.spatial.rdf.server.UserDefinedFuncHandler;
import oracle.spatial.rdf.server.parser.sparql.ASTAdditiveOperator;
import oracle.spatial.rdf.server.parser.sparql.ASTAggregate;
import oracle.spatial.rdf.server.parser.sparql.ASTBooleanSpecialNode;
import oracle.spatial.rdf.server.parser.sparql.ASTBuiltInCall;
import oracle.spatial.rdf.server.parser.sparql.ASTComparisonOperator;
import oracle.spatial.rdf.server.parser.sparql.ASTFunctionArgs;
import oracle.spatial.rdf.server.parser.sparql.ASTIRIrefOrFunction;
import oracle.spatial.rdf.server.parser.sparql.ASTMultiplicativeOperator;
import oracle.spatial.rdf.server.parser.sparql.ASTRelationalExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTUnaryOperator;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class Filter
implements Cloneable {
    private static final String NO_COALESCE_ERROR = "No COALESCE found while optimizing COALESCE clause";
    private static final String COALESCE_TYPE_ERROR = "Unexpected node type found while optimizing COALESCE clause";
    protected static final String SECONDARY_EXTRACTED = "SECONDARY_EXTRACTED";
    protected static final String TABLE_REWRITE_FALSE = "TABLE_REWRITE=FALSE";
    protected static final String SQL_XSD_CAST_FALSE = "SQL_XSD_CAST=FALSE";
    protected static final String EXTENDED_VC_TRUE = "EXTENDED_VC=TRUE";
    protected static final String DEFAULT_DATE = "2009-06-26";
    protected static final String DEFAULT_TZ = "Z";
    protected static final String DATE_TIME_FMT = "SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM";
    protected static final String DATE_FMT = "SYYYY-MM-DDTZH:TZM";
    protected static final String NESTED_INPUT = "NESTED_INPUT";
    public static final String TRUE_RDFTERM = "'\"true\"^^<http://www.w3.org/2001/XMLSchema#boolean>'";
    public static final String FALSE_RDFTERM = "'\"false\"^^<http://www.w3.org/2001/XMLSchema#boolean>'";
    public static final String FUNC_USER_PRE = "http://xmlns.oracle.com/rdf/extensions/";
    public static final String FUNC_USER_AGG = "http://xmlns.oracle.com/rdf/aggExtensions/";
    public static final String FUNC_HASVID_OP = "http://xmlns.oracle.com/rdf/hasVID";
    public static final String FUNC_SAMECTERM_OP = "http://xmlns.oracle.com/rdf/sameCanonTerm";
    private static final String UNSUPPORTED_FUNC_ERROR = "Unsupported Function: ";
    public static final String STR_OP = "STR";
    public static final String LANG_OP = "LANG";
    public static final String LANGMATCHES_OP = "LANGMATCHES";
    public static final String DATATYPE_OP = "DATATYPE";
    public static final String BOUND_OP = "BOUND";
    public static final String SAMETERM_OP = "SAMETERM";
    public static final String ISURI_OP = "ISURI";
    public static final String ISIRI_OP = "ISIRI";
    public static final String ISBLANK_OP = "ISBLANK";
    public static final String ISLITERAL_OP = "ISLITERAL";
    public static final String ISNUMERIC_OP = "ISNUMERIC";
    public static final String REGEX_OP = "REGEX";
    public static final String IF_OP = "IF";
    public static final String COALESCE_OP = "COALESCE";
    public static final String IN_OP = "IN";
    public static final String NOT_IN_OP = "NOT IN";
    public static final String REPLACE_OP = "REPLACE";
    public static final String EXISTS_OP = "EXISTS";
    public static final String NOT_EXISTS_OP = "NOT EXISTS";
    public static final String COUNT_OP = "COUNT";
    public static final String SUM_OP = "SUM";
    public static final String AVERAGE_OP = "AVG";
    public static final String MIN_OP = "MIN";
    public static final String MAX_OP = "MAX";
    public static final String SAMPLE_OP = "SAMPLE";
    public static final String GROUP_CONCAT_OP = "GROUP_CONCAT";
    public static final String FUNC_BOOLEAN = "BOOLEAN";
    public static final String FUNC_LITERAL = "LITERAL";
    public static final String FUNC_URI = "URI";
    public static final String FUNC_NUMERIC = "NUMERIC";
    public static final String FUNC_INTEGER = "INTEGER";
    public static final String FUNC_DOUBLE = "DOUBLE";
    public static final String FUNC_FLOAT = "FLOAT";
    public static final String FUNC_GML = "GML";
    public static final String FUNC_WKT = "WKT";
    public static final String FUNC_GEOM = "SDO_GEOM";
    public static final String FUNC_DATETIME = "DATETIME";
    public static final String FUNC_RDF_TERM = "SDO_RDF_TERM";
    public static final String FUNC_VC_TERM = "VC_RDF_TERM";
    public static final int LIT_STRING = 0;
    public static final int LIT_NUMERIC = 1;
    public static final int LIT_DATETIME = 2;
    public static final int LIT_DATE = 3;
    public static final int LIT_TIME = 4;
    public static final int LIT_BOOLEAN = 5;
    public static final int LIT_OTHER = 6;
    public static final int NUMERIC_OP_NODE = 0;
    public static final int BOOLEAN_CONST_NODE = 1;
    public static final int BOOLEAN_NODE = 2;
    public static final int NUMERIC_NODE = 3;
    public static final int VAR_NODE = 4;
    public static final int URI_NODE = 5;
    public static final int URI_WRAPPED_NODE = 6;
    public static final int LIT_WRAPPED_NODE = 7;
    public static final int LIT_PLAIN_NODE = 8;
    public static final int LIT_LANG_NODE = 9;
    public static final int LIT_OTHER_NODE = 10;
    public static final int LIT_STRING_NODE = 11;
    public static final int LIT_NUMERIC_NODE = 12;
    public static final int LIT_BOOLEAN_NODE = 13;
    public static final int LIT_DATETIME_NODE = 14;
    public static final int LIT_DATE_NODE = 15;
    public static final int LIT_TIME_NODE = 16;
    public static final int LIT_DATETIME_TZ_NODE = 17;
    public static final int LIT_DATE_TZ_NODE = 18;
    public static final int LIT_TIME_TZ_NODE = 19;
    public static final int CONST_LIT_PLAIN_NODE = 20;
    public static final int GML_CLOB_NODE = 21;
    public static final int LIT_GML_NODE = 22;
    public static final int WKT_CLOB_NODE = 23;
    public static final int LIT_WKT_NODE = 24;
    public static final int SDO_GEOM_NODE = 25;
    public static final int DATETIME_TZ_NODE = 26;
    public static final int SDO_RDF_TERM_NODE = 27;
    public static final int VC_TERM_NODE = 28;
    public static final int INTEGER_NODE = 29;
    public static final int DOUBLE_NODE = 30;
    public static final int FLOAT_NODE = 31;
    public static final int VAL_NUMERIC = 0;
    public static final int VAL_DATETIME = 1;
    public static final int VAL_DATE = 2;
    public static final int VAL_TIME = 3;
    public static final int VAL_DATETIME_TZ = 4;
    public static final int VAL_DATE_TZ = 5;
    public static final int VAL_TIME_TZ = 6;
    public static final int VAL_STRING = 7;
    public static final int VAL_BOOLEAN = 8;
    public static final int VAL_URI = 9;
    public static final int VAL_LANG_LIT = 10;
    public static final int VAL_OTHER_LIT = 11;
    public static final int VAL_VAR = 12;
    public static final int VAL_OTHER = 13;
    public static final int VAL_SDO_TERM = 14;
    public static final int VAL_VC_TERM = 15;
    public static final int AGG_NORMAL_CASE = 0;
    public static final int AGG_GRP_CONCAT_PL = 1;
    public static final int AGG_MIN_MAX_NUM = 2;
    public static final int AGG_MIN_MAX_PL = 3;
    public static final int AGG_MIN_MAX_DT = 4;
    public static final int BIT_IS_LOCAL = 1;
    public static final int BIT_USES_BOUND = 2;
    public static final int BIT_FAST_DATE = 1;
    public static final int BIT_FAST_TERM = 2;
    public static final int BIT_DISABLE_VID_OPT = 4;
    public static final String NUMERIC_VDOLLAR_FUNC = "sem_apis.getV$NumericVal";
    public static final String EBV_VDOLLAR_FUNC = "sem_apis.getV$EBVVal";
    public static final String STRING_VDOLLAR_FUNC = "sem_apis.getV$StringVal";
    public static final String DTIME_VDOLLAR_FUNC = "sem_apis.getV$DateTimeTZVal";
    public static final String DATE_VDOLLAR_FUNC = "sem_apis.getV$DateTZVal";
    public static final String TIME_VDOLLAR_FUNC = "sem_apis.getV$TimeTZVal";
    public static final String BOOL_VDOLLAR_FUNC = "sem_apis.getV$BooleanVal";
    public static final String DTYPE_VDOLLAR_FUNC = "sem_apis.getV$DatatypeVal";
    public static final String LANG_VDOLLAR_FUNC = "sem_apis.getV$LangVal";
    public static final String STR_VDOLLAR_FUNC = "sem_apis.getV$STRVal";
    public static final String NUMERIC_VDOLLAR_VC_FUNC = "mdsys.sdo_rdf.getV$NumericVal";
    public static final String EBV_VDOLLAR_VC_FUNC = "mdsys.sdo_rdf.getV$EBVVal";
    public static final String STRING_VDOLLAR_VC_FUNC = "mdsys.sdo_rdf.getV$StringVal";
    public static final String DTIME_VDOLLAR_VC_FUNC = "mdsys.sdo_rdf.getV$DateTimeTZVal";
    public static final String DATE_VDOLLAR_VC_FUNC = "mdsys.sdo_rdf.getV$DateTZVal";
    public static final String TIME_VDOLLAR_VC_FUNC = "mdsys.sdo_rdf.getV$TimeTZVal";
    public static final String BOOL_VDOLLAR_VC_FUNC = "mdsys.sdo_rdf.getV$BooleanVal";
    public static final String DTYPE_VDOLLAR_VC_FUNC = "mdsys.sdo_rdf.getV$DatatypeVal";
    public static final String LANG_VDOLLAR_VC_FUNC = "mdsys.sdo_rdf.getV$LangVal";
    private static Map<String, String> VAL_DOL_VC_FUNC_MAP = new HashMap<String, String>();
    public static final String SPARQL_IF_FUNC = "sem_apis.sparql_if";
    public static final String SPARQL_COALESCE_FUNC = "sem_apis.sparql_coalesce";
    public static final String SPARQL_REPLACE_FUNC = "sem_apis.sparql_replace";
    public static final String SPARQL_VC_RDFT_REPLACE_FUNC = "mdsys.sdo_rdf.sparql_replace";
    public static final String SPARQL_VC_RDFT_REGEX_FUNC = "mdsys.sdo_rdf.sparql_regex";
    public static final String RDFT_CANON_TERM_FUNC = "sem_apis.compose_canon_term";
    public static final String RDFT_VDOLLAR_FUNC = "sem_apis.compose_rdf_term";
    public static final String RDFT_SDO_RDF_TERM = "MDSYS.SDO_RDF_TERM";
    public static final String SRT_TO_CANON_TERM = ".toCanonTerm()";
    public static final String SRT_TO_VC_TERM = ".nonCanonTermStr()";
    public static final String SRT_TO_CANON_VC_TERM = ".canonTermStr()";
    public static final String RDF_TERM_COMP = "sem_apis.rdfTermComp";
    public static final String RDF_TERM_COMP_VC = "mdsys.sdo_rdf.rdfTermComp";
    public static final String RDF_TERM_EQUAL = "sem_apis.rdfTermEqual";
    public static final String RDF_TERM_EQUAL_VC = "mdsys.sdo_rdf.rdfTermEqual";
    public static final int MAX_VDOLLAR_ARG_NUM = 8;
    public static final String COUNT_FUNC = "COUNT";
    public static final String SUM_FUNC = "SUM";
    public static final String AVG_FUNC = "AVG";
    public static final String MAX_FUNC = "MAX";
    public static final String MIN_FUNC = "MIN";
    public static final String LISTAGG_FUNC = "LISTAGG";
    public static final String SEM_APIS_MAX = "SEM_APIS_MAX";
    public static final String SEM_APIS_MIN = "SEM_APIS_MIN";
    public static final String SEM_APIS_SAMPLE = "SEM_APIS_SAMPLE";
    public static final String SEM_APIS_GROUP_CONCAT = "SEM_APIS_GROUP_CONCAT";
    public static final String SEM_APIS_MAX_VC = "SEM_APIS_MAX_VC";
    public static final String SEM_APIS_MIN_VC = "SEM_APIS_MIN_VC";
    public static final String SEM_APIS_SAMPLE_VC = "SEM_APIS_SAMPLE_VC";
    public static final String SEM_APIS_GROUP_CONCAT_VC = "SEM_APIS_GROUP_CONCAT_VC";
    public static final String ANC_OP_PREFIX = "ANC$";
    private static final int LONG_VC_LIT_THRESHOLD = 2000;
    private static Map<String, List<Integer>> VAL_DOLLAR_ARG_MAP;
    private SimpleNode filterRoot;
    private Set<String> vars;
    private Set<String> fJoinVars;
    private Set<String> depVars;
    private int specialCases;
    private Set<String> lexVars;
    private Set<String> inScopeVars;
    private Set<String> pfInScopeVars;
    private ASTTripleAtom activeGraph;
    private int pushCnt;
    private boolean pushedToJoin;
    private SQLGenContext ctx;
    private boolean wrapForHaving;
    private Set<String> groupByVars;
    private Set<ASTTripleAtom.BindVar> bindVars;
    private Set<String> defBoundVars;
    private String values_tab;
    private String netNamePfx;
    private String netOwner;
    private String currGpSQL;
    private Set<String> gpVars;
    private Set<String> gpProjVars;
    private Set<String> gpLexVars;
    private Set<String> gpNonPushVars;
    private boolean secondaryExtracted;
    private boolean nestedFuncExists;
    private Map<String, String> spmValueColMapping;

    public static String genValTypeCaseStmt(String string) {
        return "(CASE WHEN " + string + " IS NULL THEN NULL\nWHEN " + string + " IN ('UR','URI') THEN '" + FUNC_URI + "'\nWHEN " + string + " IN ('BN','BLN') THEN '" + "BLN" + "'\nELSE '" + "LIT" + "'\nEND)";
    }

    protected static String concatStrArray(String[] stringArray, String string) {
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = i > 0 ? string2 + string + stringArray[i] : string2 + stringArray[i];
        }
        return string2;
    }

    public static boolean isSubQAlias(String string) {
        return string.startsWith("R.") || string.startsWith("r1.") || string.startsWith("r2.") || string.startsWith("E.");
    }

    private static boolean isVarAtom(int n) {
        boolean bl = false;
        if (n == 0 || n == 9) {
            bl = true;
        }
        return bl;
    }

    public static int getAtomPosition(String string, Map<String, String> map, SQLGenContext sQLGenContext) {
        int n = 0;
        if ((sQLGenContext.contextFlags & 8) > 0) {
            if (map == null) {
                return n;
            }
            String string2 = map.get(string.toUpperCase());
            if (string2.contains("START_NODE_ID")) {
                n = 1;
            } else if (string2.contains("P_VALUE_ID")) {
                n = 2;
            } else if (string2.contains("CANON_END_NODE_ID") || string2.contains("END_NODE_ID")) {
                n = 3;
            }
        }
        return n;
    }

    public static String getAtomSuffix(int n) {
        String string = "";
        string = n == 1 ? "_S" : (n == 2 ? "_P" : "_O");
        return string;
    }

    protected static int getNodeRetType(SimpleNode simpleNode, Map<String, String> map) throws RDFException {
        return Filter.getNodeRetType(simpleNode, map, null);
    }

    protected static int getNodeRetType(SimpleNode simpleNode, Map<String, String> map, SQLGenContext sQLGenContext) throws RDFException {
        int n = -1;
        int n2 = simpleNode.id;
        String string = "";
        String string2 = "";
        block0 : switch (n2) {
            case 89: {
                ASTAggregate aSTAggregate = (ASTAggregate)simpleNode;
                string = aSTAggregate.name;
                boolean bl = false;
                if (sQLGenContext != null && sQLGenContext.inlineAggregates) {
                    int n3 = Filter.isAggregateSpecialCase(aSTAggregate, map, sQLGenContext);
                    switch (n3) {
                        case 1: 
                        case 3: {
                            n = 8;
                            bl = true;
                            break;
                        }
                        case 2: {
                            n = 3;
                            bl = true;
                            break;
                        }
                        case 4: {
                            n = 26;
                            bl = true;
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            throw new RDFException("Undefined Aggregate Case");
                        }
                    }
                }
                if (bl) break;
                string2 = map.get(string);
                if (string2 == null) {
                    if (string.contains(FUNC_USER_AGG)) {
                        string2 = FUNC_RDF_TERM;
                        break;
                    }
                    throw new RDFException(UNSUPPORTED_FUNC_ERROR + string);
                }
                if (string2.equals(FUNC_RDF_TERM)) {
                    n = 27;
                    break;
                }
                if (string2.equals(FUNC_VC_TERM)) {
                    n = 28;
                    break;
                }
                if (string2.equals(FUNC_NUMERIC)) {
                    n = 3;
                    break;
                }
                if (string2.equals(FUNC_INTEGER)) {
                    n = 29;
                    break;
                }
                throw new RDFException(UNSUPPORTED_FUNC_ERROR + string);
            }
            case 58: 
            case 88: 
            case 90: {
                string = n2 == 88 ? ((ASTBuiltInCall)simpleNode).name : ((ASTTripleAtom)simpleNode.jjtGetChild((int)0)).name;
                string2 = map.get(string);
                if (string2 == null) {
                    if (string.contains(FUNC_USER_PRE) || string.contains(FUNC_USER_AGG)) {
                        string2 = FUNC_RDF_TERM;
                    } else {
                        throw new RDFException(UNSUPPORTED_FUNC_ERROR + string);
                    }
                }
                if (string2.equals(FUNC_BOOLEAN)) {
                    n = 2;
                    break;
                }
                if (string2.equals(FUNC_LITERAL)) {
                    n = 8;
                    break;
                }
                if (string2.equals(FUNC_NUMERIC)) {
                    n = 3;
                    break;
                }
                if (string2.equals(FUNC_INTEGER)) {
                    n = 29;
                    break;
                }
                if (string2.equals(FUNC_FLOAT)) {
                    n = 31;
                    break;
                }
                if (string2.equals(FUNC_DOUBLE)) {
                    n = 30;
                    break;
                }
                if (string2.equals(FUNC_GML)) {
                    n = 21;
                    break;
                }
                if (string2.equals(FUNC_WKT)) {
                    n = 23;
                    break;
                }
                if (string2.equals(FUNC_GEOM)) {
                    n = 25;
                    break;
                }
                if (string2.equals(FUNC_URI)) {
                    n = 6;
                    break;
                }
                if (string2.equals(FUNC_DATETIME)) {
                    n = 26;
                    break;
                }
                if (string2.equals(FUNC_RDF_TERM)) {
                    n = 27;
                    break;
                }
                if (!string2.equals(FUNC_VC_TERM)) break;
                n = 28;
                break;
            }
            case 82: 
            case 84: {
                n = 3;
                break;
            }
            case -1: 
            case 78: 
            case 79: 
            case 80: {
                n = 2;
                break;
            }
            case 86: {
                ASTUnaryOperator aSTUnaryOperator = (ASTUnaryOperator)simpleNode.jjtGetChild(0);
                if (aSTUnaryOperator.name.equals("!")) {
                    n = 2;
                    break;
                }
                n = 3;
                break;
            }
            case 73: {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                int n4 = aSTTripleAtom.type;
                switch (n4) {
                    case 0: {
                        n = 4;
                        break block0;
                    }
                    case 9: {
                        n = 27;
                        break block0;
                    }
                    case 1: {
                        n = 5;
                        break block0;
                    }
                }
                if (aSTTripleAtom.litType != null) {
                    switch (Filter.litFamily(aSTTripleAtom.litType)) {
                        case 0: {
                            n = 11;
                            break block0;
                        }
                        case 1: {
                            n = 12;
                            break block0;
                        }
                        case 2: {
                            if (aSTTripleAtom.name.matches("^(-)?\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(\\.(\\d)+)?(Z|(\\+|-)\\d\\d:\\d\\d)$")) {
                                n = 17;
                                break block0;
                            }
                            n = 14;
                            break block0;
                        }
                        case 3: {
                            if (aSTTripleAtom.name.matches("^(-)?\\d\\d\\d\\d-\\d\\d-\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)$")) {
                                n = 18;
                                break block0;
                            }
                            n = 15;
                            break block0;
                        }
                        case 4: {
                            if (aSTTripleAtom.name.matches("^\\d\\d:\\d\\d:\\d\\d(\\.(\\d)+)?(Z|(\\+|-)\\d\\d:\\d\\d)$")) {
                                n = 19;
                                break block0;
                            }
                            n = 16;
                            break block0;
                        }
                        case 5: {
                            n = 13;
                            break block0;
                        }
                        case 6: {
                            if (aSTTripleAtom.litType.equals("http://www.opengis.net/ont/geosparql#gmlLiteral") || aSTTripleAtom.litType.equals("http://xmlns.oracle.com/rdf/geo/GML31Literal")) {
                                n = 22;
                                break block0;
                            }
                            if (aSTTripleAtom.litType.equals("http://xmlns.oracle.com/rdf/geo/WKTLiteral") || aSTTripleAtom.litType.equals("http://www.opengis.net/ont/geosparql#wktLiteral")) {
                                n = 24;
                                break block0;
                            }
                            n = 10;
                            break block0;
                        }
                    }
                    n = 10;
                    break;
                }
                if (aSTTripleAtom.litLang != null) {
                    n = 9;
                    break;
                }
                n = 20;
                break;
            }
            case 83: 
            case 85: {
                n = 0;
            }
        }
        return n;
    }

    protected static boolean isCalendarType(int n) {
        boolean bl = false;
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: {
                bl = true;
            }
        }
        return bl;
    }

    protected static int getCompFamily(int n) {
        int n2 = -1;
        switch (n) {
            case 3: 
            case 12: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 0;
                break;
            }
            case 8: 
            case 11: 
            case 20: {
                n2 = 7;
                break;
            }
            case 17: 
            case 26: {
                n2 = 4;
                break;
            }
            case 14: {
                n2 = 1;
                break;
            }
            case 18: {
                n2 = 5;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
            case 19: {
                n2 = 6;
                break;
            }
            case 16: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                n2 = 8;
                break;
            }
            case 5: 
            case 6: {
                n2 = 9;
                break;
            }
            case 9: {
                n2 = 10;
                break;
            }
            case 10: 
            case 22: 
            case 24: {
                n2 = 11;
                break;
            }
            case 4: {
                n2 = 12;
                break;
            }
            case 27: {
                n2 = 14;
                break;
            }
            case 28: {
                n2 = 15;
                break;
            }
            default: {
                n2 = 13;
            }
        }
        return n2;
    }

    protected static int litFamily(String string) {
        String string2;
        int n = string.startsWith("http://www.w3.org/2001/XMLSchema#") ? ((string2 = string.substring(33)).equals("string") ? 0 : (string2.equals("normalizedString") ? 0 : (string2.equals("token") ? 0 : (string2.equals("language") ? 0 : (string2.equals("Name") ? 0 : (string2.equals("NCName") ? 0 : (string2.equals("NMTOKEN") ? 0 : (string2.equals("double") ? 1 : (string2.equals("float") ? 1 : (string2.equals("decimal") ? 1 : (string2.equals("integer") ? 1 : (string2.equals("nonPositiveInteger") ? 1 : (string2.equals("negativeInteger") ? 1 : (string2.equals("long") ? 1 : (string2.equals("int") ? 1 : (string2.equals("short") ? 1 : (string2.equals("byte") ? 1 : (string2.equals("nonNegativeInteger") ? 1 : (string2.equals("unsignedLong") ? 1 : (string2.equals("unsignedInt") ? 1 : (string2.equals("unsignedShort") ? 1 : (string2.equals("unsignedByte") ? 1 : (string2.equals("positiveInteger") ? 1 : (string2.equals("boolean") ? 5 : (string2.equals("date") ? 3 : (string2.equals("dateTime") ? 2 : (string2.equals("time") ? 4 : 6))))))))))))))))))))))))))) : 6;
        return n;
    }

    protected static String normalizeBoolean(String string) {
        String string2 = "NULL";
        string2 = string.toUpperCase().equals("'TRUE'") || string.toUpperCase().equals("'1'") ? TRUE_RDFTERM : FALSE_RDFTERM;
        return string2;
    }

    private static int isAggregateSpecialCase(ASTAggregate aSTAggregate, Map<String, String> map, SQLGenContext sQLGenContext) throws RDFException {
        String string = "";
        int n = 0;
        boolean bl = false;
        string = aSTAggregate.name;
        if (aSTAggregate.distinct != "") {
            bl = true;
        }
        if (aSTAggregate.jjtGetNumChildren() > 0) {
            SimpleNode simpleNode = (SimpleNode)aSTAggregate.jjtGetChild(0);
            n = Filter.getNodeRetType((SimpleNode)aSTAggregate.jjtGetChild(0), map);
        }
        if (string.equals(GROUP_CONCAT_OP) && !sQLGenContext.clobAggSupport && n == 8) {
            if (sQLGenContext.dbVersion.isCompatible(OracleDatabaseVersion.V_19c) || !bl) {
                return 1;
            }
            return 0;
        }
        if (!(!string.equals("MIN") && !string.equals("MAX") || sQLGenContext.clobAggSupport || n != 3 && n != 29 && n != 31 && n != 30 && n != 0)) {
            return 2;
        }
        if ((string.equals("MIN") || string.equals("MAX")) && !sQLGenContext.clobAggSupport && n == 8) {
            return 3;
        }
        if ((string.equals("MIN") || string.equals("MAX")) && !sQLGenContext.clobAggSupport && n == 26) {
            return 4;
        }
        return 0;
    }

    private static String getNonExistingTermFilterQuery(String string) {
        return "(SELECT 0 FROM SYS.DUAL WHERE NOT EXISTS (SELECT NULL FROM " + QueryUtils.getLocalNamespaceDollarName(string) + " where rownum < 1))";
    }

    private static String wrapUnescape(String string) {
        return "(CASE WHEN INSTR(" + string + ",'\\') > 0 THEN " + "SEM_APIS.unescape_rdf_value" + "(" + string + ") ELSE " + string + " END)";
    }

    private static boolean isStrForVar(SimpleNode simpleNode, Map<String, String> map, SQLGenContext sQLGenContext) throws RDFException {
        boolean bl = false;
        SimpleNode simpleNode2 = simpleNode;
        if (simpleNode2.id == 56) {
            simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(0);
        }
        if (simpleNode2.id == 88) {
            ASTBuiltInCall aSTBuiltInCall = (ASTBuiltInCall)simpleNode2;
            if (aSTBuiltInCall.name.equals(STR_OP) && Filter.getNodeRetType((SimpleNode)simpleNode2.jjtGetChild(0), map, sQLGenContext) == 4) {
                bl = true;
            }
        }
        return bl;
    }

    public Filter(SimpleNode simpleNode, SQLGenContext sQLGenContext) {
        this(simpleNode, sQLGenContext, null);
    }

    public Filter(SimpleNode simpleNode, SQLGenContext sQLGenContext, ASTTripleAtom aSTTripleAtom) {
        this.filterRoot = simpleNode;
        this.ctx = sQLGenContext;
        this.lexVars = new HashSet<String>();
        this.inScopeVars = new HashSet<String>();
        this.pfInScopeVars = new HashSet<String>();
        this.depVars = new HashSet<String>();
        this.specialCases = 0;
        this.pushCnt = 0;
        this.pushedToJoin = false;
        this.wrapForHaving = false;
        this.activeGraph = aSTTripleAtom;
        this.groupByVars = null;
        this.defBoundVars = new HashSet<String>();
        this.currGpSQL = null;
        this.gpVars = null;
        this.gpProjVars = null;
        this.gpLexVars = null;
        this.gpNonPushVars = null;
        this.secondaryExtracted = false;
        this.nestedFuncExists = false;
        this.values_tab = QueryUtils.escapeSingleQuotes(QueryUtils.getLocalValueDollarName(sQLGenContext.clnPfxForRdfObjName));
        this.netNamePfx = QueryUtils.getNetworkNamePfx(sQLGenContext.clnNetworkName);
        this.netOwner = QueryUtils.escapeSingleQuotes(sQLGenContext.clnNetworkOwner);
        this.spmValueColMapping = null;
    }

    public void setSQLGenCtx(SQLGenContext sQLGenContext) {
        this.ctx = sQLGenContext;
    }

    public void setLexVars(Set<String> set) {
        this.lexVars.addAll(set);
    }

    public void setSpmValueColMapping(Map<String, String> map) {
        this.spmValueColMapping = map;
    }

    private String getSpmMappedValueCol(String string) {
        String string2 = null;
        if (this.spmValueColMapping != null) {
            string2 = this.spmValueColMapping.get(string);
        }
        return string2 == null ? string : string2;
    }

    public Set<String> getRequiredLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        Set<String> set = Collections.emptySet();
        Set<String> set2 = Collections.emptySet();
        Stack<Node> stack = new Stack<Node>();
        stack.push(this.filterRoot);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            if (OptimizerUtils.isExistsNode((SimpleNode)node)) {
                try {
                    SPARQLTreeNode sPARQLTreeNode = SPARQLEngine.buildSPARQLTree(node, this.ctx, this.activeGraph, set, set2, null);
                    hashSet.addAll(sPARQLTreeNode.getRequiredLexVars());
                }
                catch (RDFException rDFException) {
                    rDFException.printStackTrace();
                }
                continue;
            }
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                stack.push(node.jjtGetChild(i));
            }
        }
        return hashSet;
    }

    public boolean isCoalesceNonLexSpecialCase() {
        return this.isCoalesceNonLexSpecialCase(this.lexVars);
    }

    public boolean isCoalesceNonLexSpecialCase(Set<String> set) {
        if (this.filterRoot != null) {
            SimpleNode simpleNode = this.filterRoot;
            if (simpleNode.id == 88) {
                ASTBuiltInCall aSTBuiltInCall = (ASTBuiltInCall)simpleNode;
                if (aSTBuiltInCall.name.equals(COALESCE_OP)) {
                    for (int i = 0; i < aSTBuiltInCall.jjtGetNumChildren(); ++i) {
                        SimpleNode simpleNode2 = (SimpleNode)aSTBuiltInCall.jjtGetChild(i);
                        if (simpleNode2.id == 73) {
                            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode2;
                            if (aSTTripleAtom.type == 0 && !set.contains(aSTTripleAtom.name)) continue;
                            return false;
                        }
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsExists() {
        Stack<Node> stack = new Stack<Node>();
        stack.push(this.filterRoot);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            if (OptimizerUtils.isExistsNode((SimpleNode)node)) {
                return true;
            }
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                stack.push(node.jjtGetChild(i));
            }
        }
        return false;
    }

    public Filter extractSecondaryFilter() {
        this.secondaryExtracted = true;
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        stack.push(this.filterRoot);
        while (!stack.empty()) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (simpleNode.id == 90 && simpleNode.jjtGetNumChildren() == 4) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode.jjtGetChild(0);
                if (aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/geo/sdoJoin")) {
                    ASTRelationalExpression aSTRelationalExpression = new ASTRelationalExpression(80);
                    aSTRelationalExpression.jjtSetInitCapacity(3);
                    ASTIRIrefOrFunction aSTIRIrefOrFunction = new ASTIRIrefOrFunction(90);
                    aSTRelationalExpression.jjtAddChild(aSTIRIrefOrFunction, 0);
                    aSTIRIrefOrFunction.jjtSetParent(aSTRelationalExpression);
                    aSTIRIrefOrFunction.jjtSetInitCapacity(4);
                    ASTTripleAtom aSTTripleAtom2 = new ASTTripleAtom(73);
                    aSTTripleAtom2.type = 1;
                    aSTTripleAtom2.name = "http://xmlns.oracle.com/rdf/geo/funcRelate";
                    aSTTripleAtom2.jjtSetParent(aSTIRIrefOrFunction);
                    aSTIRIrefOrFunction.jjtAddChild(aSTTripleAtom2, 0);
                    SimpleNode simpleNode2 = (SimpleNode)((SimpleNode)simpleNode.jjtGetChild(1)).cloneNode();
                    simpleNode2.jjtSetParent(aSTIRIrefOrFunction);
                    aSTIRIrefOrFunction.jjtAddChild(simpleNode2, 1);
                    SimpleNode simpleNode3 = (SimpleNode)((SimpleNode)simpleNode.jjtGetChild(2)).cloneNode();
                    simpleNode3.jjtSetParent(aSTIRIrefOrFunction);
                    aSTIRIrefOrFunction.jjtAddChild(simpleNode3, 2);
                    SimpleNode simpleNode4 = (SimpleNode)((SimpleNode)simpleNode.jjtGetChild(3)).cloneNode();
                    simpleNode4.jjtSetParent(aSTIRIrefOrFunction);
                    aSTIRIrefOrFunction.jjtAddChild(simpleNode4, 3);
                    ASTComparisonOperator aSTComparisonOperator = new ASTComparisonOperator(81);
                    aSTComparisonOperator.name = "=";
                    aSTRelationalExpression.jjtAddChild(aSTComparisonOperator, 1);
                    aSTComparisonOperator.jjtSetParent(aSTRelationalExpression);
                    ASTTripleAtom aSTTripleAtom3 = new ASTTripleAtom(73);
                    aSTTripleAtom3.name = ((ASTTripleAtom)simpleNode4).name.toUpperCase().trim();
                    aSTTripleAtom3.type = 3;
                    aSTRelationalExpression.jjtAddChild(aSTTripleAtom3, 2);
                    aSTTripleAtom3.jjtSetParent(aSTRelationalExpression);
                    return this.cloneForAST(aSTRelationalExpression);
                }
                if (aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/geo/sdoDistJoin")) {
                    ASTIRIrefOrFunction aSTIRIrefOrFunction = new ASTIRIrefOrFunction(90);
                    aSTIRIrefOrFunction.jjtSetInitCapacity(4);
                    ASTTripleAtom aSTTripleAtom4 = new ASTTripleAtom(73);
                    aSTTripleAtom4.type = 1;
                    aSTTripleAtom4.name = "http://xmlns.oracle.com/rdf/geo/idxWithinDistance";
                    aSTTripleAtom4.jjtSetParent(aSTIRIrefOrFunction);
                    aSTIRIrefOrFunction.jjtAddChild(aSTTripleAtom4, 0);
                    SimpleNode simpleNode5 = (SimpleNode)((SimpleNode)simpleNode.jjtGetChild(1)).cloneNode();
                    simpleNode5.jjtSetParent(aSTIRIrefOrFunction);
                    aSTIRIrefOrFunction.jjtAddChild(simpleNode5, 1);
                    SimpleNode simpleNode6 = (SimpleNode)((SimpleNode)simpleNode.jjtGetChild(2)).cloneNode();
                    simpleNode6.jjtSetParent(aSTIRIrefOrFunction);
                    aSTIRIrefOrFunction.jjtAddChild(simpleNode6, 2);
                    SimpleNode simpleNode7 = (SimpleNode)((SimpleNode)simpleNode.jjtGetChild(3)).cloneNode();
                    simpleNode7.jjtSetParent(aSTIRIrefOrFunction);
                    aSTIRIrefOrFunction.jjtAddChild(simpleNode7, 3);
                    return this.cloneForAST(aSTIRIrefOrFunction);
                }
            }
            int n = simpleNode.jjtGetNumChildren();
            for (int i = n - 1; i >= 0; --i) {
                SimpleNode simpleNode8 = (SimpleNode)simpleNode.jjtGetChild(i);
                stack.push(simpleNode8);
            }
        }
        return null;
    }

    public List<String> getSecondaryJoinVars() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        stack.push(this.filterRoot);
        while (!stack.empty()) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (simpleNode.id == 90 && simpleNode.jjtGetNumChildren() == 4) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode.jjtGetChild(0);
                if (aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/geo/funcRelate") || aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/geo/idxWithinDistance")) {
                    SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(1);
                    if (simpleNode2.id == 73) {
                        arrayList.add(((ASTTripleAtom)simpleNode2).name);
                    }
                    SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(2);
                    if (simpleNode3.id == 73) {
                        arrayList.add(((ASTTripleAtom)simpleNode3).name);
                    }
                }
            }
            int n = simpleNode.jjtGetNumChildren();
            for (int i = n - 1; i >= 0; --i) {
                SimpleNode simpleNode4 = (SimpleNode)simpleNode.jjtGetChild(i);
                stack.push(simpleNode4);
            }
        }
        return arrayList;
    }

    public List<String[]> extractAncInfoForPrim() throws RDFException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        stack.push(this.filterRoot);
        while (!stack.empty()) {
            SimpleNode simpleNode;
            SimpleNode simpleNode2 = (SimpleNode)stack.pop();
            if (simpleNode2.id == 90 && simpleNode2.jjtGetNumChildren() == 4) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode2.jjtGetChild(0);
                if (aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/textContains")) {
                    simpleNode = (SimpleNode)simpleNode2.jjtGetChild(3);
                    if (simpleNode.id == 73) {
                        ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)simpleNode;
                        String string = "";
                        try {
                            string = Integer.toString(Integer.parseInt(aSTTripleAtom2.name));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new RDFException("Invalid invocation id argument for http://xmlns.oracle.com/rdf/textContains");
                        }
                        String[] stringArray = new String[]{"SCORE", string};
                        arrayList.add(stringArray);
                    }
                }
            }
            int n = simpleNode2.jjtGetNumChildren();
            for (int i = n - 1; i >= 0; --i) {
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(i);
                stack.push(simpleNode);
            }
        }
        return arrayList;
    }

    public List<String[]> extractAncInfoForAnc() throws RDFException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        stack.push(this.filterRoot);
        while (!stack.empty()) {
            SimpleNode simpleNode;
            SimpleNode simpleNode2 = (SimpleNode)stack.pop();
            if (simpleNode2.id == 90 && simpleNode2.jjtGetNumChildren() == 2) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode2.jjtGetChild(0);
                if (aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/textScore")) {
                    simpleNode = (SimpleNode)simpleNode2.jjtGetChild(1);
                    if (simpleNode.id == 73) {
                        ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)simpleNode;
                        String string = "";
                        try {
                            string = Integer.toString(Integer.parseInt(aSTTripleAtom2.name));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new RDFException("Invalid invocation id argument for http://xmlns.oracle.com/rdf/textScore");
                        }
                        String[] stringArray = new String[]{"SCORE", string};
                        arrayList.add(stringArray);
                    }
                }
            }
            int n = simpleNode2.jjtGetNumChildren();
            for (int i = n - 1; i >= 0; --i) {
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(i);
                stack.push(simpleNode);
            }
        }
        return arrayList;
    }

    public void clearLexVars() {
        this.lexVars.clear();
    }

    public void setInScopeVars(Set<String> set, Set<String> set2) {
        this.inScopeVars.addAll(set);
        this.pfInScopeVars.addAll(set2);
    }

    public void setDefBoundVars(Set<String> set) {
        this.defBoundVars.addAll(set);
    }

    public void setCurrSQL(String string, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) {
        this.currGpSQL = string;
        this.gpVars = set;
        this.gpProjVars = set2;
        this.gpLexVars = set3;
        this.gpNonPushVars = set4;
    }

    public void init() {
        this.extractVars();
        this.setFlags();
    }

    public Filter cloneForAST(SimpleNode simpleNode) {
        Filter filter = new Filter(simpleNode, this.ctx);
        for (String string : this.getDepVars()) {
            filter.addDepVar(new String(string));
        }
        filter.setLexVars(this.lexVars);
        filter.setInScopeVars(this.inScopeVars, this.pfInScopeVars);
        filter.init();
        filter.setSpecialCase(this.getSpecialCaseFlags());
        filter.setPushCnt(this.getPushCnt());
        filter.setPushedToJoin(this.getPushedToJoin());
        filter.setWrapForHaving(this.getWrapForHaving());
        filter.setDefBoundVars(this.defBoundVars);
        filter.secondaryExtracted = false;
        return filter;
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleNode simpleNode = (SimpleNode)this.filterRoot.cloneSubTree();
        return this.cloneForAST(simpleNode);
    }

    public boolean containsConstant() {
        boolean bl = false;
        if (this.filterRoot != null) {
            Stack<SimpleNode> stack = new Stack<SimpleNode>();
            stack.push(this.filterRoot);
            while (!stack.empty() && !bl) {
                SimpleNode simpleNode = (SimpleNode)stack.pop();
                if (simpleNode.id == 73) {
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                    if (aSTTripleAtom.type == 0) continue;
                    bl = true;
                    continue;
                }
                for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                    stack.push((SimpleNode)simpleNode.jjtGetChild(i));
                }
            }
        }
        return bl;
    }

    private String wrapVColForAgg(String string, String string2, boolean bl, boolean bl2) {
        if (this.groupByVars != null && this.groupByVars.contains(string) && (!bl || this.lexVars.contains(string))) {
            if (bl2) {
                return "NULL";
            }
            return "MIN (" + string2 + ")";
        }
        return string2;
    }

    private void updateAliasesForBindVars(Map<String, String> map, Map<String, String> map2) {
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            map.put(bindVar.bvName, bindVar.getTermCol());
        }
        if (map2 != null) {
            for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
                map2.put(bindVar.bvName, bindVar.getIdCol());
            }
        }
    }

    private void setFlags() {
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        boolean bl = false;
        stack.push(this.filterRoot);
        while (!stack.empty() && !bl) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (simpleNode.id == 88 && this.hasNestedInput(simpleNode)) {
                bl = true;
            }
            if (bl) continue;
            int n = simpleNode.jjtGetNumChildren();
            for (int i = n - 1; i >= 0; --i) {
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                stack.push(simpleNode2);
            }
        }
        this.nestedFuncExists = bl;
    }

    private void extractVars() {
        this.vars = new HashSet<String>();
        this.fJoinVars = new HashSet<String>();
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        this.bindVars = new HashSet<ASTTripleAtom.BindVar>();
        stack.push(this.filterRoot);
        while (!stack.empty()) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (OptimizerUtils.isExistsNode(simpleNode)) {
                try {
                    SPARQLTreeNode sPARQLTreeNode = SPARQLEngine.buildSPARQLTree(simpleNode, this.ctx, this.activeGraph, this.inScopeVars, this.pfInScopeVars, null);
                    try {
                        SPARQLEngine.prepareSTreeForTrans(sPARQLTreeNode, this.ctx, this.lexVars);
                    }
                    catch (TypeException typeException) {
                        throw new RDFException(typeException.getMessage());
                    }
                    for (Filter filter : sPARQLTreeNode.getNonLocalFilters()) {
                        this.vars.addAll(QueryUtils.getCommonVars(filter.getVars(), this.inScopeVars));
                        this.fJoinVars.addAll(QueryUtils.getCommonVars(filter.getfJoinVars(), this.inScopeVars));
                    }
                    this.vars.addAll(QueryUtils.getCommonVars(sPARQLTreeNode.getCumulativeVars(), this.inScopeVars));
                    this.fJoinVars.addAll(QueryUtils.getCommonVars(sPARQLTreeNode.getRequiredLexVars(), this.inScopeVars));
                }
                catch (RDFException rDFException) {
                    rDFException.printStackTrace();
                }
                continue;
            }
            if (simpleNode.id == 73) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                if (aSTTripleAtom.type == 9) {
                    this.bindVars.add(aSTTripleAtom.getBindVar());
                } else if (aSTTripleAtom.type == 0) {
                    this.vars.add(aSTTripleAtom.name);
                    boolean bl = false;
                    Node node = aSTTripleAtom.jjtGetParent();
                    if (this.isNonLex(aSTTripleAtom)) {
                        Node node2;
                        Node node3;
                        Node node4;
                        if ((this.ctx.filterFlags & 4) == 0 && node != null && ((SimpleNode)node).id == 80 && node.jjtGetNumChildren() > 2) {
                            node4 = node.jjtGetChild(0);
                            node3 = node.jjtGetChild(1);
                            node2 = node.jjtGetChild(2);
                            if (((SimpleNode)node4).id == 73 && ((SimpleNode)node3).id == 81 && ((SimpleNode)node2).id == 73) {
                                ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)node4;
                                ASTComparisonOperator aSTComparisonOperator = (ASTComparisonOperator)node3;
                                ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)node2;
                                String string = aSTComparisonOperator.name;
                                boolean bl2 = false;
                                if (string.contains(IN_OP)) {
                                    if (!Filter.isVarAtom(aSTTripleAtom2.type)) {
                                        bl2 = true;
                                    }
                                    String string2 = string = string.equals(IN_OP) ? "=" : "!=";
                                }
                                if (!bl2 && (Filter.isVarAtom(aSTTripleAtom2.type) && this.isNonLex(aSTTripleAtom2) && this.isSafeForVIDComp(aSTTripleAtom3, string) || Filter.isVarAtom(aSTTripleAtom3.type) && this.isNonLex(aSTTripleAtom3) && this.isSafeForVIDComp(aSTTripleAtom2, string)) && (string.equals("=") || string.equals("!="))) {
                                    bl = true;
                                }
                                if (bl) {
                                    for (int i = 3; i < node.jjtGetNumChildren(); ++i) {
                                        if (((SimpleNode)node.jjtGetChild((int)i)).id != 73) {
                                            bl = false;
                                            continue;
                                        }
                                        ASTTripleAtom aSTTripleAtom4 = (ASTTripleAtom)node.jjtGetChild(i);
                                        if ((Filter.isVarAtom(aSTTripleAtom2.type) && this.isNonLex(aSTTripleAtom2) && this.isSafeForVIDComp(aSTTripleAtom4, string) || Filter.isVarAtom(aSTTripleAtom4.type) && this.isNonLex(aSTTripleAtom4) && this.isSafeForVIDComp(aSTTripleAtom2, string)) && (string.equals("=") || string.equals("!="))) continue;
                                        bl = false;
                                    }
                                }
                            }
                        } else if (node != null && ((SimpleNode)node).id == 89) {
                            ASTAggregate aSTAggregate = (ASTAggregate)node;
                            if (aSTAggregate.name.equals("COUNT") && (this.ctx.filterFlags & 4) == 0 && aSTAggregate.jjtGetNumChildren() == 1) {
                                node4 = aSTAggregate.jjtGetChild(0);
                                if (((SimpleNode)node4).id == 73 && Filter.isVarAtom(((ASTTripleAtom)node4).type)) {
                                    bl = true;
                                }
                            }
                        } else if (node != null && ((SimpleNode)node).id == 88) {
                            ASTBuiltInCall aSTBuiltInCall = (ASTBuiltInCall)node;
                            if (aSTBuiltInCall.name.equals(BOUND_OP) && ((this.ctx.filterFlags & 4) == 0 || this.ctx.usingTopDownTrans)) {
                                bl = true;
                            } else if (aSTBuiltInCall.name.equals(SAMETERM_OP) && (this.ctx.filterFlags & 4) == 0 && aSTBuiltInCall.jjtGetNumChildren() == 2) {
                                node4 = aSTBuiltInCall.jjtGetChild(0);
                                node3 = aSTBuiltInCall.jjtGetChild(1);
                                if (this.isNonLex((SimpleNode)node4) && this.isNonLex((SimpleNode)node3) && ((SimpleNode)node4).id == 73 && ((SimpleNode)node3).id == 73) {
                                    if (Filter.isVarAtom(((ASTTripleAtom)node4).type) && (((ASTTripleAtom)node3).type == 1 || ((ASTTripleAtom)node3).type == 3 || Filter.isVarAtom(((ASTTripleAtom)node3).type))) {
                                        bl = true;
                                    } else if (Filter.isVarAtom(((ASTTripleAtom)node3).type) && (((ASTTripleAtom)node4).type == 1 || ((ASTTripleAtom)node4).type == 3 || Filter.isVarAtom(((ASTTripleAtom)node4).type))) {
                                        bl = true;
                                    }
                                }
                            }
                        } else if (node != null && ((SimpleNode)node).id == 90 && node.jjtGetNumChildren() == 3) {
                            node4 = node.jjtGetChild(0);
                            if (((SimpleNode)node4).id == 73 && ((ASTTripleAtom)node4).type == 1) {
                                if (((ASTTripleAtom)node4).name.equals(FUNC_HASVID_OP)) {
                                    bl = true;
                                } else if (((ASTTripleAtom)node4).name.equals(FUNC_SAMECTERM_OP)) {
                                    node3 = node.jjtGetChild(1);
                                    node2 = (SimpleNode)node.jjtGetChild(2);
                                    if ((((SimpleNode)node3).id == 73 && Filter.isVarAtom(((ASTTripleAtom)node3).type) || ((SimpleNode)node2).id == 73 && Filter.isVarAtom(((ASTTripleAtom)node2).type)) && this.useVID((SimpleNode)node3, (SimpleNode)node2)) {
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                    if (!bl) {
                        this.fJoinVars.add(aSTTripleAtom.name);
                    }
                }
            }
            int n = simpleNode.jjtGetNumChildren();
            for (int i = n - 1; i >= 0; --i) {
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                stack.push(simpleNode2);
            }
        }
    }

    public String toString() {
        if (this.vars == null) {
            this.extractVars();
        }
        String string = "";
        string = string + "Filter: " + this.filterRoot.dumpToStr("") + "\n";
        string = string + "isLocal: " + ((this.specialCases & 1) > 0) + "\n";
        string = string + "usesBound: " + ((this.specialCases & 2) > 0) + "\n";
        string = string + "Vars:";
        for (String string2 : this.vars) {
            string = string + " " + string2;
        }
        string = string + "\n";
        string = string + "Dependent Vars:";
        for (String string2 : this.depVars) {
            string = string + " " + string2;
        }
        string = string + "\n";
        return string;
    }

    public String toString(String string) {
        if (this.vars == null) {
            this.extractVars();
        }
        String string2 = "";
        string2 = string2 + string + "Filter: " + this.filterRoot.dumpToStr(string) + "\n";
        string2 = string2 + string + "Vars:";
        for (String string3 : this.vars) {
            string2 = string2 + " " + string3;
        }
        string2 = string2 + "\n";
        string2 = string2 + string + "LexicalVars:";
        for (String string3 : this.lexVars) {
            string2 = string2 + " " + string3;
        }
        string2 = string2 + "\n";
        string2 = string2 + string + "fJoinVars:";
        for (String string3 : this.fJoinVars) {
            string2 = string2 + " " + string3;
        }
        string2 = string2 + "\n";
        return string2;
    }

    public void setIsLocal(Set<String> set) {
        boolean bl = true;
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        stack.push(this.filterRoot);
        while (!stack.empty() && bl) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (simpleNode.id == 73) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                if (Filter.isVarAtom(aSTTripleAtom.type) && !set.contains(aSTTripleAtom.name)) {
                    bl = false;
                }
            }
            int n = simpleNode.jjtGetNumChildren();
            for (int i = n - 1; i >= 0; --i) {
                stack.push((SimpleNode)simpleNode.jjtGetChild(i));
            }
        }
        if (bl) {
            this.setSpecialCase(1);
        }
    }

    public void setUsesBound() {
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        boolean bl = false;
        stack.push(this.filterRoot);
        while (!stack.empty() && !bl) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (simpleNode.id == 88) {
                ASTBuiltInCall aSTBuiltInCall = (ASTBuiltInCall)simpleNode;
                if (aSTBuiltInCall.name.equals(BOUND_OP)) {
                    bl = true;
                }
            }
            int n = simpleNode.jjtGetNumChildren();
            for (int i = n - 1; i >= 0; --i) {
                stack.push((SimpleNode)simpleNode.jjtGetChild(i));
            }
        }
        if (bl) {
            this.setSpecialCase(2);
        }
    }

    public String toSQL(Map<String, String> map, Map<String, String> map2, Map<String, FilterFuncHandler> map3) throws RDFException {
        return this.toSQL(map, null, map2, map3);
    }

    public String toSQL(Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4) throws RDFException {
        return this.getEBVSQL(this.filterRoot, this.filterToSQL(this.filterRoot, map, map2, map3, map4), map3, map2);
    }

    public String[] toSelectExprSQL(String string, Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4) throws RDFException {
        String[] stringArray;
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String[] stringArray5 = new String[1];
        String[] stringArray6 = new String[1];
        String[] stringArray7 = new String[1];
        String string2 = this.filterToSQL(this.filterRoot, map, map2, map3, map4, false);
        String string3 = string;
        int n = Filter.getNodeRetType(this.filterRoot, map3, this.ctx);
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (n == 25) {
            string7 = this.wrapSQLforGEOMtoCLOB(string);
            string4 = "TO_NUMBER(NULL)";
            stringArray2[0] = "NVL2(" + string3 + ",'LIT',NULL)";
            stringArray3[0] = this.wrapSQLforCLOBcomp(string3, null, "'http://www.opengis.net/ont/geosparql#wktLiteral'");
            stringArray4[0] = "''";
            stringArray5[0] = "NVL2(" + string3 + ",'" + "http://www.opengis.net/ont/geosparql#wktLiteral" + "',NULL)";
            stringArray6[0] = "''";
            stringArray7[0] = string3;
            stringArray = this.wrapSQLforCLOBcomp(string3, null, "'http://www.opengis.net/ont/geosparql#wktLiteral'");
            string5 = "MDSYS.SDO_RDF_TERM(" + stringArray2[0] + "," + (String)stringArray + "," + stringArray5[0] + "," + stringArray6[0] + "," + stringArray7[0] + ",1)";
            if (!this.ctx.useExactForExpr) {
                string5 = string5 + SRT_TO_CANON_TERM;
            }
            String string8 = RDFT_VDOLLAR_FUNC;
            if (!this.ctx.useExactForExpr) {
                string8 = RDFT_CANON_TERM_FUNC;
            }
            string6 = string8 + "(" + (String)stringArray + "," + stringArray2[0] + "," + stringArray5[0] + "," + stringArray6[0] + ")";
        } else if (n == 2) {
            boolean bl = false;
            string2 = this.filterRoot.id == 88 && (((ASTBuiltInCall)this.filterRoot).name.equals(EXISTS_OP) || ((ASTBuiltInCall)this.filterRoot).name.equals(NOT_EXISTS_OP)) ? this.wrapSQLforBooleanNoNullNoQuotes(string2) : this.wrapSQLforBooleanNoQuotes(string2);
            string7 = string;
            string4 = "TO_NUMBER(NULL)";
            stringArray2[0] = "NVL2(" + string3 + ",'LIT',NULL)";
            stringArray3[0] = string3;
            stringArray4[0] = "''";
            stringArray5[0] = "NVL2(" + string3 + ",'" + "http://www.w3.org/2001/XMLSchema#boolean" + "',NULL)";
            stringArray6[0] = "''";
            stringArray7[0] = "TO_CLOB(NULL)";
            string5 = "MDSYS.SDO_RDF_TERM(" + stringArray2[0] + "," + stringArray3[0] + "," + stringArray5[0] + "," + stringArray6[0] + "," + stringArray7[0] + ",1)";
            string6 = "sem_apis.compose_rdf_term(" + stringArray3[0] + "," + stringArray2[0] + "," + stringArray5[0] + "," + stringArray6[0] + ")";
        } else {
            if (n == 4 || n == 12) {
                string3 = string2;
            }
            string7 = string;
            this.decomposeRDFTerm(this.filterRoot, string3, map3, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, map2);
            stringArray2[0] = Filter.genValTypeCaseStmt(stringArray2[0]);
            string4 = "TO_NUMBER(NULL)";
            if (this.isCoalesceNonLexSpecialCase()) {
                string4 = this.buildIdForCoalesceNonLex(map2);
            }
            if (this.filterRoot.id == 73) {
                stringArray = (ASTTripleAtom)this.filterRoot;
                String string9 = null;
                switch (stringArray.type) {
                    case 9: {
                        string9 = stringArray.getBindVar().getIdCol();
                        break;
                    }
                    case 1: {
                        string9 = this.ctx.URImap.get(stringArray.name);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string9 = this.ctx.litMap.get((ASTTripleAtom)stringArray);
                    }
                }
                if (string9 != null) {
                    string4 = string9;
                }
            }
            string5 = this.ctx.useExactForExpr ? this.toSDORDFTobj(string, map, map2, map3, map4) : this.toCanonSDORDFTobj(string, map, map2, map3, map4);
            string6 = this.toVCTermForSelExpr(string, this.ctx.useExactForExpr, map, map2, map3, map4);
        }
        stringArray = new String[]{string4, stringArray2[0], stringArray3[0], stringArray4[0], stringArray5[0], stringArray6[0], stringArray7[0], string5, string6, string2, string7};
        return stringArray;
    }

    public String toSDORDFTobj(String string, Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4) throws RDFException {
        String string2 = "";
        int n = Filter.getNodeRetType(this.filterRoot, map3, this.ctx);
        String string3 = string;
        if (n == 4 || n == 2 || n == 12) {
            string3 = this.filterToSQL(this.filterRoot, map, map2, map3, map4, false);
        }
        string2 = n == 27 ? string3 : (n == 28 ? "MDSYS.SDO_RDF_TERM(" + string3 + ")" : this.genRDFtermObj(this.filterRoot, string3, map3, map2));
        return string2;
    }

    public String toCanonSDORDFTobj(String string, Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4) throws RDFException {
        String string2 = this.toSDORDFTobj(string, map, map2, map3, map4);
        string2 = string2 + SRT_TO_CANON_TERM;
        return string2;
    }

    public String toVCTermForSelExpr(String string, boolean bl, Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4) throws RDFException {
        String string2 = "";
        String string3 = SRT_TO_CANON_VC_TERM;
        String string4 = RDFT_CANON_TERM_FUNC;
        if (bl) {
            string3 = SRT_TO_VC_TERM;
            string4 = RDFT_VDOLLAR_FUNC;
        }
        int n = Filter.getNodeRetType(this.filterRoot, map3, this.ctx);
        String string5 = string;
        if (n == 4 || n == 2 || n == 12) {
            string5 = this.filterToSQL(this.filterRoot, map, map2, map3, map4, false);
        }
        string2 = !bl ? (n == 28 ? (!bl && this.filterRoot.id == 89 && ((ASTAggregate)this.filterRoot).name.equals(SAMPLE_OP) ? this.buildVDollarFuncCall(string4, this.filterRoot, string5, map3, map2) : string5) : (n == 27 ? string5 + string3 : (this.isRDFViewOptCase(this.filterRoot, string5) ? this.getTermForVar(((ASTTripleAtom)this.filterRoot).name, string5, map2) : this.buildVDollarFuncCall(string4, this.filterRoot, string5, map3, map2)))) : (this.ctx.clobExpSupport ? (n == 27 ? string5 + string3 : this.buildVDollarFuncCall(string4, this.filterRoot, string5, map3, map2)) : this.buildInLineTermExpr(this.filterRoot, string5, map3, map2, true, false));
        return string2;
    }

    public String toOrderBySQL(Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4, String string, String string2) throws RDFException {
        String string3 = this.filterToSQL(this.filterRoot, map, map2, map3, map4, true);
        int n = Filter.getNodeRetType(this.filterRoot, map3, this.ctx);
        switch (n) {
            case 21: 
            case 23: {
                string3 = this.wrapSQLforCLOBcomp(string3, null, "'http://www.opengis.net/ont/geosparql#wktLiteral'");
                break;
            }
            case 25: {
                string3 = this.wrapSQLforGEOMtoVC(string3);
                break;
            }
            case 2: {
                string3 = this.wrapSQLforBoolean(string3);
                break;
            }
            case 8: {
                if (this.ctx.unescapeStrFunc && !this.ctx.networkStorageForm.equals("UNESC")) {
                    string3 = Filter.isStrForVar(this.filterRoot, map3, this.ctx) ? Filter.wrapUnescape(string3) : "SEM_APIS.unescape_rdf_value(" + string3 + ")";
                }
                string3 = this.wrapSQLforLit(string3, null, null, true);
                break;
            }
            case 5: {
                string3 = this.wrapSQLforURI(string3);
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 29: 
            case 30: 
            case 31: {
                string3 = QueryUtils.wrapSQLforNumeric(string3);
                break;
            }
            case 27: 
            case 28: {
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                if (n == 27) {
                    string4 = string3 + "." + "VALUE_NAME";
                    if (this.ctx.unescapeStrFunc && !this.ctx.networkStorageForm.equals("UNESC")) {
                        string4 = Filter.wrapUnescape(string4);
                    }
                    string5 = string3 + "." + "VALUE_TYPE";
                    string6 = string3 + "." + "LITERAL_TYPE";
                    string7 = string3 + "." + "LANGUAGE_TYPE";
                    string8 = string3 + "." + "VALUE_TYPE" + ", " + string3 + "." + "VALUE_NAME" + ", ''," + string3 + "." + "LITERAL_TYPE" + ", " + string3 + "." + "LANGUAGE_TYPE";
                } else if (n == 28) {
                    String[] stringArray = new String[1];
                    String[] stringArray2 = new String[1];
                    String[] stringArray3 = new String[1];
                    String[] stringArray4 = new String[1];
                    String[] stringArray5 = new String[1];
                    String[] stringArray6 = new String[1];
                    this.decomposeRDFTerm(this.filterRoot, string3, map3, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, map2);
                    string4 = "MDSYS.SDO_RDF.VNAME(" + string3 + ")";
                    if (this.ctx.unescapeStrFunc && !this.ctx.networkStorageForm.equals("UNESC")) {
                        string4 = Filter.wrapUnescape(string4);
                    }
                    string5 = stringArray[0];
                    string6 = stringArray4[0];
                    string7 = stringArray5[0];
                    string8 = stringArray[0] + ", " + string4 + ", ''," + stringArray4[0] + ", " + stringArray5[0];
                }
                string3 = "CASE WHEN (" + string5 + " IS NULL) THEN 0\nWHEN (" + string5 + " IN ('BLN','BN')) THEN 1\nWHEN (" + string5 + " IN ('URI','UR')) THEN 2\nWHEN (" + string5 + " IN ('PL', 'PLL', 'CPLL', 'PL@', 'PLL@', 'CPLL@', 'TL', 'TLL', 'CTLL', 'LIT'))\nTHEN (CASE WHEN (" + string7 + " IS NOT NULL) THEN 5\nWHEN (" + string6 + " IS NOT NULL) THEN 4\nELSE 3 END)\nELSE NULL END " + string2 + ",\nCASE WHEN (" + string6 + " IN " + "('http://www.w3.org/2001/XMLSchema#decimal','http://www.w3.org/2001/XMLSchema#double','http://www.w3.org/2001/XMLSchema#integer','http://www.w3.org/2001/XMLSchema#float','http://www.w3.org/2001/XMLSchema#int','http://www.w3.org/2001/XMLSchema#nonPositiveInteger','http://www.w3.org/2001/XMLSchema#negativeInteger','http://www.w3.org/2001/XMLSchema#long','http://www.w3.org/2001/XMLSchema#short','http://www.w3.org/2001/XMLSchema#byte','http://www.w3.org/2001/XMLSchema#nonNegativeInteger','http://www.w3.org/2001/XMLSchema#unsignedLong','http://www.w3.org/2001/XMLSchema#unsignedInt','http://www.w3.org/2001/XMLSchema#unsignedShort','http://www.w3.org/2001/XMLSchema#unsignedByte','http://www.w3.org/2001/XMLSchema#positiveInteger')" + ")\nTHEN " + NUMERIC_VDOLLAR_FUNC + "(" + string8 + ")\nELSE NULL END " + string2 + ",\nCASE WHEN (" + string6 + " IN " + "('http://www.w3.org/2001/XMLSchema#date','http://www.w3.org/2001/XMLSchema#time','http://www.w3.org/2001/XMLSchema#dateTime')" + ")\nTHEN " + "sem_apis.getV$CalendarOrderVal" + "(" + string8 + "," + string + ")\nELSE NULL END " + string2 + ",\n(" + string4 + ") ";
                break;
            }
            default: {
                string3 = "'a'";
            }
        }
        return string3;
    }

    public String toGroupBySQL(Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4) throws RDFException {
        String string = this.filterToSQL(this.filterRoot, map, map2, map3, map4, true);
        int n = Filter.getNodeRetType(this.filterRoot, map3, this.ctx);
        switch (n) {
            case 27: {
                if (this.ctx.useExactForExpr) {
                    string = string + SRT_TO_VC_TERM;
                    break;
                }
                string = string + ".COMPARE()";
                break;
            }
            case 28: {
                break;
            }
            default: {
                String string2 = RDFT_CANON_TERM_FUNC;
                if (this.ctx.useExactForExpr) {
                    string2 = RDFT_VDOLLAR_FUNC;
                }
                string = this.isRDFViewOptCase(this.filterRoot, string) ? this.getTermForVar(((ASTTripleAtom)this.filterRoot).name, string, map2) : this.buildVDollarFuncCall(string2, this.filterRoot, string, map3, map2);
            }
        }
        return string;
    }

    public void validateFilter(Map<String, String> map) throws RDFException, TypeException {
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        int n = 0;
        stack.push(this.filterRoot);
        while (!stack.empty()) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (OptimizerUtils.isExistsNode(simpleNode)) continue;
            switch (simpleNode.id) {
                case 73: {
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                    if (aSTTripleAtom.litType == null) break;
                    if (Filter.litFamily(aSTTripleAtom.litType) == 2) {
                        if (aSTTripleAtom.name.matches("^(-)?\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d(\\.(\\d){0,9})?(Z|(\\+|-)\\d\\d:\\d\\d)?$")) break;
                        throw new TypeException("Invalid dateTime String");
                    }
                    if (Filter.litFamily(aSTTripleAtom.litType) == 3) {
                        if (aSTTripleAtom.name.matches("^(-)?\\d\\d\\d\\d-\\d\\d-\\d\\d(Z|(\\+|-)\\d\\d:\\d\\d)?$")) break;
                        throw new TypeException("Invalid date String");
                    }
                    if (Filter.litFamily(aSTTripleAtom.litType) != 4 || aSTTripleAtom.name.matches("^(T)?\\d\\d:\\d\\d:\\d\\d(\\.(\\d){0,9})?(Z|(\\+|-)\\d\\d:\\d\\d)?$")) break;
                    throw new TypeException("Invalid time String");
                }
                case 82: 
                case 84: {
                    int n2;
                    SimpleNode simpleNode2;
                    for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                        simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
                        n2 = Filter.getNodeRetType(simpleNode2, map, this.ctx);
                        if (n2 != 3 && n2 != 29 && n2 != 31 && n2 != 30 && n2 != 12 && n2 != 0 && n2 != 4 && n2 != 27 && n2 == 28) continue;
                    }
                    break;
                }
                case 86: {
                    int n2;
                    SimpleNode simpleNode2;
                    if (simpleNode.jjtGetNumChildren() == 2) {
                        simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
                        if (((ASTUnaryOperator)simpleNode2).name.equals("!") || (n2 = Filter.getNodeRetType((SimpleNode)simpleNode.jjtGetChild(1), map, this.ctx)) == 3 || n2 == 29 || n2 == 31 || n2 == 30 || n2 == 4 || n2 == 27 || n2 == 28) break;
                        break;
                    }
                    throw new TypeException("Cannot apply unary operator to more than one expression");
                }
                case 80: {
                    int n3;
                    SimpleNode simpleNode3;
                    Object object;
                    if (simpleNode.jjtGetNumChildren() == 3 && ((SimpleNode)simpleNode.jjtGetChild((int)1)).id == 81) {
                        SimpleNode simpleNode4 = (SimpleNode)simpleNode.jjtGetChild(0);
                        object = (ASTComparisonOperator)simpleNode.jjtGetChild(1);
                        simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(2);
                        int n4 = Filter.getNodeRetType(simpleNode4, map, this.ctx);
                        n3 = Filter.getCompFamily(n4);
                        int n5 = Filter.getNodeRetType(simpleNode3, map, this.ctx);
                        int n6 = Filter.getCompFamily(n5);
                        if (n4 != 4 && n5 != 4) {
                            if ((n3 == 1 || n3 == 4) && (n6 == 1 || n6 == 4) || (n3 == 2 || n3 == 5) && (n6 == 2 || n6 == 5) || (n3 == 3 || n3 == 6) && (n6 == 3 || n6 == 6) || n3 == 14 || n6 == 14 || n3 == 15 || n6 == 15) break;
                            if (n3 == n6) {
                                if (n3 == 11 && !((ASTTripleAtom)simpleNode4).litType.equals(((ASTTripleAtom)simpleNode3).litType)) {
                                    throw new TypeException("Comparison of incompatible types in SPARQL expression");
                                }
                                if (((ASTComparisonOperator)object).name.equals("=") || ((ASTComparisonOperator)object).name.equals("!=") || ((ASTComparisonOperator)object).name.contains(IN_OP) || n3 != 9 && n3 != 13) break;
                                throw new TypeException("Comparison of incompatible types in SPARQL expression");
                            }
                            throw new TypeException("Comparison of incompatible types in SPARQL expression");
                        }
                        int n7 = -1;
                        n7 = n4 == 4 && n5 != 4 ? n6 : n3;
                        if (((ASTComparisonOperator)object).name.equals("=") || ((ASTComparisonOperator)object).name.equals("!=") || ((ASTComparisonOperator)object).name.contains(IN_OP) || n7 != 9 && n7 != 13) break;
                        throw new TypeException("Comparison of incompatible types in SPARQL expression");
                    }
                    if (((SimpleNode)simpleNode.jjtGetChild(1)).toString().contains(IN_OP)) break;
                    throw new TypeException("Cannot directly compare more than two values in a SPARQL expression");
                }
                case 88: {
                    int n8;
                    int n3;
                    int n2;
                    SimpleNode simpleNode2;
                    ASTBuiltInCall aSTBuiltInCall = (ASTBuiltInCall)simpleNode;
                    if (aSTBuiltInCall.name.equals(LANGMATCHES_OP) || aSTBuiltInCall.name.equals(LANG_OP) || aSTBuiltInCall.name.equals(DATATYPE_OP)) {
                        for (int i = 0; i < aSTBuiltInCall.jjtGetNumChildren(); ++i) {
                            simpleNode2 = (SimpleNode)aSTBuiltInCall.jjtGetChild(i);
                            n2 = Filter.getNodeRetType(simpleNode2, map, this.ctx);
                            if (n2 != 5 && n2 != 6) continue;
                            throw new TypeException("Cannot use a URI as input to the following SPARQL built-ins: langMatches(), LANG(), DATATYPE()");
                        }
                    }
                    if (!aSTBuiltInCall.name.equals(REGEX_OP) && !aSTBuiltInCall.name.equals(REPLACE_OP)) break;
                    for (n8 = 0; n8 < 2; ++n8) {
                        simpleNode2 = (SimpleNode)aSTBuiltInCall.jjtGetChild(n8);
                        n2 = Filter.getNodeRetType(simpleNode2, map, this.ctx);
                        if (n2 != 5 && n2 != 6) continue;
                        throw new TypeException("Cannot use a URI as input to the REGEX() or REPLACE()SPARQL built-in");
                    }
                    int n9 = n8 = aSTBuiltInCall.name.equals(REGEX_OP) ? 2 : 3;
                    if (aSTBuiltInCall.jjtGetNumChildren() <= n8) break;
                    simpleNode2 = (SimpleNode)aSTBuiltInCall.jjtGetChild(n8);
                    n2 = Filter.getNodeRetType(simpleNode2, map, this.ctx);
                    if (n2 != 20) {
                        throw new TypeException("Flag parameter for REGEX must be a constant literal");
                    }
                    SimpleNode simpleNode3 = (ASTTripleAtom)simpleNode2;
                    char[] cArray = ((ASTTripleAtom)simpleNode3).name.toCharArray();
                    for (n3 = 0; n3 < cArray.length; ++n3) {
                        if (cArray[n3] == 's' || cArray[n3] == 'm' || cArray[n3] == 'i' || cArray[n3] == 'x') continue;
                        throw new TypeException(cArray[n3] + " is not a valid REGEX flag");
                    }
                    break;
                }
                case 58: 
                case 90: {
                    SimpleNode simpleNode3;
                    int n10 = Filter.getNodeRetType(simpleNode, map, this.ctx);
                    Object object = null;
                    if (((ASTTripleAtom)simpleNode.jjtGetChild((int)0)).name.equals("http://xmlns.oracle.com/rdf/geo/sdoJoin")) {
                        object = "http://xmlns.oracle.com/rdf/geo/sdoJoin";
                    } else if (((ASTTripleAtom)simpleNode.jjtGetChild((int)0)).name.equals("http://xmlns.oracle.com/rdf/geo/sdoDistJoin")) {
                        object = "http://xmlns.oracle.com/rdf/geo/sdoDistJoin";
                    }
                    if (object == null || (simpleNode3 = (SimpleNode)simpleNode.jjtGetParent()) != null && simpleNode3.id == 56) break;
                    throw new RDFException((String)object + " cannot be used in this context");
                }
            }
            n = simpleNode.jjtGetNumChildren();
            for (int i = n - 1; i >= 0; --i) {
                stack.push((SimpleNode)simpleNode.jjtGetChild(i));
            }
        }
    }

    public String filterToSQL(SimpleNode simpleNode, Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4) throws RDFException {
        return this.filterToSQL(simpleNode, map, map2, map3, map4, false);
    }

    public String filterToSQL(SimpleNode simpleNode, Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4, boolean bl) throws RDFException {
        int n;
        this.updateAliasesForBindVars(map, map2);
        String string = "";
        String[] stringArray = new String[]{};
        if (!OptimizerUtils.isExistsNode(simpleNode) && simpleNode.jjtGetNumChildren() > 0) {
            stringArray = new String[simpleNode.jjtGetNumChildren()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = this.filterToSQL((SimpleNode)simpleNode.jjtGetChild(n), map, map2, map3, map4, bl);
            }
        }
        n = simpleNode.id;
        int n2 = 0;
        String string2 = "";
        String string3 = "";
        int n3 = 0;
        String string4 = "";
        String string5 = "";
        int n4 = 0;
        block2 : switch (n) {
            case 58: 
            case 90: {
                String string6 = "";
                if (this.secondaryExtracted) {
                    string6 = string6 + " SECONDARY_EXTRACTED=TRUE ";
                }
                if (this.singleVCLexVarArg(simpleNode)) {
                    string6 = string6 + " SINGLE_VC_LEX_VAR=TRUE ";
                }
                if (this.ctx.notTableRewrite) {
                    string6 = string6 + " TABLE_REWRITE=FALSE ";
                }
                if (this.ctx.disableSqlXsdCast) {
                    string6 = string6 + " SQL_XSD_CAST=FALSE ";
                }
                if (this.ctx.extendedVc) {
                    string6 = string6 + " EXTENDED_VC=TRUE ";
                }
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode.jjtGetChild(0);
                string2 = aSTTripleAtom.name;
                List<String[]> list = this.prepareExtFuncArgs(simpleNode, stringArray, map3, 1, map2);
                FilterFuncHandler filterFuncHandler = map4.get(string2);
                if (filterFuncHandler == null) {
                    if (string2.contains(FUNC_USER_PRE)) {
                        filterFuncHandler = new UserDefinedFuncHandler();
                    } else if (string2.contains(FUNC_USER_AGG)) {
                        filterFuncHandler = new UserDefinedAggHandler();
                        if (((ASTFunctionArgs)((Object)simpleNode)).getDistinct()) {
                            string6 = string6 + " DISTINCT=TRUE ";
                        }
                    } else {
                        if (string2.equals(FUNC_HASVID_OP)) {
                            if (simpleNode.jjtGetNumChildren() != 3) {
                                throw new RDFException("Wrong number of parameters in function " + string2);
                            }
                            if (((SimpleNode)simpleNode.jjtGetChild((int)1)).id != 73 || ((SimpleNode)simpleNode.jjtGetChild((int)2)).id != 73) {
                                throw new RDFException("Wrong parameter in function " + string2);
                            }
                            ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)simpleNode.jjtGetChild(1);
                            ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)simpleNode.jjtGetChild(2);
                            if (aSTTripleAtom2.type != 0 || aSTTripleAtom3.type != 3) {
                                throw new RDFException("Wrong parameter type in function " + string2);
                            }
                            string = "(" + this.getVIDExpr(((ASTTripleAtom)simpleNode.jjtGetChild((int)1)).name, stringArray[1], map2) + "=to_number(" + stringArray[2] + "))";
                            break;
                        }
                        if (string2.equals(FUNC_SAMECTERM_OP)) {
                            if (simpleNode.jjtGetNumChildren() != 3) {
                                throw new RDFException("Wrong number of parameters in function " + string2);
                            }
                            String string7 = "";
                            String string8 = "";
                            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(1);
                            SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(2);
                            boolean bl2 = this.useVID(simpleNode2, simpleNode3);
                            string7 = this.getSameCanonTermVal(simpleNode2, stringArray[1], map2, map3, bl2);
                            string8 = this.getSameCanonTermVal(simpleNode3, stringArray[2], map2, map3, bl2);
                            string = string7 + "=" + string8;
                            break;
                        }
                        throw new RDFException(UNSUPPORTED_FUNC_ERROR + string2);
                    }
                }
                string = filterFuncHandler.genSQL(list, string2, string6);
                break;
            }
            case 86: {
                if (simpleNode.jjtGetNumChildren() != 2) break;
                n3 = Filter.getNodeRetType(simpleNode, map3, this.ctx);
                SimpleNode simpleNode4 = (SimpleNode)simpleNode.jjtGetChild(1);
                n2 = Filter.getNodeRetType(simpleNode4, map3, this.ctx);
                if (n3 == 2) {
                    stringArray[1] = this.getEBVSQL(simpleNode4, stringArray[1], map3, map2);
                } else if ((n3 == 3 || n3 == 29 || n3 == 30 || n3 == 31) && n2 != 3 && n2 != 29 && n2 != 30 && n2 != 31) {
                    if (n2 == 4) {
                        n4 = Filter.getAtomPosition(((ASTTripleAtom)simpleNode.jjtGetChild((int)1)).name, map2, this.ctx);
                        string5 = this.getRelExprOrdColVar(((ASTTripleAtom)simpleNode.jjtGetChild((int)1)).name, stringArray[1], 3, n4);
                        if (string5 == null) {
                            string5 = this.buildVDollarFuncCall(NUMERIC_VDOLLAR_FUNC, simpleNode4, stringArray[1], map3, map2);
                        }
                        stringArray[1] = string5;
                    } else {
                        stringArray[1] = n2 == 12 ? QueryUtils.wrapSQLforNumeric(stringArray[1]) : this.buildVDollarFuncCall(NUMERIC_VDOLLAR_FUNC, simpleNode4, stringArray[1], map3, map2);
                    }
                }
                string = stringArray[0] + "(" + stringArray[1] + ")";
                break;
            }
            case 82: {
                int n5;
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    n2 = Filter.getNodeRetType((SimpleNode)simpleNode.jjtGetChild(n5), map3, this.ctx);
                    if (n2 == 3 || n2 == 29 || n2 == 30 || n2 == 31 || ((SimpleNode)simpleNode.jjtGetChild((int)n5)).id == 83) continue;
                    if (n2 == 4) {
                        n4 = Filter.getAtomPosition(((ASTTripleAtom)simpleNode.jjtGetChild((int)n5)).name, map2, this.ctx);
                        string5 = this.getRelExprOrdColVar(((ASTTripleAtom)simpleNode.jjtGetChild((int)n5)).name, stringArray[n5], 3, n4);
                        if (string5 == null) {
                            string5 = this.buildVDollarFuncCall(NUMERIC_VDOLLAR_FUNC, (SimpleNode)simpleNode.jjtGetChild(n5), stringArray[n5], map3, map2);
                        }
                        stringArray[n5] = string5;
                        continue;
                    }
                    stringArray[n5] = n2 == 12 ? QueryUtils.wrapSQLforNumeric(stringArray[n5]) : this.buildVDollarFuncCall(NUMERIC_VDOLLAR_FUNC, (SimpleNode)simpleNode.jjtGetChild(n5), stringArray[n5], map3, map2);
                }
                string = "(" + stringArray[0];
                for (int i = 1; i < stringArray.length; ++i) {
                    n5 = ((SimpleNode)simpleNode.jjtGetChild((int)(i - 1))).id;
                    int n6 = ((SimpleNode)simpleNode.jjtGetChild((int)i)).id;
                    string = n5 != 83 && n6 != 83 ? string + " + " + stringArray[i] : string + " " + stringArray[i];
                }
                string = string + ")";
                break;
            }
            case 84: {
                for (int i = 0; i < stringArray.length; ++i) {
                    n2 = Filter.getNodeRetType((SimpleNode)simpleNode.jjtGetChild(i), map3, this.ctx);
                    if (n2 == 3 || n2 == 29 || n2 == 30 || n2 == 31 || ((SimpleNode)simpleNode.jjtGetChild((int)i)).id == 85) continue;
                    if (n2 == 4) {
                        n4 = Filter.getAtomPosition(((ASTTripleAtom)simpleNode.jjtGetChild((int)i)).name, map2, this.ctx);
                        string5 = this.getRelExprOrdColVar(((ASTTripleAtom)simpleNode.jjtGetChild((int)i)).name, stringArray[i], 3, n4);
                        if (string5 == null) {
                            string5 = this.buildVDollarFuncCall(NUMERIC_VDOLLAR_FUNC, (SimpleNode)simpleNode.jjtGetChild(i), stringArray[i], map3, map2);
                        }
                        stringArray[i] = string5;
                        continue;
                    }
                    stringArray[i] = n2 == 12 ? QueryUtils.wrapSQLforNumeric(stringArray[i]) : this.buildVDollarFuncCall(NUMERIC_VDOLLAR_FUNC, (SimpleNode)simpleNode.jjtGetChild(i), stringArray[i], map3, map2);
                }
                if (simpleNode.jjtGetNumChildren() == 3 && ((SimpleNode)simpleNode.jjtGetChild((int)1)).id == 85 && ((ASTMultiplicativeOperator)simpleNode.jjtGetChild((int)1)).name.equals("/")) {
                    stringArray[2] = "DECODE(" + stringArray[2] + ",0,NULL," + stringArray[2] + ")";
                }
                string = "(" + Filter.concatStrArray(stringArray, " ") + ")";
                break;
            }
            case 78: {
                string = string + "(";
                for (int i = 0; i < stringArray.length; ++i) {
                    SimpleNode simpleNode5 = (SimpleNode)simpleNode.jjtGetChild(i);
                    string = i > 0 ? string + " OR (" + this.getEBVSQL(simpleNode5, stringArray[i], map3, map2) + ")" : string + "(" + this.getEBVSQL(simpleNode5, stringArray[i], map3, map2) + ")";
                }
                string = string + ")";
                break;
            }
            case 79: {
                for (int i = 0; i < stringArray.length; ++i) {
                    SimpleNode simpleNode6 = (SimpleNode)simpleNode.jjtGetChild(i);
                    string = i > 0 ? string + " AND (" + this.getEBVSQL(simpleNode6, stringArray[i], map3, map2) + ")" : string + "(" + this.getEBVSQL(simpleNode6, stringArray[i], map3, map2) + ")";
                }
                break;
            }
            case 80: {
                if (simpleNode.jjtGetNumChildren() == 3) {
                    boolean bl3;
                    String string9 = "";
                    String string10 = "";
                    String string11 = "";
                    SimpleNode simpleNode7 = (SimpleNode)simpleNode.jjtGetChild(0);
                    SimpleNode simpleNode8 = (SimpleNode)simpleNode.jjtGetChild(1);
                    SimpleNode simpleNode9 = (SimpleNode)simpleNode.jjtGetChild(2);
                    int n7 = Filter.getNodeRetType(simpleNode7, map3, this.ctx);
                    int n8 = Filter.getCompFamily(n7);
                    int n9 = Filter.getNodeRetType(simpleNode9, map3, this.ctx);
                    int n10 = Filter.getCompFamily(n9);
                    if (stringArray[1].contains(IN_OP)) {
                        stringArray[1] = stringArray[1].equals(IN_OP) ? "=" : "!=";
                    }
                    boolean bl4 = (this.ctx.filterFlags & 4) > 0 || !this.isNonLex(simpleNode7) || !this.isNonLex(simpleNode9);
                    boolean bl5 = false;
                    if (!bl4) {
                        if (n7 == 4 && simpleNode9.id == 73 && (stringArray[1].equals("=") || stringArray[1].equals("!=")) && this.isSafeForVIDComp((ASTTripleAtom)simpleNode9, stringArray[1])) {
                            string = this.getSQLforOptEqualComp((ASTTripleAtom)simpleNode7, stringArray[0], (ASTTripleAtom)simpleNode9, stringArray[2], stringArray[1], map2);
                            bl5 = true;
                        } else if (n9 == 4 && simpleNode7.id == 73 && (stringArray[1].equals("=") || stringArray[1].equals("!=")) && this.isSafeForVIDComp((ASTTripleAtom)simpleNode7, stringArray[1])) {
                            string = this.getSQLforOptEqualComp((ASTTripleAtom)simpleNode9, stringArray[2], (ASTTripleAtom)simpleNode7, stringArray[0], stringArray[1], map2);
                            bl5 = true;
                        }
                    }
                    if (bl5) break;
                    boolean bl6 = (this.ctx.filterFlags & 2) > 0;
                    boolean bl2 = bl3 = !stringArray[1].equals("=") && !stringArray[1].equals("!=");
                    if (n7 == 4 && n9 != 4 && this.allowsIdxBasedComp(simpleNode9, map3) && (!stringArray[1].equals("!=") || bl6)) {
                        if (this.ctx.useOrderCol && !Filter.isSubQAlias(stringArray[0])) {
                            n4 = Filter.getAtomPosition(((ASTTripleAtom)simpleNode7).name, map2, this.ctx);
                        }
                        if ((string10 = this.getRelExprOrdColVar(((ASTTripleAtom)simpleNode7).name, stringArray[0], n9, n4)) == null) {
                            string10 = this.getRelExprVal(simpleNode7, stringArray[0], map3, n10, bl3, map2);
                        }
                        string11 = this.getRelExprVal(simpleNode9, stringArray[2], map3, n10, bl3, map2);
                        String string12 = "";
                        if (stringArray[1].equals("!=")) {
                            string12 = " OR " + string10 + " IS NULL";
                        } else if (stringArray[1].equals("=") && this.hasNegationParent(simpleNode7)) {
                            string12 = " AND " + string10 + " IS NOT NULL";
                        }
                        string = "(" + string10 + " " + stringArray[1] + " " + string11 + string12 + ")";
                        if (!Filter.isCalendarType(n9) || (this.ctx.filterFlags & 1) != 0) break;
                        string9 = this.buildFuncCompStr(simpleNode7, stringArray[0], stringArray[1], simpleNode9, stringArray[2], map3, map2);
                        string = "(" + string + " AND " + string9 + string12 + ")";
                        break;
                    }
                    if (n9 == 4 && n7 != 4 && this.allowsIdxBasedComp(simpleNode7, map3) && (!stringArray[1].equals("!=") || bl6)) {
                        string10 = this.getRelExprVal(simpleNode7, stringArray[0], map3, n8, bl3, map2);
                        if (this.ctx.useOrderCol && !Filter.isSubQAlias(stringArray[2])) {
                            n4 = Filter.getAtomPosition(((ASTTripleAtom)simpleNode9).name, map2, this.ctx);
                        }
                        if ((string11 = this.getRelExprOrdColVar(((ASTTripleAtom)simpleNode9).name, stringArray[2], n7, n4)) == null) {
                            string11 = this.getRelExprVal(simpleNode9, stringArray[2], map3, n8, bl3, map2);
                        }
                        String string13 = "";
                        if (stringArray[1].equals("!=")) {
                            string13 = " OR " + string11 + " IS NULL";
                        } else if (stringArray[1].equals("=") && this.hasNegationParent(simpleNode9)) {
                            string13 = " AND " + string11 + " IS NOT NULL";
                        }
                        string = "(" + string10 + " " + stringArray[1] + " " + string11 + string13 + ")";
                        if (!Filter.isCalendarType(n7) || (this.ctx.filterFlags & 1) != 0) break;
                        string9 = this.buildFuncCompStr(simpleNode7, stringArray[0], stringArray[1], simpleNode9, stringArray[2], map3, map2);
                        string = "(" + string + " AND " + string9 + string13 + ")";
                        break;
                    }
                    if (!((n7 != 3 && n7 != 29 && n7 != 30 && n7 != 31 && n7 != 12 || n9 != 3 && n9 != 29 && n9 != 30 && n9 != 31 && n9 != 12) && (n9 != 8 && n9 != 20 && n9 != 11 || n7 != 8 && n7 != 20 && n7 != 11) && (!Filter.isCalendarType(n7) || !Filter.isCalendarType(n9) || this.hasNegationParent(simpleNode7) && (this.ctx.filterFlags & 1) <= 0) && (n7 != 6 && n7 != 5 || n9 != 6 && n9 != 5))) {
                        string10 = this.getRelExprVal(simpleNode7, stringArray[0], map3, n8, bl3, map2);
                        string11 = this.getRelExprVal(simpleNode9, stringArray[2], map3, n10, bl3, map2);
                        string = "(" + string10 + " " + stringArray[1] + " " + string11 + ")";
                        if (!Filter.isCalendarType(n7) || (this.ctx.filterFlags & 1) != 0) break;
                        string9 = this.buildFuncCompStr(simpleNode7, stringArray[0], stringArray[1], simpleNode9, stringArray[2], map3, map2);
                        string = "(" + string + " AND " + string9 + ")";
                        break;
                    }
                    string = this.buildFuncCompStr(simpleNode7, stringArray[0], stringArray[1], simpleNode9, stringArray[2], map3, map2);
                    break;
                }
                if (!stringArray[1].contains(IN_OP)) break;
                if (simpleNode.jjtGetNumChildren() == 2) {
                    string = stringArray[1].contains("NOT") ? "(1=1)" : "(1=0)";
                    break;
                }
                SimpleNode simpleNode10 = (SimpleNode)simpleNode.jjtGetChild(0);
                int n11 = stringArray[1].contains("NOT") ? 0 : 1;
                String string14 = n11 == 0 ? "!=" : "=";
                String string15 = "";
                ArrayList arrayList = new ArrayList();
                String[] stringArray2 = new String[1];
                String[] stringArray3 = new String[1];
                String[] stringArray4 = new String[1];
                String[] stringArray5 = new String[1];
                String[] stringArray6 = new String[1];
                String[] stringArray7 = new String[1];
                this.decomposeRDFTerm(simpleNode10, stringArray[0], map3, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, map2);
                string15 = stringArray2[0] + ", " + stringArray3[0] + ", " + stringArray4[0] + ", " + stringArray5[0] + ", " + stringArray6[0];
                boolean bl8 = false;
                int n12 = Filter.getNodeRetType(simpleNode10, map3, this.ctx);
                SimpleNode simpleNode11 = simpleNode10;
                if (n12 == 4 && this.isNonLex((ASTTripleAtom)simpleNode10)) {
                    bl8 = true;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                String string16 = "";
                for (int i = 2; i < simpleNode.jjtGetNumChildren(); ++i) {
                    simpleNode10 = (SimpleNode)simpleNode.jjtGetChild(i);
                    boolean bl9 = false;
                    if (simpleNode10.id == 73) {
                        bl9 = this.isSafeForVIDComp((ASTTripleAtom)simpleNode10, string14);
                    }
                    if (bl9 && bl8) {
                        ASTTripleAtom object = (ASTTripleAtom)simpleNode10;
                        String string6 = this.getVIDForTerm(object, stringArray[i], map2);
                        arrayList2.add(string6);
                        continue;
                    }
                    this.decomposeRDFTerm(simpleNode10, stringArray[i], map3, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, map2);
                    string16 = stringArray2[0] + ", " + stringArray3[0] + ", " + stringArray4[0] + ", " + stringArray5[0] + ", " + stringArray6[0];
                    string = string + "sem_apis.rdfTermEqual(" + string15 + ", " + string16 + ") = " + n11;
                    string = string + (n11 == 0 ? " AND \n" : " OR \n");
                }
                if (string != "") {
                    string = string.substring(0, string.length() - 5);
                }
                String string18 = "";
                if (arrayList2.size() > 0) {
                    simpleNode10 = (SimpleNode)simpleNode.jjtGetChild(0);
                    string18 = this.getVIDForTerm((ASTTripleAtom)simpleNode10, stringArray[0], map2);
                    string18 = "( " + string18 + " " + stringArray[1] + " (";
                    for (String string7 : arrayList2) {
                        string18 = string18 + string7 + ", ";
                    }
                    string18 = string18.substring(0, string18.length() - 2);
                    string18 = string18 + "))";
                    if (string != "") {
                        string18 = string18 + (n11 == 0 ? " AND \n" : " OR \n");
                    }
                }
                string = "(" + string18 + string + ")";
                break;
            }
            case 81: {
                string = string + ((ASTComparisonOperator)simpleNode).name;
                break;
            }
            case 83: {
                string = string + ((ASTAdditiveOperator)simpleNode).name;
                break;
            }
            case 85: {
                string = string + ((ASTMultiplicativeOperator)simpleNode).name;
                break;
            }
            case 87: {
                if (((ASTUnaryOperator)simpleNode).name.equals("!")) {
                    string = string + "NOT";
                    break;
                }
                string = string + ((ASTUnaryOperator)simpleNode).name;
                break;
            }
            case 88: {
                string = this.getSQLforBuiltIn((ASTBuiltInCall)simpleNode, stringArray, map2, map3, bl, map4, map);
                break;
            }
            case 73: {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                int n13 = Filter.getNodeRetType(simpleNode, map3, this.ctx);
                switch (n13) {
                    case 4: 
                    case 27: {
                        if (map.containsKey(aSTTripleAtom.name)) {
                            string = map.get(aSTTripleAtom.name);
                            break block2;
                        }
                        string = "";
                        break block2;
                    }
                    case 12: {
                        string = aSTTripleAtom.name;
                        break block2;
                    }
                }
                if (aSTTripleAtom == null || aSTTripleAtom.name.length() == 0) {
                    string = "chr(0)";
                    break;
                }
                if (!this.ctx.clobExpSupport || QueryUtils.computeConstTermLen(aSTTripleAtom.name, aSTTripleAtom.litLang, aSTTripleAtom.litType) <= 4000) {
                    try {
                        string = QueryUtils.enquoteLiteral(QueryUtils.shortenConstVNforTerm(aSTTripleAtom.name, aSTTripleAtom.litLang, aSTTripleAtom.litType));
                    }
                    catch (SQLException sQLException) {
                        throw new RDFException(sQLException.getMessage());
                    }
                    if (string.length() < 2000) break;
                    string = QueryUtils.wrapFor4kVc(string);
                    break;
                }
                try {
                    string = QueryUtils.splitClobInChunks(aSTTripleAtom.name, 3500);
                    break;
                }
                catch (SQLException sQLException) {
                    throw new RDFException(sQLException.getMessage());
                }
            }
            case -1: {
                string = string + ((ASTBooleanSpecialNode)simpleNode).name;
                break;
            }
            case 89: {
                boolean bl10 = this.wrapForHaving;
                string = this.getSQLforAggregateFunct((ASTAggregate)simpleNode, stringArray, map2, map3, bl, map4);
                break;
            }
            case 17: {
                string = "HAVING (" + this.filterToSQL((SimpleNode)simpleNode.children[0], map, map2, map3, map4, bl) + ")";
                break;
            }
            default: {
                throw new RDFException("Unexpected AST node type in FILTER: " + simpleNode.getClass().toString());
            }
        }
        return string;
    }

    public String getSQLforOptEqualComp(ASTTripleAtom aSTTripleAtom, String string, ASTTripleAtom aSTTripleAtom2, String string2, String string3, Map<String, String> map) {
        String string4 = null;
        String string5 = this.getVIDForTerm(aSTTripleAtom2, string2, map);
        string4 = "(" + this.getVIDExpr(aSTTripleAtom.name, string, map) + " " + string3 + " " + string5 + ")";
        return string4;
    }

    private String getVIDForTerm(ASTTripleAtom aSTTripleAtom, String string, Map<String, String> map) {
        String string2 = null;
        if (aSTTripleAtom.type == 1) {
            string2 = this.ctx.URImap.get(aSTTripleAtom.name);
        } else if (aSTTripleAtom.type == 2 || aSTTripleAtom.type == 3 || aSTTripleAtom.type == 4 || aSTTripleAtom.type == 5 || aSTTripleAtom.type == 6) {
            string2 = this.ctx.litMap.get(aSTTripleAtom);
        } else if (aSTTripleAtom.type == 0) {
            string2 = this.getVIDExpr(aSTTripleAtom.name, string, map);
        } else if (aSTTripleAtom.type == 9) {
            string2 = aSTTripleAtom.getBindVar().getIdCol();
        }
        if (string2 == null) {
            string2 = Filter.getNonExistingTermFilterQuery(this.ctx.clnPfxForRdfObjName);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSQLforBuiltIn(ASTBuiltInCall aSTBuiltInCall, String[] stringArray, Map<String, String> map, Map<String, String> map2, boolean bl, Map<String, FilterFuncHandler> map3, Map<String, String> map4) throws RDFException {
        String string = "";
        int n = 0;
        String string2 = "";
        String string3 = "";
        String string4 = RDFT_VDOLLAR_FUNC;
        boolean bl2 = false;
        String string5 = "";
        if (!this.ctx.useExactForExpr) {
            string4 = RDFT_CANON_TERM_FUNC;
        }
        if ((string = aSTBuiltInCall.name).equals(STR_OP)) {
            if (this.ctx.useOldOptimizationForSTR && !this.ctx.clobExpSupport) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    n = Filter.getNodeRetType((SimpleNode)aSTBuiltInCall.jjtGetChild(n2), map2, this.ctx);
                    switch (n) {
                        case 4: {
                            stringArray[n2] = this.buildInLineStrExpr((ASTTripleAtom)aSTBuiltInCall.jjtGetChild(n2), stringArray[n2], map2, map);
                            break;
                        }
                        case 2: {
                            stringArray[n2] = this.wrapSQLforBooleanNoQuotes(stringArray[n2]);
                            break;
                        }
                        case 6: {
                            stringArray[n2] = this.stripEnclosingChars(stringArray[n2]);
                            stringArray[n2] = this.wrapSQLforVCHARcomp(stringArray[n2]);
                            break;
                        }
                        case 12: {
                            stringArray[n2] = this.wrapSQLforVCHARcomp("'" + stringArray[n2] + "'");
                            break;
                        }
                        case 21: 
                        case 23: {
                            stringArray[n2] = this.wrapSQLforCLOBcomp(stringArray[n2], null, "'http://www.opengis.net/ont/geosparql#wktLiteral'");
                            break;
                        }
                        case 25: {
                            stringArray[n2] = this.wrapSQLforGEOMtoVC(stringArray[n2]);
                            break;
                        }
                        case 27: {
                            stringArray[n2] = this.wrapSQLforVCHARcomp(stringArray[n2] + "." + "VALUE_NAME");
                            break;
                        }
                        case 28: {
                            stringArray[n2] = this.wrapSQLforVCHARcomp("MDSYS.SDO_RDF.VNAME(" + stringArray[n2] + ")");
                            break;
                        }
                        case 3: 
                        case 29: 
                        case 30: 
                        case 31: {
                            stringArray[n2] = this.wrapNumericforVCHARcomp(stringArray[n2]);
                            break;
                        }
                        case 26: {
                            stringArray[n2] = this.wrapDateTimeforVCHARcomp(stringArray[n2]);
                            break;
                        }
                        default: {
                            stringArray[n2] = this.wrapSQLforVCHARcomp(stringArray[n2]);
                        }
                    }
                    ++n2;
                }
                return Filter.concatStrArray(stringArray, " ");
            }
            String[] stringArray2 = new String[1];
            String[] stringArray3 = new String[1];
            String[] stringArray4 = new String[1];
            String[] stringArray5 = new String[1];
            String[] stringArray6 = new String[1];
            String[] stringArray7 = new String[1];
            this.decomposeRDFTerm((SimpleNode)aSTBuiltInCall.jjtGetChild(0), stringArray[0], map2, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, map);
            string3 = "sem_apis.getV$STRVal (" + stringArray2[0] + ", " + stringArray3[0] + ", " + stringArray4[0] + ", " + stringArray5[0] + ", " + stringArray6[0];
            if (!this.ctx.usingTopDownTrans) return string3 + ", " + stringArray7[0] + ")";
            return string3 + ")";
        }
        if (string.equals(LANG_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 1) return Filter.concatStrArray(stringArray, " ");
            stringArray[0] = this.getLangSQL(aSTBuiltInCall, stringArray[0], 0, map2, map);
            return Filter.concatStrArray(stringArray, " ");
        }
        if (string.equals(LANGMATCHES_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 2) return string3;
            String[] stringArray8 = new String[1];
            String[] stringArray9 = new String[1];
            String[] stringArray10 = new String[1];
            String[] stringArray11 = new String[1];
            String[] stringArray12 = new String[1];
            String[] stringArray13 = new String[1];
            String[] stringArray14 = new String[1];
            String[] stringArray15 = new String[1];
            String[] stringArray16 = new String[1];
            String[] stringArray17 = new String[1];
            this.decomposeRDFTerm((SimpleNode)aSTBuiltInCall.jjtGetChild(0), stringArray[0], map2, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, map);
            this.decomposeRDFTerm((SimpleNode)aSTBuiltInCall.jjtGetChild(1), stringArray[1], map2, stringArray13, stringArray14, stringArray15, stringArray16, stringArray17, map);
            return "(sem_apis.langMatches(" + stringArray8[0] + ", " + stringArray9[0] + ", " + stringArray10[0] + ", " + stringArray11[0] + ", " + stringArray12[0] + ", " + stringArray13[0] + ", " + stringArray14[0] + ", " + stringArray15[0] + ", " + stringArray16[0] + ", " + stringArray17[0] + ") = 1)";
        }
        if (string.equals(DATATYPE_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 1) return Filter.concatStrArray(stringArray, " ");
            SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(0);
            n = Filter.getNodeRetType(simpleNode, map2, this.ctx);
            switch (n) {
                case 4: {
                    String[] stringArray18 = new String[8];
                    this.popVDollarColArray(simpleNode, stringArray[0], map2, false, stringArray18, map);
                    stringArray[0] = "(CASE WHEN (" + stringArray18[4] + ") IS NOT NULL THEN '<' ||" + stringArray18[4] + "|| '>' ELSE (CASE WHEN (" + stringArray18[1] + " IN ('PL', 'PLL', 'TL', 'TLL', 'PL@', 'PLL@', 'CPLL', 'CPLL@', 'CTLL', 'LIT')) THEN '<" + "http://www.w3.org/2001/XMLSchema#string" + ">' ELSE NULL END) END)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 8: {
                    stringArray[0] = "NVL2(" + stringArray[0] + ", '<http://www.w3.org/2001/XMLSchema#string>', NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 9: 
                case 20: {
                    stringArray[0] = "'<http://www.w3.org/2001/XMLSchema#string>'";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 1: {
                    stringArray[0] = "'<http://www.w3.org/2001/XMLSchema#boolean>'";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 2: {
                    stringArray[0] = "NVL((case when((" + stringArray[0] + ") OR (NOT(" + stringArray[0] + "))) then '<http://www.w3.org/2001/XMLSchema#boolean>' else NULL end), NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 3: {
                    stringArray[0] = "NVL2(" + stringArray[0] + ", '<http://www.w3.org/2001/XMLSchema#decimal>', NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 29: {
                    stringArray[0] = "NVL2(" + stringArray[0] + ", '<http://www.w3.org/2001/XMLSchema#integer>', NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 30: {
                    stringArray[0] = "NVL2(" + stringArray[0] + ", '<http://www.w3.org/2001/XMLSchema#double>', NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 31: {
                    stringArray[0] = "NVL2(" + stringArray[0] + ", '<http://www.w3.org/2001/XMLSchema#float>', NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 21: {
                    stringArray[0] = "NVL2(" + stringArray[0] + ", '<" + "http://www.opengis.net/ont/geosparql#gmlLiteral" + ">', NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 23: 
                case 25: {
                    stringArray[0] = "NVL2(" + stringArray[0] + ", '<" + "http://www.opengis.net/ont/geosparql#wktLiteral" + ">', NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 26: {
                    stringArray[0] = "NVL2(" + stringArray[0] + ", '<" + "http://www.w3.org/2001/XMLSchema#dateTime" + ">', NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 22: 
                case 24: {
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                    stringArray[0] = "'<" + aSTTripleAtom.litType + ">'";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 27: {
                    stringArray[0] = "(CASE WHEN (" + stringArray[0] + "." + "LITERAL_TYPE" + ") IS NOT NULL THEN '<' ||" + stringArray[0] + "." + "LITERAL_TYPE" + "|| '>' ELSE (CASE WHEN (" + stringArray[0] + "." + "VALUE_TYPE" + " IN ('PL', 'PLL', 'TL', 'TLL', 'PL@', 'PLL@', 'CPLL', 'CPLL@', 'CTLL', 'LIT')) THEN '<" + "http://www.w3.org/2001/XMLSchema#string" + ">' ELSE NULL END) END)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 28: {
                    stringArray[0] = "(CASE WHEN MDSYS.SDO_RDF.LTYPE(" + stringArray[0] + ") IS NOT NULL THEN '<' ||" + "MDSYS.SDO_RDF.LTYPE" + "(" + stringArray[0] + ") || '>' ELSE (CASE WHEN " + "MDSYS.SDO_RDF.VTYPE" + "(" + stringArray[0] + ") IN ('PL', 'PLL', 'TL', 'TLL', 'PL@', 'PLL@', 'CPLL', 'CPLL@', 'CTLL', 'LIT') THEN '<" + "http://www.w3.org/2001/XMLSchema#string" + ">' ELSE NULL END) END)";
                }
            }
            return Filter.concatStrArray(stringArray, " ");
        }
        if (string.equals(BOUND_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 1) return Filter.concatStrArray(stringArray, " ");
            SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(0);
            n = Filter.getNodeRetType(simpleNode, map2, this.ctx);
            switch (n) {
                case 4: {
                    if (this.ctx.usingTopDownTrans && !Filter.isSubQAlias(stringArray[0])) {
                        stringArray[0] = "(1 = 1)";
                        return Filter.concatStrArray(stringArray, " ");
                    }
                    stringArray[0] = "(" + this.getBoundColumnExpr((ASTTripleAtom)simpleNode, stringArray[0], map) + " IS NOT NULL)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 21: 
                case 23: 
                case 25: 
                case 29: 
                case 30: 
                case 31: {
                    stringArray[0] = "(NVL2(" + stringArray[0] + ", 1, 0) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 2: {
                    stringArray[0] = "((case when((" + stringArray[0] + ") OR (NOT(" + stringArray[0] + "))) then 1 else 0 end) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 27: {
                    stringArray[0] = "(NVL2(" + stringArray[0] + "." + "VALUE_TYPE" + ",1,0) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 28: {
                    stringArray[0] = "(NVL2(MDSYS.SDO_RDF.VTYPE(" + stringArray[0] + "),1,0) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                default: {
                    stringArray[0] = "(1 = 1)";
                }
            }
            return Filter.concatStrArray(stringArray, " ");
        }
        if (string.equals(SAMETERM_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 2) return string3;
            SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(0);
            SimpleNode simpleNode2 = (SimpleNode)aSTBuiltInCall.jjtGetChild(1);
            int n3 = Filter.getNodeRetType(simpleNode, map2, this.ctx);
            int n4 = Filter.getNodeRetType(simpleNode2, map2, this.ctx);
            boolean bl3 = (this.ctx.filterFlags & 4) > 0 || !this.isNonLex(simpleNode) || !this.isNonLex(simpleNode2);
            boolean bl4 = false;
            if (!bl3) {
                if (n3 == 4 && n4 == 4) {
                    return "(" + this.getVIDExpr(((ASTTripleAtom)simpleNode).name, stringArray[0], map) + "=" + this.getVIDExpr(((ASTTripleAtom)simpleNode2).name, stringArray[1], map) + ")";
                }
                if (n3 == 4 && simpleNode2.id == 73 && (((ASTTripleAtom)simpleNode2).type == 1 || ((ASTTripleAtom)simpleNode2).type == 3) || n4 == 4 && simpleNode.id == 73 && (((ASTTripleAtom)simpleNode).type == 1 || ((ASTTripleAtom)simpleNode).type == 3)) {
                    if (n3 != 4) return this.getSQLforOptEqualComp((ASTTripleAtom)simpleNode2, stringArray[1], (ASTTripleAtom)simpleNode, stringArray[0], "=", map);
                    return this.getSQLforOptEqualComp((ASTTripleAtom)simpleNode, stringArray[0], (ASTTripleAtom)simpleNode2, stringArray[1], "=", map);
                }
            }
            if (bl4) return string3;
            return "(" + this.getSameTermVal(simpleNode, stringArray[0], map2, map) + " = " + this.getSameTermVal(simpleNode2, stringArray[1], map2, map) + ")";
        }
        if (string.equals(ISURI_OP) || string.equals(ISIRI_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 1) return Filter.concatStrArray(stringArray, " ");
            SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(0);
            n = Filter.getNodeRetType(simpleNode, map2, this.ctx);
            switch (n) {
                case 27: {
                    stringArray[0] = "NVL2(" + stringArray[0] + "." + "VALUE_TYPE" + ", (CASE WHEN " + stringArray[0] + "." + "VALUE_TYPE" + " IN ('URI','UR') THEN 1 ELSE 0 END),\n NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 28: {
                    stringArray[0] = "NVL2(MDSYS.SDO_RDF.VTYPE(" + stringArray[0] + "), (CASE WHEN " + "MDSYS.SDO_RDF.VTYPE" + "(" + stringArray[0] + ") IN ('URI','UR') THEN 1 ELSE 0 END),\n NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 4: {
                    String string6 = "";
                    if (Filter.isSubQAlias(stringArray[0])) {
                        string6 = (this.ctx.contextFlags & 8) > 0 && this.ctx.vjoinVars != null && this.ctx.vjoinVars.contains(((ASTTripleAtom)simpleNode).name) ? this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetValTyp(" + stringArray[0] + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false) : this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, stringArray[0] + "$RDFVTYP", false, false);
                    } else if ((this.ctx.contextFlags & 8) > 0) {
                        String string7 = map.get(((ASTTripleAtom)simpleNode).name.toUpperCase());
                        string6 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetValTyp(" + string7 + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                    } else {
                        string6 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, this.getSpmMappedValueCol(stringArray[0] + "." + "VALUE_TYPE"), false, false);
                    }
                    stringArray[0] = "NVL2(" + string6 + ", (CASE WHEN " + string6 + " IN ('UR','URI') THEN 1 ELSE 0 END),\n NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 5: 
                case 6: {
                    stringArray[0] = "(NVL2(" + stringArray[0] + ", 1, NULL) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 2: {
                    stringArray[0] = "(NVL((case when((" + stringArray[0] + ") OR (NOT(" + stringArray[0] + "))) then 0 else NULL end), NULL) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 3: 
                case 8: 
                case 21: 
                case 23: 
                case 25: 
                case 29: 
                case 30: 
                case 31: {
                    stringArray[0] = "(NVL2(" + stringArray[0] + ", 0, null) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                default: {
                    stringArray[0] = "(1 = 0)";
                }
            }
            return Filter.concatStrArray(stringArray, " ");
        }
        if (string.equals(ISBLANK_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 1) return Filter.concatStrArray(stringArray, " ");
            SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(0);
            n = Filter.getNodeRetType(simpleNode, map2, this.ctx);
            switch (n) {
                case 27: {
                    stringArray[0] = "NVL2(" + stringArray[0] + "." + "VALUE_TYPE" + ", (CASE WHEN " + stringArray[0] + "." + "VALUE_TYPE" + " IN ('BN','BLN') THEN 1 ELSE 0 END),\n NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 28: {
                    stringArray[0] = "NVL2(MDSYS.SDO_RDF.VTYPE(" + stringArray[0] + "), (CASE WHEN " + "MDSYS.SDO_RDF.VTYPE" + "(" + stringArray[0] + ") IN ('BN','BLN') THEN 1 ELSE 0 END),\n NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 4: {
                    String string8 = "";
                    if (Filter.isSubQAlias(stringArray[0])) {
                        string8 = (this.ctx.contextFlags & 8) > 0 && this.ctx.vjoinVars != null && this.ctx.vjoinVars.contains(((ASTTripleAtom)simpleNode).name) ? this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetValTyp(" + stringArray[0] + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false) : this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, stringArray[0] + "$RDFVTYP", false, false);
                    } else if ((this.ctx.contextFlags & 8) > 0) {
                        String string9 = map.get(((ASTTripleAtom)simpleNode).name.toUpperCase());
                        string8 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetValTyp(" + string9 + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "'", false, false);
                    } else {
                        string8 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, this.getSpmMappedValueCol(stringArray[0] + "." + "VALUE_TYPE"), false, false);
                    }
                    stringArray[0] = "NVL2(" + string8 + ", (CASE WHEN " + string8 + " IN ('BN','BLN') THEN 1 ELSE 0 END),\n  NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 2: {
                    stringArray[0] = "(NVL((case when((" + stringArray[0] + ") OR (NOT(" + stringArray[0] + "))) then 0 else NULL end), NULL) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 21: 
                case 23: 
                case 25: 
                case 29: 
                case 30: 
                case 31: {
                    stringArray[0] = "(NVL2(" + stringArray[0] + ", 0, NULL) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                default: {
                    stringArray[0] = "(1 = 0)";
                }
            }
            return Filter.concatStrArray(stringArray, " ");
        }
        if (string.equals(ISLITERAL_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 1) return Filter.concatStrArray(stringArray, " ");
            SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(0);
            n = Filter.getNodeRetType(simpleNode, map2, this.ctx);
            switch (n) {
                case 27: {
                    stringArray[0] = "NVL2(" + stringArray[0] + "." + "VALUE_TYPE" + ", (CASE WHEN (" + stringArray[0] + "." + "VALUE_TYPE" + " IN ('PL', 'PLL', 'TL', 'TLL', 'PL@', 'PLL@', 'LIT')) THEN 1 ELSE 0 END),\n NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 28: {
                    stringArray[0] = "NVL2(MDSYS.SDO_RDF.VTYPE(" + stringArray[0] + "), (CASE WHEN (" + "MDSYS.SDO_RDF.VTYPE" + "(" + stringArray[0] + ") IN ('PL', 'PLL', 'TL', 'TLL', 'PL@', 'PLL@', 'LIT')) THEN 1 ELSE 0 END),\n NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 4: {
                    String string10 = "";
                    if (Filter.isSubQAlias(stringArray[0])) {
                        string10 = (this.ctx.contextFlags & 8) > 0 && this.ctx.vjoinVars != null && this.ctx.vjoinVars.contains(((ASTTripleAtom)simpleNode).name) ? this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetValTyp(" + stringArray[0] + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false) : this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, stringArray[0] + "$RDFVTYP", false, false);
                    } else {
                        if ((this.ctx.contextFlags & 8) > 0) {
                            String string11 = map.get(((ASTTripleAtom)simpleNode).name.toUpperCase());
                            string10 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetValTyp(" + string11 + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                        }
                        string10 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, this.getSpmMappedValueCol(stringArray[0] + "." + "VALUE_TYPE"), false, false);
                    }
                    stringArray[0] = "NVL2(" + string10 + ", (CASE WHEN " + string10 + " IN ('LIT', 'PL', 'PLL', 'TL', 'TLL', 'PL@', 'PLL@') THEN 1 ELSE 0 END),\n  NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 5: 
                case 6: {
                    stringArray[0] = "(NVL2(" + stringArray[0] + ", 0, NULL) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 2: {
                    stringArray[0] = "(NVL((case when((" + stringArray[0] + ") OR (NOT(" + stringArray[0] + "))) then 1 else NULL end), NULL) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 3: 
                case 8: 
                case 21: 
                case 23: 
                case 25: 
                case 29: 
                case 30: 
                case 31: {
                    stringArray[0] = "(NVL2(" + stringArray[0] + ", 1, NULL) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                default: {
                    stringArray[0] = "(1 = 1)";
                }
            }
            return Filter.concatStrArray(stringArray, " ");
        }
        if (string.equals(REGEX_OP)) {
            String string12 = null;
            if (aSTBuiltInCall.jjtGetNumChildren() > 2) {
                string12 = this.getRegexFlag(stringArray[2]);
            }
            if (this.ctx.rdftStrExp || this.nestedFuncExists && !this.ctx.noRdftStrExp) {
                List<String[]> list = this.prepareExtFuncArgs(aSTBuiltInCall, stringArray, map2, 0, map);
                StringBuffer stringBuffer = new StringBuffer("SYS.ODCIVarchar2List(");
                String string13 = "";
                for (int i = 0; i < 2; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",\n");
                    }
                    string13 = QueryUtils.buildOptTerm(list.get(i));
                    if (this.ctx.unescapeUniRegex && !this.ctx.networkStorageForm.equals("UNESC")) {
                        string13 = this.wrapForUnicodeUnescape(string13);
                    }
                    stringBuffer.append(string13);
                }
                stringBuffer.append(")");
                if (string12 == null) return "mdsys.sdo_rdf.sparql_regex(" + stringBuffer.toString() + ",NULL) > 0";
                return "mdsys.sdo_rdf.sparql_regex(" + stringBuffer.toString() + "," + string12 + ") > 0";
            }
            block81: for (int i = 0; i < 2; ++i) {
                SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(i);
                n = Filter.getNodeRetType(simpleNode, map2, this.ctx);
                switch (n) {
                    case 4: {
                        if (!Filter.isSubQAlias(stringArray[i])) {
                            stringArray[i] = this.getSpmMappedValueCol(stringArray[i] + ".VNAME_PREFIX") + " || " + this.getSpmMappedValueCol(stringArray[i] + ".VNAME_SUFFIX");
                        }
                        stringArray[i] = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, stringArray[i], false, false);
                        continue block81;
                    }
                    case 6: {
                        stringArray[i] = this.stripEnclosingChars(stringArray[i]);
                        continue block81;
                    }
                    case 2: {
                        stringArray[i] = this.wrapSQLforBooleanNoQuotes(stringArray[i]);
                        continue block81;
                    }
                    case 3: 
                    case 29: 
                    case 30: 
                    case 31: {
                        stringArray[i] = this.wrapNumericforVCHARcomp(stringArray[i]);
                        continue block81;
                    }
                    case 21: 
                    case 23: {
                        stringArray[i] = this.wrapSQLforCLOBcomp(stringArray[i], null, "'http://www.opengis.net/ont/geosparql#wktLiteral'");
                        continue block81;
                    }
                    case 25: {
                        stringArray[i] = this.wrapSQLforGEOMtoVC(stringArray[i]);
                        continue block81;
                    }
                    case 27: {
                        stringArray[i] = stringArray[i] + "." + "VALUE_NAME";
                        if (i != 1) continue block81;
                        stringArray[i] = "REPLACE(" + stringArray[i] + ",'\\','')";
                        continue block81;
                    }
                    case 28: {
                        stringArray[i] = "MDSYS.SDO_RDF.VNAME(" + stringArray[i] + ")";
                        if (i != 1) continue block81;
                        stringArray[i] = "REPLACE(" + stringArray[i] + ",'\\','')";
                        continue block81;
                    }
                    default: {
                        if (i != 1) continue block81;
                        stringArray[i] = this.removeEscapeChars(stringArray[i]);
                    }
                }
            }
            if (this.ctx.unescapeUniRegex && !this.ctx.networkStorageForm.equals("UNESC")) {
                stringArray[0] = this.wrapForUnicodeUnescape(stringArray[0]);
                stringArray[1] = this.wrapForUnicodeUnescape(stringArray[1]);
            }
            if (string12 == null) return "(REGEXP_INSTR(" + stringArray[0] + ", " + stringArray[1] + ") > 0)";
            return "(REGEXP_INSTR(" + stringArray[0] + ", " + stringArray[1] + ", 1,1,0, " + string12 + ") > 0)";
        }
        if (string.equals(REPLACE_OP)) {
            int n5;
            Object object;
            String string14 = null;
            if (aSTBuiltInCall.jjtGetNumChildren() > 3) {
                string14 = this.getRegexFlag(stringArray[3]);
            }
            String string15 = "1";
            if (this.ctx.useExactForExpr) {
                string15 = "0";
            }
            if (this.ctx.clobExpSupport) {
                string3 = SPARQL_REPLACE_FUNC;
                String string16 = this.sparqlCOALESCEList(aSTBuiltInCall, stringArray, map2, this.ctx.unescapeUniRegex && !this.ctx.networkStorageForm.equals("UNESC"), map);
                string3 = string14 != null ? string3 + "(" + string16 + "," + string14 + ")" : string3 + "(" + string16 + ", NULL)";
                if (!this.ctx.unescapeUniRegex) return string3;
                if (this.ctx.networkStorageForm.equals("UNESC")) return string3;
                if ((this.ctx.contextFlags & 8) <= 0) return "SDO_RDF_TERM(" + string3 + "." + "VALUE_TYPE" + "," + this.wrapForUnicodeEscape(string3 + "." + "VALUE_NAME") + "," + string3 + "." + "LITERAL_TYPE" + "," + string3 + "." + "LANGUAGE_TYPE" + "," + this.wrapForUnicodeEscapeClob(string3 + "." + "LONG_VALUE") + ")";
                return "SDO_RDF_TERM(" + string3 + "." + "VALUE_TYPE" + "," + this.wrapForUnicodeEscape(string3 + "." + "VALUE_NAME") + "," + string3 + "." + "LITERAL_TYPE" + "," + string3 + "." + "LANGUAGE_TYPE" + "," + this.wrapForUnicodeEscapeClob("NULL") + ")";
            }
            if (this.ctx.rdftStrExp || this.nestedFuncExists && !this.ctx.noRdftStrExp) {
                List<String[]> list = this.prepareExtFuncArgs(aSTBuiltInCall, stringArray, map2, 0, map);
                StringBuffer stringBuffer = new StringBuffer("SYS.ODCIVarchar2List(");
                for (int i = 0; i < 3; ++i) {
                    String string17 = "";
                    if (i > 0) {
                        stringBuffer.append(",\n");
                    }
                    string17 = QueryUtils.buildOptTerm(list.get(i));
                    if (this.ctx.unescapeUniRegex && !this.ctx.networkStorageForm.equals("UNESC")) {
                        string17 = this.wrapForUnicodeUnescape(string17);
                    }
                    stringBuffer.append(string17);
                }
                stringBuffer.append(")");
                string3 = string14 != null ? "mdsys.sdo_rdf.sparql_replace(" + stringBuffer.toString() + "," + string14 + "," + string15 + ")" : "mdsys.sdo_rdf.sparql_replace(" + stringBuffer.toString() + ",NULL," + string15 + ")";
                if (!this.ctx.unescapeUniRegex) return string3;
                if (this.ctx.networkStorageForm.equals("UNESC")) return string3;
                return this.wrapForUnicodeEscape(string3);
            }
            String[][][] stringArray19 = new String[3][6][1];
            for (int i = 0; i < 3; ++i) {
                object = (SimpleNode)aSTBuiltInCall.jjtGetChild(i);
                this.decomposeRDFTerm((SimpleNode)object, stringArray[i], map2, stringArray19[i][0], stringArray19[i][1], stringArray19[i][2], stringArray19[i][3], stringArray19[i][4], stringArray19[i][5], map);
                if (!this.ctx.unescapeUniRegex || this.ctx.networkStorageForm.equals("UNESC")) continue;
                stringArray19[i][1][0] = this.wrapForUnicodeUnescape(stringArray19[i][1][0]);
                stringArray19[i][2][0] = this.wrapForUnicodeUnescape(stringArray19[i][2][0]);
            }
            String string18 = stringArray19[0][1][0] + "||" + stringArray19[0][2][0];
            object = "REPLACE(" + stringArray19[1][1][0] + "||" + stringArray19[1][2][0] + ", '\\\\', '\\')";
            String string19 = stringArray19[2][1][0] + "||" + stringArray19[2][2][0];
            String string20 = "REGEXP_REPLACE(REGEXP_REPLACE(REGEXP_REPLACE(REGEXP_REPLACE(\n" + string19 + ",'([^\\\\]|^)\\$([[:digit:]]{1})','\\1\\\\\\2')\n,'([^\\\\]|^)\\$([[:digit:]]{1})','\\1\\\\\\2')\n,'([^\\\\]|^)\\\\\\\\\\$','\\1$')\n,'([^\\\\]|^)\\\\\\\\\\$','\\1$')";
            String string21 = "(NVL2(" + string14 + ", \nREGEXP_REPLACE(" + string18 + "," + (String)object + "," + string20 + ",1,0," + string14 + "),\nREGEXP_REPLACE(" + string18 + ",\n" + (String)object + ",\n" + string20 + ")))";
            String string22 = stringArray19[0][0][0];
            String string23 = stringArray19[0][3][0];
            String string24 = stringArray19[0][4][0];
            string3 = "(CASE WHEN (";
            for (n5 = 0; n5 < 3; ++n5) {
                if (n5 > 0) {
                    string3 = string3 + "\nOR ";
                }
                string3 = string3 + stringArray19[n5][0][0] + " NOT IN ('PL', 'PLL', 'TL', 'TLL', 'PL@', 'PLL@', 'LIT', 'CPLL','CPLL@','CTLL') ";
            }
            string3 = string3 + ") THEN NULL";
            string3 = string3 + "\nWHEN (";
            for (n5 = 0; n5 < 3; ++n5) {
                if (n5 > 0) {
                    string3 = string3 + "\nAND ";
                }
                string3 = string3 + "NVL(" + stringArray19[n5][3][0] + ",'" + "http://www.w3.org/2001/XMLSchema#string" + "') = '" + "http://www.w3.org/2001/XMLSchema#string" + "'";
            }
            string3 = string3 + ") \nTHEN " + string4 + "(" + string21 + ",\n" + string22 + ",\n" + string23 + ",\n" + string24 + ")";
            string3 = string3 + "\n ELSE NULL END)";
            if (!this.ctx.unescapeUniRegex) return string3;
            if (this.ctx.networkStorageForm.equals("UNESC")) return string3;
            return this.wrapForUnicodeEscape(string3);
        }
        if (string.equals(ISNUMERIC_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 1) return Filter.concatStrArray(stringArray, " ");
            SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(0);
            n = Filter.getNodeRetType(simpleNode, map2, this.ctx);
            switch (n) {
                case 27: {
                    stringArray[0] = "NVL2(" + stringArray[0] + "." + "VALUE_TYPE" + ", (CASE WHEN (" + stringArray[0] + "." + "VALUE_TYPE" + " IN ('" + "LIT" + "', 'TL')) AND \n(" + stringArray[0] + "." + "LITERAL_TYPE" + " IN  ('" + "http://www.w3.org/2001/XMLSchema#double" + "','" + "http://www.w3.org/2001/XMLSchema#decimal" + "','" + "http://www.w3.org/2001/XMLSchema#float" + "','" + "http://www.w3.org/2001/XMLSchema#int" + "','" + "http://www.w3.org/2001/XMLSchema#integer" + "','" + "http://www.w3.org/2001/XMLSchema#long" + "','" + "http://www.w3.org/2001/XMLSchema#short" + "','" + "http://www.w3.org/2001/XMLSchema#nonPositiveInteger" + "','" + "http://www.w3.org/2001/XMLSchema#negativeInteger" + "','" + "http://www.w3.org/2001/XMLSchema#byte" + "','" + "http://www.w3.org/2001/XMLSchema#nonNegativeInteger" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedByte" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedInt" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedLong" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedShort" + "','" + "http://www.w3.org/2001/XMLSchema#positiveInteger" + "')) THEN 1 ELSE 0 END),\nNULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 28: {
                    stringArray[0] = "NVL2(MDSYS.SDO_RDF.VTYPE(" + stringArray[0] + "), (CASE WHEN (" + "MDSYS.SDO_RDF.VTYPE" + "(" + stringArray[0] + ") IN ('" + "LIT" + "', 'TL')) AND \n(" + "MDSYS.SDO_RDF.LTYPE" + "(" + stringArray[0] + ") IN  ('" + "http://www.w3.org/2001/XMLSchema#double" + "','" + "http://www.w3.org/2001/XMLSchema#decimal" + "','" + "http://www.w3.org/2001/XMLSchema#float" + "','" + "http://www.w3.org/2001/XMLSchema#int" + "','" + "http://www.w3.org/2001/XMLSchema#integer" + "','" + "http://www.w3.org/2001/XMLSchema#long" + "','" + "http://www.w3.org/2001/XMLSchema#short" + "','" + "http://www.w3.org/2001/XMLSchema#nonPositiveInteger" + "','" + "http://www.w3.org/2001/XMLSchema#negativeInteger" + "','" + "http://www.w3.org/2001/XMLSchema#byte" + "','" + "http://www.w3.org/2001/XMLSchema#nonNegativeInteger" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedByte" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedInt" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedLong" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedShort" + "','" + "http://www.w3.org/2001/XMLSchema#positiveInteger" + "')) THEN 1 ELSE 0 END),\nNULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 4: {
                    String string25 = "";
                    String string26 = "";
                    if (Filter.isSubQAlias(stringArray[0])) {
                        if ((this.ctx.contextFlags & 8) > 0 && this.ctx.vjoinVars != null && this.ctx.vjoinVars.contains(((ASTTripleAtom)simpleNode).name)) {
                            string25 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetValTyp(" + stringArray[0] + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                            string26 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetLitType(" + stringArray[0] + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                        } else {
                            string25 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, stringArray[0] + "$RDFVTYP", false, false);
                            string26 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, stringArray[0] + "$RDFLTYP", false, false);
                        }
                    } else if ((this.ctx.contextFlags & 8) > 0) {
                        String string27 = map.get(((ASTTripleAtom)simpleNode).name.toUpperCase());
                        string25 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetValTyp(" + string27 + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                        string26 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, "mdsys.sdo_rdf.GetLitType(" + string27 + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                    } else {
                        string25 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, this.getSpmMappedValueCol(stringArray[0] + "." + "VALUE_TYPE") + string5, false, false);
                        string26 = this.wrapVColForAgg(((ASTTripleAtom)simpleNode).name, this.getSpmMappedValueCol(stringArray[0] + "." + "LITERAL_TYPE"), false, false);
                    }
                    stringArray[0] = "NVL2(" + string25 + ", (CASE WHEN (" + string25 + " IN ('LIT','TL')) AND \n(" + string26 + " IN ('" + "http://www.w3.org/2001/XMLSchema#double" + "','" + "http://www.w3.org/2001/XMLSchema#decimal" + "','" + "http://www.w3.org/2001/XMLSchema#float" + "','" + "http://www.w3.org/2001/XMLSchema#int" + "','" + "http://www.w3.org/2001/XMLSchema#integer" + "','" + "http://www.w3.org/2001/XMLSchema#long" + "','" + "http://www.w3.org/2001/XMLSchema#short" + "','" + "http://www.w3.org/2001/XMLSchema#nonPositiveInteger" + "','" + "http://www.w3.org/2001/XMLSchema#negativeInteger" + "','" + "http://www.w3.org/2001/XMLSchema#byte" + "','" + "http://www.w3.org/2001/XMLSchema#nonNegativeInteger" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedByte" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedInt" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedLong" + "','" + "http://www.w3.org/2001/XMLSchema#unsignedShort" + "','" + "http://www.w3.org/2001/XMLSchema#positiveInteger" + "'))  THEN 1 ELSE 0 END),\n  NULL) = 1";
                    return Filter.concatStrArray(stringArray, " ");
                }
                case 3: 
                case 12: 
                case 29: 
                case 30: 
                case 31: {
                    stringArray[0] = "(NVL2(" + stringArray[0] + ", 1, NULL) = 1)";
                    return Filter.concatStrArray(stringArray, " ");
                }
                default: {
                    stringArray[0] = "(NVL2(" + stringArray[0] + ", 0, NULL) = 1)";
                }
            }
            return Filter.concatStrArray(stringArray, " ");
        }
        if (string.equals(IF_OP)) {
            if (aSTBuiltInCall.jjtGetNumChildren() != 3) return string3;
            SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(0);
            String string28 = this.getEBVSQL(simpleNode, stringArray[0], map2, map);
            SimpleNode simpleNode3 = (SimpleNode)aSTBuiltInCall.jjtGetChild(1);
            SimpleNode simpleNode4 = (SimpleNode)aSTBuiltInCall.jjtGetChild(2);
            if (!this.ctx.clobExpSupport) return "(CASE WHEN (" + string28 + ")\nTHEN " + this.buildInLineTermExpr(simpleNode3, stringArray[1], map2, map, false, false) + "\nWHEN NOT (" + string28 + ")\nTHEN " + this.buildInLineTermExpr(simpleNode4, stringArray[2], map2, map, false, false) + "\nELSE NULL END)";
            return "sem_apis.sparql_if ( \n(CASE WHEN (" + string28 + ") THEN 1 \n WHEN NOT (" + string28 + ") THEN 0 \n ELSE NULL END),\n" + this.sparqlIFList(simpleNode3, simpleNode4, stringArray, map2, map) + ")";
        }
        if (string.equals(COALESCE_OP)) {
            if (this.ctx.clobExpSupport) {
                String string29 = "";
                string29 = aSTBuiltInCall.jjtGetNumChildren() > 0 ? this.sparqlCOALESCEList(aSTBuiltInCall, stringArray, map2, false, map) : " SYS.ODCIVarchar2List(NULL),\n SYS.ODCIVarchar2List(NULL),\n SYS.ODCIVarchar2List(NULL),\n SYS.ODCIVarchar2List(NULL),\n SYS.ODCIVarchar2List(NULL),\n MDSYS.RDF_CLOBS     (NULL)";
                return "sem_apis.sparql_coalesce ( \n" + string29 + ")";
            }
            if (aSTBuiltInCall.jjtGetNumChildren() == 0) {
                return "NULL";
            }
            if (aSTBuiltInCall.jjtGetNumChildren() > 1) {
                string3 = "(COALESCE(";
            }
            int n6 = aSTBuiltInCall.jjtGetNumChildren();
            for (int i = 0; i < n6; ++i) {
                if (i > 0) {
                    string3 = string3 + ",";
                }
                SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(i);
                string3 = string3 + this.buildInLineTermExpr(simpleNode, stringArray[i], map2, map, false, false);
            }
            if (aSTBuiltInCall.jjtGetNumChildren() <= 1) return string3;
            return string3 + "))";
        }
        if (string.equals(EXISTS_OP) || string.equals(NOT_EXISTS_OP)) {
            Object object;
            String string30 = EXISTS_OP;
            if (this.ctx.disableNotExists) {
                string30 = IN_OP;
            }
            String string31 = "OR";
            if (string.equals(NOT_EXISTS_OP)) {
                string30 = NOT_EXISTS_OP;
                if (this.ctx.disableNotExists) {
                    string30 = NOT_IN_OP;
                }
                string31 = "AND";
            }
            SPARQLTreeNode sPARQLTreeNode = SPARQLEngine.buildSPARQLTree(aSTBuiltInCall, this.ctx, this.activeGraph, this.inScopeVars, this.pfInScopeVars, null);
            Set<String> set = QueryUtils.getCommonVars(sPARQLTreeNode.getCumulativeVars(), this.getVars());
            Set<String> set2 = this.defBoundVars;
            Set<String> set3 = sPARQLTreeNode.getDefiniteBoundVars();
            Set<String> set4 = QueryUtils.getCommonVars(set, sPARQLTreeNode.getRequiredLexVars());
            set4.addAll(QueryUtils.getCommonVars(set, this.lexVars));
            String[] stringArray20 = set.toArray(new String[0]);
            String[] stringArray21 = new String[set.size()];
            String[] stringArray22 = new String[set.size()];
            String[] stringArray23 = new String[set.size()];
            String[] stringArray24 = new String[set.size()];
            String string32 = "SELECT ";
            boolean bl5 = false;
            for (String string33 : set) {
                if (set3.contains(string33)) continue;
                bl5 = true;
                break;
            }
            if (set.isEmpty()) {
                string32 = string32 + "1";
            } else {
                void var32_109;
                boolean bl6 = false;
                boolean bl7 = false;
                while (var32_109 < stringArray20.length) {
                    object = stringArray20[var32_109];
                    if (bl6) {
                        string32 = string32 + ",";
                    }
                    bl6 = true;
                    if (set4.contains(object)) {
                        stringArray21[var32_109] = this.getTermForVar((String)object, "" + map4.get(((String)object).toUpperCase()), map);
                        stringArray22[var32_109] = "'0'";
                        stringArray23[var32_109] = (String)object + "$RDFTERM";
                        stringArray24[var32_109] = "'0'";
                        string32 = string32 + this.getTermForVar((String)object, "E." + (String)object, map) + " AS " + (String)object + "$RDFTERM";
                    } else {
                        stringArray21[var32_109] = this.getVIDExpr((String)object, "" + map4.get(((String)object).toUpperCase()), map);
                        stringArray22[var32_109] = "0";
                        stringArray23[var32_109] = (String)object + "$RDFVID";
                        stringArray24[var32_109] = "0";
                        string32 = string32 + this.getVIDExpr((String)object, "E." + (String)object, map) + " AS " + (String)object + "$RDFVID";
                    }
                    ++var32_109;
                }
            }
            Object object2 = "";
            try {
                Object object32;
                sPARQLTreeNode.initFilters();
                List<Filter> list = sPARQLTreeNode.getNonLocalFilters();
                object = sPARQLTreeNode.getCumulativeVars();
                for (Object object32 : list) {
                    sPARQLTreeNode.addProjectVars(QueryUtils.getCommonVars(((Filter)object32).getfJoinVars(), (Set<String>)object));
                }
                sPARQLTreeNode.addProjectVars(QueryUtils.getCommonVars(sPARQLTreeNode.getCumulativeVars(), set4));
                SPARQLEngine.prepareSTreeForTrans(sPARQLTreeNode, this.ctx, this.lexVars);
                String string34 = sPARQLTreeNode.getAntiJoinHint();
                if (bl5) {
                    object32 = "potentially unbound variables are not supported inside EXISTS and NOT EXISTS in this context";
                    if (this.currGpSQL == null) throw new RDFException((String)object32);
                    try {
                        object2 = ((SimpleSPARQLTreeNode)sPARQLTreeNode).toSQL(this.currGpSQL, this.gpVars, set2, this.gpProjVars, this.gpLexVars, this.gpVars);
                    }
                    catch (ClassCastException classCastException) {
                        throw new RDFException((String)object32);
                    }
                } else {
                    object2 = sPARQLTreeNode.toSQL();
                }
                object32 = new StringBuffer("");
                HashMap<String, String> hashMap = new HashMap<String, String>(map4);
                HashMap<String, String> hashMap2 = null;
                if (map != null) {
                    hashMap2 = new HashMap<String, String>(map);
                }
                for (String string35 : sPARQLTreeNode.getCumulativeVars()) {
                    hashMap.put(string35, "E." + string35);
                    if (hashMap2 == null) continue;
                    hashMap2.put(string35, "E." + string35 + "$RDFVID");
                }
                for (Filter filter : list) {
                    ((StringBuffer)object32).append("\nAND " + filter.toSQL(hashMap, hashMap2, map2, map3));
                }
                String string36 = string32 + "\nFROM (\n" + (String)object2 + ") E\nWHERE (1=1)" + ((StringBuffer)object32).toString();
                if (!set.isEmpty()) return "(" + QueryUtils.buildMaskedInListClause(stringArray20, set2, set3, stringArray21, stringArray23, stringArray22, stringArray24, string36, "E", string30, string31, true, string34, this.ctx) + ")";
                string3 = "(" + string30 + "\n(SELECT " + (String)string34 + " *\nFROM(" + (String)string36 + ")))";
                if (!this.ctx.disableNotExists) return string3;
                return "(1\n" + string30 + "\n(SELECT " + (String)string34 + " *\nFROM(" + (String)string36 + ")))";
            }
            catch (TypeException typeException) {
                throw new RDFException(typeException.getMessage());
            }
        }
        List<String[]> list = this.prepareExtFuncArgs(aSTBuiltInCall, stringArray, map2, 0, map);
        FilterFuncHandler filterFuncHandler = map3.get(string);
        if (filterFuncHandler == null) {
            throw new RDFException(UNSUPPORTED_FUNC_ERROR + string);
        }
        String string37 = "";
        if ((string.equals("IRI") || string.equals(FUNC_URI)) && this.ctx.baseURIset == 1) {
            string37 = string37 + " BASE_URI=" + this.ctx.baseURI + " ";
        } else if (this.singleVCLexVarArg(aSTBuiltInCall)) {
            string37 = string37 + " SINGLE_VC_LEX_VAR=TRUE ";
        }
        if (!this.nestedFuncExists) return filterFuncHandler.genSQL(list, string, string37);
        string37 = string37 + " NESTED_INPUT=TRUE ";
        return filterFuncHandler.genSQL(list, string, string37);
    }

    private String buildIdForCoalesceNonLex(Map<String, String> map) throws RDFException {
        String string = "";
        if (this.filterRoot != null) {
            if (this.filterRoot.id != 88) {
                throw new RDFException(NO_COALESCE_ERROR);
            }
            if (!((ASTBuiltInCall)this.filterRoot).name.equals(COALESCE_OP)) {
                throw new RDFException(NO_COALESCE_ERROR);
            }
            for (int i = 0; i < this.filterRoot.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode = (SimpleNode)this.filterRoot.jjtGetChild(i);
                if (simpleNode.id != 73) {
                    throw new RDFException(COALESCE_TYPE_ERROR);
                }
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                if (aSTTripleAtom.type != 0) {
                    throw new RDFException(COALESCE_TYPE_ERROR);
                }
                String string2 = map.get(aSTTripleAtom.name);
                if (i > 0) {
                    string = string + ",";
                }
                string = string + string2;
            }
            if (this.filterRoot.jjtGetNumChildren() > 1) {
                string = "COALESCE(" + string + ")";
            }
        }
        return string;
    }

    private String wrapForUnicodeUnescape(String string) {
        return "MDSYS.SDO_RDF.UNESCAPE_RDF_VALUE(" + string + ",options=>'UNI_ONLY=T')";
    }

    private String wrapForUnicodeUnescapeClob(String string) {
        return "MDSYS.SDO_RDF.UNESCAPE_CLOB_VALUE(" + string + ",options=>'UNI_ONLY=T')";
    }

    private String wrapForUnicodeEscape(String string) {
        return "MDSYS.SDO_RDF.ESCAPE_RDF_VALUE(" + string + ",options=>'UNI_ONLY=T ESC_SBYTE_OPT=F')";
    }

    private String wrapForUnicodeEscapeClob(String string) {
        return "MDSYS.SDO_RDF.ESCAPE_CLOB_VALUE(" + string + ",options=>'UNI_ONLY=T ESC_SBYTE_OPT=F')";
    }

    private boolean singleVCLexVarArg(SimpleNode simpleNode) {
        boolean bl = false;
        if (simpleNode.jjtGetNumChildren() == 1) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
            if (simpleNode2.id == 73) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode2;
                if (aSTTripleAtom.type == 0 && this.lexVars.contains(aSTTripleAtom.name) && this.ctx.vcTerms) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private String buildInLineStrExpr(ASTTripleAtom aSTTripleAtom, String string, Map<String, String> map, Map<String, String> map2) throws RDFException {
        String string2 = null;
        if (this.isRDFViewOptCase(aSTTripleAtom, string)) {
            String string3 = string + "$RDFTERM";
            string2 = "DECODE(SUBSTR(" + string3 + ",1,1),'_'," + string3 + ",'\"',SUBSTR(" + string3 + ",2,INSTR(" + string3 + ",'\"',-1)-2),'<',SUBSTR(" + string3 + ",2,LENGTH(" + string3 + ")-2),NULL)";
        } else {
            String[] stringArray = new String[8];
            this.popVDollarColArray(aSTTripleAtom, string, map, false, stringArray, map2);
            string2 = "NVL2(" + stringArray[1] + ",(CASE WHEN(" + stringArray[4] + " = '" + "http://www.w3.org/2001/XMLSchema#time" + "' AND SUBSTR(" + stringArray[0] + ",1,1) IN ('@','+','-')) THEN SUBSTR(NVL(" + stringArray[0] + ",chr(0)),2)  ELSE NVL(" + stringArray[0] + ",chr(0)) END),NULL)";
        }
        return string2;
    }

    private String buildNumericTermExpr(String string, String string2) {
        return "NVL2(" + string + ",'\"'||" + QueryUtils.buildSafeToChar(string) + "||'\"^^<" + string2 + ">',NULL)";
    }

    private String buildInLineTermExpr(SimpleNode simpleNode, String string, Map<String, String> map, Map<String, String> map2, boolean bl, boolean bl2) throws RDFException {
        int n = Filter.getNodeRetType(simpleNode, map, this.ctx);
        String string2 = "";
        if (n == 28) {
            string2 = string;
        } else if (n == 27) {
            string2 = string + SRT_TO_VC_TERM;
        } else if (this.isRDFViewOptCase(simpleNode, string)) {
            string2 = this.getTermForVar(((ASTTripleAtom)simpleNode).name, string, map2);
        } else if (n == 6) {
            string2 = string;
        } else if (n == 5) {
            string2 = "NVL2(" + string + ",'<'||" + string + "||'>',NULL)";
        } else if (n == 8) {
            string2 = "NVL2(" + string + ",'\"'||REPLACE(" + string + ",chr(0))||'\"',NULL)";
        } else if (n == 2) {
            string2 = "NVL2(" + this.wrapSQLforBooleanNoQuotes(string) + ",'\"'||" + this.wrapSQLforBooleanNoQuotes(string) + "||'\"^^<" + "http://www.w3.org/2001/XMLSchema#boolean" + ">',NULL)";
        } else if (n == 3) {
            string2 = this.buildNumericTermExpr(string, "http://www.w3.org/2001/XMLSchema#decimal");
        } else if (n == 29) {
            string2 = this.buildNumericTermExpr(string, "http://www.w3.org/2001/XMLSchema#integer");
        } else if (n == 31) {
            string2 = this.buildNumericTermExpr(string, "http://www.w3.org/2001/XMLSchema#float");
        } else if (n == 30) {
            string2 = this.buildNumericTermExpr(string, "http://www.w3.org/2001/XMLSchema#double");
        } else if (n == 26) {
            string2 = "NVL2(" + string + ",'\"'||" + this.wrapDateTimeforVCHARcomp(string) + "||'\"^^<" + "http://www.w3.org/2001/XMLSchema#dateTime" + ">',NULL)";
        } else if (n == 20) {
            string2 = "'\"'||REPLACE(" + string + ",chr(0))||'\"'";
        } else if (n == 11) {
            string2 = "'\"'||REPLACE(" + string + ",chr(0))||'\"^^<" + "http://www.w3.org/2001/XMLSchema#string" + ">'";
        } else if (n == 9) {
            String string3 = QueryUtils.escapeSingleQuotes(((ASTTripleAtom)simpleNode).litLang);
            if (bl2) {
                string3 = string3.toLowerCase();
            }
            string2 = "'\"'||REPLACE(" + string + ",chr(0))||'\"@" + string3 + "'";
        } else if (n == 1 || n == 10 || n == 12 || n == 13 || n == 14 || n == 15 || n == 16 || n == 17 || n == 18 || n == 19) {
            try {
                string2 = QueryUtils.enquoteLiteral(((ASTTripleAtom)simpleNode).printSPARQLTextForUpd());
            }
            catch (SQLException | ParseException exception) {
                throw new RDFException(exception.getMessage());
            }
        } else {
            String[] stringArray = new String[1];
            String[] stringArray2 = new String[1];
            String[] stringArray3 = new String[1];
            String[] stringArray4 = new String[1];
            String[] stringArray5 = new String[1];
            String[] stringArray6 = new String[1];
            this.decomposeRDFTerm(simpleNode, string, map, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, map2);
            String string4 = stringArray2[0] + " || " + stringArray3[0];
            string2 = QueryUtils.buildInLineRDFT(string4, stringArray[0], stringArray5[0], stringArray4[0], bl, bl2);
        }
        return string2;
    }

    private String getSQLforAggregateFunct(ASTAggregate aSTAggregate, String[] stringArray, Map<String, String> map, Map<String, String> map2, boolean bl, Map<String, FilterFuncHandler> map3) throws RDFException {
        String string = "";
        int n = 0;
        String string2 = "";
        boolean bl2 = false;
        SimpleNode simpleNode = null;
        String string3 = "";
        String string4 = "";
        string = aSTAggregate.name;
        if (aSTAggregate.distinct != "") {
            bl2 = true;
            string2 = string2 + " DISTINCT ";
        }
        if (aSTAggregate.jjtGetNumChildren() > 0) {
            simpleNode = (SimpleNode)aSTAggregate.jjtGetChild(0);
            n = Filter.getNodeRetType((SimpleNode)aSTAggregate.jjtGetChild(0), map2, this.ctx);
        }
        int n2 = Filter.isAggregateSpecialCase(aSTAggregate, map2, this.ctx);
        if (string.equals("COUNT")) {
            string4 = aSTAggregate.modifier;
            if (!string4.equals("*")) {
                switch (n) {
                    case 4: {
                        if (this.isNonLex(simpleNode)) {
                            string4 = this.getVIDExpr(((ASTTripleAtom)simpleNode).name, stringArray[0], map);
                            break;
                        }
                        if (this.isRDFViewOptCase(simpleNode, stringArray[0])) {
                            string4 = this.getTermForVar(((ASTTripleAtom)simpleNode).name, stringArray[0], map);
                            break;
                        }
                        string4 = this.buildVDollarFuncCall(RDFT_VDOLLAR_FUNC, simpleNode, stringArray[0], map2, map);
                        break;
                    }
                    default: {
                        string4 = this.buildInLineTermExpr(simpleNode, stringArray[0], map2, map, false, false);
                    }
                }
            }
            string2 = "COUNT(" + string2 + string4 + ")";
        } else if (string.equals("SUM") || string.equals("AVG")) {
            if (n == 4) {
                int n3 = Filter.getAtomPosition(((ASTTripleAtom)simpleNode).name, map, this.ctx);
                string4 = this.getRelExprOrdColVar(((ASTTripleAtom)simpleNode).name, stringArray[0], 3, n3);
                if (string4 == null) {
                    string4 = this.buildVDollarFuncCall(NUMERIC_VDOLLAR_FUNC, simpleNode, stringArray[0], map2, map);
                }
            } else {
                string4 = n == 3 || n == 29 || n == 30 || n == 31 ? stringArray[0] : this.buildVDollarFuncCall(NUMERIC_VDOLLAR_FUNC, simpleNode, stringArray[0], map2, map);
            }
            string3 = string.equals("SUM") ? "SUM" : "AVG";
            string2 = string3 + "(" + string2 + string4 + ")";
        } else if (string.equals(GROUP_CONCAT_OP)) {
            String string5 = "";
            try {
                string5 = QueryUtils.enquoteLiteral(aSTAggregate.modifier);
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage());
            }
            if (!this.ctx.clobAggSupport) {
                if (this.ctx.inlineAggregates && n2 == 1) {
                    string2 = QueryUtils.shortenVNforTerm("(LISTAGG(" + string2 + " " + stringArray[0] + "," + string5 + ") WITHIN GROUP (ORDER BY 'a'))", null, null);
                } else {
                    string3 = SEM_APIS_GROUP_CONCAT_VC;
                    string4 = this.buildInLineTermExpr(simpleNode, stringArray[0], map2, map, false, false);
                    String string6 = "lpad(" + QueryUtils.buildSafeToChar("lengthb(" + string5 + ")") + ",4,'0') || " + string5 + " ";
                    string4 = string6 + " || " + string4;
                    string2 = string3 + "(" + string2 + " " + string4 + ")";
                }
            } else {
                string3 = SEM_APIS_GROUP_CONCAT;
                string4 = this.buildVDollarFuncCall(RDFT_SDO_RDF_TERM, simpleNode, stringArray[0], map2, map);
                string4 = string4.substring(0, string4.length() - 1) + "," + string5 + ")";
                string2 = string3 + "(" + string2 + " " + string4 + ")";
            }
        } else if (string.equals(SAMPLE_OP)) {
            if (!this.ctx.clobAggSupport) {
                string3 = "MAX";
                if (!this.ctx.inlineAggregates) {
                    string3 = SEM_APIS_SAMPLE_VC;
                }
                string4 = this.buildInLineTermExpr(simpleNode, stringArray[0], map2, map, false, false);
                string2 = string3 + "(" + string4 + ")";
            } else {
                string3 = SEM_APIS_SAMPLE;
                string4 = n == 27 ? stringArray[0] : this.buildVDollarFuncCall(RDFT_SDO_RDF_TERM, simpleNode, stringArray[0], map2, map);
                string2 = string3 + "(" + string4 + ")";
            }
        } else if (string.equals("MIN") || string.equals("MAX")) {
            if (!this.ctx.clobAggSupport) {
                if (this.ctx.inlineAggregates && (n2 == 2 || n2 == 3 || n2 == 4)) {
                    string3 = string.equals("MAX") ? "MAX" : "MIN";
                    if (n2 == 3 && this.ctx.unescapeStrFunc && !this.ctx.networkStorageForm.equals("UNESC")) {
                        string2 = "sem_apis.escape_rdf_value(" + string3 + "(" + Filter.wrapUnescape(stringArray[0]) + "))";
                    } else {
                        if ((this.ctx.contextFlags & 8) > 0 && simpleNode.id == 73) {
                            int n4 = Filter.getAtomPosition(((ASTTripleAtom)simpleNode).name, map, this.ctx);
                            string4 = n2 == 2 ? this.getRelExprOrdColVar(((ASTTripleAtom)simpleNode).name, stringArray[0], 3, n4) : this.getRelExprOrdColVar(((ASTTripleAtom)simpleNode).name, stringArray[0], 26, n4);
                            stringArray[0] = string4;
                        }
                        string2 = string3 + "(" + stringArray[0] + ")";
                    }
                } else {
                    string3 = string.equals("MIN") ? SEM_APIS_MIN_VC : SEM_APIS_MAX_VC;
                    string4 = this.buildInLineTermExpr(simpleNode, stringArray[0], map2, map, false, false);
                    string2 = string3 + "(" + string4 + ")";
                }
            } else {
                string3 = string.equals("MIN") ? SEM_APIS_MIN : SEM_APIS_MAX;
                string4 = n == 27 ? stringArray[0] : this.buildVDollarFuncCall(RDFT_SDO_RDF_TERM, simpleNode, stringArray[0], map2, map);
                string2 = string3 + "(" + string4 + ")";
            }
        }
        return string2;
    }

    public String getSQLForHavingCond(Map<String, String> map, Map<String, String> map2, Map<String, String> map3, Map<String, FilterFuncHandler> map4, Set<String> set) throws RDFException {
        String string = "";
        this.groupByVars = new HashSet<String>(set);
        string = this.filterToSQL(this.filterRoot, map, map2, map3, map4);
        return string;
    }

    private String getVIDExpr(String string, String string2, Map<String, String> map) {
        String string3 = null;
        if (!Filter.isSubQAlias(string2)) {
            if (map != null) {
                string3 = map.get(string.toUpperCase());
            }
            if (string3 == null) {
                string3 = string2 + "." + "VALUE_ID";
            }
        } else {
            string3 = string2 + "$RDFVID";
        }
        return this.wrapVColForAgg(string, string3, true, false);
    }

    private String getTermForVar(String string, String string2, Map<String, String> map) {
        String string3 = "";
        int[] nArray = AbstractSPARQLTreeNode.RDFT_VC_COLS;
        ArrayList<String> arrayList = new ArrayList<String>(8);
        String string4 = "";
        String string5 = "";
        int n = 0;
        if (!Filter.isSubQAlias(string2)) {
            if ((this.ctx.contextFlags & 8) > 0) {
                n = Filter.getAtomPosition(string, map, this.ctx);
                string5 = Filter.getAtomSuffix(n);
            }
            string4 = this.ctx.usingTopDownTrans ? this.getSpmMappedValueCol(string2 + "." + "VNAME_PREFIX") + string5 + " || " + this.getSpmMappedValueCol(string2 + "." + "VNAME_SUFFIX") + string5 : ((this.ctx.contextFlags & 8) > 0 ? QueryUtils.genVNameSubstr(string2 + "." + "VNAME_PREFIX" + string5 + " || " + string2 + "." + "VNAME_SUFFIX" + string5, "NULL", string2 + "." + "LANGUAGE_TYPE", string2 + "." + "LITERAL_TYPE") : QueryUtils.genVNameSubstr(this.getSpmMappedValueCol(string2 + "." + "VNAME_PREFIX") + " || " + this.getSpmMappedValueCol(string2 + "." + "VNAME_SUFFIX"), this.getSpmMappedValueCol(string2 + "." + "LONG_VALUE"), this.getSpmMappedValueCol(string2 + "." + "LANGUAGE_TYPE"), this.getSpmMappedValueCol(string2 + "." + "LITERAL_TYPE")));
            arrayList.add(this.wrapVColForAgg(string, string4, false, false));
            arrayList.add(this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + "VALUE_ID"), true, false));
            arrayList.add(this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + "VNAME_PREFIX") + string5, false, false));
            arrayList.add(this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + "VNAME_SUFFIX") + string5, false, false));
            arrayList.add(this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + "VALUE_TYPE") + string5, false, false));
            if ((this.ctx.contextFlags & 8) > 0) {
                arrayList.add(this.wrapVColForAgg(string, "NULL", false, true));
            } else {
                arrayList.add(this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + "LONG_VALUE"), false, true));
            }
            arrayList.add(this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + "LITERAL_TYPE"), false, false));
            arrayList.add(this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + "LANGUAGE_TYPE"), false, false));
        } else {
            string4 = this.ctx.usingTopDownTrans ? string2 : QueryUtils.genVNameSubstr(string2, string2 + "$RDFCLOB", string2 + "$RDFLANG", string2 + "$RDFLTYP");
            arrayList.add(this.wrapVColForAgg(string, string4, false, false));
            arrayList.add(this.wrapVColForAgg(string, string2 + "$RDFVID", true, false));
            arrayList.add(this.wrapVColForAgg(string, string2 + "$_PREFIX", false, false));
            arrayList.add(this.wrapVColForAgg(string, string2 + "$_SUFFIX", false, false));
            arrayList.add(this.wrapVColForAgg(string, string2 + "$RDFVTYP", false, false));
            arrayList.add(this.wrapVColForAgg(string, string2 + "$RDFCLOB", false, true));
            arrayList.add(this.wrapVColForAgg(string, string2 + "$RDFLTYP", false, false));
            arrayList.add(this.wrapVColForAgg(string, string2 + "$RDFLANG", false, false));
        }
        string3 = this.isRDFViewOptCase(string, string2) ? this.wrapVColForAgg(string, string2 + "$RDFTERM", false, false) : QueryUtils.buildFuncCall("SEM_APIS.COMPOSE_RDF_TERM", nArray, arrayList);
        return string3;
    }

    private String getVtypeExpr(String string, String string2) {
        String string3 = null;
        string3 = !Filter.isSubQAlias(string2) ? this.getSpmMappedValueCol(string2 + "." + "VALUE_TYPE") : string2 + "$RDFVTYP";
        return this.wrapVColForAgg(string, string3, false, false);
    }

    private String getBoundColumnExpr(ASTTripleAtom aSTTripleAtom, String string, Map<String, String> map) {
        String string2 = "";
        string2 = (this.ctx.filterFlags & 4) > 0 && !this.ctx.usingTopDownTrans || !this.isNonLex(aSTTripleAtom) ? this.getVtypeExpr(aSTTripleAtom.name, string) : this.getVIDExpr(aSTTripleAtom.name, string, map);
        return string2;
    }

    public String getEBVSQL(SimpleNode simpleNode, String string, Map<String, String> map, Map<String, String> map2) throws RDFException {
        String string2 = "";
        int n = Filter.getNodeRetType(simpleNode, map, this.ctx);
        switch (n) {
            case 2: {
                string2 = string;
                break;
            }
            case 3: 
            case 29: 
            case 30: 
            case 31: {
                string2 = "((" + string + ") != 0)";
                break;
            }
            case 1: 
            case 13: {
                string2 = "(" + Filter.normalizeBoolean(string) + " = " + TRUE_RDFTERM + ")";
                break;
            }
            case 4: 
            case 27: 
            case 28: {
                string2 = "(" + this.buildVDollarFuncCall(EBV_VDOLLAR_FUNC, simpleNode, string, map, map2) + " = 1)";
                break;
            }
            case 8: 
            case 11: 
            case 20: {
                string = this.wrapSQLforVCHARcomp(string);
                string2 = "(" + string + " != chr(0))";
                break;
            }
            case 21: 
            case 23: {
                string = this.wrapSQLforCLOBcomp(string, null, "'http://www.opengis.net/ont/geosparql#wktLiteral'");
                string2 = "(" + string + " != chr(0))";
                break;
            }
            case 25: {
                string = this.wrapSQLforGEOMtoVC(string);
                string2 = "(" + string + " != chr(0))";
                break;
            }
            case 12: {
                string2 = "(" + string + " != 0)";
                break;
            }
            default: {
                string2 = "(null=null)";
            }
        }
        return string2;
    }

    public String getRegexFlag(String string) {
        String string2 = "'";
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == 's') {
                string2 = string2 + "n";
                continue;
            }
            if (cArray[i] == 'm') {
                string2 = string2 + "m";
                continue;
            }
            if (cArray[i] == 'i') {
                string2 = string2 + "i";
                continue;
            }
            if (cArray[i] != 'x') continue;
            string2 = string2 + "x";
        }
        string2 = string2 + "'";
        return string2;
    }

    public String removeEscapeChars(String string) {
        String string2 = string.replace("\\\\", "\\");
        return string2;
    }

    public boolean hasNegationParent(Node node) {
        boolean bl = false;
        Node node2 = node;
        Node node3 = node2.jjtGetParent();
        while (node3 != null && !bl) {
            node2 = node3;
            if (((SimpleNode)node2).id == 86) {
                Node node4 = node2.jjtGetChild(0);
                if (((SimpleNode)node4).id == 87 && ((ASTUnaryOperator)node4).name.equals("!")) {
                    bl = true;
                }
            }
            node3 = node2.jjtGetParent();
        }
        return bl;
    }

    public boolean isRDFViewOptCase(Node node, String string) throws RDFException {
        boolean bl = false;
        if (Filter.getNodeRetType((SimpleNode)node, this.ctx.funcTypeMap, this.ctx) == 4) {
            String string2 = ((ASTTripleAtom)node).name;
            bl = this.isRDFViewOptCase(string2, string);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isRDFViewOptCase(String string, String string2) {
        return !this.ctx.disableRDFVFilterOpt && Filter.isSubQAlias(string2) && (this.ctx.isRdfVWModel || this.ctx.forceRDFVFilterOpt) && this.lexVars.contains(string);
    }

    public boolean allowsIdxBasedComp(SimpleNode simpleNode, Map<String, String> map) throws RDFException {
        boolean bl = false;
        if (!this.hasNegationParent(simpleNode) || (this.ctx.filterFlags & 2) > 0) {
            int n = Filter.getNodeRetType(simpleNode, map, this.ctx);
            switch (n) {
                case 1: 
                case 3: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 26: 
                case 29: 
                case 30: 
                case 31: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public String buildFuncCompStr(SimpleNode simpleNode, String string, String string2, SimpleNode simpleNode2, String string3, Map<String, String> map, Map<String, String> map2) throws RDFException {
        boolean bl;
        String string4 = "";
        String[] stringArray = this.buildExtFuncArray(simpleNode, string, map, map2);
        String[] stringArray2 = this.buildExtFuncArray(simpleNode2, string3, map, map2);
        boolean bl2 = bl = Integer.parseInt(stringArray[7]) == 28 || Integer.parseInt(stringArray2[7]) == 28;
        if (string2.equals("=") || string2.equals("!=")) {
            string4 = this.ctx.rdftStrExp || this.nestedFuncExists && !this.ctx.noRdftStrExp || bl && !this.ctx.noRdftStrExp ? "(mdsys.sdo_rdf.rdfTermEqual(" + QueryUtils.buildOptTerm(stringArray) + "," + QueryUtils.buildOptTerm(stringArray2) + ") " : "(sem_apis.rdfTermEqual(" + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ", " + stringArray[4] + ", " + stringArray[5] + ", " + stringArray2[1] + ", " + stringArray2[2] + ", " + stringArray2[3] + ", " + stringArray2[4] + ", " + stringArray2[5] + ") ";
            string4 = string4 + string2 + " 1)";
        } else {
            string4 = this.ctx.rdftStrExp || this.nestedFuncExists && !this.ctx.noRdftStrExp || bl && !this.ctx.noRdftStrExp ? "(mdsys.sdo_rdf.rdfTermComp(" + QueryUtils.buildOptTerm(stringArray) + "," + QueryUtils.buildOptTerm(stringArray2) : "(sem_apis.rdfTermComp(" + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ", " + stringArray[4] + ", " + stringArray[5] + ", " + stringArray2[1] + ", " + stringArray2[2] + ", " + stringArray2[3] + ", " + stringArray2[4] + ", " + stringArray2[5];
            if (!this.ctx.unescapeStrFunc) {
                string4 = string4 + ",0";
            }
            string4 = string4 + ") " + string2 + " 0)";
        }
        return string4;
    }

    public String stripEnclosingChars(String string) {
        String string2 = "";
        string2 = "substr(" + string + ", 2, (length(" + string + ") - 2))";
        return string2;
    }

    public String wrapSQLforBoolean(String string) {
        String string2 = "";
        string2 = "(case  when (" + string + ") then  '\"true\"^^<http://www.w3.org/2001/XMLSchema#boolean>' when NOT (" + string + ") then  '\"false\"^^<http://www.w3.org/2001/XMLSchema#boolean>' else NULL end)";
        return string2;
    }

    public String wrapSQLforBooleanPL(String string) {
        String string2 = "";
        string2 = "(case  when (" + string + ") then  '\"' || 'true' || '\"'  when NOT (" + string + ") then  '\"' || 'false' || '\"'  else NULL end)";
        return string2;
    }

    public String wrapSQLforBooleanNoQuotes(String string) {
        String string2 = "";
        string2 = "(case  when (" + string + ") then  'true'  when NOT (" + string + ") then  'false'  else NULL end)";
        return string2;
    }

    public String wrapSQLforBooleanNoNullNoQuotes(String string) {
        String string2 = "";
        string2 = "(case  when (" + string + ") then  'true'  else 'false' end)";
        return string2;
    }

    public String wrapSQLforTimestamp(String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        String string3 = "";
        String string4 = string.substring(1, string.length() - 1);
        if (bl3) {
            if (!string4.startsWith("T")) {
                string4 = "T" + string4;
            }
            string4 = DEFAULT_DATE + string4;
        }
        if (bl2) {
            string4 = string4 + DEFAULT_TZ;
        }
        string3 = bl ? "to_timestamp_tz('" + string4 + "', '" + string2 + "')" : "to_timestamp('" + string4 + "', '" + string2 + "')";
        return string3;
    }

    public String wrapSQLforLit(String string, String string2, String string3, boolean bl) {
        String string4 = "";
        string4 = "'\"' || " + string + " || '\"";
        if (string2 != null) {
            string4 = string4 + "^^<" + string2 + ">";
        }
        if (string3 != null) {
            string4 = string4 + "@" + string3;
        }
        string4 = string4 + "'";
        if (bl) {
            string4 = "NVL2(" + string + ", " + string4 + ", NULL)";
        }
        return string4;
    }

    public String wrapSQLforVCHARcomp(String string) {
        return string;
    }

    public String wrapNumericforVCHARcomp(String string) {
        return QueryUtils.buildSafeToChar(string);
    }

    public String wrapDateTimeforVCHARcomp(String string) {
        return "trim(to_char(" + string + ",'" + DATE_TIME_FMT + "'))";
    }

    public String wrapSQLforURI(String string) {
        String string2 = "";
        string2 = "'<' || " + string + " || '>'";
        string2 = "NVL2(" + string + ", " + string2 + ", NULL)";
        return string2;
    }

    public String wrapSQLforCLOBcomp(String string, String string2, String string3) {
        return QueryUtils.shortenClobForTerm(string, string2, string3);
    }

    public String wrapSQLforGEOMtoCLOB(String string) {
        String string2 = "";
        string2 = "NVL2(" + string + ", '<' || '" + "http://xmlns.oracle.com/rdf/geo/srid/" + this.ctx.srid + "' || '> ' || SDO_UTIL.TO_WKTGEOMETRY(" + string + "), NULL)";
        return string2;
    }

    public String wrapSQLforGEOMtoVC(String string) {
        String string2 = "";
        string2 = this.wrapSQLforGEOMtoCLOB(string);
        string2 = this.wrapSQLforCLOBcomp(string2, null, "'http://www.opengis.net/ont/geosparql#wktLiteral'");
        return string2;
    }

    public String getLangSQL(SimpleNode simpleNode, String string, int n, Map<String, String> map, Map<String, String> map2) throws RDFException {
        String string2 = "";
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(n);
        int n2 = Filter.getNodeRetType(simpleNode2, map, this.ctx);
        switch (n2) {
            case 4: 
            case 27: 
            case 28: {
                String[] stringArray = new String[8];
                this.popVDollarColArray(simpleNode2, string, map, false, stringArray, map2);
                string2 = "(CASE WHEN " + stringArray[1] + " IN ('PL','PLL','CPLL','PL@','PLL@','CPLL@','TL','TLL','CTLL','LIT') THEN (COALESCE(" + stringArray[5] + ",CHR(0))) ELSE NULL END)";
                break;
            }
            case 9: {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode2;
                string2 = "'" + aSTTripleAtom.litLang + "'";
                break;
            }
            case 2: {
                string2 = "NVL((case when ((" + string + ") OR (NOT (" + string + "))) then chr(0) else NULL end), NULL)";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: {
                string2 = "chr(0)";
                break;
            }
            default: {
                string2 = "NVL2 (" + string + ", chr(0), NULL)";
            }
        }
        return string2;
    }

    public String getSameTermVal(SimpleNode simpleNode, String string, Map<String, String> map, Map<String, String> map2) throws RDFException {
        return this.buildInLineTermExpr(simpleNode, string, map, map2, true, true);
    }

    public String getSameCanonTermVal(SimpleNode simpleNode, String string, Map<String, String> map, Map<String, String> map2, boolean bl) throws RDFException {
        String string2 = "";
        if (bl) {
            switch (simpleNode.id) {
                case 73: {
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                    if (Filter.isVarAtom(aSTTripleAtom.type)) {
                        if (this.isNonLex(aSTTripleAtom)) {
                            string2 = this.getVIDExpr(aSTTripleAtom.name, string, map);
                            break;
                        }
                        string2 = this.buildRes2VidCall(aSTTripleAtom, string, map2, map);
                        break;
                    }
                    if (aSTTripleAtom.type == 1 && this.ctx.URImap.set.containsKey(aSTTripleAtom.name)) {
                        string2 = this.ctx.URImap.get(aSTTripleAtom.name);
                        break;
                    }
                    if ((aSTTripleAtom.type == 2 || aSTTripleAtom.type == 3 || aSTTripleAtom.type == 4 || aSTTripleAtom.type == 5 || aSTTripleAtom.type == 6) && this.ctx.litMap.containsLit(aSTTripleAtom)) {
                        string2 = this.ctx.litMap.get(aSTTripleAtom);
                        break;
                    }
                    string2 = "null";
                    break;
                }
                default: {
                    string2 = this.buildRes2VidCall(simpleNode, string, map2, map);
                    break;
                }
            }
        } else {
            string2 = this.buildVDollarFuncCall(RDFT_CANON_TERM_FUNC, simpleNode, string, map2, map);
        }
        return string2;
    }

    public boolean useVID(SimpleNode simpleNode, SimpleNode simpleNode2) {
        return !this.ctx.useExactValue && (!this.isLex(simpleNode) || !this.isLex(simpleNode2));
    }

    public boolean isLex(SimpleNode simpleNode) {
        boolean bl = false;
        if (simpleNode.id == 73) {
            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
            bl = Filter.isVarAtom(aSTTripleAtom.type) ? !this.isNonLex(aSTTripleAtom) : (aSTTripleAtom.type == 1 ? !this.ctx.URImap.set.containsKey(aSTTripleAtom.name) || this.ctx.URImap.get(aSTTripleAtom.name) == null : !this.ctx.litMap.containsLit(aSTTripleAtom) || this.ctx.litMap.get(aSTTripleAtom) == null);
        } else {
            bl = true;
        }
        return bl;
    }

    public String buildRes2VidCall(SimpleNode simpleNode, String string, Map<String, String> map, Map<String, String> map2) throws RDFException {
        String string2 = "";
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String[] stringArray5 = new String[1];
        String[] stringArray6 = new String[1];
        this.decomposeRDFTerm(simpleNode, string, map, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, map2);
        string2 = "sem_apis.res2vid('" + QueryUtils.getLocalValueDollarName(this.ctx.clnPfxForRdfObjName) + "',(CASE WHEN " + stringArray[0] + " IN " + "('LIT','PL','PLL','CPLL','TL','TLL','CTLL','PL@','PLL@','CPLL@')" + " THEN '\"'||" + stringArray2[0] + "||" + stringArray3[0] + "||'\"' WHEN " + stringArray[0] + " IN " + "('UR','URI')" + " THEN '<'||" + stringArray2[0] + "||" + stringArray3[0] + "||'>' ELSE NULL END)," + stringArray4[0] + "," + stringArray5[0] + "," + stringArray6[0] + ")";
        return string2;
    }

    private List<String[]> prepareExtFuncArgs(SimpleNode simpleNode, String[] stringArray, Map<String, String> map, int n, Map<String, String> map2) throws RDFException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = n; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            arrayList.add(this.buildExtFuncArray(simpleNode2, stringArray[i], map, map2));
        }
        return arrayList;
    }

    private String[] buildExtFuncArray(SimpleNode simpleNode, String string, Map<String, String> map, Map<String, String> map2) throws RDFException {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String[] stringArray5 = new String[1];
        String[] stringArray6 = new String[1];
        this.decomposeRDFTerm(simpleNode, string, map, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, map2);
        String[] stringArray7 = new String[11];
        stringArray7[0] = stringArray2[0] + " || " + stringArray3[0];
        stringArray7[1] = stringArray[0];
        stringArray7[2] = stringArray2[0];
        stringArray7[3] = stringArray3[0];
        stringArray7[4] = stringArray4[0];
        stringArray7[5] = stringArray5[0];
        stringArray7[6] = stringArray6[0];
        int n = Filter.getNodeRetType(simpleNode, map, this.ctx);
        stringArray7[7] = Integer.valueOf(n).toString();
        stringArray7[8] = "";
        if (n == 4) {
            stringArray7[8] = Filter.isSubQAlias(string) ? "NON_LOCAL_VAR" : "LOCAL_VAR";
        } else if (n == 25) {
            stringArray7[8] = string;
        }
        stringArray7[9] = string;
        stringArray7[10] = this.buildInLineTermExpr(simpleNode, string, map, map2, false, false);
        if (this.wrapForHaving) {
            for (int i = 0; i < 7; ++i) {
                stringArray7[i] = "MIN (" + stringArray7[i] + ")";
            }
        }
        return stringArray7;
    }

    public String genRDFtermObj(SimpleNode simpleNode, String string, Map<String, String> map, Map<String, String> map2) throws RDFException {
        ASTTripleAtom aSTTripleAtom = null;
        int n = 0;
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String[] stringArray5 = new String[1];
        String[] stringArray6 = new String[1];
        String[] stringArray7 = new String[1];
        String string2 = "";
        int n2 = Filter.getNodeRetType(simpleNode, map, this.ctx);
        switch (n2) {
            case 4: {
                if (!Filter.isSubQAlias(string)) {
                    n = Filter.getAtomPosition(((ASTTripleAtom)simpleNode).name, map2, this.ctx);
                }
                this.getVDollarColNames(((ASTTripleAtom)simpleNode).name, string, stringArray, stringArray5, stringArray6, stringArray3, stringArray4, stringArray7, n);
                stringArray[0] = Filter.genValTypeCaseStmt(stringArray[0]);
                stringArray2[0] = stringArray3[0] + " || " + stringArray4[0];
                break;
            }
            case 3: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = this.wrapNumericforVCHARcomp(string);
                stringArray5[0] = "'http://www.w3.org/2001/XMLSchema#decimal'";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 29: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = this.wrapNumericforVCHARcomp(string);
                stringArray5[0] = "'http://www.w3.org/2001/XMLSchema#integer'";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 31: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = this.wrapNumericforVCHARcomp(string);
                stringArray5[0] = "'http://www.w3.org/2001/XMLSchema#float'";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 30: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = this.wrapNumericforVCHARcomp(string);
                stringArray5[0] = "'http://www.w3.org/2001/XMLSchema#double'";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 2: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = this.wrapSQLforBooleanNoQuotes(string);
                stringArray5[0] = "'http://www.w3.org/2001/XMLSchema#boolean'";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 1: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = string;
                stringArray5[0] = "'http://www.w3.org/2001/XMLSchema#boolean'";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 8: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = string;
                stringArray5[0] = "''";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 6: {
                stringArray[0] = "'URI'";
                stringArray2[0] = this.stripEnclosingChars(string);
                stringArray5[0] = "''";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 5: {
                stringArray[0] = "'URI'";
                stringArray2[0] = string;
                stringArray5[0] = "''";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 12: {
                aSTTripleAtom = (ASTTripleAtom)simpleNode;
                stringArray[0] = "'LIT'";
                stringArray2[0] = "'" + string + "'";
                stringArray5[0] = aSTTripleAtom.litType != null ? "'" + aSTTripleAtom.litType + "'" : "''";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            case 21: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = this.wrapSQLforCLOBcomp(string, null, "'http://www.opengis.net/ont/geosparql#gmlLiteral'");
                stringArray5[0] = "'http://www.opengis.net/ont/geosparql#gmlLiteral'";
                stringArray6[0] = "''";
                stringArray7[0] = string;
                break;
            }
            case 23: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = this.wrapSQLforCLOBcomp(string, null, "'http://www.opengis.net/ont/geosparql#wktLiteral'");
                stringArray5[0] = "'http://www.opengis.net/ont/geosparql#wktLiteral'";
                stringArray6[0] = "''";
                stringArray7[0] = string;
                break;
            }
            case 25: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = this.wrapSQLforGEOMtoVC(string);
                stringArray5[0] = "'http://www.opengis.net/ont/geosparql#wktLiteral'";
                stringArray6[0] = "''";
                stringArray7[0] = this.wrapSQLforGEOMtoCLOB(string);
                break;
            }
            case 26: {
                stringArray[0] = "'LIT'";
                stringArray2[0] = this.wrapDateTimeforVCHARcomp(string);
                stringArray5[0] = "'http://www.w3.org/2001/XMLSchema#dateTime'";
                stringArray6[0] = "''";
                stringArray7[0] = "TO_CLOB(NULL)";
                break;
            }
            default: {
                aSTTripleAtom = (ASTTripleAtom)simpleNode;
                stringArray[0] = "'LIT'";
                stringArray2[0] = string;
                stringArray5[0] = aSTTripleAtom.litType != null ? "'" + aSTTripleAtom.litType + "'" : "''";
                stringArray6[0] = aSTTripleAtom.litLang != null ? "'" + aSTTripleAtom.litLang + "'" : "''";
                stringArray7[0] = "TO_CLOB(NULL)";
            }
        }
        string2 = "MDSYS.SDO_RDF_TERM(" + stringArray[0] + "," + stringArray2[0] + "," + stringArray5[0] + "," + stringArray6[0] + "," + stringArray7[0] + ",1)";
        return string2;
    }

    public void decomposeRDFTerm(SimpleNode simpleNode, String string, Map<String, String> map, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, Map<String, String> map2) throws RDFException {
        this.decomposeRDFTerm(simpleNode, string, map, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, new String[1], map2);
    }

    public void decomposeRDFTerm(SimpleNode simpleNode, String string, Map<String, String> map, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, Map<String, String> map2) throws RDFException {
        ASTTripleAtom aSTTripleAtom = null;
        int n = 0;
        int n2 = Filter.getNodeRetType(simpleNode, map, this.ctx);
        switch (n2) {
            case 4: {
                if (!Filter.isSubQAlias(string)) {
                    n = Filter.getAtomPosition(((ASTTripleAtom)simpleNode).name, map2, this.ctx);
                }
                this.getVDollarColNames(((ASTTripleAtom)simpleNode).name, string, stringArray, stringArray4, stringArray5, stringArray2, stringArray3, stringArray6, n);
                break;
            }
            case 3: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = QueryUtils.buildSafeToChar(string);
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + string + ",'" + "http://www.w3.org/2001/XMLSchema#decimal" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 29: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = QueryUtils.buildSafeToChar(string);
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + string + ",'" + "http://www.w3.org/2001/XMLSchema#integer" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 31: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = QueryUtils.buildSafeToChar(string);
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + string + ",'" + "http://www.w3.org/2001/XMLSchema#float" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 30: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = QueryUtils.buildSafeToChar(string);
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + string + ",'" + "http://www.w3.org/2001/XMLSchema#double" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 2: {
                stringArray[0] = "NVL2(" + this.wrapSQLforBooleanNoQuotes(string) + ",'LIT',NULL)";
                stringArray2[0] = this.wrapSQLforBooleanNoQuotes(string);
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + this.wrapSQLforBooleanNoQuotes(string) + ",'" + "http://www.w3.org/2001/XMLSchema#boolean" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 1: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = string;
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + string + ",'" + "http://www.w3.org/2001/XMLSchema#boolean" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 8: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = string;
                stringArray3[0] = "''";
                stringArray4[0] = "''";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 6: {
                stringArray[0] = "NVL2(" + string + ",'URI',NULL)";
                stringArray2[0] = "sem_apis.value_name_prefix(" + this.stripEnclosingChars(string) + ",'URI')";
                stringArray3[0] = "sem_apis.value_name_suffix(" + this.stripEnclosingChars(string) + ",'URI')";
                stringArray4[0] = "''";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 5: {
                stringArray[0] = "NVL2(" + string + ",'URI',NULL)";
                stringArray2[0] = "sem_apis.value_name_prefix(" + string + ",'URI')";
                stringArray3[0] = "sem_apis.value_name_suffix(" + string + ",'URI')";
                stringArray4[0] = "''";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 12: {
                aSTTripleAtom = (ASTTripleAtom)simpleNode;
                stringArray[0] = "'LIT'";
                stringArray2[0] = "'" + string + "'";
                stringArray3[0] = "''";
                stringArray4[0] = aSTTripleAtom.litType != null ? "'" + aSTTripleAtom.litType + "'" : "''";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 21: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = this.wrapSQLforCLOBcomp(string, null, "'http://www.opengis.net/ont/geosparql#gmlLiteral'");
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + string + ",'" + "http://www.opengis.net/ont/geosparql#gmlLiteral" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = string;
                break;
            }
            case 23: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = this.wrapSQLforCLOBcomp(string, null, "'http://www.opengis.net/ont/geosparql#wktLiteral'");
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + string + ",'" + "http://www.opengis.net/ont/geosparql#wktLiteral" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = string;
                break;
            }
            case 25: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = this.wrapSQLforGEOMtoVC(string);
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + string + ",'" + "http://www.opengis.net/ont/geosparql#wktLiteral" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = this.wrapSQLforGEOMtoCLOB(string);
                break;
            }
            case 26: {
                stringArray[0] = "NVL2(" + string + ",'LIT',NULL)";
                stringArray2[0] = this.wrapDateTimeforVCHARcomp(string);
                stringArray3[0] = "''";
                stringArray4[0] = "NVL2(" + string + ",'" + "http://www.w3.org/2001/XMLSchema#dateTime" + "',NULL)";
                stringArray5[0] = "''";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            case 27: {
                stringArray[0] = string + "." + "VALUE_TYPE";
                stringArray2[0] = "NVL2(" + string + "." + "VNAME_SUFFIX" + "," + string + "." + "VNAME_PREFIX" + "," + string + "." + "VALUE_NAME" + ")";
                stringArray3[0] = string + "." + "VNAME_SUFFIX";
                stringArray4[0] = string + "." + "LITERAL_TYPE";
                stringArray5[0] = string + "." + "LANGUAGE_TYPE";
                if ((this.ctx.contextFlags & 8) > 0) {
                    stringArray6[0] = "NULL";
                    break;
                }
                stringArray6[0] = string + "." + "LONG_VALUE";
                break;
            }
            case 28: {
                stringArray[0] = "MDSYS.SDO_RDF.VTYPE(" + string + ")";
                stringArray2[0] = "MDSYS.SDO_RDF.VNPFX(" + string + ")";
                stringArray3[0] = "MDSYS.SDO_RDF.VNSFX(" + string + ")";
                stringArray4[0] = "MDSYS.SDO_RDF.LTYPE(" + string + ")";
                stringArray5[0] = "MDSYS.SDO_RDF.LATAG(" + string + ")";
                stringArray6[0] = "TO_CLOB(NULL)";
                break;
            }
            default: {
                aSTTripleAtom = (ASTTripleAtom)simpleNode;
                stringArray[0] = "'LIT'";
                stringArray2[0] = string;
                stringArray3[0] = "''";
                stringArray4[0] = aSTTripleAtom.litType != null ? "'" + aSTTripleAtom.litType + "'" : "''";
                String string2 = stringArray5[0] = aSTTripleAtom.litLang != null ? "'" + aSTTripleAtom.litLang + "'" : "''";
                if (this.ctx.clobExpSupport && QueryUtils.computeConstTermLen(aSTTripleAtom.name, aSTTripleAtom.litLang, aSTTripleAtom.litType) > 4000) {
                    try {
                        stringArray2[0] = QueryUtils.enquoteLiteral(QueryUtils.shortenConstVNforTerm(aSTTripleAtom.name, aSTTripleAtom.litLang, aSTTripleAtom.litType));
                    }
                    catch (SQLException sQLException) {
                        throw new RDFException(sQLException.getMessage());
                    }
                    stringArray6[0] = string;
                    break;
                }
                stringArray6[0] = "TO_CLOB(NULL)";
            }
        }
    }

    public void getVDollarColNames(String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, int n) {
        String[] stringArray7 = new String[6];
        String string3 = string.toUpperCase();
        if (Filter.isSubQAlias(string2)) {
            if ((this.ctx.contextFlags & 8) > 0 && this.ctx.vjoinVars != null && this.ctx.vjoinVars.contains(string)) {
                stringArray[0] = this.wrapVColForAgg(string, "mdsys.sdo_rdf.GetValTyp(" + string2 + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                stringArray2[0] = this.wrapVColForAgg(string, "mdsys.sdo_rdf.GetLitType(" + string2 + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                stringArray3[0] = this.wrapVColForAgg(string, "mdsys.sdo_rdf.GetLangType(" + string2 + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                stringArray4[0] = this.wrapVColForAgg(string, "mdsys.sdo_rdf.GetPref(" + string2 + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                stringArray5[0] = this.wrapVColForAgg(string, "mdsys.sdo_rdf.GetSuff(" + string2 + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')", false, false);
                stringArray6[0] = this.wrapVColForAgg(string, "TO_CLOB(NULL)", false, true);
            } else {
                stringArray[0] = this.wrapVColForAgg(string, string2 + "$RDFVTYP", false, false);
                stringArray2[0] = this.wrapVColForAgg(string, string2 + "$RDFLTYP", false, false);
                stringArray3[0] = this.wrapVColForAgg(string, string2 + "$RDFLANG", false, false);
                stringArray4[0] = this.wrapVColForAgg(string, string2 + "$_PREFIX", false, false);
                stringArray5[0] = this.wrapVColForAgg(string, string2 + "$_SUFFIX", false, false);
                stringArray6[0] = this.wrapVColForAgg(string, string2 + "$RDFCLOB", false, true);
            }
        } else {
            if ((this.ctx.contextFlags & 8) > 0 && this.ctx.ppQuery) {
                stringArray7[0] = "mdsys.sdo_rdf.GetValTyp";
                stringArray7[1] = "mdsys.sdo_rdf.GetLitType";
                stringArray7[2] = "mdsys.sdo_rdf.GetLangType";
                stringArray7[3] = "mdsys.sdo_rdf.GetPref";
                stringArray7[4] = "mdsys.sdo_rdf.GetSuff";
            } else {
                stringArray7[0] = "VALUE_TYPE";
                stringArray7[1] = "LITERAL_TYPE";
                stringArray7[2] = "LANGUAGE_TYPE";
                stringArray7[3] = "VNAME_PREFIX";
                stringArray7[4] = "VNAME_SUFFIX";
            }
            stringArray7[5] = (this.ctx.contextFlags & 8) > 0 ? "NULL" : "LONG_VALUE";
            if ((this.ctx.contextFlags & 8) > 0) {
                if (n == 1) {
                    if (this.ctx.ppQuery) {
                        stringArray7[0] = stringArray7[0] + "(" + string2 + "." + "START_NODE_ID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')";
                        stringArray7[1] = stringArray7[1] + "(" + string2 + "." + "START_NODE_ID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')";
                        stringArray7[2] = stringArray7[2] + "(" + string2 + "." + "START_NODE_ID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')";
                        stringArray7[3] = stringArray7[3] + "(" + string2 + "." + "START_NODE_ID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')";
                        stringArray7[4] = stringArray7[4] + "(" + string2 + "." + "START_NODE_ID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')";
                    } else {
                        stringArray7[0] = stringArray7[0] + "_S";
                        stringArray7[3] = stringArray7[3] + "_S";
                        stringArray7[4] = stringArray7[4] + "_S";
                    }
                } else if (n == 2) {
                    if (this.ctx.ppQuery) {
                        stringArray7[0] = stringArray7[0] + "(" + string2 + "." + "P_VALUE_ID" + ")";
                        stringArray7[1] = stringArray7[1] + "(" + string2 + "." + "P_VALUE_ID" + ")";
                        stringArray7[2] = stringArray7[2] + "(" + string2 + "." + "P_VALUE_ID" + ")";
                        stringArray7[3] = stringArray7[3] + "(" + string2 + "." + "P_VALUE_ID" + ")";
                        stringArray7[4] = stringArray7[4] + "(" + string2 + "." + "P_VALUE_ID" + ")";
                    } else {
                        stringArray7[0] = stringArray7[0] + "_P";
                        stringArray7[3] = stringArray7[3] + "_P";
                        stringArray7[4] = stringArray7[4] + "_P";
                    }
                } else if (n == 3) {
                    if (this.ctx.ppQuery) {
                        stringArray7[0] = stringArray7[0] + "(" + string2 + "." + "CANON_END_NODE_ID" + ")";
                        stringArray7[1] = stringArray7[1] + "(" + string2 + "." + "CANON_END_NODE_ID" + ")";
                        stringArray7[2] = stringArray7[2] + "(" + string2 + "." + "CANON_END_NODE_ID" + ")";
                        stringArray7[3] = stringArray7[3] + "(" + string2 + "." + "CANON_END_NODE_ID" + ")";
                        stringArray7[4] = stringArray7[4] + "(" + string2 + "." + "CANON_END_NODE_ID" + ")";
                    } else {
                        stringArray7[0] = stringArray7[0] + "_O";
                        stringArray7[3] = stringArray7[3] + "_O";
                        stringArray7[4] = stringArray7[4] + "_O";
                    }
                }
            }
            if ((this.ctx.contextFlags & 8) > 0 && this.ctx.ppQuery) {
                stringArray[0] = this.wrapVColForAgg(string, stringArray7[0], false, false);
                stringArray2[0] = this.wrapVColForAgg(string, stringArray7[1], false, false);
                stringArray3[0] = this.wrapVColForAgg(string, stringArray7[2], false, false);
                stringArray4[0] = this.wrapVColForAgg(string, stringArray7[3], false, false);
                stringArray5[0] = this.wrapVColForAgg(string, stringArray7[4], false, false);
            } else {
                stringArray[0] = this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + stringArray7[0]), false, false);
                stringArray2[0] = this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + stringArray7[1]), false, false);
                stringArray3[0] = this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + stringArray7[2]), false, false);
                stringArray4[0] = this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + stringArray7[3]), false, false);
                stringArray5[0] = this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + stringArray7[4]), false, false);
            }
            stringArray6[0] = (this.ctx.contextFlags & 8) > 0 ? this.wrapVColForAgg(string, stringArray7[5], false, true) : this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + stringArray7[5]), false, true);
        }
    }

    public void popVDollarColArray(SimpleNode simpleNode, String string, Map<String, String> map, boolean bl, String[] stringArray, Map<String, String> map2) throws RDFException {
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String[] stringArray5 = new String[1];
        String[] stringArray6 = new String[1];
        String[] stringArray7 = new String[1];
        this.decomposeRDFTerm(simpleNode, string, map, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, map2);
        stringArray[0] = stringArray4[0].equals("''") ? stringArray3[0] : stringArray3[0] + " || " + stringArray4[0];
        stringArray[1] = stringArray2[0];
        stringArray[2] = stringArray3[0];
        stringArray[3] = stringArray4[0];
        stringArray[4] = stringArray5[0];
        stringArray[5] = stringArray6[0];
        stringArray[6] = stringArray7[0];
        if (bl) {
            stringArray[5] = stringArray[5].toLowerCase();
        }
        stringArray[7] = this.ctx.usingTopDownTrans ? stringArray3[0] + " || " + stringArray4[0] : QueryUtils.genVNameSubstr(stringArray[0], stringArray[6], stringArray[5], stringArray[4]);
    }

    public String buildVDollarFuncCall(String string, SimpleNode simpleNode, String string2, Map<String, String> map, Map<String, String> map2) throws RDFException {
        return this.buildVDollarFuncCall(string, simpleNode, string2, map, false, map2);
    }

    public String buildVDollarFuncCall(String string, SimpleNode simpleNode, String string2, Map<String, String> map, boolean bl, Map<String, String> map2) throws RDFException {
        String[] stringArray = new String[8];
        this.popVDollarColArray(simpleNode, string2, map, bl, stringArray, map2);
        List<Integer> list = VAL_DOLLAR_ARG_MAP.get(string);
        boolean bl2 = false;
        String string3 = string;
        if (Filter.getNodeRetType(simpleNode, map, this.ctx) != 4 && VAL_DOL_VC_FUNC_MAP.containsKey(string)) {
            bl2 = true;
            string3 = VAL_DOL_VC_FUNC_MAP.get(string);
        }
        string3 = string3 + "(";
        boolean bl3 = false;
        String string4 = "";
        String string5 = "";
        if (this.wrapForHaving) {
            string4 = "MIN(";
            string5 = ")";
        }
        if (bl2) {
            string3 = string3 + string4 + this.buildInLineTermExpr(simpleNode, string2, map, map2, false, false) + string5;
        } else {
            for (Integer n : list) {
                if (bl3) {
                    string3 = string3 + ", ";
                }
                string3 = n >= 0 ? string3 + string4 + stringArray[n] + string5 : string3 + "NULL";
                bl3 = true;
            }
        }
        string3 = string3 + ")";
        return string3;
    }

    public String getRelExprVal(SimpleNode simpleNode, String string, Map<String, String> map, int n, boolean bl, Map<String, String> map2) throws RDFException {
        String string2 = "";
        int n2 = Filter.getNodeRetType(simpleNode, map, this.ctx);
        switch (n) {
            case 0: {
                if (n2 == 4) {
                    string2 = this.buildVDollarFuncCall(NUMERIC_VDOLLAR_FUNC, simpleNode, string, map, map2);
                    break;
                }
                if (n2 == 3 || n2 == 29 || n2 == 31 || n2 == 30) {
                    string2 = string;
                    break;
                }
                string2 = QueryUtils.wrapSQLforNumeric(string);
                break;
            }
            case 4: {
                if (n2 == 4) {
                    string2 = this.buildVDollarFuncCall(DTIME_VDOLLAR_FUNC, simpleNode, string, map, map2);
                    break;
                }
                if (n2 == 26) {
                    string2 = string;
                    break;
                }
                string2 = this.wrapSQLforTimestamp(string, true, false, false, DATE_TIME_FMT);
                break;
            }
            case 1: {
                if (n2 == 4) {
                    string2 = this.buildVDollarFuncCall(DTIME_VDOLLAR_FUNC, simpleNode, string, map, map2);
                    break;
                }
                string2 = this.wrapSQLforTimestamp(string, true, true, false, DATE_TIME_FMT);
                break;
            }
            case 5: {
                if (n2 == 4) {
                    string2 = this.buildVDollarFuncCall(DATE_VDOLLAR_FUNC, simpleNode, string, map, map2);
                    break;
                }
                string2 = this.wrapSQLforTimestamp(string, true, false, false, DATE_FMT);
                break;
            }
            case 2: {
                if (n2 == 4) {
                    string2 = this.buildVDollarFuncCall(DATE_VDOLLAR_FUNC, simpleNode, string, map, map2);
                    break;
                }
                string2 = this.wrapSQLforTimestamp(string, true, true, false, DATE_FMT);
                break;
            }
            case 6: {
                if (n2 == 4) {
                    string2 = this.buildVDollarFuncCall(TIME_VDOLLAR_FUNC, simpleNode, string, map, map2);
                    break;
                }
                string2 = this.wrapSQLforTimestamp(string, true, false, true, DATE_TIME_FMT);
                break;
            }
            case 3: {
                if (n2 == 4) {
                    string2 = this.buildVDollarFuncCall(TIME_VDOLLAR_FUNC, simpleNode, string, map, map2);
                    break;
                }
                string2 = this.wrapSQLforTimestamp(string, true, true, true, DATE_TIME_FMT);
                break;
            }
            case 7: {
                boolean bl2 = false;
                switch (n2) {
                    case 4: {
                        bl2 = true;
                        string2 = this.buildVDollarFuncCall(STRING_VDOLLAR_FUNC, simpleNode, string, map, map2);
                        break;
                    }
                    default: {
                        string2 = this.wrapSQLforVCHARcomp(string);
                    }
                }
                if (this.ctx.unescapeStrFunc && bl && !this.ctx.networkStorageForm.equals("UNESC")) {
                    string2 = bl2 || Filter.isStrForVar(simpleNode, map, this.ctx) ? Filter.wrapUnescape(string2) : "SEM_APIS.unescape_rdf_value(" + string2 + ")";
                }
                if (this.ctx == null || !this.ctx.extendedVc || n2 != 4) break;
                string2 = QueryUtils.wrapFor4kVc(string2);
                break;
            }
            case 8: {
                if (n2 == 4) {
                    string2 = this.buildVDollarFuncCall(BOOL_VDOLLAR_FUNC, simpleNode, string, map, map2);
                    if (this.ctx == null || !this.ctx.extendedVc) break;
                    string2 = QueryUtils.wrapFor4kVc(string2);
                    break;
                }
                string2 = Filter.normalizeBoolean(string);
                break;
            }
            default: {
                string2 = this.getSameTermVal(simpleNode, string, map, map2);
            }
        }
        return string2;
    }

    public String getRelExprOrdColVar(String string, String string2, int n, int n2) {
        String string3 = null;
        if (this.ctx.useOrderCol && ((this.ctx.contextFlags & 8) == 0 && !Filter.isSubQAlias(string2) || (this.ctx.contextFlags & 8) > 0 && this.ctx.varBGPIDs.containsKey(string))) {
            String string4 = null;
            String string5 = null;
            switch (n) {
                case 3: 
                case 12: 
                case 29: 
                case 30: 
                case 31: {
                    if ((this.ctx.contextFlags & 8) > 0 && (this.ctx.ppQuery || Filter.isSubQAlias(string2))) {
                        string4 = "mdsys.sdo_rdf.GetOrdNum";
                        break;
                    }
                    string4 = "ORDER_NUM";
                    break;
                }
                case 14: 
                case 17: 
                case 26: {
                    string4 = (this.ctx.contextFlags & 8) > 0 && (this.ctx.ppQuery || Filter.isSubQAlias(string2)) ? "mdsys.sdo_rdf.GetOrdDate" : "ORDER_DATE";
                    string5 = "http://www.w3.org/2001/XMLSchema#dateTime";
                    break;
                }
                case 15: 
                case 18: {
                    string4 = (this.ctx.contextFlags & 8) > 0 && (this.ctx.ppQuery || Filter.isSubQAlias(string2)) ? "mdsys.sdo_rdf.GetOrdDate" : "ORDER_DATE";
                    string5 = "http://www.w3.org/2001/XMLSchema#date";
                    break;
                }
                case 16: 
                case 19: {
                    string4 = (this.ctx.contextFlags & 8) > 0 && (this.ctx.ppQuery || Filter.isSubQAlias(string2)) ? "mdsys.sdo_rdf.GetOrdDate" : "ORDER_DATE";
                    string5 = "http://www.w3.org/2001/XMLSchema#time";
                }
            }
            if (string4 != null) {
                if ((this.ctx.contextFlags & 8) > 0) {
                    if (!Filter.isSubQAlias(string2)) {
                        if (n2 == 1) {
                            string4 = this.ctx.ppQuery ? string4 + "(" + string2 + "." + "START_NODE_ID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')" : string4 + "_S";
                        } else if (n2 == 2) {
                            string4 = this.ctx.ppQuery ? string4 + "(" + string2 + "." + "P_VALUE_ID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')" : string4 + "_P";
                        } else if (n2 == 3) {
                            string4 = this.ctx.ppQuery ? string4 + "(" + string2 + "." + "CANON_END_NODE_ID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')" : string4 + "_O";
                        }
                    } else {
                        string4 = string4 + "(" + string2 + "$RDFVID" + ",'" + this.netNamePfx + "','" + this.netOwner + "','" + this.values_tab + "')";
                    }
                }
                string3 = (this.ctx.contextFlags & 8) > 0 && (this.ctx.ppQuery || Filter.isSubQAlias(string2)) ? this.wrapVColForAgg(string, string4, false, false) : this.wrapVColForAgg(string, this.getSpmMappedValueCol(string2 + "." + string4), false, false);
                if (string5 != null && !Filter.isSubQAlias(string2)) {
                    string3 = "DECODE(" + this.getSpmMappedValueCol(string2 + "." + "LITERAL_TYPE") + ",'" + string5 + "'," + string3 + ",NULL)";
                }
            }
        }
        return string3;
    }

    public boolean isSafeForVIDComp(ASTTripleAtom aSTTripleAtom, String string) {
        boolean bl = true;
        try {
            if (!this.isNonLex(aSTTripleAtom)) {
                bl = false;
            } else if (!string.equals("!=") && !string.equals("=")) {
                bl = false;
            }
            if (bl) {
                if ((this.ctx.filterFlags & 2) > 0) {
                    if (aSTTripleAtom.type == 7 || Filter.getNodeRetType(aSTTripleAtom, null, null) == 12) {
                        bl = false;
                    }
                } else if ((string.equals("!=") || this.hasNegationParent(aSTTripleAtom)) && aSTTripleAtom.type != 1) {
                    bl = false;
                } else if (string.equals("=") && !this.hasNegationParent(aSTTripleAtom) && (Filter.isVarAtom(aSTTripleAtom.type) || aSTTripleAtom.type == 7 || Filter.getNodeRetType(aSTTripleAtom, null, null) == 12)) {
                    bl = false;
                }
            }
        }
        catch (RDFException rDFException) {
            bl = false;
        }
        return bl;
    }

    public boolean isValidForVars(Set<String> set) {
        boolean bl = true;
        for (String string : this.vars) {
            if (set.contains(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void updateVarDependencyMap(Map<String, List<Filter>> map) {
        for (String string : this.depVars) {
            List<Filter> list = map.get(string);
            if (list == null) {
                list = new ArrayList<Filter>();
                map.put(string, list);
            }
            list.add(this);
        }
    }

    public void applyFilterOptimizer(SparqlFilterOptimizer sparqlFilterOptimizer) throws RDFException, FilterException {
        this.filterRoot = (SimpleNode)sparqlFilterOptimizer.optimizeFilter(this.filterRoot);
        this.extractVars();
    }

    public String sparqlIFList(SimpleNode simpleNode, SimpleNode simpleNode2, String[] stringArray, Map<String, String> map, Map<String, String> map2) throws RDFException {
        String[][][] stringArray2 = new String[2][6][1];
        this.decomposeRDFTerm(simpleNode, stringArray[1], map, stringArray2[0][0], stringArray2[0][1], stringArray2[0][2], stringArray2[0][3], stringArray2[0][4], stringArray2[0][5], map2);
        this.decomposeRDFTerm(simpleNode2, stringArray[2], map, stringArray2[1][0], stringArray2[1][1], stringArray2[1][2], stringArray2[1][3], stringArray2[1][4], stringArray2[1][5], map2);
        String string = " SYS.ODCIVarchar2List(" + stringArray2[0][0][0] + ", " + stringArray2[1][0][0] + "),\n SYS.ODCIVarchar2List(" + stringArray2[0][1][0] + ", " + stringArray2[1][1][0] + "),\n SYS.ODCIVarchar2List(" + stringArray2[0][2][0] + ", " + stringArray2[1][2][0] + "),\n SYS.ODCIVarchar2List(" + stringArray2[0][3][0] + ", " + stringArray2[1][3][0] + "),\n SYS.ODCIVarchar2List(" + stringArray2[0][4][0] + ", " + stringArray2[1][4][0] + "),\n MDSYS.RDF_CLOBS     (" + stringArray2[0][5][0] + ", " + stringArray2[1][5][0] + ")";
        return string;
    }

    public String sparqlCOALESCEList(ASTBuiltInCall aSTBuiltInCall, String[] stringArray, Map<String, String> map, boolean bl, Map<String, String> map2) throws RDFException {
        String string = "";
        String[][] stringArray2 = new String[6][1];
        String[] stringArray3 = new String[]{"", "", "", "", "", ""};
        for (int i = 0; i < aSTBuiltInCall.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode = (SimpleNode)aSTBuiltInCall.jjtGetChild(i);
            this.decomposeRDFTerm(simpleNode, stringArray[i], map, stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3], stringArray2[4], stringArray2[5], map2);
            if (bl) {
                stringArray2[1][0] = this.wrapForUnicodeUnescape(stringArray2[1][0]);
                stringArray2[2][0] = this.wrapForUnicodeUnescape(stringArray2[2][0]);
                stringArray2[5][0] = this.wrapForUnicodeUnescapeClob(stringArray2[5][0]);
            }
            for (int j = 0; j < 6; ++j) {
                if (i > 0) {
                    int n = j;
                    stringArray3[n] = stringArray3[n] + ",";
                }
                int n = j;
                stringArray3[n] = stringArray3[n] + stringArray2[j][0];
            }
        }
        string = " SYS.ODCIVarchar2List(" + stringArray3[0] + "),\n SYS.ODCIVarchar2List(" + stringArray3[1] + "),\n SYS.ODCIVarchar2List(" + stringArray3[2] + "),\n SYS.ODCIVarchar2List(" + stringArray3[3] + "),\n SYS.ODCIVarchar2List(" + stringArray3[4] + "),\n MDSYS.RDF_CLOBS     (" + stringArray3[5] + ")";
        return string;
    }

    public boolean isNonLex(SimpleNode simpleNode) {
        boolean bl = true;
        if (simpleNode.id == 73 && Filter.isVarAtom(((ASTTripleAtom)simpleNode).type) && this.lexVars.contains(((ASTTripleAtom)simpleNode).name)) {
            bl = false;
        }
        return bl;
    }

    protected void updateSubMap(Map<String, ASTTripleAtom> map, Map<String, String> map2, Map<String, String> map3) throws RDFException {
        if (this.filterRoot.id == 80 && this.filterRoot.jjtGetNumChildren() == 3) {
            SimpleNode simpleNode = (SimpleNode)this.filterRoot.jjtGetChild(0);
            SimpleNode simpleNode2 = (SimpleNode)this.filterRoot.jjtGetChild(1);
            SimpleNode simpleNode3 = (SimpleNode)this.filterRoot.jjtGetChild(2);
            if (simpleNode.id == 73 && simpleNode2.id == 81 && simpleNode3.id == 73) {
                int n = ((ASTTripleAtom)simpleNode).type;
                String string = ((ASTComparisonOperator)simpleNode2).name;
                int n2 = ((ASTTripleAtom)simpleNode3).type;
                if (string.equals("=")) {
                    this.saveEqualTerms((ASTTripleAtom)simpleNode, (ASTTripleAtom)simpleNode3, map);
                    this.saveEqualTerms((ASTTripleAtom)simpleNode3, (ASTTripleAtom)simpleNode, map);
                }
            }
        } else if (this.filterRoot.id == 88 && ((ASTBuiltInCall)this.filterRoot).name.equals(SAMETERM_OP) && this.filterRoot.jjtGetNumChildren() == 2) {
            SimpleNode simpleNode = (SimpleNode)this.filterRoot.jjtGetChild(0);
            SimpleNode simpleNode4 = (SimpleNode)this.filterRoot.jjtGetChild(1);
            if (simpleNode.id == 73 && simpleNode4.id == 73) {
                this.saveSameTerms((ASTTripleAtom)simpleNode, (ASTTripleAtom)simpleNode4, map);
                this.saveSameTerms((ASTTripleAtom)simpleNode4, (ASTTripleAtom)simpleNode, map);
            }
        } else if (this.filterRoot.id == 90 && this.filterRoot.jjtGetNumChildren() == 3 && ((SimpleNode)this.filterRoot.jjtGetChild((int)0)).id == 73) {
            if (((ASTTripleAtom)this.filterRoot.jjtGetChild((int)0)).name.equals(FUNC_HASVID_OP)) {
                SimpleNode simpleNode = (SimpleNode)this.filterRoot.jjtGetChild(1);
                SimpleNode simpleNode5 = (SimpleNode)this.filterRoot.jjtGetChild(2);
                if (simpleNode.id == 73 && simpleNode5.id == 73) {
                    this.saveSameVIDs((ASTTripleAtom)simpleNode, (ASTTripleAtom)simpleNode5, map);
                }
            } else if (((ASTTripleAtom)this.filterRoot.jjtGetChild((int)0)).name.equals(FUNC_SAMECTERM_OP)) {
                SimpleNode simpleNode = (SimpleNode)this.filterRoot.jjtGetChild(1);
                SimpleNode simpleNode6 = (SimpleNode)this.filterRoot.jjtGetChild(2);
                if (simpleNode.id == 73 && Filter.isVarAtom(((ASTTripleAtom)simpleNode).type)) {
                    this.saveSameCanonTerms((ASTTripleAtom)simpleNode, simpleNode6, map, map2, map3);
                } else if (simpleNode6.id == 73 && Filter.isVarAtom(((ASTTripleAtom)simpleNode6).type)) {
                    this.saveSameCanonTerms((ASTTripleAtom)simpleNode6, simpleNode, map, map2, map3);
                }
            }
        }
    }

    private void saveSameVIDs(ASTTripleAtom aSTTripleAtom, ASTTripleAtom aSTTripleAtom2, Map<String, ASTTripleAtom> map) {
        int n = aSTTripleAtom.type;
        int n2 = aSTTripleAtom2.type;
        if (n == 0 && n2 == 3) {
            aSTTripleAtom2.flags |= 4;
            map.put(aSTTripleAtom.name, aSTTripleAtom2);
        }
    }

    private void saveEqualTerms(ASTTripleAtom aSTTripleAtom, ASTTripleAtom aSTTripleAtom2, Map<String, ASTTripleAtom> map) throws RDFException {
        int n = Filter.getNodeRetType(aSTTripleAtom, this.ctx.funcTypeMap, this.ctx);
        int n2 = Filter.getNodeRetType(aSTTripleAtom2, this.ctx.funcTypeMap, this.ctx);
        if (n == 4 && n2 != 12) {
            map.put(aSTTripleAtom.name, aSTTripleAtom2);
        }
    }

    private void saveSameTerms(ASTTripleAtom aSTTripleAtom, ASTTripleAtom aSTTripleAtom2, Map<String, ASTTripleAtom> map) {
        int n = aSTTripleAtom.type;
        int n2 = aSTTripleAtom2.type;
        if (n == 0 && (n2 == 1 || n2 == 3)) {
            map.put(aSTTripleAtom.name, aSTTripleAtom2);
        }
    }

    private void saveSameCanonTerms(ASTTripleAtom aSTTripleAtom, SimpleNode simpleNode, Map<String, ASTTripleAtom> map, Map<String, String> map2, Map<String, String> map3) throws RDFException {
        int n = aSTTripleAtom.type;
        if (Filter.isVarAtom(n)) {
            if (simpleNode.id == 73 && !Filter.isVarAtom(((ASTTripleAtom)simpleNode).type)) {
                map.put(aSTTripleAtom.name, (ASTTripleAtom)simpleNode);
            } else {
                int n2 = Filter.getNodeRetType(simpleNode, this.ctx.funcTypeMap, this.ctx);
                if (n2 == 27) {
                    ASTTripleAtom aSTTripleAtom2 = new ASTTripleAtom(73);
                    aSTTripleAtom2.type = 7;
                    aSTTripleAtom2.name = "(" + this.filterToSQL(simpleNode, map2, map3, this.ctx.funcTypeMap, this.ctx.funcHandMap) + ").nonCanonTermStr()";
                    map.put(aSTTripleAtom.name, aSTTripleAtom2);
                }
            }
        }
    }

    private boolean hasNestedInput(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = null;
        int n = simpleNode.jjtGetNumChildren();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n && !bl2; ++i) {
            simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2.id == 73 || this.isNestedSpecialCase(simpleNode2)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public boolean hasSpatialFunction() {
        return QueryUtils.hasSpatialFunction(this.filterRoot);
    }

    public boolean hasOracleTextFunction() {
        return QueryUtils.hasOracleTextFunction(this.filterRoot);
    }

    private boolean isNestedSpecialCase(SimpleNode simpleNode) {
        boolean bl = false;
        if (simpleNode.id == 88 && ((ASTBuiltInCall)simpleNode).name.equals(STR_OP)) {
            bl = !this.hasNestedInput(simpleNode);
        }
        return bl;
    }

    public int getSpecialCaseFlags() {
        return this.specialCases;
    }

    public void setSpecialCase(int n) {
        this.specialCases += n;
    }

    public void clearSpecialCase() {
        this.specialCases = 0;
    }

    public SimpleNode getFilterTree() {
        return this.filterRoot;
    }

    public Set<String> getVars() {
        return this.vars;
    }

    public Set<String> getfJoinVars() {
        return this.fJoinVars;
    }

    public Set<String> getBindVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            hashSet.add(bindVar.bvName);
        }
        return hashSet;
    }

    public Set<ASTTripleAtom.BindVar> getBindVarObjs() {
        return this.bindVars;
    }

    public void setDepVars(Set<String> set) {
        this.depVars = set;
    }

    public void addDepVar(String string) {
        this.depVars.add(string);
    }

    public void addDepVarSet(Set<String> set) {
        this.depVars.addAll(set);
    }

    public Set<String> getDepVars() {
        return this.depVars;
    }

    public int getPushCnt() {
        return this.pushCnt;
    }

    public void incrementPushCnt() {
        ++this.pushCnt;
    }

    public void setPushCnt(int n) {
        this.pushCnt = n;
    }

    public boolean getPushedToJoin() {
        return this.pushedToJoin;
    }

    public void setPushedToJoin(boolean bl) {
        this.pushedToJoin = bl;
    }

    public void setWrapForHaving(boolean bl) {
        this.wrapForHaving = bl;
    }

    public boolean getWrapForHaving() {
        return this.wrapForHaving;
    }

    public int getNodeType() {
        if (this.filterRoot.jjtGetNumChildren() > 0) {
            for (int i = 0; i < this.filterRoot.jjtGetNumChildren(); ++i) {
                if (this.getNodeType((SimpleNode)this.filterRoot.jjtGetChild(i)) != 89) continue;
                return 89;
            }
        }
        return this.filterRoot.id;
    }

    private int getNodeType(SimpleNode simpleNode) {
        if (simpleNode.jjtGetNumChildren() > 0) {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                if (this.getNodeType((SimpleNode)simpleNode.jjtGetChild(i)) != 89) continue;
                return 89;
            }
        }
        return simpleNode.id;
    }

    static {
        VAL_DOL_VC_FUNC_MAP.put(NUMERIC_VDOLLAR_FUNC, NUMERIC_VDOLLAR_VC_FUNC);
        VAL_DOL_VC_FUNC_MAP.put(EBV_VDOLLAR_FUNC, EBV_VDOLLAR_VC_FUNC);
        VAL_DOL_VC_FUNC_MAP.put(STRING_VDOLLAR_FUNC, STRING_VDOLLAR_VC_FUNC);
        VAL_DOL_VC_FUNC_MAP.put(DTIME_VDOLLAR_FUNC, DTIME_VDOLLAR_VC_FUNC);
        VAL_DOL_VC_FUNC_MAP.put(DATE_VDOLLAR_FUNC, DATE_VDOLLAR_VC_FUNC);
        VAL_DOL_VC_FUNC_MAP.put(TIME_VDOLLAR_FUNC, TIME_VDOLLAR_VC_FUNC);
        VAL_DOL_VC_FUNC_MAP.put(BOOL_VDOLLAR_FUNC, BOOL_VDOLLAR_VC_FUNC);
        VAL_DOL_VC_FUNC_MAP.put(DTYPE_VDOLLAR_FUNC, DTYPE_VDOLLAR_VC_FUNC);
        VAL_DOL_VC_FUNC_MAP.put(LANG_VDOLLAR_FUNC, LANG_VDOLLAR_VC_FUNC);
        VAL_DOLLAR_ARG_MAP = new HashMap<String, List<Integer>>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(NUMERIC_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(EBV_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(STRING_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(DTIME_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(DATE_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(TIME_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(BOOL_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(4);
        arrayList.add(new Integer(7));
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(RDFT_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(4);
        arrayList.add(new Integer(7));
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(RDFT_CANON_TERM_FUNC, arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(DTYPE_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(2));
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        VAL_DOLLAR_ARG_MAP.put(LANG_VDOLLAR_FUNC, arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(0));
        arrayList.add(new Integer(4));
        arrayList.add(new Integer(5));
        arrayList.add(new Integer(6));
        VAL_DOLLAR_ARG_MAP.put(RDFT_SDO_RDF_TERM, arrayList);
    }
}

