/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.ClauseTreeNode;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.FilterScopeOptimizer;
import oracle.spatial.rdf.server.GGPCollapseOptimizer;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLEngine;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SparqlFilterOptimizer;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.TranslateEngine;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.UnionRewriteOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTTopLevelQueryNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class GenerateQuery {
    public static final String MDSYS_RDFVTAB_N_SPACE = "\"MDSYS\".RDF_VALUE$ ";
    public static final String UNION_ID_COL = "RDF$L";
    Vector withVec;
    Vector selectVec;
    Vector fromVec;
    Vector whereVec;
    StringBuffer hintStr;
    boolean hint0present;
    String queryOptions;
    boolean m_bLog = false;
    Map withAliasToSqlMap;
    String basicTriples;
    boolean noUseWith;
    boolean optTrans;
    HashMap hint0leadPosMap;
    boolean sparqlNoUseWith;
    boolean sparqlUseExact;
    String vmViewName;
    boolean useVM;
    boolean relaxFilter;
    boolean probFilterExists;
    boolean unionQuery;
    private int ctnIdCtr;
    public static final int USE_WITH_HEURISTIC_THRESHOLD = 3;
    protected boolean distinct;
    private boolean m_bMagicSet = false;
    private boolean disableNoMerge = false;
    private boolean enableNoMerge = false;
    private boolean allBgpHash;
    private boolean allBgpNL;
    private boolean allNoMerge;
    private boolean allSwap;
    private boolean allOrdered;
    private boolean noPushVal;

    public static void dumpHashMap(HashMap hashMap) {
        int n = 0;
        for (String string : hashMap.keySet()) {
            QueryUtils.log("key#" + n + ": " + string + "=>" + hashMap.get(string) + "\n");
            ++n;
        }
    }

    public static void dumpVector(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            QueryUtils.log("Entry#" + i + " =>" + vector.elementAt(i) + "\n");
        }
    }

    GenerateQuery(boolean bl, String string) {
        this.queryOptions = string;
        if (this.queryOptions != null) {
            this.m_bLog = this.queryOptions.indexOf("LOG=5") >= 0;
        }
        this.withVec = new Vector();
        this.selectVec = new Vector();
        this.fromVec = new Vector();
        this.whereVec = new Vector();
        this.hintStr = new StringBuffer(" ");
        this.hint0present = false;
        this.withAliasToSqlMap = new HashMap();
        this.basicTriples = "";
        this.noUseWith = false;
        this.optTrans = true;
        this.hint0leadPosMap = new HashMap();
        this.sparqlNoUseWith = true;
        this.sparqlUseExact = false;
        this.vmViewName = null;
        this.useVM = false;
        this.relaxFilter = false;
        this.probFilterExists = false;
        this.unionQuery = false;
        this.distinct = false;
        this.m_bMagicSet = bl;
        this.disableNoMerge = false;
        this.enableNoMerge = false;
        this.allBgpHash = false;
        this.allBgpNL = false;
        this.allNoMerge = false;
        this.allSwap = false;
        this.allOrdered = false;
        this.noPushVal = false;
        this.ctnIdCtr = 0;
    }

    GenerateQuery() {
        this(false, null);
    }

    public void buildJoin_LINK(SQLGenContext sQLGenContext, SimpleNode simpleNode) {
        if (this.m_bLog) {
            QueryUtils.log("Processing=> " + simpleNode.toString() + " child-count=" + simpleNode.jjtGetNumChildren() + "\n");
        }
        if (simpleNode.id == 4 || simpleNode.id == 47) {
            int n = sQLGenContext.nTriples++;
            String string = "t" + n;
            String[] stringArray = new String[]{"START_NODE_ID", "P_VALUE_ID", "CANON_END_NODE_ID"};
            block5: for (int i = 0; i < 3; ++i) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode.jjtGetChild(i);
                String string2 = " IN (SELECT NULL FROM mdsys.rdf_namespace$ where rownum < 1) ";
                switch (aSTTripleAtom.type) {
                    case 0: {
                        String string3 = sQLGenContext.varMap.getMappingByName(aSTTripleAtom.name);
                        if (string3 != null) {
                            this.whereVec.add(string + "." + stringArray[i] + " = " + string3);
                            if (!this.hint0present || !this.noUseWith) continue block5;
                            sQLGenContext.varMap.addtoColGroup(aSTTripleAtom.name, string + "." + stringArray[i]);
                            continue block5;
                        }
                        string3 = string + "." + stringArray[i];
                        sQLGenContext.varMap.addMapping(aSTTripleAtom.name, string3);
                        if (i == 2 && !sQLGenContext.varMap.getAlwaysCanonNamesByName(aSTTripleAtom.name.toUpperCase())) {
                            if (!sQLGenContext.varMap.getFuncExactNamesByName(aSTTripleAtom.name.toUpperCase())) {
                                sQLGenContext.varMap.addExactMapping(aSTTripleAtom.name, string + ".END_NODE_ID");
                                continue block5;
                            }
                            sQLGenContext.varMap.addExactMapping(aSTTripleAtom.name, "NVL(case when " + string + "." + stringArray[i] + "=" + string + ".END_NODE_ID then null else " + string + ".END_NODE_ID end," + string + "." + stringArray[i] + ")");
                            continue block5;
                        }
                        sQLGenContext.varMap.addExactMapping(aSTTripleAtom.name, string3);
                        continue block5;
                    }
                    case 1: {
                        String string4 = sQLGenContext.URImap.get(aSTTripleAtom.name);
                        if (string4 != null) {
                            this.whereVec.add(string + "." + stringArray[i] + " = " + string4);
                            continue block5;
                        }
                        this.whereVec.add(string + "." + stringArray[i] + string2);
                        continue block5;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        String string5 = sQLGenContext.litMap.get(aSTTripleAtom);
                        if (string5 != null) {
                            this.whereVec.add(string + "." + stringArray[i] + " = " + string5);
                            continue block5;
                        }
                        this.whereVec.add(string + "." + stringArray[i] + string2);
                    }
                }
            }
            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode.jjtGetChild(1);
            if (this.useVM) {
                this.fromVec.add(this.vmViewName + " " + string);
            } else if (this.noUseWith) {
                this.fromVec.add(this.basicTriples + " " + string);
            } else {
                this.fromVec.add(sQLGenContext.srcTabName + " " + string);
            }
            if (simpleNode.jjtGetNumChildren() == 4) {
                this.buildJoin_LINK(sQLGenContext, (SimpleNode)simpleNode.jjtGetChild(3));
            }
        } else {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                this.buildJoin_LINK(sQLGenContext, (SimpleNode)simpleNode.jjtGetChild(i));
            }
        }
    }

    public void buildJoin_VALUE(SQLGenContext sQLGenContext, int[] nArray) {
        if (sQLGenContext.varMap.size() == 0) {
            if (this.m_bMagicSet) {
                this.selectVec.add("COUNT(*)");
            } else {
                this.selectVec.add("null");
            }
        } else {
            String string = " ";
            if (this.queryOptions != null) {
                string = " " + this.queryOptions.trim() + " ";
            }
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < sQLGenContext.varMap.size(); ++i) {
                String string2;
                boolean bl = false;
                String string3 = "v" + i;
                String string4 = sQLGenContext.varMap.getNameByIndex(i);
                String string5 = sQLGenContext.varMap.getMaybeLiteralByIndex(i) ? sQLGenContext.varMap.getExactMappingByIndex(i) : sQLGenContext.varMap.getMappingByIndex(i);
                if (nArray == null || n < nArray.length && n2 == nArray[n]) {
                    this.selectVec.add(string3 + ".VNAME_PREFIX || " + string3 + ".VNAME_SUFFIX \"" + sQLGenContext.varMap.getNameByIndex(i) + "\"");
                    bl = true;
                    ++n;
                } else {
                    this.selectVec.add("null");
                }
                if (nArray == null || n < nArray.length && ++n2 == nArray[n]) {
                    string2 = sQLGenContext.varMap.getNameByIndex(i) + "$RDFVID";
                    if (!bl && (this.hint0present || string.indexOf(" NOHINT ") >= 0 || string.indexOf(" NOHINT=T ") >= 0)) {
                        this.selectVec.add(string5 + " \"" + string2 + "\"");
                    } else {
                        this.selectVec.add(string3 + ".VALUE_ID \"" + string2 + "\"");
                        bl = true;
                    }
                    ++n;
                } else {
                    this.selectVec.add("null");
                }
                if (nArray == null || n < nArray.length && ++n2 == nArray[n]) {
                    string2 = sQLGenContext.varMap.getNameByIndex(i) + "$_PREFIX";
                    this.selectVec.add(string3 + ".VNAME_PREFIX \"" + string2 + "\"");
                    bl = true;
                    ++n;
                } else {
                    this.selectVec.add("null");
                }
                if (nArray == null || n < nArray.length && ++n2 == nArray[n]) {
                    string2 = sQLGenContext.varMap.getNameByIndex(i) + "$_SUFFIX";
                    this.selectVec.add(string3 + ".VNAME_SUFFIX \"" + string2 + "\"");
                    bl = true;
                    ++n;
                } else {
                    this.selectVec.add("null");
                }
                if (nArray == null || n < nArray.length && ++n2 == nArray[n]) {
                    string2 = sQLGenContext.varMap.getNameByIndex(i) + "$RDFVTYP";
                    String string6 = string3 + ".VALUE_TYPE";
                    this.selectVec.add("CASE WHEN " + string6 + " = 'UR' THEN '" + "URI" + "'\n WHEN " + string6 + " = 'BN' THEN '" + "BLN" + "'\n ELSE '" + "LIT" + "'\nEND\"" + string2 + "\"");
                    bl = true;
                    ++n;
                } else {
                    this.selectVec.add("null");
                }
                if (nArray == null || n < nArray.length && ++n2 == nArray[n]) {
                    string2 = sQLGenContext.varMap.getNameByIndex(i) + "$RDFCLOB";
                    this.selectVec.add(string3 + ".LONG_VALUE \"" + string2 + "\"");
                    bl = true;
                    ++n;
                } else {
                    this.selectVec.add("null");
                }
                if (nArray == null || n < nArray.length && ++n2 == nArray[n]) {
                    string2 = sQLGenContext.varMap.getNameByIndex(i) + "$RDFLTYP";
                    this.selectVec.add(string3 + ".LITERAL_TYPE  \"" + string2 + "\"");
                    bl = true;
                    ++n;
                } else {
                    this.selectVec.add("null");
                }
                if (nArray == null || n < nArray.length && ++n2 == nArray[n]) {
                    string2 = sQLGenContext.varMap.getNameByIndex(i) + "$RDFLANG";
                    this.selectVec.add(string3 + ".LANGUAGE_TYPE \"" + string2 + "\"");
                    bl = true;
                    ++n;
                } else {
                    this.selectVec.add("null");
                }
                ++n2;
                if (!bl) continue;
                this.fromVec.add(MDSYS_RDFVTAB_N_SPACE + string3);
                this.whereVec.add(string3 + ".VALUE_ID = " + string5);
                sQLGenContext.varMap.addProjection(sQLGenContext.varMap.getNameByIndex(i), string3);
                if (!this.hint0present || !this.noUseWith || !this.optTrans || sQLGenContext.varMap.getMaybeLiteralByName(string4) && !sQLGenContext.varMap.getAlwaysCanonNamesByName(string4.toUpperCase())) continue;
                sQLGenContext.varMap.addtoColGroup(string4, string3 + ".VALUE_ID");
            }
        }
    }

    public void buildHint(SQLGenContext sQLGenContext, boolean bl) {
        int n;
        String string = " ";
        if (this.queryOptions != null) {
            string = this.queryOptions;
        }
        if (this.m_bLog) {
            QueryUtils.log(sQLGenContext.varMap.toString() + "\n");
        }
        if (this.m_bLog) {
            QueryUtils.log("HINT0 processing ... \n");
        }
        String string2 = string;
        if (this.m_bLog) {
            QueryUtils.log("Input HINT==> " + string2 + "\n");
        }
        if ((n = string2.toUpperCase().indexOf("HINT0")) < 0) {
            return;
        }
        String string3 = string2.substring(n + "HINT0".length(), string2.length()).trim();
        if (this.m_bLog) {
            QueryUtils.log("1st cut: szHint0==> " + string3 + "\n");
        }
        if (string3.equals("") || string3.charAt(0) != '=') {
            return;
        }
        string3 = string3.substring(1, string3.length()).trim();
        if (this.m_bLog) {
            QueryUtils.log("2nd cut: szHint0==> " + string3 + "\n");
        }
        if (string3.equals("") || string3.charAt(0) != '{') {
            return;
        }
        int n2 = string3.indexOf("}");
        if (n2 < 0) {
            return;
        }
        string3 = "{ " + string3.substring(1, n2) + " }";
        if (this.m_bLog) {
            QueryUtils.log("HINT0 content==> " + string3 + "\n");
        }
        if (bl) {
            if (string3.indexOf("'") < 0 && string3.indexOf("--") < 0 && string3.indexOf(";") < 0 && string3.indexOf("/*") < 0 && string3.indexOf("*/") < 0) {
                this.computeSqlHint0(string3, true, sQLGenContext, this.m_bLog);
                if (this.m_bLog) {
                    QueryUtils.log("final hint==> " + this.hintStr.toString() + "\n");
                }
            } else {
                QueryUtils.log("SKIPPED HINT0 due to presence of bad char seq: " + string3 + "\n");
            }
        } else {
            this.hint0present = true;
            if (string3.toUpperCase().indexOf(" NO_USE_WITH ") >= 0) {
                this.noUseWith = true;
            }
            if (string3.toUpperCase().indexOf(" NO_OPT_TRANSITIVITY ") >= 0) {
                this.optTrans = false;
            }
            if (string3.toUpperCase().indexOf(" USE_WITH ") >= 0) {
                this.sparqlNoUseWith = false;
            }
            if (string3.toUpperCase().indexOf(" GET_EXACT_VALUES ") >= 0) {
                this.sparqlUseExact = true;
            }
            this.computeSqlHint0(string3, false, sQLGenContext, this.m_bLog);
        }
    }

    public void computeSqlHint0(String string, boolean bl, SQLGenContext sQLGenContext, boolean bl2) {
        String[] stringArray = new String[]{"RESULT_CACHE", "NO_REWRITE", "NO_QUERY_TRANSFORMATION", "ORDERED", "FIRST_ROWS", "ALL_ROWS"};
        String[] stringArray2 = new String[]{"LEADING", "USE_NL", "USE_HASH", "USE_MERGE", "NO_USE_NL", "NO_USE_HASH", "NO_USE_MERGE", "SWAP_JOIN_INPUTS", "NO_SWAP_JOIN_INPUTS"};
        String[] stringArray3 = new String[]{"INDEX", "INDEX_FFS", "INDEX_SS", "INDEX_JOIN", "INDEX_COMBINE", "FULL", "USE_NL_WITH_INDEX", "PARALLEL_INDEX", "PARALLEL", "INDEX_ASC", "INDEX_DESC", "INDEX_SS_ASC", "INDEX_SS_DESC", "NO_INDEX", "NO_INDEX_FFS", "NO_INDEX_SS", "NO_PARALLEL_INDEX", "NO_PARALLEL"};
        String[] stringArray4 = new String[]{"GET_CANON_VALUE", "EXACT_VIA_FUNCTION"};
        if (bl) {
            int n;
            this.hintStr.append(" /*+ ");
            for (n = 0; n < stringArray.length; ++n) {
                if (string.indexOf(" " + stringArray[n] + " ") < 0) continue;
                this.hintStr.append(" " + stringArray[n] + " ");
            }
            for (n = 0; n < stringArray2.length; ++n) {
                this.computeSqlMultiAliasHint0(stringArray2[n], "(", ")", stringArray2[n], "(", ")", string, true, sQLGenContext, true, true, false, bl2);
            }
            for (n = 0; n < stringArray3.length; ++n) {
                this.computeSqlMultiAliasHint0(stringArray3[n], "(", ")", stringArray3[n], "(", ")", string, true, sQLGenContext, true, true, true, bl2);
            }
            this.hintStr.append(" */ ");
        } else {
            for (int i = 0; i < stringArray4.length; ++i) {
                this.computeSqlMultiAliasHint0(stringArray4[i], "(", ")", null, null, null, string, false, sQLGenContext, true, false, false, bl2);
            }
        }
    }

    public void computeSqlMultiAliasHint0(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, SQLGenContext sQLGenContext, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n = 0;
        int n2 = 0;
        String string8 = " ";
        if (bl5) {
            QueryUtils.log("****************** User Keyword=" + string + "\n");
        }
        while (true) {
            int n3;
            int n4 = 0;
            int n5 = 0;
            int n6 = string7.toUpperCase().indexOf(string, n);
            if (bl5) {
                QueryUtils.log("-------------------- UsrKeyword=" + string + " iStartPos=" + n + " iBegPos=" + n6 + "\n Remaining Hint0==> " + string7.substring(n, string7.length()) + "\n");
            }
            if (n6 >= 0) {
                if (n6 > 0 && string7.charAt(n6 - 1) != ' ') {
                    n3 = string7.indexOf(" ", n6);
                    if (n3 < 0) {
                        return;
                    }
                    n = n3;
                    continue;
                }
                string8 = string7.substring(n6 + string.length(), string7.length()).trim();
                if (string8.indexOf(string2) != 0) {
                    n3 = string8.indexOf(" ");
                    if (n3 < 0) {
                        return;
                    }
                    n = n6 + string.length() + n3;
                    continue;
                }
                n2 = string8.indexOf(string3);
                if (n2 < 0) {
                    return;
                }
            } else {
                return;
            }
            if (bl5) {
                QueryUtils.log("hint0 w/o UsrKeyword=" + string8 + "\n");
            }
            string8 = string8.substring(string2.length(), n2).trim();
            if (bl5) {
                QueryUtils.log("list=" + string8 + "\n");
            }
            int n7 = 0;
            while (string8.length() > 0) {
                ++n5;
                n3 = string8.indexOf(" ");
                if (n3 < 0) {
                    n3 = string8.length();
                }
                if (bl4 && n5 > 1) {
                    n3 = string8.length();
                    if (n4 > 0) {
                        this.hintStr.append(string8);
                    }
                } else if (bl2 && string8.charAt(0) == '?' && (!bl4 || n5 == 1)) {
                    String string9 = string8.substring(1, n3);
                    if (bl5) {
                        QueryUtils.log("Var:" + string9 + "%\n");
                    }
                    if (bl) {
                        String string10 = sQLGenContext.varMap.getProjectionByName(string9.toUpperCase());
                        if (bl5) {
                            QueryUtils.log("alias=" + string10 + "$\n");
                        }
                        if (string10 != null) {
                            if (n4 == 0) {
                                this.hintStr.append(" " + string4 + string5);
                                if (bl5) {
                                    QueryUtils.log("hintStr=" + this.hintStr.toString() + "%\n");
                                }
                            }
                            ++n4;
                            this.hintStr.append(string10 + " ");
                            if (this.noUseWith && this.optTrans && string4.equalsIgnoreCase("LEADING")) {
                                this.hint0leadPosMap.put(string10, ++n7);
                            }
                            if (bl5) {
                                QueryUtils.log("SqlHint0:" + this.hintStr.toString() + "%\n");
                            }
                        }
                    } else if (sQLGenContext.varMap.set.containsKey(string9.toUpperCase())) {
                        if (string.equalsIgnoreCase("GET_CANON_VALUE")) {
                            sQLGenContext.varMap.alwaysCanonNames.add(string9.toUpperCase());
                        } else if (string.equalsIgnoreCase("EXACT_VIA_FUNCTION")) {
                            sQLGenContext.varMap.funcExactNames.add(string9.toUpperCase());
                        }
                    } else if (string9.equals("*")) {
                        if (bl5) {
                            QueryUtils.log("wildcard variable\n");
                        }
                        if (string.equalsIgnoreCase("GET_CANON_VALUE")) {
                            for (int i = 0; i < sQLGenContext.varMap.indexedNames.size(); ++i) {
                                if (bl5) {
                                    QueryUtils.log("Mark as AlwaysCanon: variable=" + sQLGenContext.varMap.getNameByIndex(i).toUpperCase() + "\n");
                                }
                                sQLGenContext.varMap.alwaysCanonNames.add(sQLGenContext.varMap.getNameByIndex(i).toUpperCase());
                            }
                        } else if (string.equalsIgnoreCase("EXACT_VIA_FUNCTION")) {
                            for (int i = 0; i < sQLGenContext.varMap.indexedNames.size(); ++i) {
                                if (bl5) {
                                    QueryUtils.log("Mark as funcExact: variable=" + sQLGenContext.varMap.getNameByIndex(i).toUpperCase() + "\n");
                                }
                                sQLGenContext.varMap.funcExactNames.add(sQLGenContext.varMap.getNameByIndex(i).toUpperCase());
                            }
                        }
                    }
                } else if (!(!bl3 || string8.charAt(0) != 'T' && string8.charAt(0) != 't' || bl4 && n5 != 1)) {
                    String string11 = string8.substring(0, n3);
                    if (bl5) {
                        QueryUtils.log("TripleAlias: " + string11 + "*\n");
                    }
                    int n8 = new Integer(string11.substring(1, string11.length()));
                    if (bl5) {
                        QueryUtils.log("AliasNum: " + n8 + "*nTriples=" + sQLGenContext.nTriples + "\n");
                    }
                    if (n8 < sQLGenContext.nTriples) {
                        if (n4 == 0) {
                            this.hintStr.append(" " + string4 + string5);
                            if (bl5) {
                                QueryUtils.log("hintStr=" + this.hintStr.toString() + "%\n");
                            }
                        }
                        ++n4;
                        if (bl) {
                            this.hintStr.append(string11 + " ");
                            if (this.noUseWith && this.optTrans && string4.equalsIgnoreCase("LEADING")) {
                                this.hint0leadPosMap.put(string11.toLowerCase(), ++n7);
                            }
                            if (bl5) {
                                QueryUtils.log("SqlHint0:" + this.hintStr.toString() + "%\n");
                            }
                        }
                    }
                } else if (bl5) {
                    QueryUtils.log("Skipped Item#" + n5 + "* Item=" + string8.substring(0, n3) + "*\n");
                }
                string8 = string8.substring(n3, string8.length()).trim();
            }
            if (bl && n4 > 0) {
                this.hintStr.append(string6);
                if (bl5) {
                    QueryUtils.log(this.hintStr.toString() + "%\n");
                }
            }
            n = string7.indexOf(string3, n6) + 1;
        }
    }

    public void adjustWhereVec(SQLGenContext sQLGenContext) {
        if (!this.noUseWith || !this.optTrans || this.hint0leadPosMap.size() == 0 || this.whereVec.size() == 0 || sQLGenContext.varMap.equalColGroups.size() == 0 || this.hintStr.toString().indexOf(" ORDERED ") >= 0) {
            return;
        }
        if (this.m_bLog) {
            GenerateQuery.dumpHashMap(this.hint0leadPosMap);
            GenerateQuery.dumpVector(this.whereVec);
            sQLGenContext.varMap.dumpColGroups();
        }
        for (String string : sQLGenContext.varMap.equalColGroups.keySet()) {
            String string2 = sQLGenContext.varMap.getColGroupByName(string);
            String string3 = sQLGenContext.varMap.getMappingByName(string).trim();
            String string4 = string3.substring(0, string3.indexOf("."));
            Integer n = (Integer)this.hint0leadPosMap.get(string4);
            if (n == null) {
                n = sQLGenContext.nTriples;
            }
            if (n == 1) continue;
            String string5 = string2;
            int n2 = 0;
            String string6 = string4;
            Integer n3 = n;
            while (n2 >= 0) {
                String string7 = (string5 = string5.substring(n2, string5.length()).trim()).substring(0, string5.indexOf("."));
                Integer n4 = (Integer)this.hint0leadPosMap.get(string7);
                if (n4 != null && n4 < n3) {
                    n3 = n4;
                    string6 = string7;
                }
                n2 = string5.indexOf(" ");
            }
            if (this.m_bLog) {
                QueryUtils.log("(var,szBestAlias)=(" + string + "," + string6 + ")\n");
            }
            if (n3 == n) continue;
            int n5 = string2.indexOf(string6 + ".");
            n2 = string2.indexOf(" ", n5);
            if (n2 < 0) {
                n2 = string2.length();
            }
            String string8 = string2.substring(n5, n2);
            for (int i = 0; i < this.whereVec.size(); ++i) {
                String string9;
                String string10;
                String string11 = (String)this.whereVec.elementAt(i);
                int n6 = string11.indexOf("=");
                if (n6 < 1 || !(string10 = string11.substring(n6 + 1, string11.length()).trim()).equalsIgnoreCase(string3) || (string9 = string11.substring(0, n6 - 1).trim()).equalsIgnoreCase(string8)) continue;
                String string12 = string9 + " = " + string8;
                this.whereVec.set(i, string12);
                if (!this.m_bLog) continue;
                QueryUtils.log("substitution: " + string11 + " ==> " + string12 + "\n");
            }
        }
    }

    private String getTopLevelHint() {
        String string = " ";
        if (this.queryOptions != null) {
            string = this.queryOptions;
        }
        String string2 = " ";
        int n = 0;
        n = string.indexOf("HINT1=(");
        if (n >= 0) {
            int n2 = string.indexOf(")", n += "HINT1=(".length());
            if (n2 >= 0) {
                string2 = "( " + string.substring(n, n2) + " )";
            }
            if (this.m_bLog) {
                QueryUtils.log("HINT1: ", string2);
            }
        } else {
            string2 = "( NO_MERGE LEADING USE_NL )";
            if (this.m_bLog) {
                QueryUtils.log("HINT1 (default): ", string2);
            }
        }
        return string2;
    }

    private String getSecondLevelHint() {
        String string = "";
        if (this.queryOptions != null) {
            string = this.queryOptions;
        }
        String string2 = " ";
        if (string.indexOf("HINT2=") >= 0) {
            // empty if block
        }
        return string2;
    }

    private String translateTopLevelHint(String string, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("/*+ ");
        if (string.indexOf(" ORDERED ") >= 0) {
            stringBuffer.append(" ORDERED ");
        }
        if (string.indexOf(" RESULT_CACHE ") >= 0) {
            stringBuffer.append(" RESULT_CACHE ");
        }
        if (string.indexOf(" NO_REWRITE ") >= 0) {
            stringBuffer.append(" NO_REWRITE ");
        }
        if (string.indexOf(" NO_QUERY_TRANSFORMATION ") >= 0) {
            stringBuffer.append(" NO_QUERY_TRANSFORMATION ");
        }
        if (string.indexOf(" NO_MERGE ") >= 0) {
            stringBuffer.append(" NO_MERGE(inner) ");
        }
        if (string.indexOf(" LEADING ") >= 0 || string.indexOf(" USE_NL ") >= 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                String string3 = string2.trim().substring(MDSYS_RDFVTAB_N_SPACE.length()).trim();
                stringBuffer2.append(string3).append(" ");
            }
            if (string.indexOf(" LEADING ") >= 0) {
                stringBuffer.append(" LEADING(inner ").append(stringBuffer2.toString()).append(") ");
            }
            if (string.indexOf(" USE_NL ") >= 0) {
                stringBuffer.append(" USE_NL(").append(stringBuffer2.toString()).append(") ");
            }
        }
        stringBuffer.append(" */ ");
        return stringBuffer.toString();
    }

    public String buildSQLQuery() {
        CharSequence charSequence;
        boolean bl = false;
        if (this.queryOptions != null && (charSequence = this.queryOptions) != null && ((String)charSequence).indexOf("USE_CID=T") >= 0) {
            bl = true;
            if (this.m_bLog) {
                QueryUtils.log("USE_CID=T");
            }
        }
        charSequence = new StringBuffer();
        if (!this.noUseWith && !this.useVM && this.withVec.size() > 0) {
            ((StringBuffer)charSequence).append("WITH ").append(GenerateQuery.concatVec(this.withVec, ", ")).append("\n");
        }
        if (this.distinct) {
            ((StringBuffer)charSequence).append("SELECT ").append(this.hintStr).append("DISTINCT ").append(GenerateQuery.concatVec(this.selectVec, ", ", bl)).append("\n");
        } else {
            ((StringBuffer)charSequence).append("SELECT ").append(this.hintStr).append(GenerateQuery.concatVec(this.selectVec, ", ", bl)).append("\n");
        }
        ((StringBuffer)charSequence).append("FROM ").append(GenerateQuery.concatVec(this.fromVec, ", ")).append("\n");
        if (this.whereVec.size() > 0) {
            ((StringBuffer)charSequence).append("WHERE ").append(GenerateQuery.concatVec(this.whereVec, " AND ", bl)).append("\n");
        } else {
            ((StringBuffer)charSequence).append("WHERE 1=1 ").append("\n");
        }
        if (this.m_bLog) {
            QueryUtils.log("Final query (no opt) => : ", ((StringBuffer)charSequence).toString());
        }
        return ((StringBuffer)charSequence).toString();
    }

    public String buildSQLQuery(boolean bl) {
        CharSequence charSequence;
        Vector<String> vector = null;
        Vector vector2 = null;
        Vector<String> vector3 = null;
        if (!bl) {
            return this.buildSQLQuery();
        }
        boolean bl2 = false;
        if (this.queryOptions != null) {
            charSequence = this.queryOptions;
            if (this.m_bLog) {
                QueryUtils.log("buildSQLQuery: options = ", (String)charSequence);
            }
            if (((String)(charSequence = (String)charSequence + " ")).indexOf("NOHINT ") >= 0 || ((String)charSequence).indexOf("NOHINT=T ") >= 0 || this.hint0present) {
                return this.buildSQLQuery();
            }
            if (((String)charSequence).indexOf("USE_CID=T") >= 0) {
                bl2 = true;
                if (this.m_bLog) {
                    QueryUtils.log("USE_CID=T");
                }
            }
        }
        charSequence = new StringBuffer();
        boolean bl3 = false;
        if (this.fromVec != null && this.fromVec.size() > 0) {
            int n = 0;
            do {
                String string = (String)this.fromVec.elementAt(n);
                if (this.m_bLog) {
                    QueryUtils.log("Analyze from clause: ", string);
                }
                if (string.trim().startsWith(MDSYS_RDFVTAB_N_SPACE)) {
                    bl3 = true;
                    if (vector2 == null) {
                        vector = new Vector<String>();
                        vector2 = new Vector();
                        vector3 = new Vector<String>();
                    }
                    if (this.m_bLog) {
                        QueryUtils.log("Analyze from clause: move it out");
                    }
                    vector2.add(this.fromVec.elementAt(n));
                    this.fromVec.remove(n);
                    String string2 = string.trim().substring(MDSYS_RDFVTAB_N_SPACE.length()).trim();
                    if (this.m_bLog) {
                        QueryUtils.log("Analyze from clause: alias ", string2);
                    }
                    int n2 = 0;
                    while (n2 < this.whereVec.size()) {
                        String string3 = (String)this.whereVec.elementAt(n2);
                        if (this.m_bLog) {
                            QueryUtils.log("Cross check where clause: cond ", string3);
                        }
                        if (string3.trim().startsWith(string2 + ".")) {
                            int n3 = string3.indexOf("=");
                            String string4 = string3.substring(n3 + 1).trim();
                            String string5 = string4.replace(".", "_");
                            this.whereVec.remove(n2);
                            String string6 = string4 + " " + string5;
                            if (!vector.contains(string6)) {
                                vector.add(string6);
                            }
                            String string7 = string3.substring(0, n3) + "= inner." + string5;
                            vector3.add(string7);
                            if (!this.m_bLog) continue;
                            QueryUtils.log("Cross check where clause: triple column    ", string4);
                            QueryUtils.log("Cross check where clause: triple col alias ", string5);
                            QueryUtils.log("Cross check where clause: szSelElem        ", string6);
                            QueryUtils.log("Cross check where clause: szWhereElem      ", string7);
                            continue;
                        }
                        ++n2;
                    }
                } else {
                    ++n;
                }
            } while (n < this.fromVec.size());
        }
        if (!bl3) {
            if (this.m_bLog) {
                QueryUtils.log("Analyze from clause: end result no value$ part to isolate out");
            }
            return this.buildSQLQuery();
        }
        if (!this.useVM && this.withVec.size() > 0) {
            ((StringBuffer)charSequence).append("WITH ").append(GenerateQuery.concatVec(this.withVec, ", ")).append("\n");
        }
        if (this.distinct) {
            ((StringBuffer)charSequence).append("SELECT ").append(this.translateTopLevelHint(this.getTopLevelHint(), vector2)).append("DISTINCT ").append(GenerateQuery.concatVec(this.selectVec, ", ", bl2)).append("\nFROM (");
        } else {
            ((StringBuffer)charSequence).append("SELECT ").append(this.translateTopLevelHint(this.getTopLevelHint(), vector2)).append(GenerateQuery.concatVec(this.selectVec, ", ", bl2)).append("\nFROM (");
        }
        ((StringBuffer)charSequence).append("SELECT ").append(this.getSecondLevelHint()).append(GenerateQuery.concatVec(vector, ", ", bl2));
        ((StringBuffer)charSequence).append(" FROM ").append(GenerateQuery.concatVec(this.fromVec, ", ")).append("\n");
        if (this.whereVec.size() > 0) {
            ((StringBuffer)charSequence).append("WHERE ").append(GenerateQuery.concatVec(this.whereVec, " AND ", bl2));
        } else {
            ((StringBuffer)charSequence).append("WHERE 1=1 ");
        }
        ((StringBuffer)charSequence).append(") inner, ").append(GenerateQuery.concatVec(vector2, ", ")).append(" WHERE ").append(GenerateQuery.concatVec(vector3, " AND ", bl2)).append("\n");
        if (this.m_bLog) {
            QueryUtils.log("Final query : ", ((StringBuffer)charSequence).toString());
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static String concatVec(Vector vector, String string) {
        return GenerateQuery.concatVec(vector, string, false);
    }

    public static String concatVec(Vector vector, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            if (!bl) {
                stringBuffer.append((String)vector.elementAt(i));
                continue;
            }
            String string2 = (String)vector.elementAt(i);
            stringBuffer.append(string2.replaceAll("\\.END_NODE_ID", ".CANON_END_NODE_ID"));
        }
        return stringBuffer.toString();
    }

    private String buildInList(String string, long[] lArray) {
        String string2 = "";
        if (lArray != null && lArray.length > 0) {
            string2 = " " + string + " IN (";
            for (int i = 0; i < lArray.length; ++i) {
                if (i > 0) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + lArray[i];
            }
            string2 = string2 + ") ";
        }
        return string2;
    }

    public String resolveModels(Connection connection, String[] stringArray, String string, String string2, String string3, String string4) throws RDFException, SQLException {
        SQLGenContext sQLGenContext = new SQLGenContext();
        sQLGenContext.conn = connection;
        sQLGenContext.clnNetworkOwner = QueryUtils.getNetworkOwnerOrMdsys(string3);
        sQLGenContext.clnNetworkName = QueryUtils.getNetworkNameOrEmptyString(string4);
        sQLGenContext.clnPfxForRdfObjName = QueryUtils.getPfxForRdfObjName(sQLGenContext.clnNetworkOwner, sQLGenContext.clnNetworkName);
        return this.resolveModels(sQLGenContext, stringArray, string, -1L, string2, null, new long[0], new long[0], new long[0], new String[0], 0);
    }

    public String resolveModels(SQLGenContext sQLGenContext, String[] stringArray, String string, long l, String string2, String string3, long[] lArray, long[] lArray2, long[] lArray3, String[] stringArray2, int n) throws RDFException {
        SPARQLEngine.setQueryOptions(sQLGenContext, n);
        SPARQLEngine.setTripleRowSources(sQLGenContext, stringArray, string, l, string2, string3, lArray, lArray2, lArray3, stringArray2, n);
        this.basicTriples = sQLGenContext.basicTriples;
        this.vmViewName = sQLGenContext.vmViewName;
        this.useVM = sQLGenContext.useVM;
        this.relaxFilter = sQLGenContext.relaxFilter;
        this.disableNoMerge = sQLGenContext.disableNoMerge;
        this.enableNoMerge = sQLGenContext.enableNoMerge;
        this.allBgpHash = sQLGenContext.allBgpHash;
        this.allBgpNL = sQLGenContext.allBgpNL;
        this.allNoMerge = sQLGenContext.allNoMerge;
        this.allSwap = sQLGenContext.allSwap;
        this.allOrdered = sQLGenContext.allOrdered;
        this.noPushVal = sQLGenContext.noPushVal;
        return sQLGenContext.basicTriplesWith;
    }

    public static String selectCMP(String[] stringArray) {
        String string;
        int n = stringArray.length;
        if (n == 0) {
            string = "SELECT VALUE_ID FROM MDSYS.RDF_VALUE$ WHERE 0 = 1";
        } else {
            string = "SELECT v.VALUE_ID FROM MDSYS.RDF_VALUE$ v\n WHERE v.VNAME_PREFIX || v.VNAME_SUFFIX LIKE 'http://www.w3.org/1999/02/22-rdf-syntax-ns#\\_%' ESCAPE '\\'\n AND REGEXP_LIKE(v.VNAME_PREFIX || v.VNAME_SUFFIX, 'http://www.w3.org/1999/02/22-rdf-syntax-ns#_[0-9]*')\nINTERSECT\n(\n";
            for (int i = 0; i < n; ++i) {
                String string2 = "\"MDSYS\".\"RDFM_" + stringArray[i].toUpperCase() + "\"";
                if (i > 0) {
                    string = string + "UNION ALL\n";
                }
                string = string + "SELECT start_node_id FROM " + string2 + "\nUNION ALL\nSELECT p_value_id FROM " + string2 + "\nUNION ALL\nSELECT end_node_id FROM " + string2 + "\n";
            }
            string = string + ")";
        }
        string = string + "\n";
        return string;
    }

    public void addWithMap(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" (\n").append(string2).append(")\n");
        this.withAliasToSqlMap.put(string, stringBuffer.toString());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string).append(" AS ").append(stringBuffer.toString());
        this.addWith(stringBuffer2.toString());
    }

    private void addWith(String string) {
        this.withVec.add(string);
    }

    public void addSelect(String string) {
        this.selectVec.add(string);
    }

    public void addFrom(String string) {
        this.fromVec.add(string);
    }

    public void addWhere(String string) {
        this.whereVec.add(string);
    }

    public String buildSQLfromSPARQL(SQLGenContext sQLGenContext, Node node, ASTTopLevelQueryNode aSTTopLevelQueryNode, int[] nArray) throws TypeException, FilterException, ParseException, RDFException {
        return this.buildSQLfromSPARQL(sQLGenContext, node, aSTTopLevelQueryNode, nArray, 0, new int[1], new ArrayList<Integer>(), new String[1]);
    }

    public String buildSQLfromSPARQL(SQLGenContext sQLGenContext, Node node, ASTTopLevelQueryNode aSTTopLevelQueryNode, int[] nArray, int n, int[] nArray2, List<Integer> list, String[] stringArray) throws TypeException, FilterException, ParseException, RDFException {
        Object object;
        ClauseTreeNode clauseTreeNode2;
        SPARQLEngine.populateFuncTypeMap(sQLGenContext);
        SPARQLEngine.populateFuncHandMap(sQLGenContext);
        if (sQLGenContext.dmpAST) {
            QueryUtils.log("%%%%%%%%%%%%% Original AST %%%%%%%%%%%%%%%%%%%%%%%%%\n");
            ((SimpleNode)node).dump("");
            QueryUtils.log("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
        Node node2 = this.extractTopGGP(node);
        ArrayList<SparqlQueryOptimizer> arrayList = new ArrayList<SparqlQueryOptimizer>();
        FilterScopeOptimizer filterScopeOptimizer = new FilterScopeOptimizer(sQLGenContext.funcTypeMap);
        GGPCollapseOptimizer gGPCollapseOptimizer = new GGPCollapseOptimizer();
        UnionRewriteOptimizer unionRewriteOptimizer = new UnionRewriteOptimizer();
        arrayList.add(filterScopeOptimizer);
        arrayList.add(gGPCollapseOptimizer);
        arrayList.add(unionRewriteOptimizer);
        arrayList.add(filterScopeOptimizer);
        node2 = SPARQLEngine.optimizeAST(node2, arrayList, sQLGenContext);
        if (sQLGenContext.dmpAST) {
            QueryUtils.log("%%%%%%%%%%%%% Optimized AST %%%%%%%%%%%%%%%%%%%%%%%%%\n");
            ((SimpleNode)node2).dump("");
            QueryUtils.log("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
        List<ClauseTreeNode> list2 = this.buildCTUnionList(node2, sQLGenContext);
        this.setIsUnionQuery(list2);
        if (this.unionQuery) {
            nArray2[0] = nArray2[0] | 4;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (ClauseTreeNode clauseTreeNode2 : list2) {
            hashSet.addAll(this.extractFilterVars(clauseTreeNode2));
            hashSet2.addAll(this.extractFilterJoinVars(clauseTreeNode2));
        }
        Set<String> set = this.extractAllRootVars(list2);
        if (!this.unionQuery) {
            this.buildHint(sQLGenContext, false);
        }
        this.preprocessFilters(sQLGenContext, list2, hashSet2, nArray2);
        this.preprocessClauseTrees(list2);
        if ((n & 4) == 0 && (nArray2[0] & 1) > 0) {
            return "";
        }
        clauseTreeNode2 = null;
        if ((nArray2[0] & 1) > 0) {
            object = this.extractCoverMap(list2);
            stringArray[0] = this.buildOrderByClause((Map<String, List<String>>)object);
            sQLGenContext.varMap.buildColIdxMap();
            list.addAll(sQLGenContext.varMap.getValueIdPositions());
            if (this.unionQuery) {
                list.add(new Integer(sQLGenContext.varMap.getTotalNumCols() + 1));
            }
        }
        object = "";
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        for (ClauseTreeNode clauseTreeNode3 : list2) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append(this.sparqlToSQL(clauseTreeNode3, sQLGenContext, nArray, sQLGenContext.funcTypeMap, hashSet2, n2));
                if (this.unionQuery) {
                    stringBuffer.insert(0, "(");
                    stringBuffer.append(")\n");
                }
            } else {
                stringBuffer.append("UNION ALL\n(" + this.sparqlToSQL(clauseTreeNode3, sQLGenContext, nArray, sQLGenContext.funcTypeMap, hashSet2, n2) + ")\n");
            }
            ++n2;
        }
        object = stringBuffer.toString();
        if (this.hint0present && !this.noPushVal) {
            hashSet2.addAll((Collection<String>)set);
        }
        object = this.performJoinWithValuesOptimized((String)object, hashSet2, set, sQLGenContext, nArray);
        return object;
    }

    public Node extractTopGGP(Node node) {
        Node node2 = node.cloneNode();
        Node node3 = null;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(node);
        boolean bl = false;
        while (!bl && !linkedList.isEmpty()) {
            Node node4 = (Node)linkedList.remove();
            if (((SimpleNode)node4).id == 48) {
                node3 = node4.cloneSubTree();
                node3.jjtSetParent(node2);
                node2.jjtAddChild(node3, 0);
                bl = true;
                continue;
            }
            for (int i = 0; i < node4.jjtGetNumChildren(); ++i) {
                linkedList.offer(node4.jjtGetChild(i));
            }
        }
        return node2;
    }

    public void setIsUnionQuery(List<ClauseTreeNode> list) {
        if (list.size() > 1) {
            this.unionQuery = true;
        } else {
            LinkedList<ClauseTreeNode> linkedList = new LinkedList<ClauseTreeNode>();
            linkedList.offer(list.get(0));
            while (!linkedList.isEmpty() && !this.unionQuery) {
                ClauseTreeNode clauseTreeNode = (ClauseTreeNode)linkedList.remove();
                if (clauseTreeNode.type.equalsIgnoreCase("UNION")) {
                    this.unionQuery = true;
                    continue;
                }
                for (int i = 0; i < clauseTreeNode.getNumChildren(); ++i) {
                    linkedList.offer(clauseTreeNode.getChild(i));
                }
            }
        }
    }

    public String buildOrderByClause(Map<String, List<String>> map) {
        Set<Map.Entry<String, List<String>>> set;
        String string = " ORDER BY ";
        if (this.unionQuery) {
            string = string + "R.RDF$L";
        }
        if ((set = map.entrySet()).size() > 1) {
            int n = 0;
            boolean bl = true;
            while (bl) {
                String string2 = "";
                bl = false;
                boolean bl2 = false;
                for (Map.Entry<String, List<String>> entry : set) {
                    if (entry.getValue().size() <= n) continue;
                    bl = true;
                    string2 = string2 + ", '" + entry.getKey() + "', " + entry.getValue().get(n);
                }
                if (string2.length() > 0) {
                    string2 = "DECODE(R.RDF$L" + string2 + ")";
                    string = string.equals(" ORDER BY ") ? string + string2 + " NULLS LAST" : string + ", " + string2 + " NULLS LAST";
                }
                ++n;
            }
        } else {
            for (Map.Entry<String, List<String>> entry : set) {
                for (String string3 : entry.getValue()) {
                    if (string.equals(" ORDER BY ")) {
                        string = string + string3 + " NULLS LAST";
                        continue;
                    }
                    string = string + ", " + string3 + " NULLS LAST";
                }
            }
        }
        return string;
    }

    public List<ClauseTreeNode> buildCTUnionList(Node node, SQLGenContext sQLGenContext) {
        List<Node> list = this.buildASTUnionList(node, sQLGenContext);
        ArrayList<ClauseTreeNode> arrayList = new ArrayList<ClauseTreeNode>();
        ClauseTreeNode clauseTreeNode = null;
        for (Node node2 : list) {
            clauseTreeNode = new ClauseTreeNode(sQLGenContext.srcTabName, this.ctnIdCtr);
            ++this.ctnIdCtr;
            this.createClauseTree((SimpleNode)node2, clauseTreeNode, sQLGenContext);
            arrayList.add(clauseTreeNode);
        }
        return arrayList;
    }

    public List<Node> buildASTUnionList(Node node, SQLGenContext sQLGenContext) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        if (node.jjtGetNumChildren() == 1 && ((SimpleNode)node.jjtGetChild((int)0)).id == 48 && (node2 = node.jjtGetChild(0)).jjtGetNumChildren() == 1 && ((SimpleNode)node2.jjtGetChild((int)0)).id == 49 && (node2 = node2.jjtGetChild(0)).jjtGetNumChildren() == 1 && ((SimpleNode)node2.jjtGetChild((int)0)).id == 55) {
            node2 = node2.jjtGetChild(0);
            for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                node3 = node2.jjtGetChild(i);
                node4 = node.cloneNode();
                node4.jjtAddChild(node3, 0);
                node3.jjtSetParent(node4);
                arrayList.add(node4);
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(node);
        }
        return arrayList;
    }

    public void preprocessFilters(SQLGenContext sQLGenContext, List<ClauseTreeNode> list, Set<String> set, int[] nArray) throws RDFException, TypeException, FilterException {
        for (ClauseTreeNode clauseTreeNode : list) {
            Set<String> set2 = this.extractPatternVars(clauseTreeNode);
            this.markSpecialFilters(clauseTreeNode);
            this.updateCTVarDeps(clauseTreeNode);
            this.setFilterJoinVars(clauseTreeNode, set);
            this.validateVarReferences(clauseTreeNode, set2, nArray);
            this.validateFilterExpressions(clauseTreeNode, sQLGenContext.funcTypeMap);
        }
    }

    public void optimizeFilters(ClauseTreeNode clauseTreeNode, List<SparqlFilterOptimizer> list) throws RDFException, FilterException {
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        stack.push(clauseTreeNode);
        while (!stack.empty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            for (Filter filter : clauseTreeNode2.getFilters()) {
                for (SparqlFilterOptimizer sparqlFilterOptimizer : list) {
                    filter.applyFilterOptimizer(sparqlFilterOptimizer);
                }
            }
            List<ClauseTreeNode> list2 = clauseTreeNode2.children;
            if (list2 == null) continue;
            for (int i = list2.size() - 1; i >= 0; --i) {
                stack.push(list2.get(i));
            }
        }
    }

    public Map<String, List<String>> extractCoverMap(List<ClauseTreeNode> list) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (int i = 0; i < list.size(); ++i) {
            CoveringTreeNode coveringTreeNode = new CoveringTreeNode(String.valueOf(i));
            this.populateCoveringTree(coveringTreeNode, list.get(i));
            this.updateMapForCoverT(coveringTreeNode, hashMap);
        }
        return hashMap;
    }

    public void populateCoveringTree(CoveringTreeNode coveringTreeNode, ClauseTreeNode clauseTreeNode) {
        if (clauseTreeNode.type.equalsIgnoreCase("UNION")) {
            for (int i = 0; i < clauseTreeNode.getNumChildren(); ++i) {
                CoveringTreeNode coveringTreeNode2 = new CoveringTreeNode(coveringTreeNode.key + "$" + String.valueOf(i));
                coveringTreeNode2.varList.addAll(coveringTreeNode.varList);
                coveringTreeNode.children.add(coveringTreeNode2);
                this.populateCoveringTree(coveringTreeNode2, clauseTreeNode.getChild(i));
            }
        } else {
            for (String string : clauseTreeNode.getNewBindings()) {
                coveringTreeNode.varList.add("R." + string + "$RDFVID");
            }
            for (int i = 0; i < clauseTreeNode.getNumChildren(); ++i) {
                this.populateCoveringTree(coveringTreeNode, clauseTreeNode.getChild(i));
            }
        }
    }

    public void updateMapForCoverT(CoveringTreeNode coveringTreeNode, Map<String, List<String>> map) {
        Stack<CoveringTreeNode> stack = new Stack<CoveringTreeNode>();
        stack.push(coveringTreeNode);
        while (!stack.isEmpty()) {
            CoveringTreeNode coveringTreeNode2 = (CoveringTreeNode)stack.pop();
            if (coveringTreeNode2.children.isEmpty()) {
                map.put(coveringTreeNode2.key, coveringTreeNode2.varList);
                continue;
            }
            for (int i = coveringTreeNode2.children.size() - 1; i >= 0; --i) {
                stack.push(coveringTreeNode2.children.get(i));
            }
        }
    }

    public Set<String> updateCTVarDeps(ClauseTreeNode clauseTreeNode) {
        List<ClauseTreeNode> list = clauseTreeNode.children;
        HashSet<String> hashSet = new HashSet<String>(clauseTreeNode.getNewBindings());
        if (list != null) {
            for (ClauseTreeNode clauseTreeNode2 : list) {
                hashSet.addAll(this.updateCTVarDeps(clauseTreeNode2));
            }
        }
        clauseTreeNode.setFilterDepVars(hashSet);
        return hashSet;
    }

    public void validateVarReferences(ClauseTreeNode clauseTreeNode, Set<String> set, int[] nArray) throws FilterException {
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        HashSet<String> hashSet = new HashSet<String>();
        stack.push(clauseTreeNode);
        while (!stack.empty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            hashSet.addAll(clauseTreeNode2.getNewBindings());
            List<Filter> list = clauseTreeNode2.getFilters();
            for (Filter filter : list) {
                Set<String> set2 = filter.getVars();
                for (String string : set2) {
                    if (!set.contains(string)) {
                        throw new FilterException("Variable ?" + string + " is undefined");
                    }
                    if (clauseTreeNode2.label.equalsIgnoreCase("Root") || hashSet.contains(string)) continue;
                    this.probFilterExists = true;
                    if (this.relaxFilter) {
                        QueryUtils.log("Returning duplicate/covered results for forward referencing filter");
                        continue;
                    }
                    nArray[0] = nArray[0] | 1;
                }
            }
            List<ClauseTreeNode> list2 = clauseTreeNode2.children;
            if (list2 == null) continue;
            for (int i = list2.size() - 1; i >= 0; --i) {
                stack.push(list2.get(i));
            }
        }
    }

    public void validateFilterExpressions(ClauseTreeNode clauseTreeNode, Map<String, String> map) throws RDFException, TypeException {
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        stack.push(clauseTreeNode);
        while (!stack.empty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            List<Filter> list = clauseTreeNode2.getFilters();
            for (Filter filter : list) {
                filter.validateFilter(map);
            }
            List<ClauseTreeNode> list2 = clauseTreeNode2.children;
            if (list2 == null) continue;
            for (int i = list2.size() - 1; i >= 0; --i) {
                stack.push(list2.get(i));
            }
        }
    }

    public void markSpecialFilters(ClauseTreeNode clauseTreeNode) {
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        stack.push(clauseTreeNode);
        while (!stack.empty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            clauseTreeNode2.setSpecialCaseFilters();
            List<ClauseTreeNode> list = clauseTreeNode2.children;
            if (list == null) continue;
            for (int i = list.size() - 1; i >= 0; --i) {
                stack.push(list.get(i));
            }
        }
    }

    public Set<String> extractPatternVars(ClauseTreeNode clauseTreeNode) {
        HashSet<String> hashSet = new HashSet<String>();
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        stack.push(clauseTreeNode);
        while (!stack.empty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            hashSet.addAll(clauseTreeNode2.varset.keySet());
            List<ClauseTreeNode> list = clauseTreeNode2.children;
            if (list == null) continue;
            for (int i = list.size() - 1; i >= 0; --i) {
                stack.push(list.get(i));
            }
        }
        return hashSet;
    }

    public Set<String> extractFilterVars(ClauseTreeNode clauseTreeNode) {
        HashSet<String> hashSet = new HashSet<String>();
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        stack.push(clauseTreeNode);
        while (!stack.empty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            List<Filter> list = clauseTreeNode2.getFilters();
            for (Filter filter : list) {
                for (String string : filter.getVars()) {
                    hashSet.add(string);
                }
            }
            List<ClauseTreeNode> list2 = clauseTreeNode2.children;
            if (list2 == null) continue;
            for (int i = list2.size() - 1; i >= 0; --i) {
                stack.push(list2.get(i));
            }
        }
        return hashSet;
    }

    public Set<String> extractFilterJoinVars(ClauseTreeNode clauseTreeNode) {
        HashSet<String> hashSet = new HashSet<String>();
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        stack.push(clauseTreeNode);
        while (!stack.empty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            List<Filter> list = clauseTreeNode2.getFilters();
            for (Filter filter : list) {
                for (String string : filter.getfJoinVars()) {
                    hashSet.add(string);
                }
            }
            List<ClauseTreeNode> list2 = clauseTreeNode2.children;
            if (list2 == null) continue;
            for (int i = list2.size() - 1; i >= 0; --i) {
                stack.push(list2.get(i));
            }
        }
        return hashSet;
    }

    public void setFilterJoinVars(ClauseTreeNode clauseTreeNode, Set<String> set) {
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        stack.push(clauseTreeNode);
        while (!stack.empty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            for (String string : clauseTreeNode2.getNewBindings()) {
                if (!set.contains(string)) continue;
                clauseTreeNode2.addFilterJoinVar(string);
            }
            List<ClauseTreeNode> list = clauseTreeNode2.children;
            if (list == null) continue;
            for (int i = list.size() - 1; i >= 0; --i) {
                stack.push(list.get(i));
            }
        }
    }

    public void createClauseTree(SimpleNode simpleNode, ClauseTreeNode clauseTreeNode, SQLGenContext sQLGenContext) {
        String string = null;
        this.createClauseTree(simpleNode, clauseTreeNode, clauseTreeNode, string, sQLGenContext, new HashSet<String>());
    }

    public ClauseTreeNode createClauseTree(SimpleNode simpleNode, ClauseTreeNode clauseTreeNode, ClauseTreeNode clauseTreeNode2, String string, SQLGenContext sQLGenContext, Set<String> set) {
        try {
            int n = simpleNode.id;
            String string2 = simpleNode.toString();
            if (n == 48) {
                if (clauseTreeNode.label == null) {
                    clauseTreeNode.setLabel("Root");
                    clauseTreeNode.setType("WHERE");
                    clauseTreeNode2 = clauseTreeNode;
                    if (simpleNode.children != null) {
                        clauseTreeNode.children_left = simpleNode.children.length - 1;
                        for (Node node : simpleNode.children) {
                            SimpleNode simpleNode2 = (SimpleNode)node;
                            this.createClauseTree(simpleNode2, clauseTreeNode, clauseTreeNode2, string, sQLGenContext, set);
                        }
                    } else {
                        clauseTreeNode.children_left = 0;
                    }
                    return clauseTreeNode2;
                }
                if (clauseTreeNode2.type == null) {
                    clauseTreeNode2.setType("WHERE");
                }
                clauseTreeNode2.children_left = simpleNode.children.length - 1;
                for (Node node : simpleNode.children) {
                    SimpleNode simpleNode3 = (SimpleNode)node;
                    this.createClauseTree(simpleNode3, clauseTreeNode, clauseTreeNode2, string, sQLGenContext, set);
                }
                return clauseTreeNode2;
            }
            if (n == 47) {
                BasicGraphPattern basicGraphPattern = new BasicGraphPattern();
                ArrayList<TriplesBlock> arrayList = new ArrayList<TriplesBlock>();
                this.createTB(arrayList, simpleNode.children, sQLGenContext);
                if (clauseTreeNode2.bgp == null) {
                    basicGraphPattern.populateTriplesList(arrayList);
                    clauseTreeNode2.populateClauseTreeNode(basicGraphPattern, set);
                } else {
                    arrayList.addAll(0, clauseTreeNode2.bgp.TBList);
                    basicGraphPattern.populateTriplesList(arrayList);
                    clauseTreeNode2.populateClauseTreeNode(basicGraphPattern, set);
                }
                return clauseTreeNode2;
            }
            if (n == 49) {
                ClauseTreeNode clauseTreeNode3 = clauseTreeNode2;
                HashSet<String> hashSet = new HashSet<String>(set);
                if (((SimpleNode)simpleNode.jjtGetChild((int)0)).id == 50 && !this.isOptUnionSpecialCase((SimpleNode)simpleNode.jjtGetChild(0)) || ((SimpleNode)simpleNode.jjtGetChild((int)0)).id == 55) {
                    clauseTreeNode3 = new ClauseTreeNode(sQLGenContext.srcTabName, this.ctnIdCtr);
                    ++this.ctnIdCtr;
                    clauseTreeNode2.children.add(clauseTreeNode3);
                    clauseTreeNode3.setParent(clauseTreeNode2);
                    clauseTreeNode3.setLabel("Non-Root");
                    hashSet.addAll(clauseTreeNode2.varset.keySet());
                }
                --clauseTreeNode2.children_left;
                for (Node node : simpleNode.children) {
                    SimpleNode simpleNode4 = (SimpleNode)node;
                    this.createClauseTree(simpleNode4, clauseTreeNode, clauseTreeNode3, string, sQLGenContext, hashSet);
                }
                return clauseTreeNode2;
            }
            if (n == 50) {
                if (clauseTreeNode2.type == null) {
                    clauseTreeNode2.setType("Optional");
                }
                for (Node node : simpleNode.children) {
                    SimpleNode simpleNode5 = (SimpleNode)node;
                    this.createClauseTree(simpleNode5, clauseTreeNode, clauseTreeNode2, string, sQLGenContext, set);
                }
                return clauseTreeNode2;
            }
            if (n == 56) {
                this.extractFilter(simpleNode, clauseTreeNode2, sQLGenContext);
                return clauseTreeNode2;
            }
            if (n == 55) {
                clauseTreeNode2.setType("UNION");
                clauseTreeNode2.setLabel("Non-Root");
                for (Node node : simpleNode.children) {
                    SimpleNode simpleNode6 = (SimpleNode)node;
                    ClauseTreeNode clauseTreeNode4 = new ClauseTreeNode(sQLGenContext.srcTabName, this.ctnIdCtr);
                    ++this.ctnIdCtr;
                    clauseTreeNode4.setParent(clauseTreeNode2);
                    clauseTreeNode2.children.add(clauseTreeNode4);
                    this.createClauseTree(simpleNode6, clauseTreeNode4, clauseTreeNode4, string, sQLGenContext, new HashSet<String>());
                }
            } else if (simpleNode.children != null) {
                for (Node node : simpleNode.children) {
                    SimpleNode simpleNode7 = (SimpleNode)node;
                    clauseTreeNode2 = this.createClauseTree(simpleNode7, clauseTreeNode, clauseTreeNode2, string, sQLGenContext, set);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return clauseTreeNode2;
    }

    public boolean isOptUnionSpecialCase(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = null;
        boolean bl = false;
        if (simpleNode.id == 50 && simpleNode.jjtGetNumChildren() == 1) {
            simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
            if (simpleNode2.id == 48 && simpleNode2.jjtGetNumChildren() == 1) {
                simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(0);
                if (simpleNode2.id == 49 && simpleNode2.jjtGetNumChildren() == 1) {
                    simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(0);
                    if (simpleNode2.id == 55) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public void preprocessClauseTrees(List<ClauseTreeNode> list) {
        for (ClauseTreeNode clauseTreeNode : list) {
            this.preprocessClauseTree(clauseTreeNode);
        }
    }

    public void preprocessClauseTree(ClauseTreeNode clauseTreeNode) {
        this.updateCTForUnion(clauseTreeNode, new HashMap<String, String>(), new HashSet<String>(), new HashSet<String>(), new ArrayList<Filter>(), new HashSet<String>());
    }

    public void updateCTForUnion(ClauseTreeNode clauseTreeNode, Map<String, String> map, Set<String> set, Set<String> set2, List<Filter> list, Set<String> set3) {
        int n = clauseTreeNode.children.size();
        ArrayList arrayList = new ArrayList(n);
        ArrayList arrayList2 = new ArrayList(n);
        ArrayList arrayList3 = new ArrayList(n);
        ArrayList arrayList4 = new ArrayList(n);
        ArrayList arrayList5 = new ArrayList(n);
        map.putAll(clauseTreeNode.varset);
        set.addAll(clauseTreeNode.getNewBindings());
        set2.addAll(clauseTreeNode.getFilterJoinVars());
        list.addAll(clauseTreeNode.getFilters());
        set3.addAll(clauseTreeNode.getDummyVarsForLOJ());
        for (int i = 0; i < n; ++i) {
            arrayList.add(new HashMap());
            arrayList2.add(new HashSet());
            arrayList3.add(new HashSet());
            arrayList4.add(new ArrayList());
            arrayList5.add(new HashSet());
            this.updateCTForUnion(clauseTreeNode.children.get(i), (Map)arrayList.get(i), (Set)arrayList2.get(i), (Set)arrayList3.get(i), (List)arrayList4.get(i), (Set)arrayList5.get(i));
            map.putAll((Map)arrayList.get(i));
            set.addAll((Collection)arrayList2.get(i));
            set2.addAll((Collection)arrayList3.get(i));
            list.addAll((Collection)arrayList4.get(i));
            set3.addAll((Collection)arrayList5.get(i));
        }
        if (clauseTreeNode.type.equals("UNION")) {
            clauseTreeNode.varset.putAll(map);
            clauseTreeNode.getNewBindings().addAll(set);
            clauseTreeNode.getFilterJoinVars().addAll(set2);
            for (Filter filter : list) {
                try {
                    Filter filter2 = (Filter)filter.clone();
                    filter2.clearSpecialCase();
                    clauseTreeNode.addFilter(filter2);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
            clauseTreeNode.setSpecialCaseFilters();
            clauseTreeNode.getDummyVarsForLOJ().addAll(set3);
            clauseTreeNode.setBGP(new BasicGraphPattern());
        }
    }

    public void createTB(List<TriplesBlock> list, Node[] nodeArray, SQLGenContext sQLGenContext) {
        SimpleNode[] simpleNodeArray = new SimpleNode[3];
        int n = 0;
        for (Node node : nodeArray) {
            SimpleNode simpleNode = (SimpleNode)node;
            if (simpleNode.toString().equalsIgnoreCase("TriplesBlock")) {
                this.createTB(list, simpleNode.children, sQLGenContext);
            } else {
                simpleNodeArray[n++] = simpleNode;
            }
            if (n != 3) continue;
            TriplesBlock triplesBlock = new TriplesBlock(simpleNodeArray, sQLGenContext);
            list.add(triplesBlock);
            n = 0;
        }
    }

    public void extractFilter(SimpleNode simpleNode, ClauseTreeNode clauseTreeNode, SQLGenContext sQLGenContext) {
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        stack.push(simpleNode);
        while (!stack.empty()) {
            SimpleNode simpleNode2 = (SimpleNode)stack.pop();
            int n = simpleNode2.id;
            if (n == 79 || n == 56) {
                int n2 = simpleNode2.jjtGetNumChildren();
                for (int i = n2 - 1; i >= 0; --i) {
                    stack.push((SimpleNode)simpleNode2.jjtGetChild(i));
                }
                continue;
            }
            Filter filter = new Filter(simpleNode2, sQLGenContext);
            filter.init();
            clauseTreeNode.addFilter(filter);
        }
    }

    public Map<String, String> buildFilterAliasMap(SQLGenContext sQLGenContext, int[] nArray, ClauseTreeNode clauseTreeNode, boolean bl, boolean bl2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = "";
        String string2 = "";
        int n = -1;
        int n2 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Set<String> set = clauseTreeNode.getNewBindings();
        BasicGraphPattern basicGraphPattern = clauseTreeNode.bgp;
        for (String string3 : sQLGenContext.varMap.indexedNames) {
            String string4;
            if (!bl) {
                if (set.contains(string3)) {
                    if (!bl2) {
                        string2 = clauseTreeNode.varset.get(string3);
                        if (string2 == null) continue;
                        string2 = string2.equalsIgnoreCase("Subject") ? "0" : (string2.equalsIgnoreCase("Predicate") ? "1" : "2");
                        string4 = "V" + basicGraphPattern.BGPelements.get((Object)new StringBuilder().append((String)string3).append((String)",").append((String)string2).toString()).uniqueId;
                        hashMap.put(string3, string4);
                        continue;
                    }
                    string4 = "r2." + string3;
                    hashMap.put(string3, string4);
                    continue;
                }
                string4 = "r1." + string3;
                hashMap.put(string3, string4);
                continue;
            }
            string4 = "R." + string3;
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public String sparqlToSQL(ClauseTreeNode clauseTreeNode, SQLGenContext sQLGenContext, int[] nArray, Map<String, String> map, Set<String> set, int n) throws RDFException {
        return this.sparqlToSQL(clauseTreeNode, sQLGenContext, nArray, map, set, n, null, null, false);
    }

    public String sparqlToSQL(ClauseTreeNode clauseTreeNode, SQLGenContext sQLGenContext, int[] nArray, Map<String, String> map, Set<String> set, int n, Set<String> set2, SortedSet<String> sortedSet, boolean bl) throws RDFException {
        String string = new String();
        ArrayList<String> arrayList = new ArrayList<String>();
        Stack<Object> stack = new Stack<Object>();
        Object var13_13 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        ArrayList<Filter> arrayList2 = new ArrayList<Filter>();
        Set<String> set3 = this.extractClauseTreeVars(clauseTreeNode);
        TreeSet<String> treeSet = new TreeSet<String>();
        boolean bl2 = false;
        String string2 = "";
        stack.push(clauseTreeNode);
        while (!stack.isEmpty()) {
            Object object;
            ArrayList<String> arrayList3;
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            boolean bl3 = true;
            bl2 = false;
            if (clauseTreeNode2.label.equalsIgnoreCase("Root")) {
                arrayList3 = new ArrayList<String>();
                if (this.hint0present && !this.noPushVal) {
                    arrayList3.addAll(clauseTreeNode2.varset.keySet());
                } else {
                    arrayList3.addAll(clauseTreeNode2.getFilterJoinVars());
                }
                hashMap2 = this.buildFilterAliasMap(sQLGenContext, nArray, clauseTreeNode, false, false);
                object = clauseTreeNode2.bgpToSQL(bl3, arrayList3, sQLGenContext, nArray, this.vmViewName, this.sparqlNoUseWith, this.sparqlUseExact, this.basicTriples, this.queryOptions, this.optTrans, hashMap2, map, this.probFilterExists, n);
                arrayList.addAll(arrayList3);
                hashSet.addAll(clauseTreeNode.getNewBindings());
                hashSet2.addAll(clauseTreeNode.getFilterJoinVars());
                string2 = "";
                if (this.allOrdered) {
                    string2 = "/*+ ORDERED */";
                }
                if (this.hint0present) {
                    this.buildHint(sQLGenContext, true);
                    string2 = this.hintStr.toString();
                }
                string = "SELECT " + string2 + ((String)object).substring("SELECT".length(), ((String)object).length());
            } else {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                arrayList3 = new ArrayList();
                arrayList3.addAll(clauseTreeNode2.getFilterJoinVars());
                object = null;
                if (clauseTreeNode2.type.equals("UNION")) {
                    bl2 = true;
                    object5 = "";
                    int n2 = clauseTreeNode2.getNumChildren();
                    object4 = null;
                    object3 = null;
                    object4 = this.buildLocalPIDsArray(clauseTreeNode2.varset.keySet(), nArray, sQLGenContext);
                    for (int i = 0; i < n2; ++i) {
                        object2 = clauseTreeNode2.getChild(i);
                        object3 = this.sparqlToSQL((ClauseTreeNode)object2, sQLGenContext, (int[])object4, map, set, i, clauseTreeNode2.varset.keySet(), clauseTreeNode2.getDummyVarsForLOJ(), true);
                        object5 = i == 0 ? (String)object5 + "(" + (String)object3 + ")\n" : (String)object5 + "UNION ALL\n(" + (String)object3 + ")\n";
                    }
                    object = object5 = "(" + (String)object5 + ")\n";
                } else {
                    hashMap2 = this.buildFilterAliasMap(sQLGenContext, nArray, clauseTreeNode2, false, false);
                    object = clauseTreeNode2.bgpToSQL(bl3, arrayList3, sQLGenContext, nArray, this.vmViewName, this.sparqlNoUseWith, this.sparqlUseExact, this.basicTriples, this.queryOptions, this.optTrans, hashMap2, map, this.probFilterExists, n);
                    string2 = "";
                    if (this.allOrdered) {
                        string2 = "/*+ ORDERED */";
                    }
                    object = "SELECT " + string2 + ((String)object).substring("SELECT".length(), ((String)object).length());
                }
                hashSet.addAll(clauseTreeNode2.getNewBindings());
                hashSet2.addAll(clauseTreeNode2.getFilterJoinVars());
                arrayList.addAll(arrayList3);
                hashMap.putAll(clauseTreeNode2.varset);
                object5 = this.getAncestors(clauseTreeNode2);
                HashMap<String, String> hashMap3 = this.getPredecessors(clauseTreeNode2);
                object4 = this.buildLOJSelect(clauseTreeNode2, (HashMap<String, String>)object5, hashMap3, arrayList, sQLGenContext, nArray, hashSet2, bl2, treeSet, clauseTreeNode2.getDummyVarsForLOJ());
                object3 = this.constructCoalesceSet((HashMap<String, String>)object5, hashMap3, (HashMap)clauseTreeNode2.varset);
                String string3 = "";
                if (!((HashMap)object3).isEmpty()) {
                    string3 = this.constructCoalesce((HashMap<String, String>)object3, hashSet2);
                }
                object2 = this.constructFrom(string);
                String string4 = this.constructLOJ((String)object);
                String string5 = this.constructLOJcondition(clauseTreeNode2, (HashMap<String, String>)object5, sQLGenContext, nArray, map, hashSet, arrayList2, (HashMap<String, String>)object3, bl2);
                string = (String)object4 + string3 + (String)object2 + string4 + string5;
            }
            if (!clauseTreeNode2.type.equals("UNION")) {
                for (int i = clauseTreeNode2.children.size(); i > 0; --i) {
                    object = clauseTreeNode2.children.get(i - 1);
                    stack.push(object);
                }
            }
            treeSet.addAll(clauseTreeNode2.getDummyVarsForLOJ());
        }
        if (!arrayList2.isEmpty()) {
            string = this.wrapBadFilterCaseStmts(string, clauseTreeNode, sQLGenContext, nArray, hashSet, hashSet2, map, arrayList, arrayList2, treeSet);
        }
        if (!clauseTreeNode.getNonLocalFilters().isEmpty()) {
            hashMap2 = this.buildFilterAliasMap(sQLGenContext, nArray, clauseTreeNode, true, false);
            string = this.addOuterFilter(string, sQLGenContext, nArray, hashSet2, set3, arrayList, clauseTreeNode.getNonLocalFilters(), hashMap2, map, treeSet);
        }
        if (this.unionQuery) {
            string = this.addOuterSelect(string, sQLGenContext, nArray, set3, set, set2, n, treeSet, sortedSet);
        }
        if (this.withVec.size() > 0 && !this.useVM && !this.sparqlNoUseWith) {
            string = "WITH " + GenerateQuery.concatVec(this.withVec, ", ") + "\n" + string;
        }
        return string;
    }

    public int[] buildLocalPIDsArray(Collection<String> collection, int[] nArray, SQLGenContext sQLGenContext) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        for (String string : sQLGenContext.varMap.indexedNames) {
            bl = collection.contains(string);
            n3 = 8;
            for (int i = 0; i < n3; ++i) {
                if (nArray == null || n < nArray.length && n2 == nArray[n]) {
                    if (bl) {
                        arrayList.add(n2);
                    }
                    ++n;
                }
                ++n2;
            }
        }
        Object object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    public String constructLOJcondition(ClauseTreeNode clauseTreeNode, HashMap<String, String> hashMap, SQLGenContext sQLGenContext, int[] nArray, Map<String, String> map, Set<String> set, List<Filter> list, HashMap<String, String> hashMap2, boolean bl) throws RDFException {
        HashMap<String, String> hashMap3 = this.constructOnSet(hashMap, (HashMap)clauseTreeNode.varset);
        String string = "ON (";
        if (!hashMap3.isEmpty()) {
            string = this.constructOn(hashMap3, sQLGenContext, bl);
        }
        Map<String, String> map2 = this.buildFilterAliasMap(sQLGenContext, nArray, clauseTreeNode, false, true);
        String[] stringArray = new String[]{""};
        this.processNonLocalFilters(clauseTreeNode, map2, map, set, list, stringArray, sQLGenContext);
        this.processBadFilters(clauseTreeNode, map2, map, set, list, stringArray, sQLGenContext);
        if (stringArray[0].length() > 0) {
            string = QueryUtils.appendToList(string, stringArray[0], " AND\n ", "ON (");
        }
        if (clauseTreeNode.getParent().type.equalsIgnoreCase("Optional")) {
            string = QueryUtils.appendToList(string, clauseTreeNode.getParent().getDummyVarName() + " IS NOT NULL", " AND\n ", "ON (");
        }
        if (!hashMap2.isEmpty()) {
            string = QueryUtils.appendToList(string, this.constructAnd(hashMap2), " AND\n ", "ON (");
        }
        if (string.equals("ON (")) {
            string = string + "1=1";
        }
        string = string + ")";
        return string;
    }

    public String buildLOJSelect(ClauseTreeNode clauseTreeNode, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, List<String> list, SQLGenContext sQLGenContext, int[] nArray, Set<String> set, boolean bl, SortedSet<String> sortedSet, SortedSet<String> sortedSet2) {
        HashMap<String, String> hashMap3 = this.constructSelectSet1(hashMap, hashMap2, (HashMap)clauseTreeNode.varset);
        HashMap<String, String> hashMap4 = this.constructSelectSet2((HashMap)clauseTreeNode.varset, hashMap2);
        HashMap<String, String> hashMap5 = this.constructSelectSet(hashMap3, hashMap4);
        String string = this.constructSelect(hashMap3, hashMap4, list, sQLGenContext, nArray, set, bl, sortedSet, sortedSet2);
        return string;
    }

    public String wrapBadFilterCaseStmts(String string, ClauseTreeNode clauseTreeNode, SQLGenContext sQLGenContext, int[] nArray, Set<String> set, Set<String> set2, Map<String, String> map, List<String> list, List<Filter> list2, SortedSet<String> sortedSet) throws RDFException {
        SortedSet<Integer> sortedSet2 = this.extractPushUpLevels(list2);
        Map<String, List<Filter>> map2 = this.buildFilterDepMap(list2);
        Map<String, String> map3 = this.buildFilterAliasMap(sQLGenContext, nArray, clauseTreeNode, true, false);
        for (Integer n : sortedSet2) {
            string = this.addBadFilterCaseStmts(string, sQLGenContext, nArray, set, set2, map2, map3, map, list, n, sortedSet);
            string = this.addNestingForOptFilter(string, sQLGenContext, nArray, set, set2, list, sortedSet);
        }
        return string;
    }

    public Set<String> extractClauseTreeVars(ClauseTreeNode clauseTreeNode) {
        HashSet<String> hashSet = new HashSet<String>();
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        stack.push(clauseTreeNode);
        while (!stack.isEmpty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            hashSet.addAll(clauseTreeNode2.varset.keySet());
            for (int i = clauseTreeNode2.children.size(); i > 0; --i) {
                ClauseTreeNode clauseTreeNode3 = clauseTreeNode2.children.get(i - 1);
                stack.push(clauseTreeNode3);
            }
        }
        return hashSet;
    }

    public Set<String> extractAllRootVars(List<ClauseTreeNode> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ClauseTreeNode clauseTreeNode : list) {
            hashSet.addAll(this.extractRootVars(clauseTreeNode));
        }
        return hashSet;
    }

    public Set<String> extractRootVars(ClauseTreeNode clauseTreeNode) {
        HashSet<String> hashSet = new HashSet<String>();
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        stack.push(clauseTreeNode);
        boolean bl = false;
        while (!stack.isEmpty() && !bl) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            if (clauseTreeNode2.label.equalsIgnoreCase("Root")) {
                hashSet.addAll(clauseTreeNode2.varset.keySet());
                bl = true;
                continue;
            }
            for (int i = clauseTreeNode2.children.size(); i > 0; --i) {
                ClauseTreeNode clauseTreeNode3 = clauseTreeNode2.children.get(i - 1);
                stack.push(clauseTreeNode3);
            }
        }
        return hashSet;
    }

    public SortedSet<Integer> extractPushUpLevels(List<Filter> list) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Filter filter : list) {
            treeSet.add(new Integer(filter.getPushCnt()));
        }
        return treeSet;
    }

    public Map<String, List<Filter>> buildFilterDepMap(List<Filter> list) {
        HashMap<String, List<Filter>> hashMap = new HashMap<String, List<Filter>>();
        for (Filter filter : list) {
            filter.updateVarDependencyMap(hashMap);
        }
        return hashMap;
    }

    public void processBadFilters(ClauseTreeNode clauseTreeNode, Map<String, String> map, Map<String, String> map2, Set<String> set, List<Filter> list, String[] stringArray, SQLGenContext sQLGenContext) throws RDFException {
        for (Filter filter : list) {
            filter.incrementPushCnt();
            if (!filter.isValidForVars(set) || (filter.getSpecialCaseFlags() & 2) > 0 || filter.getPushedToJoin()) continue;
            stringArray[0] = QueryUtils.appendToList(stringArray[0], filter.toSQL(map, map2, sQLGenContext.funcHandMap), " AND\n ", "");
            filter.setPushedToJoin(true);
        }
    }

    public void processNonLocalFilters(ClauseTreeNode clauseTreeNode, Map<String, String> map, Map<String, String> map2, Set<String> set, List<Filter> list, String[] stringArray, SQLGenContext sQLGenContext) throws RDFException {
        for (Filter filter : clauseTreeNode.getFilters()) {
            if ((filter.getSpecialCaseFlags() & 1) > 0) continue;
            boolean bl = false;
            for (String string : filter.getVars()) {
                if (set.contains(string)) continue;
                bl = true;
            }
            if (bl) {
                list.add(filter);
                if (!this.relaxFilter) continue;
                QueryUtils.log("Allowing forward referencing FILTER:\n" + filter.toString());
                continue;
            }
            filter.setSQLGenCtx(sQLGenContext);
            stringArray[0] = QueryUtils.appendToList(stringArray[0], filter.toSQL(map, map2, sQLGenContext.funcHandMap), " AND\n ", "");
        }
    }

    public String addBadFilterCaseStmts(String string, SQLGenContext sQLGenContext, int[] nArray, Set<String> set, Set<String> set2, Map<String, List<Filter>> map, Map<String, String> map2, Map<String, String> map3, List<String> list, int n, SortedSet<String> sortedSet) throws RDFException {
        String string2 = string;
        boolean bl = false;
        String string3 = "SELECT \n";
        String string4 = "FROM (" + string + ") R \n";
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        String string52 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string6 : sortedSet) {
            string3 = QueryUtils.appendToList(string3, "R." + string6 + " AS " + string6, ", ", "SELECT \n");
        }
        for (String string52 : sQLGenContext.varMap.indexedNames) {
            String string7;
            String string6;
            if (set.contains(string52) && list.contains(string52)) {
                bl3 = true;
                bl2 = set2.contains(string52);
                string3 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "R." + string52 + " AS " + string52, ", ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                string6 = this.constructCaseCondition(string52, map, map2, map3, n, sQLGenContext);
                string7 = "";
                string7 = string6.length() > 0 ? "(CASE WHEN (" + string6 + ") THEN R." + string52 + "$RDFVID" + " ELSE NULL END)" : "R." + string52 + "$RDFVID";
                boolean bl4 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3);
                string3 = QueryUtils.appendToList(string3, string7 + " AS " + string52 + "$RDFVID", ", ", "SELECT \n");
                string3 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "R." + string52 + "$_PREFIX" + " AS " + string52 + "$_PREFIX", ",\n ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                string3 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "R." + string52 + "$_SUFFIX" + " AS " + string52 + "$_SUFFIX", ",\n ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                string3 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "R." + string52 + "$RDFVTYP" + " AS " + string52 + "$RDFVTYP", ",\n ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                if (!bl3 && !bl2) continue;
                QueryUtils.selectNeeded(bl3, false, true, nArray, nArray2, nArray3);
                string3 = QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "R." + string52 + "$RDFLTYP" + " AS " + string52 + "$RDFLTYP", ",\n ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                if (QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3)) {
                    string3 = QueryUtils.appendToList(string3, "R." + string52 + "$RDFLANG" + " AS " + string52 + "$RDFLANG", ",\n ", "SELECT \n");
                    continue;
                }
                string3 = QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                continue;
            }
            if (set.contains(string52)) {
                string6 = this.constructCaseCondition(string52, map, map2, map3, n, sQLGenContext);
                string7 = "";
                string7 = string6.length() > 0 ? "(CASE WHEN (" + string6 + ") THEN R." + string52 + "$RDFVID" + " ELSE NULL END)" : "R." + string52 + "$RDFVID";
                string3 = QueryUtils.appendToList(string3, string7 + " AS " + string52 + "$RDFVID", ", ", "SELECT \n");
            }
            nArray3[0] = nArray3[0] + 8;
            nArray2[0] = this.incrementJ(nArray2[0], nArray3[0], nArray);
        }
        if ((sQLGenContext.contextFlags & 3) > 0) {
            string3 = QueryUtils.appendToList(string3, "R.T0_CTXT2 as T0_CTXT2", ", ", "SELECT \n");
        }
        if (this.probFilterExists) {
            string3 = QueryUtils.appendToList(string3, "R.RDF$L AS RDF$L", ", ", "SELECT \n");
        }
        string2 = string3 + "\n" + string4;
        return string2;
    }

    public String addNestingForOptFilter(String string, SQLGenContext sQLGenContext, int[] nArray, Set<String> set, Set<String> set2, List<String> list, SortedSet<String> sortedSet) {
        String string2 = string;
        boolean bl = false;
        String string3 = "SELECT \n";
        String string4 = "FROM (" + string + ") R \n";
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        String string52 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string6 : sortedSet) {
            string3 = QueryUtils.appendToList(string3, "R." + string6 + " AS " + string6, ", ", "SELECT \n");
        }
        for (String string52 : sQLGenContext.varMap.indexedNames) {
            if (set.contains(string52) && list.contains(string52)) {
                bl3 = true;
                bl2 = set2.contains(string52);
                string3 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "NVL2(R." + string52 + "$RDFVID" + ", R." + string52 + ", NULL) AS " + string52, ", ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                boolean bl4 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3);
                string3 = QueryUtils.appendToList(string3, "R." + string52 + "$RDFVID" + " AS " + string52 + "$RDFVID", ", ", "SELECT \n");
                string3 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "NVL2(R." + string52 + "$RDFVID" + ", R." + string52 + "$_PREFIX" + ", NULL) AS " + string52 + "$_PREFIX", ", ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                string3 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "NVL2(R." + string52 + "$RDFVID" + ", R." + string52 + "$_SUFFIX" + ", NULL) AS " + string52 + "$_SUFFIX", ", ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                string3 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "NVL2(R." + string52 + "$RDFVID" + ", R." + string52 + "$RDFVTYP" + ", NULL) AS " + string52 + "$RDFVTYP", ", ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                if (!bl3 && !bl2) continue;
                QueryUtils.selectNeeded(bl3, false, true, nArray, nArray2, nArray3);
                string3 = QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string3, "NVL2(R." + string52 + "$RDFVID" + ", R." + string52 + "$RDFLTYP" + ", NULL) AS " + string52 + "$RDFLTYP", ", ", "SELECT \n") : QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                if (QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3)) {
                    string3 = QueryUtils.appendToList(string3, "NVL2(R." + string52 + "$RDFVID" + ", R." + string52 + "$RDFLANG" + ", NULL) AS " + string52 + "$RDFLANG", ", ", "SELECT \n");
                    continue;
                }
                string3 = QueryUtils.appendToList(string3, "null", ", ", "SELECT \n");
                continue;
            }
            if (set.contains(string52)) {
                string3 = QueryUtils.appendToList(string3, "R." + string52 + "$RDFVID" + " AS " + string52 + "$RDFVID", ", ", "SELECT \n");
            }
            nArray3[0] = nArray3[0] + 8;
            nArray2[0] = this.incrementJ(nArray2[0], nArray3[0], nArray);
        }
        if ((sQLGenContext.contextFlags & 3) > 0) {
            string3 = QueryUtils.appendToList(string3, "R.T0_CTXT2 as T0_CTXT2", ", ", "SELECT \n");
        }
        if (this.probFilterExists) {
            string3 = QueryUtils.appendToList(string3, "R.RDF$L AS RDF$L", ", ", "SELECT \n");
        }
        string2 = string3 + "\n" + string4;
        return string2;
    }

    public String constructCaseCondition(String string, Map<String, List<Filter>> map, Map<String, String> map2, Map<String, String> map3, int n, SQLGenContext sQLGenContext) throws RDFException {
        String string2 = "";
        List<Filter> list = map.get(string);
        if (list != null) {
            for (Filter filter : list) {
                if (filter.getPushCnt() != n) continue;
                filter.setSQLGenCtx(sQLGenContext);
                string2 = QueryUtils.appendToList(string2, filter.toSQL(map2, map3, sQLGenContext.funcHandMap), " AND ", "");
            }
        }
        return string2;
    }

    public String addOuterFilter(String string, SQLGenContext sQLGenContext, int[] nArray, Set<String> set, Set<String> set2, List<String> list, List<Filter> list2, Map<String, String> map, Map<String, String> map2, SortedSet<String> sortedSet) throws RDFException {
        String string2 = "SELECT ";
        String string3 = "FROM (" + string + ") R ";
        String string4 = "WHERE \n";
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        boolean bl = false;
        boolean bl2 = false;
        for (String object : sortedSet) {
            string2 = QueryUtils.appendToList(string2, "R." + object + " AS " + object, ", ", "SELECT ");
        }
        for (String string5 : sQLGenContext.varMap.indexedNames) {
            bl = set.contains(string5);
            bl2 = true;
            if (set2.contains(string5)) {
                if (list.contains(string5)) {
                    string2 = QueryUtils.selectNeeded(bl2, bl, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string2, "R." + string5 + " AS " + string5, ", ", "SELECT ") : string2 + "";
                    boolean bl3 = QueryUtils.selectNeeded(bl2, bl, false, nArray, nArray2, nArray3);
                    string2 = QueryUtils.appendToList(string2, "R." + string5 + "$RDFVID" + " AS " + string5 + "$RDFVID", ", ", "SELECT ");
                    string2 = QueryUtils.selectNeeded(bl2, bl, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string2, "R." + string5 + "$_PREFIX" + " AS " + string5 + "$_PREFIX", ", ", "SELECT ") : string2 + "";
                    string2 = QueryUtils.selectNeeded(bl2, bl, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string2, "R." + string5 + "$_SUFFIX" + " AS " + string5 + "$_SUFFIX", ", ", "SELECT ") : string2 + "";
                    string2 = QueryUtils.selectNeeded(bl2, bl, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string2, "R." + string5 + "$RDFVTYP" + " AS " + string5 + "$RDFVTYP", ", ", "SELECT ") : string2 + "";
                    if (!bl2 && !bl) continue;
                    QueryUtils.selectNeeded(bl2, false, true, nArray, nArray2, nArray3);
                    string2 = QueryUtils.selectNeeded(bl2, bl, true, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string2, "R." + string5 + "$RDFLTYP" + " AS " + string5 + "$RDFLTYP", ", ", "SELECT ") : string2 + "";
                    if (QueryUtils.selectNeeded(bl2, bl, true, nArray, nArray2, nArray3)) {
                        string2 = QueryUtils.appendToList(string2, "R." + string5 + "$RDFLANG" + " AS " + string5 + "$RDFLANG", ", ", "SELECT ");
                        continue;
                    }
                    string2 = string2 + "";
                    continue;
                }
                string2 = QueryUtils.appendToList(string2, "R." + string5 + "$RDFVID" + " AS " + string5 + "$RDFVID", ", ", "SELECT ");
                nArray3[0] = nArray3[0] + 8;
                nArray2[0] = this.incrementJ(nArray2[0], nArray3[0], nArray);
                continue;
            }
            nArray3[0] = nArray3[0] + 8;
            nArray2[0] = this.incrementJ(nArray2[0], nArray3[0], nArray);
        }
        if ((sQLGenContext.contextFlags & 3) > 0) {
            string2 = QueryUtils.appendToList(string2, "R.T0_CTXT2 as T0_CTXT2", ", ", "SELECT ");
        }
        if (this.probFilterExists) {
            string2 = QueryUtils.appendToList(string2, "R.RDF$L AS RDF$L", ", ", "SELECT ");
        }
        for (Filter filter : list2) {
            filter.setSQLGenCtx(sQLGenContext);
            string4 = QueryUtils.appendToList(string4, filter.toSQL(map, map2, sQLGenContext.funcHandMap), " AND ", "WHERE \n");
        }
        return string2 + "\n" + string3 + "\n" + string4;
    }

    public String buildOuterSelectElem(String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, String string4, String string5) {
        String string6 = string;
        if (bl3 && bl) {
            string6 = bl2 ? QueryUtils.appendToList(string, string2 + string3, string4, string5) : QueryUtils.appendToList(string, "null " + string3, string4, string5);
        }
        return string6;
    }

    public String addOuterSelect(String string, SQLGenContext sQLGenContext, int[] nArray, Set<String> set, Set<String> set2, Set<String> set3, int n, SortedSet<String> sortedSet, SortedSet<String> sortedSet2) {
        boolean bl;
        String string2 = string;
        String string3 = "SELECT \n";
        String string4 = "FROM (" + string + ") R \n";
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = bl = set3 != null;
        if (sortedSet2 != null) {
            for (String string5 : sortedSet2) {
                if (sortedSet.contains(string5)) {
                    string3 = QueryUtils.appendToList(string3, "R." + string5 + " AS " + string5, ", ", "SELECT \n");
                    continue;
                }
                string3 = QueryUtils.appendToList(string3, "NULL AS " + string5, ", ", "SELECT \n");
            }
        }
        for (String string5 : sQLGenContext.varMap.indexedNames) {
            bl2 = set2.contains(string5);
            bl3 = set.contains(string5);
            bl4 = true;
            bl5 = false;
            if (set3 == null || set3.contains(string5)) {
                bl5 = true;
            }
            if (QueryUtils.selectNeeded(bl4, bl2 && bl, false, nArray, nArray2, nArray3)) {
                string3 = this.buildOuterSelectElem(string3, bl2, bl3, bl5, "R." + string5, " AS " + string5, ", ", "SELECT \n");
            }
            string3 = this.buildOuterSelectElem(string3, true, bl3, bl5, "R." + string5 + "$RDFVID", " AS " + string5 + "$RDFVID", ", ", "SELECT \n");
            QueryUtils.selectNeeded(bl4, bl2 && bl, false, nArray, nArray2, nArray3);
            if (QueryUtils.selectNeeded(bl4, bl2 && bl, false, nArray, nArray2, nArray3)) {
                string3 = this.buildOuterSelectElem(string3, bl2, bl3, bl5, "R." + string5 + "$_PREFIX", " AS " + string5 + "$_PREFIX", ", ", "SELECT \n");
            }
            if (QueryUtils.selectNeeded(bl4, bl2 && bl, false, nArray, nArray2, nArray3)) {
                string3 = this.buildOuterSelectElem(string3, bl2, bl3, bl5, "R." + string5 + "$_SUFFIX", " AS " + string5 + "$_SUFFIX", ", ", "SELECT \n");
            }
            if (QueryUtils.selectNeeded(bl4, bl2 && bl, false, nArray, nArray2, nArray3)) {
                string3 = this.buildOuterSelectElem(string3, bl2, bl3, bl5, "R." + string5 + "$RDFVTYP", " AS " + string5 + "$RDFVTYP", ", ", "SELECT \n");
            }
            if (!bl4) continue;
            QueryUtils.selectNeeded(bl4, bl2 && bl, true, nArray, nArray2, nArray3);
            if (QueryUtils.selectNeeded(bl4, bl2 && bl, true, nArray, nArray2, nArray3)) {
                string3 = this.buildOuterSelectElem(string3, bl2, bl3, bl5, "R." + string5 + "$RDFLTYP", " AS " + string5 + "$RDFLTYP", ", ", "SELECT \n");
            }
            if (!QueryUtils.selectNeeded(bl4, bl2 && bl, true, nArray, nArray2, nArray3)) continue;
            string3 = this.buildOuterSelectElem(string3, bl2, bl3, bl5, "R." + string5 + "$RDFLANG", " AS " + string5 + "$RDFLANG", ", ", "SELECT \n");
        }
        if ((sQLGenContext.contextFlags & 3) > 0) {
            string3 = QueryUtils.appendToList(string3, "R.T0_CTXT2 as T0_CTXT2", ", ", "SELECT \n");
        }
        if (this.probFilterExists && this.unionQuery) {
            string3 = QueryUtils.appendToList(string3, "R.RDF$L AS RDF$L", ", ", "SELECT \n");
        }
        if (string3.equalsIgnoreCase("SELECT \n")) {
            string3 = string3 + "NULL ";
        }
        string2 = string3 + "\n" + string4;
        return string2;
    }

    public String performJoinWithValuesOptimized(String string, Set<String> set, Set<String> set2, SQLGenContext sQLGenContext, int[] nArray) {
        String string2 = string;
        int n = 0;
        if (this.m_bLog) {
            QueryUtils.log("Number of non-null columns " + nArray.length + "\n");
        }
        String string3 = "/*+ " + TranslateEngine.DEFAULT_Q_HINT + " */";
        String string4 = "";
        String string5 = "WHERE \n";
        if (this.hint0present && !this.noPushVal || this.disableNoMerge || (sQLGenContext.contextFlags & 8) > 0 && !this.enableNoMerge) {
            string3 = "";
        }
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        boolean bl = false;
        boolean bl2 = false;
        for (String string6 : sQLGenContext.varMap.indexedNames) {
            String string7;
            boolean bl3 = false;
            bl2 = true;
            if (!set.contains(string6)) {
                string7 = "V" + n;
                String string8 = " (CASE WHEN " + string7 + ".VALUE_TYPE IS NULL THEN NULL WHEN " + string7 + ".VALUE_TYPE = 'UR' THEN '" + "URI" + "'  WHEN " + string7 + ".VALUE_TYPE = 'BN' THEN '" + "BLN" + "'  ELSE '" + "LIT" + "' END) ";
                if (QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3)) {
                    string4 = QueryUtils.appendToList(string4, string7 + ".VNAME_PREFIX || " + string7 + ".VNAME_SUFFIX AS " + string6, ",\n ", "");
                    bl3 = true;
                } else {
                    string4 = QueryUtils.appendToList(string4, "null", ", ", "");
                }
                string4 = QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3) || this.probFilterExists ? QueryUtils.appendToList(string4, "R." + string6 + "$RDFVID" + " AS " + string6 + "$RDFVID", ",\n ", "") : QueryUtils.appendToList(string4, "null", ", ", "");
                if (QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3)) {
                    string4 = QueryUtils.appendToList(string4, string7 + ".VNAME_PREFIX AS " + string6 + "$_PREFIX", ",\n ", "");
                    bl3 = true;
                } else {
                    string4 = QueryUtils.appendToList(string4, "null", ", ", "");
                }
                if (QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3)) {
                    string4 = QueryUtils.appendToList(string4, string7 + ".VNAME_SUFFIX AS " + string6 + "$_SUFFIX", ",\n ", "");
                    bl3 = true;
                } else {
                    string4 = QueryUtils.appendToList(string4, "null", ", ", "");
                }
                if (QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3)) {
                    string4 = QueryUtils.appendToList(string4, string8 + " AS " + string6 + "$RDFVTYP", ",\n ", "");
                    bl3 = true;
                } else {
                    string4 = QueryUtils.appendToList(string4, "null", ", ", "");
                }
                if (bl2) {
                    if (QueryUtils.selectNeeded(bl2, false, true, nArray, nArray2, nArray3)) {
                        string4 = QueryUtils.appendToList(string4, string7 + ".LONG_VALUE AS " + string6 + "$RDFCLOB", ",\n ", "");
                        bl3 = true;
                    } else {
                        string4 = QueryUtils.appendToList(string4, "null", ", ", "");
                    }
                    if (QueryUtils.selectNeeded(bl2, false, true, nArray, nArray2, nArray3)) {
                        string4 = QueryUtils.appendToList(string4, string7 + ".LITERAL_TYPE AS " + string6 + "$RDFLTYP", ",\n ", "");
                        bl3 = true;
                    } else {
                        string4 = QueryUtils.appendToList(string4, "null", ", ", "");
                    }
                    if (QueryUtils.selectNeeded(bl2, false, true, nArray, nArray2, nArray3)) {
                        string4 = QueryUtils.appendToList(string4, string7 + ".LANGUAGE_TYPE AS " + string6 + "$RDFLANG", ",\n ", "");
                        bl3 = true;
                    } else {
                        string4 = QueryUtils.appendToList(string4, "null", ", ", "");
                    }
                }
                if (bl3) {
                    string5 = !this.unionQuery && set2.contains(string6) ? QueryUtils.appendToList(string5, "R." + string6 + "$RDFVID" + " = V" + n + ".VALUE_ID", " AND \n", "WHERE \n") : QueryUtils.appendToList(string5, "R." + string6 + "$RDFVID" + " = V" + n + ".VALUE_ID (+)", " AND \n", "WHERE \n");
                    ++n;
                }
            } else {
                string4 = QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string4, "R." + string6 + " AS " + string6, ", ", "") : QueryUtils.appendToList(string4, "null", ", ", "");
                string4 = QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3) || this.probFilterExists ? QueryUtils.appendToList(string4, "R." + string6 + "$RDFVID" + " AS " + string6 + "$RDFVID", ",\n ", "") : QueryUtils.appendToList(string4, "null", ", ", "");
                string4 = QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string4, "R." + string6 + "$_PREFIX" + " AS " + string6 + "$_PREFIX", ",\n ", "") : QueryUtils.appendToList(string4, "null", ", ", "");
                string4 = QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string4, "R." + string6 + "$_SUFFIX" + " AS " + string6 + "$_SUFFIX", ",\n ", "") : QueryUtils.appendToList(string4, "null", ", ", "");
                string4 = QueryUtils.selectNeeded(bl2, false, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string4, "R." + string6 + "$RDFVTYP" + " AS " + string6 + "$RDFVTYP", ",\n ", "") : QueryUtils.appendToList(string4, "null", ", ", "");
                if (bl2) {
                    if (QueryUtils.selectNeeded(bl2, false, true, nArray, nArray2, nArray3)) {
                        string7 = "(CASE WHEN R." + string6 + "$_PREFIX" + " LIKE 'ORALL%' THEN (SELECT /*+ INDEX(V " + "C_PK_VID" + ") */ V." + "LONG_VALUE" + " FROM " + MDSYS_RDFVTAB_N_SPACE + " V WHERE V." + "VALUE_ID" + "=R." + string6 + "$RDFVID" + ") ELSE NULL END)";
                        string4 = QueryUtils.appendToList(string4, string7 + " AS " + string6 + "$RDFCLOB", ",\n ", "");
                    } else {
                        string4 = QueryUtils.appendToList(string4, "null", ", ", "");
                    }
                    string4 = QueryUtils.selectNeeded(bl2, false, true, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string4, "R." + string6 + "$RDFLTYP" + " AS " + string6 + "$RDFLTYP", ",\n ", "") : QueryUtils.appendToList(string4, "null", ", ", "");
                    string4 = QueryUtils.selectNeeded(bl2, false, true, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string4, "R." + string6 + "$RDFLANG" + " AS " + string6 + "$RDFLANG", ",\n ", "") : QueryUtils.appendToList(string4, "null", ", ", "");
                }
            }
            string4 = string4 + "\n";
        }
        if ((sQLGenContext.contextFlags & 3) > 0) {
            string4 = QueryUtils.appendToList(string4, "R.T0_CTXT2 as T0_CTXT2 ", ", ", "");
        }
        if (this.probFilterExists && this.unionQuery && !this.relaxFilter) {
            string4 = QueryUtils.appendToList(string4, "R.RDF$L AS RDF$L", ", ", "");
            string4 = string4 + "\n";
        }
        if (string4.equalsIgnoreCase("")) {
            string4 = string4 + "NULL";
        }
        string4 = "SELECT " + string3 + " \n" + string4 + "\n";
        if (string5.equalsIgnoreCase("WHERE \n")) {
            string5 = "WHERE 1=1 \n";
        }
        Object object = "FROM (\n" + string + "\n) R";
        for (int i = 0; i < n; ++i) {
            object = (String)object + ", MDSYS.RDF_VALUE$ V" + i;
        }
        object = (String)object + "\n";
        string2 = string4 + (String)object + string5;
        return string2;
    }

    public String constructSelect(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, List<String> list, SQLGenContext sQLGenContext, int[] nArray, Set<String> set, boolean bl, Set<String> set2, Set<String> set3) {
        String string = "";
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string2 : set2) {
            string = QueryUtils.appendToList(string, "r1." + string2 + " AS " + string2, ", ", "");
        }
        for (String string2 : set3) {
            string = QueryUtils.appendToList(string, "r2." + string2 + " AS " + string2, ", ", "");
        }
        for (String string2 : sQLGenContext.varMap.indexedNames) {
            boolean bl4;
            bl2 = set.contains(string2);
            bl3 = true;
            if (hashMap.keySet().contains(string2)) {
                if (list.contains(string2)) {
                    string = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r1." + string2 + " AS " + string2, ", ", "") : string + "";
                    bl4 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3);
                    string = QueryUtils.appendToList(string, "r1." + string2 + "$RDFVID" + " AS " + string2 + "$RDFVID", ", ", "");
                    string = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r1." + string2 + "$_PREFIX" + " AS " + string2 + "$_PREFIX", ", ", "") : string + "";
                    string = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r1." + string2 + "$_SUFFIX" + " AS " + string2 + "$_SUFFIX", ", ", "") : string + "";
                    string = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r1." + string2 + "$RDFVTYP" + " AS " + string2 + "$RDFVTYP", ", ", "") : string + "";
                    if (bl3 || bl2) {
                        QueryUtils.selectNeeded(bl3, false, true, nArray, nArray2, nArray3);
                        string = QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r1." + string2 + "$RDFLTYP" + " AS " + string2 + "$RDFLTYP", ", ", "") : string + "";
                        string = QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r1." + string2 + "$RDFLANG" + " AS " + string2 + "$RDFLANG", ", ", "") : string + "";
                    }
                    string = string + "";
                } else {
                    string = QueryUtils.appendToList(string, "r1." + string2 + "$RDFVID" + " AS " + string2 + "$RDFVID", ", ", "");
                    nArray3[0] = nArray3[0] + 8;
                    nArray2[0] = this.incrementJ(nArray2[0], nArray3[0], nArray);
                }
            } else if (hashMap2.keySet().contains(string2)) {
                if (list.contains(string2)) {
                    string = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r2." + string2 + " AS " + string2, ", ", "") : string + "";
                    bl4 = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3);
                    string = QueryUtils.appendToList(string, "r2." + string2 + "$RDFVID" + " AS " + string2 + "$RDFVID", ", ", "");
                    string = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r2." + string2 + "$_PREFIX" + " AS " + string2 + "$_PREFIX", ", ", "") : string + "";
                    string = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r2." + string2 + "$_SUFFIX" + " AS " + string2 + "$_SUFFIX", ", ", "") : string + "";
                    string = QueryUtils.selectNeeded(bl3, bl2, false, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r2." + string2 + "$RDFVTYP" + " AS " + string2 + "$RDFVTYP", ", ", "") : string + "";
                    if (bl3 || bl2) {
                        QueryUtils.selectNeeded(bl3, false, true, nArray, nArray2, nArray3);
                        string = QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r2." + string2 + "$RDFLTYP" + " AS " + string2 + "$RDFLTYP", ", ", "") : string + "";
                        string = QueryUtils.selectNeeded(bl3, bl2, true, nArray, nArray2, nArray3) ? QueryUtils.appendToList(string, "r2." + string2 + "$RDFLANG" + " AS " + string2 + "$RDFLANG", ", ", "") : string + "";
                    }
                    string = string + "";
                } else {
                    string = QueryUtils.appendToList(string, "r2." + string2 + "$RDFVID" + " AS " + string2 + "$RDFVID", ", ", "");
                    nArray3[0] = nArray3[0] + 8;
                    nArray2[0] = this.incrementJ(nArray2[0], nArray3[0], nArray);
                }
            }
            if (hashMap2.containsKey(string2) || hashMap.containsKey(string2)) continue;
            nArray3[0] = nArray3[0] + 8;
            nArray2[0] = this.incrementJ(nArray2[0], nArray3[0], nArray);
        }
        if ((sQLGenContext.contextFlags & 1) > 0) {
            string = QueryUtils.appendToList(string, " r1.T0_CTXT2 as T0_CTXT2 ", ", ", "");
        } else if ((sQLGenContext.contextFlags & 2) > 0) {
            string = QueryUtils.appendToList(string, " nvl(r1.T0_CTXT2, r2.T0_CTXT2) as T0_CTXT2 ", ", ", "");
        }
        if (this.probFilterExists && bl) {
            string = QueryUtils.appendToList(string, "r1.RDF$L || '$' || r2.RDF$L AS RDF$L", ", ", "");
        } else if (this.probFilterExists && !bl) {
            string = QueryUtils.appendToList(string, "r1.RDF$L AS RDF$L", ", ", "");
        }
        Object object = "";
        if (this.allSwap) {
            object = (String)object + " SWAP_JOIN_INPUTS(r2)  USE_HASH(r1 r2) ";
        } else if (this.allBgpHash) {
            object = (String)object + " USE_HASH(r1 r2) ";
        } else if (this.allBgpNL) {
            object = (String)object + " USE_NL(r1 r2) ";
        }
        if (this.allNoMerge) {
            object = (String)object + " NO_MERGE(r1) NO_MERGE(r2) ";
        }
        if (((String)object).length() > 0) {
            object = "/*+" + (String)object + "*/";
        }
        string = "SELECT " + (String)object + " " + string + "\n";
        return string;
    }

    private int incrementJ(int n, int n2, int[] nArray) {
        int n3 = n;
        int n4 = n2 - 8;
        for (int i = n2 - 8; i < n2 && n3 < nArray.length; ++i) {
            if (nArray[n3] != i) continue;
            ++n3;
        }
        return n3;
    }

    public String constructCoalesce(HashMap<String, String> hashMap, Set<String> set) {
        String string = "";
        boolean bl = false;
        for (String string2 : hashMap.keySet()) {
            bl = set.contains(string2);
            string = string + ", COALESCE (r1." + string2 + "$RDFVID" + ", r2." + string2 + "$RDFVID" + ") AS " + string2 + "$RDFVID" + " \n";
            if (!bl) continue;
            string = string + ", COALESCE (r1." + string2 + ", r2." + string2 + ") AS " + string2 + " \n";
            string = string + ", COALESCE (r1." + string2 + "$_PREFIX" + ", r2." + string2 + "$_PREFIX" + ") AS " + string2 + "$_PREFIX" + " \n";
            string = string + ", COALESCE (r1." + string2 + "$_SUFFIX" + ", r2." + string2 + "$_SUFFIX" + ") AS " + string2 + "$_SUFFIX" + " \n";
            string = string + ", COALESCE (r1." + string2 + "$RDFVTYP" + ", r2." + string2 + "$RDFVTYP" + ") AS " + string2 + "$RDFVTYP" + " \n";
            string = string + ", COALESCE (r1." + string2 + "$RDFLTYP" + ", r2." + string2 + "$RDFLTYP" + ") AS " + string2 + "$RDFLTYP" + " \n";
            string = string + ", COALESCE (r1." + string2 + "$RDFLANG" + ", r2." + string2 + "$RDFLANG" + ") AS " + string2 + "$RDFLANG" + " \n";
        }
        return string;
    }

    public String constructFrom(String string) {
        String string2 = "FROM ";
        return string2 + "(\n" + string + ") r1 \n";
    }

    public String constructLOJ(String string) {
        String string2 = "LEFT OUTER JOIN \n";
        string2 = string2 + "(\n" + string + "\n) r2 \n";
        return string2;
    }

    public String constructOn(HashMap<String, String> hashMap, SQLGenContext sQLGenContext, boolean bl) {
        String string = "ON (";
        for (String string2 : hashMap.keySet()) {
            String string3 = "(r1." + string2 + "$RDFVID" + "= r2." + string2 + "$RDFVID";
            if (bl) {
                string3 = string3 + " OR r2." + string2 + "$RDFVID" + " IS NULL";
            }
            string3 = string3 + ")";
            string = QueryUtils.appendToList(string, string3, " AND\n ", "ON (");
        }
        if ((sQLGenContext.contextFlags & 1) > 0) {
            string = QueryUtils.appendToList(string, "(r1.T0_CTXT2 = r2.T0_CTXT2)", " AND ", "ON (");
        } else if ((sQLGenContext.contextFlags & 2) > 0) {
            string = QueryUtils.appendToList(string, "(coalesce(r1.T0_CTXT2,r2.T0_CTXT2,'RDFCTX$NULLCTX') = coalesce(r2.T0_CTXT2,r1.T0_CTXT2,'RDFCTX$NULLCTX'))", " AND ", "ON (");
        }
        return string;
    }

    public String constructAnd1(HashMap<String, String> hashMap) {
        String string = "";
        for (String string2 : hashMap.keySet()) {
            string = string + " AND (r1." + string2 + "$RDFVID" + " IS NOT NULL)";
        }
        return string;
    }

    public String constructAnd(HashMap<String, String> hashMap) {
        String string = "";
        for (String string2 : hashMap.keySet()) {
            string = QueryUtils.appendToList(string, "(r1." + string2 + "$RDFVID" + "= r2." + string2 + "$RDFVID" + " OR r1." + string2 + "$RDFVID" + " IS NULL OR r2." + string2 + "$RDFVID" + " IS NULL)", " AND\n ", "");
        }
        return string;
    }

    public HashMap<String, String> getAncestors(ClauseTreeNode clauseTreeNode) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (!clauseTreeNode.label.equalsIgnoreCase("Root")) {
            if (clauseTreeNode.getParent().bgp != null) {
                hashMap.putAll(clauseTreeNode.getParentVariables());
            }
            clauseTreeNode = clauseTreeNode.getParent();
        }
        return hashMap;
    }

    public HashMap<String, String> getPredecessors(ClauseTreeNode clauseTreeNode) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Stack<ClauseTreeNode> stack = new Stack<ClauseTreeNode>();
        if (!clauseTreeNode.label.equalsIgnoreCase("Root")) {
            stack.push(clauseTreeNode.getParent());
        }
        while (!stack.isEmpty()) {
            ClauseTreeNode clauseTreeNode2 = (ClauseTreeNode)stack.pop();
            if (clauseTreeNode2.bgp != null) {
                hashMap.putAll(clauseTreeNode2.varset);
            }
            for (ClauseTreeNode clauseTreeNode3 : clauseTreeNode2.children) {
                if (clauseTreeNode3.equals(clauseTreeNode)) break;
                stack.push(clauseTreeNode3);
            }
            clauseTreeNode = clauseTreeNode2;
            if (clauseTreeNode.label.equalsIgnoreCase("Root")) continue;
            stack.push(clauseTreeNode.getParent());
        }
        return hashMap;
    }

    public HashMap<String, String> constructSelectSet(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        hashMap3.putAll(hashMap);
        hashMap3.putAll(hashMap2);
        return hashMap3;
    }

    public HashMap<String, String> constructSelectSet1(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3) {
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        if (hashMap != null) {
            hashMap4.putAll(hashMap);
        }
        HashMap<String, String> hashMap5 = this.constructSelectSet2(hashMap2, hashMap3);
        hashMap4.putAll(hashMap5);
        return hashMap4;
    }

    public HashMap<String, String> constructSelectSet2(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        if (hashMap != null) {
            for (String string : hashMap.keySet()) {
                if (hashMap2.containsKey(string)) continue;
                hashMap3.put(string, hashMap.get(string));
            }
        }
        return hashMap3;
    }

    public HashMap<String, String> constructCoalesceSet(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3) {
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        HashMap<String, String> hashMap5 = this.constructSelectSet2(hashMap2, hashMap);
        for (String string : hashMap3.keySet()) {
            if (!hashMap5.containsKey(string)) continue;
            hashMap4.put(string, hashMap3.get(string));
        }
        return hashMap4;
    }

    public HashMap<String, String> constructOnSet(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        for (String string : hashMap2.keySet()) {
            if (!hashMap.containsKey(string)) continue;
            hashMap3.put(string, hashMap2.get(string));
        }
        return hashMap3;
    }

    public HashMap<String, String> constructAndSet(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        HashMap<String, String> hashMap3 = new HashMap();
        hashMap3 = this.constructSelectSet2(hashMap, hashMap2);
        return hashMap3;
    }

    private class CoveringTreeNode {
        public String key;
        public List<String> varList;
        List<CoveringTreeNode> children;

        public CoveringTreeNode(String string) {
            this.key = string;
            this.varList = new ArrayList<String>();
            this.children = new ArrayList<CoveringTreeNode>();
        }
    }
}

