/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.parser.ttl.ParseException;
import oracle.spatial.rdf.server.parser.ttl.QuadHandler;
import oracle.sql.CLOB;

public class InsertTTLHandler
implements QuadHandler {
    private String modelOwner;
    private String modelName;
    private String tableName;
    private String columnName;
    private String destGraph;
    private static Connection sConn;
    private Connection conn;
    private PreparedStatement ps;
    private List<Clob> clobs = null;
    private static final int DEFAULT_BATCH_SIZE = 500;
    private int quadsInBatch;
    private String options;
    private boolean debug;
    private static final String DEBUG_FLAG = "DEBUG=T";
    private static DateFormat dateFormat;

    public InsertTTLHandler(String string, String string2, String string3, String string4, String string5, Connection connection, String string6) throws SQLException {
        this.modelOwner = string;
        this.modelName = string2;
        this.tableName = string3;
        this.columnName = string4;
        this.destGraph = string5;
        this.conn = connection == null ? this.getConnection() : connection;
        this.options = string6;
    }

    @Override
    public void init() throws ParseException {
        try {
            this.setOptions();
            String string = QueryUtils.enquoteNameSQLName(this.modelOwner);
            String string2 = QueryUtils.enquoteNameSQLName(this.tableName);
            String string3 = QueryUtils.enquoteNameSQLName(this.columnName);
            String string4 = "INSERT INTO " + string + "." + string2 + "(" + string3 + ") VALUES (sdo_rdf_triple_s(?,?,?,?))";
            InsertTTLHandler.log("Insert statement:\n" + string4, this.debug);
            this.ps = this.conn.prepareStatement(string4);
            this.quadsInBatch = 0;
            this.clobs = new ArrayList<Clob>();
        }
        catch (SQLException sQLException) {
            throw new ParseException("Exception initializing quad handler:" + sQLException.getMessage());
        }
    }

    @Override
    public void processQuad(String string, String string2, String string3, String string4) throws ParseException {
        try {
            String string5 = this.modelName;
            if (this.destGraph != null) {
                string5 = string5 + ":" + this.destGraph;
            } else if (string4 != null) {
                string5 = string5 + ":" + string4;
            }
            InsertTTLHandler.log("Adding quad to batch:[" + string5 + "," + string + "," + string2 + "," + string3 + "]", this.debug);
            this.ps.setString(1, string5);
            this.ps.setString(2, string);
            this.ps.setString(3, string2);
            if (string3.length() <= 4000) {
                this.ps.setString(4, string3);
            } else {
                CLOB cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)false, (int)10);
                cLOB.setString(1L, string3);
                this.ps.setClob(4, (Clob)cLOB);
                this.clobs.add((Clob)cLOB);
            }
            this.ps.addBatch();
            ++this.quadsInBatch;
            if (this.quadsInBatch == 500) {
                this.executeAndClean();
            }
        }
        catch (SQLException sQLException) {
            this.closePreparedStatement();
            throw new ParseException("Exception processing quad:" + sQLException.getMessage());
        }
    }

    @Override
    public void commit() throws ParseException {
        try {
            if (this.quadsInBatch > 0) {
                this.executeAndClean();
            }
            InsertTTLHandler.log("Committing inserts", this.debug);
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            throw new ParseException("Exception during commit:" + sQLException.getMessage());
        }
        finally {
            this.closePreparedStatement();
        }
    }

    private void setOptions() {
        String[] stringArray = new String[]{""};
        if (this.options != null) {
            stringArray[0] = this.options.toUpperCase();
        }
        this.debug = false;
        if (stringArray[0].contains(DEBUG_FLAG)) {
            this.debug = true;
        }
    }

    private Connection getConnection() throws SQLException {
        if (sConn == null) {
            sConn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
        return sConn;
    }

    private void executeAndClean() throws SQLException {
        try {
            InsertTTLHandler.log("Executing batch of size " + this.quadsInBatch, this.debug);
            this.ps.executeBatch();
        }
        finally {
            this.quadsInBatch = 0;
            this.cleanupClobs();
        }
    }

    private void cleanupClobs() {
        if (this.clobs != null) {
            for (Clob clob : this.clobs) {
                try {
                    if (clob == null) continue;
                    clob.free();
                }
                catch (SQLException sQLException) {
                    InsertTTLHandler.log("Exception found cleaning clob:" + sQLException.getMessage(), this.debug);
                }
            }
            this.clobs.clear();
        }
    }

    private void closePreparedStatement() {
        try {
            if (this.ps != null) {
                this.ps.close();
            }
        }
        catch (SQLException sQLException) {
            InsertTTLHandler.log("Exception found closing prepared statement:" + sQLException.getMessage(), this.debug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String string, boolean bl) {
        if (bl) {
            String string2;
            DateFormat dateFormat = InsertTTLHandler.dateFormat;
            synchronized (dateFormat) {
                string2 = InsertTTLHandler.dateFormat.format(Calendar.getInstance().getTime());
            }
            QueryUtils.log("LOAD_TTL [" + string2 + "]: " + string + "\n");
        }
    }

    static {
        dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    }
}

