/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.spatial.rdf.server.OracleDatabaseVersion;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.sql.CLOB;

public class LiteralSet
implements Cloneable {
    private HashMap set = new HashMap();
    private HashMap setExact = new HashMap();

    public void clear() {
        this.set.clear();
        this.setExact.clear();
    }

    public void put(ASTTripleAtom aSTTripleAtom) {
        if (aSTTripleAtom.type == 2) {
            aSTTripleAtom.litType = aSTTripleAtom.name.toUpperCase().contains("E") ? "http://www.w3.org/2001/XMLSchema#double" : (aSTTripleAtom.name.contains(".") ? "http://www.w3.org/2001/XMLSchema#decimal" : "http://www.w3.org/2001/XMLSchema#integer");
        }
        this.set.put(aSTTripleAtom, null);
    }

    public boolean containsLit(ASTTripleAtom aSTTripleAtom) {
        return this.set.containsKey(aSTTripleAtom);
    }

    public boolean containsExactLit(ASTTripleAtom aSTTripleAtom) {
        return this.setExact.containsKey(aSTTripleAtom);
    }

    public String get(ASTTripleAtom aSTTripleAtom) {
        return (String)this.set.get(aSTTripleAtom);
    }

    public String getExact(ASTTripleAtom aSTTripleAtom) {
        return (String)this.setExact.get(aSTTripleAtom);
    }

    public void resolve(Connection connection) throws SQLException {
        this.resolve(connection, "\"MDSYS\".RDF_VALUE$");
    }

    public void resolve(Connection connection, String string) throws SQLException {
        this.resolve(connection, string, QueryUtils.getDatabaseVersion(connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(Connection connection, String string, OracleDatabaseVersion oracleDatabaseVersion) throws SQLException {
        if (this.set.size() == 0) {
            return;
        }
        String string2 = "";
        string2 = oracleDatabaseVersion.isCompatible(OracleDatabaseVersion.V_19c) ? "{ call MDSYS.RDF_APIS.LOOKUP_LITERAL(?, ?, ?, ?, ?, ?) }" : "{ call MDSYS.RDF_APIS.LOOKUP_LITERAL(?, ?, ?, ?, ?) }";
        CallableStatement callableStatement = null;
        CallableStatement callableStatement2 = null;
        Clob clob = null;
        try {
            callableStatement = connection.prepareCall("{ call MDSYS.RDF_APIS.LOOKUP_LITERAL(?, ?, ?, ?, ?, ?) }");
            callableStatement2 = connection.prepareCall(string2);
            for (ASTTripleAtom aSTTripleAtom : this.set.keySet()) {
                long l;
                long l2;
                if (QueryUtils.computeConstTermLen(aSTTripleAtom.name, aSTTripleAtom.litLang, aSTTripleAtom.litType) <= 4000) {
                    callableStatement.setString(1, string);
                    callableStatement.setString(2, aSTTripleAtom.name);
                    callableStatement.setString(3, aSTTripleAtom.literalHasType() ? aSTTripleAtom.litType : null);
                    callableStatement.setString(4, aSTTripleAtom.literalHasLang() ? aSTTripleAtom.litLang : null);
                    callableStatement.registerOutParameter(5, 2, 0);
                    callableStatement.registerOutParameter(6, 2, 0);
                    callableStatement.execute();
                    l2 = callableStatement.getLong(5);
                    if (l2 <= 0L) continue;
                    this.set.put(aSTTripleAtom, Long.toString(l2));
                    l = callableStatement.getLong(6);
                    if (l <= 0L) continue;
                    this.setExact.put(aSTTripleAtom, Long.toString(l));
                    continue;
                }
                int n = 1;
                if (oracleDatabaseVersion.isCompatible(OracleDatabaseVersion.V_19c)) {
                    callableStatement2.setString(n++, string);
                }
                clob = CLOB.createTemporary((Connection)connection, (boolean)false, (int)10);
                clob.setString(1L, aSTTripleAtom.name);
                callableStatement2.setClob(n++, clob);
                callableStatement2.setString(n++, aSTTripleAtom.literalHasType() ? aSTTripleAtom.litType : null);
                callableStatement2.setString(n++, aSTTripleAtom.literalHasLang() ? aSTTripleAtom.litLang : null);
                callableStatement2.registerOutParameter(n++, 2, 0);
                callableStatement2.registerOutParameter(n, 2, 0);
                callableStatement2.execute();
                l2 = callableStatement2.getLong(n - 1);
                if (l2 <= 0L) continue;
                this.set.put(aSTTripleAtom, Long.toString(l2));
                l = callableStatement2.getLong(n);
                if (l <= 0L) continue;
                this.setExact.put(aSTTripleAtom, Long.toString(l));
            }
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
            if (callableStatement2 != null) {
                callableStatement2.close();
            }
            if (clob != null) {
                clob.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Connection connection, ASTTripleAtom aSTTripleAtom) throws SQLException {
        String string = "{ call mdsys.rdf_apis_internal.lookup_create_literal(?, ?, ?, ?, ?, ?) }";
        try (CallableStatement callableStatement = null;){
            callableStatement = connection.prepareCall(string);
            callableStatement.setString(1, aSTTripleAtom.name);
            callableStatement.setString(2, aSTTripleAtom.literalHasType() ? aSTTripleAtom.litType : null);
            callableStatement.setString(3, aSTTripleAtom.literalHasLang() ? aSTTripleAtom.litLang : null);
            callableStatement.registerOutParameter(4, 2, 0);
            callableStatement.registerOutParameter(5, 2, 0);
            callableStatement.registerOutParameter(6, 2, 0);
            callableStatement.execute();
            long l = callableStatement.getLong(4);
            long l2 = callableStatement.getLong(5);
            this.set.put(aSTTripleAtom, Long.toString(l));
            this.setExact.put(aSTTripleAtom, Long.toString(l2));
        }
    }

    public void createUnresolved(Connection connection) throws SQLException {
        for (ASTTripleAtom aSTTripleAtom : this.set.keySet()) {
            if (this.setExact.get(aSTTripleAtom) != null) continue;
            this.create(connection, aSTTripleAtom);
        }
    }

    public String toString() {
        String string = "";
        for (ASTTripleAtom aSTTripleAtom : this.set.keySet()) {
            String string2 = (String)this.set.get(aSTTripleAtom);
            String string3 = (String)this.setExact.get(aSTTripleAtom);
            string = string + aSTTripleAtom.toString() + " -> " + string2 + " (exact: " + string3 + ")\n";
        }
        return string;
    }

    public Object clone() throws CloneNotSupportedException {
        LiteralSet literalSet = new LiteralSet();
        literalSet.set.putAll(this.set);
        literalSet.setExact.putAll(this.setExact);
        return literalSet;
    }
}

