/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import oracle.spatial.rdf.server.RDFLogger;

public class LogUtils {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final String DEBUG_PFX = "DEBUG: ";
    private static final String ERROR_PFX = "ERROR: ";
    private static final String FATAL_PFX = "FATAL: ";
    private static final String INFO_PFX = " INFO: ";
    private static final String TRACE_PFX = "TRACE: ";
    private static final String WARN_PFX = " WARN: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String string) {
        String string2;
        DateFormat dateFormat = LogUtils.dateFormat;
        synchronized (dateFormat) {
            string2 = LogUtils.dateFormat.format(Calendar.getInstance().getTime());
        }
        System.out.println("[" + string2 + "] " + string + "\n");
    }

    public static void debug(String string, RDFLogger rDFLogger) {
        if (rDFLogger != null) {
            rDFLogger.debug(DEBUG_PFX + string);
        } else {
            LogUtils.log(string);
        }
    }

    public static void error(String string, RDFLogger rDFLogger) {
        if (rDFLogger != null) {
            rDFLogger.error(ERROR_PFX + string);
        } else {
            LogUtils.log(string);
        }
    }

    public static void fatal(String string, RDFLogger rDFLogger) {
        if (rDFLogger != null) {
            rDFLogger.fatal(FATAL_PFX + string);
        } else {
            LogUtils.log(string);
        }
    }

    public static void info(String string, RDFLogger rDFLogger) {
        if (rDFLogger != null) {
            rDFLogger.info(INFO_PFX + string);
        } else {
            LogUtils.log(string);
        }
    }

    public static void trace(String string, RDFLogger rDFLogger) {
        if (rDFLogger != null) {
            rDFLogger.trace(TRACE_PFX + string);
        } else {
            LogUtils.log(string);
        }
    }

    public static void warn(String string, RDFLogger rDFLogger) {
        if (rDFLogger != null) {
            rDFLogger.warn(WARN_PFX + string);
        } else {
            LogUtils.log(string);
        }
    }
}

