/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.FilterFuncHandler;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class OrderCond {
    public static final String ORDER_FAM_FUNC = "sem_apis.getV$OrderFamily";
    public static final String NUMERIC_ORDER_FUNC = "sem_apis.getV$NumericVal";
    public static final String CALENDAR_ORDER_FUNC = "sem_apis.getV$CalendarOrderVal";
    public static final String NUMERIC_IN = "('http://www.w3.org/2001/XMLSchema#decimal','http://www.w3.org/2001/XMLSchema#double','http://www.w3.org/2001/XMLSchema#integer','http://www.w3.org/2001/XMLSchema#float','http://www.w3.org/2001/XMLSchema#int','http://www.w3.org/2001/XMLSchema#nonPositiveInteger','http://www.w3.org/2001/XMLSchema#negativeInteger','http://www.w3.org/2001/XMLSchema#long','http://www.w3.org/2001/XMLSchema#short','http://www.w3.org/2001/XMLSchema#byte','http://www.w3.org/2001/XMLSchema#nonNegativeInteger','http://www.w3.org/2001/XMLSchema#unsignedLong','http://www.w3.org/2001/XMLSchema#unsignedInt','http://www.w3.org/2001/XMLSchema#unsignedShort','http://www.w3.org/2001/XMLSchema#unsignedByte','http://www.w3.org/2001/XMLSchema#positiveInteger')";
    public static final String CALENDAR_IN = "('http://www.w3.org/2001/XMLSchema#date','http://www.w3.org/2001/XMLSchema#time','http://www.w3.org/2001/XMLSchema#dateTime')";
    private int dir = 0;
    private ASTTripleAtom var = null;
    private Filter expr = null;
    private Node exprTree;
    private SQLGenContext ctx;

    public Object clone() throws CloneNotSupportedException {
        OrderCond orderCond = new OrderCond();
        orderCond.setDir(this.dir);
        if (this.var != null) {
            orderCond.setVar((ASTTripleAtom)this.var.cloneNode());
        }
        if (this.exprTree != null) {
            orderCond.setExprTree(this.exprTree.cloneSubTree());
        }
        if (this.expr != null) {
            try {
                orderCond.setExpr((Filter)this.expr.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.out.println("Error cloning query tree [OrderCond]");
                cloneNotSupportedException.printStackTrace();
            }
        }
        if (this.ctx != null) {
            orderCond.setSQLGenCtx(this.ctx);
        }
        return orderCond;
    }

    public void processUnDefVars(Set<String> set, Map<String, String> map) throws RDFException {
        if (this.var != null && !set.contains(this.var.name)) {
            SimpleNode simpleNode = (SimpleNode)this.var.cloneNode();
            this.expr = new Filter(simpleNode, this.ctx);
            this.var = null;
        }
        if (this.expr != null) {
            QueryUtils.processUnDefVars(this.expr, set, map);
            this.exprTree = this.expr.getFilterTree();
        }
    }

    public String toSQL(Map<String, String> map, Map<String, String> map2, Map<String, FilterFuncHandler> map3) throws RDFException {
        String string;
        String string2 = "";
        String string3 = null;
        if (this.dir == 0) {
            string = " ASC NULLS FIRST";
            string3 = "'ASC'";
        } else {
            string = " DESC NULLS LAST";
            string3 = "'DESC'";
        }
        string2 = this.var != null ? this.getSQLforVar(map, string, string3) : this.expr.toOrderBySQL(map, null, map2, map3, string3, string) + string;
        return string2;
    }

    public String getSQLforVar(Map<String, String> map, String string, String string2) {
        String string3;
        String string4 = map.get(this.var.name);
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String string5 = "";
        int n = 0;
        this.getTypeArgs(string4, stringArray, stringArray2, stringArray3, stringArray4);
        String string6 = this.buildVDolArgStr(string4);
        String string7 = "sem_apis.getV$NumericVal(" + string6 + ")";
        String string8 = "sem_apis.getV$CalendarOrderVal(" + string6 + "," + string2 + ")";
        if (this.ctx.inlineOrderBy) {
            string7 = this.buildNumericExpr(stringArray[0]);
            string8 = this.buildCalendarExpr(stringArray3[0], stringArray[0]);
        }
        if (this.ctx.useOrderCol && !Filter.isSubQAlias(string4)) {
            if ((this.ctx.contextFlags & 8) > 0) {
                if ((this.var.flags & 0x10) > 0) {
                    n = 1;
                } else if ((this.var.flags & 0x20) > 0) {
                    n = 2;
                } else if ((this.var.flags & 0x40) > 0) {
                    n = 3;
                }
                string5 = Filter.getAtomSuffix(n);
            }
            string3 = string4 + "." + "ORDER_TYPE" + string5 + " " + string + ", " + string4 + "." + "ORDER_NUM" + string5 + " " + string + ", " + string4 + "." + "ORDER_DATE" + string5 + " " + string + ",\n";
        } else {
            string3 = this.ctx.useOrderCol && (this.ctx.contextFlags & 8) > 0 ? "mdsys.sdo_rdf.GetOrdTyp(" + string4 + "$RDFVID" + ") " + string + ",\nmdsys.sdo_rdf.GetOrdNum(" + string4 + "$RDFVID" + ") " + string + ",\nmdsys.sdo_rdf.GetOrdDate(" + string4 + "$RDFVID" + ") " + string + ",\n" : this.buildOrderFamExpr(stringArray2[0], stringArray3[0], stringArray4[0]) + " " + string + ",\nCASE WHEN (" + stringArray3[0] + " IN " + NUMERIC_IN + ")\nTHEN " + string7 + "\nELSE NULL END " + string + ",\nCASE WHEN (" + stringArray3[0] + " IN " + CALENDAR_IN + ")\nTHEN " + string8 + "\nELSE NULL END " + string + ",\n";
        }
        String string9 = "";
        string9 = Filter.isSubQAlias(string4) ? (this.ctx.useOrderCol && (this.ctx.contextFlags & 8) > 0 ? string9 + "(mdsys.sdo_rdf.GetVal(" + string4 + "$RDFVID" + "))" : string9 + "(" + string4 + "$_PREFIX" + " || " + string4 + "$_SUFFIX" + ")") : string9 + "(" + string4 + "." + "VNAME_PREFIX" + string5 + " || " + string4 + "." + "VNAME_SUFFIX" + string5 + ")";
        if (!this.ctx.networkStorageForm.equals("UNESC") && this.ctx.unescapeStrFunc) {
            string9 = "(CASE WHEN INSTR(" + string9 + ",'\\') > 0 THEN " + "SEM_APIS.unescape_rdf_value" + string9 + " ELSE " + string9 + " END)";
        }
        string3 = string3 + string9 + " " + string;
        return string3;
    }

    public String buildOrderFamExpr(String string, String string2, String string3) {
        String string4 = "CASE WHEN (" + string + " IS NULL) THEN 0\nWHEN (" + string + " IN ('BLN','BN')) THEN 1\nWHEN (" + string + " IN ('URI','UR')) THEN 2\nWHEN (" + string + " IN ('PL', 'PLL', 'CPLL', 'PL@', 'PLL@', 'CPLL@', 'TL', 'TLL', 'CTLL', 'LIT'))\nTHEN (CASE WHEN (" + string3 + " IS NOT NULL) THEN 5\nWHEN (" + string2 + " IS NOT NULL) THEN 4\nELSE 3 END)\nELSE NULL END";
        return string4;
    }

    private String buildNumericExpr(String string) {
        return "TO_NUMBER(" + string + ")";
    }

    private String buildToTsTz(String string, String string2) {
        return "TO_TIMESTAMP_TZ(" + string + ",'" + string2 + "')";
    }

    private String buildTimeStr(String string, boolean bl, String string2) {
        String string3 = "REPLACE(" + string + ",'T')";
        if (bl) {
            string3 = "SUBSTRB(" + string3 + ",2)";
        }
        string3 = this.buildToTsTz("'2009-06-26T' || " + string3 + " || " + string2, "SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM");
        return string3;
    }

    private String buildCalendarExpr(String string, String string2) {
        String string3 = "(CASE WHEN ((SUBSTRB(" + string2 + ",-1,1) != 'Z') AND\n((SUBSTRB(" + string2 + ",-6,1) NOT IN ('-','+')) OR (SUBSTRB(" + string2 + ",-3,1) != ':')))\nTHEN '" + "Z" + "'\nELSE NULL\nEND)\n";
        String string4 = "DECODE (" + string + ",\n'" + "http://www.w3.org/2001/XMLSchema#dateTime" + "',\n" + this.buildToTsTz(string2 + " || " + string3, "SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM") + ",\n'" + "http://www.w3.org/2001/XMLSchema#date" + "',\n" + this.buildToTsTz(string2 + " || " + string3, "SYYYY-MM-DDTZH:TZM") + ",\n'" + "http://www.w3.org/2001/XMLSchema#time" + "',\nDECODE (SUBSTRB(" + string2 + ",1,1),\n'+'," + this.buildTimeStr(string2, true, string3) + " + INTERVAL '1' DAY,\n'-'," + this.buildTimeStr(string2, true, string3) + " - INTERVAL '1' DAY,\n'@'," + this.buildTimeStr(string2, true, string3) + ",\n" + this.buildTimeStr(string2, false, string3) + "),\nNULL\n)\n";
        return string4;
    }

    private void getTypeArgs(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        if (Filter.isSubQAlias(string)) {
            stringArray[0] = string + "$_PREFIX";
            stringArray2[0] = string + "$RDFVTYP";
            stringArray3[0] = string + "$RDFLTYP";
            stringArray4[0] = string + "$RDFLANG";
        } else {
            stringArray[0] = string + "." + "VNAME_PREFIX";
            stringArray2[0] = string + "." + "VALUE_TYPE";
            stringArray3[0] = string + "." + "LITERAL_TYPE";
            stringArray4[0] = string + "." + "LANGUAGE_TYPE";
        }
    }

    private String buildVDolArgStr(String string) {
        String string2 = "";
        string2 = Filter.isSubQAlias(string) ? string + "$RDFVTYP" + ", " + string + "$_PREFIX" + ", " + string + "$_SUFFIX" + ", " + string + "$RDFLTYP" + ", " + string + "$RDFLANG" : string + "." + "VALUE_TYPE" + ", " + string + "." + "VNAME_PREFIX" + ", " + string + "." + "VNAME_SUFFIX" + ", " + string + "." + "LITERAL_TYPE" + ", " + string + "." + "LANGUAGE_TYPE";
        return string2;
    }

    public void initExpression(SQLGenContext sQLGenContext) {
        this.ctx = sQLGenContext;
        if (this.exprTree != null) {
            this.expr = new Filter((SimpleNode)this.exprTree, sQLGenContext);
        }
    }

    public void validateFilter() throws RDFException, TypeException {
        if (this.expr != null) {
            this.expr.validateFilter(this.ctx.funcTypeMap);
        }
    }

    public String toString() {
        String string = "";
        string = string + "OrderCond: \n";
        string = string + "\tDir: " + this.dir + "\n";
        if (this.var != null) {
            string = string + "\tVar: " + this.var.name + "\n";
        }
        if (this.expr != null) {
            string = string + "\tExpr: " + this.expr.toString() + "\n";
        }
        return string;
    }

    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "OrderCond: \n";
        string2 = string2 + string + "\tDir: " + this.dir + "\n";
        if (this.var != null) {
            string2 = string2 + string + "\tVar: " + this.var.name + "\n";
        }
        if (this.expr != null) {
            string2 = string2 + string + "\tExpr: " + this.expr.toString() + "\n";
        }
        return string2;
    }

    public String toString(Map<String, String> map, Map<String, String> map2, Map<String, FilterFuncHandler> map3) {
        String string = this.toString();
        try {
            string = string + "\tSQL [" + this.toSQL(map, map2, map3) + "]\n";
        }
        catch (RDFException rDFException) {
            string = string + "\tSQL [" + rDFException.toString() + "]\n";
        }
        return string;
    }

    public void setSQLGenCtx(SQLGenContext sQLGenContext) {
        this.ctx = sQLGenContext;
        if (this.expr != null) {
            this.expr.setSQLGenCtx(sQLGenContext);
        }
    }

    public void setLexVars(Set<String> set) {
        if (this.expr != null) {
            this.expr.setLexVars(set);
        }
    }

    public void prepareExpression() {
        if (this.expr != null) {
            this.expr.init();
        }
    }

    public void setDir(int n) {
        this.dir = n;
    }

    public void setVar(ASTTripleAtom aSTTripleAtom) {
        this.var = aSTTripleAtom;
    }

    public void setExpr(Filter filter) {
        this.expr = filter;
    }

    public void setExprTree(Node node) {
        this.exprTree = node;
    }

    public void setInScopeVars(Set<String> set) {
        if (this.expr != null) {
            this.expr.setInScopeVars(set, set);
        }
    }

    public void setDefBoundVars(Set<String> set) {
        if (this.expr != null) {
            this.expr.setDefBoundVars(set);
        }
    }

    public Set<String> getVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.var != null) {
            hashSet.add(this.var.name);
        } else {
            hashSet.addAll(this.expr.getVars());
        }
        return hashSet;
    }
}

