/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import oracle.spatial.rdf.server.AbstractPPNode;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.PPSQLTransVisitor;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class PPModNode
extends AbstractPPNode
implements PPNode {
    private int modifier = -1;
    private boolean exact = false;
    private int minOcc = -1;
    private int maxOcc = -1;

    @Override
    public void setStartNode(ASTTripleAtom aSTTripleAtom) {
        this.sNode = aSTTripleAtom;
    }

    @Override
    public void setEndNode(ASTTripleAtom aSTTripleAtom) {
        this.tNode = aSTTripleAtom;
    }

    public void setModDetails(int n, boolean bl, int n2, int n3) {
        this.modifier = n;
        this.exact = bl;
        this.minOcc = n2;
        this.maxOcc = n3;
    }

    public int getModifier() {
        return this.modifier;
    }

    public boolean isExactRange() {
        return this.exact;
    }

    public int getMinOcc() {
        return this.minOcc;
    }

    public int getMaxOcc() {
        return this.maxOcc;
    }

    @Override
    public String accept(PPSQLTransVisitor pPSQLTransVisitor) throws RDFException {
        String string = "";
        int n = this.getNumChildren();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.getChild(i).accept(pPSQLTransVisitor);
            }
            string = pPSQLTransVisitor.visit(this, stringArray);
        } else {
            string = pPSQLTransVisitor.visit(this, null);
        }
        return string;
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + this.getClass().getName() + ": Direction [" + this.direction + "]\n";
        String string3 = "";
        switch (this.modifier) {
            case 0: {
                string3 = "?";
                break;
            }
            case 1: {
                string3 = "*";
                break;
            }
            case 2: {
                string3 = "+";
                break;
            }
            case 3: {
                string3 = "Range";
            }
        }
        string2 = string2 + string + "Modifier[" + string3 + "] exact[" + this.exact + "] minOcc[" + this.minOcc + "] maxOcc[" + this.maxOcc + "]\n";
        if (this.hasConstrainedStart()) {
            string2 = string2 + string + "START [" + this.getStartNode().toString("") + "]\n";
        }
        if (this.hasConstrainedEnd()) {
            string2 = string2 + string + "End [" + this.getEndNode().toString("") + "]\n";
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            string2 = string2 + this.getChild(i).toString(string + "  ") + "\n";
        }
        return string2;
    }
}

