/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTComparisonOperator;
import oracle.spatial.rdf.server.parser.sparql.ASTFilter;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTPathAlternative;
import oracle.spatial.rdf.server.parser.sparql.ASTRelationalExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class PropertyPathAlternateRewriteOptimizer
implements SparqlQueryOptimizer {
    private int varCntr = 0;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        boolean bl = true;
        while (bl) {
            bl = this.transformOneAlt(node);
        }
        return node;
    }

    private boolean transformOneAlt(Node node) {
        LinkedList<NodeInfo> linkedList = new LinkedList<NodeInfo>();
        boolean bl = false;
        linkedList.add(new NodeInfo((SimpleNode)node, null, 0));
        while (!linkedList.isEmpty() && !bl) {
            NodeInfo nodeInfo = (NodeInfo)linkedList.remove();
            SimpleNode simpleNode = nodeInfo.node;
            ASTGroupGraphPattern aSTGroupGraphPattern = nodeInfo.parentGGP;
            int n = nodeInfo.pos;
            if (this.isTbWithRewritableAltPropPath(simpleNode)) {
                bl = true;
                this.transformAlt(simpleNode, aSTGroupGraphPattern, n);
            }
            if (bl) continue;
            if (simpleNode.id == 48) {
                aSTGroupGraphPattern = (ASTGroupGraphPattern)simpleNode;
            }
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                if (simpleNode.id == 48) {
                    n = i;
                }
                linkedList.add(new NodeInfo((SimpleNode)simpleNode.jjtGetChild(i), aSTGroupGraphPattern, n));
            }
        }
        return bl;
    }

    private boolean isTbWithRewritableAltPropPath(SimpleNode simpleNode) {
        if (simpleNode.id == 47 && simpleNode.jjtGetNumChildren() >= 2 && ((SimpleNode)simpleNode.jjtGetChild((int)1)).id == 65) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(1);
            if (OptimizerUtils.containsNodeType((Node)simpleNode2, 57)) {
                return false;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < simpleNode2.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(i);
                if (simpleNode3.id != 73) {
                    return false;
                }
                String string = ((ASTTripleAtom)simpleNode3).name;
                if (hashSet.contains(string)) {
                    return false;
                }
                hashSet.add(string);
            }
            return true;
        }
        return false;
    }

    private void transformAlt(SimpleNode simpleNode, ASTGroupGraphPattern aSTGroupGraphPattern, int n) {
        int n2;
        ASTTriplesBlock aSTTriplesBlock = (ASTTriplesBlock)simpleNode;
        ASTPathAlternative aSTPathAlternative = (ASTPathAlternative)aSTTriplesBlock.jjtGetChild(1);
        ArrayList<ASTTripleAtom> arrayList = new ArrayList<ASTTripleAtom>();
        for (int i = 0; i < aSTPathAlternative.jjtGetNumChildren(); ++i) {
            arrayList.add((ASTTripleAtom)aSTPathAlternative.jjtGetChild(i));
        }
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 0;
        aSTTripleAtom.name = "PP$A$" + Integer.toString(this.varCntr);
        ++this.varCntr;
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom, 1);
        aSTTripleAtom.jjtSetParent(aSTTriplesBlock);
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = this.buildInFilter((ASTTripleAtom)aSTTripleAtom.cloneNode(), arrayList);
        Node[] nodeArray = aSTGroupGraphPattern.children;
        aSTGroupGraphPattern.jjtSetInitCapacity(nodeArray.length + 1);
        for (n2 = 0; n2 <= n; ++n2) {
            aSTGroupGraphPattern.jjtAddChild(nodeArray[n2], n2);
        }
        aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples, n + 1);
        aSTGraphPatternNotTriples.jjtSetParent(aSTGroupGraphPattern);
        for (n2 = n + 1; n2 < nodeArray.length; ++n2) {
            aSTGroupGraphPattern.jjtAddChild(nodeArray[n2], n2 + 1);
        }
    }

    private ASTGraphPatternNotTriples buildInFilter(ASTTripleAtom aSTTripleAtom, List<ASTTripleAtom> list) {
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
        ASTFilter aSTFilter = new ASTFilter(56);
        aSTGraphPatternNotTriples.jjtAddChild(aSTFilter, 0);
        aSTFilter.jjtSetParent(aSTGraphPatternNotTriples);
        ASTRelationalExpression aSTRelationalExpression = new ASTRelationalExpression(80);
        aSTFilter.jjtAddChild(aSTRelationalExpression, 0);
        aSTRelationalExpression.jjtSetParent(aSTFilter);
        aSTRelationalExpression.jjtSetInitCapacity(list.size() + 2);
        aSTRelationalExpression.jjtAddChild(aSTTripleAtom, 0);
        aSTTripleAtom.jjtSetParent(aSTRelationalExpression);
        ASTComparisonOperator aSTComparisonOperator = new ASTComparisonOperator(81);
        aSTComparisonOperator.name = "IN";
        aSTRelationalExpression.jjtAddChild(aSTComparisonOperator, 1);
        aSTComparisonOperator.jjtSetParent(aSTRelationalExpression);
        int n = 2;
        for (ASTTripleAtom aSTTripleAtom2 : list) {
            aSTRelationalExpression.jjtAddChild(aSTTripleAtom2, n);
            aSTTripleAtom2.jjtSetParent(aSTRelationalExpression);
            ++n;
        }
        return aSTGraphPatternNotTriples;
    }

    public static class NodeInfo {
        public SimpleNode node;
        public ASTGroupGraphPattern parentGGP;
        public int pos;

        public NodeInfo(SimpleNode simpleNode, ASTGroupGraphPattern aSTGroupGraphPattern, int n) {
            this.node = simpleNode;
            this.parentGGP = aSTGroupGraphPattern;
            this.pos = n;
        }
    }
}

