/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.OracleDatabaseVersion;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.UnDefVarFilterOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.util.Util;

public final class QueryUtils {
    protected static final int DEFAULT_MASK_THRESHOLD = 4;
    private static final Pattern HINT0PATTERN = Pattern.compile("(^|\\G|\\s+)HINT0\\s*=\\s*\\{\\s*([^\\}]*)\\s*\\}(\\s+|$)", 2);
    private static final Pattern TIMESTAMP = Pattern.compile("[0-9]{4}/[0-9]{2}/[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{0,9})?");
    private static final Pattern PID_COLUMN_PATTERN = Pattern.compile("^P[\\p{Digit}]+$");
    private static final Pattern PID_VALUE_COLUMN_PATTERN = Pattern.compile("^P[\\p{Digit}]+_VALUE_TYPE$");
    private static final Set<String> SCHEMA_PROPERTIES = new HashSet<String>();
    private static final Set<String> UNSELECTIVE_PROPERTIES;
    private static final String[] SPATIAL_FUNCTIONS;
    private static final String[] ORACLE_TEXT_FUNCTIONS;
    private static final int[] UNBOUND_PROPERTY_PATH_NODES;
    public static final int DEFAULT_PP_DEPTH = 10;
    private static final int NET_NAME_MAX_LEN = 25;

    protected static void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    protected static void log(String string, String string2) {
        System.out.print("\n");
        System.out.print(string);
        System.out.print(string2);
    }

    protected static boolean isEnterpriseEditionDB(Connection connection) throws SQLException {
        boolean bl = false;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductVersion().toUpperCase();
        if (string.indexOf("ENTERPRISE EDITION") > 0 || string.indexOf("EE") > 0) {
            bl = true;
        }
        return bl;
    }

    protected static String getNetworkStorageForm(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = "";
        String string3 = "SELECT value FROM " + string + "RDF_PARAMETER WHERE namespace='NETWORK' and attribute='STORAGE_FORM'";
        try {
            preparedStatement = connection.prepareStatement(string3.toString());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString("VALUE");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return string2;
    }

    protected static void getSdoRdfPPFuncInfo(Connection connection, boolean[] blArray, boolean[] blArray2) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "SELECT /*+ result_cache dynamic_sampling(0) parallel(1) */ argument_name FROM SYS.ALL_ARGUMENTS WHERE OWNER='MDSYS' AND OBJECT_NAME='SDO_RDF_PP' AND PACKAGE_NAME='SDO_RDF'";
        try {
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                bl = true;
                string = resultSet.getString(1);
                if (!"MIN_OCC".equals(string)) continue;
                bl2 = true;
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        blArray[0] = bl;
        blArray2[0] = bl2;
    }

    protected static boolean isValidForSPMOpt(SQLGenContext sQLGenContext) {
        boolean bl = true;
        if (!sQLGenContext.spmEnabled) {
            bl = false;
        } else if (sQLGenContext.useExactValue) {
            bl = false;
        } else if (sQLGenContext.models != null && sQLGenContext.models.length > 1 || sQLGenContext.vmViewName != null && sQLGenContext.vmViewName.length() > 0) {
            bl = false;
        } else if (sQLGenContext.precompIdxName != null && sQLGenContext.precompIdxName.length() > 0 || sQLGenContext.precompIdxID != 0L) {
            bl = false;
        } else if (sQLGenContext.policyName != null && sQLGenContext.policyName.length() > 0 || sQLGenContext.minLabel != null && sQLGenContext.minLabel.length() > 0) {
            bl = false;
        } else if (sQLGenContext.asOfClause != null && sQLGenContext.asOfClause.length() > 0) {
            bl = false;
        } else if (sQLGenContext.defaultMIDs != null && sQLGenContext.defaultMIDs.length > 0 || sQLGenContext.defaultModels != null && sQLGenContext.defaultModels.length > 0 || sQLGenContext.allUnnamedTrips || sQLGenContext.entUnnamedTrips || sQLGenContext.nonEmptyNamed) {
            bl = false;
        }
        return bl;
    }

    protected static Map<String, List<String>> getSPMTabsInfo(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        String string5 = "SELECT /*+ DYNAMIC_SAMPLING(0) RESULT_CACHE */ a.table_name, a.column_name FROM sys.all_tab_columns a WHERE (a.table_name like ? OR a.table_name like ? OR a.table_name like ?) AND a.owner = ? ORDER BY a.table_name, a.column_id ASC";
        String string6 = QueryUtils.checkRemoveEnclosingQuotes(string);
        String string7 = null;
        String string8 = null;
        try {
            preparedStatement = connection.prepareStatement(string5);
            preparedStatement.setString(1, string2 + "%");
            preparedStatement.setString(2, string3 + "%");
            preparedStatement.setString(3, string4 + "%");
            preparedStatement.setString(4, string6);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string7 = resultSet.getString(1);
                string8 = resultSet.getString(2);
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string7);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(string7, arrayList);
                }
                arrayList.add(string8);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashMap;
    }

    protected static Map<String, Set<String>> getSvpProperties(String string, Map<String, List<String>> map) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            HashSet<String> hashSet = new HashSet<String>();
            List<String> list = map.get(string2);
            for (String string3 : list) {
                if (!PID_COLUMN_PATTERN.matcher(string3).matches()) continue;
                hashSet.add(string3.substring(1));
            }
            hashMap.put(string2, hashSet);
        }
        return hashMap;
    }

    protected static Set<String> getMvpProperties(String string, Map<String, List<String>> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            hashSet.add(string2.substring(string.length()));
        }
        return hashSet;
    }

    protected static List<Map.Entry<String, List<String>>> getSortedPcnPropList(String string, Map<String, List<String>> map) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = map.get(string2);
            for (String string3 : list) {
                if (!PID_COLUMN_PATTERN.matcher(string3).matches()) continue;
                arrayList.add(string3.substring(1));
            }
            hashMap.put(string2, arrayList);
        }
        return QueryUtils.sortPcnPropListMap(hashMap);
    }

    private static List<Map.Entry<String, List<String>>> sortPcnPropListMap(Map<String, List<String>> map) {
        ArrayList<Map.Entry<String, List<String>>> arrayList = new ArrayList<Map.Entry<String, List<String>>>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            QueryUtils.addToSortedPcnList(arrayList, entry);
        }
        return arrayList;
    }

    private static void addToSortedPcnList(List<Map.Entry<String, List<String>>> list, Map.Entry<String, List<String>> entry) {
        boolean bl = false;
        for (int i = 0; i < list.size() && !bl; ++i) {
            Map.Entry<String, List<String>> entry2 = list.get(i);
            if (entry2.getValue().size() >= entry.getValue().size()) continue;
            list.add(i, entry);
            bl = true;
        }
        if (!bl) {
            list.add(entry);
        }
    }

    protected static Map<String, Set<String>> getSvpValueProperties(String string, Map<String, List<String>> map) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            Set<String> set = QueryUtils.getValueProperties(map.get(string2));
            hashMap.put(string2, set);
        }
        return hashMap;
    }

    protected static Map<String, Set<String>> getPcnValueProperties(String string, Map<String, List<String>> map) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            Set<String> set = QueryUtils.getValueProperties(map.get(string2));
            hashMap.put(string2, set);
        }
        return hashMap;
    }

    protected static Set<String> getMvpValueProperties(String string, Map<String, List<String>> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            hashSet.addAll(QueryUtils.getValueProperties(entry.getValue()));
        }
        return hashSet;
    }

    protected static Set<String> getValueProperties(List<String> list) {
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            for (String string : list) {
                if (!PID_VALUE_COLUMN_PATTERN.matcher(string).matches()) continue;
                hashSet.add(string.substring(1, string.indexOf("_")));
            }
        }
        return hashSet;
    }

    public static String checkRemoveEnclosingQuotes(String string) {
        if (string != null && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String getSvpTabPrefix(String string, String string2) {
        String string3 = QueryUtils.getNetworkNamePfx(string2);
        return string3 + "RDF_XT$SVP_" + string;
    }

    public static String getMvpTabPrefix(String string, String string2) {
        String string3 = QueryUtils.getNetworkNamePfx(string2);
        return string3 + "RDF_XT$MVP_" + string + "_P";
    }

    public static String getPcnTabPrefix(String string, String string2) {
        String string3 = QueryUtils.getNetworkNamePfx(string2);
        return string3 + "RDF_XT$PCN_" + string;
    }

    public static int combineSelectivity(int n, int n2) {
        int n3 = 0;
        if (n == 1 || n2 == 1) {
            n3 = 1;
        }
        return n3;
    }

    public static String updateLinkHintForAllHash(String string) {
        int n;
        String string2 = string;
        if (string2 == null) {
            string2 = new String("");
        }
        String string3 = string2.toUpperCase();
        boolean bl = false;
        boolean bl2 = false;
        if (HintGenerator.LINK_JOIN_REGEX_PATTERN.matcher(string3).matches()) {
            bl = true;
            bl2 = true;
        }
        for (n = 0; n < HintGenerator.LINK_JOIN_HINTS.length && !bl; ++n) {
            if (string3.indexOf(HintGenerator.LINK_JOIN_HINTS[n]) < 0) continue;
            bl = true;
        }
        for (n = 0; n < HintGenerator.SPM_JOIN_HINTS.length && !bl2; ++n) {
            if (string3.indexOf(HintGenerator.SPM_JOIN_HINTS[n]) < 0) continue;
            bl2 = true;
        }
        if (!bl) {
            string2 = string2 + " " + Hint.QueryOption.ALL_LINK_HASH.getName() + " ";
        }
        if (!bl2) {
            string2 = string2 + " " + Hint.QueryOption.ALL_SPM_HASH.getName() + " ";
        }
        return string2;
    }

    public static String updateValueHintForAllHash(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = new String("");
        }
        String string3 = string2.toUpperCase();
        boolean bl = false;
        if (HintGenerator.VALUE_JOIN_REGEX_PATTERN.matcher(string3).matches()) {
            bl = true;
        }
        for (int i = 0; i < HintGenerator.VALUE_JOIN_HINTS.length && !bl; ++i) {
            if (string3.indexOf(HintGenerator.VALUE_JOIN_HINTS[i]) < 0) continue;
            bl = true;
        }
        if (!bl) {
            string2 = string2 + " " + Hint.QueryOption.ALL_LOCAL_VALUE_HASH.getName() + " ";
            string2 = string2 + " " + Hint.QueryOption.ALL_NONLOCAL_VALUE_HASH.getName() + " ";
        }
        return string2;
    }

    public static OracleDatabaseVersion getDatabaseVersion(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductVersion();
        if (string.indexOf(" 10.2") >= 0) {
            return OracleDatabaseVersion.V_10_2;
        }
        if (string.indexOf(" 11.1") >= 0) {
            return OracleDatabaseVersion.V_11_1;
        }
        if (string.indexOf(" 11.2") >= 0) {
            return OracleDatabaseVersion.V_11_2;
        }
        if (string.indexOf(" 12.1") >= 0) {
            return OracleDatabaseVersion.V_12_1;
        }
        if (string.indexOf(" 12.2") >= 0) {
            return OracleDatabaseVersion.V_12_2;
        }
        if (string.indexOf(" 18.") >= 0) {
            return OracleDatabaseVersion.V_18c;
        }
        if (string.indexOf(" 19.") >= 0) {
            return OracleDatabaseVersion.V_19c;
        }
        if (string.indexOf(" 20.") >= 0) {
            return OracleDatabaseVersion.V_20c;
        }
        if (string.indexOf(" 21.") >= 0) {
            return OracleDatabaseVersion.V_21c;
        }
        return OracleDatabaseVersion.V_22c;
    }

    public static String qualifiedSQLName(Connection connection, String string) throws SQLException {
        return Util.qualifiedSQLName((Connection)connection, (String)string);
    }

    public static String enquoteNameSQLName(String string) throws SQLException {
        return Util.enquoteNameSQLName((String)string, (boolean)false);
    }

    public static String simpleSQLName(String string, int n) throws SQLException {
        return Util.checkSQLName((String)string, (int)n);
    }

    public static String enquoteLiteral(String string) throws SQLException {
        return "'" + string.replace("'", "''") + "'";
    }

    public static String getPfxForRdfObjName(String string, String string2) {
        return string + "." + QueryUtils.getNetworkNamePfx(string2);
    }

    public static String getNetworkOwnerOrMdsys(String string) {
        String string2 = null;
        string2 = string == null || string.length() == 0 ? "MDSYS" : string;
        try {
            string2 = QueryUtils.enquoteNameSQLName(string2);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        return string2;
    }

    public static String getNetworkNameOrEmptyString(String string) throws SQLException {
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string.toUpperCase();
            string2 = QueryUtils.simpleSQLName(string, 25);
        }
        return string2;
    }

    public static String getNetworkNamePfx(String string) {
        String string2 = null;
        string2 = string == null || string.length() == 0 ? "" : string.toUpperCase() + "#";
        return string2;
    }

    protected static String getLocalValueDollarName(String string) {
        return string + "RDF_VALUE$";
    }

    protected static String getLocalNamespaceDollarName(String string) {
        return string + "RDF_NAMESPACE$";
    }

    protected static String valueNamePrefix(String string, String string2) {
        String string3 = string;
        String string4 = string.replace("/", ":").replace("#", ":");
        int n = string4.lastIndexOf(":");
        if (n >= 0 && (string2.equals("UR") || string2.equals("URI"))) {
            string3 = string.substring(0, n + 1);
            if (string.length() - string3.length() > 128) {
                string3 = string;
            }
        }
        return string3;
    }

    protected static boolean isSchemaProperty(String string) {
        return SCHEMA_PROPERTIES.contains(string);
    }

    public static boolean isUnselectiveProperty(String string) {
        return UNSELECTIVE_PROPERTIES.contains(string);
    }

    protected static boolean hasSpatialFunction(Node node) {
        return OptimizerUtils.containsFunction(node, SPATIAL_FUNCTIONS, null);
    }

    protected static boolean hasOracleTextFunction(Node node) {
        return OptimizerUtils.containsFunction(node, ORACLE_TEXT_FUNCTIONS, null);
    }

    protected static boolean hasUnboundPropertyPath(Node node) {
        return OptimizerUtils.containsNodeType(node, UNBOUND_PROPERTY_PATH_NODES);
    }

    protected static int getMaxPPDepth(Map<Hint.QueryOption, String> map) {
        String string;
        int n = 10;
        if (map != null && (string = map.get((Object)Hint.QueryOption.MAX_PP_DEPTH)) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                QueryUtils.log("Error reading MAX_PP_DEPTH for\n" + string + "\n" + exception.getMessage());
            }
        }
        return n;
    }

    protected static String buildSQLCollectionStr(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string).append("(");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("'").append(stringArray[i]).append("'");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected static String buildSQLCollectionStr(String string, long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string).append("(");
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(Long.toString(lArray[i]));
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected static String extractParenValue(String string, int n, String string2) {
        String string3 = null;
        String string4 = "Error extracting value for " + string2;
        int n2 = string.indexOf("(", n);
        if (n2 >= 0) {
            int n3 = string.indexOf(")", n2);
            if (n3 > n2 + 1) {
                string3 = string.substring(n2 + 1, n3).trim();
            } else {
                QueryUtils.log(string4);
            }
        } else {
            QueryUtils.log(string4);
        }
        return string3;
    }

    protected static String wrapSQLforNumeric(String string) {
        String string2 = "";
        string2 = "to_number(" + string + ")";
        return string2;
    }

    protected static String buildVidHash(String string) {
        return "round(sys_op_combined_hash(" + string + ")/2)";
    }

    protected static String buildSubQForCLOB(String string, String string2, String string3, String string4) {
        String string5 = "(CASE WHEN " + string3 + " LIKE 'ORALL%' THEN (SELECT /*+ INDEX(V " + "C_PK_VID" + ") */ V." + "LONG_VALUE" + " FROM " + string4 + " V WHERE V." + "VALUE_ID" + "=" + string2 + ") ELSE NULL END)";
        return string5;
    }

    protected static String buildInLineRDFT(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string5 = string;
        if (bl) {
            string5 = "(CASE WHEN (" + string4 + "='" + "http://www.w3.org/2001/XMLSchema#time" + "' AND SUBSTR(" + string5 + ",1,1) IN ('@','+','-')) THEN SUBSTR(" + string5 + ",2) ELSE " + string5 + " END)";
        }
        string5 = "REPLACE(" + string5 + ",chr(0))";
        String string6 = string3;
        if (bl2) {
            string6 = "LOWER(" + string3 + ")";
        }
        stringBuffer.append("CASE WHEN " + string2 + " IS NULL\n");
        stringBuffer.append("THEN NULL\n");
        stringBuffer.append("WHEN " + string2 + " IN " + "('UR','URI')" + "\n");
        stringBuffer.append("THEN '<' || " + string + " || '>'\n");
        stringBuffer.append("WHEN " + string2 + " IN " + "('BL','BLN','BN')" + "\n");
        stringBuffer.append("THEN " + string + "\n");
        stringBuffer.append("ELSE\n");
        stringBuffer.append("'\"' || " + string5 + " || '\"' || ");
        stringBuffer.append("NVL2(" + string3 + ",'@' || " + string6 + ",'') || ");
        stringBuffer.append("NVL2(" + string4 + ",'^^<' || " + string4 + " || '>', '')");
        stringBuffer.append("END");
        return stringBuffer.toString();
    }

    protected static void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2, String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (String string2 : set) {
            map2.put(string2.toUpperCase(), "V" + n);
            String string3 = QueryUtils.buildVTYPCaseForVar("V" + n);
            ArrayList<String> arrayList = new ArrayList<String>(8);
            arrayList.add("V" + n + "." + "VNAME_PREFIX" + " || V" + n + "." + "VNAME_SUFFIX");
            arrayList.add("V" + n + "." + "VALUE_ID");
            arrayList.add("V" + n + "." + "VNAME_PREFIX");
            arrayList.add("V" + n + "." + "VNAME_SUFFIX");
            arrayList.add(string3);
            arrayList.add("V" + n + "." + "LONG_VALUE");
            arrayList.add("V" + n + "." + "LITERAL_TYPE");
            arrayList.add("V" + n + "." + "LANGUAGE_TYPE");
            map.put(string2.toUpperCase(), arrayList);
            stringBuffer.append(", " + string + " V" + n);
            if (set2.contains(string2)) {
                stringBuffer2.append(" AND (R." + string2 + "$RDFVID" + " = V" + n + "." + "VALUE_ID" + ")");
            } else {
                stringBuffer2.append(" AND (R." + string2 + "$RDFVID" + " = V" + n + "." + "VALUE_ID" + "(+))");
            }
            ++n;
        }
        stringArray[0] = stringBuffer.toString();
        stringArray2[0] = stringBuffer2.toString();
    }

    protected static void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2, String string, SQLGenContext sQLGenContext) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        String string2 = QueryUtils.enquoteLiteral(QueryUtils.getLocalValueDollarName(sQLGenContext.clnPfxForRdfObjName));
        String string3 = QueryUtils.enquoteLiteral(QueryUtils.getNetworkNamePfx(sQLGenContext.clnNetworkName));
        String string4 = QueryUtils.enquoteLiteral(sQLGenContext.clnNetworkOwner);
        if ((sQLGenContext.contextFlags & 8) > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string5 : set) {
                ArrayList<String> arrayList = new ArrayList<String>(8);
                String string6 = string5.toUpperCase();
                map2.put(string6, "R." + string6);
                hashSet.add(string5);
                arrayList.add("mdsys.sdo_rdf.GetPref(R." + string6 + "$RDFVID" + "," + string3 + "," + string4 + "," + string2 + ") || mdsys.sdo_rdf.GetSuff(R." + string6 + "$RDFVID" + "," + string3 + "," + string4 + "," + string2 + ")");
                arrayList.add("R." + string6 + "$RDFVID");
                arrayList.add("mdsys.sdo_rdf.GetPref(R." + string6 + "$RDFVID" + "," + string3 + "," + string4 + "," + string2 + ")");
                arrayList.add("mdsys.sdo_rdf.GetSuff(R." + string6 + "$RDFVID" + "," + string3 + "," + string4 + "," + string2 + ")");
                arrayList.add("mdsys.sdo_rdf.GetValTyp(R." + string6 + "$RDFVID" + "," + string3 + "," + string4 + "," + string2 + ")");
                arrayList.add("TO_CLOB(NULL)");
                arrayList.add("mdsys.sdo_rdf.GetLitType(R." + string6 + "$RDFVID" + "," + string3 + "," + string4 + "," + string2 + ")");
                arrayList.add("mdsys.sdo_rdf.GetLangType(R." + string6 + "$RDFVID" + "," + string3 + "," + string4 + "," + string2 + ")");
                map.put(string6, arrayList);
            }
            sQLGenContext.vjoinVars = hashSet;
        }
        stringArray[0] = stringBuffer.toString();
        stringArray2[0] = stringBuffer2.toString();
    }

    protected static String buildVTYPCaseForVar(String string) {
        String string2 = " (CASE WHEN " + string + "." + "VALUE_TYPE" + " IS NULL THEN NULL WHEN " + string + "." + "VALUE_TYPE" + " IN ('UR','" + "URI" + "') THEN '" + "URI" + "'\n WHEN " + string + "." + "VALUE_TYPE" + " IN ('BN', '" + "BLN" + "') THEN '" + "BLN" + "'\n ELSE '" + "LIT" + "'\nEND) ";
        return string2;
    }

    protected static ASTTripleAtom maskVar(String string) {
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 0;
        aSTTripleAtom.name = string + "$";
        return aSTTripleAtom;
    }

    protected static boolean isMasked(ASTTripleAtom aSTTripleAtom) {
        boolean bl = false;
        if (aSTTripleAtom != null && aSTTripleAtom.type == 0 && aSTTripleAtom.name.endsWith("$")) {
            bl = true;
        }
        return bl;
    }

    protected static String unMaskVar(String string) {
        return string.substring(0, string.length() - 1);
    }

    protected static String buildAliasExpr(SQLGenContext sQLGenContext, String string, String string2) {
        if (!sQLGenContext.disableAliasOpt && string.endsWith(string2) && string.matches("^\\w+\\." + string2.replace("$", "\\$") + "$")) {
            return string;
        }
        return string + " AS " + string2;
    }

    protected static String buildFuncCall(String string, int[] nArray, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string).append("(");
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(list.get(nArray[i]));
            bl = true;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected static boolean containsAny(Set<String> set, Set<String> set2) {
        if (set != null && !set.isEmpty()) {
            for (String string : set2) {
                if (!set.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set<String> getCommonVars(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!set2.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected static Set<String> getUnion(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    protected static Set<String> getDistinctVars(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (set2.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected static boolean isSafeTabName(String string) {
        if (string.contains("(") || string.contains(")") || string.contains(";") || string.contains("'") || string.contains("\"") || string.contains(",")) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("SELECT");
        hashSet.add("FROM");
        hashSet.add("WHERE");
        hashSet.add("UNION");
        hashSet.add("JOIN");
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!hashSet.contains(string2)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isSafeTimestamp(String string) {
        return TIMESTAMP.matcher(string).matches();
    }

    protected static String extractBracketedOption(String string, String string2) {
        String string3 = null;
        int n = string.indexOf(string2 + "=[");
        if (n >= 0) {
            string3 = QueryUtils.extractUntil(string, n + string2.length() + 2, ']');
        }
        return string3;
    }

    protected static String extractPlainOption(String string, String string2) {
        String string3 = null;
        int n = string.indexOf(string2 + "=");
        if (n >= 0) {
            n = n + string2.length() + 1;
            int n2 = string.indexOf(" ", n);
            int n3 = string.indexOf("\t", n);
            int n4 = string.indexOf("\n", n);
            if (n2 > n3 && n3 != -1) {
                n2 = n3;
            }
            if (n2 > n4 && n4 != -1) {
                n2 = n4;
            }
            if (n2 == -1) {
                n2 = string.length();
            }
            string3 = string.substring(n, n2);
        }
        return string3;
    }

    protected static String extractUntil(String string, int n, char c) {
        String string2 = "";
        int n2 = n;
        if (n2 <= string.length()) {
            char c2 = ' ';
            boolean bl = false;
            while (!bl && n2 <= string.length()) {
                c2 = string.charAt(n2);
                if (c2 == c) {
                    bl = true;
                } else {
                    string2 = string2 + String.valueOf(c2);
                }
                ++n2;
            }
        }
        return string2;
    }

    protected static void appendToList(StringBuffer stringBuffer, String string, String string2, String string3) {
        if (stringBuffer.length() == string3.length() && stringBuffer.toString().equalsIgnoreCase(string3)) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string2 + string);
        }
    }

    protected static String appendToList(String string, String string2, String string3, String string4) {
        String string5 = "";
        string5 = string.equalsIgnoreCase(string4) ? string + string2 : string + string3 + string2;
        return string5;
    }

    protected static boolean selectNeeded(boolean bl, boolean bl2, boolean bl3, int[] nArray, int[] nArray2, int[] nArray3) {
        boolean bl4 = false;
        if (nArray2[0] < nArray.length && nArray3[0] == nArray[nArray2[0]] || bl2) {
            bl4 = true;
        }
        if ((!bl3 || bl) && bl4 && nArray2[0] < nArray.length && nArray3[0] == nArray[nArray2[0]]) {
            nArray2[0] = nArray2[0] + 1;
        }
        if (!bl3 || bl) {
            nArray3[0] = nArray3[0] + 1;
        }
        return bl4;
    }

    protected static String buildMaskedInListClause(String[] stringArray, Set<String> set, Set<String> set2, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String string, String string2, String string3, String string4, boolean bl, String string5, SQLGenContext sQLGenContext) throws RDFException {
        int n;
        CharSequence charSequence;
        String[] stringArray6 = new String[stringArray.length];
        String[] stringArray7 = new String[stringArray.length];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            charSequence = stringArray[i];
            string7 = stringArray2[i];
            string9 = stringArray3[i];
            if (!set.contains(charSequence)) {
                string7 = "NVL(" + stringArray2[i] + "," + stringArray4[i] + ")";
                arrayList.add(i);
                arrayList3.add(stringArray4[i]);
            }
            if (!set2.contains(charSequence)) {
                string9 = "NVL(" + stringArray3[i] + "," + stringArray5[i] + ")";
                arrayList2.add(i);
                arrayList4.add(stringArray5[i]);
            }
            stringArray6[i] = string7;
            stringArray7[i] = string9;
        }
        String[] stringArray8 = new String[stringArray.length];
        charSequence = new StringBuffer("");
        String string10 = "";
        String string11 = "";
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            String string12 = stringArray[n];
            string10 = stringArray2[n];
            string11 = stringArray3[n];
            if (!set.contains(string12)) {
                string10 = !stringArray4[n].startsWith("'") ? "COALESCE(" + QueryUtils.wrapSQLforNumeric(stringArray2[n]) + "," + QueryUtils.wrapSQLforNumeric(stringArray3[n]) + "," + stringArray4[n] + ")" : "COALESCE(" + stringArray2[n] + "," + stringArray3[n] + "," + stringArray4[n] + ")";
            }
            if (!set2.contains(string12)) {
                string11 = !stringArray5[n].startsWith("'") ? "COALESCE(" + QueryUtils.wrapSQLforNumeric(stringArray3[n]) + "," + QueryUtils.wrapSQLforNumeric(stringArray2[n]) + "," + stringArray5[n] + ")" : "COALESCE(" + stringArray3[n] + "," + stringArray2[n] + "," + stringArray5[n] + ")";
                ++n2;
            }
            stringArray8[n] = string10 + " = " + string11;
        }
        n = 0;
        for (int i = 0; i < stringArray8.length; ++i) {
            if (n != 0) {
                ((StringBuffer)charSequence).append(" AND\n");
            }
            ((StringBuffer)charSequence).append(stringArray8[i]);
            n = 1;
        }
        if (!bl && n2 == stringArray.length) {
            String string13 = QueryUtils.buildAllColCoalesce(stringArray3, stringArray5);
            if (n != 0) {
                ((StringBuffer)charSequence).append(" AND\n");
            }
            ((StringBuffer)charSequence).append(string13 + " IS NOT NULL");
        }
        if (arrayList.size() > 32 || arrayList2.size() > 32) {
            throw new RDFException("Limit of 32 potentially unbound variables exceeded in negation pattern");
        }
        int n3 = arrayList.size() + arrayList2.size();
        Set<Integer> set3 = Collections.emptySet();
        string6 = QueryUtils.genColListForIn(stringArray6, set3, stringArray4, stringArray2, false, "1");
        string8 = bl ? QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, false, "1") : QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, true, "0");
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(QueryUtils.buildExistsCond(string6, string3, string8, string, string2, sQLGenContext, string5, ((StringBuffer)charSequence).toString(), n3));
        if (sQLGenContext.forceMaskForNE || sQLGenContext.disableNotExists || n3 <= sQLGenContext.neMaskThreshold && !sQLGenContext.disableMaskForNE) {
            List<Set<Integer>> list = QueryUtils.genMaskingSets(arrayList);
            for (Set<Integer> object2 : list) {
                string6 = QueryUtils.genColListForIn(stringArray6, set3, stringArray4, stringArray2, false, "1");
                string8 = bl ? QueryUtils.genColListForIn(stringArray7, object2, stringArray4, stringArray3, false, "1") : QueryUtils.genColListForIn(stringArray7, object2, stringArray4, stringArray3, true, "0");
                stringBuffer.append(string4 + "\n");
                stringBuffer.append(QueryUtils.buildExistsCond(string6, string3, string8, string, string2, sQLGenContext, string5, "", n3));
            }
            List<Set<Integer>> list2 = QueryUtils.genMaskingSets(arrayList2);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Set set4 = (Set)iterator.next();
                string6 = QueryUtils.genColListForIn(stringArray6, set4, stringArray5, stringArray2, false, "1");
                string8 = bl ? QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, false, "1") : QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, true, "0");
                stringBuffer.append(string4 + "\n");
                stringBuffer.append(QueryUtils.buildExistsCond(string6, string3, string8, string, string2, sQLGenContext, string5, "", n3));
            }
        }
        return stringBuffer.toString();
    }

    protected static String buildExistsCond(String string, String string2, String string3, String string4, String string5, SQLGenContext sQLGenContext, String string6, String string7, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (sQLGenContext.disableNotExists) {
            stringBuffer.append("(" + string + ")\n");
            stringBuffer.append(string2 + "\n");
            stringBuffer.append("(SELECT " + string6 + "" + string3 + "\n");
            stringBuffer.append("FROM (" + string4 + ") " + string5 + ")");
        } else {
            stringBuffer.append("(" + string2 + "\n");
            stringBuffer.append("(SELECT " + string6 + " " + string3 + "\n");
            stringBuffer.append("FROM (" + string4 + ") " + string5 + "\n");
            if (sQLGenContext.forceMaskForNE || n <= sQLGenContext.neMaskThreshold && !sQLGenContext.disableMaskForNE) {
                stringBuffer.append("WHERE (" + string + ") IN ((" + string3 + "))))\n");
            } else {
                stringBuffer.append("WHERE " + string7 + "))\n");
            }
        }
        return stringBuffer.toString();
    }

    protected static String genColListForIn(String[] stringArray, Set<Integer> set, String[] stringArray2, String[] stringArray3, boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            if (set.contains(i)) {
                QueryUtils.appendToList(stringBuffer, stringArray2[i], ", ", "");
                continue;
            }
            QueryUtils.appendToList(stringBuffer, stringArray[i], ", ", "");
        }
        if (bl) {
            String string2 = "";
            StringBuffer stringBuffer2 = new StringBuffer("");
            if (stringArray.length > 1) {
                stringBuffer2.append("COALESCE(");
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = stringArray2[i].startsWith("'") ? stringArray3[i] : QueryUtils.buildSafeToChar(stringArray3[i]);
                    QueryUtils.appendToList(stringBuffer2, string2, ",", "COALESCE(");
                }
                stringBuffer2.append(")");
            } else {
                stringBuffer2.append(stringArray3[0]);
            }
            QueryUtils.appendToList(stringBuffer, " NVL2(" + stringBuffer2.toString() + ",1," + string + ")", ", ", "");
        } else if (string != null) {
            QueryUtils.appendToList(stringBuffer, string, ", ", "");
        }
        return stringBuffer.toString();
    }

    protected static String buildAllColCoalesce(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (stringArray.length > 1) {
            String string = "";
            stringBuffer.append("COALESCE(");
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray2[i].startsWith("'") ? stringArray[i] : QueryUtils.buildSafeToChar(stringArray[i]);
                QueryUtils.appendToList(stringBuffer, string, ",", "COALESCE(");
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(stringArray[0]);
        }
        return stringBuffer.toString();
    }

    protected static String buildSafeToChar(String string) {
        return "TO_CHAR(" + string + "," + "'TM9'" + "," + "'NLS_Numeric_Characters=''.,'''" + ")";
    }

    protected static int computeNonVnTermLen(String string, String string2) {
        int n = 0;
        int n2 = 0;
        if (string != null && string.length() > 0) {
            n = string.length() + 1;
        }
        if (string2 != null && string2.length() > 0) {
            n2 = string2.length() + 4;
        }
        return n + n2 + 2;
    }

    protected static int computeConstTermLen(String string, String string2, String string3) {
        return string.length() + QueryUtils.computeNonVnTermLen(string2, string3);
    }

    protected static String computeClobTermLen(String string, String string2, String string3) {
        return "(NVL(DBMS_LOB.GETLENGTH(TO_CLOB(" + string + ")),0)+NVL(LENGTH(" + string2 + ")+2,0)+NVL(LENGTH(" + string3 + ")+4,0)+2)";
    }

    protected static String shortenConstVNforTerm(String string, String string2, String string3) {
        int n = 4000 - QueryUtils.computeNonVnTermLen(string2, string3);
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    protected static String shortenVNforTerm(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "NULL";
        }
        if (string3 == null) {
            string3 = "NULL";
        }
        return "TO_CHAR(SUBSTR(" + string + ",1,(" + 4000 + "-(NVL(length(" + string3 + ")+4,0)+NVL(length(" + string2 + ")+1,0)+2))))";
    }

    protected static String shortenClobForTerm(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "NULL";
        }
        if (string3 == null) {
            string3 = "NULL";
        }
        return "TO_CHAR(DBMS_LOB.SUBSTR(TO_CLOB(" + string + "),(" + 4000 + "-(NVL(length(" + string3 + ")+4,0)+NVL(length(" + string2 + ")+1,0)+2)),1))";
    }

    protected static String escapeSingleQuotes(String string) {
        return string.replace("'", "''");
    }

    public static String escapeSpecialChars(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        char c = ' ';
        block10: for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String splitClobInChunks(String string, int n) throws SQLException {
        String string2 = "(";
        int n2 = 0;
        while (n2 + n < string.length()) {
            String string3 = string.substring(n2, n2 + n);
            string3 = QueryUtils.enquoteLiteral(string3);
            string2 = string2 + "to_clob(" + string3 + ") ||";
            n2 += n;
        }
        string2 = string2 + "to_clob(" + QueryUtils.enquoteLiteral(string.substring(n2)) + "))";
        return string2;
    }

    public static String wrapFor4kVc(String string) {
        return "SUBSTRB(" + string + ",1," + 4000 + ")";
    }

    protected static List<Set<Integer>> genMaskingSets(List<Integer> list) {
        int n = Double.valueOf(Math.pow(2.0, list.size())).intValue();
        ArrayList<Set<Integer>> arrayList = new ArrayList<Set<Integer>>(n - 1);
        for (int i = 1; i < n; ++i) {
            char[] cArray = String.format("%1$" + list.size() + "s", Integer.toBinaryString(i)).replace(' ', '0').toCharArray();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray[j] != '1') continue;
                hashSet.add(list.get(j));
            }
            arrayList.add(hashSet);
        }
        return arrayList;
    }

    protected static String genVNameSubstr(String string, String string2, String string3, String string4) {
        return "NVL2(" + string2 + ",to_char(" + QueryUtils.shortenClobForTerm(string2, string3, string4) + ")," + string + ")";
    }

    protected static String extractHint0Contents(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            return null;
        }
        Matcher matcher = HINT0PATTERN.matcher(string);
        boolean bl = false;
        while (matcher.find()) {
            if (matcher.groupCount() != 3) {
                QueryUtils.log("ERROR: HINT0 pattern needs to be fixed. Unable to search for HINT0 hints");
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(matcher.group(2));
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return stringBuilder.toString();
    }

    protected static String buildInList(String string, long[] lArray) {
        String string2 = "";
        if (lArray != null && lArray.length > 0) {
            string2 = " " + string + " IN (";
            for (int i = 0; i < lArray.length; ++i) {
                if (i > 0) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + lArray[i];
            }
            string2 = string2 + ") ";
        }
        return string2;
    }

    public static void processUnDefVars(Filter filter, Set<String> set, Map<String, String> map) throws RDFException {
        if (filter != null) {
            UnDefVarFilterOptimizer unDefVarFilterOptimizer = new UnDefVarFilterOptimizer(set, map);
            try {
                filter.applyFilterOptimizer(unDefVarFilterOptimizer);
            }
            catch (FilterException filterException) {
                throw new RDFException(filterException.getMessage());
            }
        }
    }

    protected static String buildUnpivot(Set<String> set, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "$RDFTERM";
        if (bl) {
            string2 = "$RDFVID";
        }
        stringBuffer.append("SELECT TERM").append(string2).append("\nFROM (SELECT DISTINCT ");
        int n = 0;
        for (String string3 : set) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string3).append(string2).append(" AS TERM").append(n);
            ++n;
        }
        stringBuffer.append(" FROM(").append(string).append("))");
        stringBuffer.append("\nUNPIVOT INCLUDE NULLS\n");
        stringBuffer.append("((TERM").append(string2).append(")\n FOR (c) IN (");
        for (n = 0; n < set.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("(TERM").append(n).append(")");
        }
        stringBuffer.append("))");
        return stringBuffer.toString();
    }

    protected static String buildOptTerm(String[] stringArray) {
        String string = "";
        string = Integer.parseInt(stringArray[7]) == 28 ? stringArray[9] : "sem_apis.compose_rdf_term(" + stringArray[0] + "," + stringArray[1] + "," + stringArray[4] + "," + stringArray[5] + ")";
        return string;
    }

    protected static String buildOptNumber(String[] stringArray) {
        String string = "";
        string = Integer.parseInt(stringArray[7]) == 3 || Integer.parseInt(stringArray[7]) == 29 ? stringArray[9] : "sem_apis.getV$NumericVal(" + stringArray[1] + "," + stringArray[2] + "," + stringArray[3] + "," + stringArray[4] + "," + stringArray[5] + ")";
        return string;
    }

    static {
        SCHEMA_PROPERTIES.add("http://www.w3.org/2000/01/rdf-schema#subClassOf");
        SCHEMA_PROPERTIES.add("http://www.w3.org/2000/01/rdf-schema#subPropertyOf");
        SCHEMA_PROPERTIES.add("http://www.w3.org/2004/02/skos/core#broader");
        SCHEMA_PROPERTIES.add("http://www.w3.org/2004/02/skos/core#narrower");
        UNSELECTIVE_PROPERTIES = new HashSet<String>();
        UNSELECTIVE_PROPERTIES.add("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        SPATIAL_FUNCTIONS = new String[]{"http://www.opengis.net/def/function/geosparql/", "http://www.opengis.net/def/function/geosparql/relate", "http://www.opengis.net/def/function/geosparql/distance", "http://www.opengis.net/def/function/geosparql/buffer", "http://www.opengis.net/def/function/geosparql/envelope", "http://www.opengis.net/def/function/geosparql/convexHull", "http://www.opengis.net/def/function/geosparql/intersection", "http://www.opengis.net/def/function/geosparql/union", "http://www.opengis.net/def/function/geosparql/difference", "http://www.opengis.net/def/function/geosparql/symDifference", "http://www.opengis.net/def/function/geosparql/getSRID", "http://www.opengis.net/def/function/geosparql/boundary", "http://www.opengis.net/def/function/geosparql/sfEquals", "http://www.opengis.net/def/function/geosparql/sfDisjoint", "http://www.opengis.net/def/function/geosparql/sfIntersects", "http://www.opengis.net/def/function/geosparql/sfTouches", "http://www.opengis.net/def/function/geosparql/sfCrosses", "http://www.opengis.net/def/function/geosparql/sfWithin", "http://www.opengis.net/def/function/geosparql/sfContains", "http://www.opengis.net/def/function/geosparql/sfOverlaps", "http://xmlns.oracle.com/rdf/geo/withinDistance", "http://xmlns.oracle.com/rdf/geo/idxWithinDistance", "http://xmlns.oracle.com/rdf/geo/funcWithinDistance", "http://xmlns.oracle.com/rdf/geo/relate", "http://xmlns.oracle.com/rdf/geo/idxRelate", "http://xmlns.oracle.com/rdf/geo/funcRelate", "http://xmlns.oracle.com/rdf/geo/nearestNeighbor", "http://xmlns.oracle.com/rdf/geo/area", "http://xmlns.oracle.com/rdf/geo/centroid", "http://xmlns.oracle.com/rdf/geo/length", "http://xmlns.oracle.com/rdf/geo/maxMbrOrdinate", "http://xmlns.oracle.com/rdf/geo/minMbrOrdinate", "http://xmlns.oracle.com/rdf/geo/distance", "http://xmlns.oracle.com/rdf/geo/buffer", "http://xmlns.oracle.com/rdf/geo/convexHull", "http://xmlns.oracle.com/rdf/geo/intersection", "http://xmlns.oracle.com/rdf/geo/union", "http://xmlns.oracle.com/rdf/geo/difference", "http://xmlns.oracle.com/rdf/geo/xor", "http://xmlns.oracle.com/rdf/geo/mbr", "http://xmlns.oracle.com/rdf/geo/sdoJoin", "http://xmlns.oracle.com/rdf/geo/sdoDistJoin", "http://xmlns.oracle.com/rdf/geo/getSRID", "http://xmlns.oracle.com/rdf/geo/aggrCentroid", "http://xmlns.oracle.com/rdf/geo/aggrConcatLines", "http://xmlns.oracle.com/rdf/geo/aggrConvexhull", "http://xmlns.oracle.com/rdf/geo/aggrMBR", "http://xmlns.oracle.com/rdf/geo/aggrUnion"};
        ORACLE_TEXT_FUNCTIONS = new String[]{"http://xmlns.oracle.com/rdf/textContains", "http://xmlns.oracle.com/rdf/textScore"};
        UNBOUND_PROPERTY_PATH_NODES = new int[]{69, 70};
    }
}

