/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintEngine;
import oracle.spatial.rdf.server.HintEngineAdapter;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.HintZeroHintGenerator;
import oracle.spatial.rdf.server.PPIRINode;
import oracle.spatial.rdf.server.PPModNode;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SimplePPSQLTransVisitor;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class SimpleBGP
implements SPARQLBGP {
    private static final String WITH_ALIAS = "BASIC_TRIPLES";
    private static final String PUSHED_BGP_ALIAS = "PBGP";
    private static final String GRAPH_ALIAS = "VG";
    private static final String NO_INDEX_HINT = "NO_INDEX";
    private static final String BLOOM_FILTER_HINT = "PX_JOIN_FILTER";
    private static final String LAT_PP_TAB_FUNC = "mdsys.sdo_rdf.sdo_rdf_pp";
    private BasicGraphPattern bgp;
    private Map<String, String> varset;
    private List<SPARQLTriplesBlock> myTrips;
    private Set<String> variablesToBeJoined;
    private Set<ASTTripleAtom.BindVar> bindVarsToJoin;
    private List<Filter> filters;
    private Map<String, Integer> hint0leadPosMap;
    private SQLGenContext ctx = null;
    private String userHint = "";
    private Set<String> projectVars;
    private Set<String> leftJoinVars;
    private Map<String, String> varAliases;
    private Map<String, String> varIDs;
    private Map<String, String> withMap;
    private int id;
    private boolean m_bLog = false;
    private HintGenerator hintG;
    private String sqlHint;
    private Set<String> lexVars;
    private Set<ASTTripleAtom.BindVar> bindVars;
    private Map<Hint.QueryOption, String> queryOptions;
    private String link_tab = "BASIC_TRIPLES";
    private String subjectCol = "START_NODE_ID";
    private String predicateCol = "P_VALUE_ID";
    private String canonObjCol = "CANON_END_NODE_ID";
    private String exactObjCol = "END_NODE_ID";
    private String gidCol = "G_ID";
    private String values_tab;
    private String vname_col = "VALUE_NAME";
    private String vid_col = "VALUE_ID";
    private String vtype_col = "VALUE_TYPE";
    private String prefix_col = "VNAME_PREFIX";
    private String suffix_col = "VNAME_SUFFIX";
    private String litType_col = "LITERAL_TYPE";
    private String langType_col = "LANGUAGE_TYPE";
    private String longLit_col = "LONG_VALUE";
    private String vid_alias = "$RDFVID";
    private String vtype_alias = "$RDFVTYP";
    private String prefix_alias = "$_PREFIX";
    private String suffix_alias = "$_SUFFIX";
    private String litType_alias = "$RDFLTYP";
    private String langType_alias = "$RDFLANG";
    private String longLit_alias = "$RDFCLOB";
    private String term_alias = "$RDFTERM";
    private SPARQLBGP pushedBGP = null;
    private String pushedBGPAlias = "";
    private boolean hasPushedBGP = false;
    private boolean graphQuery = false;
    private ASTTripleAtom activeGraph = null;
    private String graphVar = null;
    private boolean disconnected = false;
    private List<String> optLinkAliasList;
    private boolean distinctCLOB = false;
    private Set<String> needCLOBVars = null;
    private List<List<SPMColDesc>> svpClusterList = null;
    private List<String> svpBestTabNameList = null;
    private Map<String, String> svpColMap = null;
    private Set<String> svpAliasSet = null;
    private int minClusterSize = 1;
    private List<List<SPMColDesc>> pcnChainList = null;
    private Map<String, String> pcnColMap = null;
    private Set<String> pcnAliasSet = null;
    private List<SPMColDesc> mvpPredList = null;
    private Map<String, String> mvpColMap = null;
    private Set<String> mvpAliasSet = null;
    private Map<String, String> spmValColMap = null;
    private Set<String> auxValueVars = null;
    private Map<String, String> auxVarMappedAliases = null;
    private Set<Integer> spmCoveredTripleIds = null;
    private Set<String> excludedTripleTabs = null;
    private Set<String> excludedValueTabs = null;
    private int localSelectivity = 0;
    private int globalSelectivity = 0;

    private static void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    private static String getNonExistingTermCondition(String string) {
        return " IN (SELECT NULL FROM " + QueryUtils.getLocalNamespaceDollarName(string) + " where rownum < 1)";
    }

    public SimpleBGP(int n, SQLGenContext sQLGenContext) {
        this.id = n;
        this.ctx = sQLGenContext;
        this.bgp = new BasicGraphPattern();
        this.varset = new HashMap<String, String>();
        this.myTrips = new ArrayList<SPARQLTriplesBlock>();
        this.variablesToBeJoined = new HashSet<String>();
        this.bindVarsToJoin = new HashSet<ASTTripleAtom.BindVar>();
        this.leftJoinVars = new HashSet<String>();
        this.filters = new ArrayList<Filter>();
        this.hint0leadPosMap = new HashMap<String, Integer>();
        this.projectVars = new HashSet<String>();
        this.varAliases = new HashMap<String, String>();
        this.varIDs = new HashMap<String, String>();
        this.withMap = new HashMap<String, String>();
        this.queryOptions = new HashMap<Hint.QueryOption, String>();
        this.userHint = null;
        this.hintG = sQLGenContext.useOldHintGenerator ? new HintZeroHintGenerator(sQLGenContext, true) : new HintEngineAdapter(HintEngine.getDefaultInstance(), sQLGenContext);
        this.hintG.setSPARQLBGP(this);
        this.sqlHint = "";
        this.graphQuery = false;
        this.activeGraph = null;
        this.disconnected = false;
        this.optLinkAliasList = null;
        this.lexVars = new HashSet<String>();
        this.bindVars = new HashSet<ASTTripleAtom.BindVar>();
        this.distinctCLOB = false;
        this.needCLOBVars = new HashSet<String>();
        this.svpClusterList = null;
        this.svpColMap = null;
        this.svpAliasSet = null;
        this.minClusterSize = 1;
        this.pcnChainList = null;
        this.pcnColMap = null;
        this.pcnAliasSet = null;
        this.spmCoveredTripleIds = null;
        this.mvpPredList = null;
        this.mvpColMap = null;
        this.mvpAliasSet = null;
        this.excludedTripleTabs = null;
        this.spmValColMap = null;
        this.excludedValueTabs = null;
        this.auxValueVars = null;
        this.auxVarMappedAliases = null;
        this.localSelectivity = 0;
        this.globalSelectivity = 0;
        this.values_tab = QueryUtils.getLocalValueDollarName(sQLGenContext.clnPfxForRdfObjName);
        if (sQLGenContext.localValues != null) {
            this.values_tab = sQLGenContext.localValues;
        }
        this.initLinkTab();
    }

    @Override
    public SPARQLBGP shallowClone() throws RDFException {
        SimpleBGP simpleBGP = new SimpleBGP(this.id, this.ctx);
        for (SPARQLTriplesBlock sPARQLTriplesBlock : this.myTrips) {
            simpleBGP.addTriplesBlock(sPARQLTriplesBlock);
        }
        if (this.hasPushedBGP) {
            SPARQLBGP sPARQLBGP = this.pushedBGP.shallowClone();
            simpleBGP.pushBGP(sPARQLBGP, this.pushedBGPAlias);
        }
        return simpleBGP;
    }

    @Override
    public void setIsGraphQuery(boolean bl) {
        this.graphQuery = bl;
        this.initLinkTab();
    }

    @Override
    public boolean isGraphQuery() {
        return this.graphQuery;
    }

    @Override
    public void setActiveGraph(ASTTripleAtom aSTTripleAtom) {
        this.activeGraph = aSTTripleAtom;
        if (this.activeGraph.type == 0) {
            this.graphVar = this.activeGraph.name.toUpperCase();
        } else if (this.activeGraph.type == 9) {
            ASTTripleAtom.BindVar bindVar = new ASTTripleAtom.BindVar(aSTTripleAtom.bindId, aSTTripleAtom.name);
            this.bindVars.add(bindVar);
            this.graphVar = bindVar.bvName;
        }
    }

    @Override
    public void addUserHint(String string) {
        this.userHint = string;
        this.hintG.setUserHint(string);
    }

    @Override
    public String getJoinHint(String string, String string2) {
        return this.hintG.generateJoinHint(string, string2);
    }

    @Override
    public String getAntiJoinHint() {
        return this.hintG.generateAntiJoinHint();
    }

    @Override
    public String getValueJoinHint(Collection<String> collection, String string) {
        return this.hintG.generateValueJoinHint(collection, string);
    }

    @Override
    public void addTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) {
        this.myTrips.add(sPARQLTriplesBlock);
        this.bgp.addTriplesBlock(sPARQLTriplesBlock, this.ctx);
        this.populateFromTBs();
    }

    @Override
    public List<SPARQLTriplesBlock> getTriplesBlocks() {
        return this.myTrips;
    }

    @Override
    public int getNumTriples() {
        return this.bgp.numTriples();
    }

    @Override
    public boolean addFilter(Filter filter) {
        boolean bl = true;
        if (this.ctx.allRejectFilter) {
            bl = false;
        } else {
            Set<String> set = filter.getVars();
            for (String string : set) {
                if (!this.shouldRejectVar(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.filters.add(filter);
            }
        }
        return bl;
    }

    @Override
    public Set<String> addProjectVars(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (this.shouldRejectVar(string)) {
                hashSet.add(string);
                continue;
            }
            this.projectVars.add(string);
        }
        return hashSet;
    }

    @Override
    public boolean addProjectVar(String string) {
        boolean bl = true;
        if (this.shouldRejectVar(string)) {
            bl = false;
        } else {
            this.projectVars.add(string);
        }
        return bl;
    }

    @Override
    public Set<String> getAllLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.lexVars);
        hashSet.addAll(this.getRequiredLexVars());
        if (this.hasPushedBGP) {
            hashSet.addAll(this.pushedBGP.getAllLexVars());
        }
        return hashSet;
    }

    @Override
    public Set<String> getRequiredLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if ((this.ctx.lexJoinFlags & 1) == 1) {
            hashSet.addAll(this.getBGPVars());
            if (this.hasPushedBGP) {
                hashSet.addAll(this.pushedBGP.getRequiredLexVars());
            }
        }
        return hashSet;
    }

    @Override
    public boolean addLexVar(String string) {
        boolean bl = true;
        if (this.shouldRejectVar(string)) {
            bl = false;
        } else {
            this.lexVars.add(string);
        }
        return bl;
    }

    @Override
    public Set<String> addLexVars(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!this.shouldRejectVar(string)) {
                this.lexVars.add(string);
                continue;
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public void pushBGP(SPARQLBGP sPARQLBGP, String string) {
        this.hasPushedBGP = true;
        this.pushedBGP = sPARQLBGP;
        this.pushedBGPAlias = string;
    }

    @Override
    public boolean needsParentBGPPushDown() {
        return this.hintG.specifiesBGPPushDown();
    }

    @Override
    public boolean verifyPushedBGP() {
        boolean bl = true;
        if ((this.ctx.contextFlags & 4) == 4 && this.graphVar != null && this.getAllLexVars().contains(this.graphVar)) {
            this.hasPushedBGP = false;
            this.pushedBGP = null;
            this.pushedBGPAlias = "";
            bl = false;
        }
        return bl;
    }

    @Override
    public void setLocalSelectivity() {
        this.setDisconnected();
        this.localSelectivity = this.isSelective() ? 1 : 0;
    }

    @Override
    public int getLocalSelectivity() {
        return this.localSelectivity;
    }

    @Override
    public void setGlobalSelectivity(int n) {
        this.globalSelectivity = QueryUtils.combineSelectivity(this.localSelectivity, n);
    }

    @Override
    public void addJoinVarsForHint(Set<String> set) {
        this.leftJoinVars.addAll(set);
    }

    @Override
    public Set<String> getJoinVarsForHint() {
        return Collections.unmodifiableSet(this.leftJoinVars);
    }

    @Override
    public Set<String> getBindVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            hashSet.add(bindVar.bvName);
        }
        return hashSet;
    }

    @Override
    public void popSPMAuxTabsInfo() {
        this.processSPMInfo();
    }

    @Override
    public Set<String> getSPMAuxValueVars() {
        return this.auxValueVars;
    }

    @Override
    public void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2) {
        QueryUtils.genOuterSelectComponents(set, set2, map, stringArray, stringArray2, map2, this.values_tab);
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3) {
        return QueryUtils.buildSubQForCLOB(string, string2, string3, this.values_tab);
    }

    @Override
    public String distinctGraphsQuery(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.ctx.optDistinctGQuery != null && !this.ctx.disableGMVOpt) {
            stringBuffer.append("SELECT " + this.gidCol);
            stringBuffer.append(" AS ").append(string).append(this.vid_alias).append("\n");
            stringBuffer.append("FROM (").append(this.ctx.optDistinctGQuery).append(")");
        } else {
            stringBuffer.append("SELECT DISTINCT ").append(this.gidCol);
            stringBuffer.append(" AS ").append(string).append(this.vid_alias).append("\n");
            stringBuffer.append("FROM ").append(this.link_tab).append("\n");
            stringBuffer.append("WHERE ").append(this.gidCol).append(" IS NOT NULL");
        }
        if (bl) {
            String string2 = "VG." + this.prefix_col + " || " + GRAPH_ALIAS + "." + this.suffix_col;
            String string3 = "R." + string + this.vid_alias;
            String string4 = "VG." + this.vtype_col;
            String string5 = "VG." + this.prefix_col;
            String string6 = "VG." + this.suffix_col;
            String string7 = "VG." + this.litType_col;
            String string8 = "VG." + this.langType_col;
            String string9 = "VG." + this.longLit_col;
            String string10 = this.buildRDFTerm(string2, string4, string7, string8);
            String string11 = "SELECT " + string2 + " AS " + string + ", " + string3 + " AS " + string + this.vid_alias + ", " + string4 + " AS " + string + this.vtype_alias + ", " + string5 + " AS " + string + this.prefix_alias + ", " + string6 + " AS " + string + this.suffix_alias + ", " + string7 + " AS " + string + this.litType_alias + ", " + string8 + " AS " + string + this.langType_alias + ", " + string9 + " AS " + string + this.longLit_alias + "," + string10 + " AS " + string + this.term_alias + "\nFROM (";
            stringBuffer.insert(0, string11);
            stringBuffer.append(") R,\n").append(this.values_tab).append(" ").append(GRAPH_ALIAS).append("\n");
            stringBuffer.append("WHERE R.").append(string).append(this.vid_alias);
            stringBuffer.append("=").append(GRAPH_ALIAS).append(".").append(this.vid_col);
        }
        return stringBuffer.toString();
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public Set<String> getBGPVars() {
        Set<String> set = this.getTriplePatternVars(false);
        if (this.graphQuery && this.activeGraph != null && (this.activeGraph.type == 0 || this.activeGraph.type == 9)) {
            set.add(this.activeGraph.name.toUpperCase());
        }
        return set;
    }

    @Override
    public Set<String> getBGPAndPushedVars() {
        Set<String> set = this.getBGPVars();
        if (this.hasPushedBGP) {
            set.addAll(this.pushedBGP.getBGPAndPushedVars());
        }
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        Set<String> set = this.getTriplePatternVars(false);
        if (this.graphVar != null && (this.ctx.contextFlags & 4) == 0) {
            set.add(this.graphVar);
        }
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        Set<String> set = this.getDefiniteBoundVars();
        if (this.hasPushedBGP) {
            set.addAll(this.pushedBGP.getDefiniteBoundAndPushedVars());
        }
        return set;
    }

    @Override
    public Set<String> getProjectVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.projectVars);
        for (String string : this.getAllLexVars()) {
            if (this.shouldRejectVar(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public Set<String> getHintVars() {
        return this.hintG.getHintVars();
    }

    @Override
    public boolean refsNonExistingTerm() {
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getSubject().exists() && triplesBlock.getPredicate().exists() && triplesBlock.getObject().exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toSQL() throws RDFException {
        if (!this.ctx.disableLocalLexFilterOpt) {
            this.clearLexVarsFromFilters();
        }
        this.popVarsToJoin();
        this.extractVarAliases();
        this.updateVarAliasesForAuxValues();
        this.addAutoOptimizerHints();
        this.hintG.setSPMInfo(this.excludedTripleTabs, this.excludedValueTabs, this.svpAliasSet, this.mvpAliasSet, this.pcnAliasSet);
        this.sqlHint = this.hintG.generateHint();
        if (this.ctx.useBloomFilter) {
            int n = 0;
            boolean bl = false;
            for (TriplesBlock object2 : this.bgp.TBList) {
                if (object2.getPredicate().getName().equalsIgnoreCase("http://www.w3.org/2002/07/owl#sameAs")) {
                    if (!bl) {
                        this.sqlHint = this.sqlHint.length() == 0 ? "/*+ " : this.sqlHint.replace("*/", "");
                    }
                    bl = true;
                    this.sqlHint = this.sqlHint.concat("NO_INDEX(T" + n + ") ");
                    this.sqlHint = this.sqlHint.concat("PX_JOIN_FILTER(T" + n + ") ");
                }
                ++n;
            }
            if (bl) {
                this.sqlHint = this.sqlHint.concat("*/ ");
            }
        }
        this.queryOptions = this.hintG.getQueryOptions();
        this.initLinkTab();
        if (!this.queryOptions.containsKey((Object)Hint.QueryOption.NO_OPT_TRANS_FOR_LEADING)) {
            this.hint0leadPosMap = this.hintG.getTransOrderMap();
        }
        this.genOptGIDJoinList();
        this.extractVarIDs();
        if (this.ctx.startPPOpt) {
            this.optimizePPStartNodes();
        }
        List<Filter> list = this.getSecondaryFilters();
        List<String[]> list2 = this.getAncillaryOps();
        String string = this.buildWithClause();
        String string2 = this.buildSelect(list.size() > 0, this.isGraphQuery() && this.getNumTriples() == 0 && (this.ctx.optDistinctGQuery == null || this.ctx.disableGMVOpt), false, list2);
        String string3 = this.buildFrom();
        String string4 = this.buildWhere();
        String string5 = (String)string + string2 + "\n" + string3 + "\n" + string4;
        String string6 = this.applyFilters(string5, this.getBGPAndPushedVars(), this.getProjectVars(), this.getAllLexVars(), this.getBGPVars());
        String string7 = "";
        if (this.isGraphQuery() && this.getNumTriples() == 0 && this.graphVar == null) {
            string7 = " AND ROWNUM < 2";
        }
        string5 = string5 + string6 + string7;
        if (this.distinctCLOB) {
            string5 = this.wrapForClobs(string5);
        }
        if (list.size() > 0) {
            string5 = this.wrapForSecondaryFilters(list, string5);
        }
        return string5;
    }

    private void clearLexVarsFromFilters() {
        for (Filter filter : this.filters) {
            if (filter.containsExists()) continue;
            filter.clearLexVars();
        }
    }

    private List<Filter> getSecondaryFilters() {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.filters) {
            Filter filter2 = filter.extractSecondaryFilter();
            if (filter2 == null) continue;
            arrayList.add(filter2);
        }
        return arrayList;
    }

    private List<String[]> getAncillaryOps() throws RDFException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (Filter filter : this.filters) {
            arrayList.addAll(filter.extractAncInfoForPrim());
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isDisconnected() {
        TriplesBlock triplesBlock = null;
        for (TriplesBlock object2 : this.bgp.TBList) {
            if (!object2.getSubject().isVariable() && !object2.getSubject().isBindVariable() && !object2.getPredicate().isVariable() && !object2.getPredicate().isBindVariable() && !object2.getObject().isVariable() && !object2.getObject().isBindVariable()) continue;
            triplesBlock = object2;
            break;
        }
        if (triplesBlock == null) {
            return false;
        }
        HashSet hashSet = new HashSet();
        Stack<TriplesBlock> stack = new Stack<TriplesBlock>();
        HashSet<TriplesBlock> hashSet2 = new HashSet<TriplesBlock>();
        TriplesBlock triplesBlock2 = null;
        Object var6_7 = null;
        Object var7_8 = null;
        stack.push(triplesBlock);
        hashSet2.add(triplesBlock);
        while (!stack.isEmpty()) {
            triplesBlock2 = (TriplesBlock)stack.pop();
            for (TriplesBlock.Element element : new TriplesBlock.Element[]{triplesBlock2.getSubject(), triplesBlock2.getPredicate(), triplesBlock2.getObject()}) {
                String string = element.getName();
                if (element.isVariable() || element.isBindVariable()) {
                    hashSet.add(string);
                }
                for (TriplesBlock triplesBlock3 : this.bgp.TBList) {
                    if ((!triplesBlock3.getSubject().isVariable() && !triplesBlock3.getSubject().isBindVariable() && triplesBlock3.getSubject().getCanonicalID() == null || !triplesBlock3.getSubject().getName().equals(string)) && (!triplesBlock3.getPredicate().isVariable() && !triplesBlock3.getPredicate().isBindVariable() || !triplesBlock3.getPredicate().getName().equals(string)) && (!triplesBlock3.getObject().isVariable() && !triplesBlock3.getObject().isBindVariable() && triplesBlock3.getObject().getCanonicalID() == null || !triplesBlock3.getObject().getName().equals(string)) || hashSet2.contains(triplesBlock3)) continue;
                    hashSet2.add(triplesBlock3);
                    stack.push(triplesBlock3);
                }
            }
        }
        TriplesBlock.Element[] elementArray = this.getTriplePatternVars(true);
        for (String string : elementArray) {
            void var10_16;
            if (this.isBindVar(string)) {
                String string2 = this.getBindVar(string).getBVStr();
            }
            if (hashSet.contains(var10_16)) continue;
            return true;
        }
        return false;
    }

    private void setDisconnected() {
        this.disconnected = this.isDisconnected();
    }

    private boolean shouldRejectVar(String string) {
        boolean bl = false;
        if (!this.getDefiniteBoundVars().contains(string) && this.getBGPVars().contains(string)) {
            bl = true;
        }
        return bl;
    }

    private void initLinkTab() {
        String string = "(" + this.ctx.defaultGraph + ")";
        if (this.graphQuery) {
            string = "(" + this.ctx.namedGraphs + ")";
        }
        if (this.ctx.vmViewName != null) {
            this.link_tab = this.ctx.vmDefault;
            if (this.graphQuery) {
                this.link_tab = this.ctx.vmNamed;
            }
        } else if (this.queryOptions.containsKey((Object)Hint.QueryOption.USE_WITH)) {
            this.link_tab = WITH_ALIAS;
            this.withMap.put(this.link_tab, string);
        } else {
            this.link_tab = string;
        }
    }

    private void genOptGIDJoinList() {
        this.optLinkAliasList = new ArrayList<String>(this.bgp.TBList.size());
        boolean bl = false;
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        if (!this.hint0leadPosMap.isEmpty()) {
            for (Map.Entry<String, Integer> entry : this.hint0leadPosMap.entrySet()) {
                if (!treeMap.containsKey(entry.getValue())) {
                    if (!this.isValidTabAlias(entry.getKey().toUpperCase())) continue;
                    treeMap.put(entry.getValue(), entry.getKey().toUpperCase());
                    continue;
                }
                bl = true;
                break;
            }
        }
        if (!bl && !this.hint0leadPosMap.isEmpty() && (this.ctx.ngJoinFlags & 4) == 0) {
            for (Map.Entry<String, Integer> entry : treeMap.entrySet()) {
                this.optLinkAliasList.add((String)((Object)entry.getValue()));
            }
        }
        for (int i = 0; i < this.bgp.TBList.size(); ++i) {
            if (this.optLinkAliasList.contains("T" + i)) continue;
            this.optLinkAliasList.add("T" + i);
        }
    }

    private boolean isValidTabAlias(String string) {
        try {
            if (!string.startsWith("T")) {
                return false;
            }
            int n = Integer.parseInt(string.substring(1));
            if (n < 0 || n >= this.bgp.TBList.size()) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean wantGIDCoalesce() {
        boolean bl = (this.ctx.ngJoinFlags & 1) == 0 && (!this.disconnected || (this.ctx.ngJoinFlags & 2) > 0);
        return bl;
    }

    private String buildGidExpr(boolean bl) {
        Object object;
        String string = "##";
        String string2 = null;
        if (this.graphVar != null) {
            string = this.graphVar;
        } else if (this.isGraphQuery() && this.activeGraph.type == 1) {
            string2 = this.ctx.URImap.get(this.activeGraph.name);
        } else if (this.isGraphQuery() && this.activeGraph.type == 9) {
            object = this.getBindVar(string);
            string2 = ((ASTTripleAtom.BindVar)object).getIdCol();
        }
        object = new HashSet();
        if (this.hasPushedBGP) {
            object = this.pushedBGP.getBGPAndPushedVars();
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        n += this.bgp.TBList.size();
        if (object.contains(string)) {
            ++n;
        }
        if ((this.ctx.contextFlags & 4) > 0) {
            ++n;
        }
        if (((this.ctx.contextFlags & 4) > 0 || this.wantGIDCoalesce() && bl) && n > 1) {
            stringBuffer.append("COALESCE(");
            for (int i = 0; i < this.bgp.TBList.size(); ++i) {
                QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + i + "." + this.gidCol), ", ", "COALESCE(");
            }
            if (object.contains(string)) {
                QueryUtils.appendToList(stringBuffer, "PBGP." + string + this.vid_alias, ", ", "COALESCE(");
            } else if (string2 != null) {
                QueryUtils.appendToList(stringBuffer, string2, ", ", "COALESCE(");
            }
            if ((this.ctx.contextFlags & 4) > 0) {
                if (bl) {
                    QueryUtils.appendToList(stringBuffer, "0", ", ", "COALESCE(");
                } else {
                    QueryUtils.appendToList(stringBuffer, "NULL", ", ", "COALESCE(");
                }
            }
            stringBuffer.append(")");
        } else if (this.optLinkAliasList != null && !this.optLinkAliasList.isEmpty()) {
            stringBuffer.append(this.getSPMOptimizedCol(this.optLinkAliasList.get(0) + "." + this.gidCol));
        } else {
            stringBuffer.append(this.getSPMOptimizedCol("T0." + this.gidCol));
        }
        return stringBuffer.toString();
    }

    private String buildGidNVL(String string, String string2) {
        String string3 = this.getSPMOptimizedCol(string);
        if ((this.ctx.contextFlags & 4) > 0) {
            string3 = "NVL(" + string3 + "," + string2 + ")";
        }
        return string3;
    }

    private Set<String> getTriplePatternVars(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.varset.keySet()) {
            if (!bl && string.startsWith("PP$S$")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public String buildWithClause() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.withMap != null && !this.withMap.isEmpty()) {
            stringBuffer.append("WITH ");
            boolean bl = false;
            for (Map.Entry<String, String> entry : this.withMap.entrySet()) {
                if (bl) {
                    stringBuffer.append(",\n");
                }
                bl = true;
                stringBuffer.append(entry.getKey()).append(" AS (").append(entry.getValue()).append(")");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String wrapForClobs(String string) {
        StringBuffer stringBuffer = new StringBuffer("SELECT R.*");
        String string2 = "";
        for (String string3 : this.needCLOBVars) {
            string2 = this.lexVars.contains(string3) ? "TO_CLOB(NULL)" : this.buildSubQForCLOB(string3, "R." + string3 + this.vid_alias, "R." + string3 + this.prefix_alias);
            QueryUtils.appendToList(stringBuffer, string2 + " AS " + string3 + this.longLit_alias, "\n, ", "");
        }
        return stringBuffer + "\nFROM (" + string + ") R";
    }

    private String wrapForSecondaryFilters(List<Filter> list, String string) throws RDFException {
        HashSet<String> hashSet = new HashSet<String>();
        for (Filter object2 : list) {
            hashSet.addAll(object2.getSecondaryJoinVars());
        }
        HashMap hashMap = new HashMap();
        Map<String, String> map = Collections.emptyMap();
        int n = 0;
        for (String string2 : hashSet) {
            hashMap.put(string2, "V" + n);
            ++n;
        }
        for (String string3 : this.getBGPAndPushedVars()) {
            if (hashMap.containsKey(string3)) continue;
            hashMap.put(string3, "R." + string3);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("SELECT R.*\n");
        stringBuffer.append("FROM\n");
        stringBuffer.append("(").append(string).append(") R\n");
        for (String string4 : hashSet) {
            stringBuffer.append(", ").append(this.values_tab).append(" ").append((String)hashMap.get(string4)).append("\n");
        }
        stringBuffer.append("WHERE (1=1)");
        for (String string5 : hashSet) {
            stringBuffer.append("\nAND ").append("R." + string5 + "$RDFVID = " + (String)hashMap.get(string5) + ".VALUE_ID");
        }
        for (Filter filter : list) {
            filter.setSpmValueColMapping(this.spmValColMap);
            stringBuffer.append("\nAND ").append(filter.toSQL(hashMap, map, this.ctx.funcTypeMap, this.ctx.funcHandMap));
        }
        return stringBuffer.toString();
    }

    private String buildSelect(boolean bl, boolean bl2, boolean bl3, List<String[]> list) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        HashSet<String> hashSet = new HashSet<String>();
        if (this.hasPushedBGP) {
            hashSet.addAll(this.pushedBGP.getBGPAndPushedVars());
        }
        for (String string : this.getBGPAndPushedVars()) {
            QueryUtils.appendToList(stringBuffer, this.buildSelectListForVar(string, hashSet, bl2, bl3), ",\n", "");
        }
        if ((this.ctx.contextFlags & 1) > 0) {
            if (this.bgp.TBList.size() > 0) {
                QueryUtils.appendToList(stringBuffer, " T0.CTXT2 as T0_CTXT2 ", ",\n", "");
            } else {
                QueryUtils.appendToList(stringBuffer, " NULL as T0_CTXT2 ", ",\n", "");
            }
        } else if ((this.ctx.contextFlags & 2) > 0) {
            object = new StringBuffer();
            if (this.bgp.TBList.size() > 1) {
                ((StringBuffer)object).append(" COALESCE(T0.CTXT2");
                for (int i = 1; i < this.bgp.TBList.size(); ++i) {
                    ((StringBuffer)object).append(", T" + i + ".CTXT2");
                }
                ((StringBuffer)object).append(") ");
            } else if (this.bgp.TBList.size() == 1) {
                ((StringBuffer)object).append(" T0.CTXT2 ");
            } else {
                ((StringBuffer)object).append(" NULL ");
            }
            QueryUtils.appendToList(stringBuffer, ((StringBuffer)object).toString() + " as T0_CTXT2 ", ",\n", "");
        }
        for (String[] stringArray : list) {
            QueryUtils.appendToList(stringBuffer, stringArray[0] + "(" + stringArray[1] + ") as " + "ANC$" + stringArray[1], ",\n", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(" 1\n");
        }
        if (this.ctx.topDownOpt) {
            if (this.bgp.TBList.size() > 0) {
                QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T0." + this.subjectCol) + " AS BGP$" + this.getId(), ",\n", "");
            } else {
                QueryUtils.appendToList(stringBuffer, "1 AS BGP$" + this.getId(), ",\n", "");
            }
        }
        object = "";
        if (bl) {
            object = "/*+ NO_MERGE */ ";
        }
        String string = "";
        if (bl2) {
            string = "DISTINCT ";
        }
        return "SELECT " + (String)object + string + this.sqlHint + stringBuffer.toString();
    }

    private String buildVTYPCaseForVar(String string) {
        return QueryUtils.buildVTYPCaseForVar(string);
    }

    private String buildSelectListForVar(String string, Set<String> set, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = this.varAliases.get(string);
        String string3 = "PBGP." + string;
        String string4 = "R." + string;
        String string5 = " (CASE WHEN " + this.getSPMOptimizedValCol(string2 + "." + "VALUE_TYPE") + " IS NULL THEN NULL WHEN " + this.getSPMOptimizedValCol(string2 + "." + "VALUE_TYPE") + " IN ('UR','" + "URI" + "') THEN '" + "URI" + "'\n WHEN " + this.getSPMOptimizedValCol(string2 + "." + "VALUE_TYPE") + " IN ('BN', '" + "BLN" + "') THEN '" + "BLN" + "'\n ELSE '" + "LIT" + "'\nEND) ";
        int n = 8;
        if (bl || bl2) {
            n = 7;
        }
        String[][] stringArray = new String[n][2];
        String string6 = "";
        if (bl2) {
            stringArray[0][0] = string4;
            stringArray[1][0] = string4 + this.vtype_alias;
            stringArray[2][0] = string4 + this.vid_alias;
            stringArray[3][0] = string4 + this.prefix_alias;
            stringArray[4][0] = string4 + this.suffix_alias;
            stringArray[5][0] = string4 + this.litType_alias;
            stringArray[6][0] = string4 + this.langType_alias;
            string6 = string4;
        } else if (string2 != null) {
            stringArray[0][0] = this.getSPMOptimizedValCol(string2 + "." + this.prefix_col) + " || " + this.getSPMOptimizedValCol(string2 + "." + this.suffix_col);
            stringArray[1][0] = string5;
            stringArray[2][0] = this.getLocalVIDCol(string, set);
            stringArray[3][0] = this.getSPMOptimizedValCol(string2 + "." + this.prefix_col);
            stringArray[4][0] = this.getSPMOptimizedValCol(string2 + "." + this.suffix_col);
            stringArray[5][0] = this.getSPMOptimizedValCol(string2 + "." + this.litType_col);
            stringArray[6][0] = this.getSPMOptimizedValCol(string2 + "." + this.langType_col);
            if (!bl) {
                stringArray[7][0] = this.getSPMOptimizedValCol(string2 + "." + this.longLit_col);
            }
            string6 = QueryUtils.genVNameSubstr(this.getSPMOptimizedValCol(string2 + "." + this.prefix_col) + " || " + this.getSPMOptimizedValCol(string2 + "." + this.suffix_col), this.getSPMOptimizedValCol(string2 + "." + this.longLit_col), this.getSPMOptimizedValCol(string2 + "." + this.langType_col), this.getSPMOptimizedValCol(string2 + "." + this.litType_col));
        } else {
            stringArray[0][0] = string3;
            stringArray[1][0] = string3 + this.vtype_alias;
            stringArray[2][0] = this.getLocalVIDCol(string, set);
            stringArray[3][0] = string3 + this.prefix_alias;
            stringArray[4][0] = string3 + this.suffix_alias;
            stringArray[5][0] = string3 + this.litType_alias;
            stringArray[6][0] = string3 + this.langType_alias;
            if (!bl) {
                stringArray[7][0] = string3 + this.longLit_alias;
            }
            string6 = QueryUtils.genVNameSubstr(string3, string3 + this.longLit_alias, string3 + this.langType_alias, string3 + this.litType_alias);
        }
        stringArray[0][1] = "";
        stringArray[1][1] = this.vtype_alias;
        stringArray[2][1] = this.vid_alias;
        stringArray[3][1] = this.prefix_alias;
        stringArray[4][1] = this.suffix_alias;
        stringArray[5][1] = this.litType_alias;
        stringArray[6][1] = this.langType_alias;
        if (!bl && !bl2) {
            stringArray[7][1] = this.longLit_alias;
        }
        if (this.getProjectVars().contains(string)) {
            if (bl) {
                this.distinctCLOB = true;
                this.needCLOBVars.add(string);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                QueryUtils.appendToList(stringBuffer, stringArray[i][0] + " AS " + string + stringArray[i][1], ", ", "");
            }
            if (this.getAllLexVars().contains(string)) {
                if (string2 != null) {
                    if (bl2) {
                        QueryUtils.appendToList(stringBuffer, string4 + this.term_alias + " AS " + string + this.term_alias, ", ", "");
                    } else {
                        String string7 = this.buildRDFTerm(string6, stringArray[1][0], stringArray[5][0], stringArray[6][0]);
                        QueryUtils.appendToList(stringBuffer, string7 + " AS " + string + this.term_alias, ", ", "");
                    }
                } else {
                    QueryUtils.appendToList(stringBuffer, string3 + this.term_alias + " AS " + string + this.term_alias, ", ", "");
                }
            }
        } else {
            QueryUtils.appendToList(stringBuffer, stringArray[2][0] + " AS " + string + stringArray[2][1], ", ", "");
        }
        return stringBuffer.toString();
    }

    private String buildRDFTermForVar(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (this.isBindVar(string)) {
            ASTTripleAtom.BindVar bindVar = this.getBindVar(string);
            String string7 = bindVar.getTermCol();
            string2 = string7 + "." + this.vname_col;
            string3 = string7 + "." + this.vtype_col;
            string4 = string7 + "." + this.litType_col;
            string5 = string7 + "." + this.langType_col;
            string6 = string7 + "." + this.longLit_col;
        } else {
            String string8 = this.varAliases.get(string);
            string2 = this.getSPMOptimizedValCol(string8 + "." + this.prefix_col) + " || " + this.getSPMOptimizedValCol(string8 + "." + this.suffix_col);
            string3 = this.getSPMOptimizedValCol(string8 + "." + this.vtype_col);
            string4 = this.getSPMOptimizedValCol(string8 + "." + this.litType_col);
            string5 = this.getSPMOptimizedValCol(string8 + "." + this.langType_col);
            string6 = this.getSPMOptimizedValCol(string8 + "." + this.longLit_col);
        }
        string2 = QueryUtils.genVNameSubstr(string2, string6, string5, string4);
        return this.buildRDFTerm(string2, string3, string4, string5);
    }

    private String buildRDFTerm(String string, String string2, String string3, String string4) {
        String string5 = "SEM_APIS.COMPOSE_RDF_TERM(" + string + "," + string2 + "," + string3 + "," + string4 + ")";
        return string5;
    }

    private String getLocalVIDCol(String string, Set<String> set) {
        String string2 = "";
        if (this.isBindVar(string)) {
            ASTTripleAtom.BindVar bindVar = this.getBindVar(string);
            string2 = bindVar.getIdCol();
        } else if (this.varset.containsKey(string)) {
            if (this.varset.get(string).equalsIgnoreCase("Subject")) {
                string2 = this.extractFirstOutgoingEdge(string) + "." + this.subjectCol;
            } else if (this.varset.get(string).equalsIgnoreCase("Predicate")) {
                string2 = this.extractFirstTableAlias(string) + "." + this.predicateCol;
            } else {
                String string3 = this.canonObjCol;
                if (this.ctx.useExactValue) {
                    string3 = this.exactObjCol;
                }
                string2 = this.extractFirstIncomingEdge(string) + "." + string3;
            }
        } else if (this.graphQuery && this.graphVar != null && this.graphVar.equalsIgnoreCase(string)) {
            string2 = this.buildGidExpr(false);
        } else if (set.contains(string)) {
            string2 = "PBGP." + string + this.vid_alias;
        }
        string2 = this.getSPMOptimizedCol(string2);
        return string2;
    }

    private String buildFrom() throws RDFException {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.hasPushedBGP) {
            QueryUtils.appendToList(stringBuffer, this.pushedBGPAlias + " " + PUSHED_BGP_ALIAS, ", ", "");
        }
        TreeSet<LateralPPDesc> treeSet = new TreeSet<LateralPPDesc>();
        int n2 = 0;
        PPNode pPNode = null;
        String string = "";
        String string2 = "";
        for (TriplesBlock object22 : this.bgp.TBList) {
            if (object22.hasPropertyPath()) {
                boolean bl = false;
                object = null;
                if (this.localSelectivity == 1 && this.lateralPPEnabled()) {
                    object = new LateralPPDesc[1];
                    bl = this.isLateralOptimizable(object22, n2, (LateralPPDesc[])object);
                }
                if (bl && !this.createsLateralCycle(object[0], treeSet)) {
                    treeSet.add(object[0]);
                } else {
                    SimplePPSQLTransVisitor simplePPSQLTransVisitor = new SimplePPSQLTransVisitor(this.activeGraph, this.ctx, this.queryOptions, this.link_tab);
                    pPNode = object22.getPath();
                    string = pPNode.accept(simplePPSQLTransVisitor);
                    string2 = simplePPSQLTransVisitor.getWITHClauses();
                    string = string2 + "\n" + string;
                    QueryUtils.appendToList(stringBuffer, "\n(/*PP[*/" + string + "/*]PP*/) T" + n2, ", ", "");
                }
            } else if (!this.excludedTripleTabs.contains("T" + n2)) {
                QueryUtils.appendToList(stringBuffer, this.link_tab + " T" + n2, ", ", "");
            }
            ++n2;
        }
        for (n = 0; n < this.svpClusterList.size(); ++n) {
            String string3;
            Object var8_11 = null;
            try {
                string3 = this.ctx.clnNetworkOwner + "." + QueryUtils.simpleSQLName(this.svpBestTabNameList.get(n), 128);
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage());
            }
            QueryUtils.appendToList(stringBuffer, this.addSPMTabDatasetConstraints(string3) + " SVP" + n, ",\n", "");
        }
        for (n = 0; n < this.pcnChainList.size(); ++n) {
            String string4;
            Object var8_14 = null;
            try {
                String string5 = this.getPcnTabNameForChainId(n);
                string4 = this.ctx.clnNetworkOwner + "." + QueryUtils.simpleSQLName(string5, 128);
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage());
            }
            QueryUtils.appendToList(stringBuffer, this.addSPMTabDatasetConstraints(string4) + " PCN" + n, ",\n", "");
        }
        n = 0;
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            QueryUtils.appendToList(stringBuffer, this.addSPMTabDatasetConstraints(this.ctx.qualifiedMvpTabPrefix + sPMColDesc.predId) + " MVP" + n, ",\n", "");
            ++n;
        }
        try {
            this.addLateralPropertyPaths(stringBuffer, treeSet);
        }
        catch (SQLException sQLException) {
            throw new RDFException(sQLException.getMessage());
        }
        if (this.isGraphQuery() && this.bgp.TBList.size() == 0) {
            if (this.ctx.optDistinctGQuery == null || this.ctx.disableGMVOpt) {
                QueryUtils.appendToList(stringBuffer, this.link_tab + " T0", ", ", "");
            } else {
                QueryUtils.appendToList(stringBuffer, "(" + this.ctx.optDistinctGQuery + ") T0", ", ", "");
            }
        }
        for (String string6 : this.variablesToBeJoined) {
            if (this.isBindVar(string6) || this.excludedValueTabs.contains(object = this.varAliases.get(string6))) continue;
            QueryUtils.appendToList(stringBuffer, this.values_tab + " " + this.varAliases.get(string6), ", ", "");
        }
        for (ASTTripleAtom.BindVar bindVar : this.bindVarsToJoin) {
            QueryUtils.appendToList(stringBuffer, bindVar.getAlias() + " " + bindVar.getAlias(), ", ", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("DUAL");
        }
        return "FROM " + stringBuffer.toString();
    }

    private void addLateralPropertyPaths(StringBuffer stringBuffer, SortedSet<LateralPPDesc> sortedSet) throws SQLException {
        for (LateralPPDesc lateralPPDesc : sortedSet) {
            String string = "null";
            String string2 = "0";
            if (this.isGraphQuery()) {
                string = "T" + lateralPPDesc.depAlias + "." + this.gidCol + "";
                string2 = "1";
            }
            StringBuffer stringBuffer2 = new StringBuffer("");
            stringBuffer2.append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.queryOptions))).append("\n");
            stringBuffer2.append(",").append(this.ctx.optionsFlag).append("\n");
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("MDSYS.RDF_MODELS", this.ctx.models));
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.precompIdxName))).append("\n");
            stringBuffer2.append(",").append(this.ctx.precompIdxID).append("\n");
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.idxStatus))).append("\n");
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.vmViewName))).append("\n");
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("SYS.ODCINumberList", this.ctx.defaultGIDs));
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("SYS.ODCINumberList", this.ctx.namedGIDs));
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("SYS.ODCINumberList", this.ctx.defaultMIDs));
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("MDSYS.RDF_MODELS", this.ctx.defaultModels));
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.clnNetworkOwner))).append("\n");
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.clnNetworkName))).append("\n");
            int n = QueryUtils.getMaxPPDepth(this.queryOptions);
            if (lateralPPDesc.ppType != LateralPPDesc.PPTypes.RANGE_FORWARD && lateralPPDesc.ppType != LateralPPDesc.PPTypes.RANGE_REVERSE && QueryUtils.isSchemaProperty(lateralPPDesc.ppPred) && !this.ctx.disableSPPOpt) {
                n = 0;
            }
            String string3 = "null";
            String string4 = lateralPPDesc.ppPredId;
            String string5 = "null";
            String string6 = "0";
            String string7 = "null";
            String string8 = "null";
            String string9 = "0";
            if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.PLUS_FORWARD) {
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string3 = lateralPPDesc.ppJoinCol;
                } else {
                    string5 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.PLUS_REVERSE) {
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string5 = lateralPPDesc.ppJoinCol;
                } else {
                    string3 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.STAR_FORWARD) {
                string6 = "1";
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string3 = lateralPPDesc.ppJoinCol;
                } else {
                    string5 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.STAR_REVERSE) {
                string6 = "1";
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string5 = lateralPPDesc.ppJoinCol;
                } else {
                    string3 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.RANGE_FORWARD) {
                string7 = String.valueOf(lateralPPDesc.minOcc);
                string8 = String.valueOf(lateralPPDesc.maxOcc);
                String string10 = string9 = lateralPPDesc.exact ? "1" : "0";
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string3 = lateralPPDesc.ppJoinCol;
                } else {
                    string5 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.RANGE_REVERSE) {
                string7 = String.valueOf(lateralPPDesc.minOcc);
                string8 = String.valueOf(lateralPPDesc.maxOcc);
                String string11 = string9 = lateralPPDesc.exact ? "1" : "0";
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string5 = lateralPPDesc.ppJoinCol;
                } else {
                    string3 = lateralPPDesc.ppJoinCol;
                }
            }
            string3 = this.getSPMOptimizedCol(string3);
            string5 = this.getSPMOptimizedCol(string5);
            string = this.getSPMOptimizedCol(string);
            String string12 = "mdsys.sdo_rdf.sdo_rdf_pp(" + string3 + "," + string4 + "," + string5 + "," + string + "," + string2 + "," + string6 + "," + n + "," + stringBuffer2.toString();
            if (this.lateralPPRangeEnabled()) {
                string12 = string12 + "," + string7 + "," + string8 + "," + string9;
            }
            string12 = string12 + ")";
            if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.PLUS_REVERSE || lateralPPDesc.ppType == LateralPPDesc.PPTypes.STAR_REVERSE || lateralPPDesc.ppType == LateralPPDesc.PPTypes.RANGE_REVERSE) {
                QueryUtils.appendToList(stringBuffer, "\nLATERAL (/*PP[*/SELECT DISTINCT " + this.subjectCol + " AS " + this.canonObjCol + ", " + this.canonObjCol + " AS " + this.subjectCol + ", " + this.gidCol + " FROM TABLE(" + string12 + ")/*]PP*/) T" + lateralPPDesc.alias, ", ", "");
                continue;
            }
            QueryUtils.appendToList(stringBuffer, "\nLATERAL (/*PP[*/SELECT DISTINCT " + this.subjectCol + ", " + this.canonObjCol + ", " + this.gidCol + " FROM TABLE(" + string12 + ")/*]PP*/) T" + lateralPPDesc.alias, ", ", "");
        }
    }

    /*
     * WARNING - void declaration
     */
    private String buildWhere() throws RDFException {
        void var9_23;
        Object object;
        Iterator<String> iterator;
        Object object2;
        Object object3;
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set = this.getTriplePatternVars(true);
        HashSet<String> hashSet = new HashSet<String>();
        if (this.hasPushedBGP) {
            hashSet.addAll(this.pushedBGP.getBGPAndPushedVars());
        }
        String string = "##";
        if (this.graphVar != null) {
            string = this.graphVar;
        }
        String string2 = this.buildGidExpr(true);
        String string3 = this.canonObjCol;
        if (this.ctx.useExactValue) {
            string3 = this.exactObjCol;
        }
        Set<String> set2 = this.getAllLexVars();
        if (this.hasPushedBGP) {
            Set<String> set3 = QueryUtils.getCommonVars(set, hashSet);
            Iterator object5 = set3.iterator();
            while (object5.hasNext()) {
                String string4 = (String)object5.next();
                if (string4.equals(string)) continue;
                if (set2.contains(string4)) {
                    object3 = this.buildRDFTermForVar(string4);
                    QueryUtils.appendToList(stringBuffer, "PBGP." + string4 + this.term_alias + " = " + (String)object3, " AND\n", "");
                    continue;
                }
                QueryUtils.appendToList(stringBuffer, "PBGP." + string4 + this.vid_alias + " = " + this.getLocalVIDCol(string4, hashSet), " AND\n", "");
            }
        }
        for (String i : this.variablesToBeJoined) {
            if (this.isBindVar(i) || !set.contains(i)) continue;
            String string5 = this.varAliases.get(i);
            if (this.excludedValueTabs.contains(string5)) {
                QueryUtils.appendToList(stringBuffer, "1=1", " AND\n", "");
                continue;
            }
            object3 = this.varset.get(i);
            if (((String)object3).equalsIgnoreCase("Subject")) {
                object2 = this.extractFirstOutgoingEdge(i);
                QueryUtils.appendToList(stringBuffer, string5 + "." + this.vid_col + " = " + this.getSPMOptimizedCol((String)object2 + "." + this.subjectCol), " AND\n", "");
            }
            if (((String)object3).equalsIgnoreCase("Object")) {
                object2 = this.extractFirstIncomingEdge(i);
                QueryUtils.appendToList(stringBuffer, string5 + "." + this.vid_col + " = " + this.getSPMOptimizedCol((String)object2 + "." + string3), " AND\n", "");
            }
            if (!((String)object3).equalsIgnoreCase("Predicate")) continue;
            object2 = this.extractFirstTableAlias(i);
            QueryUtils.appendToList(stringBuffer, string5 + "." + this.vid_col + " = " + (String)object2 + "." + this.predicateCol, " AND\n", "");
        }
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            object3 = triplesBlock.getSubject();
            object2 = triplesBlock.getPredicate();
            iterator = triplesBlock.getObject();
            object = null;
            String string6 = "";
            Long l = null;
            String string7 = "";
            Long l2 = null;
            String string8 = "";
            String string9 = "";
            if (!((TriplesBlock.Element)object3).isVariable()) {
                object = ((TriplesBlock.Element)object3).getCanonicalID();
                if (object != null) {
                    string6 = ((Long)object).toString();
                }
                if (((TriplesBlock.Element)object3).isBindVariable()) {
                    string9 = new ASTTripleAtom.BindVar((String)((TriplesBlock.Element)object3).getName()).bvName;
                    string6 = this.getBindVar(string9).getIdCol();
                }
                if (((TriplesBlock.Element)object3).exists()) {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + n + "." + this.subjectCol) + " = " + string6, " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + n + "." + this.subjectCol) + SimpleBGP.getNonExistingTermCondition(this.ctx.clnPfxForRdfObjName), " AND\n", "");
                }
            }
            if (!((TriplesBlock.Element)object2).isVariable() && ((TriplesBlock.Element)object2).getType() != 8) {
                l = ((TriplesBlock.Element)object2).getCanonicalID();
                if (l != null) {
                    string7 = l.toString();
                }
                if (((TriplesBlock.Element)object2).isBindVariable()) {
                    string9 = new ASTTripleAtom.BindVar((String)((TriplesBlock.Element)object2).getName()).bvName;
                    string7 = this.getBindVar(string9).getIdCol();
                }
                if (((TriplesBlock.Element)object2).exists()) {
                    String string10 = "T" + n + "." + this.predicateCol;
                    String string11 = this.getSPMOptimizedCol(string10);
                    if (!string11.equals(string10)) {
                        if (string11.startsWith("SVP")) {
                            QueryUtils.appendToList(stringBuffer, string11 + " IS NOT NULL", " AND\n", "");
                        }
                    } else {
                        QueryUtils.appendToList(stringBuffer, string10 + " = " + string7, " AND\n", "");
                    }
                } else {
                    QueryUtils.appendToList(stringBuffer, "T" + n + "." + this.predicateCol + SimpleBGP.getNonExistingTermCondition(this.ctx.clnPfxForRdfObjName), " AND\n", "");
                }
            }
            if (!((TriplesBlock.Element)((Object)iterator)).isVariable()) {
                l2 = ((TriplesBlock.Element)((Object)iterator)).getCanonicalID();
                if (l2 != null) {
                    string8 = l2.toString();
                }
                if (((TriplesBlock.Element)((Object)iterator)).isSysCtxFunction()) {
                    string8 = ((TriplesBlock.Element)((Object)iterator)).getName();
                }
                if (((TriplesBlock.Element)((Object)iterator)).isBindVariable()) {
                    string9 = new ASTTripleAtom.BindVar((String)((TriplesBlock.Element)((Object)iterator)).getName()).bvName;
                    string8 = this.getBindVar(string9).getIdCol();
                }
                if (((TriplesBlock.Element)((Object)iterator)).exists()) {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + n + "." + string3) + " = " + string8, " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + n + "." + string3) + SimpleBGP.getNonExistingTermCondition(this.ctx.clnPfxForRdfObjName), " AND\n", "");
                }
            }
            ++n;
        }
        for (String string12 : set) {
            if (this.isBindVar(string12)) continue;
            if (this.bgp.BGPelements.containsKey(string12 + ",2") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string12).append((String)",2").toString()).position.equalsIgnoreCase("Object") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string12).append((String)",2").toString()).in_degree > 1) {
                object3 = this.extractIncomingEdges(string12);
                object2 = this.extractFirstIncomingEdge(string12);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((String)object).equals(object2)) continue;
                    QueryUtils.appendToList(stringBuffer, this.buildOptimizedTpJoin((String)object2 + "." + string3, (String)object + "." + string3), " AND\n", "");
                }
            }
            if (this.bgp.BGPelements.containsKey(string12 + ",0") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string12).append((String)",0").toString()).position.equalsIgnoreCase("Subject") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string12).append((String)",0").toString()).out_degree > 1) {
                object3 = this.extractOutgoingEdges(string12);
                object2 = this.extractFirstOutgoingEdge(string12);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((String)object).equals(object2)) continue;
                    QueryUtils.appendToList(stringBuffer, this.buildOptimizedTpJoin((String)object2 + "." + this.subjectCol, (String)object + "." + this.subjectCol), " AND\n", "");
                }
            }
            if (!this.bgp.BGPelements.containsKey(string12 + ",2") || !this.bgp.BGPelements.containsKey(string12 + ",0") || this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string12).append((String)",2").toString()).in_degree <= 0 || this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string12).append((String)",0").toString()).out_degree <= 0) continue;
            object3 = this.extractFirstIncomingEdge(string12);
            object2 = this.extractFirstOutgoingEdge(string12);
            QueryUtils.appendToList(stringBuffer, this.buildOptimizedTpJoin((String)object3 + "." + string3, (String)object2 + "." + this.subjectCol), " AND\n", "");
        }
        for (String string13 : set) {
            if (this.isBindVar(string13)) continue;
            if (this.varset.get(string13).equalsIgnoreCase("Predicate") && this.bgp.BGPelements.containsKey(string13 + ",1") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string13).append((String)",1").toString()).occurences > 1) {
                object3 = this.extractAllTableAliases(string13);
                object2 = this.extractFirstTableAlias(string13);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((String)object).equalsIgnoreCase((String)object2)) continue;
                    QueryUtils.appendToList(stringBuffer, (String)object2 + "." + this.predicateCol + " = " + (String)object + "." + this.predicateCol, " AND\n", "");
                }
            }
            if (this.bgp.BGPelements.containsKey(string13 + ",1") && this.bgp.BGPelements.containsKey(string13 + ",0")) {
                object3 = this.extractFirstOutgoingEdge(string13);
                object2 = this.extractFirstTableAlias(string13);
                QueryUtils.appendToList(stringBuffer, (String)object2 + "." + this.predicateCol + " = " + this.getSPMOptimizedCol(object3 + "." + this.subjectCol), " AND\n", "");
            }
            if (!this.bgp.BGPelements.containsKey(string13 + ",1") || !this.bgp.BGPelements.containsKey(string13 + ",2")) continue;
            object3 = this.extractFirstIncomingEdge(string13);
            object2 = this.extractFirstTableAlias(string13);
            QueryUtils.appendToList(stringBuffer, (String)object2 + "." + this.predicateCol + " = " + this.getSPMOptimizedCol((String)object3 + "." + string3), " AND\n", "");
        }
        if (this.graphQuery) {
            void var9_18;
            boolean bl = true;
            String string14 = "";
            if ((this.ctx.contextFlags & 4) > 0 || this.wantGIDCoalesce()) {
                boolean bl2 = false;
            }
            while (var9_18 < this.bgp.TBList.size()) {
                String string15 = this.optLinkAliasList.get((int)var9_18);
                QueryUtils.appendToList(stringBuffer, string2 + " = " + this.buildGidNVL(this.getSPMOptimizedCol(string15 + "." + this.gidCol), string2), " AND\n", "");
                ++var9_18;
            }
            if (this.activeGraph.type == 0) {
                if (hashSet.contains(string)) {
                    if (set2.contains(string)) {
                        object3 = this.buildRDFTermForVar(string);
                        object2 = "PBGP." + string + this.term_alias;
                        QueryUtils.appendToList(stringBuffer, object3 + " = " + (String)object2, " AND\n", "");
                    } else {
                        QueryUtils.appendToList(stringBuffer, this.buildGidNVL("PBGP." + string + this.vid_alias, string2) + " = " + string2, " AND\n", "");
                    }
                }
                object3 = null;
                if (this.bgp.BGPelements.containsKey(string + ",2")) {
                    object3 = this.extractFirstIncomingEdge(string) + "." + string3;
                } else if (this.bgp.BGPelements.containsKey(string + ",0")) {
                    object3 = this.extractFirstOutgoingEdge(string) + "." + this.subjectCol;
                } else if (this.bgp.BGPelements.containsKey(string + ",1")) {
                    object3 = this.extractFirstTableAlias(string) + "." + this.predicateCol;
                }
                if (object3 != null) {
                    QueryUtils.appendToList(stringBuffer, this.buildGidNVL(this.getSPMOptimizedCol((String)object3), string2) + " = " + string2, " AND\n", "");
                }
                if (this.variablesToBeJoined.contains(string) && !set.contains(string)) {
                    if ((this.ctx.contextFlags & 4) > 0) {
                        QueryUtils.appendToList(stringBuffer, "VG." + this.vid_col + "(+) = " + string2, " AND\n", "");
                    } else {
                        QueryUtils.appendToList(stringBuffer, "VG." + this.vid_col + " = " + string2, " AND\n", "");
                    }
                }
            }
            if (this.activeGraph.type == 1 || this.activeGraph.type == 9) {
                object3 = null;
                if (this.activeGraph.type == 1) {
                    object3 = this.ctx.URImap.get(this.activeGraph.name);
                } else if (this.activeGraph.type == 9) {
                    object2 = this.getBindVar(string);
                    object3 = ((ASTTripleAtom.BindVar)object2).getIdCol();
                }
                if (object3 != null) {
                    QueryUtils.appendToList(stringBuffer, this.buildGidNVL((String)object3, string2) + " = " + string2, " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T0." + this.gidCol) + SimpleBGP.getNonExistingTermCondition(this.ctx.clnPfxForRdfObjName), " AND\n", "");
                }
            }
        }
        if ((this.ctx.contextFlags & 1) > 0 && this.bgp.TBList.size() > 1) {
            void var9_20;
            boolean bl = true;
            while (var9_20 < this.bgp.TBList.size()) {
                QueryUtils.appendToList(stringBuffer, "T0.CTXT2 = T" + (int)var9_20 + ".CTXT2 ", " AND\n", "");
                ++var9_20;
            }
        } else if ((this.ctx.contextFlags & 2) > 0 && this.bgp.TBList.size() > 1) {
            void var10_40;
            void var10_38;
            StringBuffer stringBuffer2 = new StringBuffer(" COALESCE(");
            boolean bl = false;
            while (var10_38 < this.bgp.TBList.size()) {
                stringBuffer2.append("T" + (int)var10_38 + ".CTXT2,");
                ++var10_38;
            }
            stringBuffer2.append("'RDFCTX$NULLCTX')");
            boolean bl3 = true;
            while (var10_40 < this.bgp.TBList.size()) {
                QueryUtils.appendToList(stringBuffer, stringBuffer2.toString() + " = NVL(T" + (int)var10_40 + ".CTXT2, " + stringBuffer2.toString() + ") ", " AND\n", "");
                ++var10_40;
            }
        }
        boolean bl = false;
        while (var9_23 < this.bgp.TBList.size()) {
            TriplesBlock triplesBlock = this.bgp.TBList.get((int)var9_23);
            object3 = triplesBlock.getPredicate();
            if (!((TriplesBlock.Element)object3).isVariable() && ((TriplesBlock.Element)object3).getType() != 8 && !((TriplesBlock.Element)object3).isBindVariable() && ((TriplesBlock.Element)object3).exists()) {
                this.addSPMDatasetConstraints(stringBuffer, (TriplesBlock.Element)object3, (int)var9_23);
            }
            ++var9_23;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("(1=1)");
        }
        return "WHERE " + stringBuffer.toString();
    }

    private String applyFilters(String string, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        for (Filter filter : this.filters) {
            filter.setCurrSQL(string, set, set2, set3, set4);
            filter.setSpmValueColMapping(this.spmValColMap);
            QueryUtils.appendToList(stringBuffer, filter.toSQL(this.varAliases, this.varIDs, this.ctx.funcTypeMap, this.ctx.funcHandMap), " AND\n", "dummy");
        }
        return stringBuffer.toString();
    }

    private void popVarsToJoin() {
        this.variablesToBeJoined = new HashSet<String>();
        this.variablesToBeJoined.addAll(QueryUtils.getCommonVars(this.getProjectVars(), this.getBGPVars()));
        this.bindVarsToJoin = new HashSet<ASTTripleAtom.BindVar>();
        this.bindVarsToJoin.addAll(this.bindVars);
        for (Filter filter : this.filters) {
            this.variablesToBeJoined.addAll(filter.getfJoinVars());
            this.bindVarsToJoin.addAll(filter.getBindVarObjs());
        }
    }

    private void populateFromTBs() {
        this.varset = new HashMap<String, String>();
        this.extractVariables();
    }

    private void extractVariables() {
        boolean bl = false;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            int n = 0;
            for (TriplesBlock.Element element : new TriplesBlock.Element[]{triplesBlock.getSubject(), triplesBlock.getPredicate(), triplesBlock.getObject()}) {
                String string = element.getName();
                if (element.isVariable() && !this.varset.containsKey(string)) {
                    this.varset.put(string, this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string).append((String)",").append((int)n).toString()).position);
                } else if (element.isBindVariable()) {
                    ASTTripleAtom.BindVar bindVar = new ASTTripleAtom.BindVar(string);
                    this.bindVars.add(bindVar);
                    if (!this.varset.containsKey(bindVar.bvName)) {
                        this.varset.put(bindVar.bvName, this.bgp.BGPelements.get((Object)new StringBuilder().append((String)bindVar.bvName).append((String)",").append((int)n).toString()).position);
                    }
                }
                ++n;
            }
        }
    }

    private void extractVarAliases() {
        this.varAliases = new HashMap<String, String>();
        Set<Map.Entry<String, String>> set = this.varset.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String string3 = "";
            if (this.isBindVar(string)) {
                ASTTripleAtom.BindVar bindVar = this.getBindVar(string);
                string3 = bindVar.getTermCol();
                this.varAliases.put(string, string3);
            } else {
                string2 = string2.equalsIgnoreCase("Subject") ? "0" : (string2.equalsIgnoreCase("Predicate") ? "1" : "2");
                string3 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string).append((String)",").append((String)string2).toString()).uniqueId;
                this.varAliases.put(string, string3);
            }
            if (this.hintG == null || !this.variablesToBeJoined.contains(string.toUpperCase())) continue;
            this.hintG.addVarAlias(string, string3);
        }
        if (this.graphVar != null && !this.varAliases.containsKey(this.graphVar)) {
            Object object = GRAPH_ALIAS;
            if (this.isBindVar(this.graphVar)) {
                object = this.getBindVar(this.graphVar).getTermCol();
            }
            this.varAliases.put(this.graphVar, (String)object);
            if (this.hintG != null && this.variablesToBeJoined.contains(this.graphVar)) {
                this.hintG.addVarAlias(this.graphVar, (String)object);
            }
        }
    }

    private void updateVarAliasesForAuxValues() {
        for (Map.Entry<String, String> entry : this.varAliases.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String string3 = this.auxVarMappedAliases.get(string);
            if (string3 == null || string3.equals(string2)) continue;
            entry.setValue(string3);
        }
    }

    private String addSPMTabDatasetConstraints(String string) {
        String string2 = "(SELECT * FROM " + string + " WHERE 1=0)";
        if (this.graphQuery && this.ctx.defaultGIDs != null && this.ctx.defaultGIDs.length > 0 && (this.ctx.namedGIDs == null || this.ctx.namedGIDs.length == 0)) {
            return string2;
        }
        if (!(this.graphQuery || this.ctx.namedGIDs == null || this.ctx.namedGIDs.length <= 0 || this.ctx.defaultGIDs != null && this.ctx.defaultGIDs.length != 0)) {
            return string2;
        }
        return string;
    }

    private void addSPMDatasetConstraints(StringBuffer stringBuffer, TriplesBlock.Element element, int n) {
        boolean bl;
        String string = "T" + n + "." + this.predicateCol;
        String string2 = this.getSPMOptimizedCol(string);
        boolean bl2 = bl = (this.ctx.contextFlags & 4) > 0;
        if (!string2.equals(string)) {
            String string3 = this.getSPMOptimizedCol("T" + n + "." + this.gidCol);
            if (this.graphQuery) {
                if (!bl) {
                    QueryUtils.appendToList(stringBuffer, string3 + " IS NOT NULL ", " AND\n", "");
                }
                if (this.ctx.namedGIDs != null && this.ctx.namedGIDs.length > 0) {
                    StringBuffer stringBuffer2 = new StringBuffer("(");
                    for (int i = 0; i < this.ctx.namedGIDs.length; ++i) {
                        if (i > 0) {
                            stringBuffer2.append(", ");
                        }
                        stringBuffer2.append(this.ctx.namedGIDs[i]);
                    }
                    stringBuffer2.append(") ");
                    String string4 = string3 + " IN " + stringBuffer2.toString();
                    if (bl) {
                        string4 = "(" + string4 + " OR " + string3 + " IS NULL) ";
                    }
                    QueryUtils.appendToList(stringBuffer, string4, " AND\n", "");
                }
            } else {
                if (!this.ctx.allGraphsDefault) {
                    QueryUtils.appendToList(stringBuffer, string3 + " IS NULL ", " AND\n", "");
                }
                if (this.ctx.defaultGIDs != null && this.ctx.defaultGIDs.length > 0) {
                    StringBuffer stringBuffer3 = new StringBuffer("(");
                    for (int i = 0; i < this.ctx.defaultGIDs.length; ++i) {
                        if (i > 0) {
                            stringBuffer3.append(", ");
                        }
                        stringBuffer3.append(this.ctx.defaultGIDs[i]);
                    }
                    stringBuffer3.append(") ");
                    QueryUtils.appendToList(stringBuffer, string3 + " IN " + stringBuffer3.toString(), " AND\n", "");
                }
            }
        }
    }

    private void extractVarIDs() {
        this.varIDs = new HashMap<String, String>();
        Set<String> set = this.getBGPVars();
        for (String string : set) {
            this.varIDs.put(string, this.getLocalVIDCol(string, new HashSet<String>()));
        }
    }

    private List<String> extractIncomingEdges(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getObject().isVariable() && triplesBlock.getObject().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    private String extractFirstIncomingEdge(String string) {
        List<String> list = this.extractIncomingEdges(string);
        int n = -1;
        String string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string3 : list) {
                Integer n2 = this.hint0leadPosMap.get(string3.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string2 = string3;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
        }
        return string2;
    }

    private List<String> extractOutgoingEdges(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getSubject().isVariable() && triplesBlock.getSubject().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    private String extractFirstOutgoingEdge(String string) {
        List<String> list = this.extractOutgoingEdges(string);
        int n = -1;
        String string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string3 : list) {
                Integer n2 = this.hint0leadPosMap.get(string3.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string2 = string3;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
        }
        return string2;
    }

    private String extractFirstTableAlias(String string) {
        List<String> list = this.extractAllTableAliases(string);
        int n = -1;
        String string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string3 : list) {
                Integer n2 = this.hint0leadPosMap.get(string3.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string2 = string3;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
        }
        return string2;
    }

    private List<String> extractAllTableAliases(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getPredicate().isVariable() && triplesBlock.getPredicate().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        if (this.isGraphQuery()) {
            string2 = string2 + string + "BGP [" + this.id + "] GRAPH: [" + this.activeGraph.name + "]\n";
        }
        string2 = string2 + this.bgp.toString(string);
        string2 = string2 + "\n";
        string2 = string2 + string + "ID [" + this.getId() + "]\n";
        string2 = string2 + string + "User Hint [" + this.userHint + "]\n";
        string2 = string2 + string + "Required Lex Vars: [";
        for (String string3 : this.getRequiredLexVars()) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "Lex Vars: [";
        for (String string3 : this.getAllLexVars()) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2 + "]\n";
        return string2;
    }

    private boolean isBindVar(String string) {
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            if (!bindVar.bvName.equals(string)) continue;
            return true;
        }
        return false;
    }

    private ASTTripleAtom.BindVar getBindVar(String string) {
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            if (!bindVar.bvName.equals(string)) continue;
            return bindVar;
        }
        return null;
    }

    private void optimizePPStartNodes() throws RDFException {
        HashMap<String, ASTTripleAtom> hashMap = new HashMap<String, ASTTripleAtom>();
        for (Filter object : this.filters) {
            object.updateSubMap(hashMap, this.varAliases, this.varIDs);
        }
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            String string;
            if (!triplesBlock.hasPropertyPath() || !hashMap.containsKey(string = triplesBlock.getSubject().toString())) continue;
            PPNode pPNode = triplesBlock.getPath();
            pPNode.setStartNode((ASTTripleAtom)hashMap.get(string));
        }
    }

    private boolean isLateralOptimizable(TriplesBlock triplesBlock, int n, LateralPPDesc[] lateralPPDescArray) {
        LateralPPDesc.PPTypes pPTypes;
        PPNode pPNode;
        if (triplesBlock.hasPropertyPath() && this.isUnconstrainedPP(pPNode = triplesBlock.getPath()) && ((pPTypes = this.getPPType(pPNode)) == LateralPPDesc.PPTypes.STAR_FORWARD || pPTypes == LateralPPDesc.PPTypes.STAR_REVERSE || pPTypes == LateralPPDesc.PPTypes.PLUS_FORWARD || pPTypes == LateralPPDesc.PPTypes.PLUS_REVERSE || (pPTypes == LateralPPDesc.PPTypes.RANGE_FORWARD || pPTypes == LateralPPDesc.PPTypes.RANGE_REVERSE) && this.lateralPPRangeEnabled())) {
            String string = ((PPIRINode)pPNode.getChild((int)0)).getPredAtom().name;
            String string2 = this.ctx.URImap.get(string);
            PPModNode pPModNode = (PPModNode)pPNode;
            int n2 = pPModNode.getMinOcc();
            int n3 = pPModNode.getMaxOcc();
            boolean bl = pPModNode.isExactRange();
            int n4 = 0;
            String string3 = triplesBlock.getSubject().toString();
            String string4 = triplesBlock.getObject().toString();
            for (TriplesBlock triplesBlock2 : this.bgp.TBList) {
                if (n4 != n) {
                    String string5 = triplesBlock2.getSubject().toString();
                    String string6 = triplesBlock2.getObject().toString();
                    if (string5.equals(string3) && !string6.equals(string4)) {
                        lateralPPDescArray[0] = new LateralPPDesc(n, n4, LateralPPDesc.PPJoinPositions.SUBJ, "T" + n4 + "." + this.subjectCol, pPTypes, string2, string, n2, n3, bl);
                        return true;
                    }
                    if (string5.equals(string4) && !string6.equals(string3)) {
                        lateralPPDescArray[0] = new LateralPPDesc(n, n4, LateralPPDesc.PPJoinPositions.OBJ, "T" + n4 + "." + this.subjectCol, pPTypes, string2, string, n2, n3, bl);
                        return true;
                    }
                    if (string6.equals(string3) && !string5.equals(string4)) {
                        lateralPPDescArray[0] = new LateralPPDesc(n, n4, LateralPPDesc.PPJoinPositions.SUBJ, "T" + n4 + "." + this.canonObjCol, pPTypes, string2, string, n2, n3, bl);
                        return true;
                    }
                    if (string6.equals(string4) && !string5.equals(string3)) {
                        lateralPPDescArray[0] = new LateralPPDesc(n, n4, LateralPPDesc.PPJoinPositions.OBJ, "T" + n4 + "." + this.canonObjCol, pPTypes, string2, string, n2, n3, bl);
                        return true;
                    }
                }
                ++n4;
            }
        }
        return false;
    }

    private boolean isUnconstrainedPP(PPNode pPNode) {
        TriplesBlock.Element element;
        if (pPNode.hasConstrainedStart()) {
            element = null;
            element = TriplesBlock.getElementForNode(pPNode.getStartNode(), this.ctx);
            if (element.getCanonicalID() != null) {
                return false;
            }
        }
        if (pPNode.hasConstrainedEnd()) {
            element = null;
            element = TriplesBlock.getElementForNode(pPNode.getEndNode(), this.ctx);
            if (element.getCanonicalID() != null) {
                return false;
            }
        }
        return true;
    }

    private LateralPPDesc.PPTypes getPPType(PPNode pPNode) {
        PPModNode pPModNode;
        if (pPNode instanceof PPModNode && ((pPModNode = (PPModNode)pPNode).getModifier() == 1 || pPModNode.getModifier() == 2 || pPModNode.getModifier() == 3) && pPModNode.getNumChildren() == 1 && pPModNode.getChild(0) instanceof PPIRINode) {
            PPIRINode pPIRINode = (PPIRINode)pPModNode.getChild(0);
            if (pPModNode.getDirection() == pPIRINode.getDirection()) {
                if (pPModNode.getModifier() == 1) {
                    return LateralPPDesc.PPTypes.STAR_FORWARD;
                }
                if (pPModNode.getModifier() == 3) {
                    return LateralPPDesc.PPTypes.RANGE_FORWARD;
                }
                return LateralPPDesc.PPTypes.PLUS_FORWARD;
            }
            if (pPModNode.getModifier() == 1) {
                return LateralPPDesc.PPTypes.STAR_REVERSE;
            }
            if (pPModNode.getModifier() == 3) {
                return LateralPPDesc.PPTypes.RANGE_REVERSE;
            }
            return LateralPPDesc.PPTypes.PLUS_REVERSE;
        }
        return LateralPPDesc.PPTypes.OTHER;
    }

    private boolean isSelective() {
        if (this.disconnected) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (SPARQLTriplesBlock object : this.myTrips) {
            boolean bl;
            ASTTripleAtom aSTTripleAtom = object.getSubject();
            ASTTripleAtom aSTTripleAtom2 = object.getPredicate();
            ASTTripleAtom aSTTripleAtom3 = object.getObject();
            boolean bl2 = bl = aSTTripleAtom2.type == 1 && QueryUtils.isUnselectiveProperty(aSTTripleAtom2.name);
            if (aSTTripleAtom.type != 0) {
                return true;
            }
            hashSet.add(aSTTripleAtom.name);
            if (bl) continue;
            if (aSTTripleAtom3.type != 0) {
                return true;
            }
            hashSet.add(aSTTripleAtom3.name);
        }
        for (Filter filter : this.filters) {
            if (!filter.containsConstant() || !QueryUtils.containsAny(filter.getVars(), hashSet)) continue;
            return true;
        }
        return false;
    }

    private boolean lateralPPEnabled() {
        return !this.ctx.disableLatPPOpt && this.ctx.minLabel.length() == 0 && this.ctx.asOfClause == null && this.ctx.lateralPPOptEnabled;
    }

    private boolean lateralPPRangeEnabled() {
        return this.ctx.lateralPPRangeOptEnabled;
    }

    private boolean createsLateralCycle(LateralPPDesc lateralPPDesc, SortedSet<LateralPPDesc> sortedSet) {
        if (sortedSet.isEmpty()) {
            return false;
        }
        sortedSet.add(lateralPPDesc);
        Stack<Integer> stack = new Stack<Integer>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Integer n = -1;
        boolean bl = false;
        while (n != null && !bl) {
            n = this.getNextStartAlias(sortedSet, hashSet);
            if (n == null) continue;
            stack.push(n);
            hashSet.add(n);
            bl = this.dfsFindCycle(sortedSet, stack, hashSet);
        }
        sortedSet.remove(lateralPPDesc);
        return bl;
    }

    private Integer getNextStartAlias(SortedSet<LateralPPDesc> sortedSet, Set<Integer> set) {
        for (LateralPPDesc lateralPPDesc : sortedSet) {
            Integer n = lateralPPDesc.depAlias;
            if (set.contains(n)) continue;
            return n;
        }
        return null;
    }

    private boolean dfsFindCycle(SortedSet<LateralPPDesc> sortedSet, Stack<Integer> stack, Set<Integer> set) {
        Integer n = stack.peek();
        List<Integer> list = this.getOutgoingAliases(n, sortedSet);
        boolean bl = false;
        Iterator<Integer> iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            Integer n2 = iterator.next();
            set.add(n2);
            if (stack.contains(n2)) {
                bl = true;
            }
            if (bl) continue;
            stack.push(n2);
            bl = this.dfsFindCycle(sortedSet, stack, set);
            stack.pop();
        }
        return bl;
    }

    private List<Integer> getOutgoingAliases(Integer n, SortedSet<LateralPPDesc> sortedSet) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (LateralPPDesc lateralPPDesc : sortedSet) {
            if (!n.equals(lateralPPDesc.depAlias)) continue;
            arrayList.add(lateralPPDesc.alias);
        }
        return arrayList;
    }

    private void addAutoOptimizerHints() {
        if (this.ctx.useAutoHints) {
            String string = this.userHint;
            boolean bl = false;
            if (this.globalSelectivity == 0) {
                bl = true;
                if (this.ctx.useAutoValueHints) {
                    string = QueryUtils.updateValueHintForAllHash(string);
                }
                if (this.bgp.numTriples() > 1 && this.ctx.useAutoLinkHints) {
                    string = QueryUtils.updateLinkHintForAllHash(string);
                }
            }
            if (bl) {
                this.addUserHint(string);
            }
        }
    }

    private static String nullToEmptyString(String string) {
        return string != null ? string : "";
    }

    private String buildOptimizedTpJoin(String string, String string2) {
        String string3 = this.getSPMOptimizedCol(string);
        String string4 = this.getSPMOptimizedCol(string2);
        String[] stringArray = string3.split("\\.");
        String[] stringArray2 = string4.split("\\.");
        boolean bl = false;
        if (stringArray[0].equals(stringArray2[0])) {
            if (stringArray[0].startsWith("SVP") && stringArray[1].equals(this.subjectCol) && stringArray2[1].equals(this.subjectCol)) {
                bl = true;
            }
            if (stringArray[0].startsWith("PCN") && stringArray[1].equals(stringArray2[1])) {
                bl = true;
            }
        }
        return bl ? "1=1" : string3 + " = " + string4;
    }

    private String getSPMOptimizedCol(String string) {
        String string2 = this.svpColMap.get(string);
        if (string2 == null && (string2 = this.pcnColMap.get(string)) == null) {
            string2 = this.mvpColMap.get(string);
        }
        return string2 != null ? string2 : string;
    }

    private String getSPMOptimizedValCol(String string) {
        String string2 = this.spmValColMap.get(string);
        return string2 != null ? string2 : string;
    }

    private void processSPMInfo() {
        this.minClusterSize = this.ctx.minSvpClusterSize;
        this.spmCoveredTripleIds = new HashSet<Integer>();
        if (this.ctx.preferPcn) {
            this.buildPCNChainList();
            this.buildPCNColMapping();
        }
        this.buildSVPClusterList();
        if (this.ctx.dmpSQL) {
            this.dumpSVPClusterList();
        }
        this.filterSVPClusterList();
        this.buildSVPColMapping();
        if (!this.ctx.preferPcn) {
            this.buildPCNChainList();
            this.buildPCNColMapping();
        }
        this.buildMVPPredList();
        this.buildMVPColMapping();
        this.buildExcludedTripleTabsSet();
        this.popSPMAuxValInfo();
        if (this.ctx.dmpSQL) {
            this.dumpSVPClusterList();
            this.dumpSVPColMap();
            this.dumpSVPAliasSet();
            this.dumpPCNChainList();
            this.dumpPCNColMap();
            this.dumpPCNAliasSet();
            this.dumpMVPPredList();
            this.dumpMVPColMap();
            this.dumpMVPAliasSet();
            this.dumpExcludedTabs();
            this.dumpSPMValColMap();
            this.dumpExcludedValTabs();
            this.dumpAuxValueVars();
        }
    }

    private void buildSVPClusterList() {
        HashMap<TriplesBlock.Element, ArrayList<SPMColDesc>> hashMap = new HashMap<TriplesBlock.Element, ArrayList<SPMColDesc>>();
        ArrayList<SPMColDesc> arrayList = null;
        int n = 0;
        for (TriplesBlock object : this.bgp.TBList) {
            TriplesBlock.Element element = object.getPredicate();
            if (element.getType() == 1 && element.exists() && !this.spmCoveredTripleIds.contains(n)) {
                Long l = element.getCanonicalID();
                arrayList = (ArrayList<SPMColDesc>)hashMap.get(object.getSubject());
                if (arrayList == null) {
                    arrayList = new ArrayList<SPMColDesc>();
                    hashMap.put(object.getSubject(), arrayList);
                }
                arrayList.add(new SPMColDesc(n, l.toString()));
            }
            ++n;
        }
        this.svpClusterList = new ArrayList<List<SPMColDesc>>();
        this.svpBestTabNameList = new ArrayList<String>();
        for (Map.Entry entry : hashMap.entrySet()) {
            this.svpClusterList.add((List<SPMColDesc>)entry.getValue());
            this.svpBestTabNameList.add(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void filterSVPClusterList() {
        Iterator<List<SPMColDesc>> iterator = this.svpClusterList.iterator();
        ListIterator<String> listIterator = this.svpBestTabNameList.listIterator();
        while (iterator.hasNext()) {
            Object object;
            List<SPMColDesc> list = iterator.next();
            listIterator.next();
            Iterator<SPMColDesc> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                for (String string : this.ctx.svpPropSetMap.keySet()) {
                    Set<String> set = this.ctx.svpPropSetMap.get(string);
                    if (!set.contains(((SPMColDesc)object).predId)) continue;
                    ((SPMColDesc)object).svpTabNameSet.add(string);
                }
                if (((SPMColDesc)object).svpTabNameSet.size() != 0) continue;
                iterator2.remove();
            }
            if (list.size() >= this.minClusterSize) {
                iterator2 = list.iterator();
                object = new HashMap();
                int n = 0;
                while (iterator2.hasNext()) {
                    SPMColDesc sPMColDesc = iterator2.next();
                    for (String string : sPMColDesc.svpTabNameSet) {
                        int n2 = !object.containsKey(string) ? 0 : (Integer)object.get(string);
                        object.put(string, n2 + 1);
                        if (n >= n2 + 1) continue;
                        n = n2 + 1;
                    }
                }
                if (n >= this.minClusterSize) {
                    void var7_12;
                    Object var7_11 = null;
                    int n3 = Integer.MAX_VALUE;
                    for (Map.Entry entry : object.entrySet()) {
                        int n4;
                        String string = (String)entry.getKey();
                        if ((Integer)entry.getValue() != n || (n4 = this.ctx.svpPropSetMap.get(string).size()) >= n3) continue;
                        n3 = n4;
                        String string2 = string;
                    }
                    if (n < list.size()) {
                        iterator2 = list.iterator();
                        while (iterator2.hasNext()) {
                            SPMColDesc sPMColDesc = iterator2.next();
                            if (sPMColDesc.svpTabNameSet.contains(var7_12)) continue;
                            iterator2.remove();
                        }
                    }
                    listIterator.set((String)var7_12);
                }
            }
            if (list.size() >= this.minClusterSize) continue;
            iterator.remove();
            listIterator.remove();
        }
    }

    private void buildSVPColMapping() {
        this.svpColMap = new HashMap<String, String>();
        this.svpAliasSet = new HashSet<String>();
        int n = 0;
        for (List<SPMColDesc> list : this.svpClusterList) {
            String string = "SVP" + n;
            this.svpAliasSet.add(string);
            for (SPMColDesc sPMColDesc : list) {
                String string2 = "T" + sPMColDesc.tripleId;
                this.spmCoveredTripleIds.add(sPMColDesc.tripleId);
                this.svpColMap.put(string2 + "." + this.subjectCol, string + "." + this.subjectCol);
                this.svpColMap.put(string2 + "." + this.predicateCol, string + ".P" + sPMColDesc.predId);
                this.svpColMap.put(string2 + "." + this.canonObjCol, string + ".P" + sPMColDesc.predId);
                this.svpColMap.put(string2 + "." + this.gidCol, string + ".G" + sPMColDesc.predId);
            }
            ++n;
        }
    }

    private void buildPCNChainList() {
        this.pcnChainList = new ArrayList<List<SPMColDesc>>();
        for (Map.Entry<String, List<String>> entry : this.ctx.sortedPcnPropList) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            boolean bl = true;
            while (bl) {
                List<SPMColDesc> list2 = this.matchChain(string, list);
                if (list2 != null) {
                    for (SPMColDesc sPMColDesc : list2) {
                        this.spmCoveredTripleIds.add(sPMColDesc.tripleId);
                    }
                    this.pcnChainList.add(list2);
                    continue;
                }
                bl = false;
            }
        }
    }

    private List<SPMColDesc> matchChain(String string, List<String> list) {
        ArrayList<SPMColDesc> arrayList = new ArrayList<SPMColDesc>();
        boolean bl = this.matchChain(string, list, 0, null, null, arrayList);
        if (!bl) {
            arrayList = null;
        }
        return arrayList;
    }

    private boolean matchChain(String string, List<String> list, int n, TriplesBlock.Element element, TriplesBlock.Element element2, List<SPMColDesc> list2) {
        if (n >= list.size()) {
            return true;
        }
        TriplesBlock[] triplesBlockArray = new TriplesBlock[1];
        int[] nArray = new int[1];
        String string2 = list.get(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.bgp.TBList.size()) {
            if (this.findMatch(element, string2, element2, n2, triplesBlockArray, nArray)) {
                SPMColDesc sPMColDesc = new SPMColDesc(nArray[0], string2);
                sPMColDesc.svpTabNameSet.add(string);
                list2.add(sPMColDesc);
                bl = this.matchChain(string, list, n + 1, triplesBlockArray[0].getObject(), null, list2);
                if (bl) {
                    return true;
                }
                n2 = nArray[0] + 1;
                list2.remove(list2.size() - 1);
                continue;
            }
            return false;
        }
        return false;
    }

    private boolean findMatch(TriplesBlock.Element element, String string, TriplesBlock.Element element2, int n, TriplesBlock[] triplesBlockArray, int[] nArray) {
        boolean bl = false;
        for (int i = n; i < this.bgp.TBList.size() && !bl; ++i) {
            TriplesBlock.Element element3;
            TriplesBlock triplesBlock = this.bgp.TBList.get(i);
            if (this.spmCoveredTripleIds.contains(i) || (element3 = triplesBlock.getPredicate()).getType() != 1 || !element3.exists() || !string.equals(element3.getCanonicalID().toString())) continue;
            bl = true;
            if (element != null && !triplesBlock.getSubject().equals(element)) {
                bl = false;
            }
            if (element2 != null && bl && !triplesBlock.getObject().equals(element2)) {
                bl = false;
            }
            if (!bl) continue;
            triplesBlockArray[0] = triplesBlock;
            nArray[0] = i;
        }
        return bl;
    }

    private void buildPCNColMapping() {
        this.pcnColMap = new HashMap<String, String>();
        this.pcnAliasSet = new HashSet<String>();
        int n = 0;
        for (List<SPMColDesc> list : this.pcnChainList) {
            String string = "PCN" + n;
            this.pcnAliasSet.add(string);
            for (int i = 0; i < list.size(); ++i) {
                SPMColDesc sPMColDesc = list.get(i);
                String string2 = "T" + sPMColDesc.tripleId;
                if (i == 0) {
                    this.pcnColMap.put(string2 + "." + this.subjectCol, string + "." + this.subjectCol);
                } else {
                    SPMColDesc sPMColDesc2 = list.get(i - 1);
                    this.pcnColMap.put(string2 + "." + this.subjectCol, string + ".P" + sPMColDesc2.predId);
                }
                this.pcnColMap.put(string2 + "." + this.predicateCol, string + ".P" + sPMColDesc.predId);
                this.pcnColMap.put(string2 + "." + this.canonObjCol, string + ".P" + sPMColDesc.predId);
                this.pcnColMap.put(string2 + "." + this.gidCol, string + ".G" + sPMColDesc.predId);
            }
            ++n;
        }
    }

    private void buildMVPPredList() {
        this.mvpPredList = new ArrayList<SPMColDesc>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            String string;
            TriplesBlock.Element element;
            if (!this.spmCoveredTripleIds.contains(n) && (element = triplesBlock.getPredicate()).getType() == 1 && element.exists() && this.ctx.mvpPropSet.contains(string = element.getCanonicalID().toString())) {
                this.mvpPredList.add(new SPMColDesc(n, string));
                this.spmCoveredTripleIds.add(n);
            }
            ++n;
        }
    }

    private void buildMVPColMapping() {
        this.mvpColMap = new HashMap<String, String>();
        this.mvpAliasSet = new HashSet<String>();
        int n = 0;
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            String string = "MVP" + n;
            this.mvpAliasSet.add(string);
            String string2 = "T" + sPMColDesc.tripleId;
            this.mvpColMap.put(string2 + "." + this.subjectCol, string + "." + this.subjectCol);
            this.mvpColMap.put(string2 + "." + this.predicateCol, string + ".P" + sPMColDesc.predId);
            this.mvpColMap.put(string2 + "." + this.canonObjCol, string + ".P" + sPMColDesc.predId);
            this.mvpColMap.put(string2 + "." + this.gidCol, string + ".G" + sPMColDesc.predId);
            ++n;
        }
    }

    private void popSPMAuxValInfo() {
        this.spmValColMap = new HashMap<String, String>();
        this.excludedValueTabs = new HashSet<String>();
        this.auxValueVars = new HashSet<String>();
        this.auxVarMappedAliases = new HashMap<String, String>();
        if (this.isValidForSPMValuesOpt()) {
            int n = 0;
            for (TriplesBlock triplesBlock : this.bgp.TBList) {
                TriplesBlock.Element element = triplesBlock.getPredicate();
                TriplesBlock.Element element2 = triplesBlock.getObject();
                if (element.getType() == 1 && element.exists() && element2.isVariable()) {
                    int n2;
                    String string;
                    String string2;
                    String string3 = element.getCanonicalID().toString();
                    String string4 = element2.getName();
                    boolean bl = false;
                    int n3 = this.getSvpPcnAliasIdForPred(n, string3, this.svpClusterList);
                    String string5 = null;
                    if (n3 >= 0) {
                        string5 = this.svpBestTabNameList.get(n3);
                    }
                    if (n3 >= 0 && this.ctx.svpValuePropSetMap.get(string5).contains(string3) && n3 >= 0) {
                        bl = true;
                        string2 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)element2.getName()).append((String)",2").toString()).uniqueId;
                        string = "SVP" + n3 + ".P" + string3 + "_";
                        this.addVarMapping(string2, string, string4);
                    }
                    if (!bl && (n3 = this.getSvpPcnAliasIdForPred(n, string3, this.pcnChainList)) >= 0 && this.ctx.pcnValuePropSetMap.get(this.getPcnTabNameForChainId(n3)).contains(string3)) {
                        bl = true;
                        string2 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)element2.getName()).append((String)",2").toString()).uniqueId;
                        string = "PCN" + n3 + ".P" + string3 + "_";
                        this.addVarMapping(string2, string, string4);
                    }
                    if (!bl && this.ctx.mvpValuePropSet.contains(string3) && (n2 = this.getMVPAliasIdForPred(n, string3)) >= 0) {
                        string = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)element2.getName()).append((String)",2").toString()).uniqueId;
                        String string6 = "MVP" + n2 + ".P" + string3 + "_";
                        this.addVarMapping(string, string6, string4);
                    }
                }
                ++n;
            }
        }
    }

    private void addVarMapping(String string, String string2, String string3) {
        this.addValColMapping(this.spmValColMap, string3, string, string2);
        this.excludedValueTabs.add(string);
        if (this.ctx.spmValueProjEnabled) {
            this.auxValueVars.add(string3);
        }
    }

    private void addValColMapping(Map<String, String> map, String string, String string2, String string3) {
        String[] stringArray = new String[]{"VNAME_PREFIX", "VNAME_SUFFIX", "VALUE_TYPE", "LONG_VALUE", "LITERAL_TYPE", "LANGUAGE_TYPE", "ORDER_NUM", "ORDER_DATE", "ORDER_TYPE"};
        if (!map.containsKey(string2 + stringArray[0])) {
            for (int i = 0; i < stringArray.length; ++i) {
                map.put(string2 + "." + stringArray[i], string3 + stringArray[i]);
            }
            this.auxVarMappedAliases.put(string, string2);
        }
    }

    private String getPcnTabNameForChainId(int n) {
        return this.pcnChainList.get((int)n).get((int)0).svpTabNameSet.iterator().next();
    }

    private int getSvpPcnAliasIdForPred(int n, String string, List<List<SPMColDesc>> list) {
        int n2 = 0;
        for (List<SPMColDesc> list2 : list) {
            for (SPMColDesc sPMColDesc : list2) {
                if (sPMColDesc.tripleId != n || !sPMColDesc.predId.equals(string)) continue;
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int getMVPAliasIdForPred(int n, String string) {
        int n2 = 0;
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            if (sPMColDesc.tripleId == n && sPMColDesc.predId.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void buildExcludedTripleTabsSet() {
        this.excludedTripleTabs = new HashSet<String>();
        for (List<SPMColDesc> object : this.svpClusterList) {
            for (SPMColDesc sPMColDesc : object) {
                this.excludedTripleTabs.add("T" + sPMColDesc.tripleId);
            }
        }
        for (List<SPMColDesc> list : this.pcnChainList) {
            for (SPMColDesc sPMColDesc : list) {
                this.excludedTripleTabs.add("T" + sPMColDesc.tripleId);
            }
        }
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            this.excludedTripleTabs.add("T" + sPMColDesc.tripleId);
        }
    }

    private boolean isValidForSPMValuesOpt() {
        if (!this.ctx.spmValuesEnabled) {
            return false;
        }
        if (this.ctx.clobExpSupport) {
            return false;
        }
        for (Filter filter : this.filters) {
            if (!filter.hasSpatialFunction() && !filter.hasOracleTextFunction()) continue;
            return false;
        }
        return true;
    }

    private void dumpSVPClusterList() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== svpClusterArray ===============\n");
        int n = 0;
        for (List<SPMColDesc> list : this.svpClusterList) {
            stringBuffer.append("[" + n + "]->").append(list);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpSVPColMap() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== svpColMap =====================\n");
        for (Map.Entry<String, String> entry : this.svpColMap.entrySet()) {
            stringBuffer.append(entry.getKey()).append("->").append(entry.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpSVPAliasSet() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== svpAliasSet ===================\n");
        stringBuffer.append(this.svpAliasSet.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpPCNChainList() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== pcnChainList ==================\n");
        int n = 0;
        for (List<SPMColDesc> list : this.pcnChainList) {
            stringBuffer.append("[" + n + "]->").append(list);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpPCNColMap() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== pcnColMap =====================\n");
        for (Map.Entry<String, String> entry : this.pcnColMap.entrySet()) {
            stringBuffer.append(entry.getKey()).append("->").append(entry.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpPCNAliasSet() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== pcnAliasSet ===================\n");
        stringBuffer.append(this.pcnAliasSet.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpMVPPredList() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== mvpPredList ==================\n");
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            stringBuffer.append(sPMColDesc.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpMVPColMap() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== mvpColMap =====================\n");
        for (Map.Entry<String, String> entry : this.mvpColMap.entrySet()) {
            stringBuffer.append(entry.getKey()).append("->").append(entry.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpMVPAliasSet() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== mvpAliasSet ===================\n");
        stringBuffer.append(this.mvpAliasSet.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpExcludedTabs() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=========== excludedTripleTabs ================\n");
        stringBuffer.append(this.excludedTripleTabs.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpSPMValColMap() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("============= spmValColMap ====================\n");
        for (Map.Entry<String, String> entry : this.spmValColMap.entrySet()) {
            stringBuffer.append(entry.getKey()).append("->").append(entry.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpExcludedValTabs() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=========== excludedValueTabs =================\n");
        stringBuffer.append(this.excludedValueTabs.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpAuxValueVars() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("============= auxValueVars ====================\n");
        stringBuffer.append(this.auxValueVars.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private static class LateralPPDesc
    implements Comparable<LateralPPDesc> {
        public final int alias;
        public final int depAlias;
        public final PPJoinPositions ppJoinPos;
        public final String ppJoinCol;
        public final PPTypes ppType;
        public final String ppPredId;
        public final String ppPred;
        public final int minOcc;
        public final int maxOcc;
        public final boolean exact;

        public LateralPPDesc(int n, int n2, PPJoinPositions pPJoinPositions, String string, PPTypes pPTypes, String string2, String string3, int n3, int n4, boolean bl) {
            this.alias = n;
            this.depAlias = n2;
            this.ppJoinPos = pPJoinPositions;
            this.ppJoinCol = string;
            this.ppType = pPTypes;
            this.ppPredId = string2;
            this.ppPred = string3;
            this.minOcc = n3;
            this.maxOcc = n4;
            this.exact = bl;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof LateralPPDesc) {
                LateralPPDesc lateralPPDesc = (LateralPPDesc)object;
                if (this.alias == lateralPPDesc.alias && this.depAlias == lateralPPDesc.depAlias && this.ppJoinPos.equals((Object)lateralPPDesc.ppJoinPos) && this.ppJoinCol.equals(lateralPPDesc.ppJoinCol) && this.ppType.equals((Object)lateralPPDesc.ppType) && this.ppPredId.equals(lateralPPDesc.ppPredId) && this.ppPred.equals(lateralPPDesc.ppPred) && this.minOcc == lateralPPDesc.minOcc && this.maxOcc == lateralPPDesc.maxOcc && this.exact == lateralPPDesc.exact) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(LateralPPDesc lateralPPDesc) {
            if (this.depAlias < lateralPPDesc.depAlias) {
                return -1;
            }
            if (this.depAlias > lateralPPDesc.depAlias) {
                return 1;
            }
            if (this.equals(lateralPPDesc)) {
                return 0;
            }
            if (this.alias < lateralPPDesc.alias) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return "[" + this.alias + "," + this.depAlias + "," + (Object)((Object)this.ppJoinPos) + "," + this.ppJoinCol + "," + (Object)((Object)this.ppType) + "," + this.ppPredId + "," + this.ppPred + "," + this.minOcc + "," + this.maxOcc + "," + this.exact + "]";
        }

        public static enum PPTypes {
            STAR_FORWARD,
            PLUS_FORWARD,
            RANGE_FORWARD,
            STAR_REVERSE,
            PLUS_REVERSE,
            RANGE_REVERSE,
            OTHER;

        }

        public static enum PPJoinPositions {
            SUBJ,
            OBJ;

        }
    }

    private static class SPMColDesc {
        public final int tripleId;
        public final String predId;
        public Set<String> svpTabNameSet;

        public SPMColDesc(int n, String string) {
            this.tripleId = n;
            this.predId = string;
            this.svpTabNameSet = new HashSet<String>();
        }

        public String toString() {
            return "(T" + this.tripleId + ", pred=" + this.predId + ", tables=" + this.svpTabNameSet + ")";
        }
    }
}

