/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import oracle.spatial.rdf.server.QueryUtils;

public class URIset
implements Cloneable {
    private static final int VALUE_CHUNK_SIZE = 500;
    protected HashMap set = new HashMap();

    public void clear() {
        this.set.clear();
    }

    public void put(String string) {
        this.set.put(string, null);
    }

    public String get(String string) {
        return (String)this.set.get(string);
    }

    public String getOrCreate(Connection connection, String string) throws SQLException {
        String string2 = (String)this.set.get(string);
        if (string2 == null) {
            return this.create(connection, string);
        }
        return string2;
    }

    private void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    private void log(String string, String string2) {
        System.out.print("\n");
        System.out.print(string);
        System.out.print(string2);
    }

    public void updateToCanonicalIDs(Connection connection, String string, String string2) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string32 = null;
        String string4 = "_:";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string32 : this.set.keySet()) {
            if (string32.startsWith(string4)) continue;
            Object var10_10 = null;
            try {
                String string5 = "SELECT CLIQUE_ID FROM " + string2 + "RDFC_" + string + " cl  WHERE cl.value_id=?";
                statement = connection.prepareStatement(string5.toString());
                statement.setString(1, (String)this.set.get(string32));
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String string6 = resultSet.getString("CLIQUE_ID");
                    hashMap.put(string32, string6);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while retrieveing OPT_SAMEAS IDs:", exception);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement == null) continue;
                statement.close();
            }
        }
        this.set.putAll(hashMap);
    }

    public void resolve(Connection connection) throws SQLException {
        this.resolve(connection, "\"MDSYS\".RDF_VALUE$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(Connection connection, String string) throws SQLException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ResultSet resultSet = null;
        Statement statement = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = "SELECT /*+ INDEX(v " + string + "RDF_VAL_NAMETYLITLNG_IDX) */ VNAME_PREFIX || VNAME_SUFFIX AS VALUE_NAME, VALUE_ID\n  FROM " + string + " v\n";
        String string6 = " WHERE VALUE_TYPE='UR'\n   AND (VNAME_PREFIX,VNAME_SUFFIX) IN (";
        String string7 = "(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?)";
        String string8 = " WHERE VALUE_TYPE IN ('UR','BN')\n   AND VNAME_SUFFIX IS NULL\n   AND VNAME_PREFIX IN (";
        String string9 = "?,?,?,?,?,?,?,?,?,?";
        String string10 = "_:";
        if (this.set.size() == 0) {
            return;
        }
        try {
            int n = this.set.keySet().size();
            int n2 = n / 500;
            if (n % 500 > 0) {
                ++n2;
            }
            Object[] objectArray = this.set.keySet().toArray();
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4;
                int n5;
                int n6 = i * 500;
                int n7 = n6 + 500;
                if (n < n7 - 1) {
                    n7 = n;
                }
                if ((n5 = (n4 = n7 - n6) / 10) * 10 < n4) {
                    ++n5;
                }
                int n8 = n5 * 10;
                stringBuffer.setLength(0);
                stringBuffer.append(string5);
                stringBuffer.append(string6);
                stringBuffer.append(string7);
                for (n3 = 1; n3 < n5; ++n3) {
                    stringBuffer.append("," + string7);
                }
                stringBuffer.append(")");
                stringBuffer.append("\n UNION ALL \n");
                stringBuffer.append(string5);
                stringBuffer.append(string8);
                stringBuffer.append(string9);
                for (n3 = 1; n3 < n5; ++n3) {
                    stringBuffer.append("," + string9);
                }
                stringBuffer.append(")");
                statement = connection.prepareStatement(stringBuffer.toString());
                int[] nArray = null;
                nArray = new int[n4];
                Arrays.fill(nArray, 0);
                int n9 = 0;
                int n10 = 1;
                int n11 = n6;
                while (n11 < n7) {
                    string2 = (String)objectArray[n11];
                    if (!string2.startsWith(string10) && (string3 = QueryUtils.valueNamePrefix(string2, "UR")).length() < string2.length()) {
                        string4 = string2.substring(string3.length());
                        statement.setString(n10, string3);
                        statement.setString(n10 + 1, string4);
                        n10 += 2;
                        nArray[n9] = 1;
                    }
                    ++n11;
                    ++n9;
                }
                while (n10 <= 2 * n8) {
                    statement.setString(n10, null);
                    statement.setString(n10 + 1, null);
                    n10 += 2;
                }
                n9 = 0;
                n11 = n6;
                while (n11 < n7) {
                    string2 = (String)objectArray[n11];
                    if (nArray[n9] == 0) {
                        statement.setString(n10, string2);
                        ++n10;
                    }
                    ++n11;
                    ++n9;
                }
                while (n10 <= 3 * n8) {
                    statement.setString(n10, null);
                    ++n10;
                }
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String string11 = resultSet.getString("VALUE_NAME");
                    String string12 = resultSet.getString("VALUE_ID");
                    this.set.put(string11, QueryUtils.simpleSQLName(string12, string12.length()));
                }
                if (resultSet != null && !resultSet.isClosed()) {
                    resultSet.close();
                }
                if (statement == null || statement.isClosed()) continue;
                statement.close();
            }
        }
        finally {
            if (resultSet != null && !resultSet.isClosed()) {
                resultSet.close();
            }
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve2(Connection connection) throws SQLException {
        ResultSet resultSet = null;
        Statement statement = null;
        if (this.set.size() == 0) {
            return;
        }
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT /*+ INDEX(v RDF_VAL_NAMETYLITLNG_IDX) */ v.VNAME_PREFIX || v.VNAME_SUFFIX AS  VALUE_NAME,").append(" v.VALUE_ID\n").append("  FROM MDSYS.RDF_VALUE$ v\n").append("  WHERE ( (     v.VALUE_TYPE = 'UR' ").append("            AND substr(mdsys.rdf_apis.syn_orig_value(v.vname_prefix || v.vname_suffix,  ").append("             v.value_type, v.literal_type, v.language_type),1,4000) IN (");
            for (n = 0; n < this.set.keySet().size(); ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("substr(mdsys.rdf_apis.syn_orig_value(?,'UR',null,null),1,4000)");
            }
            stringBuffer.append("))\n");
            stringBuffer.append(") union all ").append("SELECT /*+ INDEX(v RDF_VAL_NAMETYLITLNG_IDX) */ v.VNAME_PREFIX || v.VNAME_SUFFIX AS VALUE_NAME,").append(" v.VALUE_ID\n").append("  FROM MDSYS.RDF_VALUE$ v\n").append("  WHERE ( ( v.VALUE_TYPE = 'BN' ").append("            AND substr(mdsys.rdf_apis.syn_orig_value(v.vname_prefix || v.vname_suffix,  ").append("             v.value_type, v.literal_type, v.language_type),1,4000) IN (");
            for (n = 0; n < this.set.keySet().size(); ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("substr(mdsys.rdf_apis.syn_orig_value(?,'BN',null,null),1,4000)");
            }
            stringBuffer.append(")))");
            statement = connection.prepareStatement(stringBuffer.toString());
            int n2 = 1;
            Object object = this.set.keySet().iterator();
            while (object.hasNext()) {
                statement.setString(n2, (String)object.next());
                ++n2;
            }
            object = this.set.keySet().iterator();
            while (object.hasNext()) {
                statement.setString(n2, (String)object.next());
                ++n2;
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("VALUE_NAME");
                String string = resultSet.getString("VALUE_ID");
                this.set.put(object, string);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(Connection connection, String string) throws SQLException {
        String string2;
        String string3 = "{?= call mdsys.rdf_apis_internal.createnode(?)}";
        try (CallableStatement callableStatement = null;){
            callableStatement = connection.prepareCall(string3);
            callableStatement.registerOutParameter(1, 12);
            callableStatement.setString(2, string);
            callableStatement.execute();
            string2 = callableStatement.getString(1);
            this.set.put(string, QueryUtils.simpleSQLName(string2, string2.length()));
        }
        return string2;
    }

    public void createUnresolved(Connection connection) throws SQLException {
        for (String string : this.set.keySet()) {
            if (this.set.get(string) != null) continue;
            this.create(connection, string);
        }
    }

    public String toString() {
        String string = "URISet:\n";
        for (String string2 : this.set.keySet()) {
            String string3 = (String)this.set.get(string2);
            string = string + " " + string2 + " -> " + string3 + "\n";
        }
        return string;
    }

    public Object clone() throws CloneNotSupportedException {
        URIset uRIset = new URIset();
        uRIset.set.putAll(this.set);
        return uRIset;
    }
}

