/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class ValuesSPARQLTreeNode
extends AbstractSPARQLTreeNode
implements SPARQLTreeNode {
    private List<String> vars;
    private Set<String> varSet;
    private Set<String> varSetView;
    private Node[][] valuesArray;
    private String sqlTrans;

    public ValuesSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2, List<String> list, Node[][] nodeArray) throws RDFException {
        super(n, sQLGenContext, n2);
        this.vars = list;
        this.valuesArray = nodeArray;
        this.varSet = new HashSet<String>(list);
        this.varSetView = Collections.unmodifiableSet(this.varSet);
        this.translateSQL();
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        if (this.myDefBoundVars == null) {
            int n;
            this.myDefBoundVars = new HashSet();
            int n2 = this.vars.size();
            boolean[] blArray = new boolean[n2];
            for (n = 0; n < n2; ++n) {
                blArray[n] = true;
            }
            block1: for (n = 0; n < n2; ++n) {
                for (int i = 0; i < this.valuesArray.length; ++i) {
                    if (((SimpleNode)this.valuesArray[i][n]).id != 91) continue;
                    blArray[n] = false;
                    continue block1;
                }
            }
            for (n = 0; n < n2; ++n) {
                if (!blArray[n]) continue;
                this.myDefBoundVars.add(this.vars.get(n));
            }
            this.myDefBoundVars = Collections.unmodifiableSet(this.myDefBoundVars);
        }
        return this.myDefBoundVars;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        return this.getDefiniteBoundVars();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsEmptyBGP() {
        return false;
    }

    @Override
    public void setProjections() throws RDFException {
    }

    @Override
    public Set<String> getAllLexVars() {
        return this.getRequiredLexVars();
    }

    @Override
    public Set<String> getRequiredLexVars() {
        return this.myRequiredLexVars;
    }

    @Override
    public Set<String> getCumulativeVars() {
        return this.varSetView;
    }

    @Override
    public Set<String> getCumulativeAndPushedVars() {
        return this.getCumulativeVars();
    }

    @Override
    public Set<String> getProjectVars() {
        return this.varSetView;
    }

    @Override
    public Set<String> getPushCandidates() {
        if (!this.ctx.useExactForExpr) {
            Set<String> set = Collections.emptySet();
            return set;
        }
        return this.varSetView;
    }

    @Override
    public void resetVarLists() {
        this.myCumulativeVars = null;
        this.myCumulativeAndPushedVars = null;
        this.myAllLexVars = null;
        this.myDefBoundVars = null;
        this.myDefBoundAndPushedVars = null;
        this.myPushCandidates = null;
        this.myCumulativeHintVars = null;
        this.myProjectVars = null;
        this.myCumulativeBindVars = null;
        for (int i = 0; i < this.getNumChildren(); ++i) {
            this.getChild(i).resetVarLists();
        }
    }

    @Override
    public int setGlobalSelectivity(int n) {
        this.nodeSelectivity = 1;
        return 1;
    }

    @Override
    public String toSQL() throws RDFException {
        return this.sqlTrans;
    }

    private void translateSQL() throws RDFException {
        this.myRequiredLexVars = new HashSet();
        StringBuffer stringBuffer = new StringBuffer("");
        boolean[] blArray = new boolean[]{false};
        for (int i = 0; i < this.valuesArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("UNION ALL\n");
            }
            Node[] nodeArray = this.valuesArray[i];
            stringBuffer.append("SELECT\n");
            for (int j = 0; j < nodeArray.length; ++j) {
                if (j > 0) {
                    stringBuffer.append(",\n");
                }
                blArray[0] = false;
                stringBuffer.append(this.buildProjectForNode(this.vars.get(j), nodeArray[j], blArray));
                if (!blArray[0]) continue;
                this.myRequiredLexVars.add(this.vars.get(j));
            }
            stringBuffer.append("\nFROM SYS.DUAL\n");
        }
        this.myRequiredLexVars = Collections.unmodifiableSet(this.myRequiredLexVars);
        this.sqlTrans = stringBuffer.toString();
    }

    private String buildProjectForNode(String string, Node node, boolean[] blArray) throws RDFException {
        int n = ((SimpleNode)node).id;
        switch (n) {
            case 73: {
                return this.buildProjectForConst(string, (ASTTripleAtom)node, blArray);
            }
            case 91: {
                blArray[0] = false;
                return this.buildProjectForNull(string);
            }
        }
        throw new RDFException("Illegal value in VALUES clause");
    }

    private String buildProjectForConst(String string, ASTTripleAtom aSTTripleAtom, boolean[] blArray) throws RDFException {
        String string2 = "";
        try {
            String string3 = QueryUtils.enquoteLiteral(this.buildTermForConst(aSTTripleAtom));
            String string4 = QueryUtils.enquoteLiteral(aSTTripleAtom.name);
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            if (aSTTripleAtom.type == 1) {
                string5 = this.ctx.URImap.get(aSTTripleAtom.name);
                blArray[0] = false;
                if (string5 == null) {
                    string5 = "TO_NUMBER(NULL)";
                    blArray[0] = true;
                }
                string6 = "'URI'";
                string7 = "SDO_RDF.VNPFX(" + string3 + ")";
                string8 = "SDO_RDF.VNSFX(" + string3 + ")";
                string9 = "TO_CHAR(NULL)";
                string10 = "TO_CHAR(NULL)";
            } else {
                string5 = this.ctx.litMap.get(aSTTripleAtom);
                blArray[0] = false;
                if (string5 == null) {
                    string5 = "TO_NUMBER(NULL)";
                    blArray[0] = true;
                }
                string6 = "'LIT'";
                string7 = string4;
                string8 = "TO_CHAR(NULL)";
                string9 = aSTTripleAtom.litType != null ? QueryUtils.enquoteLiteral(aSTTripleAtom.litType) : "TO_CHAR(NULL)";
                string10 = aSTTripleAtom.litLang != null ? QueryUtils.enquoteLiteral(aSTTripleAtom.litLang) : "TO_CHAR(NULL)";
            }
            string2 = string5 + " " + string + "$RDFVID" + ", " + string4 + " " + string + ", " + string6 + " " + string + "$RDFVTYP" + ", " + string7 + " " + string + "$_PREFIX" + ", " + string8 + " " + string + "$_SUFFIX" + ", " + string9 + " " + string + "$RDFLTYP" + ", " + string10 + " " + string + "$RDFLANG" + ", TO_CLOB(NULL) " + string + "$RDFCLOB" + ", " + string3 + " " + string + "$RDFTERM";
        }
        catch (SQLException sQLException) {
            throw new RDFException(sQLException.getMessage());
        }
        return string2;
    }

    private String buildProjectForNull(String string) {
        return "TO_NUMBER(NULL) " + string + "$RDFVID" + ", TO_CHAR(NULL) " + string + ", TO_CHAR(NULL) " + string + "$RDFVTYP" + ", TO_CHAR(NULL) " + string + "$_PREFIX" + ", TO_CHAR(NULL) " + string + "$_SUFFIX" + ", TO_CHAR(NULL) " + string + "$RDFLTYP" + ", TO_CHAR(NULL) " + string + "$RDFLANG" + ", TO_CLOB(NULL) " + string + "$RDFCLOB" + ", TO_CHAR(NULL) " + string + "$RDFTERM";
    }

    private String buildTermForConst(ASTTripleAtom aSTTripleAtom) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer();
        switch (aSTTripleAtom.type) {
            case 1: {
                stringBuffer.append("<");
                stringBuffer.append(aSTTripleAtom.name);
                stringBuffer.append(">");
                break;
            }
            case 3: {
                stringBuffer.append("\"");
                stringBuffer.append(aSTTripleAtom.name);
                stringBuffer.append("\"");
                break;
            }
            case 4: {
                stringBuffer.append("\"");
                stringBuffer.append(aSTTripleAtom.name);
                stringBuffer.append("\"@");
                stringBuffer.append(aSTTripleAtom.litLang);
                break;
            }
            case 2: 
            case 5: {
                stringBuffer.append("\"");
                stringBuffer.append(aSTTripleAtom.name);
                stringBuffer.append("\"^^<");
                stringBuffer.append(aSTTripleAtom.litType);
                stringBuffer.append(">");
                break;
            }
            default: {
                throw new RDFException("Illegal value in VALUES clause");
            }
        }
        return stringBuffer.toString();
    }
}

