/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server.parser.sparql;

import java.util.SortedSet;
import java.util.TreeSet;
import oracle.spatial.rdf.server.parser.sparql.ASTTopLevelQueryNode;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.SparqlSelectDescriptor;
import oracle.spatial.rdf.server.parser.sparql.SparqlSolnModDesc;
import oracle.spatial.rdf.server.parser.sparql.SparqlSourceDescriptor;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;

public class ASTSelectQuery
extends SimpleNode
implements ASTTopLevelQueryNode {
    public String name = "";
    public SparqlSelectDescriptor selDesc = new SparqlSelectDescriptor();
    public SparqlSourceDescriptor sourceDesc = new SparqlSourceDescriptor();
    public SparqlSolnModDesc solnMod = new SparqlSolnModDesc();
    public boolean noGraphMask = false;
    private SortedSet<Integer> bindVars = new TreeSet<Integer>();

    public ASTSelectQuery(int n) {
        super(n);
        this.selDesc = new SparqlSelectDescriptor();
        this.sourceDesc = new SparqlSourceDescriptor();
        this.solnMod = new SparqlSolnModDesc();
        this.bindVars = new TreeSet<Integer>();
    }

    public ASTSelectQuery(sparqlParse sparqlParse2, int n) {
        super(sparqlParse2, n);
        this.selDesc = new SparqlSelectDescriptor();
        this.sourceDesc = new SparqlSourceDescriptor();
        this.solnMod = new SparqlSolnModDesc();
        this.bindVars = new TreeSet<Integer>();
    }

    @Override
    public Node cloneNode() {
        ASTSelectQuery aSTSelectQuery = new ASTSelectQuery(this.parser, this.id);
        aSTSelectQuery.children = null;
        aSTSelectQuery.parent = null;
        aSTSelectQuery.name = this.name;
        aSTSelectQuery.noGraphMask = this.noGraphMask;
        for (Integer n : this.bindVars) {
            aSTSelectQuery.addBindVar(n);
        }
        try {
            aSTSelectQuery.selDesc = (SparqlSelectDescriptor)this.selDesc.clone();
            aSTSelectQuery.sourceDesc = (SparqlSourceDescriptor)this.sourceDesc.clone();
            aSTSelectQuery.solnMod = (SparqlSolnModDesc)this.solnMod.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Error cloning query tree [ASTSelectQuery]");
            cloneNotSupportedException.printStackTrace();
        }
        return aSTSelectQuery;
    }

    @Override
    public String toString() {
        String string = "";
        string = string + super.toString() + " selectModifier: " + this.name;
        string = string + "\n SELECT [\n" + this.selDesc.toString() + "]\n";
        string = string + "\n FROM [\n" + this.sourceDesc.toString() + "]\n";
        string = string + "\n SOLN MOD [\n" + this.solnMod.toString() + "]\n";
        string = string + "\n BIND VARS " + this.bindVars.toString() + "\n";
        return string;
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + super.toString() + " selectModifier: " + this.name;
        string2 = string2 + "\n" + string + "SELECT [\n" + this.selDesc.toString(string) + string + "]\n";
        string2 = string2 + "\n" + string + "FROM [\n" + this.sourceDesc.toString(string) + string + "]\n";
        string2 = string2 + "\n" + string + "SOLN MOD [\n" + this.solnMod.toString(string) + string + "]\n";
        string2 = string2 + "\n" + string + "BIND VARS " + this.bindVars.toString() + "\n";
        string2 = string2 + "\n" + string + "========================\n";
        string2 = string2 + "\n" + string + "]\n";
        return string2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public SparqlSelectDescriptor getselDesc() {
        return this.selDesc;
    }

    @Override
    public void setselDesc(SparqlSelectDescriptor sparqlSelectDescriptor) {
        this.selDesc = sparqlSelectDescriptor;
    }

    @Override
    public SparqlSourceDescriptor getsourceDesc() {
        return this.sourceDesc;
    }

    @Override
    public void setsourceDesc(SparqlSourceDescriptor sparqlSourceDescriptor) {
        this.sourceDesc = sparqlSourceDescriptor;
    }

    @Override
    public SparqlSolnModDesc getsolnMod() {
        return this.solnMod;
    }

    @Override
    public void setsolnMod(SparqlSolnModDesc sparqlSolnModDesc) {
        this.solnMod = sparqlSolnModDesc;
    }

    @Override
    public boolean getType() {
        return true;
    }

    @Override
    public void addBindVar(int n) {
        this.bindVars.add(n);
    }

    @Override
    public SortedSet<Integer> getBindVars() {
        return this.bindVars;
    }

    @Override
    public String printSPARQLText() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.selDesc.getIsTopSelect()) {
            stringBuffer.append("{");
        }
        stringBuffer.append(this.selDesc.printSPARQLText());
        stringBuffer.append(this.sourceDesc.printSPARQLText());
        stringBuffer.append(super.printSPARQLText());
        if (!this.selDesc.getIsTopSelect()) {
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }
}

