/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server.parser.sparql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;
import oracle.spatial.rdf.server.parser.sparql.sparqlParseTreeConstants;

public class ASTTripleAtom
extends SimpleNode {
    public static final int ATOM_TYPE_VAR = 0;
    public static final int ATOM_TYPE_URI = 1;
    public static final int ATOM_TYPE_LITERAL_NUMERIC = 2;
    public static final int ATOM_TYPE_LITERAL_TEXT_PLAIN = 3;
    public static final int ATOM_TYPE_LITERAL_TEXT_LANG = 4;
    public static final int ATOM_TYPE_LITERAL_TEXT_TYPED = 5;
    public static final int ATOM_TYPE_LITERAL_TEXT_LANG_TYPED = 6;
    public static final int ATOM_TYPE_SYS_CTX_FUNCTION = 7;
    public static final int ATOM_TYPE_PROPERTY_PATH = 8;
    public static final int ATOM_TYPE_BIND_VAR = 9;
    public static final int ATOM_TYPE_BLANK_NODE = 10;
    public int bindId = -1;
    public int type = 0;
    public String name = null;
    public int flags;
    public static final int ATOM_FLAG_FOR_VPD_CONSTR = 1;
    public static final int ATOM_FLAG_INVIS_VPD_VAR = 2;
    public static final int ATOM_FLAG_LIT_IS_ID = 4;
    public static final int ATOM_FLAG_BN_IS_ANON = 8;
    public static final int ATOM_FLAG_SUBJECT = 16;
    public static final int ATOM_FLAG_PREDICATE = 32;
    public static final int ATOM_FLAG_OBJECT = 64;
    public String litLang = null;
    public String litType = null;
    public String networkStorageForm = "";

    public ASTTripleAtom(int n) {
        super(n);
    }

    public ASTTripleAtom(sparqlParse sparqlParse2, int n) {
        super(sparqlParse2, n);
    }

    @Override
    public Node cloneNode() {
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(this.parser, this.id);
        aSTTripleAtom.children = null;
        aSTTripleAtom.parent = null;
        aSTTripleAtom.type = this.type;
        aSTTripleAtom.bindId = this.bindId;
        aSTTripleAtom.name = this.name;
        aSTTripleAtom.flags = this.flags;
        aSTTripleAtom.litLang = this.litLang;
        aSTTripleAtom.litType = this.litType;
        aSTTripleAtom.networkStorageForm = this.networkStorageForm;
        return aSTTripleAtom;
    }

    public boolean literalHasLang() {
        return this.type == 4 || this.type == 6;
    }

    public boolean literalHasType() {
        return this.type == 5 || this.type == 6 || this.type == 2;
    }

    public static int getTextLiteralType(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return 6;
        }
        if (bl) {
            return 4;
        }
        if (bl2) {
            return 5;
        }
        return 3;
    }

    public boolean processSystemTypes() throws ParseException {
        return this.processInstructionType();
    }

    private boolean processInstructionType() throws ParseException {
        boolean bl = false;
        if (this.litType != null && this.litType.equals("http://xmlns.oracle.com/rdf/instruction")) {
            String string;
            bl = true;
            this.name = this.name.replace("\\'", "'");
            Pattern pattern = Pattern.compile("^\\s*SYS_CONTEXT\\s*\\(\\s*'[A-Za-z0-9_#\\$]+'\\s*,\\s*'[A-Za-z0-9_#\\$]+'\\s*\\)\\s*$");
            Matcher matcher = pattern.matcher(string = this.name.toUpperCase());
            if (!matcher.find()) {
                throw new ParseException("unsupported instruction used in literal " + this.name);
            }
            this.type = 7;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ASTTripleAtom)) {
            return false;
        }
        ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)object;
        if (this.type != aSTTripleAtom.type || !this.name.equals(aSTTripleAtom.name)) {
            return false;
        }
        if (this.literalHasType() && !this.litType.equals(aSTTripleAtom.litType)) {
            return false;
        }
        return !this.literalHasLang() || this.litLang.equals(aSTTripleAtom.litLang);
    }

    public int hashCode() {
        int n = this.type;
        n ^= this.name.hashCode();
        if (this.literalHasType()) {
            n ^= this.litType.hashCode();
        }
        if (this.literalHasLang()) {
            n ^= this.litLang.hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        String string = sparqlParseTreeConstants.jjtNodeName[this.id] + ": " + this.type + " \"" + this.name + "\"";
        if (this.bindId >= 0) {
            string = string + " (bindId: " + this.bindId + ")";
        }
        if (this.literalHasLang()) {
            string = string + " (lang: " + this.litLang + ")";
        }
        if (this.literalHasType()) {
            string = string + " (type: " + this.litType + ")";
        }
        return string;
    }

    public BindVar getBindVar() {
        if (this.type == 9) {
            return new BindVar(this.bindId, this.name);
        }
        return null;
    }

    private String serializeRDFTerm(boolean bl) throws ParseException {
        String string = this.name;
        if (bl) {
            string = QueryUtils.escapeSpecialChars(this.name);
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                stringBuffer.append("?");
                stringBuffer.append(this.name);
                break;
            }
            case 1: {
                stringBuffer.append("<");
                stringBuffer.append(this.name);
                stringBuffer.append(">");
                break;
            }
            case 2: {
                stringBuffer.append(this.name);
                break;
            }
            case 3: {
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
                break;
            }
            case 4: {
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\"@");
                stringBuffer.append(this.litLang);
                break;
            }
            case 5: {
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\"^^<");
                stringBuffer.append(this.litType);
                stringBuffer.append(">");
                break;
            }
            case 6: {
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
                break;
            }
            case 7: {
                throw new ParseException(this.name + "should not be used inside SERVICE");
            }
            case 8: {
                stringBuffer.append(this.name);
                break;
            }
            case 9: {
                throw new ParseException(this.name + "should not be used inside SERVICE");
            }
            case 10: {
                throw new ParseException(this.name + "should not be used inside SERVICE");
            }
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    @Override
    public String printSPARQLText() throws ParseException {
        boolean bl = false;
        if (this.networkStorageForm.equals("UNESC")) {
            bl = true;
        }
        return this.serializeRDFTerm(bl);
    }

    public String printSPARQLTextForUpd() throws ParseException {
        if (this.type == 10) {
            return this.name;
        }
        if (this.type == 2) {
            return "\"" + this.name + "\"^^<" + this.litType + ">";
        }
        return this.serializeRDFTerm(false).trim();
    }

    public static class BindVar {
        public int bvId = -1;
        public String bvName = "";

        public BindVar() {
            this.bvId = -1;
            this.bvName = "";
        }

        public BindVar(String string) {
            this.bvId = Integer.parseInt(string.substring(0, string.indexOf("$")));
            this.bvName = string.substring(string.indexOf("$") + 1);
        }

        public BindVar(int n, String string) {
            this.bvId = n;
            this.bvName = string;
        }

        public String getBVStr() {
            return String.valueOf(this.bvId) + "$" + this.bvName;
        }

        public String getIdCol() {
            return "BV" + this.bvId + ".VALUE_ID";
        }

        public String getTermCol() {
            return "BV" + this.bvId + ".TERM";
        }

        public String getAlias() {
            return "BV" + this.bvId;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BindVar)) {
                return false;
            }
            BindVar bindVar = (BindVar)object;
            if (this.bvId != bindVar.bvId) {
                return false;
            }
            return this.bvName.equals(bindVar.bvName);
        }

        public int hashCode() {
            String string = this.getBVStr();
            return string.hashCode();
        }
    }
}

