/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.util;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import oracle.spatial.rdf.util.RDFXMLParseException;
import oracle.sql.CLOB;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RDFXMLContentHandler
implements ContentHandler {
    private HashMap<String, String> nmspcMap = new HashMap();
    private Stack<RDFElement> rdfNodes = new Stack();
    private ArrayList<String> tripleAtoms;
    private StringBuffer currentTextData;
    private Connection conn;
    private PreparedStatement insTriple;
    private PreparedStatement insTripleWithClob;
    private String docid;
    private int modelid;
    private String loadMethod;
    private String targetTable;
    private String columnList;
    private String columnListWithClob;
    private int rdfxml_parse_flags;

    private void log(String string) {
        if ((this.rdfxml_parse_flags & 0x80) == 128) {
            System.out.print("\n");
            System.out.print(string + "\n");
        }
    }

    public RDFXMLContentHandler(ArrayList<String> arrayList, Connection connection, String string, int n, int n2, String string2, String string3) {
        this.tripleAtoms = arrayList;
        this.conn = connection;
        this.docid = string;
        this.modelid = n;
        this.rdfxml_parse_flags = n2;
        this.loadMethod = (n2 & 4) == 4 ? "BULKLOAD" : "DML";
        this.targetTable = string3 == null ? string2 : string2 + " partition(" + string3 + ") ";
        this.columnList = " (RDF$STC_sub, RDF$STC_pred, RDF$STC_obj, RDF$STC_GRAPH) ";
        this.columnListWithClob = " (RDF$STC_sub, RDF$STC_pred, RDF$STC_clob, RDF$STC_GRAPH) ";
        this.nmspcMap.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.nmspcMap.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.nmspcMap.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.nmspcMap.put("owl", "http://www.w3.org/2002/07/owl#");
        this.nmspcMap.put("dc", "http://purl.org/dc/elements/1.1/");
        this.nmspcMap.put("dcterms", "http://purl.org/dc/terms/");
        this.nmspcMap.put("orardf", "http://xmlns.oracle.com/rdf/");
    }

    public RDFXMLContentHandler(ArrayList<String> arrayList, String string, int n, int n2, String string2, String string3) throws SQLException {
        this(arrayList, null, string, n, n2, string2, string3);
        if (arrayList == null) {
            this.conn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
    }

    private void addTriple(String string, String string2, String string3) throws SAXException {
        this.addTriple(string, string2, string3, false, null);
    }

    private void cleanup() {
        try {
            if (this.insTriple != null) {
                this.insTriple.close();
            }
            this.insTriple = null;
            if (this.insTripleWithClob != null) {
                this.insTripleWithClob.close();
            }
            this.insTripleWithClob = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void raiseError(String string) throws RDFXMLParseException {
        this.cleanup();
        throw new RDFXMLParseException(string);
    }

    private void addTriple(String string, String string2, String string3, boolean bl, String string4) throws SAXException {
        String string5 = string3;
        this.log("addTriple: sub=" + string + " pro=" + string2 + " obj=" + string5 + "*");
        if (string5 == null || string5.length() == 0) {
            return;
        }
        this.log("addTriple: processing ...");
        if (bl) {
            string5 = string4 != null ? "\"" + string5.trim() + "\"^^<" + string4 + ">" : "\"" + string5.trim() + "\"";
        }
        if (this.tripleAtoms != null) {
            this.log("addTriple: into tripleAtoms ...");
            this.tripleAtoms.add(string);
            this.tripleAtoms.add(string2);
            this.tripleAtoms.add(string5);
        } else {
            this.log("addTriple: into " + this.targetTable + " ...");
            if (this.insTriple == null) {
                this.raiseError("invalid SQL state while parsing RDF/XML document");
            }
            if (string5.length() > 4000) {
                this.log("addTriple: object.length=" + string5.length());
                try {
                    this.log("addTriple: inserting into " + this.targetTable + " ... modelid=" + this.modelid + " docid=" + this.docid + "*");
                    if (this.insTripleWithClob == null) {
                        this.log("addTriple: need to prepare the CLOB insert statement");
                        this.insTripleWithClob = this.conn.prepareStatement("insert into " + this.targetTable + this.columnListWithClob + "values (:1,:2,:3,:4)");
                        this.log("prepareStatement: insert into " + this.targetTable + this.columnListWithClob + "values (:1,:2,:3,:4)");
                    }
                    this.log("addTriple: already-prepared CLOB insert statement");
                    this.insTripleWithClob.setString(1, string);
                    this.insTripleWithClob.setString(2, string2);
                    CLOB cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)false, (int)10);
                    cLOB.open(1);
                    cLOB.setString(1L, string5);
                    this.insTripleWithClob.setClob(3, (Clob)cLOB);
                    this.insTripleWithClob.setString(4, this.docid);
                    this.log("addTriple: just before insTripleWithClob.executeUpdate() of CLOB insert statement");
                    this.insTripleWithClob.executeUpdate();
                    this.log("addTriple: just AFTER insTripleWithClob.executeUpdate() of CLOB insert statement");
                    cLOB.close();
                    cLOB.freeTemporary();
                }
                catch (SQLException sQLException) {
                    this.raiseError("Error populating triples table with CLOB object" + sQLException.getMessage());
                }
                return;
            }
            try {
                this.log("addTriple: inserting into " + this.targetTable + " ... modelid=" + this.modelid + " docid=" + this.docid + "*");
                this.insTriple.setString(1, string);
                this.insTriple.setString(2, string2);
                this.insTriple.setString(3, string5);
                this.insTriple.setString(4, this.docid);
                this.insTriple.execute();
            }
            catch (SQLException sQLException) {
                this.raiseError("Error populating triples table " + sQLException.getMessage());
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.conn == null) {
            return;
        }
        try {
            this.log("prepareStatement: insert into " + this.targetTable + this.columnList + "values (:1,:2,:3,:4)");
            this.insTriple = this.conn.prepareStatement("insert into " + this.targetTable + this.columnList + "values (:1,:2,:3,:4)");
            this.log("prepareStatement: insert into " + this.targetTable + this.columnListWithClob + "values (:1,:2,:3,:4)");
            this.insTripleWithClob = this.conn.prepareStatement("insert into " + this.targetTable + this.columnListWithClob + "values (:1,:2,:3,:4)");
        }
        catch (SQLException sQLException) {
            this.raiseError("Error populating triples table " + sQLException.getMessage());
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.conn == null) {
            return;
        }
        try {
            if (this.insTriple != null) {
                this.insTriple.close();
            }
            if (this.insTripleWithClob != null) {
                this.insTripleWithClob.close();
            }
            this.conn.close();
            this.insTriple = null;
            this.insTripleWithClob = null;
            this.conn = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.nmspcMap.containsKey(string)) {
            if (!this.nmspcMap.get(string).equals(string2)) {
                this.raiseError("duplicate namespace map for " + string);
            }
            return;
        }
        this.nmspcMap.put(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (this.nmspcMap.remove(string) == null) {
            this.raiseError("namespace map does not exist for " + string);
        }
    }

    private String getRDFTagName(String string, String string2, String string3) throws SAXException {
        if (string != null && string2 != null && string.length() > 0 && string2.length() > 0) {
            return string + string2;
        }
        String string4 = null;
        String string5 = null;
        if (string3.indexOf(":") > 0 && (string5 = this.nmspcMap.get(string4 = string3.substring(0, string3.indexOf(":")))) != null) {
            return string5 + string3.substring(string3.indexOf(":") + 1);
        }
        this.raiseError("invalid namespace context for RDF/XML document - " + string3);
        return null;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = this.getRDFTagName(string, string2, string3);
        if (string4.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#RDF")) {
            if (!this.rdfNodes.empty()) {
                this.raiseError("incorrect use of <rdf:RDF> element in RDFXML");
            }
            this.rdfNodes.add(new RDFElement(1, null));
        } else if (string4.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Description")) {
            if (this.rdfNodes.empty() || !((RDFElement)this.rdfNodes.lastElement()).isElemType(1)) {
                this.raiseError("invalid context for <rdf:Description> element ");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = this.getRDFTagName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
                if (!string5.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#about")) continue;
                this.rdfNodes.add(new RDFElement(2, attributes.getValue(i)));
            }
        } else if (string4.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
            if (this.rdfNodes.empty() || !((RDFElement)this.rdfNodes.lastElement()).isElemType(2)) {
                this.raiseError("invalid context for <rdf:type> element ");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string6 = this.getRDFTagName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
                if (!string6.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#resource")) continue;
                this.addTriple("<" + ((RDFElement)this.rdfNodes.lastElement()).getContext() + ">", "<" + string4 + ">", "<" + attributes.getValue(i) + ">");
                this.currentTextData = null;
            }
            this.rdfNodes.add(new RDFElement(3, null));
        } else {
            String string7 = null;
            if (this.rdfNodes.empty() || !((RDFElement)this.rdfNodes.lastElement()).isElemType(2)) {
                this.raiseError("unsupported RDFXML syntax at " + string4);
            }
            this.currentTextData = new StringBuffer();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string8 = this.getRDFTagName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
                if (string8.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#resource")) {
                    this.addTriple("<" + ((RDFElement)this.rdfNodes.lastElement()).getContext() + ">", "<" + string4 + ">", "<" + attributes.getValue(i) + ">");
                    this.currentTextData = null;
                    continue;
                }
                if (!string8.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#datatype")) continue;
                string7 = attributes.getValue(i);
            }
            this.rdfNodes.add(new RDFElement(4, string7));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.getRDFTagName(string, string2, string3);
        if (string4.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#RDF")) {
            if (this.rdfNodes.empty() || !((RDFElement)this.rdfNodes.lastElement()).isElemType(1)) {
                this.raiseError("error closing element <rdf:RDF>");
            }
            this.rdfNodes.pop();
        } else if (string4.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Description")) {
            if (this.rdfNodes.empty() || !((RDFElement)this.rdfNodes.lastElement()).isElemType(2)) {
                this.raiseError("error closing element <rdf:Description>");
            }
            this.rdfNodes.pop();
        } else if (string4.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
            if (this.rdfNodes.empty() || !((RDFElement)this.rdfNodes.lastElement()).isElemType(3) || this.currentTextData != null && this.currentTextData.length() > 0) {
                this.raiseError("error closing element <rdf:type>");
            }
            this.rdfNodes.pop();
        } else {
            if (this.rdfNodes.empty() || !((RDFElement)this.rdfNodes.lastElement()).isElemType(4)) {
                this.raiseError("error closing element " + string4);
            }
            RDFElement rDFElement = this.rdfNodes.pop();
            if (this.currentTextData != null) {
                RDFElement rDFElement2 = (RDFElement)this.rdfNodes.lastElement();
                this.addTriple("<" + rDFElement2.getContext() + ">", "<" + string4 + ">", this.currentTextData.toString(), true, rDFElement.getContext());
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.currentTextData == null) {
            return;
        }
        this.currentTextData.append(cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void skippedEntity(String string) {
    }

    class RDFElement {
        int elemType;
        static final int RDF_RDF = 1;
        static final int RDF_DESCRIPTION = 2;
        static final int RDF_TYPE = 3;
        static final int RDF_PROP_TEXT_NODE = 4;
        String elemContext;

        RDFElement(int n, String string) {
            this.elemType = n;
            this.elemContext = string;
        }

        boolean isElemType(int n) {
            return n == this.elemType;
        }

        String getContext() {
            return this.elemContext;
        }
    }
}

