/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.enc.XECipherData;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XECipherReference;
import oracle.security.xmlsec.enc.XEDataReference;
import oracle.security.xmlsec.enc.XEEncryptedObject;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.enc.XEKeyInfo;
import oracle.security.xmlsec.enc.XEReference;
import oracle.security.xmlsec.enc.XEReferenceList;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.enc.XEUtils;
import oracle.security.xmlsec.keys.AgreementMethod;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XEEncryptedKey
extends XEEncryptedObject
implements KeyInfoData {
    private static Method jsr106encryptKey;
    private static Method jsr106decryptKey;

    public XEEncryptedKey(Element encKey) {
        super(encKey);
    }

    public XEEncryptedKey(Element encKey, String systemId) {
        super(encKey, systemId);
    }

    public XEEncryptedKey(Document doc) {
        super(doc, "EncryptedKey");
    }

    public XEEncryptedKey(Document doc, String id) {
        this(doc);
        if (id != null) {
            this.setId(id);
        }
    }

    public static XEEncryptedKey newInstance() throws DOMException {
        Document doc = XMLUtils.createDocument();
        XEEncryptedKey encKey = new XEEncryptedKey(doc);
        encKey.appendTo(doc);
        return encKey;
    }

    public static XEEncryptedKey newInstance(String id) throws DOMException {
        Document doc = XMLUtils.createDocument();
        XEEncryptedKey encKey = new XEEncryptedKey(doc, id);
        encKey.appendTo(doc);
        return encKey;
    }

    public static XEEncryptedKey newInstance(Document doc) throws DOMException {
        return new XEEncryptedKey(doc);
    }

    public static XEEncryptedKey newInstance(Document doc, String id) throws DOMException {
        return new XEEncryptedKey(doc, id);
    }

    public void setCarriedKeyName(String keyName) throws DOMException {
        Document owner = this.getOwnerDocument();
        Element ckn = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName");
        XMLUtils.copyNSPrefix((Element)this.node, ckn);
        ckn.appendChild(owner.createTextNode(keyName));
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName");
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            this.removeChild(nodes.item(i));
        }
        this.appendChild(ckn);
    }

    public String getCarriedKeyName() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName");
        if (nodes.getLength() != 0) {
            return XMLUtils.collectText(nodes.item(0));
        }
        return null;
    }

    public void setRecipient(String recipient) throws DOMException {
        this.setAttribute("Recipient", recipient);
    }

    public String getRecipient() {
        if (this.hasAttribute("Recipient")) {
            return this.getAttribute("Recipient");
        }
        return null;
    }

    public void addReference(XEReference ref) throws DOMException {
        NodeList list = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        XEReferenceList rs = null;
        if (list.getLength() != 0) {
            rs = new XEReferenceList((Element)list.item(0));
        } else {
            rs = new XEReferenceList(this.getOwnerDocument());
            list = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName");
            if (list.getLength() != 0) {
                this.insertBefore(rs, list.item(0));
            } else {
                this.appendChild(rs);
            }
        }
        rs.appendChild(ref);
    }

    public Vector getDataReferences() {
        NodeList list = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        Vector v = new Vector();
        if (list.getLength() != 0) {
            v = new XEReferenceList((Element)list.item(0)).getDataReferences();
        }
        return v;
    }

    public Vector getKeyReferences() {
        NodeList list = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        Vector v = new Vector();
        if (list.getLength() != 0) {
            v = new XEReferenceList((Element)list.item(0)).getKeyReferences();
        }
        return v;
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    }

    public byte[] encrypt(byte[] contentKeyBytes, Key keyEncKey) throws XESchemaException, XECipherException {
        boolean USE_JSR106;
        String algURI;
        XEEncryptionMethod encMethod = this.getEncryptionMethod();
        if (encMethod == null || (algURI = encMethod.getAlgorithm()) == null) {
            throw new XESchemaException("Missing algorithm identifier URI.");
        }
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            SecretKeySpec contentKey = new SecretKeySpec(contentKeyBytes, encMethod.getJCEKeyAlgorithm());
            return this.encryptKeyUsingJSR106(contentKey, keyEncKey);
        }
        try {
            if (!(keyEncKey instanceof PublicKey) || keyEncKey instanceof DSAPublicKey || keyEncKey instanceof ECPublicKey || keyEncKey.getAlgorithm().equals("DSA") || keyEncKey.getAlgorithm().equals("EC")) {
                // empty if block
            }
            if (algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                return XEEncryptedKey.des3KeyWrap(contentKeyBytes, keyEncKey);
            }
            if (algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128") || algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192") || algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                return XEEncryptedKey.aesKeyWrap(contentKeyBytes, algURI, keyEncKey);
            }
            if (algURI.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                Cipher cipher = CryptoUtils.getCipherInstance((Key)keyEncKey, (String)encMethod.getJCEAlgorithm());
                cipher.init(1, keyEncKey);
                return cipher.doFinal(contentKeyBytes);
            }
            if (algURI.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p") || algURI.equals("http://www.w3.org/2009/xmlenc11#rsa-oaep")) {
                Cipher cipher = this.getOAEPCipher(keyEncKey, 1);
                return cipher.doFinal(contentKeyBytes);
            }
            throw new XECipherException("Unsupported key encryption algorithm: " + algURI);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XECipherException(ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XECipherException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new XECipherException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XECipherException(ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XECipherException(ex);
        }
        catch (BadPaddingException ex) {
            throw new XECipherException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new XECipherException(ex);
        }
        catch (SecurityException e) {
            throw new XECipherException(e);
        }
        catch (IllegalArgumentException e) {
            throw new XECipherException(e);
        }
    }

    private Cipher getOAEPCipher(Key keyEncKey, int mode) throws XECipherException {
        try {
            XEEncryptionMethod encMethod = this.getEncryptionMethod();
            String algURI = encMethod.getAlgorithm();
            String digestAlg = URIManager.getURIManager().getJCEAlgorithm(encMethod.getDigestMethod() != null ? encMethod.getDigestMethod().getAlgorithm() : "http://www.w3.org/2000/09/xmldsig#sha1");
            Cipher cipher = CryptoUtils.getCipherInstance((Key)keyEncKey, (String)("RSA/ECB/OAEPWith" + digestAlg + "AndMGF1Padding"));
            byte[] oaepBytes = encMethod.getOAEPParams();
            PSource.PSpecified ps = null;
            ps = oaepBytes == null ? PSource.PSpecified.DEFAULT : new PSource.PSpecified(oaepBytes);
            MGF1ParameterSpec mgfSpec = MGF1ParameterSpec.SHA1;
            if (algURI.equals("http://www.w3.org/2009/xmlenc11#rsa-oaep") && encMethod.getMGF() != null && encMethod.getMGF().getAlgorithm() != null) {
                String alg = encMethod.getMGF().getAlgorithm();
                if (alg.equals("http://www.w3.org/2009/xmlenc11#mgf1sha256")) {
                    mgfSpec = MGF1ParameterSpec.SHA256;
                } else if (alg.equals("http://www.w3.org/2009/xmlenc11#mgf1sha384")) {
                    mgfSpec = MGF1ParameterSpec.SHA384;
                } else if (alg.equals("http://www.w3.org/2009/xmlenc11#mgf1sha512")) {
                    mgfSpec = MGF1ParameterSpec.SHA512;
                }
            }
            AlgorithmParameterSpec params = CryptoUtils.getOEPAlgoSpec((String)digestAlg, (String)"MGF1", (AlgorithmParameterSpec)mgfSpec, (PSource)ps, (Key)keyEncKey);
            cipher.init(mode, keyEncKey, params);
            return cipher;
        }
        catch (NoSuchPaddingException e) {
            throw new XECipherException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XECipherException(e);
        }
        catch (NoSuchProviderException e) {
            throw new XECipherException(e);
        }
        catch (SecurityException e) {
            throw new XECipherException(e);
        }
        catch (IllegalArgumentException e) {
            throw new XECipherException(e);
        }
        catch (ClassNotFoundException e) {
            throw new XECipherException(e);
        }
        catch (NoSuchMethodException e) {
            throw new XECipherException(e);
        }
        catch (IllegalAccessException e) {
            throw new XECipherException(e);
        }
        catch (NoSuchFieldException e) {
            throw new XECipherException(e);
        }
        catch (InstantiationException e) {
            throw new XECipherException(e);
        }
        catch (InvocationTargetException e) {
            throw new XECipherException(e);
        }
        catch (InvalidKeyException e) {
            throw new XECipherException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new XECipherException(e);
        }
    }

    public byte[] encrypt(byte[] contentKeyBytes) throws XEException {
        return this.encrypt(contentKeyBytes, this.getEncryptionKey());
    }

    public byte[] encrypt(SecretKey contentKey, Key keyEncKey) throws XESchemaException, XECipherException {
        boolean USE_JSR106;
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            return this.encryptKeyUsingJSR106(contentKey, keyEncKey);
        }
        return this.encrypt(contentKey.getEncoded(), keyEncKey);
    }

    public void encryptKey(SecretKey contentKey, Key keyEncKey, String keyEncKeyName) throws XESchemaException, XECipherException {
        byte[] cipherValue = this.encrypt(contentKey, keyEncKey);
        XECipherData cd = this.createCipherData();
        cd.setCipherValue(cipherValue);
        this.setCipherData(cd);
        if (keyEncKeyName != null) {
            XEKeyInfo kki = this.createKeyInfo();
            kki.addKeyInfoData(kki.createKeyName(keyEncKeyName));
            this.setKeyInfo(kki);
        }
    }

    public byte[] encrypt(SecretKey contentKey) throws XEException {
        return this.encrypt(contentKey, this.getEncryptionKey());
    }

    public byte[] decrypt(XEEncryptionMethod ceEncMethod, Key keyDecKey) throws XESchemaException, XECipherException {
        String algURI;
        boolean USE_JSR106;
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            return this.decryptKeyUsingJSR106(keyDecKey);
        }
        XEEncryptionMethod encMethod = this.getEncryptionMethod();
        if (encMethod == null || (algURI = encMethod.getAlgorithm()) == null) {
            throw new XESchemaException("Missing algorithm identifier URI.");
        }
        XECipherData cipherData = this.getCipherData();
        if (cipherData == null) {
            throw new XESchemaException("Missing CipherData element.");
        }
        byte[] cipherValue = cipherData.getCipherValue();
        if (cipherValue == null) {
            XECipherReference ciphRef = cipherData.getCipherReference();
            if (ciphRef == null) {
                throw new XESchemaException("Missing both CipherValue and CipherReference elements in CipherData");
            }
            try {
                cipherValue = ciphRef.getCipherValue();
            }
            catch (ReferenceException ex) {
                throw new XESchemaException(ex);
            }
        }
        try {
            Cipher cipher;
            Key oldKeyDecKey = keyDecKey;
            if (this.getKeyInfo() != null && this.getKeyInfo().getAgreementMethods().size() > 0) {
                AgreementMethod am = (AgreementMethod)this.getKeyInfo().getAgreementMethods().get(0);
                if (keyDecKey instanceof DHPrivateKey || keyDecKey instanceof ECPrivateKey || keyDecKey instanceof PrivateKey && (keyDecKey.getAlgorithm().equals("DH") || keyDecKey.getAlgorithm().equals("EC"))) {
                    PublicKey oPubKey = KeyRetriever.getPublicKey(am.getOriginatorKeyInfo());
                    byte[] key = am.generateKeyMaterial(this.getEncryptionMethod(), (PrivateKey)keyDecKey, oPubKey);
                    keyDecKey = new SecretKeySpec(key, ceEncMethod == null ? "AES" : ceEncMethod.getJCEAlgorithm());
                }
            }
            if (algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                return XEEncryptedKey.des3KeyUnwrap(cipherValue, ceEncMethod.getJCEAlgorithm(), ceEncMethod.keySize(), keyDecKey);
            }
            if (algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128") || algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192") || algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                return XEEncryptedKey.aesKeyUnwrap(cipherValue, algURI, keyDecKey);
            }
            if (algURI.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                cipher = CryptoUtils.getCipherInstance((Key)keyDecKey, (String)encMethod.getJCEAlgorithm());
                cipher.init(2, keyDecKey);
                return cipher.doFinal(cipherValue);
            }
            if (algURI.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p") || algURI.equals("http://www.w3.org/2009/xmlenc11#rsa-oaep")) {
                cipher = this.getOAEPCipher(keyDecKey, 2);
                return cipher.doFinal(cipherValue);
            }
            throw new XECipherException("Unsupported key encryption algorithm: " + algURI);
        }
        catch (NoSuchAlgorithmException aex) {
            throw new XECipherException(aex);
        }
        catch (NoSuchProviderException ex) {
            throw new XECipherException(ex);
        }
        catch (InvalidKeyException iex) {
            throw new XECipherException(iex);
        }
        catch (InvalidAlgorithmParameterException iex) {
            throw new XECipherException(iex);
        }
        catch (BadPaddingException iex) {
            throw new XECipherException(iex);
        }
        catch (NoSuchPaddingException iex) {
            throw new XECipherException(iex);
        }
        catch (IllegalBlockSizeException iex) {
            throw new XECipherException(iex);
        }
        catch (KeyRetrievalException iex) {
            throw new XECipherException(iex);
        }
        catch (SecurityException e) {
            throw new XECipherException(e);
        }
        catch (IllegalArgumentException e) {
            throw new XECipherException(e);
        }
    }

    public byte[] decrypt(XEEncryptionMethod ceEncMethod) throws XEException {
        return this.decrypt(ceEncMethod, this.getDecryptionKey());
    }

    public SecretKey getKey(XEEncryptionMethod ceEncMethod, Key keyDecKey) throws DOMException, XEException {
        Vector v;
        if (ceEncMethod == null && (v = this.getDataReferences()) != null && v.size() > 0) {
            try {
                XEDataReference ref = (XEDataReference)v.get(0);
                XEEncryptedObject encObj = ref.getEncryptedObject();
                ceEncMethod = encObj.getEncryptionMethod();
            }
            catch (ReferenceException referenceException) {
                // empty catch block
            }
        }
        String alg = ceEncMethod != null ? ceEncMethod.getJCEKeyAlgorithm() : "AES";
        return new SecretKeySpec(this.decrypt(ceEncMethod, keyDecKey), alg);
    }

    public SecretKey getKey(XEEncryptionMethod ceEncMethod) throws DOMException, XEException {
        return this.getKey(ceEncMethod, this.getDecryptionKey());
    }

    private static int des3WrapSize(String alg, int keySize) {
        if (alg.startsWith("DESede")) {
            return 40;
        }
        if (alg.startsWith("AES") && keySize == 128) {
            return 32;
        }
        if (alg.startsWith("AES") && keySize == 192) {
            return 40;
        }
        if (alg.startsWith("AES") && keySize == 256) {
            return 48;
        }
        return -1;
    }

    private static byte[] getKeyChecksum(byte[] keyBytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] digest = md.digest(keyBytes);
        byte[] cks = new byte[8];
        System.arraycopy(digest, 0, cks, 0, 8);
        return cks;
    }

    private static byte[] des3KeyWrap(byte[] keyBytes, Key keKey) throws NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        byte[] CKS = XEEncryptedKey.getKeyChecksum(keyBytes);
        byte[] WKCKS = XEUtils.concat(keyBytes, CKS);
        byte[] IV = new byte[8];
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.nextBytes(IV);
        Cipher cipher = Cipher.getInstance("DESEde/CBC/NoPadding");
        cipher.init(1, keKey, new IvParameterSpec(IV));
        byte[] TEMP1 = cipher.doFinal(WKCKS);
        byte[] TEMP2 = XEUtils.concat(IV, TEMP1);
        byte[] TEMP3 = XEUtils.reverse(TEMP2);
        byte[] IV1 = Utils.fromHexString((String)"4adda22c79e82105");
        cipher.init(1, keKey, new IvParameterSpec(IV1));
        return cipher.doFinal(TEMP3);
    }

    private static byte[] des3KeyUnwrap(byte[] keyBytes, String alg, int keySize, Key keKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        int size = XEEncryptedKey.des3WrapSize(alg, keySize);
        if (size == -1) {
            throw new IllegalArgumentException("Triple DES wrapping of key for algorithm: " + alg + " not supported");
        }
        if (keyBytes.length != size) {
            throw new IllegalArgumentException("Wrapped Key MUST be " + size + " bytes in length for the algorithm " + alg);
        }
        byte[] IV = Utils.fromHexString((String)"4adda22c79e82105");
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        cipher.init(2, keKey, new IvParameterSpec(IV));
        byte[] TEMP3 = cipher.doFinal(keyBytes);
        byte[] TEMP2 = XEUtils.reverse(TEMP3);
        IV = new byte[8];
        byte[] TEMP1 = new byte[TEMP2.length - 8];
        System.arraycopy(TEMP2, 0, IV, 0, 8);
        System.arraycopy(TEMP2, 8, TEMP1, 0, TEMP2.length - 8);
        cipher.init(2, keKey, new IvParameterSpec(IV));
        byte[] WKCKS = cipher.doFinal(TEMP1);
        int len = WKCKS.length - 8;
        byte[] WK = new byte[len];
        byte[] CKS = new byte[8];
        System.arraycopy(WKCKS, 0, WK, 0, len);
        System.arraycopy(WKCKS, len, CKS, 0, 8);
        byte[] keyCKS = XEEncryptedKey.getKeyChecksum(WK);
        if (keyCKS.length != CKS.length) {
            throw new InvalidKeyException("key Checksum Length DOES NOT Match");
        }
        for (int i = 0; i < CKS.length; ++i) {
            if (keyCKS[i] == CKS[i]) continue;
            throw new InvalidKeyException("key Checksum DOES NOT match");
        }
        return WK;
    }

    private static byte[] aesKeyWrap(byte[] keyBytes, String kwAlgURI, Key keKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException {
        if (keyBytes.length % 8 != 0) {
            throw new IllegalArgumentException("The inputs are not a mutiple of 8 bytes");
        }
        int n = keyBytes.length / 8;
        byte[] A = Utils.fromHexString((String)"a6a6a6a6a6a6a6a6");
        byte[] C = new byte[keyBytes.length + 8];
        System.arraycopy(keyBytes, 0, C, 8, keyBytes.length);
        int keySize = 0;
        if (kwAlgURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
            keySize = 128;
        } else if (kwAlgURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
            keySize = 192;
        } else if (kwAlgURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
            keySize = 256;
        } else {
            throw new NoSuchAlgorithmException("Unsupported AES key wrap algorithm " + kwAlgURI);
        }
        if (keKey.getEncoded().length * 8 != keySize) {
            throw new InvalidKeyException("Key length doesn't match key wrap algorithm");
        }
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, keKey);
        byte[] temp = new byte[8];
        if (n == 1) {
            System.arraycopy(C, 8, temp, 0, 8);
            C = cipher.doFinal(XEUtils.concat(A, temp));
        } else {
            for (int j = 0; j < 6; ++j) {
                for (int i = 1; i < n + 1; ++i) {
                    System.arraycopy(C, 8 * i, temp, 0, 8);
                    cipher.init(1, keKey);
                    byte[] B = cipher.doFinal(XEUtils.concat(A, temp));
                    System.arraycopy(B, 0, temp, 0, 8);
                    A = XEUtils.xor(temp, Utils.wordToBytes((int)(n * j + i)));
                    System.arraycopy(B, 8, C, 8 * i, 8);
                }
            }
            System.arraycopy(A, 0, C, 0, 8);
        }
        return C;
    }

    private static byte[] aesKeyUnwrap(byte[] cipherBytes, String kwAlgURI, Key keKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException {
        if (cipherBytes.length % 8 != 0 || cipherBytes.length < 16) {
            throw new IllegalArgumentException("The inputs should have length in bytes  a mutiple of 8 and not less than 16");
        }
        int n = cipherBytes.length / 8 - 1;
        byte[] A = new byte[8];
        System.arraycopy(cipherBytes, 0, A, 0, 8);
        byte[] P = new byte[cipherBytes.length - 8];
        System.arraycopy(cipherBytes, 8, P, 0, P.length);
        int keySize = 0;
        if (kwAlgURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
            keySize = 128;
        } else if (kwAlgURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
            keySize = 192;
        } else if (kwAlgURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
            keySize = 256;
        } else {
            throw new NoSuchAlgorithmException("Unsupported AES key wrap algorithm " + kwAlgURI);
        }
        if (keKey.getEncoded().length * 8 != keySize) {
            throw new InvalidKeyException("Key length doesn't make key wrap algorithm");
        }
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(2, keKey);
        byte[] B = new byte[16];
        if (n == 1) {
            B = cipher.doFinal(cipherBytes);
            System.arraycopy(B, 0, A, 0, 8);
            System.arraycopy(B, 8, P, 0, 8);
        } else {
            for (int j = 5; j >= 0; --j) {
                for (int i = n; i > 0; --i) {
                    byte[] temp = new byte[8];
                    System.arraycopy(P, 8 * (i - 1), temp, 0, 8);
                    cipher.init(2, keKey);
                    B = cipher.doFinal(XEUtils.concat(XEUtils.xor(A, Utils.wordToBytes((int)(n * j + i))), temp));
                    System.arraycopy(B, 0, A, 0, 8);
                    System.arraycopy(B, 8, P, 8 * (i - 1), 8);
                }
            }
        }
        if (!Utils.areEqual((byte[])A, (byte[])Utils.fromHexString((String)"a6a6a6a6a6a6a6a6"))) {
            throw new InvalidKeyException("Initial value does not match");
        }
        return P;
    }

    private byte[] encryptKeyUsingJSR106(Key contentKey, Key keyEncKey) throws XESchemaException, XECipherException {
        try {
            return (byte[])jsr106encryptKey.invoke(null, this, contentKey, keyEncKey);
        }
        catch (InvocationTargetException ex) {
            throw new XECipherException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new XECipherException(ex);
        }
    }

    private byte[] decryptKeyUsingJSR106(Key keyDecKey) throws XESchemaException, XECipherException {
        try {
            return (byte[])jsr106decryptKey.invoke(null, this, keyDecKey);
        }
        catch (InvocationTargetException ex) {
            throw new XECipherException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new XECipherException(ex);
        }
    }

    static {
        boolean USE_JSR106;
        boolean bl = USE_JSR106 = System.getProperty("osdt.useJSR106") != null;
        if (USE_JSR106) {
            try {
                Class<?> jsr105Util = Class.forName("oracle.security.xmlsec.enc.JSR106Util");
                jsr106encryptKey = jsr105Util.getMethod("encryptKeyUsingJSR106", XEEncryptedKey.class, Key.class, Key.class);
                jsr106decryptKey = jsr105Util.getMethod("decryptUsingJSR106", XEEncryptedKey.class, Key.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

