/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.NamespaceContext;
import oracle.dbtools.common.app.Version;
import oracle.dbtools.common.install.InstallConstants;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NSContext;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.common.util.XPaths;
import oracle.dbtools.rt.config.setup.SetupMessages;
import org.w3c.dom.Node;

class InstallParams {
    private static final Log LOG = Log.get(InstallParams.class);
    private static final String EMPTY = "";
    private static final String _NS = "http://java.sun.com/xml/ns/j2ee";
    private static final String _NS_PREFIX = "j";
    private static final NamespaceContext NS_CONTEXT = NSContext.namespaceContext((String[])new String[]{"j", "http://java.sun.com/xml/ns/j2ee"});
    private static final XPaths.Expression VERSION_TEXT = XPaths.expression((String)"/j:web-app/j:context-param[j:param-name=\"version\"]/j:param-value/text()", (NamespaceContext)NS_CONTEXT);

    static Map<String, String> getInstallParameters(File war, String installType, String paramFileName) throws IOException {
        return new InstallParams().getParams(war, installType, paramFileName, null);
    }

    static Map<String, String> getInstallParameters(File war, String installType, String paramFileName, String logDir) throws IOException {
        return new InstallParams().getParams(war, installType, paramFileName, logDir);
    }

    private InstallParams() {
    }

    private Map<String, String> getParams(File war, String installType, String installParamFile, String logDir) throws IOException {
        HashMap<String, String> installParams = new HashMap<String, String>();
        installParams.put("product.name", Version.INSTANCE.getProductName());
        installParams.put("product.abbreviation", Version.INSTANCE.getProductAbbreviation());
        installParams.put("product.version", this.getProductVersion(war));
        installParams.put("schema.name", "ORDS_METADATA");
        installParams.put("install.type", this.getInstallType(installType));
        String paramFile = installParamFile;
        String defParamFile = war.getParentFile().getPath() + InstallConstants.INSTALL_PARAMS_XML;
        installParams.put("file.default.parameter", defParamFile);
        if (NullOrEmpty.nullOrEmpty((CharSequence)paramFile)) {
            paramFile = defParamFile;
        }
        installParams.put("file.parameter", paramFile);
        if (!NullOrEmpty.nullOrEmpty((CharSequence)logDir)) {
            installParams.put("log.folder", logDir);
        }
        this.loadParamsFromFile(installParams, paramFile);
        return installParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadParamsFromFile(Map<String, String> installParams, String paramFileName) throws IOException {
        File paramFile;
        if (!NullOrEmpty.nullOrEmpty((CharSequence)paramFileName) && (paramFile = Files.file((String)paramFileName)).exists()) {
            Properties props = new Properties();
            InputStream in = null;
            try {
                in = Files.inputStream((File)paramFile);
                props.load(in);
            }
            finally {
                Closeables.close((Object)in);
            }
            if (props != null) {
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    Object name = names.nextElement();
                    String key = name.toString();
                    String value = props.getProperty(key);
                    if (NullOrEmpty.nullOrEmpty((CharSequence)value)) continue;
                    if (key.startsWith("@")) {
                        String dKey = key.substring(1);
                        if ((dKey = Passwords.comingIn((String)dKey)).equals("sys.user") && value.startsWith("@")) {
                            String dValue = value.substring(1);
                            dValue = Passwords.comingIn((String)dValue);
                            installParams.put(dKey, dValue);
                            continue;
                        }
                        installParams.put(dKey, value);
                        continue;
                    }
                    installParams.put(key, value);
                }
            }
        }
    }

    private String getProductVersion(File war) throws IOException {
        String string;
        ZipFile zip = null;
        InputStream content = null;
        try {
            zip = new ZipFile(war);
            ZipEntry entry = zip.getEntry("WEB-INF/web.xml");
            if (entry == null) {
                throw new IllegalStateException(SetupMessages.format("WEBXMLNOTFOUND", "WEB-INF/web.xml"));
            }
            content = zip.getInputStream(entry);
            string = InstallParams.getVersion(content);
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{content, zip});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{content, zip});
        return string;
    }

    static String getVersion(InputStream content) throws IOException {
        try {
            Node paramValue = (Node)XPaths.select((InputStream)content, (XPaths.Expression)VERSION_TEXT, Node.class);
            if (paramValue == null) {
                return null;
            }
            String text = paramValue.getNodeValue();
            if (NullOrEmpty.nullOrEmpty((CharSequence)text)) {
                throw new IllegalStateException(SetupMessages.getString("VERSIONNUM_ERROR"));
            }
            return text.trim();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String getInstallType(String installType) throws IOException {
        if (NullOrEmpty.nullOrEmpty((CharSequence)installType) || installType.equals("advanced")) {
            return "install.advanced";
        }
        if (installType.equals("simple")) {
            return "install.simple";
        }
        throw new IOException(SetupMessages.format("INVALID_INSTALL_TYPE", SetupMessages.getString("ARG_SIMPLE"), SetupMessages.getString("ARG_ADVANCED")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeInstallProperties(Map<String, String> installParams) throws IOException {
        if (!NullOrEmpty.nullOrEmpty(installParams)) {
            String paramFileName = null;
            String paramCreator = installParams.get("file.creator");
            paramFileName = paramCreator != null && paramCreator.equals("sqldev") ? installParams.get("file.default.parameter") : installParams.get("file.parameter");
            SortedProperties sortedProps = InstallParams.createInstallProperties(installParams);
            if (!NullOrEmpty.nullOrEmpty((Map)sortedProps)) {
                File paramFile = Files.file((String)paramFileName);
                OutputStream out = null;
                try {
                    out = Files.outputStream((File)paramFile);
                    sortedProps.store(out, null);
                }
                finally {
                    Closeables.close((Object)out);
                }
            }
        }
    }

    private static SortedProperties createInstallProperties(Map<String, String> installParams) {
        if (!NullOrEmpty.nullOrEmpty(installParams)) {
            SortedProperties props = new SortedProperties();
            for (String key : InstallConstants.INSTALL_PARAM_SET) {
                String value;
                if (InstallParams.isFilter(key, value = installParams.get(key))) continue;
                if (value != null && value.trim().isEmpty()) {
                    if (InstallConstants.INSTALL_PARAM_OPTIONAL.contains(key)) continue;
                    props.put((Object)key, (Object)EMPTY);
                    continue;
                }
                props.put((Object)key, (Object)value);
            }
            return props;
        }
        return null;
    }

    private static boolean isFilter(String key, String value) {
        return !NullOrEmpty.nullOrEmpty((CharSequence)key) && !NullOrEmpty.nullOrEmpty((CharSequence)value) && (key.equals("schema.tablespace.default") || key.equals("schema.tablespace.temp") || key.equals("user.tablespace.default") || key.equals("user.tablespace.temp")) && value.equals("-DEFAULT");
    }

    static boolean simpleInstall(Map<String, String> installParams) {
        String installType = installParams.get("install.type");
        return NullOrEmpty.nullOrEmpty((CharSequence)installType) || installType.equals("install.simple");
    }
}

