/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.microdata;

import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.json.JSONBuilder;
import oracle.dbtools.json.JSONNode;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.json.JSONValue;
import oracle.dbtools.rt.microdata.MicrodataBuilder;

public class MicrodataToJson
implements Transform<MicrodataBuilder, JSONNode> {
    private static final Transform<MicrodataBuilder.MicrodataItem, JSONValue<?>> ITEM_TO_JSON = new ItemToJson();
    private static final Transform<String, JSONValue<?>> TEXT_TO_JSON = new TextToJson();

    public JSONNode apply(MicrodataBuilder microdata) {
        JSONBuilder json = JSONBuilder.o((JSONOptions)JSONOptions.DEFAULT_JSON_OPTIONS);
        json.p("items", (Object)JSONBuilder.v((JSONBuilder)JSONBuilder.a((Iterable)Iterables.transform(microdata.items(), ITEM_TO_JSON))));
        return json.build();
    }

    private static final class TextToJson
    implements Transform<String, JSONValue<?>> {
        private TextToJson() {
        }

        public JSONValue<?> apply(String x) {
            return JSONBuilder.v((String)x);
        }
    }

    private static final class ItemToJson
    implements Transform<MicrodataBuilder.MicrodataItem, JSONValue<?>> {
        private ItemToJson() {
        }

        public JSONValue<?> apply(MicrodataBuilder.MicrodataItem item) {
            JSONBuilder json = JSONBuilder.o((JSONOptions)JSONOptions.DEFAULT_JSON_OPTIONS);
            JSONBuilder properties = JSONBuilder.o((JSONOptions)JSONOptions.DEFAULT_JSON_OPTIONS);
            for (String property : item.propertyNames()) {
                MicrodataBuilder.MicrodataValue value = item.value(property);
                MicrodataBuilder.Kind kind = value.kind();
                switch (kind) {
                    case URI: 
                    case TIMESTAMP: 
                    case TEXT: {
                        properties.p(property, (Object)JSONBuilder.v((JSONBuilder)JSONBuilder.a((Iterable)Iterables.transform(value.values(), (Transform)TEXT_TO_JSON))));
                        break;
                    }
                    case ITEM: {
                        properties.p(property, (Object)JSONBuilder.v((JSONBuilder)JSONBuilder.a((Iterable)Iterables.transform(value.items(), (Transform)ITEM_TO_JSON))));
                    }
                }
            }
            String type = item.type();
            String id = item.id();
            if (type != null) {
                json.p("type", (Object)JSONBuilder.v((String)type));
            }
            if (id != null) {
                json.p("id", (Object)JSONBuilder.v((String)id));
            }
            json.p("properties", (Object)JSONBuilder.v((JSONBuilder)properties));
            return JSONBuilder.v((JSONBuilder)json);
        }
    }
}

