/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.oauth;

import java.io.IOException;
import java.io.StringWriter;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.ecid.ECIDPrincipal;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Collections;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.FormFields;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.MissingFormFieldException;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.json.JSONBuilder;
import oracle.dbtools.json.JSONFormatter;
import oracle.dbtools.json.JSONNode;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.json.JSONRenderer;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.AuthenticationService;
import oracle.dbtools.rt.authentication.BaseHandler;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.oauth.AccessTokenStatus;
import oracle.dbtools.rt.oauth.AccessTokens;
import oracle.dbtools.rt.oauth.ApprovalRequest;
import oracle.dbtools.rt.oauth.BearerTokenVerification;
import oracle.dbtools.rt.oauth.OAuthDataAccess;
import oracle.dbtools.rt.oauth.OAuthException;
import oracle.dbtools.rt.oauth.OAuthProvider;
import oracle.dbtools.rt.oauth.ScopeAuthorizationPolicies;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.WebException;

@Service
public class OAuthAuthorization
implements OAuthProvider {
    @Reference
    private OAuthDataAccess data;
    private static final Log LOG = Log.get(OAuthAuthorization.class);
    private static final String NATIVE_CLIENT_REDIRECT = "urn:ietf:wg:oauth:2.0:oob";
    private static final SecurityConfig RESOURCE_OWNER_CREDENTIALS = new SecurityConfig(SecurityConstraint.SECURE_AND_AUTHENTICATED, AuthenticationRealm.RESOURCE_OWNER, LogonRealm.NONE);

    @Override
    public final void approveRequest(RequestEntity request) {
        Transaction txn = null;
        try {
            CompoundPrincipal principal;
            OAuthDataAccess data = this.data;
            ApprovalRequest.Status expectedStatus = ApprovalRequest.Status.PENDING;
            ApprovalRequest.Status newStatus = ApprovalRequest.Status.DENIED;
            String userId = Requests.remoteUser(request);
            TenantIdentifier pendingId = null;
            FormFields formFields = Requests.formFields(request);
            String text = formFields.getRequiredField("pending_id");
            pendingId = data.parseId(text);
            text = formFields.getRequiredField("decision");
            if ("allow_access".equalsIgnoreCase(text)) {
                newStatus = ApprovalRequest.Status.APPROVED;
            }
            if ((txn = data.newTransaction(principal = request.principal())) == null) {
                throw WebException.serviceUnavailable();
            }
            ApprovalRequest ar = data.updatePendingApproval(principal, txn, pendingId, userId, newStatus, expectedStatus);
            try {
                if (ar == null) {
                    throw WebException.badRequest(new Reason[0]);
                }
                if (ar.status() != ApprovalRequest.Status.APPROVED) {
                    throw this.accessDenied(ar);
                }
                this.setBearerTokenAndRedirect(data, principal, txn, ar, false);
            }
            catch (OAuthException e) {
                throw this.redirect(ar, e);
            }
        }
        catch (MissingFormFieldException e) {
            try {
                throw WebException.badRequest(e);
            }
            catch (Throwable throwable) {
                Closeables.close(txn);
                throw throwable;
            }
        }
        Closeables.close((Object)txn);
    }

    @Override
    public final ApprovalRequest pendingRequest(RequestEntity request) {
        ApprovalRequest approvalRequest;
        ApprovalRequest pending;
        Transaction txn;
        ApprovalRequest ar;
        block18: {
            ar = ApprovalRequest.approvalRequest(request);
            txn = null;
            String clientId = ar.clientId();
            ClientData clientData = this.client(request.principal(), clientId);
            OAuthDataAccess data = clientData.data;
            txn = clientData.txn;
            this.verifyClient(clientData.client, ar);
            String userId = Requests.remoteUser(request);
            CompoundPrincipal principal = request.principal();
            if (!this.authorizeScopes(principal, ar.scopes())) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Principal is not authorized to access the scopes the client requires");
                }
                throw this.accessDenied(ar);
            }
            ar.userId(userId);
            pending = null;
            if (!NullOrEmpty.nullOrEmpty((CharSequence)ar.state())) {
                pending = this.checkForExistingPendingApproval(data, principal, txn, ar.state());
            }
            if (pending != null) break block18;
            ApprovalRequest.Status status = this.checkForExistingApproval(data, principal, txn, ar);
            if (status == null) {
                data.createApprovalRequest(principal, txn, ar);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("New pending approval: " + ar);
                }
            } else {
                switch (status) {
                    case PENDING: {
                        if (ar.state() == null) break;
                        data.createPendingApproval(principal, txn, ar);
                        break;
                    }
                    case DENIED: {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Previously denied: " + ar);
                        }
                        throw this.accessDenied(ar);
                    }
                    case APPROVED: {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Previously approved: " + ar);
                        }
                        this.setBearerTokenAndRedirect(data, principal, txn, ar, true);
                    }
                }
            }
            ApprovalRequest approvalRequest2 = ar;
            Closeables.close((Object)txn);
            return approvalRequest2;
        }
        try {
            approvalRequest = pending;
        }
        catch (OAuthException e) {
            try {
                throw this.redirect(ar, e);
            }
            catch (Throwable throwable) {
                Closeables.close(txn);
                throw throwable;
            }
        }
        Closeables.close((Object)txn);
        return approvalRequest;
    }

    /*
     * Loose catch block
     */
    @Override
    public final Entity tokenRequest(RequestEntity request) {
        LocalePreference localePreference = LocalePreference.preference(request);
        Transaction txn = null;
        try {
            Entity response = null;
            TokenRequest tokenRequest = new TokenRequest();
            String clientId = Requests.remoteUser(request);
            ClientData clientData = this.client(request.principal(), clientId);
            tokenRequest.client = clientData.client;
            OAuthDataAccess data = clientData.data;
            txn = clientData.txn;
            FormFields formFields = Requests.formFields(request);
            String text = formFields.getRequiredField("grant_type");
            tokenRequest.grantType = GrantType.valueOf(text.toUpperCase());
            tokenRequest.code = text = (String)formFields.get((Object)"code");
            tokenRequest.redirectUri = text = (String)formFields.get((Object)"redirect_uri");
            tokenRequest.username = text = (String)formFields.get((Object)"username");
            text = (String)formFields.get((Object)"password");
            if (text != null) {
                tokenRequest.password = text.toCharArray();
            }
            if ((text = (String)formFields.get((Object)"scope")) != null) {
                tokenRequest.scopes = Arrays.asList(Text.spaceDelimited((String)text));
            }
            tokenRequest.refreshToken = text = (String)formFields.get((Object)"refresh_token");
            switch (tokenRequest.grantType) {
                case PASSWORD: {
                    response = this.resourceOwnerCredentials(data, txn, tokenRequest, request);
                    break;
                }
                case REFRESH_TOKEN: {
                    response = this.refreshToken(data, txn, tokenRequest, request);
                    break;
                }
                case AUTHORIZATION_CODE: {
                    response = this.authorizationCode(data, txn, tokenRequest, request);
                    break;
                }
                default: {
                    throw WebException.serviceUnavailable();
                }
            }
            Entity entity = response;
            Closeables.close((Object)txn);
            return entity;
        }
        catch (OAuthException e) {
            Entity entity = OAuthException.render(e, (Iterable<Locale>)((Object)localePreference));
            return entity;
        }
        catch (MissingFormFieldException e2) {
            throw WebException.badRequest(e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Closeables.close(txn);
        }
    }

    @Override
    public final BearerTokenVerification validateBearerToken(CompoundPrincipal principal, TenantIdentifier scopeId, String bearerToken) {
        return this.data.accessGranted(principal, scopeId, bearerToken);
    }

    protected void activate(ServiceProperties properties) {
    }

    private final OAuthException accessDenied(ApprovalRequest ar) {
        return OAuthException.error(OAuthException.Error.ACCESS_DENIED);
    }

    private AccessTokens assignTokens(OAuthDataAccess data, CompoundPrincipal principal, Transaction txn, ApprovalRequest ar) {
        AccessTokens accessTokens = AccessTokens.accessAndRefreshTokens();
        TenantIdentifier sessionId = data.createUserSession(principal, txn, ar, accessTokens);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Created OAuth2 user session: " + sessionId + " for approval request: " + ar);
        }
        return accessTokens;
    }

    private Entity authorizationCode(OAuthDataAccess data, Transaction txn, TokenRequest tokenRequest, RequestEntity request) {
        return this.exchangeRefreshTokenForAccessToken(data, txn, tokenRequest, request);
    }

    private boolean authorizeScopes(CompoundPrincipal principal, Collection<ApprovalRequest.Scope> requestedScopes) {
        boolean allAuthorized = false;
        for (ApprovalRequest.Scope requestedScope : requestedScopes) {
            boolean authorized;
            allAuthorized = authorized = ScopeAuthorizationPolicies.authorizeScope(principal, requestedScope.id());
            if (authorized) continue;
            if (!LOG.isLoggable(Level.FINE)) break;
            LOG.fine("Principal: " + principal.getName() + " is not authorized to access: " + requestedScope.name());
            break;
        }
        return allAuthorized;
    }

    private ApprovalRequest.Status checkForExistingApproval(OAuthDataAccess data, CompoundPrincipal principal, Transaction txn, ApprovalRequest ar) {
        ApprovalRequest existing = data.approvalRequest(principal, txn, ar.userId(), ar.clientId());
        if (existing != null) {
            boolean sameScopes = OAuthAuthorization.sameScopes(existing.scopes(), ar.scopes());
            ApprovalRequest.Status status = existing.status();
            switch (status) {
                case PENDING: {
                    break;
                }
                case DENIED: 
                case APPROVED: {
                    if (sameScopes) break;
                    data.deleteApprovalRequest(principal, txn, existing.id());
                    return null;
                }
            }
            ar.id(existing.id());
            return status;
        }
        return null;
    }

    private ApprovalRequest checkForExistingPendingApproval(OAuthDataAccess data, CompoundPrincipal principal, Transaction txn, String state) {
        ApprovalRequest ar = data.pendingApproval(principal, txn, state);
        return ar;
    }

    private ClientData client(CompoundPrincipal principal, OAuthDataAccess data, String clientId) {
        Transaction txn = data.newTransaction(principal);
        if (txn == null) {
            return null;
        }
        OAuthClient client = data.client(principal, txn, clientId);
        if (client == null) {
            Closeables.close((Object)txn);
            return null;
        }
        return new ClientData(client, data, txn);
    }

    private ClientData client(CompoundPrincipal principal, String clientId) {
        ClientData clientData = this.client(principal, this.data, clientId);
        return clientData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entity exchangeRefreshTokenForAccessToken(OAuthDataAccess data, Transaction txn, TokenRequest tokenRequest, RequestEntity request) {
        Pair<TenantIdentifier, ApprovalRequest> sessionAndApproval = data.sessionAndApproval(request.principal(), txn, tokenRequest.client, tokenRequest.code);
        if (sessionAndApproval == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No session found for specified token");
            }
            throw OAuthException.error(OAuthException.Error.INVALID_GRANT);
        }
        TenantIdentifier userSessionId = (TenantIdentifier)sessionAndApproval.first();
        ApprovalRequest ar = (ApprovalRequest)sessionAndApproval.second();
        try {
            if (ar == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No session found for specified token");
                }
                throw OAuthException.error(OAuthException.Error.INVALID_GRANT);
            }
            Entity entity = this.generateTokens(data, request.principal(), txn, ar);
            return entity;
        }
        finally {
            if (userSessionId != null) {
                data.deleteUserSession(request.principal(), txn, userSessionId);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Revoked OAuth2 user session: " + userSessionId + " for approval request: " + ar);
                }
            }
        }
    }

    private Entity generateTokens(OAuthDataAccess data, CompoundPrincipal principal, Transaction txn, ApprovalRequest ar) {
        AccessTokens accessTokens = this.assignTokens(data, principal, txn, ar);
        String bearerToken = accessTokens.accessToken();
        String refreshToken = accessTokens.refreshToken();
        Object[] parameters = new Object[]{"access_token", bearerToken, "token_type", "bearer", "expires_in", accessTokens.accessDuration() / 1000L, "refresh_token", refreshToken};
        return OAuthAuthorization.jsonEntity(parameters);
    }

    private OAuthException invalidRequest(ApprovalRequest ar) {
        return OAuthException.error(OAuthException.Error.INVALID_REQUEST);
    }

    private WebException redirect(ApprovalRequest ar, OAuthException e) {
        boolean fragment = ApprovalRequest.ResponseType.TOKEN == ar.responseType();
        String redirectUri = OAuthAuthorization.redirectUri(ar);
        String state = ar.state();
        return OAuthException.redirect(fragment, redirectUri, state, e);
    }

    private void redirectToClient(AccessTokens accessTokens, ApprovalRequest ar) {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        if (accessTokens.isAuthorizationCode()) {
            parameters.add(Pair.pair((Object)"code", (Object)accessTokens.refreshToken()));
        } else {
            parameters.add(Pair.pair((Object)"token_type", (Object)"bearer"));
            parameters.add(Pair.pair((Object)"access_token", (Object)accessTokens.accessToken()));
            parameters.add((Pair<String, String>)Pair.pair((Object)"expires_in", (Object)Long.toString(accessTokens.accessDuration() / 1000L)));
            if (accessTokens.hasRefreshToken()) {
                parameters.add((Pair<String, String>)Pair.pair((Object)"refresh_token", (Object)accessTokens.refreshToken()));
            }
        }
        String state = ar.state();
        if (state != null) {
            parameters.add(Pair.pair((Object)"state", (Object)state));
        }
        String redirectUri = OAuthAuthorization.redirectUri(ar);
        throw OAuthException.redirect(accessTokens.isIndirectToken(), redirectUri, parameters);
    }

    private Entity refreshToken(OAuthDataAccess data, Transaction txn, TokenRequest tokenRequest, RequestEntity request) {
        if (tokenRequest.code == null && tokenRequest.refreshToken != null) {
            tokenRequest.code = tokenRequest.refreshToken;
        }
        return this.exchangeRefreshTokenForAccessToken(data, txn, tokenRequest, request);
    }

    private CompoundPrincipal replace(CompoundPrincipal principal, CompoundPrincipal existingPrincipal, Class<? extends Principal> type) {
        Principal existing = existingPrincipal.principal(type);
        if (existing != null) {
            principal = principal.replace(type, existing);
        }
        return principal;
    }

    private Entity resourceOwnerCredentials(OAuthDataAccess data, Transaction txn, TokenRequest tokenRequest, RequestEntity request) {
        Pair credentials = Pair.pair((Object)tokenRequest.username, (Object)tokenRequest.password);
        BaseHandler cb = new BaseHandler(request, credentials){};
        AuthenticationService auth = (AuthenticationService)ServiceLocator.acquire(AuthenticationService.class);
        AuthenticationResult result = auth.authenticate(RESOURCE_OWNER_CREDENTIALS, cb);
        if (result.isValid()) {
            CompoundPrincipal principal = CompoundPrincipal.compound((Iterable)result);
            ApprovalRequest.Builder b = ApprovalRequest.builder();
            b.clientId(tokenRequest.client.clientId);
            b.clientSecret(tokenRequest.client.secret);
            b.userId(principal.getName());
            ApprovalRequest ar = b.build();
            List<ApprovalRequest.Scope> requestedScopes = tokenRequest.client.scopes;
            CompoundPrincipal existingPrincipal = request.principal();
            principal = this.replace(principal, existingPrincipal, JDBCPrincipal.class);
            principal = this.replace(principal, existingPrincipal, TenantPrincipal.class);
            principal = this.replace(principal, existingPrincipal, ECIDPrincipal.class);
            if (this.authorizeScopes(principal, requestedScopes)) {
                this.verifyClient(tokenRequest.client, ar);
                ApprovalRequest.Status status = this.checkForExistingApproval(data, principal, txn, ar);
                if (status == null) {
                    data.createApprovedRequest(principal, txn, ar);
                }
                return this.generateTokens(data, principal, txn, ar);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Principal is not authorized to access the scopes the client requires");
            }
            throw this.accessDenied(ar);
        }
        throw OAuthException.error(OAuthException.Error.INVALID_GRANT).description((Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "OQuthAuthorization.0", "Invalid resource owner credentials", new Object[0]));
    }

    private void setBearerTokenAndRedirect(OAuthDataAccess data, CompoundPrincipal principal, Transaction txn, ApprovalRequest ar, boolean previouslyApproved) {
        AccessTokens accessTokens = null;
        accessTokens = ar.responseType().equals((Object)ApprovalRequest.ResponseType.TOKEN) ? AccessTokens.accessTokenOnly() : AccessTokens.authorizationCode();
        TenantIdentifier sessionId = data.createUserSession(principal, txn, ar, accessTokens);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Created OAuth2 user session: " + sessionId + " for approval request: " + ar);
        }
        this.redirectToClient(accessTokens, ar);
    }

    private boolean validateRedirect(OAuthClient expected) {
        if (ApprovalRequest.AuthFlow.AUTH_CODE == expected.authFlow || ApprovalRequest.AuthFlow.IMPLICIT == expected.authFlow) {
            return NullOrEmpty.nullOrEmpty((CharSequence)expected.redirectUri);
        }
        return false;
    }

    private void verifyClient(OAuthClient expected, ApprovalRequest ar) {
        if (expected == null) {
            throw this.invalidRequest(ar);
        }
        if (!expected.responseType.equals((Object)ar.responseType())) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Attempting to use incorrect response type");
            }
            throw this.invalidRequest(ar);
        }
        if (this.validateRedirect(expected)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Client lacks a redirect URI");
            }
            throw this.accessDenied(ar);
        }
        ar.redirectUri(expected.redirectUri);
        ar.scopes().clear();
        ar.scopes().addAll(expected.scopes);
        ar.clientKey(expected.id).name(expected.name).description(expected.description).email(expected.email);
    }

    public static String redirectUri(ApprovalRequest ar) {
        String redirectUri = ar.redirectUri();
        if (NATIVE_CLIENT_REDIRECT.equals(redirectUri)) {
            return "oauth2/native";
        }
        return redirectUri;
    }

    public static BearerTokenVerification verifyApproval(TenantIdentifier scopeId, Timestamp expiry, Timestamp now, String userId, List<TenantIdentifier> scopes) {
        boolean authorized = false;
        boolean expired = true;
        for (TenantIdentifier approvedScope : scopes) {
            if (!scopeId.equals(approvedScope)) continue;
            authorized = true;
            if (!expiry.after(now)) break;
            expired = false;
            break;
        }
        AccessTokenStatus status = AccessTokenStatus.EXPIRED;
        if (!expired) {
            status = AccessTokenStatus.VALID;
        } else if (!authorized) {
            status = AccessTokenStatus.INSUFFICENT_AUTHORITY;
        }
        return BearerTokenVerification.verification(userId, status);
    }

    static Entity jsonEntity(Object ... parameters) {
        JSONBuilder json = JSONBuilder.o((JSONOptions)JSONOptions.DEFAULT_JSON_OPTIONS);
        for (int i = 0; i < parameters.length; ++i) {
            Object value;
            String name = (String)parameters[i];
            if ((value = parameters[++i]) == null) continue;
            json.p(name, value);
        }
        StringWriter text = new StringWriter();
        JSONBuilder.render((JSONRenderer)new JSONFormatter((Appendable)text), (JSONOptions)json.options(), (JSONNode)json.build());
        try {
            return Entities.entity(StreamCopy.toInputStream((CharSequence)text.toString()), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.JSON}));
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    private static boolean sameScopes(Set<ApprovalRequest.Scope> expected, Collection<ApprovalRequest.Scope> actual) {
        if (expected.size() == actual.size()) {
            Set difference = (Set)Collections.clone(expected);
            difference.removeAll(actual);
            return difference.size() == 0;
        }
        return false;
    }

    private static class TokenRequest {
        public List<String> scopes;
        OAuthClient client;
        String code;
        GrantType grantType;
        char[] password;
        String redirectUri;
        String refreshToken;
        String username;

        private TokenRequest() {
        }
    }

    private static class ClientData {
        private final OAuthClient client;
        private final OAuthDataAccess data;
        private final Transaction txn;

        private ClientData(OAuthClient client, OAuthDataAccess data, Transaction txn) {
            this.client = client;
            this.data = data;
            this.txn = txn;
        }
    }

    public static class OAuthClient {
        public ApprovalRequest.AuthFlow authFlow;
        public String clientId;
        public String description;
        public String email;
        public TenantIdentifier id;
        public String name;
        public String redirectUri;
        public ApprovalRequest.ResponseType responseType;
        public List<ApprovalRequest.Scope> scopes;
        public String secret;
    }

    public static enum GrantType {
        AUTHORIZATION_CODE,
        CLIENT_CREDENTIALS,
        PASSWORD,
        REFRESH_TOKEN;

    }
}

