/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.cache;

import oracle.dbtools.cache.CacheConfiguration;
import oracle.dbtools.common.service.NotAvailableException;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.BaseScopeAuthorizationPolicy;
import oracle.dbtools.rt.authorization.ScopeAuthorizationPolicy;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.resource.templates.cache.MetadataCache;
import oracle.dbtools.rt.resource.templates.cache.MetadataCacheConfigurations;
import oracle.dbtools.rt.resource.templates.cache.MetadataCaches;

@Service(priority=4)
public class CachedScopeAuthorizationPolicy
extends BaseScopeAuthorizationPolicy
implements ScopeAuthorizationPolicy {
    @Reference
    private MetadataCacheConfigurations cacheConfs;
    @Reference
    private MetadataCaches caches;

    protected void activate(ServiceProperties props) {
        CacheConfiguration cacheConf = this.cacheConfs.resourceModules();
        if (!cacheConf.enabled()) {
            throw new NotAvailableException(CachedScopeAuthorizationPolicy.class);
        }
    }

    @Override
    protected AuthorizationPolicy.Access authorize(CompoundPrincipal principal, TenantIdentifier scopeId) {
        MetadataCache cache = this.caches.get(principal);
        if (cache == null) {
            return AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN;
        }
        return cache.authorize(principal, scopeId);
    }
}

