/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.authorization.PrivilegeSecurityConfig;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.resource.templates.v2.ProtectedResourceTemplateMatch;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.HttpMethod;

public abstract class ResourceTemplateMatchBase
implements ProtectedResourceTemplateMatch {
    private final ResourceModule module;
    private final transient CompoundPrincipal principal;
    private final TenantIdentifier privilegeId;
    private transient SecurityConfig securityConfig;
    private final ResourceTemplate template;

    protected ResourceTemplateMatchBase(CompoundPrincipal principal, ResourceModule module, TenantIdentifier privilegeId, ResourceTemplate template) {
        this.principal = principal;
        this.module = module;
        this.privilegeId = privilegeId;
        this.securityConfig = privilegeId == null ? SecurityConfigs.NONE : new PrivilegeSecurityConfig(privilegeId);
        this.template = template;
    }

    @Override
    public final boolean corsEnabled() {
        if (this.privilegeId == null) {
            return true;
        }
        return !this.module.originsAllowed().isEmpty();
    }

    @Override
    public final ResourceHandler handler(CharSequence mthd) {
        String method = HttpMethod.GET.method();
        if (mthd != null) {
            method = mthd.toString();
        }
        return this.handler(method);
    }

    @Override
    public final ResourceModule module() {
        return this.module;
    }

    @Override
    public final TenantIdentifier privilegeId() {
        return this.privilegeId;
    }

    @Override
    public final SecurityConfig securityConfig() {
        return this.securityConfig;
    }

    @Override
    public final ResourceTemplate template() {
        return this.template;
    }

    public String toString() {
        return "ResourceTemplateMatch [module=" + this.module + ", privilegeId=" + this.privilegeId + ", template=" + this.template + "]";
    }

    @Override
    public final URITemplate uriTemplate() {
        return this.template.uriTemplate();
    }

    protected abstract ResourceHandler handler(String var1);

    protected final CompoundPrincipal principal() {
        return this.principal;
    }
}

