/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.apex.statistics.Statistics;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Collections;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.json.query.JSONQueryStream;
import oracle.dbtools.rt.statistics.LogMessageToResultRow;
import oracle.dbtools.rt.web.AcceptFormatting;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class LogService
extends RequestHandler {
    private static final LogMessageToResultRow LOGS_TO_ROWS = new LogMessageToResultRow();
    public static final RequestHandlerMetaData META_DATA = LogService.secureService("_/statistics/log", HttpMethod.GET);

    public LogService() {
        super(META_DATA);
    }

    @Override
    protected Entity delete(RequestEntity request) throws IOException {
        Statistics.getInstance().clearLogging();
        return HttpResources.NO_CONTENT;
    }

    @Override
    protected Entity get(RequestEntity request) throws IOException {
        AcceptFormatting contentFormatting = AcceptFormatting.contentFormatting(request);
        JSONOptions options = JSONOptions.configure(contentFormatting.parameters());
        Statistics.Report report = Statistics.getInstance().getReport();
        List logs = report.getLogs();
        Iterator<ResultRow> rows = this.asResultRows(Collections.reverseIterator((List)logs));
        return LogService.entity((InputStream)((Object)new JSONQueryStream(rows, options)), LogService.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.JSON}), new Object[0]);
    }

    private Iterator<ResultRow> asResultRows(Iterator<String> errors) {
        return Iterators.transform(errors, (Transform)LOGS_TO_ROWS);
    }
}

