/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.validation;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.dbtools.common.Translatables;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Template;
import oracle.dbtools.rt.validation.ConstraintDescriptor;
import oracle.dbtools.rt.validation.ConstraintViolation;
import oracle.dbtools.rt.validation.Path;
import oracle.dbtools.rt.validation.ValidationMessages;

class ConstraintViolationImpl<T>
implements ConstraintViolation<T> {
    private final ConstraintDescriptor<?> constraintDescriptor;
    private final Object invalidValue;
    private final Path propertyPath;
    private final T rootBean;

    ConstraintViolationImpl(T rootBean, Path propertyPath, Object invalidValue, ConstraintDescriptor<?> constraintDescriptor) {
        this.rootBean = rootBean;
        this.propertyPath = propertyPath;
        this.constraintDescriptor = constraintDescriptor;
        this.invalidValue = invalidValue;
    }

    @Override
    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    @Override
    public Object getInvalidValue() {
        return this.invalidValue;
    }

    @Override
    public Object getLeafBean() {
        return null;
    }

    @Override
    public String toString(Iterable<Locale> localePreference) {
        String messageTemplate = this.getMessageTemplate();
        if (messageTemplate == null) {
            return null;
        }
        Template t = new Template(messageTemplate);
        ResourceBundle bundle = Translatables.getBundle(ValidationMessages.class, localePreference);
        String interpolated = t.encode(this.toStrings(bundle));
        Template t2 = new Template(interpolated);
        return t2.encode(this.toStrings(this.constraintDescriptor.getAttributes()));
    }

    @Override
    public String getMessageTemplate() {
        return (String)this.constraintDescriptor.getAttributes().get("message");
    }

    @Override
    public Path getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public T getRootBean() {
        return this.rootBean;
    }

    @Override
    public Class<T> getRootBeanClass() {
        return this.rootBean.getClass();
    }

    public String toString() {
        return this.toString(Iterables.iterable((Object[])new Locale[]{Locale.getDefault()}));
    }

    private Map<String, String> toStrings(Map<String, Object> attributes) {
        LinkedHashMap<String, String> strings = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
            strings.put(attribute.getKey(), attribute.getValue().toString());
        }
        String value = "null";
        if (this.invalidValue != null) {
            value = this.invalidValue.toString();
        }
        strings.put("value", value);
        return strings;
    }

    private Map<String, String> toStrings(ResourceBundle bundle) {
        LinkedHashMap<String, String> strings = new LinkedHashMap<String, String>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = bundle.getString(key);
            strings.put(key, value);
        }
        return strings;
    }
}

