/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.plugin.api.conf.Configuration;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.web.ExternalErrorPage;
import oracle.dbtools.rt.web.HttpStatusCode;

class ExternalErrorPages {
    private final ConcurrentMap<HttpStatusCode, ExternalErrorPage> externalErrorPages = new ConcurrentHashMap<HttpStatusCode, ExternalErrorPage>();
    private URITemplate externalErrors = null;
    private static final String DEFAULT_EXTERNAL_PATTERN = "{status}.html";
    private static final String FILE_PROTOCOL = "file://";
    private static final Log LOG = Log.get(ExternalErrorPages.class);

    ExternalErrorPages(URITemplate externalErrors) {
        this.externalErrors = externalErrors;
    }

    Entity errorPage(HttpStatusCode statusCode, String reasonsHtml) throws IOException {
        ExternalErrorPage page = (ExternalErrorPage)this.externalErrorPages.get(statusCode);
        return page.encode("statusCode", Integer.toString(statusCode.statusCode()), "statusMessage", statusCode.message(), "reasons", reasonsHtml);
    }

    boolean hasExternalErrorPage(HttpStatusCode statusCode) {
        try {
            ExternalErrorPage resource = this.checkErrorPageExists(statusCode);
            return resource != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    private ExternalErrorPage checkErrorPageExists(HttpStatusCode statusCode) throws IOException {
        ExternalErrorPage resource = null;
        if (this.externalErrors != null) {
            resource = (ExternalErrorPage)this.externalErrorPages.get(statusCode);
            if (resource == null) {
                resource = this.externalPage(statusCode);
            }
            if (resource != null) {
                this.externalErrorPages.putIfAbsent(statusCode, resource);
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalErrorPage externalPage(HttpStatusCode statusCode) {
        InputStream body = null;
        String path = this.externalErrors.encode(Maps.toMap((String[])new String[]{"status", Integer.toString(statusCode.statusCode())}));
        try {
            File file = Files.file((String)path);
            if (file.exists()) {
                ExternalErrorPage page;
                body = Files.inputStream((File)file);
                String template = StreamCopy.string((InputStream)body);
                ExternalErrorPage externalErrorPage = page = ExternalErrorPage.page(template, "reasons");
                Closeables.close((Object)body);
                return externalErrorPage;
            }
            Closeables.close(body);
        }
        catch (IOException e) {
            LOG.severe((Throwable)e);
        }
        finally {
            Closeables.close(body);
        }
        return null;
    }

    static ExternalErrorPages externalErrorPages(Configuration conf) {
        URITemplate externalErrors = null;
        String externalPath = conf.get("error.externalPath");
        if (externalPath != null) {
            if (externalPath.startsWith(FILE_PROTOCOL)) {
                externalPath = externalPath.substring(FILE_PROTOCOL.length());
            }
            while (externalPath.endsWith("/")) {
                externalPath = externalPath.substring(0, externalPath.length() - 1);
            }
            try {
                File folder = Files.file((String)externalPath);
                if (!folder.exists()) {
                    LOG.severe("The external error folder does not exist: " + folder.getCanonicalPath());
                }
                if (!folder.isDirectory()) {
                    LOG.severe("The external error folder is not actually a folder: " + folder.getCanonicalPath());
                }
                if (!folder.canRead()) {
                    LOG.severe("The external error folder is not accessible: " + folder.getCanonicalPath());
                }
            }
            catch (IOException e) {
                LOG.severe("An error occurred trying to configure the external error folder: " + externalPath);
            }
            String externalPattern = conf.get("error.externalPattern", DEFAULT_EXTERNAL_PATTERN);
            externalErrors = URITemplates.uriTemplate(externalPath + '/' + externalPattern);
        }
        return new ExternalErrorPages(externalErrors);
    }
}

