/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.dbtools.auth.AuthenticationStatus;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.diagnostics.DiagnosticContext;
import oracle.dbtools.common.diagnostics.Diagnostics;
import oracle.dbtools.common.ecid.ECIDPrincipal;
import oracle.dbtools.common.ecid.ECIDPrincipals;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.FormFields;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.http.servlet.HttpServletRequestBody;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaderBase;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.tenants.Tenants;
import oracle.dbtools.rt.web.ApexHeaders;
import oracle.dbtools.rt.web.BaseAndPath;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HTTPRequestEntityHeaders;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.WebException;

public final class Requests {
    public static final ContentType FORM_DATA = ContentType.contentType("application/x-www-form-urlencoded");
    public static final String SECURE_COOKIE_NAME = "_com_ora_al_";
    private static final Log LOG = Log.get(Requests.class);
    private static final String REASON_REQUIRES_SECURE_ACCESS = "uri.scheme";
    public static final String TENANT_PRINCIPAL = "__tenant_principal";
    private static boolean verifyTransport = true;

    private Requests() {
    }

    public static void acceptable(ContentType contentType, ContentType ... acceptable) throws WebException {
        if (!(NullOrEmpty.nullOrEmpty((Object[])acceptable) || contentType != null && contentType.matches(acceptable))) {
            throw WebException.unsupportedMediaType();
        }
    }

    public static void acceptable(RequestEntity request, ContentType ... contentTypes) {
        ContentType contentType = request.contentType();
        try {
            Requests.acceptable(contentType, new ContentType[0]);
        }
        catch (WebException e) {
            if (HttpStatusCode.UNSUPPORTED_MEDIA_TYPE == e.statusCode()) {
                Requests.log(request, (Object)((Object)contentType) + " is not an acceptable media type");
            }
            throw e;
        }
    }

    public static String documentBase(Entity entity) {
        EntityHeader b = entity.headers().header("X-APEX-BASE");
        String base = b.value();
        EntityHeader p = entity.headers().header("X-APEX-PATH");
        String path = p.value();
        return BaseAndPath.documentBase(base, path);
    }

    public static String documentBase(RequestEntity request) {
        return Requests.documentBase((RequestPaths)request);
    }

    public static String documentBase(RequestPaths requestPaths) {
        return BaseAndPath.documentBase(requestPaths.base(), requestPaths.path());
    }

    public static FormFields formFields(RequestEntity request) {
        return Requests.wrapper(request).formFields;
    }

    public static RequestEntity suppressHeaders(RequestEntity request, CharSequence ... suppressedHeaders) throws IOException {
        EntityHeaders headers = request.headers();
        EntityHeaders modifiedHeaders = Entities.suppress(headers, suppressedHeaders);
        Entity modifiedEntity = Entities.entity(request.body(), modifiedHeaders);
        RequestEntityWrapper existingRequest = Requests.wrapper(request);
        return new RequestEntityWrapper(modifiedEntity, existingRequest.req, request.principal());
    }

    public static RequestEntity forward(RequestEntity request, CharSequence path, boolean forceGet, EntityHeaders additionalHeaders) {
        EntityHeaders headers = request.headers();
        if (additionalHeaders != null) {
            headers = Entities.merge(request.headers(), additionalHeaders);
        }
        headers = Entities.merge(headers, Requests.forwardedPath(request, path, forceGet));
        Entity forwardedEntity = Entities.entity(StreamCopy.emptyStream(), headers);
        RequestEntityWrapper existingRequest = Requests.wrapper(request);
        return new RequestEntityWrapper(forwardedEntity, existingRequest.req, request.principal());
    }

    public static boolean hasContent(RequestEntity request) {
        String method = request.method();
        if (HttpMethod.GET.equals(method) || HttpMethod.HEAD.equals(method) || HttpMethod.DELETE.equals(method)) {
            return false;
        }
        return request.contentType() != null;
    }

    public static void invalidateSession(RequestEntity request) {
        Requests.wrapper(request).invalidateSession();
    }

    public static boolean isHtmlForm(RequestEntity request) {
        return FORM_DATA.matches(request.contentType());
    }

    public static boolean isRead(RequestEntity request) {
        return HttpMethod.GET.equals(request.method()) || HttpMethod.HEAD.equals(request.method());
    }

    public static boolean isStandardPort(RequestPaths request) {
        if (request instanceof HttpTransport) {
            return ((HttpTransport)((Object)request)).standardPort();
        }
        return false;
    }

    public static void log(RequestEntity request, CharSequence text) {
        Requests.wrapper(request).log(text);
    }

    public static void log(RequestEntity request, Throwable t) {
        Requests.wrapper(request).log(t);
    }

    public static RequestEntity merge(RequestEntity existing, Entity updated) throws IOException {
        Entity mergedEntity = Entities.entity(updated.body(), Entities.merge(existing.headers(), updated.headers()));
        return new RequestEntityWrapper(mergedEntity, Requests.wrapper(existing).req, existing.principal());
    }

    public static Pair<String, String> pathAndQuery(RequestPaths request) {
        String path = request.path();
        String[] segments = path.split("\\?");
        if (segments.length == 1) {
            return Pair.pair((Object)path, null);
        }
        return Pair.pair((Object)segments[0], (Object)segments[1]);
    }

    public static RequestEntity principal(RequestEntity request, CompoundPrincipal authenticatedUser) {
        return new MutatedPrincipal(request, request.principal().identifiedAs((Iterable)authenticatedUser));
    }

    public static String remoteUser(RequestEntity request) {
        return request.principal().getName();
    }

    public static RequestEntity replacePrincipal(RequestEntity request, Principal principal, Class<? extends Principal> replaceTypesOf) {
        if (principal == null) {
            return request;
        }
        CompoundPrincipal mutated = null;
        if (replaceTypesOf == CompoundPrincipal.class && principal instanceof CompoundPrincipal) {
            mutated = (CompoundPrincipal)principal;
        } else {
            CompoundPrincipal existing = request.principal();
            mutated = existing.replace(replaceTypesOf, principal);
        }
        return new MutatedPrincipal(request, mutated);
    }

    public static RequestEntity request(HttpServletRequest request) throws IOException {
        Entity entity = Entities.entity(StreamCopy.uncloseable((InputStream)new HttpServletRequestBody(request)), Requests.headers(request));
        RequestEntityWrapper req = new RequestEntityWrapper(entity, request, null);
        return Requests.tenant(request, req);
    }

    public static HttpServletRequest servletRequest(RequestEntity request) {
        return Requests.wrapper(request).servletRequest();
    }

    public static Object sessionAttribute(RequestEntity request, String attributeName) {
        return Requests.wrapper(request).sessionAttribute(attributeName);
    }

    public static void sessionAttribute(RequestEntity request, String attributeName, Object value) {
        Requests.wrapper(request).sessionAttribute(attributeName, value);
    }

    public static TenantPrincipal tenant(RequestEntity request) {
        TenantPrincipal tenant = Requests.principal(request, TenantPrincipal.class);
        if (tenant == null) {
            tenant = TenantPrincipal.noTenant();
        }
        return tenant;
    }

    public static void verifyTransport(boolean verifyTransport) {
        Requests.verifyTransport = verifyTransport;
    }

    private static boolean checkConfig() {
        try {
            return (Boolean)PrimitiveTypes.valueOf((CharSequence)GlobalConfiguration.globalConfiguration().get("security.verifySSL", "true"), Boolean.class);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private static FormFields formFields(HttpServletRequest req) {
        MultiAssociativeArrays.Builder fields = MultiAssociativeArrays.builder();
        Map parameters = req.getParameterMap();
        if (parameters != null) {
            for (String name : parameters.keySet()) {
                String[] values;
                for (String value : values = (String[])parameters.get(name)) {
                    fields.add((Object)name, (Object)value);
                }
            }
        }
        return new FormFields(fields.build());
    }

    private static EntityHeaders forwardedPath(RequestPaths request, CharSequence path, boolean forceGet) {
        CharSequence[] values = null;
        values = forceGet ? new CharSequence[]{"X-APEX-METHOD", HttpMethod.GET, "X-APEX-PATH", path} : new CharSequence[]{"X-APEX-PATH", path};
        return Entities.headers(values);
    }

    private static EntityHeaders headers(HttpServletRequest request) {
        String charsetParameter;
        String[] baseAndPath = BaseAndPath.baseAndPath(request);
        String base = baseAndPath[0];
        String path = baseAndPath[1];
        String mediaType = request.getHeader(HttpHeader.CONTENT_TYPE.toString());
        String method = request.getMethod();
        String remoteAddress = request.getRemoteAddr();
        ContentType contentType = null;
        String charset = Text.defaultEncoding();
        if (mediaType != null && (charsetParameter = (contentType = ContentType.contentType(mediaType)).parameter("charset")) != null) {
            contentType = contentType.removeParameter("charset");
            charset = charsetParameter;
        }
        HTTPRequestEntityHeaders requestHeaders = new HTTPRequestEntityHeaders(request);
        EntityHeaders internalHeaders = Requests.internalHeaders(method, remoteAddress, base, path, contentType, charset);
        return Entities.merge(Requests.suppressInternalHeaders(requestHeaders), internalHeaders);
    }

    private static EntityHeaders internalHeaders(String method, String remoteAddress, String base, String path, ContentType contentType, String charset) {
        EntityHeaders internalHeaders = Entities.headers(new CharSequence[]{"X-APEX-METHOD", method, "X-APEX-BASE", base, "X-APEX-PATH", path, "X-APEX-CHARSET", charset, HttpHeader.CONTENT_TYPE, contentType, "X-APEX-REMOTE-ADDRESS", remoteAddress});
        return internalHeaders;
    }

    private static boolean isUserInRole(CompoundPrincipal compoundPrincipal, String name) {
        if (name == null) {
            return false;
        }
        for (Principal principal : compoundPrincipal) {
            if (!name.equals(principal.getName())) continue;
            return true;
        }
        return false;
    }

    private static <T extends Principal> T principal(RequestEntity request, Class<T> type) {
        CompoundPrincipal root = request.principal();
        Principal principal = null;
        if (root != null && root instanceof CompoundPrincipal) {
            CompoundPrincipal compound = root;
            principal = compound.principal(type);
        }
        return (T)principal;
    }

    private static EntityHeaders suppressInternalHeaders(HTTPRequestEntityHeaders requestHeaders) {
        return Entities.suppress((EntityHeaders)requestHeaders, ApexHeaders.ALL);
    }

    private static RequestEntity tenant(HttpServletRequest request, RequestEntityWrapper req) {
        TenantPrincipal tenant = (TenantPrincipal)request.getAttribute(TENANT_PRINCIPAL);
        if (tenant == null) {
            String tenantIdentifier = (String)request.getAttribute("tenantIdentifier");
            RequestEntity tenantedRequest = Tenants.tenant(req, tenantIdentifier);
            tenant = (TenantPrincipal)tenantedRequest.principal().principal(TenantPrincipal.class);
            if (tenant != null) {
                request.setAttribute(TENANT_PRINCIPAL, (Object)tenant);
            }
            return tenantedRequest;
        }
        return Requests.replacePrincipal(req, tenant, TenantPrincipal.class);
    }

    private static void verifySecurityConstraint(HttpTransport transport, CompoundPrincipal principal, SecurityConfig securityConfig) {
        SecurityConstraint constraint = securityConfig.constraint();
        if (constraint != SecurityConstraint.NONE) {
            if ((constraint == SecurityConstraint.SECURE || constraint == SecurityConstraint.SECURE_AND_AUTHENTICATED) && Requests.verifyTransportRequired() && !transport.secure()) {
                Requests.log((RequestEntity)((Object)transport), "must be accessed over https only");
                throw WebException.forbidden().reasons(Reason.reason(REASON_REQUIRES_SECURE_ACCESS, (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "ResourceTemplate.0", "This resource must be accessed over HTTPS only", new Object[0])));
            }
            if ((constraint == SecurityConstraint.AUTHENTICATED || constraint == SecurityConstraint.SECURE_AND_AUTHENTICATED) && principal.primary().equals(AnonymousPrincipal.ANONYMOUS)) {
                Requests.log((RequestEntity)((Object)transport), "not a public resource, no user authenticated, not authorized");
                throw securityConfig.notAuthorized((RequestEntity)((Object)transport), AuthenticationStatus.INVALID);
            }
        }
    }

    private static boolean verifyTransportRequired() {
        return verifyTransport && Requests.checkConfig();
    }

    private static RequestEntityWrapper wrapper(RequestEntity request) {
        if (request instanceof RequestEntityWrapper) {
            RequestEntityWrapper wrapper = (RequestEntityWrapper)request;
            return wrapper;
        }
        if (request instanceof MutatedPrincipal) {
            return Requests.wrapper(((MutatedPrincipal)request).request);
        }
        throw new IllegalStateException("No RequestEntityWrapper found in this request");
    }

    private static class ServletRequestPrincipal
    implements Principal,
    Serializable {
        private final String remoteUser;
        private static final long serialVersionUID = -856517306468537997L;

        ServletRequestPrincipal(HttpServletRequest request) {
            this.remoteUser = request.getRemoteUser();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServletRequestPrincipal other = (ServletRequestPrincipal)obj;
            return !(this.remoteUser == null ? other.remoteUser != null : !this.remoteUser.equals(other.remoteUser));
        }

        @Override
        public String getName() {
            return this.remoteUser;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.remoteUser == null ? 0 : this.remoteUser.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    private static final class RequestEntityWrapper
    implements RequestEntity,
    HttpTransport {
        private final DiagnosticContext diagnosticContext;
        private final Entity entity;
        private final FormFields formFields;
        private final CompoundPrincipal principal;
        private final HttpServletRequest req;
        private static final String SECURE_PROTOCOL = "https";

        private RequestEntityWrapper(Entity entity, HttpServletRequest req, CompoundPrincipal existingPrincipal) {
            this.diagnosticContext = this.diagnosticContext(req);
            this.req = req;
            this.principal = existingPrincipal == null ? RequestEntityWrapper.principal(req) : existingPrincipal;
            this.entity = Entities.merge(entity, (EntityHeaders)new ApexUserHeader(entity.headers(), this.principal));
            this.formFields = Requests.formFields(req);
        }

        @Override
        public String base() {
            EntityHeader h = this.entity.headers().header("X-APEX-BASE");
            if (h == null) {
                return null;
            }
            return h.value();
        }

        @Override
        public InputStream body() throws IOException {
            return this.entity.body();
        }

        @Override
        public void close() throws IOException {
            this.entity.close();
        }

        @Override
        public ContentType contentType() {
            EntityHeader h = this.entity.headers().header(HttpHeader.CONTENT_TYPE);
            if (h == null) {
                return null;
            }
            return ContentType.contentType(h.value());
        }

        @Override
        public EntityHeaders headers() {
            return this.entity.headers();
        }

        public void invalidateSession() {
            HttpSession session = this.req.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        }

        @Override
        public boolean isUserInRole(String name) {
            return Requests.isUserInRole(this.principal, name);
        }

        @Override
        public String method() {
            EntityHeader h = this.entity.headers().header("X-APEX-METHOD");
            if (h == null) {
                return null;
            }
            return h.value();
        }

        @Override
        public String path() {
            EntityHeader h = this.entity.headers().header("X-APEX-PATH");
            if (h == null) {
                return null;
            }
            return h.value();
        }

        @Override
        public CompoundPrincipal principal() {
            return this.principal;
        }

        @Override
        public boolean secure() {
            return SECURE_PROTOCOL.equals(this.req.getScheme()) || this.req.isSecure();
        }

        public Object sessionAttribute(String attributeName) {
            HttpSession session = this.req.getSession(false);
            if (session != null) {
                return session.getAttribute(attributeName);
            }
            return null;
        }

        @Override
        public boolean standardPort() {
            int serverPort = this.req.getServerPort();
            return -1 == serverPort || this.secure() && serverPort == 443 || serverPort == 80;
        }

        public String toString() {
            return this.entity.toString();
        }

        @Override
        public void verifySecurityConstraint(SecurityConfig securityConfig) {
            RequestEntityWrapper transport = this;
            CompoundPrincipal principal = this.principal();
            Requests.verifySecurityConstraint(transport, principal, securityConfig);
        }

        void log(CharSequence text) {
            this.diagnosticContext.log(text);
        }

        void log(Throwable t) {
            this.diagnosticContext.log(t);
        }

        private DiagnosticContext diagnosticContext(HttpServletRequest req) {
            try {
                Diagnostics diagnostics = (Diagnostics)ServiceLocator.acquire(Diagnostics.class);
                return diagnostics.diagnosticContext(req);
            }
            catch (Throwable t) {
                LOG.fine(t);
                return DiagnosticContext.DISABLED;
            }
        }

        private HttpServletRequest servletRequest() {
            return this.req;
        }

        private void sessionAttribute(String attributeName, Object value) {
            HttpSession session = this.req.getSession(true);
            session.setAttribute(attributeName, value);
        }

        private static CompoundPrincipal principal(HttpServletRequest request) {
            ArrayList<Object> principals = new ArrayList<Object>(2);
            Principal principal = request.getUserPrincipal();
            if (principal == null) {
                principals.add(AnonymousPrincipal.ANONYMOUS);
            } else {
                principals.add(new ServletRequestPrincipal(request));
            }
            JDBCPrincipal jdbcPrincipal = (JDBCPrincipal)request.getAttribute("jdbcPrincipal");
            if (jdbcPrincipal != null) {
                principals.add(jdbcPrincipal);
            }
            ECIDPrincipal ecid = ECIDPrincipals.ecidPrincipal((HttpServletRequest)request, (boolean)false);
            principals.add(ecid);
            return CompoundPrincipal.compound(principals);
        }
    }

    private static final class MutatedPrincipal
    implements RequestEntity,
    HttpTransport {
        private final EntityHeaders headers;
        private final CompoundPrincipal mutated;
        private final RequestEntity request;

        private MutatedPrincipal(RequestEntity request, CompoundPrincipal mutated) {
            this.request = request;
            this.mutated = mutated;
            this.headers = new ApexUserHeader(request.headers(), this.mutated);
        }

        @Override
        public String base() {
            return this.request.base();
        }

        @Override
        public InputStream body() throws IOException {
            return this.request.body();
        }

        @Override
        public void close() throws IOException {
            this.request.close();
        }

        @Override
        public ContentType contentType() {
            return this.request.contentType();
        }

        @Override
        public EntityHeaders headers() {
            return this.headers;
        }

        @Override
        public boolean isUserInRole(String name) {
            return Requests.isUserInRole(this.principal(), name);
        }

        @Override
        public String method() {
            return this.request.method();
        }

        @Override
        public String path() {
            return this.request.path();
        }

        @Override
        public CompoundPrincipal principal() {
            return this.mutated;
        }

        @Override
        public boolean secure() {
            return ((HttpTransport)((Object)this.request)).secure();
        }

        @Override
        public boolean standardPort() {
            return ((HttpTransport)((Object)this.request)).standardPort();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("Compound-Principal: ");
            b.append(this.mutated.toString());
            b.append("\n");
            b.append(this.headers().toString());
            return b.toString();
        }

        @Override
        public void verifySecurityConstraint(SecurityConfig securityConfig) {
            Requests.verifySecurityConstraint(this, this.principal(), securityConfig);
        }
    }

    private static interface HttpTransport {
        public boolean secure();

        public boolean standardPort();
    }

    private static final class ApexUserHeader
    implements EntityHeaders {
        private final Iterable<String> names;
        private final EntityHeaders target;
        private final String user;

        ApexUserHeader(EntityHeaders target, CompoundPrincipal principal) {
            this.target = target;
            this.user = principal == null ? null : principal.getName();
            if (this.user == null) {
                this.names = target;
            } else {
                LinkedHashSet<String> headers = new LinkedHashSet<String>();
                Iterators.add(headers, target.iterator());
                headers.add("X-APEX-USER");
                this.names = headers;
            }
        }

        @Override
        public int compareTo(EntityHeaders o) {
            return this.target.compareTo(o);
        }

        @Override
        public EntityHeader header(CharSequence name) {
            if (this.user != null && "X-APEX-USER".equalsIgnoreCase(name.toString())) {
                return new EntityHeaderBase("X-APEX-USER"){

                    @Override
                    public String toString() {
                        return Entities.string(this);
                    }

                    @Override
                    public Iterable<String> values() {
                        return Iterables.iterable((Object[])new String[]{ApexUserHeader.this.user});
                    }
                };
            }
            return this.target.header(name);
        }

        @Override
        public Iterator<String> iterator() {
            return this.names.iterator();
        }

        public String toString() {
            return Entities.toString(this);
        }
    }
}

