/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.util.Collections;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.dispatch.DispatchableResourceType;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RequestDispatchers;
import oracle.dbtools.rt.web.RequestEntity;

public interface ResourceDispatcher {
    public static final Score NO_MATCH = new Score(null, -1, SecurityConfigs.NONE, null, Iterables.empty(), false);

    public Score canDispatch(RequestEntity var1);

    public HttpResource dispatch(Score var1, RequestEntity var2) throws IOException;

    public static class Score {
        private final boolean corsEnabled;
        private final Object handle;
        private final Iterable<String> originsAllowed;
        private final SecurityConfig scope;
        private final int score;
        private final DispatchableResourceType type;

        public Score(DispatchableResourceType type, int score, SecurityConfig scope, Object handle, boolean corsEnabled) {
            this(type, score, scope, handle, Collections.emptyList(), corsEnabled);
        }

        public Score(DispatchableResourceType type, int score, SecurityConfig scope, Object handle, Iterable<String> originsAllowed, boolean corsEnabled) {
            this.type = type;
            this.score = score;
            this.scope = scope;
            this.handle = handle;
            this.originsAllowed = originsAllowed;
            this.corsEnabled = corsEnabled;
        }

        public Score(DispatchableResourceType type, int score, SecurityConfig scope, Object handle, String ... allowedOrigins) {
            this(type, score, scope, handle, Iterables.iterable((Object[])allowedOrigins), true);
        }

        public Object handle() {
            return this.handle;
        }

        public boolean isCorsEnabled() {
            boolean isPublic = RequestDispatchers.isPublicResource(this);
            boolean hasOrigins = !NullOrEmpty.nullOrEmpty(this.originsAllowed());
            return this.corsEnabled && (isPublic || hasOrigins);
        }

        public Iterable<String> originsAllowed() {
            return this.originsAllowed;
        }

        public int score() {
            return this.score;
        }

        public SecurityConfig securityRealm() {
            return this.scope;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Score [handle=");
            builder.append(this.handle);
            builder.append(", score=");
            builder.append(this.score);
            builder.append(", scope=");
            builder.append(this.scope);
            builder.append(", originsAllowed=");
            builder.append(this.originsAllowed);
            builder.append(", corsEnabled=");
            builder.append(this.corsEnabled);
            builder.append("]");
            return builder.toString();
        }

        public DispatchableResourceType type() {
            return this.type;
        }

        public static boolean isMatch(Score score) {
            return score != null && score != NO_MATCH && score.score != -1;
        }
    }
}

