/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.app.Version;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.util.Arrays;
import oracle.dbtools.common.util.Base64;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Digests;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Template;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;
import oracle.dbtools.rt.web.content.StaticContent;

public class TemplateResourceGenerator {
    private final CharSequence contentType;
    private final TemplateProvider template;
    private final String[] doNotEscape;

    private TemplateResourceGenerator(CharSequence contentType, TemplateProvider template, String ... doNotEscape) {
        this.contentType = contentType;
        this.template = template;
        this.doNotEscape = doNotEscape;
    }

    public String encode(LocalePreference localePreference, Map<String, String> values) {
        if (values == null) {
            throw new NullPointerException("values must not be null");
        }
        values = this.escape(values);
        return this.template.template(localePreference).encode(values);
    }

    public String encode(LocalePreference localePreference, String ... valuePairs) {
        if (valuePairs == null) {
            throw new NullPointerException("values must not be null");
        }
        return this.encode(localePreference, Maps.toMap((String[])valuePairs));
    }

    public HttpResource generate(LocalePreference localePreference, Map<String, String> values) {
        if (values == null) {
            throw new NullPointerException("values must not be null");
        }
        if (this.isHtml(this.contentType)) {
            values = this.escape(values);
        }
        return new TemplateResource(localePreference, values);
    }

    private Map<String, String> escape(Map<String, String> values) {
        LinkedHashMap<String, String> escaped = new LinkedHashMap<String, String>(values.size());
        for (String key : values.keySet()) {
            String escapedValue = values.get(key);
            if (!Arrays.contains((Object)key, (Object[])this.doNotEscape)) {
                escapedValue = Text.escapeHtml((CharSequence)values.get(key));
            }
            escaped.put(key, escapedValue);
        }
        return escaped;
    }

    private boolean isHtml(CharSequence contentType) {
        ContentType ct = ContentType.contentType(contentType);
        return ct.matches(ContentTypes.HTML_TYPES);
    }

    public static Map<String, String> globalProperties() {
        return TemplateResourceGenerator.globalProperties(new HashMap<String, String>());
    }

    public static Map<String, String> globalProperties(Map<String, String> properties) {
        properties.put("version", Version.INSTANCE.getVersion());
        properties.put("configFolder", ConfigurationFolder.INSTANCE.getFolder().getAbsolutePath());
        return properties;
    }

    public static TemplateResourceGenerator templateFromString(CharSequence contentType, String template, String ... doNotEscape) {
        return new TemplateResourceGenerator(contentType, new StringTemplateProvider(template), doNotEscape);
    }

    public static TemplateResourceGenerator templateFromUrl(CharSequence contentType, String templateName, String ... doNotEscape) {
        return new TemplateResourceGenerator(contentType, new StaticContentProvider(templateName), doNotEscape);
    }

    private static String version(String text) {
        try {
            return Base64.byteArrayToBase64((byte[])Digests.digest((CharSequence)text));
        }
        catch (IOException e) {
            throw UnrecoverableException.unrecoverable((Throwable)e);
        }
    }

    private class TemplateResource
    implements HttpResource {
        private final LocalePreference localePreference;
        private final Map<String, String> values;

        public TemplateResource(LocalePreference localePreference, Map<String, String> values) {
            this.localePreference = localePreference;
            this.values = values;
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            String text = TemplateResourceGenerator.this.template.template(this.localePreference).encode(this.values);
            InputStream body = StreamCopy.toInputStream((CharSequence)text);
            return Entities.entity(body, Entities.headers(HttpHeader.CONTENT_TYPE, TemplateResourceGenerator.this.contentType));
        }

        @Override
        public String version() {
            try {
                Digests.Builder digest = Digests.builder();
                digest.digest(TemplateResourceGenerator.this.contentType);
                digest.digest((CharSequence)TemplateResourceGenerator.this.template.version(this.localePreference));
                for (String value : this.values.values()) {
                    digest.digest((CharSequence)value);
                }
                return Base64.byteArrayToBase64((byte[])digest.build());
            }
            catch (Exception e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }
    }

    private static interface TemplateProvider {
        public Template template(LocalePreference var1);

        public String version(LocalePreference var1);
    }

    private static class StringTemplateProvider
    implements TemplateProvider {
        private final Template template;
        private final String version;

        StringTemplateProvider(String text) {
            this.template = new Template(text);
            this.version = TemplateResourceGenerator.version(text);
        }

        @Override
        public Template template(LocalePreference localePreference) {
            return this.template;
        }

        @Override
        public String version(LocalePreference localePreference) {
            return this.version;
        }
    }

    private static class StaticContentProvider
    implements TemplateProvider {
        private final String path;

        StaticContentProvider(String path) {
            if (path == null) {
                throw new NullPointerException();
            }
            this.path = path;
        }

        @Override
        public Template template(LocalePreference localePreference) {
            return new Template(this.text(localePreference));
        }

        @Override
        public String version(LocalePreference localePreference) {
            return TemplateResourceGenerator.version(this.text(localePreference));
        }

        private String text(LocalePreference localePreference) {
            URI uri = StaticContent.uri(localePreference, this.path);
            if (uri == null) {
                throw new IllegalStateException(this.path);
            }
            InputStream in = null;
            try {
                String text;
                in = URIs.inputStream((URI)uri);
                String string = text = StreamCopy.string((InputStream)in);
                return string;
            }
            catch (IOException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
            finally {
                Closeables.close((Object)in);
            }
        }
    }
}

