/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.example;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.json.JSONBuilder;
import oracle.dbtools.json.JSONNode;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.TenantedRequestHandler;
import oracle.dbtools.rt.web.WebException;

@Service
public class GreetingHandler
extends TenantedRequestHandler
implements ResourceDispatcher {
    private static final RequestHandlerMetaData META_DATA = GreetingHandler.metadata("_/examples/greeting?who={name}", HttpMethod.GET).build();

    public GreetingHandler() {
        super(META_DATA);
    }

    @Override
    protected Entity get(RequestEntity request) throws IOException {
        Entity entity;
        Connection conn = null;
        Connection metadata = null;
        JSONBuilder results = JSONBuilder.o();
        String name = META_DATA.uriTemplate().decode(request.path()).get("name");
        try {
            conn = this.connection(request);
            metadata = this.metadata(request);
            results.p("tenant user", (CharSequence)this.doQuery(conn, name));
            results.p("metadata user", (CharSequence)this.doQuery(metadata, name));
            String text = JSONBuilder.render((JSONNode)results.build());
            entity = Entities.entity(StreamCopy.toInputStream((CharSequence)text), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.JSON}));
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{metadata, conn});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{metadata, conn});
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doQuery(Connection conn, String name) throws SQLException {
        String string;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("select 'Hi ' || ? || ' from database user: ' || SYS_CONTEXT ('USERENV', 'CURRENT_USER') from dual");
            stmt.setString(1, name);
            rs = stmt.executeQuery();
            rs.next();
            string = rs.getString(1);
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{rs, stmt});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{rs, stmt});
        return string;
    }
}

