/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cms.CMSAuthenticatedDataInputStream;
import oracle.security.crypto.cms.CMSInputConnector;

public class CMSAuthenticatedDataInputConnector
implements CMSInputConnector {
    private CMSAuthenticatedDataInputStream authIn;

    public CMSAuthenticatedDataInputConnector(InputStream in, PrivateKey recipientPrivateKey, X509Certificate recipientCert) throws CertificateEncodingException, NoSuchAlgorithmException, IOException {
        this.authIn = new CMSAuthenticatedDataInputStream(in, recipientPrivateKey, recipientCert);
    }

    public CMSAuthenticatedDataInputConnector(InputStream in, SecretKey keyEncryptionKey) {
        this.authIn = new CMSAuthenticatedDataInputStream(in, keyEncryptionKey);
    }

    public CMSAuthenticatedDataInputConnector(CMSInputConnector conn, PrivateKey recipientPrivateKey, X509Certificate recipientCert) throws IOException, NoSuchAlgorithmException, CertificateEncodingException {
        this.authIn = new CMSAuthenticatedDataInputStream(conn, recipientPrivateKey, recipientCert);
    }

    public CMSAuthenticatedDataInputConnector(CMSInputConnector conn, SecretKey keyEncryptionKey) {
        this.authIn = new CMSAuthenticatedDataInputStream(conn, keyEncryptionKey);
    }

    @Override
    public ASN1ObjectID getEnclosedContentType() throws IOException {
        return this.authIn.getEnclosedContentType();
    }

    @Override
    public InputStream getInputStream() {
        return this.authIn;
    }
}

