/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CIInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSInputConnector;
import oracle.security.crypto.cms.CMSInputStream;
import oracle.security.crypto.cms.CMSKEKRecipientInfo;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfo;
import oracle.security.crypto.cms.CMSRecipientInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.OriginatorInfo;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSAuthenticatedDataInputStream
extends CMSInputStream {
    private final boolean readingFromConnector;
    private PrivateKey recipientPrivateKey;
    private SecretKey keyEncryptionKey;
    private IssuerAndSerialNo recipientIASN;
    private ASN1ObjectID enclosedContentType = CMS.id_data;
    private OriginatorInfo origInfo;
    private AttributeSet authenticatedAttribs;
    private AttributeSet unauthenticatedAttribs;
    private ASN1Integer version;
    private byte[] recipientSPKI64;
    private byte[] recipientSPKI160;
    private MessageDigest md;
    private ByteArrayOutputStream bos;
    private byte[] bosData;
    private AlgorithmIdentifier macAlgorithm;
    private AlgorithmIdentifier digestAlgID;
    private byte[] macCode;
    private byte[] dig;
    private boolean readInitial = false;
    private boolean terminated = false;
    private ASN1ConstructedInputStream ci_in;
    private ASN1ConstructedInputStream cic_in;
    private ASN1ConstructedInputStream ed_in;
    private CIInputStream content_in;
    private byte[] contentAuthenticationKey = null;
    private String contentAuthenticationKeyAlgo = null;

    public CMSAuthenticatedDataInputStream(InputStream in, PrivateKey recipientPrivateKey, X509Certificate recipientCert) throws CertificateEncodingException, IOException, NoSuchAlgorithmException {
        super(in);
        this.recipientPrivateKey = recipientPrivateKey;
        this.recipientIASN = new IssuerAndSerialNo(new X509(recipientCert.getEncoded()));
        this.recipientSPKI64 = CMSUtils.generateSPKI64(recipientCert);
        this.recipientSPKI160 = CMSUtils.generateSPKI160(recipientCert);
        this.readingFromConnector = false;
    }

    public CMSAuthenticatedDataInputStream(CMSInputConnector conn, PrivateKey recipientPrivateKey, X509Certificate recipientCert) throws CertificateEncodingException, NoSuchAlgorithmException, IOException {
        super(conn.getInputStream());
        this.recipientPrivateKey = recipientPrivateKey;
        this.recipientIASN = new IssuerAndSerialNo(new X509(recipientCert.getEncoded()));
        this.recipientSPKI64 = CMSUtils.generateSPKI64(recipientCert);
        this.recipientSPKI160 = CMSUtils.generateSPKI160(recipientCert);
        this.readingFromConnector = true;
    }

    public CMSAuthenticatedDataInputStream(InputStream in, SecretKey keyEncryptionKey) {
        super(in);
        this.keyEncryptionKey = keyEncryptionKey;
        this.readingFromConnector = false;
    }

    public CMSAuthenticatedDataInputStream(CMSInputConnector conn, SecretKey keyEncryptionKey) {
        super(conn.getInputStream());
        this.keyEncryptionKey = keyEncryptionKey;
        this.readingFromConnector = true;
    }

    private void ensureReadInitial() throws IOException {
        if (!this.readInitial) {
            if (!this.readingFromConnector) {
                this.ci_in = new ASN1SequenceInputStream(this.in);
                if (!CMS.id_ct_authData.equals((Object)new ASN1ObjectID((InputStream)this.ci_in))) {
                    throw new InvalidInputException("Content-type 'authenticatedData' expected.");
                }
                this.cic_in = new ASN1ConstructedInputStream((InputStream)this.ci_in, 0);
                this.ed_in = new ASN1SequenceInputStream((InputStream)this.cic_in);
            } else {
                this.ed_in = new ASN1SequenceInputStream(this.in);
            }
            this.version = new ASN1Integer((InputStream)this.ed_in);
            if (!this.version.equals(0) && !this.version.equals(2)) {
                throw new VersionException("Expected Version 0 or 2 but Got " + this.version.getValue());
            }
            if (this.ed_in.getCurrentTag() == 0) {
                this.ed_in.setCurrentTag(16);
                this.origInfo = new OriginatorInfo((InputStream)this.ed_in);
            }
            Object contentEncryptionKey = null;
            try {
                boolean foundRecipient = false;
                ASN1SetInputStream ris = new ASN1SetInputStream((InputStream)this.ed_in);
                do {
                    if (!ris.hasMoreData()) {
                        throw new InvalidInputException("Recipient not found.");
                    }
                    CMSRecipientInfo ri = CMSRecipientInfo.inputInstance((InputStream)ris);
                    if (ri instanceof CMSKeyTransRecipientInfo) {
                        CMSKeyTransRecipientInfo ktri = (CMSKeyTransRecipientInfo)ri;
                        if (ktri.getSPKI() == null) {
                            if (!ktri.getIASN().equals((Object)this.recipientIASN) || this.recipientPrivateKey == null) continue;
                            this.contentAuthenticationKey = ktri.getContentAuthenticationKey(this.recipientPrivateKey);
                            this.contentAuthenticationKeyAlgo = ktri.getKeyAlgo();
                            foundRecipient = true;
                            continue;
                        }
                        if (Utils.toHexString((byte[])ktri.getSPKI()).equals(Utils.toHexString((byte[])this.recipientSPKI64))) {
                            if (this.recipientPrivateKey == null) continue;
                            this.contentAuthenticationKey = ktri.getContentAuthenticationKey(this.recipientPrivateKey);
                            this.contentAuthenticationKeyAlgo = ktri.getKeyAlgo();
                            foundRecipient = true;
                            continue;
                        }
                        if (!Utils.toHexString((byte[])ktri.getSPKI()).equals(Utils.toHexString((byte[])this.recipientSPKI160)) || this.recipientPrivateKey == null) continue;
                        this.contentAuthenticationKey = ktri.getContentAuthenticationKey(this.recipientPrivateKey);
                        this.contentAuthenticationKeyAlgo = ktri.getKeyAlgo();
                        foundRecipient = true;
                        continue;
                    }
                    if (!(ri instanceof CMSKEKRecipientInfo)) continue;
                    CMSKEKRecipientInfo kekri = (CMSKEKRecipientInfo)ri;
                    if (this.keyEncryptionKey == null) continue;
                    this.contentAuthenticationKey = kekri.getContentAuthenticationKey(this.keyEncryptionKey);
                    this.contentAuthenticationKeyAlgo = this.keyEncryptionKey.getAlgorithm();
                    foundRecipient = true;
                } while (!foundRecipient);
                ris.terminate(true);
            }
            catch (InvalidKeyException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (NoSuchPaddingException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (IllegalBlockSizeException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (BadPaddingException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (InvalidKeySpecException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new InvalidInputException((Exception)ex);
            }
            this.macAlgorithm = new AlgorithmIdentifier((InputStream)this.ed_in);
            if (this.ed_in.getCurrentTag() == 1) {
                this.ed_in.setCurrentTag(16);
                this.digestAlgID = new AlgorithmIdentifier((InputStream)this.ed_in);
            }
            this.content_in = new CIInputStream((InputStream)this.ed_in);
            this.enclosedContentType = this.content_in.getContentType();
            if (this.digestAlgID != null) {
                try {
                    this.md = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID));
                }
                catch (NoSuchAlgorithmException ex1) {
                    throw new IOException("Message Digest Algorithm not Supported " + ex1.toString());
                }
            }
            this.bos = new ByteArrayOutputStream();
            this.readInitial = true;
        }
    }

    private void ensureTerminated() throws IOException {
        if (!this.terminated) {
            if (this.ed_in.getCurrentTag() == 2) {
                this.ed_in.setCurrentTag(17);
                this.authenticatedAttribs = new AttributeSet((InputStream)this.ed_in);
            }
            this.macCode = new ASN1OctetString((InputStream)this.ed_in).getValue();
            if (this.ed_in.hasMoreData()) {
                if (this.ed_in.getCurrentTag() == 3) {
                    this.ed_in.setCurrentTag(17);
                    this.unauthenticatedAttribs = new AttributeSet((InputStream)this.ed_in);
                } else {
                    throw new InvalidInputException("Expected Unauthenticated Attributes");
                }
            }
            this.ed_in.terminate();
            if (!this.readingFromConnector) {
                this.cic_in.terminate();
                this.ci_in.terminate();
            }
            if (this.md != null) {
                this.dig = this.md.digest();
            }
            this.bosData = this.bos.toByteArray();
            this.bos.close();
            if (!this.enclosedContentType.equals((Object)CMS.id_data) && this.authenticatedAttribs == null) {
                throw new IOException("AuthenticatedAttributes MUST be present if the  Encapsulated Content-Type is not CMS.id_data ");
            }
            if (this.digestAlgID == null && this.authenticatedAttribs != null || this.digestAlgID != null && this.authenticatedAttribs == null) {
                throw new InvalidInputException("Digest Algorithm and AuthenticatedAttributes  MUST Both be present or Not at all");
            }
            this.terminated = true;
        }
    }

    @Override
    public ASN1ObjectID getEnclosedContentType() throws IOException {
        this.ensureReadInitial();
        return this.enclosedContentType;
    }

    public void verifyMAC() throws AuthenticationException {
        if (!this.readInitial) {
            throw new AuthenticationException("No input read");
        }
        try {
            this.ensureTerminated();
        }
        catch (IOException ex) {
            throw new AuthenticationException("Not at end of stream");
        }
        byte[] digest = this.bosData;
        if (this.md != null) {
            byte[] digest0;
            ASN1ObjectID announcedContentType;
            digest = this.dig;
            try {
                Vector vals = this.authenticatedAttribs.getAttributeValues(CMS.id_contentType);
                if (vals == null) {
                    throw new AuthenticationException("The 'contentType' attribute is missing");
                }
                if (vals.size() != 1) {
                    throw new AuthenticationException("The 'contentType' attribute is not single valued");
                }
                announcedContentType = (ASN1ObjectID)vals.elementAt(0);
            }
            catch (ClassCastException ex) {
                throw new AuthenticationException("The value of the 'contentType' attribute has the wrong type");
            }
            if (!announcedContentType.equals((Object)this.enclosedContentType)) {
                throw new AuthenticationException("The value of the 'contentType' attribute is incorrect");
            }
            try {
                Vector vals = this.authenticatedAttribs.getAttributeValues(CMS.id_messageDigest);
                if (vals == null) {
                    throw new AuthenticationException("The 'messageDigest' attribute is missing");
                }
                if (vals.size() != 1) {
                    throw new AuthenticationException("The 'messageDigest' attribute is not single valued");
                }
                digest0 = ((ASN1OctetString)vals.elementAt(0)).getValue();
            }
            catch (ClassCastException ex) {
                throw new AuthenticationException("The value of the 'messageDigest' attribute has the wrong type");
            }
            if (!Utils.areEqual((byte[])digest, (byte[])digest0)) {
                throw new AuthenticationException("The value of the 'messageDigest' attribute is incorrect");
            }
            try {
                MessageDigest md0 = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID));
                digest = md0.digest(Utils.toBytes((Streamable)this.authenticatedAttribs));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new AuthenticationException(ex.toString());
            }
        }
        try {
            byte[] hmacCode;
            AlgorithmIdentifier hmacDigest = null;
            if (this.macAlgorithm.equals((Object)CMS.hmac_SHA_1)) {
                hmacDigest = AlgID.sha_1;
            } else {
                new AuthenticationException("unsupported HMAC Algorithm: " + this.macAlgorithm);
            }
            String algoName = CMSUtils.getAlgoName(hmacDigest);
            this.contentAuthenticationKeyAlgo = CMSUtils.getAlgoName(this.macAlgorithm);
            Mac mac = Mac.getInstance("Hmac" + algoName);
            SecretKeySpec secretKey = new SecretKeySpec(this.contentAuthenticationKey, this.contentAuthenticationKeyAlgo);
            mac.init(secretKey);
            if (digest == null) {
                digest = new byte[]{};
            }
            if (!Utils.areEqual((byte[])this.macCode, (byte[])(hmacCode = mac.doFinal(digest)))) {
                throw new AuthenticationException(" MAC is invalid");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureReadInitial();
        int ch = this.content_in.read();
        if (ch == -1) {
            this.ensureTerminated();
        } else {
            if (this.md != null) {
                this.md.update((byte)ch);
            }
            this.bos.write((byte)ch);
        }
        return ch;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        this.ensureReadInitial();
        int efflen = this.content_in.read(buffer, offset, len);
        if (efflen == -1) {
            this.ensureTerminated();
        } else {
            if (this.md != null) {
                this.md.update(buffer, offset, efflen);
            }
            this.bos.write(buffer, offset, efflen);
        }
        return efflen;
    }

    @Override
    public int available() throws IOException {
        this.ensureReadInitial();
        return this.content_in.available();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Skip not implemented.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void terminate() throws IOException {
        if (!this.terminated) {
            this.content_in.ensureTerminated();
            this.ensureTerminated();
        }
    }

    public OriginatorInfo getOriginatorInfo() throws IOException {
        this.ensureReadInitial();
        return this.origInfo;
    }

    public AttributeSet getAuthenticatedAttributes() throws IOException {
        this.terminate();
        return this.authenticatedAttribs;
    }

    public AttributeSet getUnauthenticatedAttributes() throws IOException {
        this.terminate();
        return this.unauthenticatedAttribs;
    }

    public BigInteger getVersionNumber() throws IOException {
        this.ensureReadInitial();
        return this.version.getValue();
    }

    public ASN1Integer getVersion() throws IOException {
        this.ensureReadInitial();
        return this.version;
    }

    public AlgorithmIdentifier getMACAlgID() throws IOException {
        this.ensureReadInitial();
        return this.macAlgorithm;
    }

    public AlgorithmIdentifier getDigestAlgID() throws IOException {
        this.ensureReadInitial();
        return this.digestAlgID;
    }

    public byte[] getMAC() throws IOException {
        this.terminate();
        return this.macCode;
    }
}

