/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cms.CIOutputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSKEKRecipientInfo;
import oracle.security.crypto.cms.CMSKEKRecipientInfoSpec;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfo;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfoSpec;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.cms.CMSOutputStream;
import oracle.security.crypto.cms.CMSRecipientInfo;
import oracle.security.crypto.cms.CMSRecipientInfoSpec;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.OriginatorInfo;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CMSAuthenticatedDataOutputStream
extends CMSOutputStream {
    private OriginatorInfo origInfo;
    private Vector recipients;
    private AlgorithmIdentifier macAlgorithm;
    private AlgorithmIdentifier digestAlgID;
    private AlgorithmIdentifier hmacKeyAlgID;
    private ASN1ObjectID encapContentType;
    private AttributeSet authenticatedAttribs;
    private AttributeSet unauthenticatedAttribs;
    private byte[] mac;
    private SecretKey contentAuthenticationKey;
    private boolean writingToConnector;
    private MessageDigest md;
    private boolean detachEncapContent = false;
    private boolean terminated = false;
    private CIOutputStream content_out;
    private ByteArrayOutputStream bos;
    private byte[] dig = null;
    private boolean prefaceOutput = false;

    public CMSAuthenticatedDataOutputStream(OutputStream out, Vector recipients, AlgorithmIdentifier macAlgorithm, ASN1ObjectID encapContentType, SecretKey hmacKey, boolean detachEncapContent) throws InvalidInputException, NoSuchAlgorithmException {
        this(out, null, recipients, macAlgorithm, null, encapContentType, null, null, hmacKey, detachEncapContent);
    }

    public CMSAuthenticatedDataOutputStream(OutputStream out, Vector recipients, AlgorithmIdentifier macAlgorithm, ASN1ObjectID encapContentType, SecretKey hmacKey, AlgorithmIdentifier hmacKeyAlgID, boolean detachEncapContent) throws InvalidInputException, NoSuchAlgorithmException {
        this(out, null, recipients, macAlgorithm, null, encapContentType, null, null, hmacKey, hmacKeyAlgID, detachEncapContent);
    }

    public CMSAuthenticatedDataOutputStream(OutputStream out, OriginatorInfo origInfo, Vector recipients, AlgorithmIdentifier macAlgorithm, AlgorithmIdentifier digestAlgID, ASN1ObjectID encapContentType, AttributeSet authenticatedAttribs, AttributeSet unauthenticatedAttribs, SecretKey hmacKey, boolean detachEncapContent) throws InvalidInputException, NoSuchAlgorithmException {
        this(out, origInfo, recipients, macAlgorithm, digestAlgID, encapContentType, authenticatedAttribs, unauthenticatedAttribs, hmacKey, CMSUtils.getAlgoID(hmacKey.getAlgorithm()), detachEncapContent);
    }

    public CMSAuthenticatedDataOutputStream(OutputStream out, OriginatorInfo origInfo, Vector recipients, AlgorithmIdentifier macAlgorithm, AlgorithmIdentifier digestAlgID, ASN1ObjectID encapContentType, AttributeSet authenticatedAttribs, AttributeSet unauthenticatedAttribs, SecretKey hmacKey, AlgorithmIdentifier hmacKeyAlgID, boolean detachEncapContent) throws InvalidInputException, NoSuchAlgorithmException {
        super(out);
        this.origInfo = origInfo;
        this.recipients = recipients;
        this.macAlgorithm = macAlgorithm;
        this.digestAlgID = digestAlgID;
        this.encapContentType = encapContentType;
        this.authenticatedAttribs = authenticatedAttribs;
        this.unauthenticatedAttribs = unauthenticatedAttribs;
        this.detachEncapContent = detachEncapContent;
        this.writingToConnector = false;
        this.hmacKeyAlgID = hmacKeyAlgID;
        if (hmacKeyAlgID.equals((Object)CMS.des_ede3_cbc)) {
            CMSUtils.setKeyParity(hmacKey, 1);
        }
        this.contentAuthenticationKey = hmacKey;
        this.initialize();
        this.bos = new ByteArrayOutputStream();
    }

    public CMSAuthenticatedDataOutputStream(CMSOutputConnector conn, Vector recipients, AlgorithmIdentifier macAlgorithm, ASN1ObjectID encapContentType, SecretKey hmacKey, boolean detachEncapContent) throws InvalidInputException, NoSuchAlgorithmException {
        this(conn, null, recipients, macAlgorithm, null, encapContentType, null, null, hmacKey, detachEncapContent);
    }

    public CMSAuthenticatedDataOutputStream(CMSOutputConnector conn, OriginatorInfo origInfo, Vector recipients, AlgorithmIdentifier macAlgorithm, AlgorithmIdentifier digestAlgID, ASN1ObjectID encapContentType, AttributeSet authenticatedAttribs, AttributeSet unauthenticatedAttribs, SecretKey hmacKey, boolean detachEncapContent) throws InvalidInputException, NoSuchAlgorithmException {
        this(conn, origInfo, recipients, macAlgorithm, digestAlgID, encapContentType, authenticatedAttribs, unauthenticatedAttribs, hmacKey, CMSUtils.getAlgoID(hmacKey.getAlgorithm()), detachEncapContent);
    }

    public CMSAuthenticatedDataOutputStream(CMSOutputConnector conn, OriginatorInfo origInfo, Vector recipients, AlgorithmIdentifier macAlgorithm, AlgorithmIdentifier digestAlgID, ASN1ObjectID encapContentType, AttributeSet authenticatedAttribs, AttributeSet unauthenticatedAttribs, SecretKey hmacKey, AlgorithmIdentifier hmacKeyAlgID, boolean detachEncapContent) throws InvalidInputException, NoSuchAlgorithmException {
        super(conn.getOutputStream());
        this.origInfo = origInfo;
        this.recipients = recipients;
        this.macAlgorithm = macAlgorithm;
        this.digestAlgID = digestAlgID;
        this.encapContentType = encapContentType;
        this.authenticatedAttribs = authenticatedAttribs;
        this.unauthenticatedAttribs = unauthenticatedAttribs;
        this.detachEncapContent = detachEncapContent;
        this.writingToConnector = true;
        this.hmacKeyAlgID = hmacKeyAlgID;
        if (hmacKeyAlgID.equals((Object)CMS.des_ede3_cbc)) {
            CMSUtils.setKeyParity(hmacKey, 1);
        }
        this.contentAuthenticationKey = hmacKey;
        this.initialize();
        this.bos = new ByteArrayOutputStream();
    }

    private void initialize() throws InvalidInputException, NoSuchAlgorithmException {
        if (!this.encapContentType.equals((Object)CMS.id_data) && this.authenticatedAttribs == null) {
            throw new InvalidInputException("Authenticated Attributes MUST be present when the Content-Type is not " + CMS.id_data);
        }
        if (!(this.digestAlgID == null && this.authenticatedAttribs == null || this.digestAlgID != null && this.authenticatedAttribs != null)) {
            throw new InvalidInputException("Digest Algorithm and AuthenticatedAttributes  MUST Both be present or Not at all");
        }
        this.md = this.digestAlgID != null ? MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID)) : null;
    }

    private void ensurePrefaceOutput() throws IOException {
        if (!this.prefaceOutput) {
            if (!this.writingToConnector) {
                ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
                CMS.id_ct_authData.output(this.out);
                ASN1Utils.outputHeader((OutputStream)this.out, (int)0, (int)128);
            }
            ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
            ASN1Integer.outputValue((OutputStream)this.out, (int)0);
            if (this.origInfo != null) {
                ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.origInfo, (int)0)).output(this.out);
            }
            ASN1Utils.outputHeader((OutputStream)this.out, (int)17, (int)0);
            try {
                Enumeration e = this.recipients.elements();
                while (e != null && e.hasMoreElements()) {
                    CMSRecipientInfo ri;
                    CMSRecipientInfoSpec rispec;
                    CMSRecipientInfoSpec spec = (CMSRecipientInfoSpec)e.nextElement();
                    if (spec instanceof CMSKeyTransRecipientInfoSpec) {
                        rispec = (CMSKeyTransRecipientInfoSpec)spec;
                        if (((CMSKeyTransRecipientInfoSpec)rispec).getSPKI() == null) {
                            ri = new CMSKeyTransRecipientInfo(this.contentAuthenticationKey, ((CMSKeyTransRecipientInfoSpec)rispec).getRecipientKey(), ((CMSKeyTransRecipientInfoSpec)rispec).getIASN(), ((CMSKeyTransRecipientInfoSpec)rispec).getKeyEncryptionAlgID());
                            ((CMSKeyTransRecipientInfo)ri).output(this.out);
                            continue;
                        }
                        ri = new CMSKeyTransRecipientInfo(this.contentAuthenticationKey, ((CMSKeyTransRecipientInfoSpec)rispec).getRecipientKey(), ((CMSKeyTransRecipientInfoSpec)rispec).getSPKI(), ((CMSKeyTransRecipientInfoSpec)rispec).getKeyEncryptionAlgID());
                        ((CMSKeyTransRecipientInfo)ri).output(this.out);
                        continue;
                    }
                    if (spec instanceof CMSKEKRecipientInfoSpec) {
                        rispec = (CMSKEKRecipientInfoSpec)spec;
                        ri = new CMSKEKRecipientInfo(this.contentAuthenticationKey, (CMSKEKRecipientInfoSpec)rispec);
                        ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)ri, (int)2)).output(this.out);
                        continue;
                    }
                    throw new IOException("unknown CMSRecipientInfo ");
                }
            }
            catch (InvalidKeySpecException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (NoSuchPaddingException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (IllegalBlockSizeException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (BadPaddingException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (InvalidKeyException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
            this.macAlgorithm.output(this.out);
            if (this.digestAlgID != null) {
                ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.digestAlgID, (int)1)).output(this.out);
            }
            this.content_out = new CIOutputStream(this.out, this.encapContentType, this.detachEncapContent);
            this.content_out.writeInitial();
            this.prefaceOutput = true;
        }
    }

    private void writeSDBodyFinal() throws IOException {
        byte[] digest;
        AttributeSet aA = this.authenticatedAttribs;
        if (this.md != null) {
            if (aA == null) {
                digest = this.dig;
            } else {
                aA = (AttributeSet)aA.clone();
                aA.addAttribute(CMS.id_contentType, (ASN1Object)this.encapContentType);
                aA.addAttribute(CMS.id_messageDigest, (ASN1Object)new ASN1OctetString(this.dig));
                try {
                    digest = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID)).digest(Utils.toBytes((Streamable)aA));
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new IOException(ex.toString());
                }
                ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)aA, (int)2)).output(this.out);
            }
        } else {
            digest = this.bos.toByteArray();
            this.bos.close();
        }
        try {
            AlgorithmIdentifier hmacDigest = null;
            if (this.macAlgorithm.equals((Object)CMS.hmac_SHA_1)) {
                hmacDigest = AlgID.sha_1;
            } else {
                new IOException("unsupported HMAC Algorithm");
            }
            Mac hmac = Mac.getInstance("Hmac" + CMSUtils.getAlgoName(hmacDigest));
            hmac.init(this.contentAuthenticationKey);
            this.mac = hmac.doFinal(digest);
            new ASN1OctetString(this.mac).output(this.out);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new IOException(ex.toString());
        }
        if (this.unauthenticatedAttribs != null) {
            ASN1Utils.addImplicitTag((ASN1Object)this.unauthenticatedAttribs, (int)3).output(this.out);
        }
    }

    @Override
    public void terminate() throws IOException {
        if (!this.terminated) {
            if (this.md != null) {
                this.dig = this.md.digest();
            }
            this.ensurePrefaceOutput();
            this.content_out.writeFinal();
            this.writeSDBodyFinal();
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
            if (!this.writingToConnector) {
                ASN1Utils.outputEndOfContents((OutputStream)this.out);
                ASN1Utils.outputEndOfContents((OutputStream)this.out);
            } else {
                ((CMSOutputStream)this.out).terminate();
            }
            this.terminated = true;
        }
    }

    @Override
    public void write(int ch) throws IOException {
        if (this.md != null) {
            this.md.update((byte)ch);
        } else {
            this.bos.write((byte)ch);
        }
        this.ensurePrefaceOutput();
        this.content_out.write(ch);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.md != null) {
            this.md.update(b, off, len);
        } else {
            this.bos.write(b, off, len);
        }
        this.ensurePrefaceOutput();
        this.content_out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.terminated) {
            this.terminate();
        }
        super.close();
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_ct_authData;
    }
}

