/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSAuthenticatedDataContentInfo;
import oracle.security.crypto.cms.CMSCompressedDataContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.cms.CMSDigestedDataContentInfo;
import oracle.security.crypto.cms.CMSEncryptedDataContentInfo;
import oracle.security.crypto.cms.CMSEnvelopedDataContentInfo;
import oracle.security.crypto.cms.CMSSignedDataContentInfo;
import oracle.security.crypto.cms.ESSReceipt;
import oracle.security.crypto.cms.TSTInfo;
import oracle.security.crypto.util.InvalidInputException;

public abstract class CMSContentInfo
implements ASN1Object {
    private ASN1ObjectID contentType;
    private ASN1Header header;
    private ASN1Header contentExplTagHeader;
    private ASN1Header contentOSHeader;

    protected CMSContentInfo(ASN1ObjectID contentType) {
        this.contentType = contentType;
    }

    public static CMSContentInfo inputInstance(InputStream is) throws IOException {
        ASN1SequenceInputStream ci = new ASN1SequenceInputStream(is);
        ASN1ObjectID contentType = new ASN1ObjectID((InputStream)ci);
        CMSContentInfo contentInfo = CMSContentInfo.makeDegenerate(contentType);
        if (contentInfo == null) {
            throw new InvalidInputException("Unknown/Unsupported content type.");
        }
        if (ci.hasMoreData()) {
            ASN1ConstructedInputStream cic = new ASN1ConstructedInputStream((InputStream)ci, 0);
            contentInfo.inputContent((InputStream)cic);
            cic.terminate();
        }
        ci.terminate();
        return contentInfo;
    }

    static CMSContentInfo makeDegenerate(ASN1ObjectID contentType) {
        if (contentType.equals((Object)CMS.id_data)) {
            return new CMSDataContentInfo();
        }
        if (contentType.equals((Object)CMS.id_digestedData)) {
            return new CMSDigestedDataContentInfo();
        }
        if (contentType.equals((Object)CMS.id_signedData)) {
            return new CMSSignedDataContentInfo();
        }
        if (contentType.equals((Object)CMS.id_encryptedData)) {
            return new CMSEncryptedDataContentInfo();
        }
        if (contentType.equals((Object)CMS.id_envelopedData)) {
            return new CMSEnvelopedDataContentInfo();
        }
        if (contentType.equals((Object)CMS.id_ct_authData)) {
            return new CMSAuthenticatedDataContentInfo();
        }
        if (contentType.equals((Object)CMS.id_ct_receipt)) {
            return new ESSReceipt();
        }
        if (contentType.equals((Object)CMS.id_ct_TSTInfo)) {
            return new TSTInfo();
        }
        if (contentType.equals((Object)CMS.id_ct_compressedData)) {
            return new CMSCompressedDataContentInfo();
        }
        if (contentType.equals((Object)CMS.id_cct_pkiData)) {
            try {
                Class<?> c = Class.forName("oracle.security.crypto.cmc.PKIData");
                if (c == null) {
                    throw new IllegalStateException("CMC library must be installed");
                }
                return (CMSContentInfo)c.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException("CMC library must be installed");
            }
        }
        if (contentType.equals((Object)CMS.id_cct_pkiResponse)) {
            try {
                Class<?> c = Class.forName("oracle.security.crypto.cmc.ResponseBody");
                if (c == null) {
                    throw new IllegalStateException("CMC library must be installed");
                }
                return (CMSContentInfo)c.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException("CMC library must be installed");
            }
        }
        return null;
    }

    public ASN1ObjectID getContentType() {
        return this.contentType;
    }

    protected abstract byte[] getExposedContent();

    public static String contentTypeName(ASN1ObjectID contentType) {
        if (contentType.equals((Object)CMS.id_data)) {
            return "data(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_digestedData)) {
            return "digested-data(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_signedData)) {
            return "signed-data(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_encryptedData)) {
            return "encrypted-data(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_envelopedData)) {
            return "enveloped-data(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_ct_authData)) {
            return "authenticated-data(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_ct_receipt)) {
            return "ess-receipt(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_ct_TSTInfo)) {
            return "tst-info(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_ct_compressedData)) {
            return "compressed-data(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_cct_pkiData)) {
            return "pki-data(" + contentType.toString() + ")";
        }
        if (contentType.equals((Object)CMS.id_cct_pkiResponse)) {
            return "pki-response(" + contentType.toString() + ")";
        }
        return contentType.toString();
    }

    public boolean isDegenerate() {
        return false;
    }

    public abstract boolean isDetached();

    protected abstract void setExposedContent(byte[] var1);

    public byte[] computeDigest(MessageDigest md) {
        byte[] info = this.getExposedContent();
        if (info == null) {
            return md.digest(new byte[0]);
        }
        return md.digest(info);
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream ci = new ASN1SequenceInputStream(is);
        ASN1ObjectID thisContentType = new ASN1ObjectID((InputStream)ci);
        if (!thisContentType.equals((Object)this.contentType)) {
            throw new ASN1FormatException("Content type '" + CMSContentInfo.contentTypeName(this.contentType) + "' expected.");
        }
        if (ci.hasMoreData()) {
            ASN1ConstructedInputStream cic = new ASN1ConstructedInputStream((InputStream)ci, 0);
            this.inputContent((InputStream)cic);
            cic.terminate();
        }
        ci.terminate();
        this.update();
    }

    protected abstract void inputContent(InputStream var1) throws IOException;

    public void output(OutputStream os) throws IOException {
        if (this.getExposedContent() == null) {
            throw new IOException("Content is NULL; CMS Object has not been properly initialized");
        }
        this.prepareHeaders();
        this.header.output(os);
        this.contentType.output(os);
        this.contentExplTagHeader.output(os);
        if (this.contentType.equals((Object)CMS.id_data)) {
            this.contentOSHeader.output(os);
        }
        os.write(this.getExposedContent());
    }

    public int length() {
        this.prepareHeaders();
        return this.header.totalLength();
    }

    protected void update() {
        this.header = null;
    }

    private void prepareHeaders() {
        if (this.header == null) {
            if (this.getExposedContent() != null) {
                int len = this.getExposedContent().length;
                if (this.contentType.equals((Object)CMS.id_data)) {
                    this.contentOSHeader = ASN1OctetString.makeHeader((int)len);
                    len = this.contentOSHeader.totalLength();
                }
                this.contentExplTagHeader = new ASN1Header(0, 128, 1, len);
                this.header = ASN1Sequence.makeHeader((int)(this.contentType.length() + this.contentExplTagHeader.totalLength()));
            } else {
                this.header = ASN1Sequence.makeHeader((int)this.contentType.length());
            }
        }
    }
}

