/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cms.CMSKEKRecipientInfo;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfo;

public abstract class CMSRecipientInfo
implements ASN1Object {
    public CMSRecipientInfo() {
    }

    public CMSRecipientInfo(InputStream is) throws IOException {
        this.input(is);
    }

    public void input(InputStream is) throws IOException {
        PushbackInputStream body_pbin = new PushbackInputStream(is);
        int ch = body_pbin.read();
        if (ch == -1) {
            throw new IOException("Unexpected end of stream");
        }
        if (ch != 48 && ch != 162) {
            throw new IOException("Unknown RecipientInfo type.");
        }
        body_pbin.unread(48);
        this.inputRecipientInfo(body_pbin);
    }

    public static CMSRecipientInfo inputInstance(InputStream is) throws IOException {
        PushbackInputStream body_pbin = new PushbackInputStream(is);
        int ch = body_pbin.read();
        if (ch == -1) {
            throw new IOException("Unexpected end of stream");
        }
        CMSRecipientInfo recipientInfo = null;
        if (ch == 48) {
            recipientInfo = new CMSKeyTransRecipientInfo();
        } else {
            if (ch == 161) {
                throw new IOException("KeyAgreeRecipientInfo type is not supported.");
            }
            if (ch == 162) {
                recipientInfo = new CMSKEKRecipientInfo();
            } else {
                if (ch == 163) {
                    throw new IOException("PasswordRecipientInfo type is not supported.");
                }
                throw new IOException("Unknown RecipientInfo type.");
            }
        }
        body_pbin.unread(48);
        ((CMSRecipientInfo)recipientInfo).inputRecipientInfo(body_pbin);
        return recipientInfo;
    }

    protected abstract void inputRecipientInfo(InputStream var1) throws IOException;

    public abstract ASN1Integer getVersion();
}

