/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class ESSReceipt
extends CMSContentInfo {
    private ASN1Integer version;
    private ASN1ObjectID receiptContentType;
    private byte[] signedContentIdentifier;
    private byte[] originatorSignatureValue;
    private byte[] exposedContent = null;

    public ESSReceipt() {
        super(CMS.id_ct_receipt);
    }

    public ESSReceipt(ASN1ObjectID contentType, byte[] signedContentIdentifier, byte[] originatorSignatureValue) {
        super(CMS.id_ct_receipt);
        this.version = new ASN1Integer(1L);
        this.receiptContentType = contentType;
        this.signedContentIdentifier = signedContentIdentifier;
        this.originatorSignatureValue = originatorSignatureValue;
    }

    public ESSReceipt(InputStream is) throws IOException {
        super(CMS.id_ct_receipt);
        this.input(is);
    }

    @Override
    protected void setExposedContent(byte[] expContent) {
        this.exposedContent = expContent;
    }

    @Override
    protected byte[] getExposedContent() {
        if (this.exposedContent == null) {
            try {
                UnsyncByteArrayOutputStream ddStore = new UnsyncByteArrayOutputStream();
                this.version.output((OutputStream)ddStore);
                this.receiptContentType.output((OutputStream)ddStore);
                ASN1OctetString.outputValue((OutputStream)ddStore, (byte[])this.signedContentIdentifier);
                ASN1OctetString.outputValue((OutputStream)ddStore, (byte[])this.originatorSignatureValue);
                byte[] buf = ddStore.toByteArray();
                byte[] hdrbuf = Utils.toBytes((Streamable)ASN1Sequence.makeHeader((int)buf.length));
                FixedByteArrayOutputStream bos = new FixedByteArrayOutputStream(hdrbuf.length + buf.length);
                bos.write(hdrbuf, 0, hdrbuf.length);
                bos.write(buf, 0, buf.length);
                this.exposedContent = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (NullPointerException ex) {
                throw new StreamableOutputException("CMS Object is Uninitialized " + ex.toString());
            }
        }
        return this.exposedContent;
    }

    @Override
    public boolean isDetached() {
        return this.version == null && this.receiptContentType == null && this.signedContentIdentifier == null && this.originatorSignatureValue == null;
    }

    public ASN1ObjectID getReceiptContentType() {
        return this.receiptContentType;
    }

    public byte[] getSignedContentIdentifier() {
        return this.signedContentIdentifier;
    }

    public byte[] getOriginatorSignatureValue() {
        return this.originatorSignatureValue;
    }

    public byte[] getReceiptData() throws IOException {
        return this.getExposedContent();
    }

    public String toString() {
        if (this.isDetached()) {
            return "Uninitialized ESSReceipt Object";
        }
        StringBuffer sb = new StringBuffer("'Receipt' object");
        sb.append("\nVersion: " + this.version.toString());
        sb.append("\nContent-Type: " + this.receiptContentType.toString());
        sb.append("\nContent-Identifier: " + Utils.toHexString((byte[])this.signedContentIdentifier));
        sb.append("\nOriginatorSignatureValue : " + Utils.toHexString((byte[])this.originatorSignatureValue));
        return sb.toString();
    }

    @Override
    public void inputContent(InputStream is) throws IOException {
        ASN1SequenceInputStream si = new ASN1SequenceInputStream(is);
        try {
            this.version = new ASN1Integer((InputStream)si);
            if (!this.version.equals(1)) {
                throw new VersionException(this.version.getValue(), 1);
            }
            this.receiptContentType = new ASN1ObjectID((InputStream)si);
            this.signedContentIdentifier = new ASN1OctetString((InputStream)si).getValue();
            this.originatorSignatureValue = new ASN1OctetString((InputStream)si).getValue();
            si.terminate();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex.toString());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    @Override
    protected void update() {
        super.update();
        this.exposedContent = null;
    }
}

