/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.dbtools.raptor.filenav.DirectoryFolder;
import oracle.dbtools.raptor.filenav.Messages;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.DeleteElementActionHandler;
import oracle.ide.refactoring.SimpleDeleteActionHandler;

public class DirectoryDeleteHandler
extends DeleteElementActionHandler<DirectoryFolder> {
    public DirectoryDeleteHandler(Context context) {
        super(context);
    }

    public boolean delete(DirectoryFolder directoryFolder) {
        URL uRL = directoryFolder.getURL();
        try {
            URLFileSystem.deleteEx((URL)uRL);
            return true;
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Throwable)iOException);
            return false;
        }
    }

    protected Component createDeleteDetailsComponent() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        Element[] elementArray = this.getContext().getSelection();
        for (Element element : elementArray) {
            if (!(element instanceof DirectoryFolder)) continue;
            defaultMutableTreeNode.insert(DirectoryDeleteHandler.createNode((DirectoryFolder)element), defaultMutableTreeNode.getChildCount());
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.setRootVisible(false);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        return jScrollPane;
    }

    protected SimpleDeleteActionHandler.DialogTextConfig createDialogTextConfig() {
        SimpleDeleteActionHandler.DialogTextConfig dialogTextConfig = new SimpleDeleteActionHandler.DialogTextConfig();
        dialogTextConfig.title(Messages.getString("FileNav.deleteDir"));
        dialogTextConfig.header(Messages.getString("FileNav.deletePrompt"));
        dialogTextConfig.description(Messages.getString("FileNav.deleteInclude"));
        dialogTextConfig.confirmTitle(Messages.getString("FileNav.deleteConfirm"));
        dialogTextConfig.confirmMessage(Messages.getString("FileNav.deleteConfirmUndo"));
        dialogTextConfig.showDetails(Messages.getString("FileNav.deleteShow"));
        dialogTextConfig.hideDetails(Messages.getString("FileNav.deleteHide"));
        dialogTextConfig.helpTopicId("f1_delete_confirmation_html");
        return dialogTextConfig;
    }

    private static MutableTreeNode createNode(DirectoryFolder directoryFolder) {
        return new DefaultMutableTreeNode((Object)directoryFolder);
    }
}

