/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.filenav.DirectoryRoot;
import oracle.dbtools.raptor.filenav.FileElementFactory;
import oracle.dbtools.raptor.filenav.FileNavigatorAddin;
import oracle.dbtools.raptor.filenav.FileNavigatorResources;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.ContentSet;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilters;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;

final class NavRoot
extends DefaultElement
implements Folder,
Observer {
    private static final NodeListener NL = new NodeListener(){

        public void nodeDirtyStateChanged(final NodeEvent nodeEvent, boolean bl) {
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Node node = nodeEvent.getNode();
                        try {
                            node.save();
                        }
                        catch (IOException iOException) {
                            FileNavigatorAddin.LOGGER.severe(iOException.getLocalizedMessage());
                        }
                    }
                });
            }
        }
    };
    private static NavRoot s_instance;
    private Workspace m_wks;
    private Project m_proj;
    private List<Element> m_children;

    static synchronized NavRoot getInstance() {
        if (s_instance == null) {
            s_instance = new NavRoot();
        }
        return s_instance;
    }

    private NavRoot() {
    }

    public boolean add(Element element) {
        return false;
    }

    public boolean canAdd(Element element) {
        return false;
    }

    public boolean canRemove(Element element) {
        return false;
    }

    public boolean containsChild(Element element) {
        return false;
    }

    public boolean remove(Element element) {
        return false;
    }

    public void removeAll() {
    }

    public int size() {
        return this.getChildList().size();
    }

    public Iterator getChildren() {
        return this.getChildList().iterator();
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public Icon getIcon() {
        return RaptorImagesArb.getIcon((String)"FILES");
    }

    public String getLongLabel() {
        return super.getLongLabel();
    }

    public String getShortLabel() {
        return FileNavigatorResources.getString("ROOT_NAME");
    }

    public String getToolTipText() {
        return super.getToolTipText();
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public Workspace getWorkspace() {
        if (this.m_wks == null) {
            URL uRL = ExtensionRegistry.getExtensionRegistry().getSystemDirectory(Product.getProductID());
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)"Files.jws");
            try {
                this.m_wks = (Workspace)NodeFactory.findOrCreate(Workspace.class, (URL)uRL2);
                this.m_wks.removeAll();
                this.m_wks.save();
                this.m_wks.addNodeListener(NL);
                Ide.getWorkspaces().add((Element)this.m_wks);
            }
            catch (IllegalAccessException illegalAccessException) {
                FileNavigatorAddin.LOGGER.log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                FileNavigatorAddin.LOGGER.log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
            catch (IOException iOException) {
                FileNavigatorAddin.LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return this.m_wks;
    }

    public Project getProject() {
        if (this.m_proj == null) {
            Workspace workspace = this.getWorkspace();
            URL uRL = URLFactory.newURL((URL)URLFileSystem.getParent((URL)workspace.getURL()), (String)"Files.jpr");
            try {
                this.m_proj = (Project)NodeFactory.findOrCreate(Project.class, (URL)uRL);
                if (URLFileSystem.exists((URL)uRL)) {
                    // empty if block
                }
                this.m_proj.open();
                this.m_proj.markDirty(true);
                this.m_proj.save();
                this.m_proj.addNodeListener(NL);
                this.m_proj.attach((Observer)this);
            }
            catch (IOException iOException) {
                FileNavigatorAddin.LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FileNavigatorAddin.LOGGER.log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                FileNavigatorAddin.LOGGER.log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
        }
        return this.m_proj;
    }

    ContentSet getFilesContent() {
        ApplicationContent applicationContent = ApplicationContent.getInstance((PropertyStorage)this.getWorkspace());
        ContentSet contentSet = applicationContent.getContentSet("RaptorFiles");
        NavRoot.initFilesContentSet(contentSet);
        return contentSet;
    }

    private static void initFilesContentSet(ContentSet contentSet) {
        if (contentSet != null) {
            PatternFilters patternFilters;
            URLPath uRLPath = contentSet.getURLPath();
            for (URL uRL : patternFilters = URLFileSystem.listRoots()) {
                uRLPath.add(uRL);
            }
            PatternFilters patternFilters2 = contentSet.getPatternFilters();
            patternFilters2.addInclude("**");
        }
    }

    private List<Element> getChildList() {
        if (this.m_children == null) {
            this.m_children = new ArrayList<Element>();
            ApplicationContent applicationContent = ApplicationContent.getInstance((PropertyStorage)this.getWorkspace());
            ContentSet contentSet = applicationContent.getContentSet("RaptorFiles");
            if (contentSet != null) {
                FileElementFactory fileElementFactory = FileElementFactory.getInstance();
                for (URL uRL : contentSet.getURLPath()) {
                    DirectoryRoot directoryRoot = fileElementFactory.findOrCreateRoot(uRL, URLFileSystem.getSystemDisplayName((URL)uRL));
                    this.m_children.add((Element)directoryRoot);
                }
            }
        }
        return this.m_children;
    }
}

