/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.javapckg;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.folder.FolderUtils;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;

public class PackageSourceModel
extends SourceModel {
    private URL pcURLForPackage;

    public PackageSourceModel() {
        this.setAllowUrlsNotInSourcePath(true);
    }

    @Override
    public String getExtension() {
        return null;
    }

    @Override
    public final URL getURL() {
        URL dirURL;
        if (this._url == null && (dirURL = this.getDirectory()) != null) {
            this._url = URLFactory.newURL((URL)dirURL, (String)this.getFileName());
        }
        return this._url;
    }

    @Override
    protected String getContentSetKey() {
        return PathsConfiguration.JAVA_CONTENT_SET_KEY;
    }

    @Override
    protected URLPath getSourcePath() {
        return PathsConfiguration.getInstance((Project)this.getProject()).getProjectSourcePath();
    }

    @Override
    public final void setRelativeDirectory(String newDir) {
        int idx;
        if (newDir != null && (idx = newDir.indexOf(46)) >= 0) {
            newDir = (idx = newDir.lastIndexOf(47, idx)) >= 0 ? newDir.substring(0, idx) : "";
        }
        super.setRelativeDirectory(newDir);
    }

    @Override
    public URL getDirectory() {
        return this._getDirectory(false);
    }

    private URL _getDirectory(boolean fastDefault) {
        if (fastDefault) {
            return super.getDirectory();
        }
        String dirString = super.getDirectoryString();
        if (dirString.length() == 0 || this.getProject() == null) {
            return super.getBaseURL();
        }
        if (this.pcURLForPackage == null) {
            Context context = new Context(null, super.getProject());
            this.pcURLForPackage = PathsConfiguration.getURLForPackage((String)dirString, (Context)context);
            if (this.pcURLForPackage == null) {
                this.pcURLForPackage = super.getDirectory();
            }
        }
        return this.pcURLForPackage;
    }

    @Override
    public Node createNode() {
        URL packageURL;
        URL parentOfPackageURL = this.getDirectory();
        if (!URLFileSystem.exists((URL)parentOfPackageURL) && !URLFileSystem.mkdirs((URL)parentOfPackageURL)) {
            return null;
        }
        if (this.getFileName().contains(".")) {
            this.setFileName(this.getFileName().replace('.', File.separatorChar));
            String[] folderTokens = Pattern.compile(File.separator, 16).split(this.getFileName());
            ArrayList<String> pathToFolder = new ArrayList<String>(Arrays.asList(folderTokens));
            FolderUtils.createPath(parentOfPackageURL, pathToFolder.subList(0, folderTokens.length - 1));
        }
        if (URLFileSystem.mkdir((URL)(packageURL = URLFactory.newDirURL((String)this.getURL().getPath()))) || URLFileSystem.exists((URL)packageURL) && URLFileSystem.delete((URL)packageURL) && URLFileSystem.mkdir((URL)this.getURL())) {
            int result = JavaProject.getInstance(this.getProject()).addToProjectSourcePath(parentOfPackageURL, false);
            if (result == 2 || result == 3) {
                return null;
            }
            URL packageInfoURL = URLFactory.newURL((URL)packageURL, (String)"package-info.java");
            this.setURL(packageInfoURL);
            return super.createNode();
        }
        return null;
    }
}

