/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import oracle.javatools.util.CamelCaseFilter;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.filter.PatternMatchNameFilter;

class ClassPackageNamePrefixFilter
implements ClassNameFilter,
PackageNameFilter {
    private String _matchCriteria;
    private CamelCaseFilter _camelFilter;
    private PatternMatchNameFilter _patternFilter;
    private int _dotPos;

    public ClassPackageNamePrefixFilter() {
        this("");
    }

    public ClassPackageNamePrefixFilter(String matchName) {
        this.setMatchName(matchName);
    }

    public void setMatchName(String matchCriteria) {
        if (matchCriteria == null) {
            throw new IllegalArgumentException("matchCriteria cannot be null.");
        }
        this._matchCriteria = matchCriteria;
        this._dotPos = matchCriteria.lastIndexOf(46);
        if (this.hasDot()) {
            String classPart = matchCriteria.substring(this._dotPos + 1);
            this._camelFilter = new CamelCaseFilter(classPart);
        } else {
            this._camelFilter = new CamelCaseFilter(matchCriteria);
        }
        this._patternFilter = new PatternMatchNameFilter(false);
        this._patternFilter.setMatchName(matchCriteria);
    }

    public boolean acceptPackageName(String packageName) {
        String prefixText = this._matchCriteria;
        int prefixLen = prefixText.length();
        if (this.hasDot()) {
            return packageName.regionMatches(true, 0, prefixText, 0, prefixLen);
        }
        if (packageName.indexOf(46) != -1) {
            return false;
        }
        return packageName.regionMatches(true, 0, prefixText, 0, prefixLen);
    }

    public boolean acceptClassName(String className, String packagePrefix) {
        String prefixText = this._matchCriteria;
        if (this.hasDot()) {
            if (packagePrefix.equals(prefixText)) {
                return true;
            }
            String packagePart = prefixText.substring(0, this._dotPos);
            if (packagePrefix.equals(packagePart) && this._camelFilter.matches(className)) {
                return true;
            }
        } else if (this._camelFilter.matches(className)) {
            return true;
        }
        return this._patternFilter != null && this._patternFilter.acceptClassName(className, packagePrefix);
    }

    private boolean hasDot() {
        return this._dotPos != -1;
    }
}

