/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.ClasspathPanel;
import oracle.jdeveloper.library.InternalLibraryList;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.model.ApplicationLibraries;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.resource.LibraryArb;

public class JProjectLibrariesPanel
extends ClasspathPanel {
    private static final String[] PROPERTYKEYS = new String[]{"jdkReference", "libraryReferences", "internalDefinitions", "exportedReferences"};
    private static URL defaultDirectory;
    private JProjectLibraries projectLibraries;
    private Project project;

    protected String getHelpTopicID() {
        return "f1_idecustlibclasspath_html";
    }

    protected URL getDefaultDirectory() {
        return defaultDirectory == null ? URLFileSystem.getParent((URL)this.project.getURL()) : defaultDirectory;
    }

    protected InternalLibraryList getLibraryList() {
        return this.projectLibraries.getProjectLibraryList();
    }

    protected InternalLibraryList newLibraryList() {
        return new JProjectLibraryList(HashStructure.newInstance());
    }

    protected List<JLibrary> getLibraries() {
        return Arrays.asList(this.projectLibraries.getLibraries());
    }

    protected void setLibraries(List<JLibrary> libraries) {
        this.projectLibraries.setLibraries(libraries.toArray(new JLibrary[libraries.size()]));
    }

    protected JDK getJDK() {
        return this.projectLibraries.getJDK();
    }

    protected void setJDK(JDK jdk) {
        this.projectLibraries.setJDK(jdk);
    }

    protected List<JLibrary> getExports() {
        return Arrays.asList(this.projectLibraries.getExports());
    }

    protected void setExports(List<JLibrary> exports) {
        this.projectLibraries.setExports(exports.toArray(new JLibrary[exports.size()]));
    }

    protected boolean canHaveExternalLibraries() {
        return true;
    }

    protected String getExternalLibrariesLabel() {
        return LibraryArb.getString((int)22);
    }

    protected Collection<JLibrary> getExternalLibraries() {
        Workspace workspace = Ide.getActiveWorkspace();
        if (workspace != null) {
            return ApplicationLibraries.getInstance((Workspace)workspace).getLibraryReferences();
        }
        return Collections.emptySet();
    }

    protected Collection<JLibrary> getExternalModulePathLibraries() {
        Workspace workspace = Ide.getActiveWorkspace();
        if (workspace != null) {
            return ApplicationLibraries.getInstance((Workspace)workspace).getModulePathLibraryReferences();
        }
        return Collections.emptySet();
    }

    protected ClasspathPanel.ExternalLibraryPosition getExternalLibraryPosition() {
        return this.projectLibraries.getOverrideApplicationLibraries() ? ClasspathPanel.ExternalLibraryPosition.BOTTOM : ClasspathPanel.ExternalLibraryPosition.TOP;
    }

    protected void setExternalLibraryPosition(ClasspathPanel.ExternalLibraryPosition position) {
        this.projectLibraries.setOverrideApplicationLibraries(position == ClasspathPanel.ExternalLibraryPosition.BOTTOM);
    }

    protected boolean showAsModuleColumn() {
        JDK jdk = this.getJDK();
        if (jdk != null) {
            return jdk.getJavaVersion().isAfter(new VersionNumber("9"), true);
        }
        return false;
    }

    protected List<JLibrary> getModulePathLibraries() {
        return Arrays.asList(this.projectLibraries.getModulePathLibraries());
    }

    protected void setModulePathLibraries(List<JLibrary> modulePathLibraries) {
        this.projectLibraries.setModulePathLibraries(modulePathLibraries.toArray(new JLibrary[modulePathLibraries.size()]));
    }

    public String getDataKey() {
        return "oracle.jdevimpl.config.JProjectLibraries";
    }

    public String[] getPropertyKeys() {
        return PROPERTYKEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (JProjectLibrariesPanel.isDefaultProject((Namespace)tc)) {
            this.setHelpID("f1_idedprojsetlibrariesdpp_html");
        }
        this.project = JProjectLibrariesPanel.getProject((Namespace)tc, (boolean)true);
        this.projectLibraries = JProjectLibrariesPanel.getJProjectLibraries(tc);
        super.onProjectPanelEntry(tc);
    }

    private static JProjectLibraries getJProjectLibraries(TraversableContext tc) {
        if (tc.getWizardCallbacks() != null) {
            return (JProjectLibraries)tc.find("oracle.jdevimpl.config.JProjectLibraries");
        }
        PropertyStorage propertyData = JProjectLibrariesPanel.getPropertyData((Namespace)tc);
        return JProjectLibraries.getInstance((PropertyStorage)propertyData);
    }
}

