/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTempFile;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaModule;
import oracle.javatools.parser.java.v2.model.JavaModuleExports;
import oracle.javatools.parser.java.v2.model.JavaModuleOpens;
import oracle.javatools.parser.java.v2.model.JavaModuleProvides;
import oracle.javatools.parser.java.v2.model.JavaModuleRequires;
import oracle.javatools.parser.java.v2.model.JavaModuleUses;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaNode;

public final class JavaClassNode
extends JavaNode {
    public static final String EXT = ".class";

    protected Reader createReader(URL url) {
        String classText = this.getDecompiledClass(url);
        return classText == null ? null : new StringReader(classText);
    }

    protected void saveImpl() {
    }

    public boolean isReadOnly() {
        return true;
    }

    private String getDecompiledClass(final URL url) {
        JavaManager javaManager;
        JavaFile javaFile;
        Project project;
        final String cmd = System.getProperty("jcncmd");
        if (cmd != null) {
            SwingWorker<String, String> swingWorker = new SwingWorker<String, String>(){

                @Override
                protected String doInBackground() {
                    try {
                        URLTempFile tempFile = new URLTempFile(url);
                        File file = tempFile.getFile();
                        if (file == null) {
                            return null;
                        }
                        Process process = Runtime.getRuntime().exec(cmd + " " + file.getAbsolutePath());
                        final BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        final StringBuilder buf = new StringBuilder();
                        Thread outputPump = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    String line;
                                    while ((line = br.readLine()) != null) {
                                        buf.append(line).append("\n");
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        };
                        outputPump.start();
                        int exitCode = process.waitFor();
                        outputPump.join();
                        if (exitCode == 0) {
                            return buf.toString();
                        }
                    }
                    catch (Throwable e) {
                        Logger.getAnonymousLogger().log(Level.SEVERE, "decompiling " + URLFileSystem.getPlatformPathName((URL)url) + " using \"" + cmd + "\"", e);
                    }
                    return null;
                }
            };
            try {
                swingWorker.execute();
                String result = (String)swingWorker.get(15L, TimeUnit.SECONDS);
                if (result != null) {
                    return result;
                }
            }
            catch (ExecutionException result) {
            }
            catch (TimeoutException result) {
            }
            catch (InterruptedException result) {
                // empty catch block
            }
        }
        if ((project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        if (project != null && (javaFile = (javaManager = JavaManager.getJavaManager(project)).getFile(url)) != null) {
            try {
                return JavaClassNode.emitFile(javaFile);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)("Reading class file of " + url.getPath()), (Throwable)ex);
            }
        }
        return null;
    }

    protected static String emitFile(JavaFile javaFile) {
        StringBuilder out = new StringBuilder(4096);
        JavaClassNode.emitComment(0, "", out);
        JavaClassNode.emitComment(0, "Oracle JDeveloper Stub Generated Source", out);
        JavaClassNode.emitComment(0, "", out);
        if (javaFile.getModule() != null) {
            JavaClassNode.emitModule(javaFile, out);
            return out.toString();
        }
        JavaClassNode.emitPackage(javaFile.getPackageName(), out);
        int importInsertionPoint = out.length();
        HashMap<String, Map<String, List<Integer>>> potentialImports = new HashMap<String, Map<String, List<Integer>>>();
        JavaClass javaClass = javaFile.getPrimaryClass();
        JavaClassNode.emitClass(javaClass, out, potentialImports);
        String javaFilePackageName = javaFile.getPackageName();
        if (!javaFilePackageName.isEmpty()) {
            HashSet<String> finalImports = new HashSet<String>();
            String javaLangPackageName = "java.lang";
            HashMap<Integer, Integer> spaceLocations = new HashMap<Integer, Integer>();
            StringBuilder spaces = new StringBuilder();
            block0: for (Map.Entry entry : potentialImports.entrySet()) {
                String shortName = (String)entry.getKey();
                Map packageNamesAndLocations = (Map)entry.getValue();
                List javaLangLocations = (List)packageNamesAndLocations.remove(javaLangPackageName);
                List packageNameLocations = (List)packageNamesAndLocations.remove(javaFilePackageName);
                if (javaLangLocations != null) {
                    JavaClassNode.shortenTypeNames(out, spaces, javaLangPackageName, javaLangLocations, spaceLocations);
                    continue;
                }
                if (packageNameLocations != null) {
                    JavaClassNode.shortenTypeNames(out, spaces, javaFilePackageName, packageNameLocations, spaceLocations);
                    continue;
                }
                if (shortName.equals(javaClass.getName())) continue;
                for (String packageName : packageNamesAndLocations.keySet()) {
                    String oneImport = packageName + "." + shortName;
                    if (!finalImports.add(oneImport)) continue;
                    List locations = (List)packageNamesAndLocations.get(packageName);
                    JavaClassNode.shortenTypeNames(out, spaces, packageName, locations, spaceLocations);
                    continue block0;
                }
            }
            ArrayList locations = new ArrayList(spaceLocations.keySet());
            Collections.sort(locations);
            for (int x = locations.size() - 1; x >= 0; --x) {
                int location = (Integer)locations.get(x);
                int size = (Integer)spaceLocations.get(location);
                out.replace(location, location + size, "");
            }
            ArrayList sortedImports = new ArrayList(finalImports);
            if (!sortedImports.isEmpty()) {
                Collections.sort(sortedImports);
                for (String oneImport : sortedImports) {
                    String line = "import " + oneImport + ";\n";
                    out.insert(importInsertionPoint, line);
                    importInsertionPoint += line.length();
                }
                out.insert(importInsertionPoint, "\n");
            }
        }
        return out.toString();
    }

    private static void shortenTypeNames(StringBuilder out, StringBuilder spaces, String packageName, List<Integer> nameLocations, Map<Integer, Integer> spaceLocations) {
        spaces.setLength(0);
        int len = packageName.length() + 1;
        for (int y = 0; y < len; ++y) {
            spaces.append(' ');
        }
        for (int x = nameLocations.size() - 1; x >= 0; --x) {
            int location = nameLocations.get(x);
            out.replace(location, location + len, spaces.toString());
            spaceLocations.put(location, len);
        }
    }

    private static void emitPackage(String packageName, StringBuilder out) {
        if (packageName != null && packageName.length() > 0) {
            out.append("package ");
            out.append(packageName);
            out.append(";");
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitEOL(out);
        }
    }

    private static void emitTypeAnnotations(JavaType javaType, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        Collection annotations = javaType.getTypeAnnotations();
        JavaClassNode.emitTypeAnnotations(annotations, out, potentialImports);
    }

    private static void emitTypeAnnotations(Collection<JavaAnnotation> annotations, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        char c = out.charAt(out.length() - 1);
        if (c != ' ' && c != '<' && c != '(' && c != '.') {
            out.append(' ');
        }
        Iterator<JavaAnnotation> iter = annotations.iterator();
        while (iter.hasNext()) {
            JavaClassNode.emitAnnotation(iter.next(), out, potentialImports);
            out.append(' ');
        }
    }

    private static void emitClass(JavaClass javaClass, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        Collection fields;
        Iterator fieldIter;
        boolean hasFields;
        String modifierText;
        Collection annotations = javaClass.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            JavaClassNode.emitAnnotations(annotations, out, 0, potentialImports);
        }
        if ((modifierText = JavaClassNode.getClassModifiers(javaClass)).length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpaces(1, out);
        }
        boolean isInterface = false;
        boolean isAnnotation = false;
        if (javaClass.isAnnotation()) {
            out.append("@interface");
            isAnnotation = true;
        } else if (javaClass.isInterface()) {
            out.append("interface");
            isInterface = true;
        } else if (javaClass.isEnum()) {
            out.append("enum");
        } else {
            out.append("class");
        }
        JavaClassNode.emitSpaces(1, out);
        String vmName = javaClass.getVMName().replace('\\', '/');
        int index = vmName.lastIndexOf(47);
        if (index >= 0) {
            vmName = vmName.substring(index + 1);
        }
        out.append(vmName);
        JavaClassNode.emitTypeParameters(javaClass.getTypeParameters(), out, potentialImports);
        JavaClassNode.emitEOL(out);
        if (!isAnnotation) {
            Collection unresolvedInterfaces;
            String rawName;
            UnresolvedType javaType = javaClass.getUnresolvedSuperclass();
            if (javaType != null && !"java.lang.Object".equals(rawName = javaType.getRawName())) {
                JavaClassNode.emitIndent(1, out);
                out.append("extends ");
                JavaClassNode.emitUnresolvedType(javaType, out, potentialImports);
                JavaClassNode.emitEOL(out);
            }
            if (!(unresolvedInterfaces = javaClass.getUnresolvedInterfaces()).isEmpty()) {
                String superTypesIndent;
                JavaClassNode.emitIndent(1, out);
                if (isInterface) {
                    out.append("extends ");
                    superTypesIndent = "        ";
                } else {
                    out.append("implements ");
                    superTypesIndent = "           ";
                }
                Iterator unresolvedIterator = unresolvedInterfaces.iterator();
                String comma = ",\n";
                boolean emitComma = false;
                while (unresolvedIterator.hasNext()) {
                    if (emitComma) {
                        out.append(comma);
                        JavaClassNode.emitIndent(1, out);
                        out.append(superTypesIndent);
                    } else {
                        emitComma = true;
                    }
                    UnresolvedType unresolvedType = (UnresolvedType)unresolvedIterator.next();
                    JavaClassNode.emitUnresolvedType(unresolvedType, out, potentialImports);
                }
                JavaClassNode.emitEOL(out);
            }
        }
        out.append("{");
        JavaClassNode.emitEOL(out);
        boolean addBlankLine = false;
        Collection constructors = javaClass.getDeclaredConstructors();
        boolean hasConstructors = false;
        for (JavaMethod constructor : constructors) {
            if (constructor.isSynthetic()) continue;
            hasConstructors = true;
            break;
        }
        if (hasConstructors) {
            Iterator constructorIter = constructors.iterator();
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Constructors", out);
            JavaClassNode.emitComment(1, "", out);
            boolean first = true;
            while (constructorIter.hasNext()) {
                JavaMethod constructor = (JavaMethod)constructorIter.next();
                if (constructor.isSynthetic()) continue;
                if (!first) {
                    JavaClassNode.emitEOL(out);
                }
                first = false;
                JavaClassNode.emitMethod(javaClass, constructor, out, potentialImports);
            }
            addBlankLine = true;
        }
        if (hasFields = (fieldIter = (fields = javaClass.getDeclaredFields()).iterator()).hasNext()) {
            if (addBlankLine) {
                JavaClassNode.emitEOL(out);
            }
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Fields", out);
            JavaClassNode.emitComment(1, "", out);
            boolean first = true;
            while (fieldIter.hasNext()) {
                if (!first) {
                    JavaClassNode.emitEOL(out);
                }
                first = false;
                JavaField field = (JavaField)fieldIter.next();
                JavaClassNode.emitField(field, out, potentialImports);
            }
            addBlankLine = true;
        }
        Collection methods = javaClass.getDeclaredMethods();
        boolean hasMethods = false;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            if (((JavaMethod)iter.next()).isSynthetic()) continue;
            hasMethods = true;
            break;
        }
        if (hasMethods) {
            if (addBlankLine) {
                JavaClassNode.emitEOL(out);
            }
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Methods", out);
            JavaClassNode.emitComment(1, "", out);
            boolean first = true;
            for (JavaMethod method : methods) {
                if (method.isSynthetic()) continue;
                if (!first) {
                    JavaClassNode.emitEOL(out);
                }
                first = false;
                JavaClassNode.emitMethod(javaClass, method, out, potentialImports);
            }
        }
        out.append("}");
        JavaClassNode.emitEOL(out);
    }

    private static void emitTypeParameters(Collection<JavaTypeVariable> typeParameters, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        if (!typeParameters.isEmpty()) {
            out.append('<');
            Iterator<JavaTypeVariable> typeParamIter = typeParameters.iterator();
            boolean emitComma = false;
            while (typeParamIter.hasNext()) {
                if (emitComma) {
                    out.append(", ");
                } else {
                    emitComma = true;
                }
                JavaClassNode.emitTypeVariable(typeParamIter.next(), out, potentialImports);
            }
            out.append('>');
        }
    }

    private static void emitTypeVariable(JavaTypeVariable typeVariable, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        JavaClassNode.emitTypeAnnotations((JavaType)typeVariable, out, potentialImports);
        out.append(typeVariable.getName());
        Collection unresolvedBounds = typeVariable.getUnresolvedBounds();
        if (!(unresolvedBounds.isEmpty() || unresolvedBounds.size() == 1 && "java.lang.Object".equals(((UnresolvedType)unresolvedBounds.iterator().next()).getRawName()))) {
            out.append(" extends ");
            boolean emitAtSign = false;
            Iterator iterator = unresolvedBounds.iterator();
            while (iterator.hasNext()) {
                if (emitAtSign) {
                    out.append(" & ");
                } else {
                    emitAtSign = true;
                }
                JavaClassNode.emitUnresolvedType((UnresolvedType)iterator.next(), out, potentialImports);
            }
        }
    }

    private static String addPotentialImport(String typeName, int location, Map<String, Map<String, List<Integer>>> potentialImports) {
        String rawName = typeName;
        int index = rawName.indexOf(60);
        if (index > 0) {
            rawName = rawName.substring(0, index);
        }
        if ((index = rawName.indexOf(91)) > 0) {
            rawName = rawName.substring(0, index);
        }
        if ((index = rawName.lastIndexOf(46)) > 0) {
            String packageName = rawName.substring(0, index);
            String shortName = rawName.substring(packageName.length() + 1);
            Map<String, List<Integer>> map = potentialImports.get(shortName);
            List<Integer> locations = null;
            if (map == null) {
                map = new HashMap<String, List<Integer>>();
                potentialImports.put(shortName, map);
            } else {
                locations = map.get(packageName);
            }
            if (locations == null) {
                locations = new ArrayList<Integer>();
                map.put(packageName, locations);
            }
            locations.add(location);
        }
        return typeName;
    }

    private static void emitField(JavaField javaField, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        Object constantValue;
        String modifierText;
        JavaClassNode.emitIndent(1, out);
        Collection annotations = javaField.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            JavaClassNode.emitAnnotations(annotations, out, 1, potentialImports);
        }
        if ((modifierText = JavaClassNode.getFieldModifiers(javaField)).length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpaces(1, out);
        }
        JavaClassNode.emitUnresolvedType(javaField.getUnresolvedType(), out, potentialImports);
        JavaClassNode.emitSpaces(1, out);
        out.append(javaField.getName());
        if (!javaField.isEnumConstant() && (constantValue = javaField.getConstantValue()) != null) {
            out.append(" = ");
            JavaClassNode.emitConstantValue(constantValue, out, potentialImports);
        }
        out.append(";");
        JavaClassNode.emitEOL(out);
    }

    private static void emitConstantValue(Object constantValue, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        boolean isArray = constantValue instanceof Object[];
        if (isArray) {
            out.append("{ ");
            Object[] constantValues = (Object[])constantValue;
            boolean emitComma = false;
            for (Object oneValue : constantValues) {
                if (emitComma) {
                    out.append(", ");
                } else {
                    emitComma = true;
                }
                JavaClassNode.emitConstantValue(oneValue, out, potentialImports);
            }
            out.append(" }");
        } else if (constantValue instanceof String) {
            out.append("\"");
            out.append(constantValue.toString().replace("\\", "\\\\"));
            out.append("\"");
        } else if (constantValue instanceof JavaType) {
            UnresolvedType javaType = ((JavaType)constantValue).getUnresolvedType();
            JavaClassNode.emitUnresolvedType(javaType, out, potentialImports);
            out.append(EXT);
        } else if (constantValue instanceof JavaField) {
            JavaField field = (JavaField)constantValue;
            JavaClass owner = field.getOwningClass();
            if (owner != null) {
                out.append(JavaClassNode.addPotentialImport(owner.getRawName(), out.length(), potentialImports));
                out.append('.');
            } else {
                UnresolvedType unresolvedType = field.getUnresolvedType();
                if (unresolvedType != null && !unresolvedType.toString().isEmpty()) {
                    JavaClassNode.emitUnresolvedType(unresolvedType, out, potentialImports);
                    out.append('.');
                }
            }
            out.append(field.getName());
        } else if (constantValue instanceof Character) {
            out.append('\'');
            out.append(constantValue.toString().replace("\\", "\\\\"));
            out.append('\'');
        } else if (constantValue instanceof Float) {
            out.append(constantValue.toString());
            out.append('f');
        } else if (constantValue instanceof Long) {
            out.append(constantValue.toString());
            out.append('L');
        } else if (constantValue != null) {
            out.append(constantValue.toString());
        } else {
            out.append("<null>");
        }
    }

    private static void emitMethod(JavaClass javaClass, JavaMethod javaMethod, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        boolean isConstructor;
        String modifierText;
        JavaClassNode.emitIndent(1, out);
        Collection annotations = javaMethod.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            JavaClassNode.emitAnnotations(annotations, out, 1, potentialImports);
        }
        String string = modifierText = (isConstructor = javaMethod.isConstructor()) ? JavaClassNode.getConstructorModifiers(javaMethod) : JavaClassNode.getMethodModifiers(javaMethod);
        if (modifierText.length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpaces(1, out);
        }
        if (javaMethod.getTypeParameters().size() > 0) {
            JavaClassNode.emitTypeParameters(javaMethod.getTypeParameters(), out, potentialImports);
            JavaClassNode.emitSpaces(1, out);
        }
        if (isConstructor) {
            out.append(javaClass.isAnonymousClass() ? "<init>" : javaClass.getName());
        } else {
            UnresolvedType returnType = javaMethod.getUnresolvedType();
            if (returnType != null) {
                JavaClassNode.emitUnresolvedType(returnType, out, potentialImports);
                JavaClassNode.emitSpaces(1, out);
            }
            out.append(javaMethod.getName());
        }
        JavaClassNode.emitMethodParameters(javaClass, javaMethod, out, potentialImports);
        if (javaClass.isAnnotation()) {
            Object defaultValue = javaMethod.getDefaultValue();
            if (defaultValue != null) {
                JavaClassNode.emitSpaces(1, out);
                out.append("default");
                JavaClassNode.emitSpaces(1, out);
                JavaClassNode.emitAnnotationComponentValue(out, defaultValue, potentialImports);
            }
            out.append(";");
        } else if (!javaMethod.isAbstract()) {
            JavaClassNode.emitSpaces(1, out);
            out.append("{ }");
        } else {
            out.append(";");
        }
        JavaClassNode.emitEOL(out);
    }

    private static void emitMethodParameters(JavaClass javaClass, JavaMethod javaMethod, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        out.append("(");
        String comma = "";
        Collection receiverAnnotations = javaMethod.getReceiverTypeAnnotations();
        if (receiverAnnotations.size() > 0) {
            Iterator iter = receiverAnnotations.iterator();
            while (iter.hasNext()) {
                JavaClassNode.emitAnnotation((JavaAnnotation)iter.next(), out, potentialImports);
                out.append(' ');
            }
            out.append(javaClass.getName());
            out.append(" this");
            comma = ", ";
        }
        boolean methodIsVarArgs = (javaMethod.getModifiers() & 0x80) != 0;
        Collection parameters = javaMethod.getParameters();
        if (parameters != null) {
            int index = 1;
            for (JavaVariable parameter : parameters) {
                out.append(comma);
                comma = ", ";
                UnresolvedType type = parameter.getUnresolvedType();
                boolean gotVarArgsArray = false;
                if (methodIsVarArgs && index == parameters.size() && type.getArrayDimensions() > 0) {
                    type = type.getComponentType();
                    gotVarArgsArray = true;
                }
                JavaClassNode.emitUnresolvedType(type, out, potentialImports);
                if (gotVarArgsArray) {
                    out.append("...");
                }
                JavaClassNode.emitSpaces(1, out);
                String parameterName = parameter.getName();
                if (parameterName != null && parameterName.length() > 0) {
                    out.append(parameterName);
                    continue;
                }
                out.append("p").append(index++);
            }
        }
        out.append(")");
    }

    private static String getFieldModifiers(JavaField javaField) {
        int modifiers = javaField.getModifiers();
        return Modifier.toString(modifiers);
    }

    private static String getMethodModifiers(JavaMethod javaMethod) {
        JavaClass javaClass = javaMethod.getOwningClass();
        boolean isInterfaceMethod = javaClass.isInterface();
        int modifiers = javaMethod.getModifiers();
        if (isInterfaceMethod) {
            modifiers &= 0xFFFFFBFE;
        }
        return Modifier.toString(modifiers &= 0xFFFFFF7F);
    }

    private static String getConstructorModifiers(JavaMethod javaMethod) {
        StringBuilder out = new StringBuilder(30);
        int modifiers = javaMethod.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            out.append("public ");
        }
        if (Modifier.isPrivate(modifiers)) {
            out.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            out.append("protected ");
        }
        if (Modifier.isAbstract(modifiers)) {
            out.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            out.append("final ");
        }
        return out.toString().trim();
    }

    private static String getClassModifiers(JavaClass javaClass) {
        StringBuilder out = new StringBuilder(30);
        int modifiers = javaClass.getModifiers();
        boolean isInterface = javaClass.isInterface();
        if (Modifier.isPublic(modifiers)) {
            out.append("public ");
        }
        if (Modifier.isPrivate(modifiers)) {
            out.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            out.append("protected ");
        }
        if (!isInterface && Modifier.isAbstract(modifiers)) {
            out.append("abstract ");
        }
        if (Modifier.isStatic(modifiers)) {
            out.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            out.append("final ");
        }
        if (Modifier.isNative(modifiers)) {
            out.append("native ");
        }
        return out.toString().trim();
    }

    private static void emitEOL(StringBuilder out) {
        out.append("\n");
    }

    private static void emitSpaces(int count, StringBuilder out) {
        for (int i = 0; i < count; ++i) {
            out.append(' ');
        }
    }

    private static void emitIndent(int level, StringBuilder out) {
        for (int i = 0; i < level; ++i) {
            out.append("    ");
        }
    }

    private static void emitComment(int level, String comment, StringBuilder out) {
        JavaClassNode.emitIndent(level, out);
        out.append("//");
        if (comment != null && comment.length() > 0) {
            out.append(' ');
            out.append(comment);
        }
        JavaClassNode.emitEOL(out);
    }

    private static void emitAnnotations(Collection annotations, StringBuilder out, int indentLevel, Map<String, Map<String, List<Integer>>> potentialImports) {
        for (Object element : annotations) {
            if (!(element instanceof JavaAnnotation)) continue;
            JavaClassNode.emitAnnotation((JavaAnnotation)element, out, potentialImports);
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitIndent(indentLevel, out);
        }
    }

    private static void emitAnnotation(JavaAnnotation annotation, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        UnresolvedType annotationType = annotation.getUnresolvedType();
        out.append("@");
        JavaClassNode.emitUnresolvedType(annotationType, out, potentialImports);
        Map arguments = annotation.getUnresolvedArguments();
        if (arguments != null && arguments.size() > 0) {
            out.append("(");
            int indent = 8;
            Iterator j = arguments.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                Object value = arguments.get(key);
                if (value == null) continue;
                if (!key.equals("value") || arguments.size() != 1) {
                    out.append(key);
                    JavaClassNode.emitSpaces(1, out);
                    out.append("=");
                    JavaClassNode.emitSpaces(1, out);
                }
                JavaClassNode.emitAnnotationComponentValue(out, value, potentialImports);
                if (!j.hasNext()) continue;
                out.append(",");
                JavaClassNode.emitEOL(out);
                JavaClassNode.emitSpaces(indent, out);
            }
            out.append(")");
        }
    }

    private static void emitAnnotationComponentValue(StringBuilder out, Object value, Map<String, Map<String, List<Integer>>> potentialImports) {
        if (value instanceof String) {
            out.append("\"" + value.toString() + "\"");
            return;
        }
        if (value instanceof Object[]) {
            out.append("{");
            Object[] values = (Object[])value;
            for (int x = 0; x < values.length; ++x) {
                if (x > 0) {
                    out.append(", ");
                }
                JavaClassNode.emitAnnotationComponentValue(out, values[x], potentialImports);
            }
            out.append("}");
            return;
        }
        if (value instanceof JavaAnnotation) {
            JavaClassNode.emitAnnotation((JavaAnnotation)value, out, potentialImports);
            return;
        }
        if (value instanceof JavaField) {
            JavaField fieldObject = (JavaField)value;
            UnresolvedType unresolvedType = fieldObject.getUnresolvedType();
            if (unresolvedType != null && !unresolvedType.toString().isEmpty()) {
                JavaClassNode.emitUnresolvedType(unresolvedType, out, potentialImports);
                out.append('.');
            }
            out.append(fieldObject.getName());
            return;
        }
        if (value instanceof JavaHasType) {
            JavaHasType javaHasType = (JavaHasType)value;
            UnresolvedType unresolvedType = javaHasType.getUnresolvedType();
            if (unresolvedType != null) {
                out.append(JavaClassNode.addPotentialImport(unresolvedType.getSimplifiedName(), out.length(), potentialImports) + EXT);
                return;
            }
        } else if (value instanceof JavaHasName) {
            out.append(((JavaHasName)value).getName());
            return;
        }
        if (value != null) {
            out.append(value.toString());
        }
    }

    private static void emitUnresolvedType(UnresolvedType type, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        UnresolvedType qualifyingType;
        JavaClassNode.emitTypeAnnotations(type.getBoundTypeAnnotations(), out, potentialImports);
        int bound = type.getBound();
        if (bound == 1) {
            out.append("? extends ");
        } else if (bound == 2) {
            out.append("? super ");
        }
        ArrayList<UnresolvedType> qualifyingTypes = new ArrayList<UnresolvedType>();
        for (qualifyingType = type.getBaseComponentType() != null ? type.getBaseComponentType() : type; qualifyingType != null; qualifyingType = qualifyingType.getQualifyingType()) {
            qualifyingTypes.add(0, qualifyingType);
        }
        boolean emitDot = false;
        for (int x = 0; x < qualifyingTypes.size(); ++x) {
            if (emitDot) {
                out.append(".");
            } else {
                emitDot = true;
            }
            qualifyingType = (UnresolvedType)qualifyingTypes.get(x);
            JavaClassNode.emitTypeAnnotations(qualifyingType.getTypeAnnotations(), out, potentialImports);
            if (x == 0) {
                out.append(JavaClassNode.addPotentialImport(qualifyingType.getRawName(), out.length(), potentialImports));
            } else {
                String name = qualifyingType.getSimplifiedName();
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(index + 1);
                }
                out.append(name);
            }
            JavaClassNode.emitTypeArguments(type.getTypeArguments(), out, potentialImports);
        }
        while (type != null && type.getComponentType() != null) {
            JavaClassNode.emitTypeAnnotations(type.getTypeAnnotations(), out, potentialImports);
            out.append("[]");
            type = type.getComponentType();
        }
    }

    private static void emitTypeArguments(Collection<UnresolvedType> typeArgs, StringBuilder out, Map<String, Map<String, List<Integer>>> potentialImports) {
        if (!typeArgs.isEmpty()) {
            out.append('<');
            boolean addComma = false;
            for (UnresolvedType typeArg : typeArgs) {
                if (addComma) {
                    out.append(", ");
                } else {
                    addComma = true;
                }
                JavaClassNode.emitUnresolvedType(typeArg, out, potentialImports);
            }
            out.append('>');
        }
    }

    private static void emitModule(JavaFile javaFile, StringBuilder out) {
        Collection uses;
        Collection requires;
        Collection provides;
        Collection opens;
        Collection exports;
        JavaModule javaModule = javaFile.getModule();
        if (javaModule.isOpen()) {
            out.append("open");
            JavaClassNode.emitSpaces(1, out);
        }
        out.append("module");
        JavaClassNode.emitSpaces(1, out);
        out.append(javaModule.getName());
        JavaClassNode.emitSpaces(1, out);
        out.append("{");
        JavaClassNode.emitEOL(out);
        String version = javaModule.getVersion();
        if (version != null && !version.isEmpty()) {
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Version", out);
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitIndent(1, out);
            out.append("Version:");
            JavaClassNode.emitSpaces(1, out);
            out.append(version);
            JavaClassNode.emitEOL(out);
        }
        if ((exports = javaModule.getExports()) != null && exports.size() > 0) {
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Exports", out);
            JavaClassNode.emitComment(1, "", out);
            for (JavaModuleExports export : exports) {
                JavaClassNode.emitIndent(1, out);
                out.append("Exports:");
                JavaClassNode.emitSpaces(1, out);
                out.append(export.getPackageName());
                Collection moduleNames = export.getModuleNames();
                if (moduleNames != null && moduleNames.size() > 0) {
                    JavaClassNode.emitSpaces(1, out);
                    out.append("exported to");
                    JavaClassNode.emitSpaces(1, out);
                    boolean emitComma = false;
                    for (Object moduleName : moduleNames) {
                        if (emitComma) {
                            out.append(",");
                            JavaClassNode.emitSpaces(1, out);
                        } else {
                            emitComma = true;
                        }
                        out.append((String)moduleName);
                    }
                }
                JavaClassNode.emitEOL(out);
            }
        }
        if ((opens = javaModule.getOpens()) != null && opens.size() > 0) {
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Opens", out);
            JavaClassNode.emitComment(1, "", out);
            for (JavaModuleOpens open : opens) {
                JavaClassNode.emitIndent(1, out);
                out.append("Opens:");
                JavaClassNode.emitSpaces(1, out);
                out.append(open.getPackageName());
                Collection moduleNames = open.getModuleNames();
                if (moduleNames != null && moduleNames.size() > 0) {
                    JavaClassNode.emitSpaces(1, out);
                    out.append("opened to");
                    JavaClassNode.emitSpaces(1, out);
                    boolean emitComma = false;
                    for (String moduleName : moduleNames) {
                        if (emitComma) {
                            out.append(",");
                            JavaClassNode.emitSpaces(1, out);
                        } else {
                            emitComma = true;
                        }
                        out.append(moduleName);
                    }
                }
                JavaClassNode.emitEOL(out);
            }
        }
        if ((provides = javaModule.getProvides()) != null && provides.size() > 0) {
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Provides", out);
            JavaClassNode.emitComment(1, "", out);
            for (JavaModuleProvides provide : provides) {
                JavaClassNode.emitIndent(1, out);
                out.append("Provides:");
                JavaClassNode.emitSpaces(1, out);
                out.append(provide.getServiceInterface());
                Collection implementations = provide.getServiceImplementations();
                if (implementations != null && implementations.size() > 0) {
                    JavaClassNode.emitSpaces(1, out);
                    out.append("provided with");
                    JavaClassNode.emitSpaces(1, out);
                    boolean emitComma = false;
                    for (String implementation : implementations) {
                        if (emitComma) {
                            out.append(",");
                            JavaClassNode.emitSpaces(1, out);
                        } else {
                            emitComma = true;
                        }
                        out.append(implementation);
                    }
                }
                JavaClassNode.emitEOL(out);
            }
        }
        if ((requires = javaModule.getRequires()) != null && requires.size() > 0) {
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Requires", out);
            JavaClassNode.emitComment(1, "", out);
            for (JavaModuleRequires require : requires) {
                JavaClassNode.emitIndent(1, out);
                out.append("Requires:");
                JavaClassNode.emitSpaces(1, out);
                if (require.isStaticPhase()) {
                    out.append("static");
                    JavaClassNode.emitSpaces(1, out);
                }
                if (require.isTransitive()) {
                    out.append("transitive");
                    JavaClassNode.emitSpaces(1, out);
                }
                out.append(require.getModuleName());
                JavaClassNode.emitEOL(out);
            }
        }
        if ((uses = javaModule.getUses()) != null && uses.size() > 0) {
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Uses", out);
            JavaClassNode.emitComment(1, "", out);
            for (JavaModuleUses use : uses) {
                JavaClassNode.emitIndent(1, out);
                out.append("Uses:");
                JavaClassNode.emitSpaces(1, out);
                out.append(use.getServiceInterface());
                JavaClassNode.emitEOL(out);
            }
        }
        out.append("}");
        JavaClassNode.emitEOL(out);
    }
}

