/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.io.IOException;
import java.net.URL;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.PackagedSourceNode;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.model.JavaNode;

public final class JavaSourceNode
extends JavaNode
implements PackagedSourceNode {
    public static final String EXT = ".java";
    public static final String SQLJ_EXT = ".sqlj";
    public static final String defaultName = ModelArb.getString((int)7);

    public JavaSourceNode() {
        this.getAttributes().set(ElementAttributes.BUILDABLE | ElementAttributes.FINDABLE | ElementAttributes.MOVEABLE);
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
    }

    public boolean isSqlj() {
        return URLFileSystem.hasSuffix((URL)this.getURL(), (String)SQLJ_EXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPackage() {
        String pkg = "";
        TextBuffer txtBuf = this.acquireTextBuffer();
        if (txtBuf != null) {
            txtBuf.readLock();
            try {
                JavaLexer lexer = new JavaLexer();
                lexer.setTextBuffer((ReadTextBuffer)txtBuf);
                lexer.setPosition(0);
                lexer.setSkipComments(true);
                LexerToken lexTkn = lexer.createLexerToken();
                int tkn = lexer.lex(lexTkn);
                if (tkn == 125) {
                    FastStringBuffer buf = new FastStringBuffer();
                    boolean foundDot = false;
                    block7: while (true) {
                        switch (lexer.lex(lexTkn)) {
                            case 4: {
                                if (foundDot) {
                                    buf.append('.');
                                    foundDot = false;
                                }
                                int start = lexTkn.getStartOffset();
                                int len = lexTkn.getEndOffset() - start;
                                buf.append(txtBuf.getChars(start, len));
                                continue block7;
                            }
                            case 43: {
                                foundDot = true;
                                continue block7;
                            }
                        }
                        break;
                    }
                    pkg = buf.toString();
                }
            }
            finally {
                txtBuf.readUnlock();
                this.releaseTextBuffer();
            }
        }
        return pkg;
    }

    public String getPackage(Project project) {
        return this.getPackage();
    }

    public String getSourceFile() {
        return URLFileSystem.getFileName((URL)this.getURL());
    }
}

